/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.hdb_res;
import de.core.seeds.SEEDS_BendCut;
import de.core.seeds.SEEDS_SBHTPS;
import de.core.seeds.SEEDS_Tool;
import java.util.Vector;

public final class SEEDS_StageHTPM {
    private SEEDS_SBHTPS myBlockSolver = null;
    protected double[][] actSolutionArr = null;
    protected double[][] actLambdaArr = null;
    protected double[] actOpercost = null;
    private Vector[] apFCFvector = null;
    private double[] blockDur = null;
    protected double discRateFEFCF = 1.0;
    private hdb_res[] res2SetVini = null;
    private int stageIn = 0;
    private int hydroIn = 0;
    private SEEDS_StageHTPM ancestP = null;
    private SEEDS_StageHTPM[] descendPs = null;
    private static int bx;
    public static boolean initSolveMode;
    public static boolean initBWMode;
    public static double initBWMSimVini;
    public static boolean solveFromFlatSol;
    protected boolean solved = false;

    public SEEDS_StageHTPM(int pstageIn, int phydroIn, SEEDS_SBHTPS pBSolv, double[] pblockDur, double pdiscRateF) {
        this.stageIn = pstageIn;
        this.hydroIn = phydroIn;
        this.myBlockSolver = pBSolv;
        this.blockDur = pblockDur;
        this.discRateFEFCF = pdiscRateF;
        this.actSolutionArr = new double[this.blockDur.length][this.myBlockSolver.numvar];
        this.actLambdaArr = new double[this.blockDur.length][this.myBlockSolver.numres];
        this.actOpercost = new double[this.blockDur.length];
    }

    public void setStDependencies(SEEDS_StageHTPM pancestP, SEEDS_StageHTPM[] pdescendPs) {
        this.ancestP = pancestP;
        this.descendPs = pdescendPs;
        this.apFCFvector = new Vector[this.blockDur.length];
        for (int i = 0; i < this.blockDur.length - 1; ++i) {
            this.apFCFvector[i] = new Vector(10);
        }
    }

    public void setEFCF(Vector pvecEFCF) {
        this.apFCFvector[this.blockDur.length - 1] = pvecEFCF;
    }

    public SEEDS_BendCut getActBendCut() {
        return (SEEDS_BendCut)this.apFCFvector[0].lastElement();
    }

    void setRes2SetVini(hdb_res[] pres2init) {
        this.res2SetVini = pres2init;
    }

    public void solveForward() throws Exception {
        SEEDS_Tool.ids[1] = this.stageIn;
        SEEDS_Tool.ids[3] = this.hydroIn;
        this.solved = true;
        if (this.blockDur.length == 1 && this.descendPs == null) {
            this.solved = false;
            return;
        }
        if (this.ancestP != null) {
            SEEDS_StageHTPM.setViniFromAncEndSol(this.ancestP);
        }
        if (this.res2SetVini != null) {
            this.myBlockSolver.setViniFromObj(this.res2SetVini);
        }
        this.myBlockSolver.setDynParSt(this.stageIn);
        this.myBlockSolver.setHydroAffQ(this.stageIn, this.hydroIn);
        this.myBlockSolver.setBlockPLoad(this.stageIn, 0);
        if (SEEDS_Tool.isRat()) {
            this.myBlockSolver.setLoadLimits(this.stageIn, 0);
            this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, 0));
        }
        this.myBlockSolver.optimizeRORaff(this.blockDur);
        this.myBlockSolver.setHydroAffBlock(0);
        this.myBlockSolver.setBCsV(this.apFCFvector[0]);
        if (solveFromFlatSol) {
            this.myBlockSolver.clearSolution();
        } else {
            this.myBlockSolver.setPreviusSolution(this.actSolutionArr[0], this.actLambdaArr[0], this.actOpercost[0]);
        }
        SEEDS_Tool.ids[2] = 0;
        this.actOpercost[0] = this.blockDur.length == 1 ? this.myBlockSolver.reSolve(this.blockDur[0], this.discRateFEFCF) : this.myBlockSolver.reSolve(this.blockDur[0], 1.0);
        if (!this.myBlockSolver.solveOK) {
            this.solved = false;
        }
        for (bx = 1; bx < this.blockDur.length - 1; ++bx) {
            SEEDS_Tool.ids[2] = bx;
            this.myBlockSolver.doResStepForward();
            this.myBlockSolver.setBlockPLoad(this.stageIn, bx);
            if (SEEDS_Tool.isRat()) {
                this.myBlockSolver.setLoadLimits(this.stageIn, bx);
                this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, bx));
            }
            this.myBlockSolver.setHydroAffBlock(bx);
            this.myBlockSolver.setBCsV(this.apFCFvector[bx]);
            if (solveFromFlatSol) {
                this.myBlockSolver.clearSolution();
            } else {
                this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx], this.actLambdaArr[bx], this.actOpercost[bx]);
            }
            this.actOpercost[SEEDS_StageHTPM.bx] = this.myBlockSolver.reSolve(this.blockDur[bx], 1.0);
            if (this.myBlockSolver.solveOK) continue;
            this.solved = false;
        }
        if (this.descendPs != null && this.blockDur.length > 1) {
            SEEDS_Tool.ids[2] = bx = this.blockDur.length - 1;
            this.myBlockSolver.doResStepForward();
            this.myBlockSolver.setBlockPLoad(this.stageIn, bx);
            if (SEEDS_Tool.isRat()) {
                this.myBlockSolver.setLoadLimits(this.stageIn, bx);
                this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, bx));
            }
            this.myBlockSolver.setHydroAffBlock(bx);
            this.myBlockSolver.setBCsV(this.apFCFvector[bx]);
            if (solveFromFlatSol) {
                this.myBlockSolver.clearSolution();
            } else {
                this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx], this.actLambdaArr[bx], this.actOpercost[bx]);
            }
            this.actOpercost[SEEDS_StageHTPM.bx] = this.myBlockSolver.reSolve(this.blockDur[bx], this.discRateFEFCF);
            if (!this.myBlockSolver.solveOK) {
                this.solved = false;
            }
        }
    }

    public SEEDS_BendCut solveBackward() throws Exception {
        SEEDS_Tool.ids[1] = this.stageIn;
        SEEDS_Tool.ids[3] = this.hydroIn;
        this.solved = true;
        bx = this.blockDur.length - 1;
        if (bx == 0) {
            if (this.ancestP != null) {
                if (initSolveMode && initBWMode) {
                    this.myBlockSolver.setVini2values(initBWMSimVini, null);
                } else {
                    SEEDS_StageHTPM.setViniFromAncEndSol(this.ancestP);
                }
            } else {
                return null;
            }
            if (this.res2SetVini != null) {
                this.myBlockSolver.setViniFromObj(this.res2SetVini);
            }
        } else if (initSolveMode && initBWMode) {
            this.myBlockSolver.setVini2values(initBWMSimVini, null);
        } else {
            this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx - 1], null, 0.0);
            this.myBlockSolver.doResStepForward();
        }
        this.myBlockSolver.setDynParSt(this.stageIn);
        this.myBlockSolver.setHydroAffQ(this.stageIn, this.hydroIn);
        this.myBlockSolver.setBlockPLoad(this.stageIn, bx);
        if (SEEDS_Tool.isRat()) {
            this.myBlockSolver.setLoadLimits(this.stageIn, bx);
            this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, bx));
        }
        this.myBlockSolver.optimizeRORaff(this.blockDur);
        this.myBlockSolver.setHydroAffBlock(bx);
        this.myBlockSolver.setBCsV(this.apFCFvector[bx]);
        if (solveFromFlatSol) {
            this.myBlockSolver.clearSolution();
        } else {
            this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx], this.actLambdaArr[bx], this.actOpercost[bx]);
        }
        SEEDS_Tool.ids[2] = bx;
        this.actOpercost[SEEDS_StageHTPM.bx] = this.myBlockSolver.reSolve(this.blockDur[bx], this.discRateFEFCF);
        if (!this.myBlockSolver.solveOK) {
            this.solved = false;
        }
        --bx;
        while (bx > 0) {
            SEEDS_Tool.ids[2] = bx;
            this.apFCFvector[bx].add(this.myBlockSolver.getSolBendCut());
            if (initSolveMode && initBWMode) {
                this.myBlockSolver.setVini2values(initBWMSimVini, null);
            } else {
                this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx - 1], null, 0.0);
                this.myBlockSolver.doResStepForward();
            }
            this.myBlockSolver.setBlockPLoad(this.stageIn, bx);
            if (SEEDS_Tool.isRat()) {
                this.myBlockSolver.setLoadLimits(this.stageIn, bx);
                this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, bx));
            }
            this.myBlockSolver.setHydroAffBlock(bx);
            this.myBlockSolver.setBCsV(this.apFCFvector[bx]);
            if (solveFromFlatSol) {
                this.myBlockSolver.clearSolution();
            } else {
                this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx], this.actLambdaArr[bx], this.actOpercost[bx]);
            }
            this.actOpercost[SEEDS_StageHTPM.bx] = this.myBlockSolver.reSolve(this.blockDur[bx], 1.0);
            if (!this.myBlockSolver.solveOK) {
                this.solved = false;
            }
            --bx;
        }
        if (bx == 0) {
            SEEDS_Tool.ids[2] = bx;
            this.apFCFvector[bx].add(this.myBlockSolver.getSolBendCut());
            if (this.ancestP != null) {
                if (initSolveMode && initBWMode) {
                    this.myBlockSolver.setVini2values(initBWMSimVini, null);
                } else {
                    SEEDS_StageHTPM.setViniFromAncEndSol(this.ancestP);
                }
            }
            if (this.res2SetVini != null) {
                this.myBlockSolver.setViniFromObj(this.res2SetVini);
            }
            this.myBlockSolver.setBlockPLoad(this.stageIn, bx);
            if (SEEDS_Tool.isRat()) {
                this.myBlockSolver.setLoadLimits(this.stageIn, bx);
                this.myBlockSolver.setSigma(SEEDS_Tool.getSigma(this.stageIn, bx));
            }
            this.myBlockSolver.setHydroAffBlock(bx);
            this.myBlockSolver.setBCsV(this.apFCFvector[bx]);
            if (solveFromFlatSol) {
                this.myBlockSolver.clearSolution();
            } else {
                this.myBlockSolver.setPreviusSolution(this.actSolutionArr[bx], this.actLambdaArr[bx], this.actOpercost[bx]);
            }
            this.actOpercost[SEEDS_StageHTPM.bx] = this.myBlockSolver.reSolve(this.blockDur[bx], 1.0);
            if (!this.myBlockSolver.solveOK) {
                this.solved = false;
            }
        }
        return this.myBlockSolver.getSolBendCut();
    }

    public static void setViniFromAncEndSol(SEEDS_StageHTPM ancestor) {
        ancestor.myBlockSolver.setPreviusSolution(ancestor.actSolutionArr[ancestor.blockDur.length - 1], null, 0.0);
        ancestor.myBlockSolver.doResStepForward();
    }

    public double getFBSPOpC() {
        return this.actOpercost[0];
    }

    public double getEBSPOpC() {
        return this.actOpercost[this.blockDur.length - 1];
    }

    public double getFBSPFuC() {
        if (this.blockDur.length > 1) {
            return this.actSolutionArr[0][this.actSolutionArr[0].length - 1] * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
        }
        return this.actSolutionArr[0][this.actSolutionArr[0].length - 1] * this.discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
    }

    public double getStSPOpC() {
        double aux = 0.0;
        for (int ix = 0; ix < this.actOpercost.length; ++ix) {
            aux += this.actOpercost[ix] * SEEDS_SBHTPS.ponderar;
        }
        return aux;
    }

    public double getEBSPFuC() {
        return this.actSolutionArr[this.blockDur.length - 1][this.actSolutionArr[this.blockDur.length - 1].length - 1] * this.discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
    }

    protected double[][] get_Ope_Fc() {
        int ix;
        double[][] aux = new double[2][this.blockDur.length];
        for (ix = 0; ix < this.actOpercost.length; ++ix) {
            aux[0][ix] = this.actOpercost[ix] * SEEDS_SBHTPS.ponderar;
        }
        for (ix = 0; ix < this.actOpercost.length; ++ix) {
            aux[1][ix] = this.blockDur.length - 1 == ix ? this.actSolutionArr[ix][this.actSolutionArr[0].length - 1] * this.discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar : this.actSolutionArr[ix][this.actSolutionArr[0].length - 1] * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
        }
        return aux;
    }

    protected Vector[] getAllCuts() {
        return this.apFCFvector;
    }

    protected double[] getFinalOperCost() {
        double[] aux = new double[this.actOpercost.length];
        for (int k = 0; k < aux.length; ++k) {
            aux[k] = this.actOpercost[k] * SEEDS_SBHTPS.ponderar;
        }
        return aux;
    }

    protected double[][] getFinalDualCost() {
        double[][] aux = new double[this.actLambdaArr.length][this.actLambdaArr[0].length];
        for (int k1 = 0; k1 < aux.length; ++k1) {
            for (int k2 = 0; k2 < aux[0].length; ++k2) {
                aux[k1][k2] = this.actLambdaArr[k1][k2] * SEEDS_SBHTPS.ponderar;
            }
        }
        return aux;
    }

    static {
        initSolveMode = false;
        initBWMode = false;
        initBWMSimVini = 0.5;
        solveFromFlatSol = false;
    }
}

