/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.DeepEdit;
import de.core.Pin;
import de.core.Schematic;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.sql.DriverManager;

public class SEEDS_Shell {
    String[] args;
    private Byte n_MPmaxIte = 10;
    private Byte n_SPmaxIte = 5;
    private Byte n_SPcostTol = 50;
    private Byte n_MPcostTol = 100;
    private Byte n_isTree = 0;
    private Byte n_ShareCuts = 1;
    private Byte n_MP = 0;
    private Byte n_solver = 1;
    private Byte n_EFCF = 1;
    SEEDS_Tool tool = null;

    SEEDS_Shell(String[] a) throws Exception {
        this.args = a;
        this.inputManage();
        this.executeProccess();
    }

    private void inputManage() throws Exception {
        Byte n_DB = 1;
        Byte n_TxL = 1;
        Byte n_LossM = 1;
        System.out.println("");
        System.out.println("__________________");
        System.out.println("Starting - DeepEdit");
        System.out.println("");
        System.out.println("Reading input parameters ...");
        BufferedReader br = new BufferedReader(new FileReader(this.args[0]));
        String sDir = "";
        String s = "";
        while ((s = br.readLine()) != null) {
            String[] st = s.split(" ");
            if (st[0].equals("Folder:")) {
                sDir = st[1];
                sDir = "." + File.separator + "SeedsFiles" + File.separator + sDir + File.separator;
                System.out.println("Folder: " + sDir);
                continue;
            }
            if (st[0].equals("Database:")) {
                n_DB = Byte.parseByte(st[1].substring(0, 1));
                switch (n_DB) {
                    case 0: {
                        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                        s = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + sDir + "SeedsDB.mdb";
                        break;
                    }
                    case 1: {
                        Class.forName("org.sqlite.JDBC");
                        s = this.args.length > 2 ? "jdbc:sqlite:" + this.args[2] : "jdbc:sqlite:" + sDir + "SeedsDB.db";
                    }
                }
                System.out.println("Database: " + s);
                SEEDS_Frame.dbtrab = DriverManager.getConnection(s);
                SEEDS_Frame.dbtrab.setAutoCommit(false);
                continue;
            }
            if (st[0].equals("Solver:")) {
                this.n_solver = Byte.parseByte(st[1].substring(0, 1));
                switch (this.n_solver) {
                    case 2: {
                        s = "Minos_SQP";
                        break;
                    }
                    case 1: {
                        s = "CPLEX_SQP";
                        break;
                    }
                    case 0: {
                        s = "CPLEX";
                    }
                }
                System.out.println("Solver: " + s);
                continue;
            }
            if (st[0].equals("EndEFCF:")) {
                this.n_EFCF = Byte.parseByte(st[1].substring(0, 1));
                switch (this.n_EFCF) {
                    case 0: {
                        s = "User defined";
                        break;
                    }
                    case 1: {
                        s = "Fixed to zero";
                    }
                }
                System.out.println("EndEFCF: " + s);
                continue;
            }
            if (st[0].equals("TxLimits:")) {
                n_TxL = Byte.parseByte(st[1].substring(0, 1));
                switch (n_TxL) {
                    case 0: {
                        s = "Without";
                        break;
                    }
                    case 1: {
                        s = "Within";
                    }
                }
                System.out.println("TxLimits: " + s);
                continue;
            }
            if (st[0].equals("LossModel:")) {
                n_LossM = Byte.parseByte(st[1].substring(0, 1));
                switch (n_LossM) {
                    case 0: {
                        s = "Without";
                        break;
                    }
                    case 1: {
                        s = "ri2";
                    }
                }
                System.out.println("LossModel: " + s);
                continue;
            }
            if (st[0].equals("Tree_Seq:")) {
                this.n_isTree = Byte.parseByte(st[1].substring(0, 1));
                switch (this.n_isTree) {
                    case 0: {
                        s = "is Seq";
                        break;
                    }
                    case 1: {
                        s = "is Tree";
                    }
                }
                System.out.println("Tree_Seq: " + s);
                continue;
            }
            if (st[0].equals("MP_maxIte:")) {
                this.n_MPmaxIte = Byte.parseByte(st[1]);
                System.out.println("MP_maxIte: " + this.n_MPmaxIte);
                continue;
            }
            if (st[0].equals("MP_costTol:")) {
                this.n_MPcostTol = Byte.parseByte(st[1]);
                System.out.println("MP_costTol: " + this.n_MPcostTol);
                continue;
            }
            if (st[0].equals("SP_maxIte:")) {
                this.n_SPmaxIte = Byte.parseByte(st[1]);
                System.out.println("SP_maxIte: " + this.n_SPmaxIte);
                continue;
            }
            if (st[0].equals("SP_costTol:")) {
                this.n_SPcostTol = Byte.parseByte(st[1]);
                System.out.println("SP_costTol: " + this.n_SPcostTol);
                continue;
            }
            if (!st[0].equals("Share_Cuts:")) continue;
            this.n_ShareCuts = Byte.parseByte(st[1].substring(0, 1));
            switch (this.n_ShareCuts) {
                case 0: {
                    s = "false";
                    break;
                }
                case 1: {
                    s = "true";
                }
            }
            System.out.println("Share_Cuts: " + s);
        }
        try {
            this.n_MP = Byte.parseByte(this.args[1]);
            if (this.n_MP > 0) {
                this.tool.defOutFile("" + this.n_MP + "_");
            } else {
                this.n_MP = 0;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace(System.err);
            this.n_MP = 0;
        }
        SEEDS_Frame.loadDataPar();
        SEEDS_Frame.n_LossMode = n_LossM.byteValue();
        SEEDS_Frame.n_TxLim = n_TxL.byteValue();
        System.out.println("");
    }

    private void executeProccess() throws Exception {
        this.tool.makeScenFromDB();
        this.tool.toRun(1 + this.n_isTree, this.n_MP - 1, this.n_solver.byteValue(), (double)this.n_SPcostTol.byteValue() / 100.0, this.n_SPmaxIte.byteValue(), true, false, (double)this.n_MPcostTol.byteValue() / 100.0, this.n_MPmaxIte.byteValue(), this.n_ShareCuts == 1, false);
        SEEDS_Frame.dbtrab.rollback();
        SEEDS_Frame.dbtrab.close();
        System.out.println(" ");
        System.out.println("Finishing  DeepEdit");
        System.out.println("___________________");
    }

    public static void main(String[] aduket) {
        if (aduket.length > 0) {
            DeepEdit.isGUI = false;
            try {
                new SEEDS_Shell(aduket);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void UserWantsOpenSchematicbyShell(String dir, String file) throws Exception {
        DeepEdit.PinGrid = new Pin[2000][7000];
        Schematic MySchematic = new Schematic(DeepEdit.PinGrid, new FileInputStream(dir + file));
        MySchematic.FileName = file;
        MySchematic.FileDir = dir;
        MySchematic.updateload();
        MySchematic.CheckActive();
    }
}

