/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Injection;
import de.core.Line;
import de.core.Load;
import de.core.PLPFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.ndb_1pol;
import de.core.ndb_inj;
import de.core.seeds.SEEDS_BendCut;
import de.core.seeds.SEEDS_Exception;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Tool;
import de.core.seeds.SEEDS_Utils;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloRange;
import ilog.cplex.IloCplex;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class SEEDS_SBHTPS
extends AnalysisTool {
    double[][] MatG;
    double[][] MatX;
    int numbran = 0;
    int numtrafo = 0;
    int numgenT = 0;
    int numReserH = 0;
    int numSerieH = 0;
    int numReserG = 0;
    int numSerieG = 0;
    int numPasad = 0;
    int numIrr = 0;
    int numvarEl = 0;
    int numresEl = 0;
    int numvarHy = 0;
    int numresHy = 0;
    int numvar = 0;
    int numres = 0;
    boolean probIsSolved = false;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_Grad;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] nod_Pdem;
    double fcf = 0.0;
    double operCost = 0.0;
    double totCost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totincome = 0.0;
    double totsales = 0.0;
    int nmaxiter;
    double costTolerance;
    int metodo = 0;
    double[][] mat_W;
    double[][] mat_A;
    double[][] mat_Avar;
    PrintWriter myPPrintStream;
    private Injection[] injGen;
    private Line[] lines;
    private Trafo[] trafos;
    private Busbar[] busbars;
    private Load[] loads;
    private ndb_inj[] geners;
    private double dTb = 744.0;
    private double discRateFFCF = 1.0;
    private Vector vBC;
    private Generator[] thermalGen;
    private Generator[] resEleGen;
    private Generator[] serEleGen;
    private Generator[] ppEleGen;
    protected hdb_res[] resHydUnit;
    private hdb_ser[] serHydUnit;
    private hdb_paspur[] ppHydUnit;
    private hdb_irr[] irrHydUnit;
    private hdb_affl[][] ppaff;
    private hdb_affl[][] seraff;
    private hdb_affl[][] resaff;
    private hdb_affl[][] irraff;
    private hdb_affl[] allaff;
    private double[][] HCx;
    private double[] mDrE;
    private double[] mDrS;
    private double[] mDbvE;
    private double[] mDfE;
    private PrintWriter myPrintWriter;
    private FileOutputStream myOS;
    private double[] slopes = null;
    private double[] points = null;
    protected static double fEscBC = 1.0;
    private static double infTx = 1000000.0;
    protected static double ponderar = 1000000.0;
    private IloCplex cplex = null;
    private double[] auxArr = null;
    private int[] vec_clave = null;
    public static boolean just1 = false;
    protected boolean solveOK = false;
    private int sp_err = 0;
    private int sp_ok = 0;
    private int[] stVar = null;
    private String[][][] sNames = null;
    private String[] sVarNames = null;
    private boolean rationing = false;
    private double globalE = 0.0;
    private double sigma = 100.0;
    private double sref = 100.0;

    SEEDS_SBHTPS(Schematic sch, double duration, double pdiscFactFCF, boolean isRat) {
        super(sch);
        try {
            this.dTb = duration;
            this.discRateFFCF = pdiscFactFCF;
            this.sref = 1.0;
            this.initLSSchemObj();
            this.initNetwork();
            if (!isRat) {
                this.modelMalloc();
            } else {
                this.rationing = true;
                this.modelMalloc(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double reSolve(double duration, double df) throws Exception {
        this.discRateFFCF = df;
        this.dTb = duration;
        if (!this.rationing) {
            this.initProblemDef();
        } else {
            this.initProblemDef(true);
        }
        this.solveOK = this.metodo == 0 ? this.Solve_QCP_CPLEX() : (this.metodo == 1 ? (!this.rationing ? this.SolveQP_BY_CPLEX() : this.SolveQP_BY_CPLEX(true)) : this.SolveQP_BY_MINOS());
        return this.operCost;
    }

    public void solve() throws Exception {
        this.operCost = this.make_cost();
        this.solveOK = this.metodo == 0 ? this.Solve_QCP_CPLEX() : (this.metodo == 1 ? (!this.rationing ? this.SolveQP_BY_CPLEX() : this.SolveQP_BY_CPLEX(true)) : this.SolveQP_BY_MINOS());
    }

    private boolean Solve_QCP_CPLEX() throws Exception {
        try {
            IloRange[] row = null;
            row = new IloRange[this.numres + this.vBC.size()];
            IloNumVar[] var = this.makeOptSystem(row);
            this.cplex.setParam(IloCplex.IntParam.RootAlg, 2);
            if (this.cplex.solve()) {
                for (int j = 0; j < this.numvar; ++j) {
                    this.vec_xtempabs[j] = this.cplex.getValue(var[j]);
                }
                this.operCost = this.cplex.getObjValue() - this.vec_xtempabs[this.numvar - 1] * fEscBC * this.discRateFFCF;
                for (int i = 0; i < this.numres; ++i) {
                    if (row[i] == null) continue;
                    this.vec_lam[i] = this.cplex.getDual(row[i]);
                }
                this.cplex.clearModel();
                return true;
            }
            this.cplex.setParam(IloCplex.IntParam.BarAlg, 1);
            if (this.cplex.solve()) {
                for (int j = 0; j < this.numvar; ++j) {
                    this.vec_xtempabs[j] = this.cplex.getValue(var[j]);
                }
                this.operCost = this.cplex.getObjValue() - this.vec_xtempabs[this.numvar - 1] * fEscBC * this.discRateFFCF;
                for (int i = 0; i < this.numres; ++i) {
                    if (row[i] == null) continue;
                    this.vec_lam[i] = this.cplex.getDual(row[i]);
                }
                this.cplex.clearModel();
                return true;
            }
            System.out.println("Opt Res :" + this.cplex.getStatus());
            this.cplex.exportModel("non_qcplex" + this.sp_err++ + ".lp");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cplex.exportModel("errQCP_" + this.sp_err++ + ".lp");
            System.out.println("Solution status = " + this.cplex.getStatus());
            System.out.println("Solution value  = " + this.cplex.getObjValue());
            return false;
        }
    }

    private boolean SolveQP_BY_CPLEX() throws Exception {
        boolean konv = false;
        boolean solveAgain = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        int iteration = 0;
        int i = 0;
        int j = 0;
        SEEDS_BendCut tempBC = null;
        try {
            cost1 = this.operCost;
            this.operCost = -1.0;
            while (!konv) {
                int to;
                double[] coef;
                ++iteration;
                this.make_vec_Grad();
                this.make_mat_W();
                this.makeAdd_mat_Avar();
                this.update_vec_RHS();
                this.updateEl_vec_xlimits();
                IloCplex model = this.cplex;
                IloNumVar[] var = model.numVarArray(this.numvar, this.vec_xmin, this.vec_xmax, this.getVarNames());
                IloLinearNumExpr lin = model.scalProd(this.vec_Grad, var);
                IloNumExpr aux3 = model.constant(0);
                for (j = 0; j < this.numvarEl; ++j) {
                    for (i = 0; i < this.numvarEl; ++i) {
                        IloNumExpr aux2;
                        if (this.mat_W[i][j] == 0.0) continue;
                        if (i == j) {
                            aux2 = model.prod(this.mat_W[i][j] / 2.0, model.square(var[i]));
                            aux3 = model.sum(aux3, aux2);
                            continue;
                        }
                        IloNumExpr aux1 = model.prod(this.mat_W[i][j] / 2.0, (IloNumExpr)var[j]);
                        aux2 = model.prod(aux1, (IloNumExpr)var[i]);
                        aux3 = model.sum(aux3, aux2);
                    }
                }
                IloNumExpr obj = model.sum((IloNumExpr)lin, aux3);
                model.addMinimize(obj);
                IloRange[] res = new IloRange[this.numres + this.vBC.size()];
                for (i = 0; i < this.numnod; ++i) {
                    coef = this.mat_A[i];
                    res[i] = model.addLe(this.vec_RHS[i], (IloNumExpr)model.scalProd(coef, var), this.getSystemNames()[1][1][i]);
                }
                if (SEEDS_Frame.n_TxLim == 1) {
                    to = this.numnod + this.numbran;
                    while (i < to) {
                        coef = this.mat_A[i];
                        res[i] = model.addGe(this.vec_RHS[i], (IloNumExpr)model.scalProd(coef, var), this.getSystemNames()[1][1][i]);
                        coef = this.mat_A[i + this.numbran];
                        res[i + this.numbran] = model.addLe(this.vec_RHS[i + this.numbran], (IloNumExpr)model.scalProd(coef, var), this.getSystemNames()[1][1][i + this.numbran]);
                        ++i;
                    }
                    i += this.numbran;
                }
                to = this.numres;
                while (i < to) {
                    coef = this.mat_A[i];
                    res[i] = model.addEq(this.vec_RHS[i], (IloNumExpr)model.scalProd(coef, var), this.getSystemNames()[1][1][i]);
                    ++i;
                }
                int offVar = this.numvarEl + this.numvarHy - this.resHydUnit.length;
                for (int ix = 0; ix < this.vBC.size(); ++ix) {
                    tempBC = (SEEDS_BendCut)this.vBC.elementAt(ix);
                    for (int jx = 0; jx < this.resHydUnit.length; ++jx) {
                        this.auxArr[offVar + jx] = tempBC.mi[jx];
                    }
                    this.auxArr[offVar + jx] = 1.0 * fEscBC;
                    res[i] = model.addLe(tempBC.f0, (IloNumExpr)model.scalProd(this.auxArr, var, offVar, this.resHydUnit.length + 1), "Bender_Cut_" + (ix + 1));
                    ++i;
                }
                this.cplex.setParam(IloCplex.IntParam.RootAlg, 2);
                if (this.cplex.solve()) {
                    this.vec_xtemp = this.cplex.getValues(var);
                    for (i = 0; i < this.numres; ++i) {
                        this.vec_lam[i] = this.cplex.getDual(res[i]);
                    }
                    solveAgain = false;
                } else {
                    this.cplex.setParam(IloCplex.IntParam.BarAlg, 1);
                    if (solveAgain) {
                        this.cplex.exportModel("./ErrorProblemSeed[" + (SEEDS_Tool.ids[0] + 1) + "," + (SEEDS_Tool.ids[1] + 1) + "," + (SEEDS_Tool.ids[2] + 1) + "," + (SEEDS_Tool.ids[3] + 1) + "]_" + this.sp_err++ + ".lp");
                        return false;
                    }
                    solveAgain = true;
                    for (i = this.numvarEl; i < this.numvar; ++i) {
                        this.vec_xtemp[i] = 0.0;
                    }
                }
                this.cplex.clearModel();
                if (solveAgain) continue;
                for (i = 0; i < this.numvarEl; ++i) {
                    int n = i;
                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                }
                cost2 = this.make_cost();
                if (Math.abs(cost2 - cost1) <= this.costTolerance * (cost2 + cost1) / 100.0 || iteration == this.nmaxiter) {
                    this.operCost = cost2;
                    for (i = this.numvarEl; i < this.numvar; ++i) {
                        this.vec_xtempabs[i] = this.vec_xtemp[i];
                    }
                    konv = true;
                }
                cost1 = cost2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cplex.exportModel("./ErrorProblemSeed" + this.sp_err++ + "cExc.lp");
            System.out.println("Modelo con error escrito");
            System.err.println(" Concert exception caugth : " + e);
            System.out.println("Opt Res :" + this.cplex.getStatus());
        }
        return konv;
    }

    private boolean SolveQP_BY_MINOS() throws Exception {
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        int iteration = 0;
        int i = 0;
        int j = 0;
        try {
            cost1 = this.operCost;
            this.operCost = -1.0;
            while (!konv && iteration < this.nmaxiter) {
                SEEDS_BendCut tempBC;
                ++iteration;
                this.make_vec_Grad();
                this.makeAdd_mat_Avar();
                this.make_mat_W();
                this.updateEl_vec_xlimits();
                this.update_vec_RHS();
                FileOutputStream os = new FileOutputStream("./economic.dat");
                PrintWriter myPrintStream = new PrintWriter(os);
                myPrintStream.println(this.numvar);
                myPrintStream.println(" ");
                myPrintStream.println(this.numres + this.vBC.size());
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_Grad[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    myPrintStream.println(this.vec_RHS[i]);
                }
                for (i = 0; i < this.vBC.size(); ++i) {
                    tempBC = (SEEDS_BendCut)this.vBC.elementAt(i);
                    myPrintStream.println("" + tempBC.f0);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    for (j = 0; j < this.numvar; ++j) {
                        myPrintStream.println(this.mat_A[i][j]);
                    }
                    myPrintStream.println(" ");
                }
                int offVar = this.numvarEl + this.numvarHy - this.resHydUnit.length;
                for (i = 0; i < this.vBC.size(); ++i) {
                    tempBC = (SEEDS_BendCut)this.vBC.elementAt(i);
                    for (j = 0; j < offVar; ++j) {
                        myPrintStream.println("0.0");
                    }
                    for (j = 0; j < this.resHydUnit.length; ++j) {
                        myPrintStream.println("" + tempBC.mi[j]);
                    }
                    myPrintStream.println("" + fEscBC);
                    myPrintStream.println(" ");
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    myPrintStream.println(this.vec_clave[i]);
                }
                for (i = 0; i < this.vBC.size(); ++i) {
                    myPrintStream.println("3");
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_xmin[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_xmax[i]);
                }
                myPrintStream.println(" ");
                myPrintStream.println("min");
                myPrintStream.println("Ergebnisse aus SQP");
                myPrintStream.close();
                ((OutputStream)os).close();
                os = new FileOutputStream("./matw.dat");
                myPrintStream = new PrintWriter(os);
                myPrintStream.println(this.numvar);
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    for (j = 0; j < this.numvar; ++j) {
                        if (i < this.numvarEl && j < this.numvarEl) {
                            myPrintStream.println(this.mat_W[i][j]);
                            continue;
                        }
                        myPrintStream.println("0.0");
                    }
                    myPrintStream.println(" ");
                }
                myPrintStream.println(" ");
                myPrintStream.close();
                ((OutputStream)os).close();
                SEEDS_SBHTPS.Dorun("cmd /C " + DeepEdit.PathDOS + "cuadra.exe>sys.log", DeepEdit.PathUNIX + "cuadra > sys.log", false);
                FileInputStream is1 = new FileInputStream("./soluci.dat");
                BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                String ln = is.readLine();
                if (ln == null) {
                    throw new SEEDS_Exception("No MINOS Solution Found on soluci.dat");
                }
                j = this.numvar + this.numres;
                for (i = 0; (ln = is.readLine()) != null && i < j; ++i) {
                    if (i < this.numvar) {
                        this.vec_xtemp[i] = Double.parseDouble(ln);
                        continue;
                    }
                    this.vec_lam[i - this.numvar] = Double.parseDouble(ln);
                }
                is.close();
                for (i = 0; i < this.numvarEl; ++i) {
                    int n = i;
                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                }
                cost2 = this.make_cost();
                if (!(Math.abs(cost2 - cost1) <= this.costTolerance * (cost2 + cost1) / 100.0) && iteration != this.nmaxiter && SEEDS_Frame.n_LossMode != 0) continue;
                this.operCost = cost2;
                for (i = this.numvarEl; i < this.numvar; ++i) {
                    this.vec_xtempabs[i] = this.vec_xtemp[i];
                }
                konv = true;
            }
        }
        catch (Exception e) {
            this.message = e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "HTGLED", "Calculation Error: " + this.message, DlgButtons, 1, 0, 0, 1);
        }
        return konv;
    }

    public void showResults() {
        int ix;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof hdb_link)) continue;
            ((hdb_link)TempComponent).InformEndComponents();
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.resHydUnit[ix].Vfinm = 0.0;
            this.resHydUnit[ix].Vinim = 0.0;
        }
        try {
            for (ix = 0; ix < this.resHydUnit.length; ++ix) {
                this.resHydUnit[ix].Vinim = SEEDS_Tool.mydbm.evalVol2Cota(this.resHydUnit[ix].Vini, this.resHydUnit[ix].getName());
                this.resHydUnit[ix].Vfinm = SEEDS_Tool.mydbm.evalVol2Cota(this.resHydUnit[ix].Vfin, this.resHydUnit[ix].getName());
            }
        }
        catch (SEEDS_Exception e) {
            System.out.println(e);
        }
        this.ActSchematic.setfitnes(-100.0);
        this.ActSchematic.settotcost(100.0);
        this.ActSchematic.settotgen(100.0);
        this.ActSchematic.settotunser(0.0);
        this.ActSchematic.settotloss(0.0);
        this.ActSchematic.settotdem(100.0);
        this.ActSchematic.Modified = false;
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.changeGIS = true;
        PLPFrame.View = true;
        SEEDS_Frame.View = true;
    }

    private void initNetwork() throws Exception {
        Complex auxc2;
        Complex auxc1;
        int con2;
        int con1;
        int jx;
        int ix;
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.numnod = this.busbars.length;
        this.numlin = this.lines.length;
        this.numtran = this.trafos.length;
        this.numbran = this.numlin + this.numtran;
        this.numgen = this.geners.length;
        this.numgenT = this.thermalGen.length;
        this.numload = this.loads.length;
        this.numReserH = this.resHydUnit.length;
        this.numSerieH = this.serHydUnit.length;
        this.numReserG = this.resEleGen.length;
        this.numSerieG = this.serEleGen.length;
        this.numPasad = this.ppHydUnit.length;
        this.numIrr = this.irrHydUnit.length;
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        Complex[][] MatY = new Complex[this.numnod][this.numnod];
        for (ix = 0; ix < this.numnod; ++ix) {
            for (jx = 0; jx < this.numnod; ++jx) {
                MatY[ix][jx] = new Complex();
            }
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.numbus(this.lines[ix].getcon1());
            con2 = this.numbus(this.lines[ix].getcon2());
            if (con1 > -1 && con2 > -1) {
                if (Math.sqrt(this.lines[ix].getxx1() * this.lines[ix].getb1()) * this.lines[ix].getlen() > 0.1396) {
                    System.out.println("No approximations were considered while modeling line: " + this.lines[ix].getName());
                    double[] param = SEEDS_Utils.getExactLineParam(this.lines[ix].getr1(), this.lines[ix].getxx1(), this.lines[ix].getg1(), this.lines[ix].getb1(), this.lines[ix].getlen());
                    this.BranchR[ix] = param[0];
                    this.BranchX[ix] = param[1];
                    this.BranchB[ix] = param[3];
                } else {
                    this.BranchX[ix] = this.lines[ix].getxx1() * this.lines[ix].getlen();
                    this.BranchR[ix] = this.lines[ix].getr1() * this.lines[ix].getlen();
                    this.BranchB[ix] = this.lines[ix].getb1() * this.lines[ix].getlen() / 2.0;
                }
                this.BranchI[ix] = con1;
                this.BranchJ[ix] = con2;
                double Ybase = this.sref / (this.lines[ix].getun1() * this.lines[ix].getun1());
                this.BranchX[ix] = this.BranchX[ix] * Ybase;
                this.BranchR[ix] = this.BranchR[ix] * Ybase;
                this.BranchB[ix] = this.BranchB[ix] / Ybase;
                auxc1 = new Complex(this.BranchR[ix], this.BranchX[ix]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[ix]);
                MatY[this.BranchJ[ix]][this.BranchI[ix]].add(Complex.negate((Complex)auxc1));
                MatY[this.BranchI[ix]][this.BranchJ[ix]].add(Complex.negate((Complex)auxc1));
                MatY[this.BranchI[ix]][this.BranchI[ix]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                MatY[this.BranchJ[ix]][this.BranchJ[ix]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                continue;
            }
            System.out.println("Wrong Connected Line: " + this.lines[ix].getName());
        }
        int count = this.lines.length;
        for (ix = 0; ix < this.trafos.length; ++ix) {
            this.trafos[ix].actualizet();
            this.trafos[ix].sett_re_old(this.trafos[ix].gett_re());
            con1 = this.numbus(this.trafos[ix].getcon1());
            con2 = this.numbus(this.trafos[ix].getcon2());
            if (con1 > -1 && con2 > -1) {
                ueb = this.trafos[ix].getun1() / this.trafos[ix].getun2() / (this.trafos[ix].getur1() / this.trafos[ix].getur2());
                res = this.trafos[ix].getpcu() * 0.001 * ueb * ueb / this.trafos[ix].getsn() * this.sref / this.trafos[ix].getsn();
                z = this.trafos[ix].getuk() * 0.01 * ueb * ueb * this.sref / this.trafos[ix].getsn();
                b = this.trafos[ix].geti0() * 0.01 * 0.5 / this.sref * this.trafos[ix].getsn();
                reac = this.trafos[ix].getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                this.BranchX[count] = reac;
                this.BranchR[count] = res;
                this.BranchB[count] = b;
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)this.trafos[ix].gett_re())));
                MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)this.trafos[ix].gett_re())));
                MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(this.trafos[ix].gett_re() * this.trafos[ix].gett_re()));
                MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                ++count;
                continue;
            }
            System.out.println("Wrong Connected Trafo: " + this.trafos[ix].getName());
        }
        this.MatG = new double[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        double are = 0.0;
        double aim = 0.0;
        Complex aco = new Complex();
        if (SEEDS_Frame.n_LossMode != 0) {
            for (ix = 0; ix < this.numnod; ++ix) {
                for (jx = 0; jx < this.numnod; ++jx) {
                    if (Complex.abs((Complex)MatY[ix][jx]) > 1.0E-9 && ix != jx) {
                        aco = new Complex(1.0, 0.0);
                        aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)MatY[ix][jx]));
                        are = aco.re;
                        aim = aco.im;
                        this.MatG[ix][jx] = are / (are * are + aim * aim);
                        this.MatX[ix][jx] = aim;
                        continue;
                    }
                    this.MatG[ix][jx] = 0.0;
                    this.MatX[ix][jx] = 0.0;
                }
            }
        } else {
            for (ix = 0; ix < this.numnod; ++ix) {
                for (jx = 0; jx < this.numnod; ++jx) {
                    if (Complex.abs((Complex)MatY[ix][jx]) > 1.0E-9 && ix != jx) {
                        aco = new Complex(1.0, 0.0);
                        aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)MatY[ix][jx]));
                        this.MatX[ix][jx] = aim = aco.im;
                        continue;
                    }
                    this.MatX[ix][jx] = 0.0;
                }
            }
        }
    }

    private void modelMalloc() throws Exception {
        this.numvarEl = this.numload + this.numgen + this.numnod;
        this.numvarHy = 4 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        this.numresEl = this.numnod;
        if (SEEDS_Frame.n_TxLim == 1) {
            this.numresEl += 2 * this.numbran;
        }
        this.numresHy = this.resEleGen.length + this.serEleGen.length + 2 * this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        this.numvar = this.numvarEl + this.numvarHy + 1;
        this.numres = this.numresEl + this.numresHy;
        this.VarNode = new int[this.numvarEl];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_Grad = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvarEl];
        this.nod_Pdem = new double[this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvarEl][this.numvarEl];
        this.slopes = new double[this.resHydUnit.length];
        this.points = new double[this.resHydUnit.length];
    }

    private void initProblemDef() throws Exception {
        int ix;
        int countVar = 0;
        for (ix = 0; ix < this.numnod; ++ix) {
            this.nod_Pdem[ix] = 0.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.loads[ix].getp0() / this.sref;
            this.VarNode[ix] = this.numbus(this.loads[ix].getcon2());
            int n = this.VarNode[ix];
            this.nod_Pdem[n] = this.nod_Pdem[n] + this.loads[ix].getp0() / this.sref;
            ++countVar;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_xminabs[countVar] = this.geners[ix].getpmin() / this.sref;
            this.vec_xmaxabs[countVar] = this.geners[ix].getpmax() / this.sref;
            this.VarNode[countVar] = this.numbus(this.geners[ix].getcon2());
            ++countVar;
        }
        countVar = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.vec_xmaxabs[countVar] = Math.min(this.vec_xmaxabs[countVar], this.ppHydUnit[ix].getWat2PowRate() * this.sumQAffl(this.ppaff[ix]) * this.ppHydUnit[ix].getRegulBFact() / this.sref);
            if (this.vec_xmaxabs[countVar] < this.vec_xminabs[countVar]) {
                this.vec_xmaxabs[countVar] = 0.0;
                this.vec_xminabs[countVar] = 0.0;
            }
            ++countVar;
        }
        countVar += this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.vec_xminabs[countVar] = -3.14;
            this.vec_xmaxabs[countVar] = 3.14;
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.resHydUnit[ix].getTurbmax();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            this.vec_xminabs[countVar] = this.serHydUnit[ix].getTurbmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.serHydUnit[ix].getSpillmax();
            this.vec_xminabs[countVar] = this.serHydUnit[ix].getSpillmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.serHydUnit[ix].getSpillmin() + this.serHydUnit[ix].getTurbmin();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xminabs[countVar] = 0.0;
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.irrHydUnit[ix].getSpillmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0;
            ++countVar;
        }
        this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
        this.vec_xminabs[countVar] = 0.0;
        if (this.metodo != 0) {
            this.make_vec_c();
            this.make_DiagMat_Q();
            this.make_mat_Afix();
            this.make_vec_RHS();
            this.makeHyd_vec_xlimits();
        }
    }

    public void makeHyd_vec_xlimits() {
        for (int i = this.numvarEl; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i];
        }
    }

    public void updateEl_vec_xlimits() {
        for (int i = 0; i < this.numvarEl; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_c[ix] = this.loads[ix].getbeta() * this.dTb * this.sref / ponderar;
        }
        int countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_c[countVar] = this.geners[ix].getbeta() * this.dTb * this.sref / ponderar;
            ++countVar;
        }
        countVar = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.vec_c[countVar] = 1.0E-6;
            ++countVar;
        }
        countVar = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_c[countVar] = (SEEDS_Frame.n_IrrCost * this.dTb + 0.001) / ponderar;
            ++countVar;
        }
        countVar = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_c[countVar] = SEEDS_Frame.n_IrrCost * this.dTb / ponderar;
            ++countVar;
        }
        this.vec_c[countVar += this.resHydUnit.length] = this.discRateFFCF * fEscBC;
    }

    public void make_mat_Afix() throws Exception {
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        int jx = this.loads.length + this.geners.length;
        for (ix = this.loads.length; ix < jx; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        if (SEEDS_Frame.n_TxLim == 1) {
            double xij;
            int con2;
            int con1;
            for (ix = 0; ix < this.lines.length; ++ix) {
                con1 = this.BranchI[ix];
                con2 = this.BranchJ[ix];
                xij = this.BranchX[ix];
                this.mat_A[this.numnod + ix][this.numgen + this.numload + con1] = 1.0 / xij;
                this.mat_A[this.numnod + ix][this.numgen + this.numload + con2] = -1.0 / xij;
                this.mat_A[this.numnod + this.numbran + ix][this.numgen + this.numload + con1] = 1.0 / xij;
                this.mat_A[this.numnod + this.numbran + ix][this.numgen + this.numload + con2] = -1.0 / xij;
            }
            int countRes = this.lines.length;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                con1 = this.BranchI[countRes];
                con2 = this.BranchJ[countRes];
                xij = this.BranchX[countRes];
                this.mat_A[this.numnod + countRes][this.numgen + this.numload + con1] = 1.0 / xij;
                this.mat_A[this.numnod + countRes][this.numgen + this.numload + con2] = -1.0 / xij;
                this.mat_A[this.numnod + this.numbran + countRes][this.numgen + this.numload + con1] = 1.0 / xij;
                this.mat_A[this.numnod + this.numbran + countRes][this.numgen + this.numload + con2] = -1.0 / xij;
                ++countRes;
            }
        }
        this.makeHSubMatrix();
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        int offVar2 = this.numvarEl;
        int offRes = this.numresEl;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrE[ix];
        }
        offVar += this.resEleGen.length;
        offVar2 += this.resHydUnit.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrS[ix];
        }
        offVar = this.numvarEl;
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (jx = 0; jx < this.HCx[0].length; ++jx) {
                this.mat_A[offRes + ix][offVar + jx] = this.HCx[ix][jx];
            }
        }
        offVar += 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = this.mDbvE[ix];
        }
        offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = -this.mDfE[ix];
            this.mat_A[offRes + ix][offVar2 + ix] = 1.0;
        }
    }

    public void make_mat_W() {
        int nn = this.numnod;
        int off = this.numgen + this.numload;
        this.mat_W = new double[this.numvarEl][this.numvarEl];
        for (int i = 0; i < off; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        for (int k = 0; k < nn; ++k) {
            if (this.vec_lam[k] < -1000000.0) {
                System.out.println("Warning negative multiplier " + this.vec_lam[k] + " in restriction '" + k + "' or " + this.getSystemNames()[1][1][k]);
                continue;
            }
            if (this.vec_lam[k] < 0.0) continue;
            for (int j = 0; j < nn; ++j) {
                if (k == j || !(Math.abs(this.MatG[k][j]) > 1.0E-9)) continue;
                double[] dArray = this.mat_W[k + off];
                int n = k + off;
                dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray2 = this.mat_W[j + off];
                int n2 = j + off;
                dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray3 = this.mat_W[k + off];
                int n3 = j + off;
                dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[k][j];
                double[] dArray4 = this.mat_W[j + off];
                int n4 = k + off;
                dArray4[n4] = dArray4[n4] - this.vec_lam[k] * this.MatG[k][j];
            }
        }
    }

    public void make_DiagMat_Q() {
        int ix = 0;
        int countVar = 0;
        for (ix = 0; ix < this.numvarEl; ++ix) {
            this.DiagMat_Q[ix] = 0.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.DiagMat_Q[ix] = 2.0 * this.loads[ix].getgamma() * this.dTb * this.sref * this.sref / ponderar;
        }
        countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.DiagMat_Q[countVar] = 2.0 * this.geners[ix].getgamma() * this.dTb * this.sref * this.sref / ponderar;
            ++countVar;
        }
    }

    public void setPreviusSolution(double[] prevsol, double[] prevlambda, double prevOpCost) {
        this.vec_xtempabs = prevsol;
        this.vec_lam = prevlambda;
        this.operCost = prevOpCost;
    }

    public void clearSolution() {
        this.vec_xtempabs = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.operCost = 0.0;
    }

    public double make_cost() {
        int i;
        double cost = 0.0;
        int fr = 0;
        int to = this.numgen + this.numload;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        for (i = 0; i < this.geners.length; ++i) {
            cost += this.geners[i].getalpha() * this.dTb;
        }
        fr = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        to = fr + this.serHydUnit.length;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtemp[i] * this.vec_c[i];
        }
        fr = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + this.irrHydUnit.length;
        to = fr + this.irrHydUnit.length;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtemp[i] * this.vec_c[i];
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.busbars.length; ++ix) {
            if (!this.busbars[ix].getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public void make_vec_Grad() {
        int i;
        for (i = 0; i < this.numgen + this.numload; ++i) {
            this.vec_Grad[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
        for (i = this.numgen + this.numload; i < this.numvar; ++i) {
            this.vec_Grad[i] = this.vec_c[i];
        }
    }

    public void makeAdd_mat_Avar() {
        int j;
        int i;
        int off = this.numgen + this.numload;
        this.mat_Avar = new double[this.numnod][this.numnod];
        if (SEEDS_Frame.n_LossMode == 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 0.0) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - 1.0 / this.MatX[i][j];
                    double[] dArray2 = this.mat_Avar[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + 1.0 / this.MatX[i][j];
                }
            }
        } else {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 0.0) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                    double[] dArray3 = this.mat_Avar[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                }
            }
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.mat_A[i][off + j] = this.mat_Avar[i][j];
            }
        }
    }

    public void make_vec_RHS() {
        double aux;
        int ix;
        this.update_vec_RHS();
        int offVar = this.numvarEl;
        int offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (int jx = 0; jx < this.HCx[0].length; ++jx) {
                if (this.HCx[ix][jx] == 0.0) continue;
                this.vec_RHS[offRes + ix] = 0.0;
            }
        }
        offVar += 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] - 0.0;
        }
        int offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (this.resHydUnit[ix].getFiltType() > 0) {
                this.vec_RHS[offRes + ix] = 0.0;
                aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
                int n = offRes + ix;
                this.vec_RHS[n] = this.vec_RHS[n] + this.resHydUnit[ix].getAvfiltf() * aux / this.dTb / 2.0 * this.dTb / 730.0;
                continue;
            }
            this.vec_RHS[offRes + ix] = 0.0;
        }
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (aux / this.dTb + this.sumQAffl(this.resaff[ix]));
        }
        offRes += this.resHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + this.sumQAffl(this.seraff[ix]);
        }
        offRes += this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (this.sumQAffl(this.irraff[ix]) - this.irrHydUnit[ix].getSpillmin());
        }
    }

    public void update_vec_RHS() {
        int offRes;
        int ix;
        double dang;
        int i;
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = this.nod_Pdem[i] / this.sref;
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i + this.numload];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + this.numload];
        }
        int off = this.numgen + this.numload;
        i = 0;
        while (i < this.numnod) {
            double transm = 0.0;
            for (int j = 0; j < this.numnod; ++j) {
                if (!(Math.abs(this.MatX[i][j]) > 0.0) || j == i) continue;
                dang = this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j];
                transm += this.MatG[i][j] / 2.0 * dang * dang + dang / this.MatX[i][j];
            }
            int n = i++;
            this.vec_RHS[n] = this.vec_RHS[n] + transm;
        }
        off = this.numgen + this.numload;
        if (SEEDS_Frame.n_TxLim == 1) {
            double xij;
            int con2;
            int con1;
            for (ix = 0; ix < this.lines.length; ++ix) {
                con1 = this.BranchI[ix];
                con2 = this.BranchJ[ix];
                xij = this.BranchX[ix];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                if (this.lines[ix].sc >= 0.0) {
                    this.vec_RHS[this.numnod + ix] = this.lines[ix].getsmax() / this.sref - dang / xij;
                    this.vec_RHS[this.numnod + this.numbran + ix] = -this.lines[ix].getsmax() / this.sref - dang / xij;
                    continue;
                }
                if (this.lines[ix].sc == -1.0) {
                    this.vec_RHS[this.numnod + ix] = this.lines[ix].getsmax() / this.sref - dang / xij;
                    this.vec_RHS[this.numnod + this.numbran + ix] = 0.0;
                    continue;
                }
                if (this.lines[ix].sc != -2.0) continue;
                this.vec_RHS[this.numnod + ix] = 0.0;
                this.vec_RHS[this.numnod + this.numbran + ix] = -this.lines[ix].getsmax() / this.sref - dang / xij;
            }
            int count = this.numnod + this.numlin;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                con1 = this.BranchI[ix + this.numlin];
                con2 = this.BranchJ[ix + this.numlin];
                xij = this.BranchX[ix + this.numlin];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                if (this.trafos[ix].sc >= 0.0) {
                    this.vec_RHS[count] = this.trafos[ix].getsmax() / this.sref - dang / xij;
                    this.vec_RHS[this.numbran + count] = -this.trafos[ix].getsmax() / this.sref - dang / xij;
                } else if (this.trafos[ix].sc == -1.0) {
                    this.vec_RHS[count] = this.trafos[ix].getsmax() / this.sref - dang / xij;
                    this.vec_RHS[this.numbran + count] = 0.0;
                } else if (this.trafos[ix].sc == -2.0) {
                    this.vec_RHS[count] = 0.0;
                    this.vec_RHS[this.numbran + count] = -this.trafos[ix].getsmax() / this.sref - dang / xij;
                }
                ++count;
            }
            offRes = this.busbars.length + 2 * this.numbran;
        } else {
            offRes = this.busbars.length;
        }
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = -this.vec_xtempabs[offVar + ix];
        }
        offVar += this.resEleGen.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = -this.vec_xtempabs[offVar + ix];
        }
    }

    public double[] make_AbsEqRHSdev() {
        int i;
        double[] deviations = new double[this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            deviations[i] = this.vec_RHS[i];
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            deviations[n] = deviations[n] - this.vec_xtemp[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i + this.numload];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtemp[i + this.numload];
        }
        return deviations;
    }

    public void writeResults() throws Exception {
        double f21;
        double f12;
        double gmula;
        int con2;
        int con1;
        int ix = 0;
        double aux = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.totunser += this.vec_xtempabs[ix] * this.sref;
            aux = this.loads[ix].getp();
            this.totdem += aux;
            this.loads[ix].setpini(aux);
            if (Math.abs(this.vec_xtempabs[ix] * this.sref) < 0.001) {
                this.loads[ix].setunser_p(0.0);
                continue;
            }
            this.loads[ix].setunser_p(this.vec_xtempabs[ix] * this.sref);
        }
        int off = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.totgen += this.vec_xtempabs[ix + off] * this.sref;
            if (Math.abs(this.vec_xtempabs[ix + off] * this.sref) < 0.001) {
                this.geners[ix].setp(0.0);
                continue;
            }
            this.geners[ix].setp(this.vec_xtempabs[ix + off] * this.sref);
        }
        off += this.geners.length;
        for (ix = 0; ix < this.busbars.length; ++ix) {
            double angulin = this.vec_xtempabs[ix + off] * 180.0 / Math.PI;
            this.busbars[ix].setdelta2(angulin);
            double spotin = this.vec_lam[ix] / this.sref / this.dTb * ponderar;
            this.busbars[ix].setspot_p(spotin);
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (Math.abs(this.BranchX[ix]) > 0.0) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                System.out.println("Too Low Reactance in lines: " + this.lines[ix].getName() + " with X=" + this.BranchX[ix]);
                f12 = 0.0;
                f21 = 0.0;
            }
            this.lines[ix].setp12(f12 / this.ActSchematic.getsref());
            this.lines[ix].setp21(f21 / this.ActSchematic.getsref());
        }
        int to = this.lines.length + this.trafos.length;
        while (ix < to) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (this.trafos[ix - this.lines.length].gett_re() > 1.0E-8) {
                this.BranchX[ix] = this.BranchX[ix] * this.trafos[ix - this.lines.length].gett_re();
                this.BranchR[ix] = this.BranchR[ix] * this.trafos[ix - this.lines.length].gett_re();
            }
            if (Math.abs(this.BranchX[ix]) > 0.0) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                System.out.println("Too Low Reactance in trafos: " + this.trafos[ix - this.lines.length].getName() + " with X=" + this.BranchX[ix]);
                f12 = 0.0;
                f21 = 0.0;
            }
            this.trafos[ix - this.lines.length].setp12(f12 / this.ActSchematic.getsref());
            this.trafos[ix - this.lines.length].setp21(f21 / this.ActSchematic.getsref());
            ++ix;
        }
        off = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            this.ppHydUnit[ix].caudaffl = this.sumQAffl(this.ppaff[ix]);
            aux = this.ppHydUnit[ix].getWat2PowRate() <= 0.0 ? 0.0 : this.vec_xtempabs[off + ix] * this.sref / this.ppHydUnit[ix].getWat2PowRate();
            this.ppHydUnit[ix].caudgener = aux;
            this.ppHydUnit[ix].caudspill = this.ppHydUnit[ix].caudaffl - aux;
        }
        off = this.numvarEl;
        int off1 = this.numvarEl + this.resHydUnit.length + this.serHydUnit.length;
        int off2 = this.numvarEl + 2 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        int off3 = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.resHydUnit[ix].caudaffl = this.sumQAffl(this.resaff[ix]);
            this.resHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.resHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
            this.resHydUnit[ix].caudfilt = this.vec_xtempabs[off2 + ix];
            this.resHydUnit[ix].Vfin = this.vec_xtempabs[off3 + ix] * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin();
            this.resHydUnit[ix].setSimVfin(this.resHydUnit[ix].Vfin);
        }
        off = this.numvarEl + this.resHydUnit.length;
        off1 = this.numvarEl + 2 * this.resHydUnit.length + this.serHydUnit.length;
        off2 = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.serHydUnit[ix].caudaffl = this.sumQAffl(this.seraff[ix]) + this.vec_xtempabs[off2 + ix];
            this.serHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.serHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
            this.serHydUnit[ix].caudaFail = this.vec_xtempabs[off2 + ix];
        }
        off = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length;
        off1 = off + this.irrHydUnit.length;
        off3 = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.irrHydUnit[ix].caudaffl = this.sumQAffl(this.irraff[ix]) + this.vec_xtempabs[off1 + ix];
            this.irrHydUnit[ix].caudaFail = this.vec_xtempabs[off1 + ix];
            this.irrHydUnit[ix].caudspill = this.vec_xtempabs[off + ix];
            this.irrHydUnit[ix].caudgener = this.irrHydUnit[ix].getSpillmin();
        }
    }

    public void setSolverParam(int solverId, int nmaxItera, double tolCost) throws Exception {
        this.metodo = solverId;
        this.nmaxiter = nmaxItera;
        this.costTolerance = tolCost;
        if (this.metodo == 0) {
            this.cplex = new IloCplex();
            this.cplex.setOut(null);
            this.cplex.setWarning(null);
            this.auxArr = new double[this.numvar];
        } else if (this.metodo == 1) {
            this.cplex = new IloCplex();
            this.cplex.setOut(null);
            this.cplex.setWarning(null);
            this.auxArr = new double[this.numvar];
        } else {
            this.vec_clave = new int[this.numres];
            this.make_vec_clave();
        }
    }

    private void initLSSchemObj() throws Exception {
        comp tempcomp;
        int ix;
        Vector<comp> ppHUVec = new Vector<comp>(10);
        Vector<comp> afflVec = new Vector<comp>(30);
        Vector<comp> serHUVecNoGr = new Vector<comp>(20);
        Vector<comp> serHUVecGnd = new Vector<comp>(20);
        Vector<comp> resHUVecNoGr = new Vector<comp>(10);
        Vector<comp> resHUVecGnd = new Vector<comp>(10);
        Vector<comp> irrHUVec = new Vector<comp>(15);
        Vector<comp> eleGenVec = new Vector<comp>(70);
        Vector<comp> injGenVec = new Vector<comp>(20);
        Vector<comp> lineVec = new Vector<comp>(70);
        Vector<comp> trafoVec = new Vector<comp>(20);
        Vector<comp> busbarVec = new Vector<comp>(70);
        Vector<comp> loadVec = new Vector<comp>(70);
        Object tempGen = null;
        Object temphdb = null;
        hdb_ser tempSer = null;
        hdb_res tempRes = null;
        hdb_irr tempIrr = null;
        Object tempInj = null;
        Line TempLine = null;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!tempcomp.getinservice() || !tempcomp.getactive()) continue;
            if (tempcomp instanceof hdb_link) {
                ((hdb_link)tempcomp).InformEndComponents();
                continue;
            }
            if (tempcomp instanceof ndb_1pol) {
                tempcomp.InformAllComponents();
                continue;
            }
            if (tempcomp instanceof Trafo) {
                Trafo trafo = (Trafo)tempcomp;
                trafo.InformAllComponents();
                continue;
            }
            if (!(tempcomp instanceof Line)) continue;
            TempLine = (Line)tempcomp;
            TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
            TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!tempcomp.getinservice() || !tempcomp.getactive()) continue;
            if (tempcomp instanceof hdb_comp) {
                hdb_link link;
                if (tempcomp instanceof hdb_affl) {
                    afflVec.add(tempcomp);
                    continue;
                }
                if (!(tempcomp instanceof hdb_unit)) continue;
                ((hdb_unit)tempcomp).InformRiverUpComps();
                if (tempcomp instanceof hdb_paspur) {
                    ppHUVec.add(tempcomp);
                    continue;
                }
                if (tempcomp instanceof hdb_irr) {
                    irrHUVec.add(tempcomp);
                    tempIrr = (hdb_irr)tempcomp;
                    tempIrr.InformRecipients();
                    continue;
                }
                if (tempcomp instanceof hdb_res) {
                    tempRes = (hdb_res)tempcomp;
                    tempRes.InformRecipients();
                    if (tempRes.getgrounded()) {
                        resHUVecGnd.add(tempcomp);
                        continue;
                    }
                    resHUVecNoGr.add(tempcomp);
                    continue;
                }
                if (tempcomp instanceof hdb_ser) {
                    tempSer = (hdb_ser)tempcomp;
                    tempSer.InformRecipients();
                    if (tempSer.getgrounded()) {
                        serHUVecGnd.add(tempcomp);
                        continue;
                    }
                    serHUVecNoGr.add(tempcomp);
                    continue;
                }
                if (!(tempcomp instanceof hdb_link) || (link = (hdb_link)tempcomp).hasEndComp()) continue;
                System.out.println("hdb_link [" + tempcomp.getName() + "]: in {(" + link.x1 + "," + link.y1 + "),(" + link.x2 + "," + link.y2 + ")} is not connected.");
                continue;
            }
            if (tempcomp instanceof Generator) {
                eleGenVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof ndb_inj) {
                injGenVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Line) {
                lineVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Trafo) {
                trafoVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Busbar) {
                busbarVec.add(tempcomp);
                continue;
            }
            if (!(tempcomp instanceof Load)) continue;
            loadVec.add(tempcomp);
        }
        this.injGen = new Injection[injGenVec.size()];
        for (ix = 0; ix < injGenVec.size(); ++ix) {
            this.injGen[ix] = (Injection)injGenVec.elementAt(ix);
        }
        this.lines = new Line[lineVec.size()];
        for (ix = 0; ix < lineVec.size(); ++ix) {
            this.lines[ix] = (Line)lineVec.elementAt(ix);
        }
        this.trafos = new Trafo[trafoVec.size()];
        for (ix = 0; ix < trafoVec.size(); ++ix) {
            this.trafos[ix] = (Trafo)trafoVec.elementAt(ix);
        }
        this.busbars = new Busbar[busbarVec.size()];
        for (ix = 0; ix < busbarVec.size(); ++ix) {
            this.busbars[ix] = (Busbar)busbarVec.elementAt(ix);
        }
        this.loads = new Load[loadVec.size()];
        for (ix = 0; ix < loadVec.size(); ++ix) {
            this.loads[ix] = (Load)loadVec.elementAt(ix);
        }
        this.irrHydUnit = new hdb_irr[irrHUVec.size()];
        for (ix = 0; ix < irrHUVec.size(); ++ix) {
            this.irrHydUnit[ix] = (hdb_irr)irrHUVec.elementAt(ix);
        }
        this.ppHydUnit = new hdb_paspur[ppHUVec.size()];
        for (ix = 0; ix < ppHUVec.size(); ++ix) {
            this.ppHydUnit[ix] = (hdb_paspur)ppHUVec.elementAt(ix);
        }
        this.serHydUnit = new hdb_ser[serHUVecGnd.size() + serHUVecNoGr.size()];
        for (ix = 0; ix < serHUVecNoGr.size(); ++ix) {
            this.serHydUnit[ix] = (hdb_ser)serHUVecNoGr.elementAt(ix);
        }
        for (ix = 0; ix < serHUVecGnd.size(); ++ix) {
            this.serHydUnit[serHUVecNoGr.size() + ix] = (hdb_ser)serHUVecGnd.elementAt(ix);
        }
        this.resHydUnit = new hdb_res[resHUVecGnd.size() + resHUVecNoGr.size()];
        for (ix = 0; ix < resHUVecNoGr.size(); ++ix) {
            this.resHydUnit[ix] = (hdb_res)resHUVecNoGr.elementAt(ix);
        }
        for (ix = 0; ix < resHUVecGnd.size(); ++ix) {
            this.resHydUnit[resHUVecNoGr.size() + ix] = (hdb_res)resHUVecGnd.elementAt(ix);
        }
        this.ppEleGen = new Generator[this.ppHydUnit.length];
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            this.ppEleGen[ix] = (Generator)this.extractComp(this.ppHydUnit[ix].getName(), eleGenVec);
        }
        this.serEleGen = new Generator[serHUVecNoGr.size()];
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.serEleGen[ix] = (Generator)this.extractComp(this.serHydUnit[ix].getName(), eleGenVec);
        }
        this.resEleGen = new Generator[resHUVecNoGr.size()];
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.resEleGen[ix] = (Generator)this.extractComp(this.resHydUnit[ix].getName(), eleGenVec);
        }
        this.thermalGen = new Generator[eleGenVec.size()];
        for (ix = 0; ix < this.thermalGen.length; ++ix) {
            this.thermalGen[ix] = (Generator)eleGenVec.elementAt(ix);
        }
        int sx = this.injGen.length + this.thermalGen.length + this.ppEleGen.length + this.resEleGen.length + this.serEleGen.length;
        this.geners = new ndb_inj[sx];
        sx = 0;
        for (ix = 0; ix < this.injGen.length; ++ix) {
            this.geners[ix] = this.injGen[ix];
        }
        sx = this.injGen.length;
        for (ix = 0; ix < this.thermalGen.length; ++ix) {
            this.geners[sx + ix] = this.thermalGen[ix];
        }
        sx += this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.geners[sx + ix] = this.ppEleGen[ix];
        }
        sx += this.ppEleGen.length;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.geners[sx + ix] = this.resEleGen[ix];
        }
        sx += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.geners[sx + ix] = this.serEleGen[ix];
        }
        this.irraff = new hdb_affl[this.irrHydUnit.length][0];
        this.ppaff = new hdb_affl[this.ppHydUnit.length][0];
        this.seraff = new hdb_affl[this.serHydUnit.length][0];
        this.resaff = new hdb_affl[this.resHydUnit.length][0];
        Vector<comp> tempVec = new Vector<comp>(10);
        Vector<comp> affVec = new Vector<comp>(100);
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            for (sx = 0; sx < this.irrHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.irrHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
                affVec.addElement(tempcomp);
            }
            this.irraff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.irraff[ix].length; ++sx) {
                this.irraff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.irraff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            for (sx = 0; sx < this.ppHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.ppHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
                affVec.addElement(tempcomp);
            }
            this.ppaff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.ppaff[ix].length; ++sx) {
                this.ppaff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.ppaff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            for (sx = 0; sx < this.serHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.serHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
                affVec.addElement(tempcomp);
            }
            this.seraff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.seraff[ix].length; ++sx) {
                this.seraff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.seraff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            for (sx = 0; sx < this.resHydUnit[ix].riverUpComps.size(); ++sx) {
                tempcomp = (comp)this.resHydUnit[ix].riverUpComps.elementAt(sx);
                if (!(tempcomp instanceof hdb_affl)) continue;
                tempVec.addElement(tempcomp);
                affVec.addElement(tempcomp);
            }
            this.resaff[ix] = new hdb_affl[tempVec.size()];
            for (sx = 0; sx < this.resaff[ix].length; ++sx) {
                this.resaff[ix][sx] = (hdb_affl)tempVec.elementAt(sx);
                this.extractComp(this.resaff[ix][sx].getName(), afflVec);
            }
            tempVec.removeAllElements();
        }
        this.allaff = new hdb_affl[affVec.size()];
        for (ix = 0; ix < affVec.size(); ++ix) {
            this.allaff[ix] = (hdb_affl)affVec.elementAt(ix);
        }
    }

    private void reloadTx() throws Exception {
        int ix;
        Vector ppHUVec = new Vector(10);
        Vector afflVec = new Vector(30);
        Vector serHUVecNoGr = new Vector(20);
        Vector serHUVecGnd = new Vector(20);
        Vector resHUVecNoGr = new Vector(10);
        Vector resHUVecGnd = new Vector(10);
        Vector irrHUVec = new Vector(15);
        Vector eleGenVec = new Vector(70);
        Vector injGenVec = new Vector(20);
        Vector lineVec = new Vector(70);
        Vector trafoVec = new Vector(20);
        Vector busbarVec = new Vector(70);
        Vector loadVec = new Vector(70);
        Object tempGen = null;
        Object temphdb = null;
        Object tempSer = null;
        Object tempRes = null;
        Object tempIrr = null;
        Object tempInj = null;
        Line TempLine = null;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!tempcomp.getinservice() || !tempcomp.getactive()) continue;
            if (tempcomp instanceof Trafo) {
                Trafo trafo = (Trafo)tempcomp;
                trafo.InformAllComponents();
                continue;
            }
            if (!(tempcomp instanceof Line)) continue;
            TempLine = (Line)tempcomp;
            TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
            TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
        }
        this.lines = new Line[lineVec.size()];
        for (ix = 0; ix < lineVec.size(); ++ix) {
            this.lines[ix] = (Line)lineVec.elementAt(ix);
        }
        this.trafos = new Trafo[trafoVec.size()];
        for (ix = 0; ix < trafoVec.size(); ++ix) {
            this.trafos[ix] = (Trafo)trafoVec.elementAt(ix);
        }
    }

    private void makeHSubMatrix() throws Exception {
        hdb_unit temphun;
        int row;
        int col;
        int ix;
        int numfil = this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        int numcol = 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        this.HCx = new double[numfil][numcol];
        int rowbias = 0;
        int colbias1 = 0;
        int colbias2 = this.resHydUnit.length + this.serHydUnit.length;
        int colbias3 = 2 * colbias2;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            col = ix;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getTurbRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias2;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getSpilRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                this.HCx[row][col] = -1.0;
            }
            col = ix + colbias3;
            row = ix;
            this.HCx[row][col] = 1.0;
            temphun = this.resHydUnit[ix].getFiltRecComp();
            if (temphun == null) continue;
            row = this.getRecipientRow(temphun);
            this.HCx[row][col] = -1.0;
        }
        rowbias = this.resHydUnit.length;
        colbias1 = this.resHydUnit.length;
        colbias2 = 2 * this.resHydUnit.length + this.serHydUnit.length;
        colbias3 = 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            row = ix + rowbias;
            col = ix + colbias1;
            this.HCx[row][col] = 1.0;
            col = ix + colbias2;
            this.HCx[row][col] = 1.0;
            col = ix + colbias3;
            this.HCx[row][col] = -1.0;
            temphun = this.serHydUnit[ix].getTurbRecComp();
            if (temphun != null) {
                row = this.getRecipientRow(temphun);
                col = ix + colbias1;
                this.HCx[row][col] = -1.0;
            }
            if ((temphun = this.serHydUnit[ix].getSpilRecComp()) == null) continue;
            row = this.getRecipientRow(temphun);
            col = ix + colbias2;
            this.HCx[row][col] = -1.0;
        }
        rowbias = this.resHydUnit.length + this.serHydUnit.length;
        colbias1 = 3 * this.resHydUnit.length + 3 * this.serHydUnit.length;
        colbias2 = colbias1 + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            row = ix + rowbias;
            col = ix + colbias1;
            this.HCx[row][col] = 1.0;
            col = ix + colbias2;
            this.HCx[row][col] = -1.0;
            temphun = this.irrHydUnit[ix].getTurbRecComp();
            if (temphun == null) continue;
            row = this.getRecipientRow(temphun);
            col = ix + colbias1;
            this.HCx[row][col] = -1.0;
        }
        this.mDrE = new double[this.resEleGen.length];
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.mDrE[ix] = this.resHydUnit[ix].getWat2PowRate() / this.sref;
        }
        this.mDrS = new double[this.serEleGen.length];
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.mDrS[ix] = this.serHydUnit[ix].getWat2PowRate() / this.sref;
        }
        this.mDbvE = new double[this.resHydUnit.length];
        this.mDfE = new double[this.resHydUnit.length];
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            double capacity = (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
            this.mDbvE[ix] = capacity / this.dTb;
            this.mDfE[ix] = this.resHydUnit[ix].getFiltType() > 0 ? this.mDbvE[ix] * this.resHydUnit[ix].getAvfiltf() / 2.0 * this.dTb / 730.0 : 0.0;
        }
    }

    private void loadBCs() {
        this.vBC = new Vector();
        this.slopes = new double[]{2000000.0, 3000000.0, 5000000.0, 2000000.0, 2500000.0, 3100000.0};
        this.points = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
        SEEDS_BendCut bc1 = new SEEDS_BendCut(this.slopes, this.points, 4.6E8);
        this.vBC.add(bc1);
    }

    private comp extractComp(String compName, Vector compVec) {
        comp comp2ret = null;
        for (int pos = 0; pos < compVec.size(); ++pos) {
            if (!compName.equals(((comp)compVec.elementAt(pos)).getName())) continue;
            comp2ret = (comp)compVec.elementAt(pos);
            compVec.remove(pos);
            return comp2ret;
        }
        return null;
    }

    private int findArrPos(comp comp2find, Object[] arrComp) {
        for (int pos = 0; pos < arrComp.length; ++pos) {
            if (comp2find != arrComp[pos]) continue;
            return pos;
        }
        return -1;
    }

    private int getRecipientRow(hdb_comp temphdb) {
        int row = -1;
        try {
            if (temphdb instanceof hdb_res) {
                row = this.findArrPos(temphdb, this.resHydUnit);
            } else if (temphdb instanceof hdb_ser) {
                row = this.resHydUnit.length + this.findArrPos(temphdb, this.serHydUnit);
            } else if (temphdb instanceof hdb_irr) {
                row = this.resHydUnit.length + this.serHydUnit.length + this.findArrPos(temphdb, this.irrHydUnit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    private double sumQAffl(hdb_affl[] aff) {
        double sum = 0.0;
        for (int i = 0; i < aff.length; ++i) {
            sum += aff[i].getQ();
        }
        return sum;
    }

    public void finalize() throws Exception {
        this.MatG = null;
        this.MatX = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_Grad = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.nod_Pdem = null;
        this.mat_W = null;
        this.mat_A = null;
        this.vBC = null;
        if (this.cplex != null) {
            this.cplex.end();
            this.cplex = null;
        }
    }

    public void make_vec_clave() {
        int i;
        int f = 0;
        int t = this.numnod;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 3;
        }
        if (SEEDS_Frame.n_TxLim == 1) {
            f = t;
            t += this.numbran;
            for (i = f; i < t; ++i) {
                this.vec_clave[i] = 2;
                this.vec_clave[i + this.numbran] = 3;
            }
            t += this.numbran;
        }
        f = t;
        t = this.numres;
        for (i = f; i < t; ++i) {
            this.vec_clave[i] = 1;
        }
    }

    public void setBCsV(Vector pBCuts) {
        this.vBC = pBCuts;
    }

    protected void setViniFromObj(hdb_res[] res2SetVini) {
        for (int ix = 0; ix < res2SetVini.length; ++ix) {
            res2SetVini[ix].setSimVini(res2SetVini[ix].getVini());
        }
    }

    public void setVini2values(double pSimVini, double[] pSimViniArr) {
        block3: {
            block2: {
                if (pSimViniArr != null) break block2;
                for (int ix = 0; ix < this.resHydUnit.length; ++ix) {
                    this.resHydUnit[ix].setSimVini(pSimVini * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin());
                }
                break block3;
            }
            if (pSimViniArr.length != this.resHydUnit.length) break block3;
            for (int ix = 0; ix < this.resHydUnit.length; ++ix) {
                this.resHydUnit[ix].setSimVini(pSimViniArr[ix] * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin());
            }
        }
    }

    public void doResStepForward() {
        int offVar = this.numvar - 1 - this.resHydUnit.length;
        for (int ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.resHydUnit[ix].setSimVini(this.vec_xtempabs[offVar + ix] * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin());
        }
    }

    public void setHydroAffQ(int stageIn, int hydroIn) throws SEEDS_Exception {
        int ix;
        boolean allOK = true;
        for (ix = 0; ix < this.allaff.length && allOK; ++ix) {
            allOK = this.allaff[ix].setQfromSimStMat(stageIn, hydroIn);
        }
        if (!allOK) {
            throw new SEEDS_Exception("An error when loading Q in Affluent '" + this.allaff[ix].getName() + "' stage " + (stageIn + 1));
        }
    }

    public void setDynParSt(int stageIn) {
        int ix;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.geners[ix].setDynPars(stageIn);
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.serHydUnit[ix].setDynPars(stageIn);
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.irrHydUnit[ix].setDynPars(stageIn);
        }
    }

    public void setHydroAffBlock(int blockIdx) {
        hdb_paspur.blockIn = blockIdx;
    }

    public void setBlockPLoad(int stageIn, int blockIn) throws SEEDS_Exception {
        int ix;
        boolean allOK = true;
        for (ix = 0; ix < this.loads.length && allOK; ++ix) {
            allOK = this.loads[ix].setPfromSimSt(stageIn, blockIn);
        }
        if (!allOK) {
            throw new SEEDS_Exception("An error when loading Pdem in Load '" + this.loads[ix].getName() + "' stage " + (stageIn + 1) + " block" + (blockIn + 1));
        }
    }

    public void optimizeRORaff(double[] blocksD) {
        int ix;
        if (blocksD.length == 1) {
            return;
        }
        int[] blocksDur = new int[blocksD.length];
        int stageDur = 0;
        for (ix = 0; ix < blocksDur.length; ++ix) {
            stageDur += blocksDur[ix];
            blocksDur[ix] = (int)Math.round(blocksD[ix]);
        }
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            if (!this.ppHydUnit[ix].getIsRegulTank()) continue;
            hdb_paspur.makeRegulBF(this.ppHydUnit[ix], this.sumQAffl(this.ppaff[ix]), blocksDur, stageDur, this.ppEleGen[ix]);
        }
    }

    public SEEDS_BendCut getSolBendCut() {
        int ix;
        this.totCost = this.operCost + this.vec_xtempabs[this.numvar - 1] * fEscBC * this.discRateFFCF;
        int offset = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.slopes[ix] = -this.vec_lam[offset + ix] * this.mDbvE[ix];
        }
        offset = this.numvar - 1 - this.resHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            double capa = this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin();
            this.points[ix] = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) / capa;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (!(this.slopes[ix] < 0.0)) continue;
            this.slopes[ix] = 0.0;
        }
        return new SEEDS_BendCut(this.slopes, this.points, this.totCost);
    }

    public void writeBCs(OutputStream myOS) {
        int ix;
        PrintWriter myPrintStream = new PrintWriter(myOS);
        myPrintStream.println("Benders Cuts");
        String auxcad = "CutNum ";
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            auxcad = auxcad + "Si_" + this.resHydUnit[ix].getName() + " ";
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            auxcad = auxcad + "Xi_" + this.resHydUnit[ix].getName() + " ";
        }
        auxcad = auxcad + "Base_F";
        myPrintStream.println(auxcad);
        for (ix = 0; ix < this.vBC.size(); ++ix) {
            int jx;
            SEEDS_BendCut tempBC = (SEEDS_BendCut)this.vBC.elementAt(ix);
            this.auxArr = tempBC.mi;
            auxcad = "" + (ix + 1) + " ";
            for (jx = 0; jx < this.auxArr.length; ++jx) {
                auxcad = auxcad + this.auxArr[jx] + " ";
            }
            this.auxArr = tempBC.xi;
            for (jx = 0; jx < this.auxArr.length; ++jx) {
                auxcad = auxcad + this.auxArr[jx] + " ";
            }
            auxcad = auxcad + tempBC.f0;
            myPrintStream.println(auxcad);
        }
        myPrintStream.flush();
    }

    public void writeActSol(OutputStream myOS, boolean wNames) {
        int ix;
        PrintWriter myPrintStream = new PrintWriter(myOS);
        myPrintStream.println("Actual Solution");
        String auxcad = "";
        if (wNames) {
            for (ix = 0; ix < this.resHydUnit.length; ++ix) {
                auxcad = auxcad + "Xsol_" + this.resHydUnit[ix].getName() + " ";
            }
            myPrintStream.println(auxcad);
        }
        int offVar = this.numvarEl + this.numvarHy - this.resHydUnit.length;
        auxcad = "";
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            auxcad = auxcad + this.vec_xtempabs[ix + offVar] + " ";
        }
        myPrintStream.println(auxcad);
        myPrintStream.flush();
    }

    protected void setStageLength(double length) {
        this.dTb = length;
    }

    protected double getStageLength() {
        return this.dTb;
    }

    protected String[][][] getSystemNames() {
        int ix;
        if (this.sNames != null) {
            return this.sNames;
        }
        int count = 0;
        this.sNames = new String[2][0][0];
        this.sNames[0] = new String[2][this.numvar];
        this.sNames[1] = new String[2][this.numres];
        System.out.println("Sequence \u00ab " + (SEEDS_Tool.ids[0] + 1) + " \u00bb. Each SP has N\u00b0 var: " + this.numvar + " N\u00b0 res: " + this.numres);
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sNames[0][0][count] = "Pu_Load";
            this.sNames[0][1][count] = this.loads[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.sNames[0][0][count] = "Pg_Gen";
            this.sNames[0][1][count] = this.geners[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.sNames[0][0][count] = "Ang_Bus";
            this.sNames[0][1][count] = this.busbars[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qt_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qt_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Irr";
            this.sNames[0][1][count] = this.irrHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Irr";
            this.sNames[0][1][count] = this.irrHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "V_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        this.sNames[0][0][count] = " ";
        this.sNames[0][1][count] = "EFCF";
        count = 0;
        for (ix = 0; ix < this.numnod; ++ix) {
            this.sNames[1][0][ix] = "CMg Bus";
            this.sNames[1][1][ix] = this.busbars[ix].getName();
            ++count;
        }
        if (SEEDS_Frame.n_TxLim == 1) {
            for (ix = 0; ix < this.lines.length; ++ix) {
                this.sNames[1][0][this.numnod + ix] = "CMg TxUp";
                this.sNames[1][1][this.numnod + ix] = this.lines[ix].getName().replace("-", "_").replace(">", "") + "_Up";
                this.sNames[1][0][this.numnod + this.numbran + ix] = "CMg TxDn";
                this.sNames[1][1][this.numnod + this.numbran + ix] = this.lines[ix].getName().replace("-", "_").replace(">", "") + "_Dn";
            }
            for (ix = 0; ix < this.trafos.length; ++ix) {
                this.sNames[1][0][this.numnod + this.numlin + ix] = "CMg TrafoUp";
                this.sNames[1][1][this.numnod + this.numlin + ix] = this.trafos[ix].getName().replace("-", "_").replace(">", "") + "_Up";
                this.sNames[1][0][this.numnod + this.numlin + this.numbran + ix] = "CMg TrafoDn";
                this.sNames[1][1][this.numnod + this.numlin + this.numbran + ix] = this.trafos[ix].getName().replace("-", "_").replace(">", "") + "_Dn";
            }
            count += 2 * this.numbran;
        }
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.sNames[1][0][count] = "Reser e->h";
            this.sNames[1][1][count] = this.resEleGen[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.sNames[1][0][count] = "Serie e->h";
            this.sNames[1][1][count] = this.serEleGen[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Reser Balance";
            this.sNames[1][1][count] = this.resHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Serie Balance";
            this.sNames[1][1][count] = this.serHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg irr deal";
            this.sNames[1][1][count] = this.irrHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Reser Filter";
            this.sNames[1][1][count] = this.resHydUnit[ix].getName() + "_Fil";
            ++count;
        }
        for (ix = 0; ix < this.sNames[1][1].length; ++ix) {
            this.sNames[1][1][ix] = this.sNames[1][1][ix].replaceAll(">", "");
        }
        return this.sNames;
    }

    private String[] getVarNames() {
        int ix;
        if (this.sVarNames != null) {
            return this.sVarNames;
        }
        int countVar = 0;
        this.sVarNames = new String[this.numvar];
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sVarNames[countVar] = "Dx_" + this.loads[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.sVarNames[countVar] = "Gen_" + this.geners[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.sVarNames[countVar] = "Ang_" + this.busbars[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rtu_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Stu_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rsp_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Ssp_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rft_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Sfl_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Itu_" + this.irrHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Ifl_" + this.irrHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Vol_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        this.sVarNames[countVar] = "FCF";
        return this.sVarNames;
    }

    private IloNumVar[] makeOptSystem(IloRange[] row) throws Exception {
        int ix = 0;
        int jx = 0;
        int count = 0;
        double aux = 0.0;
        IloCplex model = this.cplex;
        IloNumVar[] x = model.numVarArray(this.numvar, this.vec_xminabs, this.vec_xmaxabs, this.getVarNames());
        IloNumExpr aux1 = model.constant(0);
        IloNumExpr aux2 = model.constant(0);
        for (ix = 0; ix < this.loads.length; ++ix) {
            aux2 = model.prod(this.dTb * this.loads[ix].getbeta() * this.sref / ponderar, (IloNumExpr)x[count]);
            aux1 = model.sum(aux1, aux2);
            aux = this.loads[ix].getgamma();
            aux2 = model.prod(this.dTb * aux * this.sref * this.sref / ponderar, model.square(x[count]));
            aux1 = model.sum(aux1, aux2);
            ++count;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            aux2 = model.constant(this.dTb * this.geners[ix].getalpha() / ponderar);
            aux1 = model.sum(aux1, aux2);
            aux2 = model.prod(this.dTb * this.geners[ix].getbeta() * this.sref / ponderar, (IloNumExpr)x[count]);
            aux1 = model.sum(aux1, aux2);
            aux = this.geners[ix].getgamma();
            aux2 = model.prod(this.dTb * aux * this.sref * this.sref / ponderar, model.square(x[count]));
            aux1 = model.sum(aux1, aux2);
            ++count;
        }
        count = this.loads.length + this.geners.length - this.ppEleGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            aux2 = model.prod(1.0E-6, (IloNumExpr)x[count + ix]);
            aux1 = model.sum(aux1, aux2);
        }
        count = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            aux2 = model.prod((this.dTb * SEEDS_Frame.n_IrrCost + 0.001) / ponderar, (IloNumExpr)x[count]);
            aux1 = model.sum(aux1, aux2);
            ++count;
        }
        count = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            aux2 = model.prod(this.dTb * SEEDS_Frame.n_IrrCost / ponderar, (IloNumExpr)x[count + ix]);
            aux1 = model.sum(aux1, aux2);
        }
        aux1 = model.sum(aux1, model.prod(this.discRateFFCF * fEscBC, (IloNumExpr)x[this.numvar - 1]));
        model.addMinimize(aux1);
        this.make_mat_Afix();
        count = 0;
        ix = this.numload + this.numgen;
        for (int kx = 0; kx < this.numnod; ++kx) {
            aux2 = model.constant(0);
            for (jx = 0; jx < this.numnod; ++jx) {
                if (!(Math.abs(this.MatX[kx][jx]) > 0.0) || kx == jx) continue;
                aux1 = model.prod(1.0 / this.MatX[kx][jx], model.sum((IloNumExpr)x[ix + jx], model.negative(x[ix + kx])));
                aux2 = model.sum(aux2, aux1);
            }
            aux1 = model.sum(aux2, (IloNumExpr)model.scalProd(this.mat_A[kx], x));
            row[count] = model.addLe(this.nod_Pdem[kx], aux1, this.getSystemNames()[1][1][kx]);
            ++count;
        }
        if (SEEDS_Frame.n_TxLim == 1) {
            for (ix = 0; ix < this.lines.length; ++ix) {
                row[count] = model.addGe(this.lines[ix].getsmax() / this.sref, (IloNumExpr)model.scalProd(this.mat_A[count], x), this.getSystemNames()[1][1][count]);
                row[count + this.numbran] = model.addLe(-this.lines[ix].getsmax() / this.sref, (IloNumExpr)model.scalProd(this.mat_A[count + this.numbran], x), this.getSystemNames()[1][1][count + this.numbran]);
                ++count;
            }
            count = this.numnod + this.numlin;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                row[count] = model.addGe(this.trafos[ix].getsmax() / this.sref, (IloNumExpr)model.scalProd(this.mat_A[count], x), this.getSystemNames()[1][1][count]);
                row[count + this.numbran] = model.addLe(-this.trafos[ix].getsmax() / this.sref, (IloNumExpr)model.scalProd(this.mat_A[count + this.numbran], x), this.getSystemNames()[1][1][count + this.numbran]);
                ++count;
            }
            count += this.numbran;
        }
        for (ix = 0; ix < this.resEleGen.length + this.serEleGen.length; ++ix) {
            row[count] = model.addEq(0.0, (IloNumExpr)model.scalProd(this.mat_A[count], x), this.getSystemNames()[1][1][count]);
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6 / this.dTb + this.sumQAffl(this.resaff[ix]);
            row[count + ix] = model.addEq(aux, (IloNumExpr)model.scalProd(this.mat_A[count + ix], x), this.getSystemNames()[1][1][count + ix]);
        }
        count += this.resHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            aux = this.sumQAffl(this.seraff[ix]);
            row[count + ix] = model.addEq(aux, (IloNumExpr)model.scalProd(this.mat_A[count + ix], x), this.getSystemNames()[1][1][count + ix]);
        }
        count += this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            aux = this.sumQAffl(this.irraff[ix]) - this.irrHydUnit[ix].getSpillmin();
            row[count + ix] = model.addEq(aux, (IloNumExpr)model.scalProd(this.mat_A[count + ix], x), this.getSystemNames()[1][1][count + ix]);
        }
        count += this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (this.resHydUnit[ix].getFiltType() > 0) {
                aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
                aux = this.resHydUnit[ix].getAvfiltf() * aux / this.dTb / 2.0 * this.dTb / 730.0;
            } else {
                aux = 0.0;
            }
            row[count + ix] = model.addEq(aux, (IloNumExpr)model.scalProd(this.mat_A[count + ix], x), this.getSystemNames()[1][1][count + ix]);
        }
        count += this.resHydUnit.length;
        ix = this.numvarEl + this.numvarHy - this.numReserH;
        for (jx = 0; jx < this.vBC.size(); ++jx) {
            aux1 = model.constant(0);
            SEEDS_BendCut tempBC = (SEEDS_BendCut)this.vBC.elementAt(jx);
            for (int kx = 0; kx < this.resHydUnit.length; ++kx) {
                aux2 = model.prod(tempBC.mi[kx], (IloNumExpr)x[ix + kx]);
                aux1 = model.sum(aux1, aux2);
            }
            aux2 = model.prod(fEscBC, (IloNumExpr)x[this.numvar - 1]);
            aux1 = model.sum(aux1, aux2);
            row[count + jx] = model.addLe(tempBC.f0, aux1, "Bender_Cut_" + (jx + 1));
        }
        return x;
    }

    private boolean SolveQP_BY_CPLEX(boolean flagrat) throws Exception {
        boolean konv = false;
        boolean solveAgain = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        int iteration = 0;
        int i = 0;
        int j = 0;
        SEEDS_BendCut tempBC = null;
        try {
            cost1 = this.operCost;
            this.operCost = -1.0;
            while (!konv) {
                double[] coef;
                ++iteration;
                this.make_vec_Grad(true);
                this.make_mat_W(true);
                this.makeAdd_mat_Avar(true);
                this.update_vec_RHS(true);
                this.updateEl_vec_xlimits();
                this.cplex.clearModel();
                IloCplex qp = this.cplex;
                IloNumVar[] var = qp.numVarArray(this.numvar, this.vec_xmin, this.vec_xmax, this.getVarNames(true));
                IloLinearNumExpr lin = this.cplex.scalProd(this.vec_Grad, var);
                IloNumExpr aux3 = this.cplex.constant(0);
                for (j = 0; j < this.numvarEl; ++j) {
                    for (i = 0; i < this.numvarEl; ++i) {
                        IloNumExpr aux2;
                        if (this.mat_W[i][j] == 0.0) continue;
                        if (i == j) {
                            aux2 = this.cplex.prod(this.mat_W[i][j] / 2.0, this.cplex.square(var[i]));
                            aux3 = this.cplex.sum(aux3, aux2);
                            continue;
                        }
                        IloNumExpr aux1 = this.cplex.prod(this.mat_W[i][j] / 2.0, (IloNumExpr)var[j]);
                        aux2 = this.cplex.prod(aux1, (IloNumExpr)var[i]);
                        aux3 = this.cplex.sum(aux3, aux2);
                    }
                }
                IloNumExpr obj = this.cplex.sum((IloNumExpr)lin, aux3);
                qp.addMinimize(obj);
                IloRange[] res = new IloRange[this.numres + this.vBC.size()];
                for (i = 0; i < this.numnod; ++i) {
                    coef = this.mat_A[i];
                    res[i] = this.cplex.addLe(this.vec_RHS[i], (IloNumExpr)this.cplex.scalProd(coef, var), this.getSystemNames(true)[1][1][i]);
                }
                coef = this.mat_A[this.numnod];
                res[this.numnod] = this.cplex.addLe(this.vec_RHS[this.numnod], (IloNumExpr)this.cplex.scalProd(coef, var), this.getSystemNames(true)[1][1][i]);
                ++i;
                int to = this.numnod + 1 + this.numbran;
                while (i < to) {
                    coef = this.mat_A[i];
                    res[i] = this.cplex.addGe(this.vec_RHS[i], (IloNumExpr)this.cplex.scalProd(coef, var), this.getSystemNames(true)[1][1][i]);
                    coef = this.mat_A[i + this.numbran];
                    res[i + this.numbran] = this.cplex.addLe(this.vec_RHS[i + this.numbran], (IloNumExpr)this.cplex.scalProd(coef, var), this.getSystemNames(true)[1][1][i + this.numbran]);
                    ++i;
                }
                i += this.numbran;
                to = this.numres;
                while (i < to) {
                    coef = this.mat_A[i];
                    res[i] = this.cplex.addEq(this.vec_RHS[i], (IloNumExpr)this.cplex.scalProd(coef, var), this.getSystemNames(true)[1][1][i]);
                    ++i;
                }
                int offVar = this.numvarEl + this.numvarHy - this.resHydUnit.length;
                for (int ix = 0; ix < this.vBC.size(); ++ix) {
                    tempBC = (SEEDS_BendCut)this.vBC.elementAt(ix);
                    for (int jx = 0; jx < this.resHydUnit.length; ++jx) {
                        this.auxArr[offVar + jx] = tempBC.mi[jx];
                    }
                    this.auxArr[offVar + jx] = 1.0 * fEscBC;
                    res[i] = this.cplex.addLe(tempBC.f0, (IloNumExpr)this.cplex.scalProd(this.auxArr, var, offVar, this.resHydUnit.length + 1), "Bender_Cut_" + (ix + 1));
                    ++i;
                }
                this.cplex.setParam(IloCplex.IntParam.RootAlg, 2);
                if (this.cplex.solve()) {
                    this.vec_xtemp = this.cplex.getValues(var);
                    for (i = 0; i < this.numres; ++i) {
                        this.vec_lam[i] = this.cplex.getDual(res[i]);
                    }
                    solveAgain = false;
                    this.cplex.setParam(IloCplex.IntParam.BarAlg, 0);
                } else {
                    this.cplex.setParam(IloCplex.IntParam.BarAlg, 1);
                    if (solveAgain) {
                        this.cplex.exportModel("./" + System.currentTimeMillis() + "ErrorProblemSeed" + this.sp_err++ + ".lp");
                        return false;
                    }
                    solveAgain = true;
                    for (i = this.numvarEl; i < this.numvar; ++i) {
                        this.vec_xtemp[i] = 0.0;
                    }
                }
                this.cplex.clearModel();
                if (solveAgain) continue;
                for (i = 0; i < this.numvarEl; ++i) {
                    int n = i;
                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                }
                cost2 = this.make_cost(true);
                if (Math.abs(cost2 - cost1) <= this.costTolerance * (cost2 + cost1) / 100.0 || iteration == this.nmaxiter) {
                    this.operCost = cost2;
                    for (i = this.numvarEl; i < this.numvar; ++i) {
                        this.vec_xtempabs[i] = this.vec_xtemp[i];
                    }
                    konv = true;
                }
                cost1 = cost2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cplex.exportModel("./ErrorProblemSeed" + this.sp_err++ + ".lp");
            System.out.println("Modelo con error escrito");
            System.err.println(" Concert exception caugth : " + e);
            System.out.println("Opt Res :" + this.cplex.getStatus());
        }
        return konv;
    }

    private void modelMalloc(boolean flagrat) throws Exception {
        this.numvarEl = this.numload + this.numgen + this.numnod + this.numload;
        this.numvarHy = 4 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        this.numresEl = this.numnod + 1;
        if (SEEDS_Frame.n_TxLim == 1) {
            this.numresEl += 2 * this.numbran;
        }
        this.numresHy = this.resEleGen.length + this.serEleGen.length + 2 * this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        this.numvar = this.numvarEl + this.numvarHy + 1;
        this.numres = this.numresEl + this.numresHy;
        this.VarNode = new int[this.numvarEl];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_Grad = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvarEl];
        this.nod_Pdem = new double[this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvarEl][this.numvarEl];
        this.slopes = new double[this.resHydUnit.length];
        this.points = new double[this.resHydUnit.length];
    }

    private void initProblemDef(boolean flagrat) throws Exception {
        int ix;
        this.globalE = 0.0;
        int countVar = 0;
        for (ix = 0; ix < this.numnod; ++ix) {
            this.nod_Pdem[ix] = 0.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.loads[ix].getp0() / this.sref;
            this.VarNode[ix] = this.numbus(this.loads[ix].getcon2());
            int n = this.VarNode[ix];
            this.nod_Pdem[n] = this.nod_Pdem[n] + this.loads[ix].getp0() / this.sref;
            this.globalE += this.loads[ix].getp0() / this.sref;
            ++countVar;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_xminabs[countVar] = this.geners[ix].getpmin() / this.sref;
            this.vec_xmaxabs[countVar] = this.geners[ix].getpmax() / this.sref;
            this.VarNode[countVar] = this.numbus(this.geners[ix].getcon2());
            ++countVar;
        }
        countVar = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.vec_xmaxabs[countVar] = Math.min(this.vec_xmaxabs[countVar], this.ppHydUnit[ix].getWat2PowRate() * this.sumQAffl(this.ppaff[ix]) * this.ppHydUnit[ix].getRegulBFact() / this.sref);
            if (this.vec_xmaxabs[countVar] < this.vec_xminabs[countVar]) {
                this.vec_xmaxabs[countVar] = 0.0;
                this.vec_xminabs[countVar] = 0.0;
            }
            ++countVar;
        }
        countVar += this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_xminabs[countVar] = this.loads[ix].getp0() / this.sref * (this.loads[ix].getldc_pmin() / 100.0);
            this.vec_xmaxabs[countVar] = this.loads[ix].getp0() / this.sref * (this.loads[ix].getldc_pmax() / 100.0);
            ++countVar;
        }
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.vec_xminabs[countVar] = -3.14;
            this.vec_xmaxabs[countVar] = 3.14;
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.resHydUnit[ix].getTurbmax();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            this.vec_xminabs[countVar] = this.serHydUnit[ix].getTurbmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.serHydUnit[ix].getSpillmax();
            this.vec_xminabs[countVar] = this.serHydUnit[ix].getSpillmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.serHydUnit[ix].getSpillmin() + this.serHydUnit[ix].getTurbmin();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = this.irrHydUnit[ix].getSpillmin();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.vec_xmaxabs[countVar] = 1.0;
            ++countVar;
        }
        this.vec_xmaxabs[countVar] = Double.MAX_VALUE;
        this.vec_xminabs[countVar] = 0.0;
        if (this.metodo != 0) {
            this.make_vec_c(true);
            this.make_DiagMat_Q(true);
            this.make_mat_Afix(true);
            this.make_vec_RHS(true);
            this.makeHyd_vec_xlimits();
        }
    }

    public void make_vec_c(boolean flagrat) {
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.vec_c[ix] = this.loads[ix].getbeta() * this.dTb * this.sref / ponderar;
        }
        int countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.vec_c[countVar] = this.geners[ix].getbeta() * this.dTb * this.sref / ponderar;
            ++countVar;
        }
        countVar = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppEleGen.length; ++ix) {
            this.vec_c[countVar] = 1.0E-6;
            ++countVar;
        }
        countVar = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.vec_c[countVar] = (SEEDS_Frame.n_IrrCost + 0.001) * this.dTb / ponderar;
            ++countVar;
        }
        countVar = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.vec_c[countVar] = SEEDS_Frame.n_IrrCost * this.dTb / ponderar;
            ++countVar;
        }
        this.vec_c[countVar += this.resHydUnit.length] = this.discRateFFCF * fEscBC;
    }

    public void make_DiagMat_Q(boolean flagrat) {
        int ix = 0;
        int countVar = 0;
        for (ix = 0; ix < this.numvarEl; ++ix) {
            this.DiagMat_Q[ix] = 0.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.DiagMat_Q[ix] = 2.0 * (this.loads[ix].getgamma() / this.sref / (this.loads[ix].getp0() * this.dTb)) * this.dTb * this.sref * this.sref / ponderar;
        }
        countVar = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.DiagMat_Q[countVar] = 2.0 * this.geners[ix].getgamma() * this.dTb * this.sref * this.sref / ponderar;
            ++countVar;
        }
    }

    public void make_mat_Afix(boolean flagrat) throws Exception {
        double xij;
        int con2;
        int con1;
        int ix;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        int jx = this.loads.length + this.geners.length;
        for (ix = this.loads.length; ix < jx; ++ix) {
            this.mat_A[this.VarNode[ix]][ix] = 1.0;
        }
        jx = 2 * this.loads.length + this.geners.length;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.mat_A[this.VarNode[ix]][this.loads.length + this.geners.length + ix] = -1.0;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.mat_A[this.numnod][this.loads.length + this.geners.length + ix] = 1.0;
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            xij = this.BranchX[ix];
            this.mat_A[this.numnod + 1 + ix][this.numgen + 2 * this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + 1 + ix][this.numgen + 2 * this.numload + con2] = -1.0 / xij;
            this.mat_A[this.numnod + 1 + this.numbran + ix][this.numgen + 2 * this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + 1 + this.numbran + ix][this.numgen + 2 * this.numload + con2] = -1.0 / xij;
        }
        int countRes = this.lines.length;
        for (ix = 0; ix < this.trafos.length; ++ix) {
            con1 = this.BranchI[countRes];
            con2 = this.BranchJ[countRes];
            xij = this.BranchX[countRes];
            this.mat_A[this.numnod + 1 + countRes][this.numgen + 2 * this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + 1 + countRes][this.numgen + 2 * this.numload + con2] = -1.0 / xij;
            this.mat_A[this.numnod + 1 + this.numbran + countRes][this.numgen + 2 * this.numload + con1] = 1.0 / xij;
            this.mat_A[this.numnod + 1 + this.numbran + countRes][this.numgen + 2 * this.numload + con2] = -1.0 / xij;
            ++countRes;
        }
        this.makeHSubMatrix();
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        int offVar2 = this.numvarEl;
        int offRes = this.numresEl;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrE[ix];
        }
        offVar += this.resEleGen.length;
        offVar2 += this.resHydUnit.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = 1.0;
            this.mat_A[offRes + ix][offVar2 + ix] = -this.mDrS[ix];
        }
        offVar = this.numvarEl;
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (jx = 0; jx < this.HCx[0].length; ++jx) {
                this.mat_A[offRes + ix][offVar + jx] = this.HCx[ix][jx];
            }
        }
        offVar += 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = this.mDbvE[ix];
        }
        offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.mat_A[offRes + ix][offVar + ix] = -this.mDfE[ix];
            this.mat_A[offRes + ix][offVar2 + ix] = 1.0;
        }
    }

    public void make_vec_RHS(boolean flagrat) {
        double aux;
        int ix;
        this.update_vec_RHS(true);
        int offVar = this.numvarEl;
        int offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.HCx.length; ++ix) {
            for (int jx = 0; jx < this.HCx[0].length; ++jx) {
                if (this.HCx[ix][jx] == 0.0) continue;
                this.vec_RHS[offRes + ix] = 0.0;
            }
        }
        offVar += 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] - 0.0;
        }
        int offVar2 = this.numvarEl + 2 * (this.resHydUnit.length + this.serHydUnit.length);
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length + this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            if (this.resHydUnit[ix].getFiltType() > 0) {
                this.vec_RHS[offRes + ix] = 0.0;
                aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
                int n = offRes + ix;
                this.vec_RHS[n] = this.vec_RHS[n] + this.resHydUnit[ix].getAvfiltf() * aux / this.dTb / 2.0 * this.dTb / 730.0;
                continue;
            }
            this.vec_RHS[offRes + ix] = 0.0;
        }
        offRes = this.numresEl + this.resEleGen.length + this.serEleGen.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            aux = (this.resHydUnit[ix].getSimVini() - this.resHydUnit[ix].getVmin()) * 1000.0 / 3.6;
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (aux / this.dTb + this.sumQAffl(this.resaff[ix]));
        }
        offRes += this.resHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + this.sumQAffl(this.seraff[ix]);
        }
        offRes += this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            int n = offRes + ix;
            this.vec_RHS[n] = this.vec_RHS[n] + (this.sumQAffl(this.irraff[ix]) - this.irrHydUnit[ix].getSpillmin());
        }
    }

    public void update_vec_RHS(boolean flagrat) {
        int count;
        int help;
        int ix;
        double dang;
        int i;
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        this.vec_RHS[this.numnod] = this.globalE * (this.sigma / 100.0);
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i + this.numload];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + this.numload];
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[i + this.numload + this.numgen];
        }
        for (i = 0; i < this.numload; ++i) {
            int n = this.numnod;
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + this.numload + this.numgen];
        }
        int off = this.numgen + 2 * this.numload;
        i = 0;
        while (i < this.numnod) {
            double transm = 0.0;
            for (int j = 0; j < this.numnod; ++j) {
                if (!(Math.abs(this.MatX[i][j]) > 0.0) || j == i) continue;
                dang = this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j];
                transm += this.MatG[i][j] / 2.0 * dang * dang + dang / this.MatX[i][j];
            }
            int n = i++;
            this.vec_RHS[n] = this.vec_RHS[n] + transm;
        }
        off = this.numgen + 2 * this.numload;
        if (SEEDS_Frame.n_TxLim == 1) {
            double xij;
            int con2;
            int con1;
            for (ix = 0; ix < this.lines.length; ++ix) {
                con1 = this.BranchI[ix];
                con2 = this.BranchJ[ix];
                xij = this.BranchX[ix];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                this.vec_RHS[this.numnod + 1 + ix] = this.lines[ix].getsmax() - dang / xij;
                help = this.lines[ix].sc == -1.0 ? 0 : 1;
                this.vec_RHS[this.numnod + 1 + this.numbran + ix] = -this.lines[ix].getsmax() * (double)help / this.sref - dang / xij;
            }
            count = this.numnod + 1 + this.numlin;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                con1 = this.BranchI[ix + this.numlin];
                con2 = this.BranchJ[ix + this.numlin];
                xij = this.BranchX[ix + this.numlin];
                dang = this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2];
                this.vec_RHS[count] = this.trafos[ix].getsmax() / this.sref - dang / xij;
                this.vec_RHS[this.numbran + count] = -this.trafos[ix].getsmax() / this.sref - dang / xij;
                ++count;
            }
        } else {
            for (ix = 0; ix < this.lines.length; ++ix) {
                this.vec_RHS[this.numnod + 1 + ix] = infTx;
                help = this.lines[ix].sc == -1.0 ? 0 : 1;
                this.vec_RHS[this.numnod + 1 + this.numbran + ix] = (double)(-help) * infTx;
            }
            count = this.numnod + 1 + this.numlin;
            for (ix = 0; ix < this.trafos.length; ++ix) {
                this.vec_RHS[count] = infTx;
                this.vec_RHS[this.numbran + count] = -infTx;
                ++count;
            }
        }
        int offVar = this.loads.length + this.injGen.length + this.thermalGen.length + this.ppEleGen.length;
        int offVar2 = this.numvarEl;
        int offRes = this.numnod + 1 + 2 * this.numbran;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = -this.vec_xtempabs[offVar + ix];
        }
        offVar += this.resEleGen.length;
        offVar2 += this.resHydUnit.length;
        offRes += this.resEleGen.length;
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.vec_RHS[offRes + ix] = -this.vec_xtempabs[offVar + ix];
        }
    }

    public void make_vec_Grad(boolean flagrat) {
        int i;
        for (i = 0; i < this.numgen + this.numload; ++i) {
            this.vec_Grad[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
        for (i = this.numgen + this.numload; i < this.numvar; ++i) {
            this.vec_Grad[i] = this.vec_c[i];
        }
    }

    public void make_mat_W(boolean flagrat) {
        int nn = this.numnod;
        int off = this.numgen + 2 * this.numload;
        this.mat_W = new double[this.numvarEl][this.numvarEl];
        for (int i = 0; i < off; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        for (int k = 0; k < nn; ++k) {
            if (this.vec_lam[k] < -1.0E-6) {
                System.out.println("Warning negative multiplier " + this.vec_lam[k] + " in restriction '" + k + "' or " + this.getSystemNames()[1][1][k]);
                continue;
            }
            if (this.vec_lam[k] < 0.0) continue;
            for (int j = 0; j < nn; ++j) {
                if (k == j || !(Math.abs(this.MatG[k][j]) > 1.0E-9)) continue;
                double[] dArray = this.mat_W[k + off];
                int n = k + off;
                dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray2 = this.mat_W[j + off];
                int n2 = j + off;
                dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray3 = this.mat_W[k + off];
                int n3 = j + off;
                dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[k][j];
                double[] dArray4 = this.mat_W[j + off];
                int n4 = k + off;
                dArray4[n4] = dArray4[n4] - this.vec_lam[k] * this.MatG[k][j];
            }
        }
    }

    public void makeAdd_mat_Avar(boolean flagrat) {
        int j;
        int i;
        int off = this.numgen + 2 * this.numload;
        this.mat_Avar = new double[this.numnod][this.numnod];
        if (SEEDS_Frame.n_LossMode == 0) {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 0.0) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - 1.0 / this.MatX[i][j];
                    double[] dArray2 = this.mat_Avar[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + 1.0 / this.MatX[i][j];
                }
            }
        } else {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 0.0) || i == j) continue;
                    double[] dArray = this.mat_Avar[i];
                    int n = i;
                    dArray[n] = dArray[n] - (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                    double[] dArray3 = this.mat_Avar[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + (this.MatG[i][j] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + 1.0 / this.MatX[i][j]);
                }
            }
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.mat_A[i][off + j] = this.mat_Avar[i][j];
            }
        }
    }

    private String[] getVarNames(boolean flagrat) {
        int ix;
        if (this.sVarNames != null) {
            return this.sVarNames;
        }
        int countVar = 0;
        this.sVarNames = new String[this.numvar];
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sVarNames[countVar] = "UE_" + this.loads[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.sVarNames[countVar] = "Gen_" + this.geners[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sVarNames[countVar] = "D_" + this.loads[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.sVarNames[countVar] = "Ang_" + this.busbars[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rtu_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Stu_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rsp_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Ssp_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Rft_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Sfl_" + this.serHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Isp_" + this.irrHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Ifl_" + this.irrHydUnit[ix].getName();
            ++countVar;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sVarNames[countVar] = "Vol_" + this.resHydUnit[ix].getName();
            ++countVar;
        }
        this.sVarNames[countVar] = "FCF";
        return this.sVarNames;
    }

    protected String[][][] getSystemNames(boolean flagrat) {
        int ix;
        if (this.sNames != null) {
            return this.sNames;
        }
        int count = 0;
        this.sNames = new String[2][0][0];
        this.sNames[0] = new String[2][this.numvar];
        this.sNames[1] = new String[2][this.numres];
        System.out.println("Each SP has N\u00b0 var: " + this.numvar + " N\u00b0 res: " + this.numres);
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sNames[0][0][count] = "Pu_Load";
            this.sNames[0][1][count] = this.loads[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.sNames[0][0][count] = "Pg_Gen";
            this.sNames[0][1][count] = this.geners[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.sNames[0][0][count] = "Pl_Load";
            this.sNames[0][1][count] = this.loads[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.busbars.length; ++ix) {
            this.sNames[0][0][count] = "Ang_Bus";
            this.sNames[0][1][count] = this.busbars[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qt_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qt_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Serie";
            this.sNames[0][1][count] = this.serHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qs_Irr";
            this.sNames[0][1][count] = this.irrHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "qf_Irr";
            this.sNames[0][1][count] = this.irrHydUnit[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[0][0][count] = "V_Reser";
            this.sNames[0][1][count] = this.resHydUnit[ix].getName();
            ++count;
        }
        this.sNames[0][0][count] = " ";
        this.sNames[0][1][count] = "EFCF";
        count = 0;
        for (ix = 0; ix < this.numnod; ++ix) {
            this.sNames[1][0][ix] = "CMg Bus";
            this.sNames[1][1][ix] = this.busbars[ix].getName();
            ++count;
        }
        this.sNames[1][0][this.numnod] = "CMg Global";
        this.sNames[1][1][this.numnod] = "Global";
        ++count;
        for (ix = 0; ix < this.lines.length; ++ix) {
            this.sNames[1][0][this.numnod + 1 + ix] = "CMg TxUp";
            this.sNames[1][1][this.numnod + 1 + ix] = this.lines[ix].getName().replace("-", "_").replace(">", "") + "_Up";
            this.sNames[1][0][this.numnod + 1 + this.numbran + ix] = "CMg TxDn";
            this.sNames[1][1][this.numnod + 1 + this.numbran + ix] = this.lines[ix].getName().replace("-", "_").replace(">", "") + "_Dn";
        }
        for (ix = 0; ix < this.trafos.length; ++ix) {
            this.sNames[1][0][this.numnod + 1 + this.numlin + ix] = "CMg TrafoUp";
            this.sNames[1][1][this.numnod + 1 + this.numlin + ix] = this.trafos[ix].getName().replace("-", "_").replace(">", "") + "_Up";
            this.sNames[1][0][this.numnod + 1 + this.numlin + this.numbran + ix] = "CMg TrafoDn";
            this.sNames[1][1][this.numnod + 1 + this.numlin + this.numbran + ix] = this.trafos[ix].getName().replace("-", "_").replace(">", "") + "_Dn";
        }
        count += 2 * this.numbran;
        for (ix = 0; ix < this.resEleGen.length; ++ix) {
            this.sNames[1][0][count] = "Reser e->h";
            this.sNames[1][1][count] = this.resEleGen[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.serEleGen.length; ++ix) {
            this.sNames[1][0][count] = "Serie e->h";
            this.sNames[1][1][count] = this.serEleGen[ix].getName();
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Reser Balance";
            this.sNames[1][1][count] = this.resHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Serie Balance";
            this.sNames[1][1][count] = this.serHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg irr deal";
            this.sNames[1][1][count] = this.irrHydUnit[ix].getName() + "_Bal";
            ++count;
        }
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.sNames[1][0][count] = "CMg Reser Filter";
            this.sNames[1][1][count] = this.resHydUnit[ix].getName() + "_Fil";
            ++count;
        }
        for (ix = 0; ix < this.sNames[1][1].length; ++ix) {
            this.sNames[1][1][ix] = this.sNames[1][1][ix].replaceAll(">", "");
        }
        return this.sNames;
    }

    public double make_cost(boolean flagrat) {
        int i;
        double cost = 0.0;
        int fr = 0;
        int to = this.numgen + this.numload;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        for (i = 0; i < this.geners.length; ++i) {
            cost += this.geners[i].getalpha() * this.dTb;
        }
        fr = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        to = fr + this.serHydUnit.length;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtemp[i] * this.vec_c[i];
        }
        fr = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + this.irrHydUnit.length;
        to = fr + this.irrHydUnit.length;
        for (i = fr; i < to; ++i) {
            cost += this.vec_xtemp[i] * this.vec_c[i];
        }
        return cost;
    }

    public void writeResults(boolean flagrat) throws Exception {
        double f21;
        double f12;
        double gmula;
        int con2;
        int con1;
        int ix = 0;
        double aux = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.loads.length; ++ix) {
            this.totunser += this.vec_xtempabs[ix] * this.sref;
            aux = this.loads[ix].getp();
            this.totdem += aux;
            this.loads[ix].setpini(aux);
            if (Math.abs(this.vec_xtempabs[ix] * this.sref) < 0.001) {
                this.loads[ix].setunser_p(0.0);
                continue;
            }
            this.loads[ix].setunser_p(this.vec_xtempabs[ix] * this.sref);
        }
        int off = this.loads.length;
        for (ix = 0; ix < this.geners.length; ++ix) {
            this.totgen += this.vec_xtempabs[ix + off] * this.sref;
            if (Math.abs(this.vec_xtempabs[ix + off] * this.sref) < 0.001) {
                this.geners[ix].setp(0.0);
                continue;
            }
            this.geners[ix].setp(this.vec_xtempabs[ix + off] * this.sref);
        }
        off += this.geners.length;
        for (ix = 0; ix < this.loads.length; ++ix) {
            System.out.println("Nombre: " + this.loads[ix].getName() + " - carga: " + this.vec_xtempabs[ix + off] * this.sref);
            this.loads[ix].setp0(this.vec_xtempabs[ix + off] * this.sref);
        }
        off += this.loads.length;
        for (ix = 0; ix < this.busbars.length; ++ix) {
            double angulin = this.vec_xtempabs[ix + off] * 180.0 / Math.PI;
            this.busbars[ix].setdelta2(angulin);
            double spotin = this.vec_lam[ix] / this.sref / this.dTb * ponderar;
            this.busbars[ix].setspot_p(spotin);
        }
        for (ix = 0; ix < this.lines.length; ++ix) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (Math.abs(this.BranchX[ix]) > 0.0) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                System.out.println("Too Low Reactance in lines: " + this.lines[ix].getName() + " with X=" + this.BranchX[ix]);
                f12 = 0.0;
                f21 = 0.0;
            }
            this.lines[ix].setp12(f12 / this.ActSchematic.getsref());
            this.lines[ix].setp21(f21 / this.ActSchematic.getsref());
        }
        int to = this.lines.length + this.trafos.length;
        while (ix < to) {
            con1 = this.BranchI[ix];
            con2 = this.BranchJ[ix];
            if (this.trafos[ix - this.lines.length].gett_re() > 1.0E-8) {
                this.BranchX[ix] = this.BranchX[ix] * this.trafos[ix - this.lines.length].gett_re();
                this.BranchR[ix] = this.BranchR[ix] * this.trafos[ix - this.lines.length].gett_re();
            }
            if (Math.abs(this.BranchX[ix]) > 0.0) {
                gmula = this.BranchR[ix] / (this.BranchR[ix] * this.BranchR[ix] + this.BranchX[ix] * this.BranchX[ix]);
                f12 = (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]));
                f21 = (this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]) / this.BranchX[ix] + gmula * (1.0 - Math.cos(this.vec_xtempabs[off + con2] - this.vec_xtempabs[off + con1]));
            } else {
                System.out.println("Too Low Reactance in lines: " + this.trafos[ix].getName() + " with X=" + this.BranchX[ix]);
                f12 = 0.0;
                f21 = 0.0;
            }
            this.trafos[ix - this.lines.length].setp12(f12 / this.ActSchematic.getsref());
            this.trafos[ix - this.lines.length].setp21(f21 / this.ActSchematic.getsref());
            ++ix;
        }
        off = this.loads.length + this.injGen.length + this.thermalGen.length;
        for (ix = 0; ix < this.ppHydUnit.length; ++ix) {
            this.ppHydUnit[ix].caudaffl = this.sumQAffl(this.ppaff[ix]);
            aux = this.ppHydUnit[ix].getWat2PowRate() <= 0.0 ? 0.0 : this.vec_xtempabs[off + ix] * this.sref / this.ppHydUnit[ix].getWat2PowRate();
            this.ppHydUnit[ix].caudgener = aux;
            this.ppHydUnit[ix].caudspill = this.ppHydUnit[ix].caudaffl - aux;
        }
        off = this.numvarEl;
        int off1 = this.numvarEl + this.resHydUnit.length + this.serHydUnit.length;
        int off2 = this.numvarEl + 2 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        int off3 = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length + 2 * this.irrHydUnit.length;
        for (ix = 0; ix < this.resHydUnit.length; ++ix) {
            this.resHydUnit[ix].caudaffl = this.sumQAffl(this.resaff[ix]);
            this.resHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.resHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
            this.resHydUnit[ix].caudfilt = this.vec_xtempabs[off2 + ix];
            this.resHydUnit[ix].Vfin = this.vec_xtempabs[off3 + ix] * (this.resHydUnit[ix].getVmax() - this.resHydUnit[ix].getVmin()) + this.resHydUnit[ix].getVmin();
            this.resHydUnit[ix].setSimVfin(this.resHydUnit[ix].Vfin);
        }
        off = this.numvarEl + this.resHydUnit.length;
        off1 = this.numvarEl + 2 * this.resHydUnit.length + this.serHydUnit.length;
        off2 = this.numvarEl + 3 * this.resHydUnit.length + 2 * this.serHydUnit.length;
        for (ix = 0; ix < this.serHydUnit.length; ++ix) {
            this.serHydUnit[ix].caudaffl = this.sumQAffl(this.seraff[ix]) + this.vec_xtempabs[off2 + ix];
            this.serHydUnit[ix].caudgener = this.vec_xtempabs[off + ix];
            this.serHydUnit[ix].caudspill = this.vec_xtempabs[off1 + ix];
            this.serHydUnit[ix].caudaFail = this.vec_xtempabs[off2 + ix];
        }
        off = this.numvarEl + 3 * this.resHydUnit.length + 3 * this.serHydUnit.length;
        off1 = off + this.irrHydUnit.length;
        off3 = this.numresEl + this.resEleGen.length + this.serEleGen.length + this.resHydUnit.length + this.serHydUnit.length;
        for (ix = 0; ix < this.irrHydUnit.length; ++ix) {
            this.irrHydUnit[ix].caudaffl = this.sumQAffl(this.irraff[ix]) + this.vec_xtempabs[off1 + ix];
            this.irrHydUnit[ix].caudaFail = this.vec_xtempabs[off1 + ix];
            this.irrHydUnit[ix].caudspill = this.vec_xtempabs[off + ix];
            this.irrHydUnit[ix].caudgener = this.irrHydUnit[ix].getSpillmin();
        }
    }

    public void setLoadLimits(int stage, int block) {
        for (int ix = 0; ix < this.loads.length; ++ix) {
            this.loads[ix].setlimits(stage, block);
        }
    }

    protected void setSigma(double value) {
        this.sigma = value;
    }
}

