/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import Acme.JPM.Encoders.GifEncoder;
import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.LineChart;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Tool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;

public class SEEDS_Result {
    private static String BINres = SEEDS_Tool.archivoBINres;
    private static String BINconv = SEEDS_Tool.archivoBINconv;
    private int[] convIter = null;
    private double[][][] convBnds = null;
    private double[][][][][][][] convCost = null;
    private double[][][][] convCuts = null;
    private String[] convNames = null;
    private String[][][] resNames = null;
    private double[][][][][][] resSols = null;
    private double[][][][] resCost = null;
    private double[] iniReser = null;
    private Object[][] Oaux;
    private Object[] Saux;
    private String titulo;
    private Hashtable<String, int[]> allNumb;
    protected int[] param;
    protected String[] typeVar;
    private SEEDS_Frame MySEEDSFrame = null;
    private JFileChooser chooser;
    private double[][] tempDouble;

    SEEDS_Result(SEEDS_Frame de) {
        this.MySEEDSFrame = de;
    }

    protected boolean isResults() {
        return this.resNames != null && this.resSols != null && this.resCost != null && this.iniReser != null;
    }

    protected boolean isBounds() {
        return this.convBnds != null;
    }

    protected boolean isIteCosts() {
        return this.convCost != null;
    }

    protected boolean isBendersCuts() {
        return this.convCuts != null;
    }

    protected void bringConver() {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(BINconv);
            ois = new ObjectInputStream(fis);
        }
        catch (Exception e) {
            System.out.println("Information not found");
        }
        try {
            this.convBnds = (double[][][])ois.readObject();
            this.convCost = (double[][][][][][][])ois.readObject();
            this.convCuts = (double[][][][])ois.readObject();
            this.convNames = (String[])ois.readObject();
            this.convIter = (int[])ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            try {
                fis.close();
                System.out.println("File is already open");
                e.printStackTrace();
            }
            catch (Exception ex) {
                System.out.println("File is already open");
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void bringResults() {
        this.allNumb = new Hashtable(20, 0.1f);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        this.param = new int[4];
        int[] a = null;
        try {
            fis = new FileInputStream(BINres);
            ois = new ObjectInputStream(fis);
        }
        catch (Exception e) {
            System.out.println("Information not found");
        }
        try {
            a = (int[])ois.readObject();
            this.resNames = (String[][][])ois.readObject();
            this.resSols = (double[][][][][][])ois.readObject();
            this.resCost = (double[][][][])ois.readObject();
            this.iniReser = (double[])ois.readObject();
            this.param[0] = this.resSols[0][0].length;
            this.param[1] = this.resSols[0][0][0][0].length;
            this.param[3] = this.resSols.length;
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            try {
                fis.close();
            }
            catch (Exception ex) {
                System.out.println("File is already open");
                ex.printStackTrace();
            }
        }
        if (a.length != 0) {
            SEEDS_Frame sEEDS_Frame = this.MySEEDSFrame;
            if (!sEEDS_Frame.mySEEDS_tool.isRat()) {
                this.allNumb.put("Puns", new int[]{0, a[0], 0});
                this.allNumb.put("Pter", new int[]{a[0], a[1], 0});
                this.allNumb.put("Pres", new int[]{a[0] + a[1] + a[9], a[5], 0});
                this.allNumb.put("Pser", new int[]{a[0] + a[1] + a[9] + a[5], a[6], 0});
                this.allNumb.put("Prun", new int[]{a[0] + a[1], a[9], 0});
                this.allNumb.put("Qtres", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2], a[7], 0});
                this.allNumb.put("Qtser", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7], a[8], 0});
                this.allNumb.put("Qsres", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8], a[7], 0});
                this.allNumb.put("Qsser", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7], a[8], 0});
                this.allNumb.put("Qfres", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8], a[7], 0});
                this.allNumb.put("Qfser", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7], a[8], 0});
                this.allNumb.put("Qtirr", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8], a[10], 0});
                this.allNumb.put("Qfirr", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10], a[10], 0});
                this.allNumb.put("Vres", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10] + a[10], a[7], 0});
                this.allNumb.put("Cbus", new int[]{0, a[2], 1});
                this.allNumb.put("Ctxs", new int[]{a[2], 2 * a[3] + 2 * a[4], 1});
                this.allNumb.put("Cres", new int[]{a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6], a[7], 1});
                this.allNumb.put("Cser", new int[]{a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7], a[8], 1});
                this.allNumb.put("Cirr", new int[]{a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7] + a[8], a[10], 1});
                this.allNumb.put("Cfil", new int[]{a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7] + a[8] + a[10], a[7], 1});
                this.allNumb.put("EFCF", new int[]{a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10] + a[10] + a[7], 1, 0});
                this.allNumb.put("ICF", new int[]{0, 1, 2});
                this.typeVar = new String[]{"ICF && EFCF", "ICF", "EFCF", "All generations", "P_uns Loads", "P_gen Thermals", "P_gen Reservoirs", "P_gen Series", "P_gen run of rivers", "All flows", "Reservoir flows", "Serie unit flows", "Irrigation deal flows", "Vol stored Reservoir", "Cmg buses", "Cmg transmission", "Cmg irrigation deals && filtrations", "Cmg serie && reservoir balances"};
                this.param[2] = a[11] + 1;
                System.out.println("Load last results successfully.");
                return;
            }
        }
        if (a.length == 0) return;
        this.allNumb.put("Puns", new int[]{0, a[0], 0});
        this.allNumb.put("Pter", new int[]{a[0], a[1], 0});
        this.allNumb.put("Pres", new int[]{a[0] + a[1] + a[9], a[5], 0});
        this.allNumb.put("Pser", new int[]{a[0] + a[1] + a[9] + a[5], a[6], 0});
        this.allNumb.put("Prun", new int[]{a[0] + a[1], a[9], 0});
        this.allNumb.put("Pload", new int[]{a[0] + a[1] + a[9] + a[5] + a[6], a[0], 0});
        this.allNumb.put("Qtres", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2], a[7], 0});
        this.allNumb.put("Qtser", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7], a[8], 0});
        this.allNumb.put("Qsres", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8], a[7], 0});
        this.allNumb.put("Qsser", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7], a[8], 0});
        this.allNumb.put("Qfres", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8], a[7], 0});
        this.allNumb.put("Qfser", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7], a[8], 0});
        this.allNumb.put("Qtirr", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8], a[10], 0});
        this.allNumb.put("Qfirr", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10], a[10], 0});
        this.allNumb.put("Vres", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10] + a[10], a[7], 0});
        this.allNumb.put("Cbus", new int[]{0, a[2], 1});
        this.allNumb.put("Ctxs", new int[]{1 + a[2], 2 * a[3] + 2 * a[4], 1});
        this.allNumb.put("Cres", new int[]{1 + a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6], a[7], 1});
        this.allNumb.put("Cser", new int[]{1 + a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7], a[8], 1});
        this.allNumb.put("Cirr", new int[]{1 + a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7] + a[8], a[10], 1});
        this.allNumb.put("Cfil", new int[]{1 + a[2] + 2 * a[3] + 2 * a[4] + a[5] + a[6] + a[7] + a[8] + a[10], a[7], 1});
        this.allNumb.put("EFCF", new int[]{2 * a[0] + a[1] + a[9] + a[5] + a[6] + a[2] + a[7] + a[8] + a[7] + a[8] + a[7] + a[8] + a[10] + a[10] + a[7], 1, 0});
        this.allNumb.put("ICF", new int[]{0, 1, 2});
        this.typeVar = new String[]{"ICF && EFCF", "ICF", "EFCF", "All generations", "P_uns Loads", "P_gen Thermals", "P_gen Reservoirs", "P_gen Series", "P_gen run of rivers", "All flows", "Reservoir flows", "Serie unit flows", "Irrigation deal flows", "Vol stored Reservoir", "Cmg buses", "Cmg transmission", "Cmg irrigation deals && filtrations", "Cmg serie && reservoir balances"};
        this.param[2] = a[11] + 1;
        System.out.println("Load last results successfully.");
    }

    protected double[][] getCuts(int sec, int stage) {
        double[][] cuts = null;
        if (sec < this.convCuts.length && this.convCuts[sec] != null && stage < this.convCuts[sec].length) {
            cuts = this.convCuts[sec][stage];
        }
        return cuts;
    }

    protected int getNSec() {
        int sec = 0;
        if (this.convCuts != null) {
            sec = this.convCuts.length;
        }
        return sec;
    }

    protected void convBounds() {
        int s;
        if (this.convBnds == null) {
            return;
        }
        int aux = 0;
        int i = 0;
        for (s = 0; s < this.convBnds.length; ++s) {
            aux += this.convIter[s];
        }
        this.Oaux = new Object[aux][5];
        this.Saux = new Object[this.Oaux[0].length];
        this.Saux[0] = "MP [N\u00b0]";
        this.Saux[1] = "Ite [N\u00b0]";
        this.Saux[2] = "Upper bound [MU$]";
        this.Saux[3] = "Lower bound [MU$]";
        this.Saux[4] = "Difference [%]";
        aux = 0;
        for (s = 0; s < this.convBnds.length; ++s) {
            for (i = 0; i < this.convIter[s]; ++i) {
                this.Oaux[aux][0] = s + 1;
                this.Oaux[aux][1] = i + 1;
                this.Oaux[aux][2] = SEEDS_Tool.df.format(this.convBnds[s][0][i]);
                this.Oaux[aux][3] = SEEDS_Tool.df.format(this.convBnds[s][1][i]);
                this.Oaux[aux][4] = Math.rint((this.convBnds[s][0][i] - this.convBnds[s][1][i]) / this.convBnds[s][0][i] * 100.0);
                ++aux;
            }
        }
        this.titulo = "Bounds evoution";
        JTable tabla = new JTable(this.Oaux, this.Saux);
        JScrollPane p = this.formatTable(tabla);
        this.launchOutput(p, this.titulo, -1);
        this.Oaux = null;
        this.Saux = null;
    }

    protected void convCosts() {
        int st;
        int s;
        if (this.convCost == null) {
            return;
        }
        int aux = 0;
        int aux2 = 0;
        for (s = 0; s < this.convCost.length; ++s) {
            aux += this.convCost[s][0].length;
            for (st = 1; st < this.convCost[s].length - 1; ++st) {
                aux += 2 * this.convCost[s][st].length;
            }
            aux += this.convCost[s][st].length;
            aux *= this.convIter[s];
            aux2 += (aux *= this.convCost[s][st][0][0][0][0].length);
            aux = 0;
        }
        this.Oaux = new Object[aux2][8];
        this.Saux = new Object[this.Oaux[0].length];
        this.Saux[0] = "MP [N\u00b0]";
        this.Saux[1] = "Ite [N\u00b0]";
        this.Saux[2] = "Stage";
        this.Saux[3] = "Hydro";
        this.Saux[4] = "Block";
        this.Saux[5] = "Mode";
        this.Saux[6] = "ICF";
        this.Saux[7] = "EFCF";
        aux = 0;
        for (s = 0; s < this.convCost.length; ++s) {
            for (int ite = 0; ite < this.convIter[s]; ++ite) {
                int bl;
                int hyd;
                for (st = 0; st < this.convCost[s].length - 1; ++st) {
                    for (hyd = 0; hyd < this.convCost[s][st].length; ++hyd) {
                        for (bl = 0; bl < this.convCost[s][st][hyd][ite][0][0].length; ++bl) {
                            this.Oaux[aux][0] = s + 1;
                            this.Oaux[aux][1] = ite + 1;
                            this.Oaux[aux][2] = st + 1;
                            this.Oaux[aux][3] = hyd + 1;
                            this.Oaux[aux][4] = bl + 1;
                            this.Oaux[aux][5] = "Fwd";
                            this.Oaux[aux][6] = SEEDS_Tool.df.format(this.convCost[s][st][hyd][ite][0][0][bl]);
                            this.Oaux[aux][7] = SEEDS_Tool.df.format(this.convCost[s][st][hyd][ite][0][1][bl]);
                            ++aux;
                        }
                    }
                }
                for (st = this.convCost[s].length - 1; st > 0; --st) {
                    for (hyd = 0; hyd < this.convCost[s][st].length; ++hyd) {
                        for (bl = 0; bl < this.convCost[s][st][hyd][ite][1][0].length; ++bl) {
                            this.Oaux[aux][0] = s + 1;
                            this.Oaux[aux][1] = ite + 1;
                            this.Oaux[aux][2] = st + 1;
                            this.Oaux[aux][3] = hyd + 1;
                            this.Oaux[aux][4] = bl + 1;
                            this.Oaux[aux][5] = "Bwd";
                            this.Oaux[aux][6] = SEEDS_Tool.df.format(this.convCost[s][st][hyd][ite][1][0][bl]);
                            this.Oaux[aux][7] = SEEDS_Tool.df.format(this.convCost[s][st][hyd][ite][1][1][bl]);
                            ++aux;
                        }
                    }
                }
            }
        }
        this.titulo = "First block costs evoution";
        JTable tabla = new JTable(this.Oaux, this.Saux);
        JScrollPane p = this.formatTable(tabla);
        this.launchOutput(p, this.titulo, -1);
        this.Oaux = null;
        this.Saux = null;
    }

    protected void convCuts() {
        int st;
        int s;
        if (this.convCuts == null) {
            return;
        }
        int aux = 0;
        for (s = 0; s < this.convCuts.length; ++s) {
            for (st = 0; st < this.convCuts[s].length; ++st) {
                aux += this.convCuts[s][st].length;
            }
        }
        if (aux < 1 || this.convCuts[0][0].length == 0) {
            return;
        }
        this.Oaux = new Object[aux][this.convCuts[0][0][0].length + 3];
        this.Saux = new Object[this.Oaux[0].length];
        this.Saux[0] = "MP [N\u00b0]";
        this.Saux[1] = "Stage";
        this.Saux[2] = "Cut [N\u00b0]";
        this.Saux[3] = "Y [MU$]";
        for (aux = 0; aux < this.convNames.length; ++aux) {
            this.Saux[4 + aux] = "S_" + (aux + 1) + "(" + this.convNames[aux] + ") [MU$/\u00b0/1]";
            this.Saux[4 + aux + this.convNames.length] = "X_" + (aux + 1) + "(" + this.convNames[aux] + ") [\u00b0/1]";
        }
        aux = 0;
        for (s = 0; s < this.convCuts.length; ++s) {
            int cut;
            int ite;
            for (st = 0; st < this.convCuts[s].length - 1; ++st) {
                for (ite = 0; ite < this.convCuts[s][st].length; ++ite) {
                    this.Oaux[aux][0] = s + 1;
                    this.Oaux[aux][1] = st + 1;
                    this.Oaux[aux][2] = ite + 1;
                    this.Oaux[aux][3] = SEEDS_Tool.df.format(this.convCuts[s][st][ite][0]);
                    for (cut = 0; cut < this.convNames.length; ++cut) {
                        this.Oaux[aux][4 + cut] = SEEDS_Tool.df.format(this.convCuts[s][st][ite][1 + cut]);
                        this.Oaux[aux][4 + cut + this.convNames.length] = SEEDS_Tool.df.format(this.convCuts[s][st][ite][1 + cut + this.convNames.length]);
                    }
                    ++aux;
                }
            }
            for (ite = 0; ite < this.convCuts[s][st].length; ++ite) {
                this.Oaux[aux][0] = s + 1;
                this.Oaux[aux][1] = st + 1;
                this.Oaux[aux][2] = 0;
                this.Oaux[aux][3] = this.convCuts[s][st][ite][0];
                for (cut = 0; cut < this.convNames.length; ++cut) {
                    this.Oaux[aux][4 + cut] = SEEDS_Tool.df.format(this.convCuts[s][st][ite][1 + cut]);
                    this.Oaux[aux][4 + cut + this.convNames.length] = SEEDS_Tool.df.format(this.convCuts[s][st][ite][1 + cut + this.convNames.length]);
                }
                ++aux;
            }
        }
        this.titulo = "Bender's cuts evolution";
        JTable tabla = new JTable(this.Oaux, this.Saux);
        JScrollPane p = this.formatTable(tabla);
        this.launchOutput(p, this.titulo, -1);
        this.Oaux = null;
        this.Saux = null;
    }

    protected String[] bringNames(int tipo) {
        String[] t = null;
        String[] var = null;
        var = this.var2Graph(tipo);
        int n1 = 0;
        int j = 0;
        if (tipo > 1) {
            int h1;
            for (h1 = 0; h1 < var.length; ++h1) {
                j += this.allNumb.get(var[h1])[1];
            }
            t = new String[j];
            j = 0;
            for (h1 = 0; h1 < var.length; ++h1) {
                n1 = this.allNumb.get(var[h1])[0];
                int n2 = this.allNumb.get(var[h1])[1];
                int n3 = this.allNumb.get(var[h1])[2];
                for (int h2 = n1; h2 < n1 + n2; ++h2) {
                    t[j] = this.resNames[n3][1][h2] + " [" + this.resNames[n3][0][h2] + "]";
                    ++j;
                }
            }
        } else if (tipo == 0) {
            t = new String[]{"ICF", "EFCF"};
        } else if (tipo == 1) {
            t = new String[]{"ICF"};
        }
        return t;
    }

    private void filterTable(int tipo, int s, int a, int b, int c, boolean isExp) {
        int st;
        int mp;
        int aux1 = 0;
        int aux2 = 0;
        for (mp = 0; mp < this.resSols.length; ++mp) {
            for (st = 0; st < this.resSols[mp][0].length; ++st) {
                for (int hyd = 0; hyd < this.resSols[mp][0][st].length; ++hyd) {
                    for (int bl = 0; bl < this.resSols[mp][0][st][hyd].length; ++bl) {
                        if (s != 0 && s != mp + 1 || a != 0 && a != st + 1 || b != 0 && b != hyd + 1 || c != 0 && c != bl + 1) continue;
                        ++aux1;
                    }
                }
            }
        }
        if (aux1 == 0) {
            System.out.println("Error reading solutions");
            return;
        }
        if (isExp) {
            for (mp = 0; mp < this.resSols.length; ++mp) {
                for (st = 0; st < this.resSols[mp][0].length; ++st) {
                    for (int bl = 0; bl < this.resSols[mp][0][st][0].length; ++bl) {
                        if (s != 0 && s != mp + 1 || a != 0 && a != st + 1 || c != 0 && c != bl + 1) continue;
                        ++aux2;
                    }
                }
            }
        } else {
            aux2 = aux1;
        }
        this.Oaux = null;
        this.Saux = null;
        String[] var = this.var2Table(tipo);
        if (isExp) {
            this.makeArrays(var, aux2, 3);
        } else {
            this.makeArrays(var, aux2, 4);
        }
        double[] tempD = new double[this.Oaux[0].length];
        this.tempDouble = new double[this.Oaux.length][this.Oaux[0].length];
        this.fillingNames(var, isExp);
        aux1 = -1;
        for (int mp2 = 0; mp2 < this.resSols.length; ++mp2) {
            for (int st2 = 0; st2 < this.resSols[mp2][0].length; ++st2) {
                for (int bl = 0; bl < this.resSols[mp2][0][st2][0].length; ++bl) {
                    for (int hyd = 0; hyd < this.resSols[mp2][0][st2].length; ++hyd) {
                        if (s != 0 && s != mp2 + 1 || a != 0 && a != st2 + 1 || b != 0 && b != hyd + 1 || c != 0 && c != bl + 1) continue;
                        tempD = this.fillingRows(mp2, st2, hyd, bl, var, isExp);
                        if (!isExp) {
                            this.tempDouble[++aux1][0] = tempD[0];
                            this.tempDouble[aux1][1] = tempD[1];
                            this.tempDouble[aux1][2] = tempD[2];
                            this.tempDouble[aux1][3] = tempD[3];
                            for (aux2 = 4; aux2 < tempD.length; ++aux2) {
                                this.tempDouble[aux1][aux2] = tempD[aux2];
                            }
                            continue;
                        }
                        if (hyd == 0) {
                            this.tempDouble[++aux1][0] = tempD[0];
                            this.tempDouble[aux1][1] = tempD[1];
                            this.tempDouble[aux1][2] = tempD[2];
                        }
                        for (aux2 = 3; aux2 < tempD.length; ++aux2) {
                            double[] dArray = this.tempDouble[aux1];
                            int n = aux2;
                            dArray[n] = dArray[n] + tempD[aux2] / (double)this.resSols[mp2][0][st2].length;
                        }
                    }
                }
            }
        }
        tipo = isExp ? 3 : 4;
        for (aux1 = 0; aux1 < this.Oaux.length; ++aux1) {
            for (aux2 = 0; aux2 < tipo; ++aux2) {
                this.Oaux[aux1][aux2] = (int)this.tempDouble[aux1][aux2];
            }
            for (aux2 = tipo; aux2 < this.Oaux[0].length; ++aux2) {
                this.Oaux[aux1][aux2] = SEEDS_Tool.df.format(this.tempDouble[aux1][aux2]);
            }
        }
    }

    private String[] var2Table(int type) {
        String[] var = null;
        switch (type) {
            case 1: {
                var = new String[]{"Pter", "Pres", "Pser", "Prun"};
                this.titulo = "Information about generation";
                break;
            }
            case 2: {
                var = new String[]{"Ctxs"};
                this.titulo = "Information about transmission";
                break;
            }
            case 3: {
                var = new String[]{"Puns"};
                this.titulo = "Information about unservice demand";
                break;
            }
            case 4: {
                var = new String[]{"ICF", "EFCF", "Cbus", "Cres", "Cser"};
                this.titulo = "Information about total and bus costs";
                break;
            }
            case 5: {
                var = new String[]{"Vres", "Cres", "Cfil"};
                this.titulo = "Information about reservoir balance && filtrations";
                break;
            }
            case 6: {
                var = new String[]{"Qtres", "Qsres", "Qfres", "Qtser", "Qsser", "Qfser"};
                this.titulo = "Information about water flows";
                break;
            }
            case 7: {
                var = new String[]{"Cirr", "Qsirr", "Qfirr"};
                this.titulo = "Information about irrigation deals";
                break;
            }
            case 8: {
                var = new String[]{"Pload"};
                this.titulo = "Information about load levels";
                break;
            }
            case 0: {
                var = new String[]{"ICF", "EFCF", "Pter", "Pres", "Pser", "Prun", "Puns", "Vres", "Qtres", "Qsres", "Qfres", "Qtser", "Qsser", "Qfser", "Qtirr", "Qfirr", "Cbus", "Ctxs", "Cres", "Cser", "Cirr", "Cfil"};
                this.titulo = "All variables, marginal costs and costs";
            }
        }
        return var;
    }

    private void makeArrays(String[] index, int rows, int b) {
        int j = b;
        for (int h = 0; h < index.length; ++h) {
            j += this.allNumb.get(index[h])[1];
        }
        this.Oaux = new Object[rows][j];
        this.Saux = new Object[j];
    }

    private void fillingNames(String[] index, boolean isExp) {
        this.Saux[0] = "MP [N\u00b0]";
        this.Saux[1] = "Stage";
        this.Saux[2] = "Block";
        this.Saux[3] = "Hydro";
        int j = 0;
        j = !isExp ? 4 : 3;
        for (int h = 0; h < index.length; ++h) {
            if (index[h].equalsIgnoreCase("ICF")) {
                this.Saux[j] = "ICF";
                ++j;
                continue;
            }
            int n1 = this.allNumb.get(index[h])[0];
            int n2 = this.allNumb.get(index[h])[1];
            int n3 = this.allNumb.get(index[h])[2];
            for (int i = n1; i < n1 + n2; ++i) {
                this.Saux[j] = this.resNames[n3][1][i] + " [" + this.resNames[n3][0][i] + "]";
                ++j;
            }
        }
    }

    private double[] fillingRows(int s, int t, int h, int b, String[] index, boolean isExp) {
        double[] aux = new double[this.Oaux[0].length];
        aux[0] = s + 1;
        aux[1] = t + 1;
        aux[2] = b + 1;
        aux[3] = h + 1;
        int j = 0;
        j = !isExp ? 4 : 3;
        for (int ll = 0; ll < index.length; ++ll) {
            int n3;
            int n2;
            int n1;
            if (index[ll].equalsIgnoreCase("ICF")) {
                aux[j] = this.resCost[s][t][h][b];
                ++j;
                continue;
            }
            if (index[ll].equalsIgnoreCase("EFCF")) {
                n1 = this.allNumb.get(index[ll])[0];
                n2 = this.allNumb.get(index[ll])[1];
                n3 = this.allNumb.get(index[ll])[2];
                aux[j] = this.resSols[s][n3][t][h][b][n1];
                ++j;
                continue;
            }
            n1 = this.allNumb.get(index[ll])[0];
            n2 = this.allNumb.get(index[ll])[1];
            n3 = this.allNumb.get(index[ll])[2];
            for (int i = n1; i < n1 + n2; ++i) {
                aux[j] = this.resSols[s][n3][t][h][b][i];
                ++j;
            }
        }
        return aux;
    }

    protected void saveTable(int tipo, int a1, int a2, int a3, int a4, boolean needExp) {
        String dondeGrabar = "salida.csv";
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.MySEEDSFrame);
        if (retorno == 0) {
            dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!dondeGrabar.substring(dondeGrabar.length() - 5, dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                dondeGrabar = dondeGrabar + ".csv";
            }
            this.filterTable(tipo, a1, a2, a3, a4, needExp);
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(dondeGrabar));
                String resp = "";
                for (int i = -1; i < this.Oaux.length; ++i) {
                    for (int j = 0; j < this.Oaux[0].length; ++j) {
                        resp = i == -1 ? resp + this.Saux[j] + "," : resp + this.Oaux[i][j] + ",";
                    }
                    pw.println(resp);
                    resp = "";
                }
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + ".csv was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + ".csv it's opened");
            }
            this.Oaux = null;
            this.Saux = null;
        }
    }

    protected void makeTable(int tipo, int a1, int a2, int a3, int a4, boolean needExp) {
        this.filterTable(tipo, a1, a2, a3, a4, needExp);
        JTable tabla = new JTable(this.Oaux, this.Saux);
        JScrollPane p = this.formatTable(tabla);
        this.launchOutput(p, this.titulo, -1);
        this.Oaux = null;
        this.Saux = null;
    }

    private JScrollPane formatTable(JTable t) {
        t.setAutoResizeMode(0);
        t.setPreferredScrollableViewportSize(new Dimension(800, 200));
        t.setFillsViewportHeight(true);
        t.setAutoCreateRowSorter(true);
        t.setSelectionMode(2);
        t.setCellSelectionEnabled(true);
        DefaultTableCellRenderer tcr1 = new DefaultTableCellRenderer();
        DefaultTableCellRenderer tcr2 = new DefaultTableCellRenderer();
        tcr1.setHorizontalAlignment(0);
        tcr2.setHorizontalAlignment(0);
        tcr1.setBackground(Color.lightGray);
        for (int i = 0; i < t.getColumnCount(); ++i) {
            t.getColumnModel().getColumn(i).setCellRenderer(tcr2);
            t.getColumnModel().getColumn(i).setHeaderRenderer(tcr1);
        }
        JScrollPane scrollPaneGen = new JScrollPane(t);
        scrollPaneGen.setOpaque(true);
        return scrollPaneGen;
    }

    private String[] var2Graph(int type) {
        String[] var = null;
        switch (type) {
            case 0: {
                var = new String[]{"ICF", "EFCF"};
                this.titulo = "Information from future and inmediate cost";
                break;
            }
            case 1: {
                var = new String[]{"ICF"};
                this.titulo = "Information from inmediate cost";
                break;
            }
            case 2: {
                var = new String[]{"EFCF"};
                this.titulo = "Information from future cost";
                break;
            }
            case 3: {
                var = new String[]{"Pter", "Pres", "Pser", "Prun", "Puns"};
                this.titulo = "Information from all kind generetion";
                break;
            }
            case 4: {
                var = new String[]{"Puns"};
                this.titulo = "Information from unservice demand";
                break;
            }
            case 5: {
                var = new String[]{"Pter"};
                this.titulo = "Information from thermal generation";
                break;
            }
            case 6: {
                var = new String[]{"Pres"};
                this.titulo = "Information from reservoir generation";
                break;
            }
            case 7: {
                var = new String[]{"Pser"};
                this.titulo = "Information from serie generation";
                break;
            }
            case 8: {
                var = new String[]{"Prun"};
                this.titulo = "Information from run of river generation";
                break;
            }
            case 9: {
                var = new String[]{"Qtres", "Qsres", "Qfres", "Qtser", "Qsser", "Qfser", "Qtirr", "Qfirr"};
                this.titulo = "Information from water flows";
                break;
            }
            case 10: {
                var = new String[]{"Qtres", "Qsres", "Qfres"};
                this.titulo = "Information from reservoir flows";
                break;
            }
            case 11: {
                var = new String[]{"Qtser", "Qsser", "Qfser"};
                this.titulo = "Information from serie unit flows";
                break;
            }
            case 12: {
                var = new String[]{"Qtirr", "Qfirr"};
                this.titulo = "Information from irrigation flows";
                break;
            }
            case 13: {
                var = new String[]{"Vres"};
                this.titulo = "Information from reservoir stored";
                break;
            }
            case 14: {
                var = new String[]{"Cbus"};
                this.titulo = "Information from bus marginal cost";
                break;
            }
            case 15: {
                var = new String[]{"Ctxs"};
                this.titulo = "Information from transmission marginal cost";
                break;
            }
            case 16: {
                var = new String[]{"Cirr", "Cfil"};
                this.titulo = "Information from irrigation deal && filtration marginal cost";
                break;
            }
            case 17: {
                var = new String[]{"Cres", "Cser"};
                this.titulo = "Information from serie units && reservoir balances marginal costs";
            }
        }
        return var;
    }

    private Chart buildGraph(int tipo, boolean u_d, int amount) {
        int h;
        double[][] Out = null;
        String[] Sout = null;
        String[] var = this.var2Graph(tipo);
        if (amount == 0) {
            if (tipo == 0) {
                amount = 2;
            } else if (tipo == 1) {
                amount = 1;
            } else {
                for (h = 0; h < var.length; ++h) {
                    amount += this.allNumb.get(var[h])[1];
                }
            }
            int aux = 0;
            for (int s = 0; s < this.resSols.length; ++s) {
                for (int st = 0; st < this.resSols[s][0].length; ++st) {
                    for (int hyd = 0; hyd < this.resSols[s][0][st].length; ++hyd) {
                        for (int bl = 0; bl < this.resSols[s][0][st][hyd].length; ++bl) {
                            ++aux;
                        }
                    }
                }
            }
            if ((amount *= aux) > 100) {
                amount = 100;
                System.out.println("Too much information, maximum is 100");
            }
        }
        Out = new double[1][amount];
        Sout = new String[Out[0].length];
        for (h = 0; h < Out[0].length; ++h) {
            Out[0][h] = u_d ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            Sout[h] = "";
        }
        for (int mp = 0; mp < this.resSols.length; ++mp) {
            for (int st = 0; st < this.resSols[mp][0].length; ++st) {
                for (int hyd = 0; hyd < this.resSols[mp][0][st].length; ++hyd) {
                    for (int bl = 0; bl < this.resSols[mp][0][st][hyd].length; ++bl) {
                        for (int h1 = 0; h1 < var.length; ++h1) {
                            int n1 = this.allNumb.get(var[h1])[0];
                            int n2 = this.allNumb.get(var[h1])[1];
                            int n3 = this.allNumb.get(var[h1])[2];
                            for (int h2 = n1; h2 < n1 + n2; ++h2) {
                                int h3;
                                for (h3 = Out[0].length - 1; h3 > -1 && !(u_d ? (var[h1].equalsIgnoreCase("ICF") ? this.resCost[mp][st][hyd][bl] < Out[0][h3] : this.resSols[mp][n3][st][hyd][bl][h2] < Out[0][h3]) : (var[h1].equalsIgnoreCase("ICF") ? this.resCost[mp][st][hyd][bl] > Out[0][h3] : this.resSols[mp][n3][st][hyd][bl][h2] > Out[0][h3])); --h3) {
                                }
                                if (h3 >= Out[0].length - 1) continue;
                                for (int h4 = Out[0].length - 1; h4 > h3 + 1; --h4) {
                                    Out[0][h4] = Out[0][h4 - 1];
                                    Sout[h4] = Sout[h4 - 1];
                                }
                                if (var[h1].equalsIgnoreCase("ICF")) {
                                    Out[0][h4] = this.resCost[mp][st][hyd][bl];
                                    Sout[h4] = "ICF [MP" + (mp + 1) + ",t" + (st + 1) + ",b" + (bl + 1) + ",h" + (hyd + 1) + "]";
                                    continue;
                                }
                                if (var[h1].equalsIgnoreCase("EFCF")) {
                                    Out[0][h4] = this.resSols[mp][n3][st][hyd][bl][h2];
                                    Sout[h4] = "EFCF [MP" + (mp + 1) + ",t" + (st + 1) + ",b" + (bl + 1) + ",h" + (hyd + 1) + "]";
                                    continue;
                                }
                                Out[0][h4] = this.resSols[mp][n3][st][hyd][bl][h2];
                                Sout[h4] = this.resNames[n3][1][h2] + " [" + this.resNames[n3][0][h2] + "] [MP" + (mp + 1) + ",t" + (st + 1) + ",b" + (bl + 1) + ",h" + (hyd + 1) + "]";
                            }
                        }
                    }
                }
            }
        }
        BarChart chart = new BarChart();
        chart.setSampleCount(Out[0].length);
        chart.setSampleValues(0, Out[0]);
        chart.setSampleLabels(Sout);
        chart = (BarChart)this.formatGraph(chart, 0);
        return chart;
    }

    private Chart buildGraph(int tipo, int a, int s) {
        int hyd;
        int h1;
        double[][] Out = null;
        String[] Sout = null;
        String[] var = this.var2Graph(tipo);
        int n1 = 0;
        int n2 = 0;
        int n3 = 0;
        int sce = Math.max(this.param[2], this.resSols[s][0][this.resSols[s][0].length - 1].length);
        for (h1 = 0; h1 < var.length; ++h1) {
            n1 = this.allNumb.get(var[h1])[0];
            n2 = this.allNumb.get(var[h1])[1];
            n3 = this.allNumb.get(var[h1])[2];
            if (a < n2) {
                ++h1;
                break;
            }
            a -= n2;
        }
        if (tipo == 13) {
            Out = new double[sce][this.param[0] * this.param[1] + 1];
            Sout = new String[this.param[0] * this.param[1] + 1];
        } else {
            Out = new double[sce][this.param[0] * this.param[1]];
            Sout = new String[this.param[0] * this.param[1]];
        }
        for (int st = 0; st < this.resSols[s][0].length; ++st) {
            int bl;
            for (hyd = 0; hyd < this.resSols[s][0][st].length; ++hyd) {
                for (bl = 0; bl < this.resSols[s][0][st][hyd].length; ++bl) {
                    if (var[h1 - 1].equalsIgnoreCase("ICF")) {
                        Out[hyd][st * this.param[1] + bl] = Math.rint(this.resCost[s][st][hyd][bl] * 100.0) / 100.0;
                    } else if (var[h1 - 1].equalsIgnoreCase("EFCF")) {
                        Out[hyd][st * this.param[1] + bl] = Math.rint(this.resSols[s][n3][st][hyd][bl][n1 + a] * 100.0) / 100.0;
                    } else if (var[h1 - 1].equalsIgnoreCase("Vres")) {
                        Out[hyd][st * this.param[1] + bl + 1] = Math.rint(this.resSols[s][n3][st][hyd][bl][n1 + a] * 1000.0) / 1000.0;
                    } else {
                        Out[hyd][st * this.param[1] + bl] = Math.rint(this.resSols[s][n3][st][hyd][bl][n1 + a] * 100.0) / 100.0;
                    }
                    if (hyd != 0) continue;
                    if (var[h1 - 1].equalsIgnoreCase("Vres")) {
                        Sout[st * this.param[1] + bl + 1] = "MP" + (s + 1) + "t" + (st + 1) + "b" + (bl + 1);
                        continue;
                    }
                    Sout[st * this.param[1] + bl] = "MP" + (s + 1) + "t" + (st + 1) + "b" + (bl + 1);
                }
            }
            while (hyd < sce) {
                for (bl = 0; bl < this.param[1]; ++bl) {
                    if (var[h1 - 1].equalsIgnoreCase("Vres")) {
                        Out[hyd][st * this.param[1] + bl + 1] = Double.NaN;
                        continue;
                    }
                    Out[hyd][st * this.param[1] + bl] = Double.NaN;
                }
                ++hyd;
            }
        }
        if (var[h1 - 1].equalsIgnoreCase("Vres")) {
            Sout[0] = "MP" + (s + 1) + "t" + 0;
            Out[0][0] = Math.rint(this.iniReser[a] * 1000.0) / 1000.0;
            for (hyd = 1; hyd < sce; ++hyd) {
                Out[hyd][0] = Double.NaN;
            }
        }
        LineChart chart = new LineChart();
        chart.setSeriesCount(Out.length);
        chart.setSampleCount(Sout.length);
        for (h1 = 0; h1 < Out.length; ++h1) {
            chart.setSampleValues(h1, Out[h1]);
        }
        chart.setSampleLabels(Sout);
        chart = (LineChart)this.formatGraph(chart, 1);
        return chart;
    }

    protected void makeGraph(int tipo, int a1, Object a2) {
        Chart grafo = null;
        int aux = 0;
        try {
            String s = a2.toString();
            aux = Integer.parseInt(s);
            if (aux == -1) {
                aux = 0;
            }
        }
        catch (Exception ex) {
            aux = 0;
        }
        if (a1 == 0 || a1 == 1) {
            boolean u_d = a1 == 0;
            grafo = this.buildGraph(tipo, u_d, aux);
            JScrollPane p = new JScrollPane(grafo);
            this.launchOutput(p, this.titulo, 1);
        } else {
            grafo = this.buildGraph(tipo, aux, a1 - 2);
            JScrollPane p = new JScrollPane(grafo);
            this.launchOutput(p, this.titulo, 1);
        }
    }

    protected void saveGraph(int tipo, int a1, Object a2) {
        Chart grafo = null;
        int aux = 0;
        try {
            String s = a2.toString();
            aux = Integer.parseInt(s);
            if (aux == -1) {
                aux = 0;
            }
        }
        catch (Exception ex) {
            aux = 0;
        }
        if (a1 == 0 || a1 == 1) {
            boolean u_d = a1 == 0;
            grafo = this.buildGraph(tipo, u_d, aux);
            grafo.setSize(600, (grafo.getSampleValues(0).length + 1) * 20);
            ((BarChart)grafo).setValueLabelStyle(0);
        } else {
            grafo = this.buildGraph(tipo, aux, a1 - 2);
            grafo.setSize(grafo.getSampleLabels().length * 40 + 60, 400);
            ((LineChart)grafo).setValueLabelStyle(1);
        }
        grafo.setSampleScrollerOn(false);
        grafo.setRangeAdjusterOn(0, false);
        this.convert2Gif(grafo);
    }

    private Chart formatGraph(Chart ch, int a) {
        Chart aux = null;
        if (a == 0) {
            BarChart chart = (BarChart)ch;
            chart.setSampleColor(0, Color.YELLOW.darker());
            chart.setBarLabelsOn(true);
            chart.setBarLabelStyle(0);
            chart.setValueLabelsOn(true);
            chart.setValueLabelStyle(2);
            chart.setFont("sampleLabelFont", new Font("Arial", 1, 11));
            chart.setRelativeRange(1.0);
            chart.setLowerRelativeRange(1.0);
            chart.setFont("rangeLabelFont", new Font("Arial", 1, 12));
            chart.setBarOutlineOn(true);
            chart.setBarAlignment(0);
            chart.set3DModeOn(true);
            chart.setChartForeground(Color.BLACK);
            chart.setForeground(Color.BLACK);
            chart.setChartBackground(Color.WHITE);
            chart.setBackground(Color.WHITE);
            chart.setRangeDecimalCount(0, 1);
            chart.setSampleDecimalCount(0, 2);
            chart.setSampleScrollerOn(true);
            chart.setRangeAdjusterOn(0, true);
            aux = chart;
        } else if (a == 1) {
            LineChart chart = (LineChart)ch;
            chart.setValueLabelsOn(true);
            chart.setValueLabelStyle(2);
            chart.setSampleLabelsOn(true);
            chart.setSampleLabelStyle(3);
            chart.setRelativeRange(1.0);
            chart.setLowerRelativeRange(1.0);
            chart.setMaxValueLineCount(6);
            chart.setSampleScrollerOn(true);
            chart.setFont("valueLabelFont", new Font("Arial", 1, 11));
            chart.setFont("rangeLabelFont", new Font("Arial", 1, 12));
            chart.setSampleHighlightOn(true);
            for (int i = 0; i < chart.getSeriesCount(); ++i) {
                if (i == 0) {
                    chart.setSampleHighlightOn(i, false);
                } else {
                    chart.setSampleHighlightStyle(i, 1, 4);
                    chart.setSeriesLineOn(i, false);
                    chart.setSampleColor(i, new Color(1658254));
                }
                chart.setSampleDecimalCount(i, 2);
                chart.setRangeAdjusterOn(i, true);
            }
            chart.setChartBackground(new Color(0xFFFCF1));
            chart.setBackground(new Color(0xFFFCF1));
            chart.setValueLinesOn(true);
            chart.setRangeDecimalCount(0, 2);
            aux = chart;
        }
        return aux;
    }

    private void convert2Gif(Chart pChart) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setDialogType(1);
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = this.getExtension(f);
                    if (extension != null && extension.equalsIgnoreCase("gif")) {
                        return true;
                    }
                }
                return false;
            }

            public String getExtension(File f) {
                String filename;
                int i;
                if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                    return filename.substring(i + 1).toLowerCase();
                }
                return null;
            }

            @Override
            public String getDescription() {
                return "GIF Image Files";
            }
        });
        int returnVal = this.chooser.showSaveDialog(this.MySEEDSFrame);
        if (returnVal == 0) {
            Cursor currCursor = this.MySEEDSFrame.getCursor();
            this.MySEEDSFrame.setCursor(new Cursor(3));
            File file2save = this.chooser.getSelectedFile();
            String filename = file2save.getName();
            int i = filename.lastIndexOf(46);
            if (i > 0 && i < filename.length() - 1) {
                if (!filename.substring(i + 1).equalsIgnoreCase("gif")) {
                    file2save = new File(file2save.getName() + ".gif");
                }
            } else {
                file2save = new File(file2save.getName() + ".gif");
            }
            if (!file2save.isAbsolute()) {
                file2save = new File(this.chooser.getCurrentDirectory().getPath() + "\\" + file2save.getName());
            }
            try {
                FileOutputStream out = new FileOutputStream(file2save);
                GifEncoder gif = new GifEncoder(pChart.getImage(pChart.getWidth(), pChart.getHeight()), (OutputStream)out);
                gif.encode();
                out.flush();
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.MySEEDSFrame, "Can't create output file", "Saving Gif File", 0);
            }
            this.MySEEDSFrame.setCursor(currCursor);
        }
    }

    private int cuantasVeces(String s, String sub) {
        int a = 0;
        int h = 0;
        int n = 0;
        while ((n = s.indexOf(sub, h)) != -1) {
            h = n + 1;
            ++a;
        }
        return a;
    }

    protected int hyd2Stage(int mp, int st) {
        return this.resSols[mp][0][st].length;
    }

    private void launchOutput(JScrollPane p, String s, int a) {
        DeepEdit.frame.chartSetUp();
        DeepEditFrame.myMChartFrame.addChart(s, p);
    }

    protected void loadScematic(int n_branch, int n_stage, int n_hydro, int n_block) {
        try {
            this.MySEEDSFrame.mySEEDS_tool.loadSSHB(this.resSols[n_branch][0][n_stage][n_hydro][n_block], this.resSols[n_branch][1][n_stage][n_hydro][n_block], this.resCost[n_branch][n_stage][n_hydro][n_block], n_branch, n_stage, n_block, n_hydro);
        }
        catch (Exception e) {
            System.out.println("Not compatibility between Schematic && results");
            e.printStackTrace();
        }
    }

    protected void filtrate(int tipo, int a1, int a2, int a3, int a4, boolean needExp) {
        this.filterTable(tipo, a1, a2, a3, a4, needExp);
    }

    protected double[][] getData() {
        return this.tempDouble;
    }

    protected Object[] getHeader() {
        return this.Saux;
    }

    protected void setHeader(Object[] head) {
        this.Saux = head;
    }

    protected void setData(Object[][] data2) {
        this.Oaux = data2;
    }

    protected void makeTable(String title) {
        JTable tabla = new JTable(this.Oaux, this.Saux);
        JScrollPane p = this.formatTable(tabla);
        this.launchOutput(p, title, -1);
        this.Oaux = null;
        this.Saux = null;
    }
}

