/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.Busbar;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.Trafo;
import de.core.comp;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Result;
import de.core.seeds.SEEDS_Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SEEDS_Rationing {
    private SEEDS_Frame MySEEDSFrame = null;
    private SEEDS_Tool myTool = null;
    private SEEDS_Result myResult;
    private JFileChooser chooser;
    private File OptFile = null;
    private File SimFile = null;
    private File MeasuresFile = null;
    Object[] help;
    private double tse;
    private double[] costos;
    private double[][] rawdata = null;
    private Object[] Headers = null;
    private Object[][] Data = null;
    private Schematic actSchem = null;
    int N;
    int B;
    int T;
    int nbus;
    int nloadbus;
    int tramos = 4;
    private Line[] lines;
    private Trafo[] trafos;
    private Busbar[] busbars;
    private Load[] loads;
    private Generator[] gens;
    private String[][][] bbload;
    private String[][] elements_names;
    private String[][][] strhead;
    private String[] busname;
    BufferedReader in;
    private Statement s;
    private Connection dbtrab;
    private double[][] costosENSoriginal;
    private double[][] costosENSnuevo;
    private double[] costosENS;
    private double beta;
    private double gamma;

    SEEDS_Rationing(SEEDS_Frame de) {
        this.MySEEDSFrame = de;
        this.myTool = de.mySEEDS_tool;
        this.actSchem = this.MySEEDSFrame.actSchem;
        this.dbtrab = DeepEditFrame.conSEEDSDB;
    }

    protected void getOptFile() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.MySEEDSFrame.actSchem.FileDir);
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.MySEEDSFrame);
        if (retorno == 0) {
            this.OptFile = this.chooser.getSelectedFile().getAbsoluteFile();
            this.MySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            System.out.println("" + this.chooser.getSelectedFile().getName() + " successfully loaded");
        }
    }

    protected void getSimFile() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.MySEEDSFrame.actSchem.FileDir);
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.MySEEDSFrame);
        if (retorno == 0) {
            this.SimFile = this.chooser.getSelectedFile().getAbsoluteFile();
            this.MySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            System.out.println("" + this.chooser.getSelectedFile().getName() + " successfully loaded");
        }
    }

    protected boolean orchestrateFirst() {
        try {
            this.originalBounds();
            this.cargarCostosENS(this.costosENSnuevo);
            this.myTool.runRationing(true);
            this.loadSeq(this.OptFile, "opt. file");
            this.optimize();
            this.myTool.busyThread();
            this.loadSeq(this.SimFile, "sim. file");
            this.simulate();
            this.myTool.busyThread();
            this.results(true);
            this.cargarCostosENS(this.costosENSoriginal);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean orchestrateMeasures() {
        try {
            this.cargarCostosENS(this.costosENSnuevo);
            this.myTool.runRationing(true);
            this.loadSeq(this.OptFile, "opt. file");
            this.reoptimize();
            this.myTool.busyThread();
            this.loadSeq(this.SimFile, "sim. file");
            this.resimulate();
            this.myTool.busyThread();
            this.results(false);
            this.cargarCostosENS(this.costosENSoriginal);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void loadSeq(File file, String type) {
        try {
            this.myTool.make2DBScSeqDef(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Problems loading " + type + " in Rationing Orchestration");
            return;
        }
    }

    protected void optimize() {
        this.help = this.MySEEDSFrame.getOptParam();
        try {
            this.myTool.toRun(1, -1, 1, Double.valueOf((String)this.help[1]), Integer.valueOf((String)this.help[2]), (Integer)this.help[3] == 1, (Integer)this.help[4] == 0, Double.valueOf((String)this.help[5]), Integer.valueOf((String)this.help[6]), (Boolean)this.help[7], (Boolean)this.help[8]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problems in rationing optimization");
            return;
        }
    }

    protected void simulate() {
        this.help = this.MySEEDSFrame.getOptParam();
        try {
            this.myTool.toRun(0, -1, 1, Double.valueOf((String)this.help[1]), Integer.valueOf((String)this.help[2]), (Integer)this.help[3] == 1, (Integer)this.help[4] == 0, Double.valueOf((String)this.help[5]), Integer.valueOf((String)this.help[6]), false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void reoptimize() {
        this.help = this.MySEEDSFrame.getOptParam();
        try {
            this.myTool.toRun(1, -1, 1, Double.valueOf((String)this.help[1]), Integer.valueOf((String)this.help[2]), (Integer)this.help[3] == 1, (Integer)this.help[4] == 0, Double.valueOf((String)this.help[5]), Integer.valueOf((String)this.help[6]), (Boolean)this.help[7], (Boolean)this.help[8]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problems in rationing optimization");
            return;
        }
    }

    protected void resimulate() {
        this.help = this.MySEEDSFrame.getOptParam();
        try {
            this.myTool.toRun(0, -1, 1, Double.valueOf((String)this.help[1]), Integer.valueOf((String)this.help[2]), (Integer)this.help[3] == 1, (Integer)this.help[4] == 0, Double.valueOf((String)this.help[5]), Integer.valueOf((String)this.help[6]), false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void results(boolean isIndex) {
        int aux2;
        int aux1;
        int n;
        Double[] doubleArray;
        int k;
        int j;
        int i;
        int cont = 0;
        int cont2 = 0;
        this.myResult = new SEEDS_Result(this.MySEEDSFrame);
        this.myResult.bringResults();
        this.myResult.filtrate(3, 0, 0, 0, 0, false);
        this.rawdata = this.myResult.getData();
        this.Headers = this.myResult.getHeader();
        this.tse = SEEDS_Tool.mydbm.getParam("Total System Energy");
        this.N = SEEDS_Frame.n_Seq;
        this.T = SEEDS_Frame.n_Stages;
        Double[][] estadistico = new Double[this.T * this.B][3];
        Double[][] profundidad = new Double[this.N * this.T * this.B][this.nloadbus];
        Double[][] busdeficit = new Double[this.N * this.T * this.B][this.nloadbus];
        Double[][][][] busdeficittramos = new Double[this.N * this.T * this.B][this.nloadbus][this.tramos][2];
        Double[][][] index = new Double[this.T * this.B][this.nloadbus][this.tramos];
        Double[][] max = new Double[this.T * this.B][this.nloadbus];
        int info = 2;
        double[] costosSim = new double[this.N];
        int[][] columnas1 = new int[this.bbload.length][0];
        String[][] col1loadname = new String[this.bbload.length][0];
        int[][] columnas2 = new int[this.nloadbus][this.tramos];
        this.busname = new String[this.nloadbus];
        int indice = 0;
        for (i = 0; i < this.busbars.length; ++i) {
            columnas1[i] = new int[this.bbload[i].length];
            col1loadname[i] = new String[this.bbload[i].length];
            if (this.bbload[i].length > 0) {
                this.busname[indice] = this.busbars[i].getName();
                ++indice;
            }
            for (j = 0; j < this.bbload[i].length; ++j) {
                for (k = 0; k < this.Headers.length; ++k) {
                    String straux;
                    String str = (String)this.Headers[k];
                    if (str.indexOf("[") == -1 || !this.bbload[i][j][0].matches(straux = str.substring(0, str.indexOf("[") - 1))) continue;
                    columnas1[i][j] = k;
                    col1loadname[i][j] = straux;
                }
            }
        }
        double[][][] loadpower = this.busload();
        for (i = 0; i < this.N * this.T * this.B; ++i) {
            cont = 0;
            for (j = 0; j < this.bbload.length; ++j) {
                if (this.bbload[j].length <= 0) continue;
                busdeficit[i][cont] = 0.0;
                for (k = 0; k < columnas1[j].length; ++k) {
                    doubleArray = busdeficit[i];
                    n = cont;
                    Double.valueOf(doubleArray[n] + this.rawdata[i][columnas1[j][k]]);
                }
                ++cont;
            }
        }
        for (i = 0; i < this.N * this.T * this.B; ++i) {
            for (j = 0; j < busdeficit[i].length; ++j) {
                double deficit = busdeficit[i][j];
                double ctotal = loadpower[j][i / this.B % this.T][i % this.B];
                double prodef = this.roundD(busdeficit[i][j] / loadpower[j][i / this.B % this.T][i % this.B] * 100.0, 1);
                if (deficit <= 0.0) {
                    for (k = 0; k < this.tramos; ++k) {
                        busdeficittramos[i][j][k][0] = 0.0;
                        busdeficittramos[i][j][k][1] = 0.0;
                    }
                } else if (0.0 < deficit && deficit < ctotal * 0.05) {
                    busdeficittramos[i][j][0][0] = deficit;
                    busdeficittramos[i][j][0][1] = 1.0;
                    for (k = 1; k < this.tramos; ++k) {
                        busdeficittramos[i][j][k][0] = 0.0;
                        busdeficittramos[i][j][k][1] = 0.0;
                    }
                } else if (ctotal * 0.05 < deficit && deficit < ctotal * 0.1) {
                    busdeficittramos[i][j][0][0] = ctotal * 0.05;
                    busdeficittramos[i][j][0][1] = 1.0;
                    busdeficittramos[i][j][1][0] = deficit - ctotal * 0.05;
                    busdeficittramos[i][j][1][1] = 1.0;
                    for (k = 2; k < this.tramos; ++k) {
                        busdeficittramos[i][j][k][0] = 0.0;
                        busdeficittramos[i][j][k][1] = 0.0;
                    }
                } else if (ctotal * 0.1 < deficit && deficit < ctotal * 0.2) {
                    busdeficittramos[i][j][0][0] = ctotal * 0.05;
                    busdeficittramos[i][j][0][1] = 1.0;
                    busdeficittramos[i][j][1][0] = ctotal * 0.05;
                    busdeficittramos[i][j][1][1] = 1.0;
                    busdeficittramos[i][j][2][0] = deficit - ctotal * 0.1;
                    busdeficittramos[i][j][2][1] = 1.0;
                    busdeficittramos[i][j][3][0] = 0.0;
                    busdeficittramos[i][j][3][1] = 0.0;
                } else if (deficit > ctotal * 0.2) {
                    busdeficittramos[i][j][0][0] = ctotal * 0.05;
                    busdeficittramos[i][j][0][1] = 1.0;
                    busdeficittramos[i][j][1][0] = ctotal * 0.05;
                    busdeficittramos[i][j][1][1] = 1.0;
                    busdeficittramos[i][j][2][0] = ctotal * 0.1;
                    busdeficittramos[i][j][2][1] = 1.0;
                    busdeficittramos[i][j][3][0] = deficit - ctotal * 0.2;
                    busdeficittramos[i][j][3][1] = 1.0;
                }
                profundidad[i][j] = prodef;
            }
        }
        for (i = 0; i < this.N * this.T * this.B; ++i) {
            for (j = 0; j < this.nloadbus; ++j) {
                for (k = 0; k < this.tramos; ++k) {
                    if (index[i % (this.T * this.B)][j][k] != null) {
                        doubleArray = index[i % (this.T * this.B)][j];
                        n = k;
                        Double.valueOf(doubleArray[n] + busdeficittramos[i][j][k][1]);
                        continue;
                    }
                    index[i % (this.T * this.B)][j][k] = busdeficittramos[i][j][k][1];
                }
            }
        }
        for (i = 0; i < this.N * this.T * this.B; ++i) {
            for (j = 0; j < this.nloadbus; ++j) {
                max[i % (this.T * this.B)][j] = max[i % (this.T * this.B)][j] == null ? profundidad[i][j] : Double.valueOf(Math.max(max[i % (this.T * this.B)][j], profundidad[i][j]));
            }
        }
        for (aux1 = 0; aux1 < this.T * this.B; ++aux1) {
            double totalload = 0.0;
            for (aux2 = 0; aux2 < this.nloadbus; ++aux2) {
                if (estadistico[aux1][0] == null) {
                    estadistico[aux1][0] = index[aux1][aux2][0] / (double)this.N * 100.0;
                    estadistico[aux1][1] = index[aux1][aux2][0] / (double)this.N * 100.0;
                    estadistico[aux1][2] = index[aux1][aux2][0] * loadpower[aux2][aux1 / this.B % this.T][aux1 % this.B];
                    totalload = loadpower[aux2][aux1 / this.B % this.T][aux1 % this.B];
                    continue;
                }
                estadistico[aux1][0] = Math.min(estadistico[aux1][0], index[aux1][aux2][0] / (double)this.N * 100.0);
                estadistico[aux1][1] = Math.max(estadistico[aux1][1], index[aux1][aux2][0] / (double)this.N * 100.0);
                Double[] i2 = estadistico[aux1];
                Double.valueOf(i2[2] + index[aux1][aux2][0] * loadpower[aux2][aux1 / this.B % this.T][aux1 % this.B]);
                totalload += loadpower[aux2][aux1 / this.B % this.T][aux1 % this.B];
            }
            estadistico[aux1][2] = estadistico[aux1][2] * 100.0 / ((double)this.N * totalload);
        }
        int ancho = info + this.nloadbus * 4;
        cont = 0;
        Object[] head = new Object[ancho];
        for (i = 0; i < info; ++i) {
            head[i] = this.Headers[i + 1];
            ++cont;
        }
        for (i = 0; i < this.busbars.length; ++i) {
            if (this.bbload[i].length <= 0) continue;
            for (j = 0; j < this.tramos; ++j) {
                head[cont] = "" + this.busbars[i].getName() + "_T" + (j + 1);
                columnas2[cont2][j] = cont++;
            }
            ++cont2;
        }
        this.Data = new Object[this.T * this.B][this.tramos * this.nloadbus + info];
        for (aux1 = 0; aux1 < this.T * this.B; ++aux1) {
            for (aux2 = 0; aux2 < info; ++aux2) {
                this.Data[aux1][aux2] = (int)this.rawdata[aux1][aux2 + 1];
            }
            for (aux2 = 0; aux2 < this.nloadbus; ++aux2) {
                for (int aux3 = 0; aux3 < this.tramos; ++aux3) {
                    this.Data[aux1][aux3 + aux2 * this.tramos + info] = this.roundD(index[aux1][aux2][aux3] / (double)this.N * 100.0, 1);
                }
            }
        }
        this.myResult.setHeader(head);
        this.myResult.setData(this.Data);
        if (isIndex) {
            this.myResult.makeTable("\u00cdNDICE (Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        } else {
            this.myResult.makeTable("\u00cdNDICE (Medidas: " + this.MeasuresFile.getName() + " - Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        }
        head = new Object[info + this.nloadbus];
        for (i = 0; i < head.length; ++i) {
            head[i] = i < info ? this.Headers[i + 1] : this.busname[i - info] + "_max%";
        }
        this.Data = new Object[this.T * this.B][info + this.nloadbus];
        for (aux1 = 0; aux1 < this.T * this.B; ++aux1) {
            for (aux2 = 0; aux2 < info; ++aux2) {
                this.Data[aux1][aux2] = (int)this.rawdata[aux1][aux2 + 1];
            }
            for (aux2 = 0; aux2 < this.nloadbus; ++aux2) {
                this.Data[aux1][aux2 + info] = max[aux1][aux2];
            }
        }
        this.myResult.setHeader(head);
        this.myResult.setData(this.Data);
        if (isIndex) {
            this.myResult.makeTable("PROFUNDIDAD (Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        } else {
            this.myResult.makeTable("PROFUNDIDAD (Medidas: " + this.MeasuresFile.getName() + " - Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        }
        head = new Object[info + 3];
        for (i = 0; i < info; ++i) {
            if (i >= info) continue;
            head[i] = this.Headers[i + 1];
        }
        head[info] = "Index MIN";
        head[info + 1] = "Index MAX";
        head[info + 2] = "Index WAVE";
        this.Data = new Object[this.T * this.B][info + 3];
        for (aux1 = 0; aux1 < this.T * this.B; ++aux1) {
            for (aux2 = 0; aux2 < info; ++aux2) {
                this.Data[aux1][aux2] = (int)this.rawdata[aux1][aux2 + 1];
            }
            for (aux2 = 0; aux2 < estadistico[aux1].length; ++aux2) {
                this.Data[aux1][aux2 + info] = this.roundD(estadistico[aux1][aux2], 1);
            }
        }
        this.myResult.setHeader(head);
        this.myResult.setData(this.Data);
        if (isIndex) {
            this.myResult.makeTable("ESTADISTICOS (Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        } else {
            this.myResult.makeTable("ESTADISTICOS (Medidas: " + this.MeasuresFile.getName() + " - Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        }
        this.myResult.filtrate(8, 0, 0, 0, 0, false);
        if (isIndex) {
            this.myResult.makeTable("CARGAS (Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        } else {
            this.myResult.makeTable("CARGAS (Medidas: " + this.MeasuresFile.getName() + " - Simulaci\u00f3n: " + this.SimFile.getName() + " - Optimizaci\u00f3n: " + this.OptFile.getName() + ")");
        }
        costosSim = this.myTool.returnCostMonte();
        double costoaux = 0.0;
        for (int i3 = 0; i3 < costosSim.length; ++i3) {
            costoaux += costosSim[i3];
        }
        System.out.println("costo esperado: " + costoaux / (double)this.N);
    }

    private double[][][] busload() {
        int cont = 0;
        int cont2 = 0;
        for (int i = 0; i < this.bbload.length; ++i) {
            if (this.bbload[i].length <= 0) continue;
            ++cont;
        }
        double[][][] results = new double[cont][][];
        for (int e = 0; e < this.busname.length; ++e) {
            for (int i = 0; i < this.bbload.length; ++i) {
                if (!this.elements_names[2][i].matches(this.busname[e])) continue;
                double[][][] doubleaux = new double[this.bbload[i].length][][];
                for (int j = 0; j < this.bbload[i].length; ++j) {
                    try {
                        doubleaux[j] = SEEDS_Tool.mydbm.getLoadValues(this.bbload[i][j][0]);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[cont2] = new double[doubleaux[0].length][doubleaux[0][0].length];
                for (int k = 0; k < doubleaux[0].length; ++k) {
                    for (int l = 0; l < doubleaux[0][0].length; ++l) {
                        for (int j = 0; j < doubleaux.length; ++j) {
                            double[] dArray = results[cont2][k];
                            int n = l;
                            dArray[n] = dArray[n] + doubleaux[j][k][l];
                        }
                    }
                }
                ++cont2;
            }
        }
        return results;
    }

    private String[] getcargas(String barra) {
        int index;
        String[] straux = null;
        for (index = 0; index < this.elements_names[2].length && !this.elements_names[2][index].matches(barra); ++index) {
        }
        for (int i = 0; i < this.bbload[index].length; ++i) {
            straux[i] = this.bbload[index][i][0];
        }
        return straux;
    }

    private int getposload(String load) {
        int auxiliar = -1;
        for (int i = 0; i < this.elements_names[3].length; ++i) {
            if (!this.elements_names[3][i].matches(load)) continue;
            auxiliar = i;
        }
        return auxiliar;
    }

    private double roundD(double d, int c) {
        double temp = d * Math.pow(10.0, c);
        long tempint = Math.round(temp);
        temp = tempint;
        return temp / Math.pow(10.0, c);
    }

    private void getSchemInfo() throws Exception {
        int i;
        int ix;
        Vector<comp> lineVec = new Vector<comp>(70);
        Vector<comp> trafoVec = new Vector<comp>(20);
        Vector<comp> busbarVec = new Vector<comp>(70);
        Vector<comp> loadVec = new Vector<comp>(70);
        Vector<comp> genVec = new Vector<comp>(70);
        Object TempLine = null;
        this.nloadbus = 0;
        for (ix = 0; ix < this.actSchem.Components.size(); ++ix) {
            comp tempcomp = (comp)this.actSchem.Components.elementAt(ix);
            if (!tempcomp.getinservice() || !tempcomp.getactive()) continue;
            if (tempcomp instanceof Line) {
                lineVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Trafo) {
                trafoVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Busbar) {
                busbarVec.add(tempcomp);
                continue;
            }
            if (tempcomp instanceof Load) {
                loadVec.add(tempcomp);
                continue;
            }
            if (!(tempcomp instanceof Generator)) continue;
            genVec.add(tempcomp);
        }
        this.elements_names = new String[5][0];
        this.lines = new Line[lineVec.size()];
        this.elements_names[0] = new String[lineVec.size()];
        for (ix = 0; ix < lineVec.size(); ++ix) {
            this.lines[ix] = (Line)lineVec.elementAt(ix);
            this.elements_names[0][ix] = this.lines[ix].getName();
        }
        this.trafos = new Trafo[trafoVec.size()];
        this.elements_names[1] = new String[trafoVec.size()];
        for (ix = 0; ix < trafoVec.size(); ++ix) {
            this.trafos[ix] = (Trafo)trafoVec.elementAt(ix);
            this.elements_names[1][ix] = this.trafos[ix].getName();
        }
        this.busbars = new Busbar[busbarVec.size()];
        this.elements_names[2] = new String[busbarVec.size()];
        for (ix = 0; ix < busbarVec.size(); ++ix) {
            this.busbars[ix] = (Busbar)busbarVec.elementAt(ix);
            this.elements_names[2][ix] = this.busbars[ix].getName();
        }
        this.loads = new Load[loadVec.size()];
        this.elements_names[3] = new String[loadVec.size()];
        for (ix = 0; ix < loadVec.size(); ++ix) {
            this.loads[ix] = (Load)loadVec.elementAt(ix);
            this.elements_names[3][ix] = this.loads[ix].getName();
        }
        this.gens = new Generator[genVec.size()];
        this.elements_names[4] = new String[genVec.size()];
        for (ix = 0; ix < genVec.size(); ++ix) {
            this.gens[ix] = (Generator)genVec.elementAt(ix);
            this.elements_names[4][ix] = this.gens[ix].getName();
        }
        this.bbload = new String[this.busbars.length][0][0];
        String[] straux = new String[this.loads.length];
        int[] intaux = new int[this.loads.length];
        for (i = 0; i < this.busbars.length; ++i) {
            int a = 0;
            for (int j = 0; j < this.loads.length; ++j) {
                if (this.busbars[i].InformOutput(this.loads[j]) == -1) continue;
                straux[a] = this.loads[j].getName();
                intaux[a] = this.busbars[i].InformOutput(this.loads[j]);
                ++a;
            }
            this.bbload[i] = new String[a][2];
            for (int k = 0; k < a; ++k) {
                this.bbload[i][k][0] = straux[k];
                this.bbload[i][k][1] = "" + intaux[k];
            }
        }
        for (i = 0; i < this.bbload.length; ++i) {
            if (this.bbload[i].length == 0) continue;
            ++this.nloadbus;
        }
    }

    protected boolean verify() {
        boolean flag3 = false;
        boolean flag = true;
        boolean flag2 = false;
        boolean cont = false;
        int cont2 = 0;
        int counter = 0;
        this.T = -1;
        File file = null;
        this.myTool.runRationing(true);
        try {
            this.getSchemInfo();
            if (counter < 1) {
                this.guardarCostosENS();
                ++counter;
            }
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            return flag;
        }
        if (this.OptFile == null && this.SimFile == null) {
            flag = false;
            flag2 = false;
            System.out.println("There is no Optimization Sequences File");
            System.out.println("There is no Simulation Sequences File");
        } else {
            if (this.SimFile != null && this.OptFile != null) {
                flag = true;
                file = this.SimFile;
            } else if (this.SimFile == null && this.OptFile != null) {
                flag = false;
                System.out.println("There is no Simulation Sequences File");
                file = this.OptFile;
            } else if (this.OptFile == null && this.SimFile != null) {
                flag = false;
                System.out.println("There is no Optimization Sequences File");
                file = this.SimFile;
            }
            this.T = this.getInfoCSV(file, 1, 2);
            this.B = this.getInfoCSV(file, 2, 2);
            if (this.T != -1) {
                flag2 = true;
            }
        }
        cont2 = 0;
        if (flag2) {
            for (int i = 0; i < this.bbload.length; ++i) {
                if (this.bbload[i].length <= 0) continue;
                for (int j = 0; j < this.gens.length; ++j) {
                    if (this.busbars[i].InformInput(this.gens[j]) != -1 && this.gens[j].getName().indexOf("_CF") == -1) continue;
                }
            }
            if (cont2 > 0) {
                flag = false;
            }
        }
        this.calcularCostoENS();
        return flag;
    }

    private int getInfoCSV(File file, int row, int column) {
        String lineText = null;
        int st = -1;
        try {
            this.in = new BufferedReader(new FileReader(file));
            for (int aux = 0; aux < row; ++aux) {
                lineText = this.in.readLine();
            }
            if (lineText != null) {
                String[] line = lineText.split(",");
                st = Integer.parseInt(line[column - 1]);
            }
        }
        catch (Exception ex) {
            System.out.println("Problems with File " + file.getName());
            ex.printStackTrace();
            return st;
        }
        return st;
    }

    private double[] aproxDefFun() {
        double[] param = new double[2];
        return param;
    }

    private void originalBounds() {
        this.myTool.initializeSigmas(this.T, this.B);
        for (int i = 0; i < this.loads.length; ++i) {
            for (int j = 0; j < this.T; ++j) {
                for (int k = 0; k < this.B; ++k) {
                    this.loads[i].initializelimits(this.T, this.B);
                }
            }
        }
    }

    protected void makeLoadMan() {
        int cont = 0;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.MySEEDSFrame.actSchem.FileDir);
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.MySEEDSFrame);
        if (retorno == 0) {
            String dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!dondeGrabar.substring(dondeGrabar.length() - 4, dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                dondeGrabar = dondeGrabar + ".csv";
            }
            try {
                int j;
                int i;
                PrintWriter pw = new PrintWriter(new FileWriter(dondeGrabar));
                String resp = "Stage,Block,Sigma";
                for (i = 0; i < this.bbload.length; ++i) {
                    for (j = 0; j < this.bbload[i].length; ++j) {
                        resp = resp + "," + this.bbload[i][j][0] + "_alpha";
                        resp = resp + "," + this.bbload[i][j][0] + "_beta";
                        cont += 2;
                    }
                }
                pw.println(resp);
                resp = "";
                for (i = 0; i < this.T; ++i) {
                    for (j = 0; j < this.B; ++j) {
                        resp = "" + (i + 1) + "," + (j + 1) + ",100";
                        for (int k = 0; k < cont; ++k) {
                            resp = resp + ",100";
                        }
                        pw.println(resp);
                    }
                }
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + " it's opened");
            }
        }
    }

    protected boolean loadLoadMan() {
        String[] line = null;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(this.MySEEDSFrame.actSchem.FileDir);
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.MySEEDSFrame);
        if (retorno == 0) {
            this.MeasuresFile = this.chooser.getSelectedFile().getAbsoluteFile();
            this.MySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            String[] nombres = new String[this.loads.length];
            int[] posicionalpha = new int[this.loads.length];
            try {
                this.in = new BufferedReader(new FileReader(this.MeasuresFile));
            }
            catch (Exception p) {
                System.out.println("File name was wrong.");
                return false;
            }
            try {
                int i;
                String lineText = this.in.readLine();
                if (lineText != null) {
                    line = lineText.split(",");
                    if (line.length != 2 * this.loads.length + 3) {
                        System.out.println("Bad format in file.");
                        return false;
                    }
                } else {
                    System.out.println("Bad format in file.");
                    return false;
                }
                for (i = 0; i < this.loads.length; ++i) {
                    nombres[i] = this.loads[i].getName();
                    for (int j = 3; j < line.length; ++j) {
                        int indice = line[j].indexOf("_alpha");
                        if (indice == -1 || !line[j].substring(0, indice).matches(nombres[i])) continue;
                        posicionalpha[i] = j;
                    }
                }
                while ((lineText = this.in.readLine()) != null) {
                    line = lineText.split(",");
                    this.myTool.defineSigmas(Integer.parseInt(line[0]) - 1, Integer.parseInt(line[1]) - 1, Double.parseDouble(line[2]));
                    for (i = 0; i < this.loads.length; ++i) {
                        this.loads[i].fill_limits(Integer.parseInt(line[0]) - 1, Integer.parseInt(line[1]) - 1, Double.parseDouble(line[posicionalpha[i]]), Double.parseDouble(line[posicionalpha[i] + 1]));
                    }
                }
                System.out.println("" + this.MeasuresFile.getName() + " successfully loaded");
                this.in.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Information not found");
                return false;
            }
        }
        return false;
    }

    private void guardarCostosENS() {
        this.costosENSoriginal = new double[this.loads.length][2];
        for (int i = 0; i < this.loads.length; ++i) {
            this.costosENSoriginal[i][0] = this.loads[i].beta;
            this.costosENSoriginal[i][1] = this.loads[i].gamma;
        }
    }

    private void cargarCostosENS(double[][] param) {
        for (int i = 0; i < this.loads.length; ++i) {
            this.loads[i].beta = param[i][0];
            this.loads[i].gamma = param[i][1];
        }
    }

    private void calcularCostoENS() {
        double[] e = new double[4];
        double[] c = new double[4];
        try {
            int i;
            this.costosENS = this.MySEEDSFrame.getCFcosts();
            e[0] = 0.05;
            e[1] = 0.1;
            e[2] = 0.2;
            e[3] = 1.0;
            for (i = 0; i < c.length; ++i) {
                c[i] = i == 0 ? e[0] * this.costosENS[0] : c[i - 1] + (e[i] - e[i - 1]) * this.costosENS[i];
            }
            this.beta = this.roundD((c[3] - c[2] * Math.pow(e[3], 2.0) / Math.pow(e[2], 2.0)) / (e[3] - Math.pow(e[3], 2.0) / e[2]), 3);
            this.gamma = this.roundD((c[3] - c[2] * e[3] / e[2]) / (Math.pow(e[3], 2.0) - e[3] * e[2]) * e[3], 3);
            this.costosENSnuevo = new double[this.loads.length][2];
            for (i = 0; i < this.loads.length; ++i) {
                this.costosENSnuevo[i][0] = this.beta;
                this.costosENSnuevo[i][1] = this.gamma;
            }
        }
        catch (Exception ex) {
            this.beta = 484.5;
            this.gamma = 66.384;
            System.out.println("Error in unserved energy costs. Original beta and normalized gamma will be used");
            ex.printStackTrace();
            return;
        }
    }
}

