/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.Load;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SEEDS_LoadManager {
    private Connection dbtrab;
    private SEEDS_Frame mySEEDSFrame = null;
    private Statement s;
    private JFileChooser chooser;
    private String dondeGrabar = "Loads_Manager";

    SEEDS_LoadManager(SEEDS_Frame ff, Connection cc) {
        this.mySEEDSFrame = ff;
        this.dbtrab = cc;
    }

    protected void makeLoadsManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            try {
                int i = 0;
                int j = 0;
                boolean h = false;
                PrintWriter pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Number,Demand";
                for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                    resp = resp + ",B" + (i + 1) + "_Energy_Portion";
                }
                pw.println(resp);
                resp = "[N\u00b0],[Name]";
                for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                    resp = resp + ",[%]";
                }
                pw.println(resp);
                Vector loadsVec = SEEDS_Tool.mydbm.getLoadsVector();
                double aux = 100 / loadsVec.size();
                for (j = 0; j < loadsVec.size(); ++j) {
                    resp = j + 1 + "," + ((Load)loadsVec.elementAt(j)).getName();
                    for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                        resp = resp + "," + aux;
                    }
                    pw.println(resp);
                }
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + " it's opened");
            }
        }
    }

    protected void editLoadsManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            int i = 0;
            ResultSet r = null;
            PrintWriter pw = null;
            try {
                this.s = this.dbtrab.createStatement();
                r = this.s.executeQuery("SELECT * FROM Loads_Manager ORDER BY Numbers ASC");
                pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Number,Demand";
                for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                    resp = resp + ",B" + (i + 1) + "_Energy_Portion";
                }
                pw.println(resp);
                resp = "[N\u00b0],[Name]";
                for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                    resp = resp + ",[%]";
                }
                pw.println(resp);
                while (r.next()) {
                    resp = r.getInt(1) + "," + r.getString(2);
                    for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                        try {
                            resp = resp + "," + r.getDouble(i + 3);
                            continue;
                        }
                        catch (Exception ezx) {
                            resp = resp + ",0.0";
                        }
                    }
                    pw.println(resp);
                }
                r.close();
                this.s.close();
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + " it's opened.");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLoadsManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            File file = this.chooser.getSelectedFile().getAbsoluteFile();
            this.mySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            try {
                BufferedReader in;
                int i = 0;
                try {
                    in = new BufferedReader(new FileReader(file));
                }
                catch (Exception p) {
                    System.out.println("File name was wrong.");
                    return;
                }
                String lineText = in.readLine();
                String[] line = null;
                if (lineText == null) {
                    System.out.println("Bad format in file.");
                    return;
                }
                line = lineText.split(",");
                this.s = this.dbtrab.createStatement();
                try {
                    this.s.executeUpdate("DELETE FROM Loads_Manager");
                }
                catch (Exception e) {
                    lineText = "CREATE TABLE Loads_Manager (Numbers SMALLINT, Demand VARCHAR(25)";
                    for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                        lineText = lineText + ",B" + (i + 1) + "_Eportion" + " DOUBLE";
                    }
                    lineText = lineText + ")";
                    this.s.executeUpdate(lineText);
                }
                finally {
                    try {
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanal_1B");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanal_2B");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanal_3B");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanal_4B");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanal_5B");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Cargas");
                        this.s.executeUpdate("DROP TABLE Dem_FCDC_Semanas");
                        this.s.executeUpdate("DROP TABLE Demanda_Anual");
                    }
                    catch (Exception e) {}
                }
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",");
                    lineText = "INSERT INTO Loads_Manager VALUES ('" + line[0].trim() + "','" + line[1].trim() + "'";
                    for (i = 0; i < SEEDS_Frame.n_Blocks; ++i) {
                        lineText = lineText + "," + line[i + 2].trim();
                    }
                    lineText = lineText + ")";
                    this.s.executeUpdate(lineText);
                }
                System.out.println("Load Loads_Manager correctly.");
                this.s.close();
                this.dbtrab.commit();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Information not found");
            }
        }
    }
}

