/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.hdb_affl;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SEEDS_HydroManager {
    private Connection dbtrab;
    private SEEDS_Frame mySEEDSFrame = null;
    private Statement s;
    private JFileChooser chooser;
    private String dondeGrabar = "Hydro_Manager";

    SEEDS_HydroManager(SEEDS_Frame ff, Connection cc) {
        this.mySEEDSFrame = ff;
        this.dbtrab = cc;
    }

    protected void makeHydroManager(int a) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            try {
                int i = 0;
                int j = 0;
                int h = 0;
                PrintWriter pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Inflow, Number";
                for (i = 1; i < 49; ++i) {
                    resp = resp + ",Week_" + i;
                }
                resp = resp + ",Info";
                pw.println(resp);
                resp = "[Name],[N\u00b0]";
                for (i = 1; i < 49; ++i) {
                    resp = resp + ",[m3/s]";
                }
                resp = resp + ",[20 char]";
                pw.println(resp);
                Vector affVec = SEEDS_Tool.mydbm.getStochAffVec();
                for (h = 0; h < a; ++h) {
                    for (j = 0; j < affVec.size(); ++j) {
                        resp = ((hdb_affl)affVec.elementAt(j)).getName() + "," + (h + 1);
                        for (i = 1; i < 49; ++i) {
                            resp = resp + ",0";
                        }
                        resp = resp + ", ";
                        pw.println(resp);
                    }
                }
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + " it's opened");
            }
        }
    }

    protected void editHydroManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            int i = 0;
            ResultSet r = null;
            PrintWriter pw = null;
            try {
                this.s = this.dbtrab.createStatement();
                r = this.s.executeQuery("SELECT * FROM Hydro_Manager ORDER BY Numbers ASC, Inflow ASC");
                pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Inflow,Number";
                for (i = 1; i < 49; ++i) {
                    resp = resp + ",Week_" + i;
                }
                resp = resp + ",Info";
                pw.println(resp);
                resp = "[Name],[N\u00b0]";
                for (i = 1; i < 49; ++i) {
                    resp = resp + ",[m3/s]";
                }
                resp = resp + ",[20 Char]";
                pw.println(resp);
                while (r.next()) {
                    try {
                        resp = r.getString(1) + "," + r.getInt(2);
                        for (i = 1; i < 49; ++i) {
                            resp = resp + "," + r.getDouble(i + 2);
                        }
                        resp = resp + "," + r.getString(51);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    pw.println(resp);
                }
                r.close();
                this.s.close();
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + " it's opened");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadHydroManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            File file = this.chooser.getSelectedFile().getAbsoluteFile();
            this.mySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            try {
                BufferedReader in;
                int i = 0;
                try {
                    in = new BufferedReader(new FileReader(file));
                }
                catch (Exception p) {
                    System.out.println("File name was wrong.");
                    return;
                }
                String lineText = in.readLine();
                String[] line = null;
                if (lineText == null) {
                    System.out.println("Bad format in file.");
                    return;
                }
                line = lineText.split(",");
                this.s = this.dbtrab.createStatement();
                try {
                    this.s.executeUpdate("DELETE FROM Hydro_Manager");
                }
                catch (Exception e) {
                    lineText = "CREATE TABLE Hydro_Manager (Inflow VARCHAR(50), Numbers SMALLINT";
                    for (i = 1; i < 49; ++i) {
                        lineText = lineText + ",Week_" + i + " DOUBLE";
                    }
                    lineText = lineText + ",Info CHAR(20))";
                    this.s.executeUpdate(lineText);
                }
                finally {
                    try {
                        this.s.executeUpdate("DROP TABLE Caudal_Afluentes");
                    }
                    catch (Exception e) {}
                }
                lineText = in.readLine();
                int hidros = 0;
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",");
                    if (line.length < 3) {
                        System.out.println("Bad format in HydroManager file.");
                        return;
                    }
                    lineText = "INSERT INTO Hydro_Manager VALUES ('" + line[0].trim() + "'";
                    for (i = 1; i < 50 && i < line.length; ++i) {
                        lineText = lineText + "," + line[i].trim();
                    }
                    while (i < 50) {
                        lineText = lineText + ",0";
                        ++i;
                    }
                    lineText = line.length > 51 ? lineText + ",'" + line[51].trim() + "'" : lineText + ",' '";
                    lineText = lineText + ")";
                    this.s.executeUpdate(lineText);
                    hidros = Integer.parseInt(line[1].trim());
                }
                this.mySEEDSFrame.setNumHydros(hidros);
                System.out.println("Load Hydro_Manager correctly.");
                this.s.close();
                this.dbtrab.commit();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Information not found");
            }
        }
    }
}

