/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Schematic;
import de.core.Trafo;
import de.core.comp;
import de.core.seeds.SEEDS_Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;

public class SEEDS_GridManager {
    private JFileChooser chooser;
    private SEEDS_Frame mySEEDSFrame = null;
    private String dondeGrabar = "Grids_Manager";
    private final String sGen = File.separator + "SEEDS_Generation";
    private final String sBus = File.separator + "SEEDS_Busses";
    private final String sTrf = File.separator + "SEEDS_Trafos";
    private final String sLin = File.separator + "SEEDS_Lines";
    private final String sEmb = File.separator + "SEEDS_Reservoirs";
    private final String sSer = File.separator + "SEEDS_Series";
    private final String sPas = File.separator + "SEEDS_RunRivers";
    private final String sIrr = File.separator + "SEEDS_Irrigations";
    private final String sAff = File.separator + "SEEDS_Affluents";
    private final String[][] sTitles = new String[][]{{"Id", "Name", "Voltage"}, {"Id", "Name", "Bus", "Pmax", "Pmin", "Alpha", "Beta", "Gamma"}, {"Id", "Name", "Bus_From", "Bus_to", "Pmax", "react", "resis", "length"}, {"Id", "Name", "Bus_From", "Bus_to", "Pmax", "react", "resis"}, {"Id", "Name", "Generator", "Turbine", "Spillage", "Filtration", "Rend", "Vini", "Vmax", "Vmin", "Smax", "Smin"}, {"Id", "Name", "Generator", "Turbine", "Spillage", "Rend", "Smax", "Smin"}, {"Id", "Name", "Generator", "Rend", "Vmax"}, {"Id", "Name", "Go", "Smax", "Smin"}, {"Id", "Name", "Hydro Unit"}};
    private int[] hoy = new int[]{1, 1, 2011};
    private int[] iniH = new int[]{1, 1, 2010};
    private int[] finH = new int[]{31, 12, 2029};
    private Node[] nodes = new Node[0];
    private Gener[] geners = new Gener[0];
    private Lines[] lines = new Lines[0];
    private Trans[] trafos = new Trans[0];
    private Reser[] resers = new Reser[0];
    private Serie[] series = new Serie[0];
    private RunRi[] rivers = new RunRi[0];
    private Irrig[] irrigs = new Irrig[0];
    private Afflu[] afflus = new Afflu[0];
    Hashtable<String, int[]> ht_hidroUnits = null;
    private static int pinYmax = 0;
    private static int pinXmax;

    SEEDS_GridManager() {
    }

    SEEDS_GridManager(SEEDS_Frame ff) {
        this.mySEEDSFrame = ff;
        this.ht_hidroUnits = new Hashtable();
    }

    protected void makeGridsManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        System.out.println("Select directory for grids files.");
        this.chooser.setFileSelectionMode(1);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath() + File.separator + "SEEDS_Grid";
            File file = new File(this.dondeGrabar);
            if (file.exists() || file.mkdir()) {
                System.out.println("It was made: " + this.dondeGrabar);
                try {
                    int i;
                    String resp = this.sTitles[0][0];
                    PrintWriter p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sBus + ".csv"));
                    for (i = 1; i < this.sTitles[0].length; ++i) {
                        resp = resp + "," + this.sTitles[0][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[1][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sGen + ".csv"));
                    for (i = 1; i < this.sTitles[1].length; ++i) {
                        resp = resp + "," + this.sTitles[1][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[2][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sLin + ".csv"));
                    for (i = 1; i < this.sTitles[2].length; ++i) {
                        resp = resp + "," + this.sTitles[2][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[3][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sTrf + ".csv"));
                    for (i = 1; i < this.sTitles[3].length; ++i) {
                        resp = resp + "," + this.sTitles[3][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[4][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sEmb + ".csv"));
                    for (i = 1; i < this.sTitles[4].length; ++i) {
                        resp = resp + "," + this.sTitles[4][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[5][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sSer + ".csv"));
                    for (i = 1; i < this.sTitles[5].length; ++i) {
                        resp = resp + "," + this.sTitles[5][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[6][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sPas + ".csv"));
                    for (i = 1; i < this.sTitles[6].length; ++i) {
                        resp = resp + "," + this.sTitles[6][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[7][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sIrr + ".csv"));
                    for (i = 1; i < this.sTitles[7].length; ++i) {
                        resp = resp + "," + this.sTitles[7][i];
                    }
                    p.println(resp);
                    p.close();
                    resp = this.sTitles[8][0];
                    p = new PrintWriter(new FileWriter(this.dondeGrabar + this.sAff + ".csv"));
                    for (i = 1; i < this.sTitles[8].length; ++i) {
                        resp = resp + "," + this.sTitles[8][i];
                    }
                    p.println(resp);
                    p.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("It could not save that directory.");
            }
        }
    }

    protected void editGridsManager() {
        System.out.println("Not yet implemented.");
    }

    protected void loadGridsManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        System.out.println("Select directory for grids files.");
        this.chooser.setFileSelectionMode(1);
        int retorno = this.chooser.showOpenDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            Object temp;
            Node nod;
            Node nodB;
            Node nodA;
            int i;
            Object temp2;
            String[] line;
            String lineText;
            Vector<Object> auxVec;
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            BufferedReader in = null;
            try {
                auxVec = new Vector<Object>();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sBus + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim().replaceAll(" ", "_");
                    line[1] = line[1].trim().replaceAll("'", "");
                    line[2] = line[2].trim();
                    if (line[1].equalsIgnoreCase("") || line[2].equalsIgnoreCase("")) continue;
                    temp2 = new Node(line[0], line[1], line[2]);
                    auxVec.add(temp2);
                }
                this.nodes = new Node[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.nodes[i] = (Node)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Busses info.");
            }
            auxVec = new Vector();
            try {
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sGen + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim().replaceAll(" ", "_");
                    line[1] = line[1].trim().replaceAll("'", "");
                    line[2] = line[2].trim().replaceAll(" ", "_");
                    line[2] = line[2].trim().replaceAll("'", "");
                    if (line[1].equalsIgnoreCase("") || line[2].equalsIgnoreCase("")) continue;
                    Node nod2 = null;
                    for (i = 0; i < this.nodes.length && !(nod2 = this.nodes[i]).getName().equalsIgnoreCase(line[2]); ++i) {
                        nod2 = null;
                    }
                    if (nod2 == null) continue;
                    Gener temp3 = new Gener(line[0], line[1], nod2, line[3], line[4], line[5], line[6], line[7]);
                    auxVec.add(temp3);
                }
                this.geners = new Gener[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.geners[i] = (Gener)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Generation info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sLin + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim().replaceAll(" ", "_");
                    line[1] = line[1].trim().replaceAll("'", "");
                    line[2] = line[2].trim().replaceAll(" ", "_");
                    line[2] = line[2].trim().replaceAll("'", "");
                    line[3] = line[3].trim().replaceAll(" ", "_");
                    line[3] = line[3].trim().replaceAll("'", "");
                    if (line[1].equalsIgnoreCase("") || line[2].equalsIgnoreCase("") || line[3].equalsIgnoreCase("")) continue;
                    nodA = null;
                    nodB = null;
                    nod = null;
                    for (i = 0; i < this.nodes.length; ++i) {
                        nod = this.nodes[i];
                        if (nod.getName().equalsIgnoreCase(line[2])) {
                            nodA = nod;
                            continue;
                        }
                        if (nod.getName().equalsIgnoreCase(line[3])) {
                            nodB = nod;
                            continue;
                        }
                        if (nodA != null && nodB != null) break;
                    }
                    if (nodA == null || nodB == null) continue;
                    temp = new Lines(line[0], line[1], nodA, nodB, line[4], line[5], line[6], line[7]);
                    auxVec.add(temp);
                }
                this.lines = new Lines[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.lines[i] = (Lines)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Lines info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sTrf + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim().replaceAll(" ", "_");
                    line[1] = line[1].trim().replaceAll("'", "");
                    line[2] = line[2].trim().replaceAll(" ", "_");
                    line[2] = line[2].trim().replaceAll("'", "");
                    line[3] = line[3].trim().replaceAll(" ", "_");
                    line[3] = line[3].trim().replaceAll("'", "");
                    if (line[1].equalsIgnoreCase("") || line[2].equalsIgnoreCase("") || line[3].equalsIgnoreCase("")) continue;
                    nodA = null;
                    nodB = null;
                    nod = null;
                    for (i = 0; i < this.nodes.length; ++i) {
                        nod = this.nodes[i];
                        if (nod.getName().equalsIgnoreCase(line[2])) {
                            nodA = nod;
                            continue;
                        }
                        if (nod.getName().equalsIgnoreCase(line[3])) {
                            nodB = nod;
                            continue;
                        }
                        if (nodA != null && nodB != null) break;
                    }
                    if (nodA == null || nodB == null) continue;
                    temp = new Trans(line[0], line[1], nodA, nodB, line[4], line[5], line[6]);
                    auxVec.add(temp);
                }
                this.trafos = new Trans[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.trafos[i] = (Trans)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Trafos info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sEmb + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim();
                    if (line[1].equalsIgnoreCase("")) continue;
                    line[1] = line[1].replaceAll(" ", "_");
                    line[1] = line[1].trim().replaceAll("'", "");
                    temp2 = new Reser(line[0], line[1], line[2].replaceAll(" ", "_"), line[3].replaceAll(" ", "_"), line[4].replaceAll(" ", "_"), line[5].replaceAll(" ", "_"));
                    ((Reser)temp2).setValues(new String[]{line[6], line[7], line[8], line[9], line[10], line[11]});
                    auxVec.add(temp2);
                }
                this.resers = new Reser[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.resers[i] = (Reser)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Reservoirs info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sSer + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim();
                    if (line[1].equalsIgnoreCase("")) continue;
                    line[1] = line[1].replaceAll(" ", "_");
                    temp2 = new Serie(line[0], line[1], line[2].replaceAll(" ", "_"), line[3].replaceAll(" ", "_"), line[4].replaceAll(" ", "_"));
                    ((Serie)temp2).setValues(new String[]{line[5], line[6], line[7]});
                    auxVec.add(temp2);
                }
                this.series = new Serie[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.series[i] = (Serie)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Series info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sPas + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim();
                    if (line[1].equalsIgnoreCase("")) continue;
                    temp2 = new RunRi(line[0], line[1].replaceAll(" ", "_"), line[2].replaceAll(" ", "_"));
                    ((RunRi)temp2).setValues(new String[]{line[3], line[4]});
                    auxVec.add(temp2);
                }
                this.rivers = new RunRi[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.rivers[i] = (RunRi)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Run of Rivers info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sIrr + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim();
                    if (line[1].equalsIgnoreCase("")) continue;
                    temp2 = new Irrig(line[0], line[1].replaceAll(" ", "_"), line[2].replaceAll(" ", "_"));
                    ((Irrig)temp2).setValues(new String[]{line[3], line[4]});
                    auxVec.add(temp2);
                }
                this.irrigs = new Irrig[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.irrigs[i] = (Irrig)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Irrigation info.");
            }
            try {
                auxVec = new Vector();
                in = new BufferedReader(new FileReader(this.dondeGrabar + this.sAff + ".csv"));
                lineText = in.readLine();
                while ((lineText = in.readLine()) != null) {
                    line = lineText.split(",", -1);
                    line[0] = line[0].trim();
                    line[1] = line[1].trim();
                    if (line[1].equalsIgnoreCase("")) continue;
                    temp2 = new Afflu(line[0], line[1].replaceAll(" ", "_"), line[2].replaceAll(" ", "_"));
                    auxVec.add(temp2);
                }
                this.afflus = new Afflu[auxVec.size()];
                for (i = 0; i < auxVec.size(); ++i) {
                    this.afflus[i] = (Afflu)auxVec.elementAt(i);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Was not found Affluents info.");
            }
            this.orderComps();
            try {
                this.makeSim();
            }
            catch (Exception e) {
                System.out.println("Problems making SIM file.");
                e.printStackTrace();
            }
        }
    }

    private void orderComps() {
        int i;
        int j = 0;
        int k = 0;
        int posIniX = 100;
        int posIniY = 100;
        boolean isLeft = true;
        int n = this.nodes.length;
        String name = null;
        Hashtable ht = this.discoverPos(this.dondeGrabar + File.separator + "base.sim");
        int n500 = 0;
        int n220 = 0;
        int n154 = 0;
        int n110 = 0;
        int n066 = 0;
        int n044 = 0;
        int n033 = 0;
        int n02x = 0;
        int n01x = 0;
        int n000 = 0;
        System.out.println("There is " + n + " busses.");
        for (i = 0; i < n; ++i) {
            name = this.nodes[i].getName();
            if (this.nodes[i].nroLins == 0 && this.nodes[i].nroTrfs == 0 || !ht.containsKey(name)) continue;
            this.nodes[i].defMaxPins(isLeft);
            posIniX = j = ((int[])ht.get(name))[0];
            posIniY = (int)((double)((int[])ht.get(name))[1] * 1.0);
            ++k;
            this.nodes[i].defPos(new int[]{posIniX, posIniY});
        }
        System.out.println("It was found " + k + " busses location.");
        for (i = 0; i < n; ++i) {
            name = this.nodes[i].getName();
            if (this.nodes[i].nroLins == 0 && this.nodes[i].nroTrfs == 0 || this.nodes[i].hasPos()) continue;
            this.nodes[i].defMaxPins(isLeft);
            name = this.nodes[i].getName();
            if (this.nodes[i].getTension().equalsIgnoreCase("500")) {
                posIniX = 50 + n500;
                posIniY = n500 * 23 + 50;
                ++n500;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("220")) {
                posIniX = 100 + n220;
                posIniY = n220 * 23 + 50;
                ++n220;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("154")) {
                posIniX = 150 + n154;
                posIniY = n154 * 23 + 50;
                ++n154;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("110")) {
                posIniX = 200 + n110;
                posIniY = n110 * 23 + 50;
                ++n110;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("66")) {
                posIniX = 250 + n066;
                posIniY = n066 * 23 + 50;
                ++n066;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("44")) {
                posIniX = 300 + n044;
                posIniY = n044 * 23 + 50;
                ++n044;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("33")) {
                posIniX = 350 + n033;
                posIniY = n033 * 23 + 50;
                ++n033;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("24") || this.nodes[i].getTension().equalsIgnoreCase("23") || this.nodes[i].getTension().equalsIgnoreCase("20.4") || this.nodes[i].getTension().equalsIgnoreCase("20")) {
                posIniX = 400 + n02x;
                posIniY = n02x * 23 + 50;
                ++n02x;
            } else if (this.nodes[i].getTension().equalsIgnoreCase("18") || this.nodes[i].getTension().equalsIgnoreCase("15.75") || this.nodes[i].getTension().equalsIgnoreCase("15") || this.nodes[i].getTension().equalsIgnoreCase("13.8") || this.nodes[i].getTension().equalsIgnoreCase("13.2") || this.nodes[i].getTension().equalsIgnoreCase("12.5") || this.nodes[i].getTension().equalsIgnoreCase("12") || this.nodes[i].getTension().equalsIgnoreCase("11.5") || this.nodes[i].getTension().equalsIgnoreCase("11")) {
                posIniX = 450 + n01x;
                posIniY = n01x * 23 + 50;
                ++n01x;
            } else {
                posIniX = 500 + n000;
                posIniY = n000 * 23 + 50;
                ++n000;
            }
            this.nodes[i].defPos(new int[]{posIniX, posIniY});
        }
        k = 0;
        posIniX = 20;
        for (i = 0; i < this.afflus.length; ++i) {
            for (j = 0; j < this.rivers.length; ++j) {
                if (!this.afflus[i].getName().equalsIgnoreCase(this.rivers[j].getName())) continue;
                posIniY = k == 0 ? 5 : 15;
                this.afflus[i].defPos(new int[]{posIniX, posIniY});
                if (k == 0) {
                    posIniY = 25;
                    k = 1;
                } else {
                    posIniY = 30;
                    k = 0;
                }
                this.rivers[j].defPos(new int[]{posIniX + 10, posIniY});
                this.ht_hidroUnits.put(this.rivers[j].getName(), this.rivers[j].getPos());
                posIniX += 15;
            }
        }
        posIniX += 10;
        for (i = 0; i < this.rivers.length; ++i) {
            if (this.rivers[i].posDef) continue;
            this.rivers[i].defPos(new int[]{posIniX += 20, posIniY});
            this.ht_hidroUnits.put(this.rivers[i].getName(), this.rivers[i].getPos());
        }
        posIniX = 20;
        posIniY = 60;
        for (i = 0; i < this.afflus.length; ++i) {
            if (this.afflus[i].posDef) continue;
            this.afflus[i].defPos(new int[]{posIniX, posIniY});
            posIniX += 20;
        }
        posIniX = 20;
        posIniY += 30;
        for (i = 0; i < this.resers.length; ++i) {
            this.resers[i].defPos(new int[]{posIniX, posIniY});
            posIniX += 15;
            this.ht_hidroUnits.put(this.resers[i].getName(), this.resers[i].getPos());
        }
        posIniX = 20;
        posIniY += 30;
        for (i = 0; i < this.series.length; ++i) {
            this.series[i].defPos(new int[]{posIniX, posIniY});
            posIniX += 15;
            this.ht_hidroUnits.put(this.series[i].getName(), this.series[i].getPos());
        }
        posIniX = 20;
        posIniY += 30;
        for (i = 0; i < this.irrigs.length; ++i) {
            this.irrigs[i].defPos(new int[]{posIniX, posIniY});
            posIniX += 15;
            this.ht_hidroUnits.put(this.irrigs[i].getName(), this.irrigs[i].getPos());
        }
    }

    private void makeSim() throws Exception {
        Object temp;
        int i;
        int noConBus = 0;
        boolean onlyBusbar = false;
        PrintWriter p = new PrintWriter(new FileWriter(this.dondeGrabar + File.separator + "newCase.sim"));
        boolean minTension = false;
        p.println("# DeepEdit file");
        p.println("version 2 0");
        p.println("describe component System");
        p.println(" sysname       SEEDS Case");
        p.println(" sref          100");
        p.println(" iniperiod     " + this.iniH[2]);
        p.println(" endperiod     " + this.finH[2]);
        p.println(" actperiod     " + this.hoy[2]);
        p.println(" inimonth      " + this.iniH[1]);
        p.println(" endmonth      " + this.finH[1]);
        p.println(" actmonth      " + this.hoy[1]);
        p.println(" actday        " + this.hoy[0]);
        p.println(" actdaytype    1");
        p.println(" acthour       1");
        p.println(" stepperiod    1");
        p.println(" peaksim       false");
        p.println(" customsim     false");
        p.println(" meansim       true");
        p.println(" lowsim        false");
        p.println(" intrate       10.0");
        p.println(" loadfac1      0.0");
        p.println(" loadfac2      1.0");
        p.println("end describe");
        for (i = 0; i < this.nodes.length; ++i) {
            int j;
            Vector<Object> vec;
            temp = this.nodes[i];
            if (((Node)temp).nroLins == 0 && ((Node)temp).nroTrfs == 0) {
                ++noConBus;
                continue;
            }
            p.println("describe component Busbar");
            p.println(" pos " + ((Node)temp).getPos()[0] + " " + ((Node)temp).getPos()[1]);
            p.println(" num " + ((Node)temp).getPins());
            p.println(" umin 0.9");
            p.println(" umax 1.1");
            p.println(" Name " + ((Node)temp).getName());
            p.println(" type CHT");
            p.println(" alias Bus");
            p.println(" owner -");
            p.println(" ctrla -");
            p.println(" cost 0");
            p.println(" un1 " + ((Node)temp).getTension());
            p.println(" lifetime 100");
            p.println(" entryperiod " + this.iniH[2]);
            p.println(" exitperiod " + this.finH[2]);
            p.println(" entrymonth " + this.iniH[1]);
            p.println(" exitmonth " + this.finH[1]);
            p.println(" latitude 0");
            p.println(" longitude 0");
            p.println(" inservice  true");
            p.println("end describe");
            if (!onlyBusbar || (double)minTension < Double.parseDouble(((Node)temp).getTension())) {
                vec = ((Node)temp).vGen;
                for (j = 0; j < vec.size(); ++j) {
                    Gener gen = (Gener)vec.elementAt(j);
                    p.println("describe component Generator");
                    if (((Node)temp).left) {
                        p.println(" pos " + (((Node)temp).getPos()[0] + 5 * j) + " " + (((Node)temp).getPos()[1] - 8));
                    } else {
                        p.println(" pos " + (((Node)temp).getPos()[0] + (((Node)temp).nCon / 2 - 1) * 5 + -5 * (j + 1)) + " " + (((Node)temp).getPos()[1] - 8));
                    }
                    p.println(" Name " + gen.getName());
                    p.println(" type CHT");
                    p.println(" alias Gen");
                    p.println(" owner -");
                    p.println(" cost 0");
                    p.println(" un1 " + ((Node)temp).getTension());
                    p.println(" us  1");
                    p.println(" smax " + gen.getPmax() * 10.0);
                    p.println(" lifetime 100");
                    p.println(" entryperiod " + this.iniH[2]);
                    p.println(" exitperiod " + this.finH[2]);
                    p.println(" entrymonth " + this.iniH[1]);
                    p.println(" exitmonth " + this.finH[1]);
                    p.println(" pmin " + gen.getPmin());
                    p.println(" pmax " + gen.getPmax());
                    p.println(" qmin 0");
                    p.println(" qmax 1");
                    p.println(" emax 2");
                    p.println(" emin 0");
                    p.println(" gradU 10");
                    p.println(" gradD 10");
                    p.println(" p0 0");
                    p.println(" q0 0");
                    p.println(" alpha " + gen.getAlpha());
                    p.println(" beta " + gen.getBeta());
                    p.println(" gamma " + gen.getGamma());
                    p.println(" sn  " + gen.getPmax() * 10.0);
                    p.println(" st  0");
                    p.println(" lftype  2");
                    p.println(" lftypes  3");
                    p.println(" latitude  0");
                    p.println(" longitude  0");
                    p.println(" ctrla -");
                    p.println(" inservice true");
                    p.println(" xd 0");
                    p.println(" xd1 0");
                    p.println(" xd2 0");
                    p.println(" xs 0");
                    p.println(" CvPLP 0");
                    p.println(" invstate -");
                    p.println(" source -");
                    p.println(" firstannyear -");
                    p.println(" firstannmonth -");
                    p.println("end describe");
                }
                p.println("describe component Load");
                if (((Node)temp).left) {
                    p.println(" pos " + (((Node)temp).getPos()[0] + 1) + " " + (((Node)temp).getPos()[1] + 10));
                } else {
                    p.println(" pos " + (((Node)temp).getPos()[0] + (((Node)temp).nCon / 2 - 1) * 5 + 1 - 5) + " " + (((Node)temp).getPos()[1] + 10));
                }
                p.println(" Name D_" + ((Node)temp).getName());
                p.println(" type CHT");
                p.println(" owner -");
                p.println(" cost 0");
                p.println(" un1 " + ((Node)temp).getTension());
                p.println(" lifetime 100");
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" pini 0");
                p.println(" qini 0");
                p.println(" alpha 0");
                p.println(" beta 500");
                p.println(" gamma 0");
                p.println(" grate 10");
                p.println(" ldc_T 0");
                p.println(" ldc_pmin 50");
                p.println(" ldc_pmax 100");
                p.println(" vd_p 0");
                p.println(" vd_q 0");
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" ctrla -");
                p.println(" place -");
                p.println(" inservice  true");
                p.println(" fcaPLP  0");
                p.println("end describe");
            }
            vec = ((Node)temp).vTrf;
            for (j = 0; j < vec.size(); ++j) {
                Trans traf = (Trans)vec.elementAt(j);
                p.println("describe component Trafo");
                p.println(" pos " + (((Node)temp).getPos()[0] + 5 * (j + ((Node)temp).nroDems)) + " " + (((Node)temp).getPos()[1] + 10));
                p.println(" Name " + traf.getName());
                p.println(" type CHT");
                p.println(" alias Trf");
                p.println(" owner -");
                p.println(" ctrla -");
                p.println(" cost 0");
                p.println(" coym 0");
                p.println(" un1 " + traf.getNodes()[0].getTension());
                p.println(" un2 " + traf.getNodes()[1].getTension());
                p.println(" ur1 " + traf.getNodes()[0].getTension());
                p.println(" ur2 " + traf.getNodes()[1].getTension());
                p.println(" smax " + traf.getPmax());
                p.println(" sn " + traf.getPmax());
                p.println(" lifetime 100");
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" pfe 0");
                p.println(" pcu " + traf.getPfe());
                p.println(" uk " + traf.getUk());
                p.println(" i0 0");
                p.println(" incomep 0");
                p.println(" incomeq 0");
                p.println(" z0z1 0");
                p.println(" r0x0 0");
                p.println(" verhor true");
                p.println(" swapPS false");
                p.println(" planning 0");
                p.println(" project -");
                p.println(" alternative -");
                p.println(" suggest false");
                p.println(" zsl 0");
                p.println(" maxt 0");
                p.println(" sollt 0");
                p.println(" inservice  true");
                p.println("end describe");
            }
        }
        System.out.println("Number of not connected busses: " + noConBus);
        if (!onlyBusbar) {
            String aux;
            for (i = 0; i < this.lines.length; ++i) {
                temp = this.lines[i];
                if (!((double)minTension < Double.parseDouble(((Lines)temp).getNodes()[0].getTension()))) continue;
                p.println("describe component Line");
                int[][] pos = ((Lines)temp).getPos();
                p.println(" pos " + pos[0][0] + " " + pos[0][1]);
                p.println(" pos2 " + pos[1][0] + " " + pos[1][1]);
                p.println(" Name " + ((Lines)temp).getName());
                p.println(" type CHT");
                p.println(" alias Lin");
                p.println(" owner -");
                p.println(" ctrla -");
                p.println(" cost 0");
                p.println(" coym 0");
                p.println(" un1 " + ((Lines)temp).getNodes()[0].getTension());
                p.println(" smax " + ((Lines)temp).getPmax());
                p.println(" sc 1");
                p.println(" sn " + ((Lines)temp).getPmax());
                p.println(" lifetime 100");
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" r1 " + ((Lines)temp).getResis());
                p.println(" xx1 " + ((Lines)temp).getReact());
                p.println(" g1 0");
                p.println(" b1 0");
                p.println(" len " + ((Lines)temp).getLength());
                p.println(" planning 0");
                p.println(" project -");
                p.println(" alternative -");
                p.println(" suggest false");
                p.println(" inservice  true");
                p.println("end describe");
            }
            for (i = 0; i < this.rivers.length; ++i) {
                temp = this.rivers[i];
                p.println("describe component hdbpaspur");
                p.println(" pos " + ((RunRi)temp).getPos()[0] + " " + ((RunRi)temp).getPos()[1]);
                p.println(" Name " + ((RunRi)temp).getName());
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" lifetime 100");
                p.println(" cost 0");
                p.println(" owner -");
                p.println(" type CHT");
                p.println(" Wat2PowRate " + ((RunRi)temp).rend);
                p.println(" SpillMin 0");
                p.println(" SpillMax 100");
                if (((RunRi)temp).Vmax > 0.0) {
                    p.println(" isRegulTank true");
                } else {
                    p.println(" isRegulTank false");
                }
                aux = this.getGen(((RunRi)temp).getUnit());
                p.println(" ElGeName " + aux);
                if (aux.equalsIgnoreCase("")) {
                    p.println(" grounded true");
                } else {
                    p.println(" grounded false");
                }
                p.println("end describe");
            }
            for (i = 0; i < this.afflus.length; ++i) {
                temp = this.afflus[i];
                p.println("describe component hdbaffl");
                p.println(" pos " + ((Afflu)temp).getPos()[0] + " " + ((Afflu)temp).getPos()[1]);
                p.println(" Name " + ((Afflu)temp).getName());
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" Q 0");
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" lifetime 100");
                p.println(" cost 0");
                p.println(" owner -");
                p.println(" type CHT");
                p.println(" isStoch true");
                p.println("end describe");
                this.writeLinks(p, new int[]{((Afflu)temp).getPos()[0] + 3, ((Afflu)temp).getPos()[1] + 8}, ((Afflu)temp).getUnit());
            }
            for (i = 0; i < this.resers.length; ++i) {
                temp = this.resers[i];
                p.println("describe component hdbres");
                p.println(" pos " + ((Reser)temp).getPos()[0] + " " + ((Reser)temp).getPos()[1]);
                aux = this.getGen(((Reser)temp).getUnit());
                if (aux.equalsIgnoreCase("")) {
                    p.println(" Name " + aux);
                } else {
                    p.println(" Name " + ((Reser)temp).getName());
                }
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" lifetime 100");
                p.println(" cost 0");
                p.println(" owner -");
                p.println(" type CHT");
                p.println(" Vmax " + ((Reser)temp).Vmax);
                p.println(" Vmin " + ((Reser)temp).Vmin);
                p.println(" Vini " + ((Reser)temp).Vini);
                p.println(" Vfin 0");
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" Wat2PowRate " + ((Reser)temp).rend);
                p.println(" WaterVal 0");
                p.println(" SpillMin " + ((Reser)temp).Smin);
                p.println(" SpillMax " + ((Reser)temp).Smax);
                p.println(" AvfiltFact 0");
                p.println(" filtType 2");
                p.println(" TurbMin 0");
                p.println(" TurbMax 100");
                p.println(" ElGeName " + ((Reser)temp).getName());
                if (aux.equalsIgnoreCase("")) {
                    p.println(" grounded false");
                } else {
                    p.println(" grounded true");
                }
                p.println("end describe");
                this.writeLinks(p, new int[]{((Reser)temp).getPos()[0] + 3, ((Reser)temp).getPos()[1] + 9}, ((Reser)temp).getTurb());
                this.writeLinks(p, new int[]{((Reser)temp).getPos()[0] + 5, ((Reser)temp).getPos()[1] + 2}, ((Reser)temp).getVert());
                this.writeLinks(p, new int[]{((Reser)temp).getPos()[0] + 5, ((Reser)temp).getPos()[1] + 6}, ((Reser)temp).getFilt());
            }
            for (i = 0; i < this.series.length; ++i) {
                temp = this.series[i];
                p.println("describe component hdbser");
                p.println(" pos " + ((Serie)temp).getPos()[0] + " " + ((Serie)temp).getPos()[1]);
                p.println(" Name " + ((Serie)temp).getName());
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" lifetime 100");
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" cost 0");
                p.println(" owner -");
                p.println(" type CHT");
                p.println(" Wat2PowRate " + ((Serie)temp).rend);
                p.println(" SpillMin " + ((Serie)temp).Smin);
                p.println(" SpillMax " + ((Serie)temp).Smax);
                p.println(" TurbMin 0");
                p.println(" TurbMax 100");
                aux = this.getGen(((Serie)temp).getUnit());
                p.println(" ElGeName " + aux);
                if (aux.equalsIgnoreCase("")) {
                    p.println(" grounded true");
                } else {
                    p.println(" grounded false");
                }
                p.println("end describe");
                this.writeLinks(p, new int[]{((Serie)temp).getPos()[0] + 3, ((Serie)temp).getPos()[1] + 8}, ((Serie)temp).getTurb());
                this.writeLinks(p, new int[]{((Serie)temp).getPos()[0] + 5, ((Serie)temp).getPos()[1] + 2}, ((Serie)temp).getVert());
            }
            for (i = 0; i < this.irrigs.length; ++i) {
                temp = this.irrigs[i];
                p.println("describe component hdbirr");
                p.println(" pos " + ((Irrig)temp).getPos()[0] + " " + ((Irrig)temp).getPos()[1]);
                p.println(" Name " + ((Irrig)temp).getName());
                p.println(" entryperiod " + this.iniH[2]);
                p.println(" exitperiod " + this.finH[2]);
                p.println(" entrymonth " + this.iniH[1]);
                p.println(" exitmonth " + this.finH[1]);
                p.println(" lifetime 100");
                p.println(" latitude 0");
                p.println(" longitude 0");
                p.println(" cost 0");
                p.println(" owner -");
                p.println(" type CHT");
                p.println(" SpillMin " + ((Irrig)temp).Smin);
                p.println(" SpillMax " + ((Irrig)temp).Smax);
                p.println("end describe");
                this.writeLinks(p, new int[]{((Irrig)temp).getPos()[0] + 3, ((Irrig)temp).getPos()[1] + 8}, ((Irrig)temp).getPass());
            }
        }
        p.close();
        System.out.println("Was written " + this.dondeGrabar + File.separator + "newCase.sim");
        try {
            int linenumero = 0;
            BufferedReader in = new BufferedReader(new FileReader(this.dondeGrabar + File.separator + "newCase.sim"));
            while (in.readLine() != null) {
                ++linenumero;
            }
            FileInputStream is = new FileInputStream(this.dondeGrabar + File.separator + "newCase.sim");
            Schematic NewSchematic = new Schematic(DeepEdit.PinGrid, is, linenumero);
            for (i = 0; i < NewSchematic.Components.size(); ++i) {
                comp TempComponent = (comp)NewSchematic.Components.elementAt(i);
                if (TempComponent instanceof Trafo) {
                    NewSchematic.BringToFront(TempComponent);
                    continue;
                }
                if (!(TempComponent instanceof Busbar)) continue;
                NewSchematic.BringToFront(TempComponent);
            }
            NewSchematic.FileName = "newCase.sim";
            NewSchematic.FileDir = this.dondeGrabar;
            if (NewSchematic != null) {
                DeepEdit.frame.setTitle(DeepEdit.getEditor(), NewSchematic);
                DeepEdit cfr_ignored_0 = this.mySEEDSFrame.myApplet;
                DeepEdit.MySchematic = NewSchematic;
                SEEDS_Frame sEEDS_Frame = this.mySEEDSFrame;
                NewSchematic.setEditor(sEEDS_Frame.myApplet.getEditor());
                SEEDS_Frame sEEDS_Frame2 = this.mySEEDSFrame;
                sEEDS_Frame2.myApplet.SimulateSetUp();
                DeepEdit.MySchematicPanel.repaint();
                SEEDS_Frame sEEDS_Frame3 = this.mySEEDSFrame;
                sEEDS_Frame3.myApplet.updateTime();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DeepEdit.MySchematicPanel.repaint();
        }
    }

    private String getGen(String name) {
        String aux = "";
        if (name.equalsIgnoreCase("") || name.equalsIgnoreCase("NoCon")) {
            return aux;
        }
        for (int i = 0; i < this.geners.length; ++i) {
            aux = this.geners[i].getName();
            if (!name.equalsIgnoreCase(aux)) continue;
            return aux;
        }
        return "";
    }

    private void writeLinks(PrintWriter p, int[] pos1, String name) {
        if (name.equalsIgnoreCase("") || name.equalsIgnoreCase("nocon") || !this.ht_hidroUnits.containsKey(name)) {
            return;
        }
        int[] pos2 = this.ht_hidroUnits.get(name);
        p.println("describe component hdblink");
        p.println(" pos " + pos1[0] + " " + pos1[1]);
        p.println(" pos2 " + (pos2[0] + 3) + " " + (pos2[1] + 1));
        p.println(" Name ");
        p.println(" entryperiod " + this.iniH[2]);
        p.println(" exitperiod " + this.finH[2]);
        p.println(" entrymonth " + this.iniH[1]);
        p.println(" exitmonth " + this.finH[1]);
        p.println(" lifetime 100");
        p.println(" cost 0");
        p.println(" owner -");
        p.println(" type CHT");
        p.println("end describe ");
    }

    private Hashtable discoverPos(String test) {
        Hashtable<String, int[]> ht = null;
        int xPos = 0;
        int yPos = 0;
        String[] line = null;
        ht = new Hashtable<String, int[]>();
        try {
            String lineText;
            System.out.println("Schematic based on " + test);
            BufferedReader in = new BufferedReader(new FileReader(test));
            while ((lineText = in.readLine()) != null) {
                if (!lineText.contains("Busbar")) continue;
                lineText = in.readLine();
                line = lineText.split(" ");
                xPos = Integer.parseInt(line[2]);
                yPos = Integer.parseInt(line[3]);
                in.readLine();
                in.readLine();
                in.readLine();
                lineText = in.readLine();
                line = lineText.split(" ");
                String name = line[2].trim();
                ht.put(name, new int[]{xPos, yPos});
                for (xPos = 0; xPos < 8; ++xPos) {
                    in.readLine();
                }
            }
        }
        catch (Exception e) {
            ht = new Hashtable();
            System.out.println("Not founded base.sim.");
        }
        return ht;
    }

    private class Lines {
        String id = "";
        String name = "";
        double Pmax = 0.0;
        double react = 0.0;
        double resis = 0.0;
        double largo = 1.0;
        Node n1;
        Node n2;
        int idA;
        int idB;

        Lines(String i, String n, Node nod1, Node nod2, String p, String equis, String erre, String l) {
            this.id = i;
            this.name = n;
            this.n1 = nod1;
            this.idA = this.n1.addLin(this);
            this.n2 = nod2;
            this.idB = this.n2.addLin(this);
            this.Pmax = new Double(p);
            this.react = new Double(equis);
            this.resis = new Double(erre);
            this.largo = new Double(l);
        }

        double getPmax() {
            return this.Pmax;
        }

        double getReact() {
            return this.react;
        }

        double getResis() {
            return this.resis;
        }

        double getLength() {
            return this.largo;
        }

        String getName() {
            return this.name;
        }

        Node[] getNodes() {
            return new Node[]{this.n1, this.n2};
        }

        int[][] getPos() {
            int[][] p = new int[2][2];
            if (this.n1.left) {
                if (this.idA + this.n1.nroGen > this.n1.nCon / 2) {
                    p[0][0] = this.n1.getPos()[0] + 3 + (this.idA + this.n1.nroDems + this.n1.nroTrfs - 1 - this.n1.nCon / 2 + this.n1.nroGen) * 5;
                    p[0][1] = this.n1.getPos()[1] + 11;
                } else {
                    p[0][0] = this.n1.getPos()[0] + 3 + (this.n1.nroGen + this.idA - 1) * 5;
                    p[0][1] = this.n1.getPos()[1];
                }
            } else if (this.n1.nCon / 2 == this.n1.nroGen) {
                p[0][0] = this.n1.getPos()[0] + (this.n1.nCon / 2 - 1) * 5 + 3 - (this.idA + 1) * 5;
                p[0][1] = this.n1.getPos()[1] + 11;
            } else if (this.idA + this.n1.nroGen <= this.n1.nCon / 2) {
                p[0][0] = this.n1.getPos()[0] + (this.n1.nCon / 2 - 1) * 5 + 3 - (this.n1.nroGen + this.idA - 1) * 5;
                p[0][1] = this.n1.getPos()[1];
            } else {
                p[0][0] = this.n1.getPos()[0] + (this.n1.nCon / 2 - 1) * 5 + 3 - (1 + this.idA - (this.n1.nCon / 2 - this.n1.nroGen)) * 5;
                p[0][1] = this.n1.getPos()[1] + 11;
            }
            if (this.n2.left) {
                if (this.idB + this.n2.nroGen > this.n2.nCon / 2) {
                    p[1][0] = this.n2.getPos()[0] + 3 + (this.idB + this.n2.nroDems + this.n2.nroTrfs - 1 - this.n2.nCon / 2 + this.n2.nroGen) * 5;
                    p[1][1] = this.n2.getPos()[1] + 11;
                } else {
                    p[1][0] = this.n2.getPos()[0] + 3 + (this.n2.nroGen + this.idB - 1) * 5;
                    p[1][1] = this.n2.getPos()[1];
                }
            } else if (this.n2.nCon / 2 == this.n2.nroGen) {
                p[1][0] = this.n2.getPos()[0] + (this.n2.nCon / 2 - 1) * 5 + 3 - (this.idB + 1) * 5;
                p[1][1] = this.n2.getPos()[1] + 11;
            } else if (this.idB + this.n2.nroGen <= this.n2.nCon / 2) {
                p[1][0] = this.n2.getPos()[0] + (this.n2.nCon / 2 - 1) * 5 + 3 - (this.n2.nroGen + this.idB - 1) * 5;
                p[1][1] = this.n2.getPos()[1];
            } else {
                p[1][0] = this.n2.getPos()[0] + (this.n2.nCon / 2 - 1) * 5 + 3 - (1 + this.idB - (this.n2.nCon / 2 - this.n2.nroGen)) * 5;
                p[1][1] = this.n2.getPos()[1] + 11;
            }
            return p;
        }
    }

    private class Trans {
        String id = "";
        String name = "";
        double Pmax;
        double react;
        double resis;
        double pfe;
        double uk;
        Node n1;
        Node n2;
        int idA;
        int idB;

        Trans(String i, String n, Node nod1, Node nod2, String p, String equis, String erre) {
            this.id = i;
            this.name = n;
            Double d = new Double(nod1.getTension());
            Double d2 = new Double(nod2.getTension());
            if (d < d2) {
                this.n2 = nod1;
                this.n1 = nod2;
            } else {
                this.n1 = nod1;
                this.n2 = nod2;
            }
            this.idA = this.n1.addTrf(this, true);
            this.idB = this.n2.addTrf(this, false);
            this.Pmax = new Double(p);
            this.setPfe(erre);
            this.setUk(equis);
        }

        void setPfe(String r) {
            double aux = 0.0;
            this.resis = aux = new Double(r).doubleValue();
            this.pfe = this.resis * Math.pow(this.Pmax, 2.0) / ((SEEDS_GridManager)SEEDS_GridManager.this).mySEEDSFrame.mySEEDS_tool.getSref() * 1000.0;
        }

        void setUk(String x) {
            double aux = 0.0;
            this.react = aux = new Double(x).doubleValue();
            this.uk = this.Pmax * Math.sqrt(Math.pow(this.resis, 2.0) + Math.pow(this.react, 2.0)) * 100.0 / ((SEEDS_GridManager)SEEDS_GridManager.this).mySEEDSFrame.mySEEDS_tool.getSref();
        }

        double getPmax() {
            return this.Pmax;
        }

        double getReact() {
            return this.react;
        }

        double getResis() {
            return this.resis;
        }

        double getPfe() {
            return this.pfe;
        }

        double getUk() {
            return this.uk;
        }

        String getName() {
            return this.name;
        }

        Node[] getNodes() {
            return new Node[]{this.n1, this.n2};
        }
    }

    private class Gener {
        String id = "";
        String name = "";
        double Pmax = 1000.0;
        double Pmin = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        Node n;

        Gener(String i, String nn, Node nod, String p1, String p2, String a, String b, String c) {
            this.id = i;
            this.name = nn;
            this.n = nod;
            nod.addGen(this);
            this.Pmax = new Double(p1);
            this.Pmin = new Double(p2);
            this.alpha = new Double(a);
            this.beta = new Double(b);
            this.gamma = new Double(c);
        }

        String getName() {
            return this.name;
        }

        double getPmin() {
            return this.Pmin;
        }

        double getPmax() {
            return this.Pmax;
        }

        double getAlpha() {
            return this.alpha;
        }

        double getBeta() {
            return this.beta;
        }

        double getGamma() {
            return this.gamma;
        }
    }

    private class Node {
        int nroGen = 0;
        int nroLins = 0;
        int nroTrfs = 0;
        int nroDems = 1;
        Vector<Gener> vGen;
        Vector<Lines> vLin;
        Vector<Trans> vTrf;
        String id = "";
        String name = "";
        String tension = "";
        int nCon;
        int posX;
        int posY;
        boolean defPos = false;
        boolean left = true;

        Node(String i, String n, String t) {
            this.id = i;
            this.name = n;
            this.tension = t;
            this.vGen = new Vector();
            this.vLin = new Vector();
            this.vTrf = new Vector();
        }

        void addGen(Gener g) {
            this.vGen.add(g);
            ++this.nroGen;
        }

        int addLin(Lines l) {
            this.vLin.add(l);
            ++this.nroLins;
            return this.nroLins;
        }

        int addTrf(Trans t, boolean is) {
            if (is) {
                this.vTrf.add(t);
            }
            ++this.nroTrfs;
            return this.nroTrfs;
        }

        String getName() {
            return this.name;
        }

        String getConn() {
            int i;
            String st = this.name + "___";
            for (i = 0; i < this.vGen.size(); ++i) {
                st = st + " Gen_" + (i + 1) + ":" + this.vGen.elementAt(i).getName();
            }
            for (i = 0; i < this.vLin.size(); ++i) {
                st = st + " Lin_" + (i + 1) + ":" + this.vLin.elementAt(i).getName();
            }
            for (i = 0; i < this.vTrf.size(); ++i) {
                st = st + " Trf_" + (i + 1) + ":" + this.vTrf.elementAt(i).getName();
            }
            return st;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
            this.defPos = true;
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        int getPins() {
            return this.nCon;
        }

        boolean hasPos() {
            return this.defPos;
        }

        void defMaxPins(boolean tt) {
            this.left = tt;
            if (this.nroGen >= this.nroTrfs + this.nroDems + this.nroLins) {
                this.nCon = this.nroGen;
            } else if (this.nroTrfs + this.nroDems >= this.nroGen + this.nroLins) {
                this.nCon = this.nroTrfs + this.nroDems;
            } else {
                int i = Math.abs(this.nroGen - this.nroTrfs - this.nroDems);
                this.nCon = Math.max(this.nroGen, this.nroTrfs + this.nroDems) + (int)Math.ceil(1.0 * (double)(this.nroLins - i) / 2.0);
            }
            this.nCon *= 2;
        }

        String getTension() {
            return this.tension;
        }
    }

    private class Afflu {
        int posX;
        int posY;
        String id = "";
        String name = "";
        String unit = "";
        boolean posDef = false;

        Afflu(String i, String nn, String u) {
            this.name = nn;
            this.id = i;
            this.unit = u;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
            this.posDef = true;
        }

        String getUnit() {
            return this.unit;
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        String getName() {
            return this.name;
        }
    }

    private class Irrig {
        double Smin = 0.0;
        double Smax = 1000000.0;
        String id = "";
        String name = "";
        String pass = "";
        int posX;
        int posY;

        Irrig(String i, String nn, String p) {
            this.name = nn;
            this.id = i;
            this.pass = p;
        }

        String getPass() {
            return this.pass;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        String getName() {
            return this.name;
        }

        void setValues(String[] q) {
            this.Smax = new Double(q[0]);
            this.Smin = new Double(q[1]);
        }
    }

    private class RunRi {
        double rend = 1.0;
        double Vmax = 0.0;
        String id = "";
        String name = "";
        String unit = "";
        int posX;
        int posY;
        boolean posDef = false;

        RunRi(String i, String nn, String u) {
            this.name = nn;
            this.id = i;
            this.unit = u;
        }

        String getUnit() {
            return this.unit;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
            this.posDef = true;
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        String getName() {
            return this.name;
        }

        void setValues(String[] q) {
            this.rend = new Double(q[0]);
            this.Vmax = new Double(q[1]);
        }
    }

    private class Serie {
        String id = "";
        String name = "";
        String turb = "";
        String vert = "";
        String unit = "";
        double rend = 1.0;
        double Smin = 0.0;
        double Smax = 1000000.0;
        int posX;
        int posY;

        Serie(String i, String nn, String u, String t, String v) {
            this.name = nn;
            this.id = i;
            this.turb = t;
            this.vert = v;
            this.unit = u;
        }

        String getUnit() {
            return this.unit;
        }

        String getTurb() {
            return this.turb;
        }

        String getVert() {
            return this.vert;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        String getName() {
            return this.name;
        }

        void setValues(String[] q) {
            this.rend = new Double(q[0]);
            this.Smax = new Double(q[1]);
            this.Smin = new Double(q[2]);
        }
    }

    private class Reser {
        double rend = 1.0;
        double Smin = 0.0;
        double Smax = 1000000.0;
        double Vmin = 0.0;
        double Vmax = 1000000.0;
        double Vini = 1.0;
        String id = "";
        String name = "";
        String turb = "";
        String vert = "";
        String filt = "";
        String unit = "";
        int posX;
        int posY;

        Reser(String i, String nn, String u, String t, String v, String f) {
            this.name = nn;
            this.id = i;
            this.turb = t;
            this.vert = v;
            this.filt = f;
            this.unit = u;
        }

        String getUnit() {
            return this.unit;
        }

        String getTurb() {
            return this.turb;
        }

        String getVert() {
            return this.vert;
        }

        String getFilt() {
            return this.filt;
        }

        void defPos(int[] pos) {
            this.posX = pos[0];
            this.posY = pos[1];
        }

        int[] getPos() {
            return new int[]{this.posX, this.posY};
        }

        String getName() {
            return this.name;
        }

        void setValues(String[] q) {
            this.rend = new Double(q[0]);
            this.Vini = new Double(q[1]);
            this.Vmax = new Double(q[2]);
            this.Vmin = new Double(q[3]);
            this.Smax = new Double(q[4]);
            this.Smin = new Double(q[5]);
        }
    }
}

