/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

public final class SEEDS_BendCut {
    private static int dim = 0;
    private static double val = 0.0;
    private static int i = 0;
    public double[] mi;
    public double[] xi;
    public double f0;

    public SEEDS_BendCut(double[] mip, double[] xip, double fp) {
        if (dim == 0) {
            dim = mip.length;
        } else if (dim != mip.length || dim != xip.length) {
            System.out.print("Warning : Change in BCuts Dimension. ");
            System.out.println("Act Dim=" + dim + ", mip.length=" + mip.length + ", xip.length=" + xip.length);
            Exception e = new Exception("Problemas");
            e.printStackTrace();
            return;
        }
        this.mi = new double[dim];
        this.xi = new double[dim];
        this.f0 = fp;
        for (i = 0; i < dim; ++i) {
            this.mi[SEEDS_BendCut.i] = mip[i];
            this.xi[SEEDS_BendCut.i] = xip[i];
            this.f0 += this.mi[i] * this.xi[i];
        }
    }

    public SEEDS_BendCut(double[] mip, int fm, double[] xip, int fx, double fp) {
        if (dim == 0) {
            return;
        }
        if (dim != mip.length || dim != xip.length) {
            return;
        }
        this.mi = new double[dim];
        this.xi = new double[dim];
        this.f0 = fp;
        for (i = 0; i < dim; ++i) {
            this.mi[SEEDS_BendCut.i] = mip[i + fm];
            this.xi[SEEDS_BendCut.i] = xip[i + fx];
            this.f0 -= this.mi[i] * this.xi[i];
        }
    }

    public static void setDimension(int pdim) {
        dim = pdim;
    }

    public double evalIn(double[] xip) {
        val = this.f0;
        for (i = 0; i < dim; ++i) {
            val -= this.mi[i] * xip[i];
        }
        return val;
    }

    public void pond(double factor) {
        i = 0;
        while (i < dim) {
            int n = i++;
            this.mi[n] = this.mi[n] * factor;
        }
        this.f0 *= factor;
    }

    public void algSum(SEEDS_BendCut bcp) {
        for (i = 0; i < dim; ++i) {
            int n = i;
            this.mi[n] = this.mi[n] + bcp.mi[i];
        }
        this.f0 += bcp.f0;
    }

    public SEEDS_BendCut getClon() {
        return new SEEDS_BendCut(this.mi, this.xi, this.f0);
    }

    public void scalAdd(double value) {
        this.f0 += value;
    }
}

