/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.InputPin;
import de.core.Load;
import de.core.OutputPin;
import de.core.Pin;
import de.core.comp;
import de.core.mdb_act;
import de.core.mdb_wheel;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

class mdb_cust
extends mdb_act {
    protected FontMetrics SimpleDialogFontMetrics;
    int CaptWidth;

    public mdb_cust(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 11, 6, 1, 6, 9, 9, 1, 1, "New Name", entryperiod, exitperiod, entrymonth, exitmonth);
        this.ClassName = "mdb_cust";
        this.adjustPins();
    }

    public mdb_cust(Pin[][] PinGrid, int nnum, int x, int y, String Name, double aalpha, double bbeta, double ggamma, int entryperiod, int exitperiod, int entrymonth, int exitmonth, String llogo, int llevel) {
        super(x, y, nnum * 5 + 11, 6, (nnum * 5 + 11) / 2 - 4 - nnum % 2, 6, 9 + nnum % 2, 9 + nnum % 2, nnum + 1, 1, Name, entryperiod, exitperiod, entrymonth, exitmonth, aalpha, bbeta, ggamma, llogo, llevel);
        this.ClassName = "mdb_cust";
        this.adjustPins();
    }

    public mdb_cust(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.ClassName = "mdb_cust";
        this.HitBoxSize = new Dimension(9, 9);
        this.HitBox = new Point(1, 6);
    }

    @Override
    public void addComponent(comp newComponent) {
        if (!(newComponent instanceof Load)) {
            return;
        }
        if (!this.Components.contains(newComponent)) {
            this.Components.addElement(newComponent);
            this.adjustPins();
        }
    }

    @Override
    public void removeComponent(comp OldComponent) {
        if (!(OldComponent instanceof Load)) {
            return;
        }
        if (this.Components.remove(OldComponent)) {
            this.adjustPins();
        }
    }

    private void adjustPins() {
        int num = this.getnum();
        if (this.OPin[0] != null) {
            this.RemovePinsGrid(DeepEdit.PinGrid);
        }
        this.Inputs = num + 1;
        this.IPin = new InputPin[this.Inputs];
        this.OPin = new OutputPin[this.Outputs];
        for (int i = 0; i < num; ++i) {
            String numero = String.valueOf(i + 1);
            this.IPin[i] = new InputPin(numero, 5 * i + 8, 0, 0, 5, 1, 0, 0);
        }
        int xowner = (int)(5.0 + Math.floor(num / 2) * 5.0 + (double)(num % 2 * 3));
        this.OPin[0] = new OutputPin("Owned", xowner, 15 + num % 2, 0, 0, 0, 0, 2);
        this.IPin[num] = new InputPin("Owners", xowner, 6, 0, 0, 0, 0, 2);
        this.HitBox.x = (num * 5 + 11) / 2 - 4 - num % 2;
        this.RegisterPins(DeepEdit.PinGrid, this.getxpos(), this.getypos());
    }

    @Override
    public comp Copy(int xo, int yo) {
        mdb_cust NewComponent = new mdb_cust(this, xo, yo);
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setalpha(this.getalpha());
        NewComponent.setbeta(this.getbeta());
        NewComponent.setgamma(this.getgamma());
        NewComponent.logo = this.logo;
        return NewComponent;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        int y2min;
        int cx1 = this.Pos.x;
        int cy1 = this.Pos.y;
        int cx2 = this.Pos.x + 2 * this.HitBox.x + this.HitBoxSize.width;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height;
        int x1max = cx1 > x1 ? cx1 : x1;
        int x2min = cx2 < x2 ? cx2 : x2;
        int y1max = cy1 > y1 ? cy1 : y1;
        int n = y2min = cy2 < y2 ? cy2 : y2;
        return x1max <= x2min && y1max <= y2min;
    }

    @Override
    public void CheckPosition(DeepEdit app) {
        int xp;
        for (int o = 0; o < this.Outputs; ++o) {
            xp = this.Pos.x + this.OPin[o].PinPos.x;
            if (xp >= 0) continue;
            this.Pos.x -= xp;
        }
        for (int i = 0; i < this.Inputs; ++i) {
            xp = this.Pos.x + this.IPin[i].PinPos.x;
            if (xp >= 0) continue;
            this.Pos.x -= xp;
        }
        if (this.Pos.x < 0) {
            this.Pos.x = 0;
        }
        if (this.Pos.y < 0) {
            this.Pos.y = 0;
        }
        if (this.Pos.x > DeepEdit.getMaxXPoints() - this.Dim.width) {
            this.Pos.x = DeepEdit.getMaxXPoints() - this.Dim.width;
        }
        if (this.Pos.y > DeepEdit.getMaxYPoints() - this.Dim.height) {
            this.Pos.y = DeepEdit.getMaxYPoints() - this.Dim.height;
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component mdbcust");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" num " + this.getnum());
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" logo " + this.logo);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" alpha " + this.alpha);
        myPrintStream.println(" beta " + this.beta);
        myPrintStream.println(" gamma " + this.gamma);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO mdb_cust (XPos, YPos, Name, logo, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.logo + "'," + String.valueOf(this.alpha) + "," + String.valueOf(this.beta) + "," + String.valueOf(this.gamma) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        int num = this.getnum();
        int sf = num % 2;
        Polygon p0 = new Polygon();
        Polygon p1 = new Polygon();
        g.setColor(TextColor2);
        if (gs >= 0 && gs < 4) {
            g.setFont(Font9);
            this.SimpleDialogFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font9);
            this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(this.ComponentName);
            g.drawString(this.ComponentName, (x + (num * 5 + 10) / 2 - this.CaptWidth / 2 / gs) * gs, (y + 19 + sf) * gs);
        } else if (gs >= 4 && gs < 6) {
            g.setFont(Font11);
            this.SimpleDialogFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font11);
            this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(this.ComponentName);
            g.drawString(this.ComponentName, (x + (num * 5 + 10) / 2 - this.CaptWidth / 2 / gs) * gs, (y + 18 + sf) * gs);
        } else if (gs >= 6 && gs < 10) {
            g.setFont(Font12);
            this.SimpleDialogFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font12);
            this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(this.ComponentName);
            g.drawString(this.ComponentName, (x + (num * 5 + 10) / 2 - this.CaptWidth / 2 / gs) * gs, (y + 18 + sf) * gs);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font14);
            this.SimpleDialogFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font14);
            this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(this.ComponentName);
            g.drawString(this.ComponentName, (x + (num * 5 + 10) / 2 - this.CaptWidth / 2 / gs) * gs, (y + 17 + sf) * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            this.SimpleDialogFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font16);
            this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(this.ComponentName);
            g.drawString(this.ComponentName, (x + (num * 5 + 10) / 2 - this.CaptWidth / 2 / gs) * gs, (y + 17 + sf) * gs);
        }
        if (gs > 6) {
            g.setColor(TextColor1);
            g.setFont(Font8);
            if (num != 0) {
                for (int ix = 0; ix < this.Components.size(); ++ix) {
                    Load TempLoad = (Load)this.Components.elementAt(ix);
                    g.drawString(TempLoad.getName(), (x + 8 + 5 * ix) * gs, (y + 3) * gs);
                }
            }
        }
        g.setColor(Color.gray);
        p0.addPoint((x + 5) * gs, (y + 5) * gs);
        p0.addPoint(x * gs, y * gs);
        p0.addPoint(x * gs, (y + 1) * gs);
        p0.addPoint((x + 5) * gs, (y + 6) * gs);
        g.fillPolygon(p0);
        g.setColor(Color.black);
        g.drawPolygon(p0);
        g.setColor(Color.gray);
        p1.addPoint((x + 6 + num * 5) * gs, (y + 5) * gs);
        p1.addPoint((x + 11 + num * 5) * gs, y * gs);
        p1.addPoint((x + 11 + num * 5) * gs, (y + 1) * gs);
        p1.addPoint((x + 6 + num * 5) * gs, (y + 6) * gs);
        g.fillPolygon(p1);
        g.setColor(Color.black);
        g.drawPolygon(p1);
        g.setColor(Color.gray);
        g.fillRect((x + 5) * gs, (y + 5) * gs, (num * 5 + 1) * gs, gs);
        g.setColor(Color.yellow);
        g.fillRect((int)(((double)(x + 5 * sf) + 4.5 * (double)(1 - sf) + (double)num * 2.5) * (double)gs), (int)(((double)y + 15.5 * (double)sf + 14.5 * (double)(1 - sf)) * (double)gs), gs, gs);
        g.fillRect((int)(((double)(x + 5 * sf) + 4.5 * (double)(1 - sf) + (double)num * 2.5) * (double)gs), (int)(((double)y + 5.5) * (double)gs), gs, gs);
        g.setColor(Color.black);
        g.drawRect((int)(((double)(x + 5 * sf) + 4.5 * (double)(1 - sf) + (double)num * 2.5) * (double)gs), (int)(((double)y + 15.5 * (double)sf + 14.5 * (double)(1 - sf)) * (double)gs), gs, gs);
        g.drawRect((int)(((double)(x + 5 * sf) + 4.5 * (double)(1 - sf) + (double)num * 2.5) * (double)gs), (int)(((double)y + 5.5) * (double)gs), gs, gs);
        g.drawImage(DeepEditFrame.img_mdb_cust, (x + (num * 5 + 10) / 2 - 4) * gs, (y + 6) * gs, (9 + sf) * gs, (9 + sf) * gs, DeepEdit.MySchematicPanel);
        g.drawRect((x + (num * 5 + 10) / 2 - 4) * gs, (y + 6) * gs, (9 + sf) * gs, (9 + sf) * gs);
        g.setColor(Color.gray);
        this.DrawInputPins(g, x, y, gs);
        this.DrawOutputPins(g, x, y, gs);
    }

    public mdb_wheel[] InformAllWheelingContracts() {
        ArrayList<mdb_wheel> lWheelContract = new ArrayList<mdb_wheel>();
        for (int o = 0; o < this.Inputs; ++o) {
            assert (this.IPin[o].ConnComps != null) : "Did you forget to call SimulateSetUp before calling your calculation routine??";
            for (int ix = 0; ix < this.IPin[o].ConnComps.size(); ++ix) {
                comp ConnectedComponent = (comp)this.IPin[o].ConnComps.elementAt(ix);
                if (!(ConnectedComponent instanceof mdb_wheel)) continue;
                lWheelContract.add((mdb_wheel)ConnectedComponent);
            }
        }
        mdb_wheel[] myWheelContracts = lWheelContract.toArray(new mdb_wheel[lWheelContract.size()]);
        return myWheelContracts;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alpha")) {
            sValue = String.valueOf(this.getalpha());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("beta")) {
            sValue = String.valueOf(this.getbeta());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("gamma")) {
            sValue = String.valueOf(this.getgamma());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Logo")) {
            sValue = this.getlogo();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alpha")) {
            this.setalpha(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("beta")) {
            this.setbeta(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gamma")) {
            this.setgamma(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Logo")) {
            this.setlogo(sValue);
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

