/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.InputPin;
import de.core.OutputPin;
import de.core.PLPFrame;
import de.core.Pin;
import de.core.comp;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class hdb_res
extends hdb_ser {
    private double Vmax = 100.0;
    private double Vmin = 0.0;
    public double Vini = 0.0;
    public double Vfin = 0.0;
    public double Vinim = 0.0;
    public double Vfinm = 0.0;
    private double avfiltf = 0.0;
    private double waterVal = 10.0;
    private double simVini;
    private double simVfin;
    private int filtType = 0;
    private String elgename = " ";
    public hdb_unit FiltRecComp = null;
    private FontMetrics myFM = null;
    public double caudfilt = 0.0;
    public double cauddef = 0.0;

    public hdb_res(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 8, 1, 1, 4, 8, 1, 2, entryperiod, exitperiod, entrymonth, exitmonth);
        this.setName("Reservoir");
        this.ClassName = "hdb_res";
        this.elgename = this.ComponentName;
        this.Vmax = 1000.0;
        this.Vmin = 0.0;
        this.Vini = 0.0;
        this.Vfin = 0.0;
        this.filtType = 0;
        this.turbmin = 0.0;
        this.turbmax = 9000.0;
        this.waterVal = 10.0;
        this.adjustPins();
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_res(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double VVmin, double VVmax, double VVini, double VVfin, double latitude, double longitude, double pwat2PowRate, double pwaterVal, double pspillmin, double pspillmax, double pavfiltf, int ffiltType, double ptbmin, double ptbmax, String pelgename, boolean pground) {
        super(x, y, 4, 8, 1, 1, 4, 8, 1, Math.max(2, ffiltType + 1), Name, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, pwat2PowRate, pspillmin, pspillmax, ptbmin, ptbmax, pground);
        this.filtType = ffiltType;
        this.ClassName = "hdb_res";
        this.Vmin = VVmin;
        this.Vmax = VVmax;
        this.Vini = VVini;
        this.Vfin = VVfin;
        this.avfiltf = pavfiltf;
        this.waterVal = pwaterVal;
        this.elgename = pelgename;
        this.adjustPins();
        this.RegisterPins(PinGrid, x, y);
    }

    private void adjustPins() {
        if (this.getFiltType() == 2) {
            this.Outputs = 3;
            this.OPin = new OutputPin[this.Outputs];
            this.OPin[2] = new OutputPin("hdb_res", 5, 6, -1, 0, 0, 0, 0);
        } else {
            this.Outputs = 2;
            this.OPin = new OutputPin[this.Outputs];
        }
        this.OPin[0] = new OutputPin("hdb_res", 3, 9, 0, -1, 0, 0, 0);
        this.OPin[1] = new OutputPin("hdb_res", 5, 2, -2, 0, 0, 0, 0);
        this.IPin = new InputPin[this.Inputs];
        this.IPin[0] = new InputPin("hdb_res", 3, 1, 0, 2, 0, 0, 0);
    }

    public hdb_res rebuilt(hdb_res resToRebuilt, int pfiltType, boolean pgrounded) {
        return null;
    }

    public double getVmax() {
        return this.Vmax;
    }

    public double getVmin() {
        return this.Vmin;
    }

    public double getVini() {
        return this.Vini;
    }

    public double getVfin() {
        return this.Vfin;
    }

    public double getSimVini() {
        return this.simVini;
    }

    public double getSimVfin() {
        return this.simVfin;
    }

    public double getAvfiltf() {
        return this.avfiltf;
    }

    public int getFiltType() {
        return this.filtType;
    }

    public hdb_unit getFiltRecComp() {
        return this.FiltRecComp;
    }

    public String getElGeName() {
        return this.elgename;
    }

    public void setSimVini(double vin) {
        this.simVini = vin;
    }

    public void setSimVfin(double vfi) {
        this.simVfin = vfi;
    }

    public void setVmax(double vmx) {
        this.Vmax = vmx;
    }

    public void setVmin(double vmn) {
        this.Vmin = vmn;
    }

    public void setVini(double vin) {
        this.Vini = vin;
    }

    public void setVfin(double vfi) {
        this.Vfin = vfi;
    }

    public void setAvfiltf(double fil) {
        this.avfiltf = fil;
    }

    public void setFiltType(int ft) {
        if (this.filtType == ft) {
            return;
        }
        this.RemovePinsGrid(DeepEdit.PinGrid);
        this.filtType = ft;
        this.adjustPins();
        this.PlacePinsHere(DeepEdit.PinGrid);
    }

    public void setElGeName(String name) {
        this.elgename = name;
    }

    public double getWaterVal() {
        return this.waterVal;
    }

    public void setWaterVal(double pwv) {
        this.waterVal = pwv;
    }

    @Override
    public void SimulateLogic() {
    }

    public hdb_res(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    @Override
    public comp Copy(int xo, int yo) {
        hdb_res NewComponent = new hdb_res(this, xo, yo);
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setcost(this.getcost());
        NewComponent.setWat2PowRate(this.getWat2PowRate());
        NewComponent.setWaterVal(this.getWaterVal());
        NewComponent.setSpillmin(this.getSpillmin());
        NewComponent.setSpillmax(this.getSpillmax());
        NewComponent.setVmax(this.getVmax());
        NewComponent.setVmin(this.getVmin());
        NewComponent.setVini(this.getVini());
        NewComponent.setVfin(this.getVfin());
        NewComponent.setAvfiltf(this.getAvfiltf());
        NewComponent.setFiltType(this.getFiltType());
        NewComponent.setgrounded(this.getgrounded());
        NewComponent.setTurbmin(this.getTurbmin());
        NewComponent.setTurbmax(this.getTurbmax());
        NewComponent.setElGeName(this.getElGeName());
        return NewComponent;
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        double width;
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        String auxs = "";
        int[] pxp = new int[4];
        int[] pyp = new int[4];
        g.setColor(Color1);
        if (gs > 2 && gs < 4) {
            g.setFont(Font8);
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font12);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
        }
        if (gs > 3) {
            if (this.grounded) {
                g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
            } else {
                g.drawString(this.elgename, (x + 4) * gs, (y + 1) * gs);
            }
        }
        this.DrawOutputPins(g, x, y, gs);
        this.DrawInputPins(g, x, y, gs);
        if (!this.getgrounded()) {
            pxp[0] = (x + 1) * gs;
            pxp[1] = (x + 5) * gs;
            pxp[2] = (x + 3) * gs;
            pxp[3] = (x + 1) * gs;
            pyp[0] = (int)(((double)y + 2.75) * (double)gs);
            pyp[1] = (int)(((double)y + 2.75) * (double)gs);
            pyp[2] = (int)(((double)y + 5.75) * (double)gs);
            pyp[3] = (int)(((double)y + 2.75) * (double)gs);
            g.drawOval((x + 2) * gs, (y + 6) * gs, 2 * gs, 2 * gs);
            g.drawLine((x + 3) * gs, (int)(((double)y + 5.5) * (double)gs), (x + 3) * gs, (y + 6) * gs);
        } else {
            pxp[0] = (x + 1) * gs;
            pxp[1] = (x + 5) * gs;
            pxp[2] = (x + 3) * gs;
            pxp[3] = (x + 1) * gs;
            pyp[0] = (int)(((double)y + 3.5) * (double)gs);
            pyp[1] = (int)(((double)y + 3.5) * (double)gs);
            pyp[2] = (int)(((double)y + 6.5) * (double)gs);
            pyp[3] = (int)(((double)y + 3.5) * (double)gs);
            g.drawLine((x + 3) * gs, (y + 6) * gs, (x + 3) * gs, (y + 7) * gs);
            g.drawLine((x + 3) * gs, (y + 2) * gs, (x + 3) * gs, (int)(((double)y + 3.5) * (double)gs));
        }
        g.fillPolygon(pxp, pyp, 4);
        if (this.filtType > 0) {
            g.drawLine((x + 3) * gs, (y + 5) * gs, (x + 4) * gs, (y + 6) * gs);
        }
        if (this.filtType > 1) {
            g.drawLine((x + 4) * gs, (y + 6) * gs, (x + 5) * gs, (y + 6) * gs);
        }
        if (this.getgrounded()) {
            g.drawLine((x + 3) * gs, (y + 7) * gs, (x + 3) * gs, (y + 8) * gs);
        }
        if (gs > 3) {
            if (!this.getgrounded()) {
                g.drawString("~", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 7.5) * (double)gs));
                width = g.getFontMetrics(g.getFont()).getStringBounds(this.ComponentName, g).getWidth();
                g.drawString(this.ComponentName, (int)((double)((x + 2) * gs) - width), (y + 6) * gs);
                g.setColor(Color.black);
                g.drawString("R", (int)(((double)x + 2.6) * (double)gs), (int)(((double)y + 4.3) * (double)gs));
            } else {
                g.setColor(Color.black);
                g.drawString("R", (int)(((double)x + 2.6) * (double)gs), (int)(((double)y + 4.9) * (double)gs));
            }
        }
        if (gs > 6 && PLPFrame.View && !Modifiedstate) {
            g.setColor(Color5);
            if (this.caudaffl != 0.0) {
                auxs = "Suma Caud. Affl:" + StringUtil.numformat(this.caudaffl, 7, 1) + "- Def: " + this.cauddef + " m\u00b3/s";
                width = g.getFontMetrics(g.getFont()).getStringBounds(auxs, g).getWidth();
                g.drawString(auxs, (int)((double)((x + 2) * gs) - width), (y + 1) * gs);
            }
            if (hdb_comp.simView) {
                auxs = StringUtil.numformat(this.simVini, 10, 2) + " Mm\u00b3";
                width = g.getFontMetrics(g.getFont()).getStringBounds(auxs, g).getWidth();
                g.drawString(auxs, (int)((double)(x * gs) - width), (y + 2) * gs);
                g.drawString(StringUtil.numformat(this.simVfin, 10, 2) + " Mm\u00b3", (int)((double)(x * gs) - width), (y + 3) * gs);
            } else {
                auxs = StringUtil.numformat(this.Vini, 10, 2) + " Mm\u00b3";
                width = g.getFontMetrics(g.getFont()).getStringBounds(auxs, g).getWidth();
                g.drawString(auxs, (int)((double)(x * gs) - width), (y + 2) * gs);
                g.drawString(StringUtil.numformat(this.Vfin, 10, 2) + " Mm\u00b3", (int)((double)(x * gs) - width), (y + 3) * gs);
            }
            g.drawString(StringUtil.numformat(this.Vinim, 9, 1) + " msnm", (int)((double)(x * gs) - width), (y + 4) * gs);
            g.drawString(StringUtil.numformat(this.Vfinm, 9, 1) + " msnm", (int)((double)(x * gs) - width), (y + 5) * gs);
            g.drawString(StringUtil.numformat(this.caudspill, 7, 1) + " m\u00b3/s", (x + 5) * gs, (y + 2) * gs);
            g.drawString(StringUtil.numformat(this.caudgener, 7, 1) + " m\u00b3/s", (x + 3) * gs, (y + 9) * gs);
            if (this.filtType > 0) {
                g.drawString(StringUtil.numformat(this.caudfilt, 7, 1) + "m\u00b3/s", (x + 5) * gs, (y + 6) * gs);
            }
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component hdbres");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.cost);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" Vmax " + this.Vmax);
        myPrintStream.println(" Vmin " + this.Vmin);
        myPrintStream.println(" Vini " + this.Vini);
        myPrintStream.println(" Vfin " + this.Vfin);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" Wat2PowRate " + this.wat2PowRate);
        myPrintStream.println(" WaterVal " + this.waterVal);
        myPrintStream.println(" SpillMin " + this.spillmin);
        myPrintStream.println(" SpillMax " + this.spillmax);
        myPrintStream.println(" AvfiltFact " + this.avfiltf);
        myPrintStream.println(" filtType " + this.filtType);
        myPrintStream.println(" TurbMin " + this.turbmin);
        myPrintStream.println(" TurbMax " + this.turbmax);
        myPrintStream.println(" ElGeName " + this.elgename);
        myPrintStream.println(" grounded " + this.grounded);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO hdb_res (XPos,YPos,Name,type,owner,cost,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,latitude,longitude,Vmax,Vmin,Vini,Vfin,wat2powrate,waterVal,spillmin,spillmax,avfiltf,filtType,turbmin,turbmax,elgename,grounded) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "'," + String.valueOf(this.cost) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.Vmax) + "," + String.valueOf(this.Vmin) + "," + String.valueOf(this.Vini) + "," + String.valueOf(this.Vfin) + "," + String.valueOf(this.wat2PowRate) + "," + String.valueOf(this.waterVal) + "," + String.valueOf(this.spillmin) + "," + String.valueOf(this.spillmax) + "," + String.valueOf(this.avfiltf) + "," + String.valueOf(this.filtType) + "," + String.valueOf(this.turbmin) + "," + String.valueOf(this.turbmax) + ",'" + this.elgename + "'," + (this.grounded ? 1 : 0) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public boolean InformRecipients() {
        this.FiltRecComp = null;
        if (!super.InformRecipients()) {
            return false;
        }
        if (this.filtType < 2) {
            return true;
        }
        boolean allOK = true;
        Vector ActComp = this.OPin[2].ConnComps;
        boolean linkfinded = false;
        for (int ix = 0; ix < ActComp.size(); ++ix) {
            comp tempcomp = (comp)ActComp.elementAt(ix);
            if (!(tempcomp instanceof hdb_link)) continue;
            if (linkfinded) {
                System.out.println(this.getName() + " has two outputs in " + this.ClassName);
                return false;
            }
            linkfinded = true;
            hdb_link tempLink = (hdb_link)tempcomp;
            tempcomp = tempLink.CompAtOut;
            if (!(tempcomp instanceof hdb_ser) && !(tempcomp instanceof hdb_irr)) {
                System.out.println("mis connected to " + tempcomp.getName());
                return false;
            }
            this.FiltRecComp = (hdb_unit)tempcomp;
        }
        return allOK;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("Vmax")) {
            sValue = String.valueOf(this.getVmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("Vmin")) {
            sValue = String.valueOf(this.getVmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("Vini")) {
            sValue = String.valueOf(this.getVini());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("Vfin")) {
            sValue = String.valueOf(this.getVfin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("wat2powrate")) {
            sValue = String.valueOf(this.getWat2PowRate());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("waterVal")) {
            sValue = String.valueOf(this.getWaterVal());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("turbmin")) {
            sValue = String.valueOf(this.getTurbmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("turbmax")) {
            sValue = String.valueOf(this.getTurbmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmin")) {
            sValue = String.valueOf(this.getSpillmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmax")) {
            sValue = String.valueOf(this.getSpillmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("avfiltf")) {
            sValue = String.valueOf(this.getAvfiltf());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("filtType")) {
            sValue = String.valueOf(this.getFiltType());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("elgename")) {
            sValue = this.getElGeName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.gettype();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getowner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getcost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("grounded")) {
            sValue = String.valueOf(this.getgrounded());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Vmax")) {
            this.setVmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Vmin")) {
            this.setVmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Vini")) {
            this.setVini(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Vfin")) {
            this.setVfin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("wat2powrate")) {
            this.setWat2PowRate(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("waterVal")) {
            this.setWaterVal(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("turbmin")) {
            this.setTurbmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("turbmax")) {
            this.setTurbmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmin")) {
            this.setSpillmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmax")) {
            this.setSpillmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("avfiltf")) {
            this.setAvfiltf(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("filtType")) {
            this.setFiltType((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("elgename")) {
            this.setElGeName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.settype(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setowner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setcost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("grounded")) {
            this.setgrounded(Boolean.parseBoolean(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

