/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.InputPin;
import de.core.OutputPin;
import de.core.PLPFrame;
import de.core.Pin;
import de.core.comp;
import de.core.hdb_unit;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

public class hdb_paspur
extends hdb_unit {
    private boolean isRegulTank;
    private double tankcapa = 100000.0;
    private double[] regulBFact = null;
    public static int blockIn = 0;

    public hdb_paspur(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 1, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("Pasada_Pura", 3, 8, 0, -2, 0, 0, 0);
        this.IPin[0] = new InputPin("Pasada_Pura", 3, 1, 0, 2, 0, 0, 0);
        this.setName("Pasada_Pura");
        this.ClassName = "hdb_paspur";
        this.isRegulTank = false;
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_paspur(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double latitude, double longitude, double pwat2PowRate, double pspillmin, double pspillmax, boolean iisRegulTank, boolean pground) {
        super(x, y, 4, 7, 1, 1, 4, 7, 1, 1, Name, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, pground, pspillmin, pspillmax, pwat2PowRate);
        this.OPin[0] = new OutputPin(Name, 3, 8, 0, -2, 0, 0, 0);
        this.IPin[0] = new InputPin(Name, 3, 1, 0, 2, 0, 0, 0);
        this.ClassName = "hdb_paspur";
        this.RegisterPins(PinGrid, x, y);
        this.isRegulTank = iisRegulTank;
    }

    public hdb_paspur(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    public boolean getIsRegulTank() {
        return this.isRegulTank;
    }

    public void setIsRegulTank(boolean val) {
        this.isRegulTank = val;
    }

    public double getRegulTankCapa() {
        if (this.isRegulTank) {
            return this.tankcapa;
        }
        return 0.0;
    }

    public void setRegulTankCapa(double capa) {
        this.tankcapa = capa;
    }

    @Override
    public comp Copy(int xo, int yo) {
        hdb_paspur NewComponent = new hdb_paspur(this, xo, yo);
        NewComponent.setIsRegulTank(this.getIsRegulTank());
        NewComponent.setWat2PowRate(this.getWat2PowRate());
        NewComponent.setSpillmin(this.getSpillmin());
        NewComponent.setSpillmax(this.getSpillmax());
        NewComponent.setgrounded(this.getgrounded());
        NewComponent.setcost(this.getcost());
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setlife_time(this.getlife_time());
        return NewComponent;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        String auxs = "";
        g.setColor(Color5);
        if (gs > 3 && gs < 7) {
            g.setFont(Font8);
            g.drawString("PP", (int)(((double)x + 2.3) * (double)gs), (int)(((double)y + 5.05) * (double)gs));
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 7 && gs < 9) {
            g.setFont(Font10);
            g.drawString("PP", (int)(((double)x + 2.3) * (double)gs), (int)(((double)y + 5.05) * (double)gs));
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 9 && gs < 11) {
            g.setFont(Font12);
            g.drawString("PP", (int)(((double)x + 2.3) * (double)gs), (int)(((double)y + 5.05) * (double)gs));
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 11 && gs < 14) {
            g.setFont(Font14);
            g.drawString("PP", (int)(((double)x + 2.4) * (double)gs), (int)(((double)y + 4.95) * (double)gs));
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            g.drawString("PP", (int)(((double)x + 2.4) * (double)gs), (int)(((double)y + 4.95) * (double)gs));
            g.drawString(this.ComponentName, (x + 4) * gs, y * gs);
        }
        g.drawOval((int)(((double)x + 1.5) * (double)gs), (y + 3) * gs, 3 * gs, 3 * gs);
        if (this.isRegulTank) {
            int[] xl = new int[4];
            int[] yl = new int[4];
            xl[0] = (int)(((double)x + 1.3) * (double)gs);
            xl[1] = (int)(((double)x + 2.7) * (double)gs);
            xl[2] = (int)(((double)x + 2.4) * (double)gs);
            xl[3] = (int)(((double)x + 1.6) * (double)gs);
            yl[0] = (int)(((double)y + 1.5) * (double)gs);
            yl[1] = yl[0];
            yl[2] = (int)(((double)y + 2.7) * (double)gs);
            yl[3] = yl[2];
            g.fillPolygon(xl, yl, 4);
            g.drawLine((x + 2) * gs, (int)(((double)y + 1.7) * (double)gs), (x + 3) * gs, (int)(((double)y + 1.7) * (double)gs));
            g.drawLine((x + 2) * gs, (int)(((double)y + 2.7) * (double)gs), (int)(((double)x + 2.4) * (double)gs), (int)(((double)y + 3.2) * (double)gs));
        }
        this.DrawOutputPins(g, x, y, gs);
        this.DrawInputPins(g, x, y, gs);
        if (gs > 6 && PLPFrame.View) {
            g.setColor(Color5);
            if (this.caudaffl != 0.0) {
                auxs = "Sum Q.Afl:" + StringUtil.numformat(this.caudaffl, 7, 1) + "m\u00b3/s";
                double width = g.getFontMetrics(g.getFont()).getStringBounds(auxs, g).getWidth();
                g.drawString(auxs, (int)((double)((x + 2) * gs) - width), (y + 1) * gs);
            }
            g.drawString(StringUtil.numformat(this.caudgener, 7, 1) + "m\u00b3/s", (x + 3) * gs, (y + 8) * gs);
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component hdbpaspur");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.cost);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" Wat2PowRate " + this.wat2PowRate);
        myPrintStream.println(" SpillMin " + this.spillmin);
        myPrintStream.println(" SpillMax " + this.spillmax);
        myPrintStream.println(" isRegulTank " + this.isRegulTank);
        myPrintStream.println(" grounded " + this.grounded);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO hdb_paspur (XPos,YPos,Name,type,owner,cost,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,latitude,longitude,wat2powrate,spillmin,spillmax,isRegulTank, grounded) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "'," + String.valueOf(this.cost) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.wat2PowRate) + "," + String.valueOf(this.spillmin) + "," + String.valueOf(this.spillmax) + "," + (this.isRegulTank ? 1 : 0) + "," + (this.grounded ? 1 : 0) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public static void makeRegulBF(hdb_paspur myRofR, double sumQAff, int[] blockDur, int stageDur, Generator myGen) {
        if (!myRofR.isRegulTank) {
            return;
        }
        if (myRofR.regulBFact == null || myRofR.regulBFact.length < blockDur.length) {
            myRofR.regulBFact = new double[blockDur.length];
            for (int ix = 0; ix < blockDur.length; ++ix) {
                myRofR.regulBFact[ix] = 1.0;
            }
        }
        if (sumQAff == 0.0) {
            return;
        }
        double transCapa = myRofR.tankcapa * (double)stageDur / 24.0;
        double waterV = sumQAff * 3600.0 * (double)stageDur;
        transCapa = Math.min(waterV, transCapa);
        double qmed = (waterV -= transCapa) / (double)(3600 * stageDur);
        int bx = 0;
        do {
            double qblock;
            if (transCapa > 0.0) {
                qblock = Math.min(qmed + transCapa / (double)blockDur[0] / 3600.0, myGen.getpmax() / myRofR.wat2PowRate);
                transCapa -= (qblock - qmed) * (double)blockDur[0] * 3600.0;
            } else {
                qblock = qmed;
            }
            myRofR.regulBFact[bx] = qblock / sumQAff;
        } while (++bx < blockDur.length);
    }

    public double getRegulBFact() {
        if (this.isRegulTank && this.regulBFact != null) {
            return this.regulBFact[blockIn];
        }
        return 1.0;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("wat2powrate")) {
            sValue = String.valueOf(this.getWat2PowRate());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmin")) {
            sValue = String.valueOf(this.getSpillmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmax")) {
            sValue = String.valueOf(this.getSpillmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.gettype();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getowner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getcost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("isRegulTank")) {
            sValue = String.valueOf(this.getIsRegulTank());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("grounded")) {
            sValue = String.valueOf(this.getgrounded());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("wat2powrate")) {
            this.setWat2PowRate(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmin")) {
            this.setSpillmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmax")) {
            this.setSpillmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.settype(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setowner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setcost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("isRegulTank")) {
            this.setIsRegulTank(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("grounded")) {
            this.setgrounded(Boolean.parseBoolean(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

