/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.Pin;
import de.core.Schematic;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class hdb_link
extends hdb_comp {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int[] xpoly = new int[32];
    private int[] ypoly = new int[32];
    public int ChangingWire = 0;
    public int ChangingWirePoly = 0;
    protected int npoly;
    public Vector ConnComps1;
    public Vector ConnComps2;
    public String in;
    public String out;
    public hdb_comp CompAtIn = null;
    public hdb_comp CompAtOut = null;
    private String tipoInput = " ";
    private String tipoOutput = " ";
    boolean reverse = false;
    boolean flow = false;
    private boolean checkPLPCompatible = false;
    private Color linkColor = new Color(143, 182, 197);
    private double[] xpolysim = new double[500];
    private double[] ypolysim = new double[500];
    private int npolysim;
    private int pospolysim;

    public hdb_link(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, y, y, x, y, y, y, y, y, entryperiod, exitperiod, entrymonth, exitmonth);
        this.setName("Link");
        this.ClassName = "hdb_link";
        this.in = "0";
        this.out = "0";
        this.x1 = x;
        this.y1 = y;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
    }

    public hdb_link(Pin[][] PinGrid, int Xpos1, int Ypos1, int Xpos2, int Ypos2, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this(PinGrid, Xpos1, Ypos1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.x1 = Xpos1;
        this.y1 = Ypos1;
        this.x2 = Xpos2;
        this.y2 = Ypos2;
        this.PlacePinsHere(PinGrid);
    }

    public hdb_link(comp CompToCopy, int xo, int yo) {
        this.setName("Link");
    }

    public hdb_link(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, int[] xxpoly, int[] yypoly, int nnpoly) {
        super(Name, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth);
        this.ClassName = "hdb_link";
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        for (int i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        this.npoly = nnpoly;
        this.PlacePinsHere(PinGrid);
    }

    @Override
    public comp Copy(int xo, int yo) {
        hdb_link NewComponent = new hdb_link(this, xo, yo);
        NewComponent.x1 = this.x1 - xo;
        NewComponent.y1 = this.y1 - yo;
        NewComponent.x2 = this.x2 - xo;
        NewComponent.y2 = this.y2 - yo;
        NewComponent.setName(this.getName());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setentry_month(this.getentry_month());
        NewComponent.setexit_month(this.getexit_month());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setcost(this.getcost());
        for (int i = 0; i < this.getnpoly(); ++i) {
            NewComponent.xpoly[i] = this.xpoly[i] - xo;
            NewComponent.ypoly[i] = this.ypoly[i] - yo;
        }
        NewComponent.setnpoly(this.getnpoly());
        return NewComponent;
    }

    public int getnpoly() {
        return this.npoly;
    }

    public int getx1() {
        return this.x1;
    }

    public int getx2() {
        return this.x2;
    }

    public int gety1() {
        return this.y1;
    }

    public int gety2() {
        return this.y2;
    }

    public String getTipoInput() {
        return this.tipoInput;
    }

    public String getTipoOutput() {
        return this.tipoOutput;
    }

    public void setnpoly(int n) {
        this.npoly = n;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public void CheckPosition(DeepEdit app) {
        if (this.x1 < 1) {
            this.x1 = 1;
        }
        if (this.x1 >= DeepEdit.getMaxXPoints()) {
            this.x1 = DeepEdit.getMaxXPoints() - 1;
        }
        if (this.y1 < 1) {
            this.y1 = 1;
        }
        if (this.y1 >= DeepEdit.getMaxYPoints()) {
            this.y1 = DeepEdit.getMaxYPoints() - 1;
        }
        if (this.x2 < 1) {
            this.x2 = 1;
        }
        if (this.x2 >= DeepEdit.getMaxXPoints()) {
            this.x2 = DeepEdit.getMaxXPoints() - 1;
        }
        if (this.y2 < 1) {
            this.y2 = 1;
        }
        if (this.y2 >= DeepEdit.getMaxYPoints()) {
            this.y2 = DeepEdit.getMaxYPoints() - 1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.xpoly[i] < 1) {
                this.xpoly[i] = 1;
            }
            if (this.xpoly[i] >= DeepEdit.getMaxXPoints()) {
                this.xpoly[i] = DeepEdit.getMaxXPoints() - 1;
            }
            if (this.ypoly[i] < 1) {
                this.ypoly[i] = 1;
            }
            if (this.ypoly[i] < DeepEdit.getMaxYPoints()) continue;
            this.ypoly[i] = DeepEdit.getMaxYPoints() - 1;
        }
    }

    public boolean InformEndComponents() {
        boolean allok = false;
        this.CompAtOut = null;
        this.CompAtIn = null;
        this.tipoOutput = " ";
        this.tipoInput = " ";
        this.reverse = false;
        Vector ActVector = this.ConnComps1;
        while (true) {
            boolean pinlinkcon = false;
            boolean pinaffcon = false;
            if (ActVector == null) continue;
            for (int ix = 0; ix < ActVector.size(); ++ix) {
                int conout;
                comp ConnectedComponent = (comp)ActVector.elementAt(ix);
                if (ConnectedComponent == this || !(ConnectedComponent instanceof hdb_comp)) continue;
                hdb_comp temphcomp = (hdb_comp)ConnectedComponent;
                if (temphcomp instanceof hdb_link && this.checkPLPCompatible) {
                    if (pinaffcon) {
                        return false;
                    }
                    pinlinkcon = true;
                    continue;
                }
                if (temphcomp instanceof hdb_paspur) {
                    conout = temphcomp.InformOutput(this);
                    if (conout != -1) {
                        return false;
                    }
                    if (this.CompAtOut != null) {
                        return false;
                    }
                    this.CompAtOut = temphcomp;
                    this.tipoOutput = "Input Passing Pure Central";
                    if (ActVector != this.ConnComps1) continue;
                    this.reverse = true;
                    continue;
                }
                if (temphcomp instanceof hdb_ser || temphcomp instanceof hdb_irr) {
                    hdb_unit temphunit;
                    hdb_ser temphser;
                    conout = temphcomp.InformOutput(this);
                    int conin = temphcomp.InformInput(this);
                    if (conin != -1) {
                        if (this.CompAtOut != null) {
                            return false;
                        }
                        this.CompAtOut = temphcomp;
                        this.tipoOutput = temphcomp instanceof hdb_res ? "Input Reservoir" : (temphcomp instanceof hdb_irr ? "Input Irrigation" : "Input Series");
                        if (temphcomp instanceof hdb_ser) {
                            temphser = (hdb_ser)temphcomp;
                            this.tipoOutput = !temphser.getgrounded() ? this.tipoOutput + " Central" : this.tipoOutput + " Unit";
                        }
                        if (ActVector != this.ConnComps1) continue;
                        this.reverse = true;
                        continue;
                    }
                    if (this.CompAtIn != null) {
                        return false;
                    }
                    this.CompAtIn = temphcomp;
                    if (conout == 2) {
                        this.tipoInput = "Filtering from ";
                    }
                    if (conout == 1) {
                        this.tipoInput = "Spilled from ";
                    }
                    if (conout == 0) {
                        this.tipoInput = "Turbined from ";
                    }
                    if (temphcomp instanceof hdb_res) {
                        this.tipoInput = this.tipoInput + "Reservoir";
                        hdb_res temphres = (hdb_res)temphcomp;
                        this.linkColor = new Color(143, 182, 197);
                        this.flow = false;
                        if (conout == 2 && temphres.caudfilt > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                        if (conout == 1 && temphres.caudspill > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                        if (conout == 0 && temphres.caudgener > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                    } else if (temphcomp instanceof hdb_irr) {
                        this.tipoInput = "Remainder from Irrigation";
                        temphunit = (hdb_unit)temphcomp;
                        this.linkColor = new Color(143, 182, 197);
                        if (conout == 1 && temphunit.caudspill > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                        if (conout == 0 && temphunit.caudgener > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                    } else {
                        this.tipoInput = this.tipoInput + "Series ";
                        temphunit = (hdb_unit)temphcomp;
                        this.linkColor = new Color(143, 182, 197);
                        if (conout == 1 && temphunit.caudspill > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                        if (conout == 0 && temphunit.caudgener > 0.01) {
                            this.linkColor = Color.blue;
                            this.flow = true;
                        }
                    }
                    if (!(temphcomp instanceof hdb_ser)) continue;
                    temphser = (hdb_ser)temphcomp;
                    if (!temphser.getgrounded()) {
                        this.tipoInput = this.tipoInput + " Central";
                        continue;
                    }
                    this.tipoInput = this.tipoInput + " Unit";
                    continue;
                }
                if (!(temphcomp instanceof hdb_affl)) continue;
                if (this.checkPLPCompatible) {
                    if (this.CompAtIn != null) {
                        return false;
                    }
                    if (pinlinkcon) {
                        return false;
                    }
                    pinaffcon = true;
                }
                this.CompAtIn = temphcomp;
                this.linkColor = Color.blue;
                this.flow = true;
                this.tipoInput = "Affluent";
            }
            if (ActVector == this.ConnComps2) break;
            ActVector = this.ConnComps2;
        }
        if (this.CompAtIn != null && this.CompAtOut != null) {
            if (!(this.CompAtIn instanceof hdb_affl) && this.CompAtOut instanceof hdb_paspur) {
                return false;
            }
            allok = true;
        }
        return allok;
    }

    public hdb_unit getUnitIN() {
        if (this.x1 < 0 || this.y1 < 0) {
            return null;
        }
        Pin mypin = DeepEdit.PinGrid[this.x1][this.y1];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (Object o : mypin.GetAllComponents()) {
                if (!(o instanceof hdb_unit) || o.equals(this)) continue;
                return (hdb_unit)o;
            }
        }
        return null;
    }

    public hdb_unit getUnitOUT() {
        if (this.x2 < 0 || this.y2 < 0) {
            return null;
        }
        Pin mypin = DeepEdit.PinGrid[this.x2][this.y2];
        if (mypin != null && mypin.ComponentsSize() > 0) {
            for (Object o : mypin.GetAllComponents()) {
                if (!(o instanceof hdb_unit) || o.equals(this)) continue;
                return (hdb_unit)o;
            }
        }
        return null;
    }

    public boolean hasEndComp() {
        return this.CompAtIn != null && this.CompAtOut != null;
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        if (!DeepEdit.MyStatusPanel.isSimulationRunning()) {
            int i;
            int auxint = 1;
            g.setColor(this.linkColor);
            if (this.flow) {
                auxint = 2;
            }
            if (this.npoly > 0) {
                GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, auxint);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawLine(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, auxint);
                }
                GraphicsUtil.drawLine(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
            } else {
                GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
            }
            if (this.isSelected()) {
                Stroke g_old = g.getStroke();
                g.setColor(TextColor1);
                if (this.getUnitIN() != null && this.getUnitOUT() != null) {
                    g.setStroke(new BasicStroke(3.0f));
                }
                if ((this.ChangingWire & 1) == 1) {
                    g.drawRect((int)(((double)(this.x1 - xp) - 0.25) * (double)gs), (int)(((double)(this.y1 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
                if (this.ChangingWire == 3) {
                    for (i = 0; i < this.npoly; ++i) {
                        g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                    }
                }
                if ((this.ChangingWire & 2) == 2) {
                    g.drawRect((int)(((double)(this.x2 - xp) - 0.25) * (double)gs), (int)(((double)(this.y2 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
                g.setStroke(g_old);
            }
            g.setColor(TextColor1);
            for (i = 0; i < this.npoly; ++i) {
                if (this.ChangingWirePoly != i + 1) continue;
                g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
            g.setColor(TextColor2);
            if (gs >= 0 && gs < 8) {
                g.setFont(Font10);
            }
            if (gs >= 4 && gs < 8) {
                g.setFont(Font9);
            } else if (!(gs >= 8 && gs < 10 || gs >= 10 && gs < 14 || gs < 14 || gs >= 18)) {
                g.setFont(Font14);
                if (this.npoly > 0) {
                    g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
                } else {
                    g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
                }
            }
            if (gs >= 4) {
                if (gs >= 4) {
                    g.setFont(Font9);
                } else if (gs >= 8) {
                    g.setFont(Font10);
                } else if (gs >= 12) {
                    g.setFont(Font12);
                }
            }
        } else if (this.reverse) {
            if (this.flow && this.npolysim > 0) {
                if (this.pospolysim == 0) {
                    this.pospolysim = this.npolysim - 1;
                }
                g.setColor(this.auxcolor);
                GraphicsUtil.drawArrow(g, (int)((this.xpolysim[this.pospolysim] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim] - (double)yp) * (double)gs), (int)((this.xpolysim[this.pospolysim - 1] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim - 1] - (double)yp) * (double)gs), 2, (int)((double)gs * 1.5));
                --this.pospolysim;
            }
        } else if (this.flow && this.npolysim > 0) {
            if (this.pospolysim == this.npolysim - 1) {
                this.pospolysim = 0;
            }
            g.setColor(this.auxcolor);
            GraphicsUtil.drawArrow(g, (int)((this.xpolysim[this.pospolysim] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim] - (double)yp) * (double)gs), (int)((this.xpolysim[this.pospolysim + 1] - (double)xp) * (double)gs), (int)((this.ypolysim[this.pospolysim + 1] - (double)yp) * (double)gs), 2, (int)((double)gs * 1.5));
            ++this.pospolysim;
        }
    }

    public void calcnumint(int px1, int py1, int px2, int py2) {
        boolean i = false;
        double numint = Math.sqrt((double)(px1 - px2) * (double)(px1 - px2) + (double)(py1 - py2) * (double)(py1 - py2)) / 2.0;
    }

    @Override
    public void RemovePinsGrid(Pin[][] PinGrid) {
        this.RemovePin(PinGrid[this.x1][this.y1]);
        this.RemovePin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void RegisterPins(Pin[][] PinGrid, int x, int y) {
        if (PinGrid == null) {
            return;
        }
        if (PinGrid[this.x1][this.y1] == null) {
            PinGrid[this.x1][this.y1] = new Pin();
        }
        if (PinGrid[this.x2][this.y2] == null) {
            PinGrid[this.x2][this.y2] = new Pin();
        }
        this.RegisterPin(PinGrid[this.x1][this.y1]);
        this.RegisterPin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void PlacePinsHere(Pin[][] PinGrid) {
        if (PinGrid == null) {
            return;
        }
        this.RegisterPins(PinGrid, 0, 0);
    }

    public void Set2ndCoord(Pin[][] PinGrid, int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component hdblink");
        myPrintStream.println(" pos " + this.x1 + " " + this.y1);
        myPrintStream.println(" pos2 " + this.x2 + " " + this.y2);
        for (int i = 0; i < this.npoly; ++i) {
            myPrintStream.println(" pospoly " + this.xpoly[i] + " " + this.ypoly[i]);
        }
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.cost);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println("end describe ");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        int i = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO hdb_link (XPos,YPos,XPos2,YPos2,numpoly,Name,type,owner,cost,lifetime,entryperiod,exitperiod,entrymonth,exitmonth";
        for (i = 0; i < this.npoly; ++i) {
            query = query + ", pospolyx" + String.valueOf(i + 1);
        }
        for (i = 0; i < this.npoly; ++i) {
            query = query + ", pospolyy" + String.valueOf(i + 1);
        }
        query = query + ") VALUES (" + String.valueOf(this.x1) + "," + String.valueOf(this.y1) + "," + String.valueOf(this.x2) + "," + String.valueOf(this.y2) + "," + String.valueOf(this.npoly) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "'," + String.valueOf(this.cost) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month);
        for (i = 0; i < this.npoly; ++i) {
            query = query + "," + String.valueOf(this.xpoly[i]);
        }
        for (i = 0; i < this.npoly; ++i) {
            query = query + "," + String.valueOf(this.ypoly[i]);
        }
        query = query + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int tx1, int ty1, int tx2, int ty2) {
        int cy2;
        int cy1;
        int cx2;
        int cx1;
        if (this.x1 < this.x2) {
            cx1 = this.x1;
            cx2 = this.x2;
        } else {
            cx1 = this.x2;
            cx2 = this.x1;
        }
        if (this.y1 < this.y2) {
            cy1 = this.y1;
            cy2 = this.y2;
        } else {
            cy1 = this.y2;
            cy2 = this.y1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (cx1 > this.xpoly[i]) {
                cx1 = this.xpoly[i];
            }
            if (cx2 < this.xpoly[i]) {
                cx2 = this.xpoly[i];
            }
            if (cy1 > this.ypoly[i]) {
                cy1 = this.ypoly[i];
            }
            if (cy2 >= this.ypoly[i]) continue;
            cy2 = this.ypoly[i];
        }
        int x1max = cx1 > tx1 ? cx1 : tx1;
        int x2min = cx2 < tx2 ? cx2 : tx2;
        int y1max = cy1 > ty1 ? cy1 : ty1;
        int y2min = cy2 < ty2 ? cy2 : ty2;
        return x1max <= x2min && y1max <= y2min;
    }

    @Override
    public boolean AdjustPosition(Pin[][] PinGrid, int x, int y) {
        int nx1 = this.x1;
        int ny1 = this.y1;
        int nx2 = this.x2;
        int ny2 = this.y2;
        if ((this.ChangingWire & 1) == 1) {
            nx1 += x;
            ny1 += y;
        }
        if ((this.ChangingWire & 2) == 2) {
            nx2 += x;
            ny2 += y;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1 && this.ChangingWire != 3) continue;
            int n = i;
            this.xpoly[n] = this.xpoly[n] + x;
            int n2 = i;
            this.ypoly[n2] = this.ypoly[n2] + y;
        }
        if (nx1 == nx2 && ny1 == ny2) {
            return false;
        }
        this.x1 = nx1;
        this.y1 = ny1;
        this.x2 = nx2;
        this.y2 = ny2;
        return true;
    }

    public int sgn(int val) {
        if (val > 0) {
            return 1;
        }
        if (val < 0) {
            return -1;
        }
        return 0;
    }

    public boolean CheckIfPointInWire(int a, int b, int c, int d, int x, int y) {
        int n;
        int u = c - a;
        int v = d - b;
        int d1x = this.sgn(u);
        int d1y = this.sgn(v);
        int d2x = this.sgn(u);
        int d2y = 0;
        int m = Math.abs(u);
        if (m <= (n = Math.abs(v))) {
            d2x = 0;
            d2y = this.sgn(v);
            m = Math.abs(v);
            n = Math.abs(u);
        }
        int s = m / 2;
        for (int i = 0; i < m; ++i) {
            if (Math.abs(x - a) < 2 && Math.abs(y - b) < 2) {
                return true;
            }
            if ((s += n) >= m) {
                s -= m;
                a += d1x;
                b += d1y;
                continue;
            }
            a += d2x;
            b += d2y;
        }
        return false;
    }

    @Override
    public void SimulateSetUp(int x, int y, Vector ActComps) {
        if (x == this.x1 && y == this.y1) {
            this.ConnComps1 = ActComps;
        }
        if (x == this.x2 && y == this.y2) {
            this.ConnComps2 = ActComps;
        }
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        this.auxcolor = this.linkColor;
        this.npolysim = 0;
        double numint = Math.sqrt((double)(this.x1 - this.x2) * (double)(this.x1 - this.x2) + (double)(this.y1 - this.y2) * (double)(this.y1 - this.y2)) / 2.0;
        if (numint > 500.0) {
            numint = 500.0;
        }
        for (int i = 0; i < (int)numint; ++i) {
            ++this.npolysim;
            this.xpolysim[this.npolysim - 1] = (double)this.x1 + (double)(this.x2 - this.x1) / numint * (double)(i + 1);
            this.ypolysim[this.npolysim - 1] = (double)this.y1 + (double)(this.y2 - this.y1) / numint * (double)(i + 1);
        }
    }

    @Override
    public boolean CheckIfComponentClicked(int x, int y) {
        int i;
        if (x == this.x1 && y == this.y1) {
            this.ChangingWire = 1;
            return true;
        }
        if (x == this.x2 && y == this.y2) {
            this.ChangingWire = 2;
            return true;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            this.ChangingWirePoly = i + 1;
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.xpoly[0], this.ypoly[0], x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1], this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i], this.ypoly[i], this.xpoly[i + 1], this.ypoly[i + 1], x, y)) continue;
                this.ChangingWire = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLocatedAt(int x, int y) {
        return this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y);
    }

    @Override
    public boolean CheckIfComponentInSelectBox(int tx1, int ty1, int tx2, int ty2) {
        this.setSelected(false);
        this.ChangingWire = 0;
        this.ChangingWirePoly = 0;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            this.ChangingWire |= 1;
            this.setSelected(true);
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            this.ChangingWire |= 2;
            this.setSelected(true);
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            this.ChangingWirePoly = i + 1;
            this.setSelected(true);
        }
        return this.isSelected();
    }

    public boolean TryPlaceJunction(Schematic ActSchematic, Pin[][] PinGrid, int x, int y, int gs) {
        int i;
        if (x == this.x1 && y == this.y1) {
            return false;
        }
        if (x == this.x2 && y == this.y2) {
            return false;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            --this.npoly;
            for (int j = i; j < this.npoly; ++j) {
                this.xpoly[j] = this.xpoly[j + 1];
                this.ypoly[j] = this.ypoly[j + 1];
            }
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.xpoly[0] * gs, this.ypoly[0] * gs, x * gs, y * gs)) {
                for (i = this.npoly; i > 0; --i) {
                    this.xpoly[i] = this.xpoly[i - 1];
                    this.ypoly[i] = this.ypoly[i - 1];
                }
                this.xpoly[0] = x;
                this.ypoly[0] = y;
                ++this.npoly;
                this.ChangingWirePoly = 1;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1] * gs, this.ypoly[this.npoly - 1] * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i] * gs, this.ypoly[i] * gs, this.xpoly[i + 1] * gs, this.ypoly[i + 1] * gs, x * gs, y * gs)) continue;
                for (int j = this.npoly; j > i; --j) {
                    this.xpoly[j] = this.xpoly[j - 1];
                    this.ypoly[j] = this.ypoly[j - 1];
                }
                this.xpoly[i + 1] = x;
                this.ypoly[i + 1] = y;
                ++this.npoly;
                this.ChangingWirePoly = i + 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveToFile(PrintStream ps) {
        ps.println("describe component " + this.getClassName());
        for (ParameterData pData : this.getAllParametersInfo()) {
            if (pData.getName().startsWith("pospoly")) continue;
            ps.println(" " + pData.getName() + " " + pData.getValue());
        }
        for (int i = 1; i <= this.getnpoly(); ++i) {
            String dPospolyx = this.getParamaterValue("pospolyx" + i);
            String dPospolyy = this.getParamaterValue("pospolyy" + i);
            ps.println(" pospolyx" + i + " " + dPospolyx);
            ps.println(" pospolyy" + i + " " + dPospolyy);
        }
        ps.println("end describe component");
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.gettype();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getowner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getcost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("XPos")) {
            sValue = String.valueOf(this.getx1());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("YPos")) {
            sValue = String.valueOf(this.gety1());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("XPos2")) {
            sValue = String.valueOf(this.getx2());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("YPos2")) {
            sValue = String.valueOf(this.gety2());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("numpoly")) {
            sValue = String.valueOf(this.getnpoly());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx1")) {
            sValue = String.valueOf(this.xpoly[0]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy1")) {
            sValue = String.valueOf(this.ypoly[0]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx2")) {
            sValue = String.valueOf(this.xpoly[1]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy2")) {
            sValue = String.valueOf(this.ypoly[1]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx3")) {
            sValue = String.valueOf(this.xpoly[2]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy3")) {
            sValue = String.valueOf(this.ypoly[2]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx4")) {
            sValue = String.valueOf(this.xpoly[3]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy4")) {
            sValue = String.valueOf(this.ypoly[3]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx5")) {
            sValue = String.valueOf(this.xpoly[4]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy5")) {
            sValue = String.valueOf(this.ypoly[4]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx6")) {
            sValue = String.valueOf(this.xpoly[5]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy6")) {
            sValue = String.valueOf(this.ypoly[5]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx7")) {
            sValue = String.valueOf(this.xpoly[6]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy7")) {
            sValue = String.valueOf(this.ypoly[6]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx8")) {
            sValue = String.valueOf(this.xpoly[7]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy8")) {
            sValue = String.valueOf(this.ypoly[7]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx9")) {
            sValue = String.valueOf(this.xpoly[8]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy9")) {
            sValue = String.valueOf(this.ypoly[8]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyx10")) {
            sValue = String.valueOf(this.xpoly[9]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        } else if (sParameterName.equalsIgnoreCase("pospolyy10")) {
            sValue = String.valueOf(this.ypoly[9]);
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.settype(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setowner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setcost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("XPos")) {
            this.x1 = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("YPos")) {
            this.y1 = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("XPos2")) {
            this.x2 = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("YPos2")) {
            this.y2 = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("numpoly")) {
            this.setnpoly((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx1")) {
            this.xpoly[0] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy1")) {
            this.ypoly[0] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx2")) {
            this.xpoly[1] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy2")) {
            this.ypoly[1] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx3")) {
            this.xpoly[2] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy3")) {
            this.ypoly[2] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx4")) {
            this.xpoly[3] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy4")) {
            this.ypoly[3] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx5")) {
            this.xpoly[4] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy5")) {
            this.ypoly[4] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx6")) {
            this.xpoly[5] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy6")) {
            this.ypoly[5] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx7")) {
            this.xpoly[6] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy7")) {
            this.ypoly[6] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx8")) {
            this.xpoly[7] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy8")) {
            this.ypoly[7] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx9")) {
            this.xpoly[8] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy9")) {
            this.ypoly[8] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyx10")) {
            this.xpoly[9] = (int)Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pospolyy10")) {
            this.ypoly[9] = (int)Double.parseDouble(sValue);
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

