/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.InputPin;
import de.core.OutputPin;
import de.core.PLPFrame;
import de.core.Pin;
import de.core.comp;
import de.core.hdb_link;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class hdb_irr
extends hdb_unit {
    public hdb_unit TurbRecComp = null;

    public hdb_irr(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 1, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("Irrigation", 3, 8, 0, -2, 0, 0, 0);
        this.IPin[0] = new InputPin("Irrigation", 3, 1, 0, 2, 0, 0, 0);
        this.setName("Irrigation");
        this.ClassName = "hdb_irr";
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_irr(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, w, h, xh, yh, wh, hh, i, o, entryperiod, exitperiod, entrymonth, exitmonth);
    }

    public hdb_irr(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double latitude, double longitude, double pspillmin, double pspillmax) {
        super(x, y, 4, 7, 1, 1, 4, 7, 1, 1, Name, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, true, pspillmin, pspillmax, 1.0);
        this.OPin[0] = new OutputPin(Name, 3, 8, 0, -2, 0, 0, 0);
        this.IPin[0] = new InputPin(Name, 3, 1, 0, 2, 0, 0, 0);
        this.ClassName = "hdb_irr";
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_irr(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    @Override
    public comp Copy(int xo, int yo) {
        hdb_irr NewComponent = new hdb_irr(this, xo, yo);
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setcost(this.getcost());
        NewComponent.setWat2PowRate(this.getWat2PowRate());
        NewComponent.setSpillmin(this.getSpillmin());
        NewComponent.setSpillmax(this.getSpillmax());
        return NewComponent;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        String auxs = "";
        g.setColor(Color.orange);
        g.fillRect((int)(((double)x + 1.5) * (double)gs), (y + 3) * gs, 3 * gs, 3 * gs);
        this.DrawOutputPins(g, x, y, gs);
        this.DrawInputPins(g, x, y, gs);
        g.setColor(Color.orange);
        if (gs > 2 && gs < 4) {
            g.setFont(Font8);
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font12);
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            g.drawString(this.ComponentName, (x + 4) * gs, (y + 1) * gs);
        }
        g.setColor(Color.BLACK);
        g.drawLine((x + 3) * gs, (int)(((double)y + 3.1) * (double)gs), (x + 3) * gs, (int)(((double)y + 5.9) * (double)gs));
        g.drawLine((x + 3) * gs, (int)(((double)y + 4.3) * (double)gs), (int)(((double)x + 4.5) * (double)gs), (int)(((double)y + 5.8) * (double)gs));
        if (gs > 6 && PLPFrame.View) {
            g.setColor(Color5);
            if (this.caudaffl != 0.0) {
                auxs = "Failed:" + StringUtil.numformat(this.caudaFail, 7, 1) + "m\u00b3/s";
                double width = g.getFontMetrics(g.getFont()).getStringBounds(auxs, g).getWidth();
                g.drawString(auxs, (int)((double)((x + 2) * gs) - width), (y + 2) * gs);
            }
            g.drawString(StringUtil.numformat(this.caudspill, 7, 1) + "m\u00b3/s", (x + 3) * gs, (y + 8) * gs);
            g.drawString(StringUtil.numformat(this.caudgener, 7, 1) + "m\u00b3/s", (x + 4) * gs, (y + 6) * gs);
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component hdbirr");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" cost " + this.cost);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" SpillMin " + this.spillmin);
        myPrintStream.println(" SpillMax " + this.spillmax);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO hdb_irr (XPos,YPos,Name,type,owner,cost,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,latitude,longitude,spillmin,spillmax) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "'," + String.valueOf(this.cost) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.spillmin) + "," + String.valueOf(this.spillmax) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public boolean InformRecipients() {
        boolean allOK = true;
        this.TurbRecComp = null;
        Vector ActComp = this.OPin[0].ConnComps;
        for (int ix = 0; ix < ActComp.size(); ++ix) {
            boolean linkfinded = false;
            comp tempcomp = (comp)ActComp.elementAt(ix);
            if (!(tempcomp instanceof hdb_link)) continue;
            if (linkfinded) {
                System.out.println(this.getName() + " has two outputs in " + this.ClassName);
                return false;
            }
            linkfinded = true;
            hdb_link tempLink = (hdb_link)tempcomp;
            tempcomp = tempLink.CompAtOut;
            if (!(tempcomp instanceof hdb_ser) && !(tempcomp instanceof hdb_irr)) {
                System.out.println("mis connected to " + tempcomp.getName());
                return false;
            }
            this.TurbRecComp = (hdb_unit)tempcomp;
        }
        return allOK;
    }

    public hdb_unit getTurbRecComp() {
        return this.TurbRecComp;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmin")) {
            sValue = String.valueOf(this.getSpillmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spillmax")) {
            sValue = String.valueOf(this.getSpillmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.gettype();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getowner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getcost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmin")) {
            this.setSpillmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spillmax")) {
            this.setSpillmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.settype(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setowner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setcost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

