/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.OutputPin;
import de.core.PLPFrame;
import de.core.Pin;
import de.core.comp;
import de.core.hdb_comp;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

public class hdb_affl
extends hdb_comp {
    public double Q;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private boolean isStoch = true;
    private double[][] q_SimStMat = null;

    public hdb_affl(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("Afluente", 3, 8, 0, -3, 0, 0, 2);
        this.setName("NatInflow");
        this.ClassName = "hdb_affl";
        this.isStoch = true;
        this.Q = 0.0;
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_affl(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double QQ, double llatitude, double llongitude, boolean pisStoch) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, Name, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth);
        this.latitude = llatitude;
        this.longitude = llongitude;
        this.Q = QQ;
        this.isStoch = pisStoch;
        this.OPin[0] = new OutputPin(Name, 3, 8, 0, -3, 0, 0, 2);
        this.ClassName = "hdb_affl";
        this.RegisterPins(PinGrid, x, y);
    }

    public hdb_affl(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    @Override
    public comp Copy(int xo, int yo) {
        hdb_affl NewComponent = new hdb_affl(this, xo, yo);
        NewComponent.setQ(this.getQ());
        NewComponent.setcost(this.getcost());
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setlife_time(this.getlife_time());
        return NewComponent;
    }

    public double getQ() {
        return this.Q;
    }

    public double getlatitude() {
        return this.latitude;
    }

    public double getlongitude() {
        return this.longitude;
    }

    public boolean getIsStoch() {
        return this.isStoch;
    }

    public void setQ(double q) {
        this.Q = q;
    }

    public void setlatitude(double la) {
        this.latitude = la;
    }

    public void setlongitude(double lo) {
        this.longitude = lo;
    }

    public void setIsStoch(boolean val) {
        this.isStoch = val;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        g.setColor(TextColor3);
        if (gs > 2 && gs < 4) {
            g.setFont(Font8);
            g.drawString("A", (int)(((double)x + 2.65) * (double)gs), (y + 4) * gs);
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            g.drawString("A", (int)(((double)x + 2.65) * (double)gs), (y + 4) * gs);
            g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
            g.drawString("A", (int)(((double)x + 2.65) * (double)gs), (y + 4) * gs);
            g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font12);
            g.drawString("A", (int)(((double)x + 2.65) * (double)gs), (y + 4) * gs);
            g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            g.drawString("A", (int)(((double)x + 2.65) * (double)gs), (y + 4) * gs);
            g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
        }
        g.drawRoundRect((int)(((double)x + 1.5) * (double)gs), (y + 2) * gs, 3 * gs, 3 * gs, gs, gs);
        this.DrawOutputPins(g, x, y, gs);
        if (gs > 6 && PLPFrame.View && this.Q != 0.0) {
            g.setColor(Color5);
            g.drawString(StringUtil.numformat(this.Q, 7, 1) + "m\u00b3/s", (x + 3) * gs, (y + 8) * gs);
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component hdbaffl");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" Q " + this.Q);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.cost);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" isStoch " + this.isStoch);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO hdb_affl (XPos,YPos,Name,type,owner,cost,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,latitude,longitude,Caudal, isStoch) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "'," + String.valueOf(this.cost) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.Q) + "," + (this.isStoch ? 1 : 0) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public boolean setQfromSimStMat(int stage, int hydroId) {
        if (this.q_SimStMat == null || this.q_SimStMat.length <= stage || this.q_SimStMat[stage].length <= hydroId) {
            return false;
        }
        this.setQ(this.q_SimStMat[stage][hydroId]);
        return true;
    }

    public void setQ_SimStMat(double[][] q_SimMatrix) {
        this.q_SimStMat = q_SimMatrix;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("Caudal")) {
            sValue = String.valueOf(this.getQ());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.gettype();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getowner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getcost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("isStoch")) {
            sValue = String.valueOf(this.getIsStoch());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Caudal")) {
            this.setQ(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.settype(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setowner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setcost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("isStoch")) {
            this.setIsStoch(Boolean.parseBoolean(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

