/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.InputPin;
import de.core.OutputPin;
import de.core.PietEditFrame;
import de.core.Pin;
import de.core.comp;
import de.core.fdb_station;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

class fdb_storage
extends fdb_station {
    BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
    protected double sto_capacity = 0.0;
    protected String sto_capacity_unit = "m3";
    protected String fuel_type = "NONE";
    protected double ini_state = 0.0;
    protected double state = 0.0;
    protected double[] f_sto_emissions = new double[9];
    protected String[] fuelList = new String[]{"Crudo", "Gas_de_Ciudad", "Gas_Licuado", "Gas_Natural", "Gas_Oil", "Gas_Refineria", "Gasolina_81", "Gasolina_86", "Gasolina_91", "Gasolina_93_", "Gasolina_93_sin_plomo", "Gasolina_95_sin_plomo", "Gasolina_97_sin_plomo", "Gasolina_Aviacion", "Kerosene_Aviacion", "Kerosene_Domestico", "Nafta_Liviana", "P_Combustible_Ifo_180", "P_Combustible_Ifo_380", "P.Combustible__#5", "P.Combustible_#_6", "Petroleo_Diesel_A1", "Petroleo_Diesel_B", "Petroleo_Diesel_BESC", "Petroleo_Diesel_ENAP2", "Petroleo_Diesel_Invierno"};
    protected String[] fuelListAbrev = new String[]{"Cr", "GC", "GL", "GN", "GO", "GR", "G81", "G86", "G91", "G93", "G93S", "G95S", "G97S", "GA", "KA", "KD", "NL", "I180", "I380", "PC#5", "PC#6", "DA1", "DB", "DBESC", "DENAP2", "DI"};

    public fdb_storage(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod) {
        super(x, y, 8, 8, 1, 1, 8, 8, 1, 1, entryperiod, exitperiod);
        this.IPin[0] = new InputPin("fdb_storage", 5, 1, 0, 2, 0, 0, 0);
        this.OPin[0] = new OutputPin("fdb_storage", 5, 7, 0, 2, 0, 0, 0);
        this.ClassName = "fdb_storage";
        this.ComponentName = "Fuel_Storage";
        this.RegisterPins(PinGrid, x, y);
    }

    public fdb_storage(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, double latitude, double longitude, double ssto_capacity, String ssto_capacity_unit, String ffuel_type, double iini_state, double[] ff_sto_emissions) {
        super(x, y, 8, 8, 1, 1, 8, 8, 1, 1, Name, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude);
        this.IPin[0] = new InputPin(Name, 5, 1, 0, 2, 0, 0, 0);
        this.OPin[0] = new OutputPin(Name, 5, 7, 0, 2, 0, 0, 0);
        this.sto_capacity = ssto_capacity;
        this.sto_capacity_unit = ssto_capacity_unit;
        this.fuel_type = ffuel_type;
        this.ini_state = iini_state;
        for (int i = 0; i < 9; ++i) {
            this.f_sto_emissions[i] = ff_sto_emissions[i];
        }
        this.ClassName = "fdb_storage";
        this.RegisterPins(PinGrid, x, y);
    }

    public fdb_storage(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    public double getsto_capacity() {
        return this.sto_capacity;
    }

    public String getsto_capacity_unit() {
        return this.sto_capacity_unit;
    }

    public String getfuel_type() {
        return this.fuel_type;
    }

    public double getini_state() {
        return this.ini_state;
    }

    public double getstate() {
        return this.state;
    }

    public double[] get_f_sto_emissions() {
        return this.f_sto_emissions;
    }

    public double get_f_sto_emissions_at(int i) {
        return this.f_sto_emissions[i];
    }

    public void setsto_capacity(double sc) {
        this.sto_capacity = sc;
    }

    public void setsto_capacity_unit(String un) {
        this.sto_capacity_unit = un;
    }

    public void setfuel_type(String ft) {
        this.fuel_type = ft;
    }

    public void setini_state(double is) {
        this.ini_state = is;
    }

    public void setstate(double s) {
        this.state = s;
    }

    public void set_f_sto_emissions(double[] em) {
        this.f_sto_emissions = em;
    }

    public void set_f_sto_emissions_at(int i, double em) {
        this.f_sto_emissions[i] = em;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public comp Copy(int xo, int yo) {
        fdb_storage NewComponent = new fdb_storage(this, xo, yo);
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setLatitude(this.getLatitude());
        NewComponent.setLongitude(this.getLongitude());
        NewComponent.setsto_capacity(this.getsto_capacity());
        NewComponent.setsto_capacity_unit(this.getsto_capacity_unit());
        NewComponent.setfuel_type(this.getfuel_type());
        NewComponent.setini_state(this.getini_state());
        NewComponent.setstate(this.getstate());
        NewComponent.set_f_sto_emissions(this.get_f_sto_emissions());
        return NewComponent;
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        g.setColor(this.get_fuel_color(this.fuel_type));
        g.drawLine((x + 1) * gs, (y + 3) * gs, (x + 1) * gs, (y + 5) * gs);
        g.drawLine((x + 9) * gs, (y + 3) * gs, (x + 9) * gs, (y + 5) * gs);
        g.drawLine((x + 5) * gs, (y + 3) * gs, (x + 5) * gs, (y + 5) * gs);
        g.drawLine((x + 4) * gs, (y + 4) * gs, (x + 5) * gs, (y + 5) * gs);
        g.drawLine((x + 6) * gs, (y + 4) * gs, (x + 5) * gs, (y + 5) * gs);
        g.drawLine((x + 5) * gs, (y + 1) * gs, (x + 5) * gs, (y + 3) * gs);
        g.drawLine((x + 5) * gs, (y + 7) * gs, (x + 5) * gs, (y + 9) * gs);
        int[] sqx = new int[4];
        int[] sqy = new int[4];
        sqx[0] = (x + 1) * gs;
        sqx[1] = (x + 1) * gs;
        sqx[2] = (x + 9) * gs;
        sqx[3] = (x + 9) * gs;
        sqy[0] = (y + 5) * gs;
        sqy[1] = (y + 7) * gs;
        sqy[2] = (y + 7) * gs;
        sqy[3] = (y + 5) * gs;
        g.drawPolygon(sqx, sqy, 4);
        g.fillPolygon(sqx, sqy, 4);
        g.setColor(Color.black);
        if (gs > 2 && gs < 4) {
            g.setFont(Font8);
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            g.drawString(this.ComponentName, (x + 6) * gs, (y + 2) * gs);
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
            g.drawString(this.ComponentName, (x + 6) * gs, (y + 2) * gs);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font12);
            g.drawString(this.ComponentName, (x + 6) * gs, (y + 2) * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            g.drawString(this.ComponentName, (x + 6) * gs, (y + 2) * gs);
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        int i;
        boolean emi = false;
        myPrintStream.println("describe component fdbstorage");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.getinv_cost());
        myPrintStream.println(" owner " + this.getinv_owner());
        myPrintStream.println(" type " + this.getinv_type());
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" stocapacity " + this.sto_capacity);
        myPrintStream.println(" stocapacityunit " + this.sto_capacity_unit);
        myPrintStream.println(" fueltype " + this.fuel_type);
        myPrintStream.println(" inistate " + this.ini_state);
        for (i = 0; i < 9; ++i) {
            if (this.f_sto_emissions[i] == 0.0) continue;
            emi = true;
        }
        if (emi) {
            for (i = 0; i < 9; ++i) {
                myPrintStream.println(" fstoemissions " + this.f_sto_emissions[i]);
            }
        }
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = PietEditFrame.con.createStatement();
        String query = "INSERT INTO fdb_storage (XPos, YPos, Name, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, stocapacity, stocapacityunit, fueltype, inistate, fstoemissions1, fstoemissions2, fstoemissions3, fstoemissions4, fstoemissions5, fstoemissions6, fstoemissions7, fstoemissions8, fstoemissions9) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.getinv_type() + "','" + this.getinv_owner() + "'," + this.getinv_cost() + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.sto_capacity) + ",'" + this.sto_capacity_unit + "','" + this.fuel_type + "'," + String.valueOf(this.ini_state);
        for (int i = 0; i < 9; ++i) {
            query = query + "," + String.valueOf(this.f_sto_emissions[i]);
        }
        query = query + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void waits(String mess) {
        int aux = 0;
        if (!mess.equals(" ")) {
            System.out.println(mess);
        }
        try {
            aux = Integer.parseInt(this.din.readLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String Statistics(int ix) {
        String linea = "";
        linea = StringUtil.printf(ix, 4) + "    " + StringUtil.printf(this.getName(), 12) + " " + StringUtil.printf(this.entry_period, 7) + " " + StringUtil.printf(this.exit_period, 6) + "   " + StringUtil.printf(String.valueOf(this.inv_cost), 6) + " " + StringUtil.printf(this.inv_owner, 12) + " " + StringUtil.printf(String.valueOf(this.latitude), 4) + " " + StringUtil.printf(String.valueOf(this.longitude), 4) + "    " + StringUtil.printf(String.valueOf(this.sto_capacity), 9);
        return linea;
    }
}

