/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.GraphicsUtil;
import de.core.JMapObject;
import de.core.PietEditFrame;
import de.core.PietSchematic;
import de.core.Pin;
import de.core.comp;
import de.core.fdb_comp;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class fdb_link
extends fdb_comp {
    BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    public int[] xpoly = new int[32];
    public int[] ypoly = new int[32];
    public int ChangingWire = 0;
    public int ChangingWirePoly = 0;
    protected int npoly;
    protected JMapObject mo;
    public Vector ConnComps1;
    public Vector ConnComps2;
    protected double f_capacity = 0.0;
    protected String f_unit = "m3";
    protected int my_f_modes = 1;
    protected double length = 0.0;
    protected double flow = 0.0;
    protected String fuel_type = "Crudo";
    protected Color my_fuel_color = Color.black;
    protected double[] f_link_emissions = new double[9];

    public fdb_link(String Name, double FFOR) {
        super("Link", 1, 1);
        this.ClassName = "fdb_link";
        this.ComponentName = Name;
        this.FOR = FFOR;
    }

    public fdb_link(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod) {
        super("Link", entryperiod, exitperiod);
        this.ClassName = "fdb_link";
        this.x1 = x;
        this.y1 = y;
    }

    public fdb_link(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int[] xxpoly, int[] yypoly, int nnpoly, double ff_capacity, String ff_unit, int mmy_f_modes, double llength, String ffuel_type, double[] ff_link_emissions) {
        super(Name, type, owner, cost, lifetime, entryperiod, exitperiod);
        int i;
        this.ClassName = "fdb_link";
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        for (i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        for (i = 0; i < 9; ++i) {
            this.f_link_emissions[i] = ff_link_emissions[i];
        }
        this.npoly = nnpoly;
        this.PlacePinsHere(PinGrid);
        this.f_capacity = ff_capacity;
        this.f_unit = ff_unit;
        this.my_f_modes = mmy_f_modes;
        this.length = llength;
        this.fuel_type = "Crudo";
        this.my_fuel_color = this.get_fuel_color(ffuel_type);
        this.fuel_type = ffuel_type;
    }

    public fdb_link(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int[] xxpoly, int[] yypoly, int nnpoly, double ff_capacity, int mmy_f_modes, double llength, String ffuel_type, double[] ff_link_emissions) {
        super(Name, type, owner, cost, lifetime, entryperiod, exitperiod);
        int i;
        this.ClassName = "fdb_link";
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        for (i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        for (i = 0; i < 9; ++i) {
            this.f_link_emissions[i] = ff_link_emissions[i];
        }
        this.npoly = nnpoly;
        this.PlacePinsHere(PinGrid);
        this.f_capacity = ff_capacity;
        this.my_f_modes = mmy_f_modes;
        this.length = llength;
        this.fuel_type = ffuel_type;
    }

    public fdb_link(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.ComponentName = "Link";
        this.ClassName = "fdb_link";
    }

    public double getf_capacity() {
        return this.f_capacity;
    }

    public String getf_unit() {
        return this.f_unit;
    }

    public int getmy_f_modes() {
        return this.my_f_modes;
    }

    public int getmy_f_modes_at(int n) {
        int modo = this.my_f_modes & (int)Math.pow(2.0, n);
        if (modo != 0) {
            return 1;
        }
        return 0;
    }

    public double getlength() {
        return this.length;
    }

    public double getflow() {
        return this.flow;
    }

    public String getfuel_type() {
        return this.fuel_type;
    }

    public Color getmy_fuel_color() {
        return this.my_fuel_color;
    }

    public int getx1() {
        return this.x1;
    }

    public int getx2() {
        return this.x2;
    }

    public int gety1() {
        return this.y1;
    }

    public int gety2() {
        return this.y2;
    }

    public double[] get_f_link_emissions() {
        return this.f_link_emissions;
    }

    public double get_f_link_emissions_at(int i) {
        return this.f_link_emissions[i];
    }

    public JMapObject getmo() {
        return this.mo;
    }

    public void setf_capacity(double fc) {
        this.f_capacity = fc;
    }

    public void setf_unit(String fu) {
        this.f_unit = fu;
    }

    public void setmy_f_modes(int fm) {
        this.my_f_modes = fm;
    }

    public void setmy_f_modes_at(int that, double tthis) {
        int aux = this.my_f_modes & (int)Math.pow(2.0, that);
        if (aux != 0) {
            this.my_f_modes -= (int)Math.pow(2.0, that);
        }
        this.my_f_modes += (int)(tthis * Math.pow(2.0, that));
    }

    public void setlength(double l) {
        this.length = l;
    }

    public void setflow(double f) {
        this.flow = f;
    }

    public void setfuel_type(String ft) {
        this.fuel_type = ft;
    }

    public void setx1(int n) {
        this.x1 = n;
    }

    public void sety1(int n) {
        this.y1 = n;
    }

    public void setx2(int n) {
        this.x2 = n;
    }

    public void sety2(int n) {
        this.y2 = n;
    }

    public void setmy_fuel_color(Color n) {
        this.my_fuel_color = n;
    }

    public void set_f_link_emissions(double[] em) {
        this.f_link_emissions = em;
    }

    public void set_f_link_emissions_at(int i, double em) {
        this.f_link_emissions[i] = em;
    }

    public void setmo(JMapObject n) {
        this.mo = n;
    }

    public void Set2ndCoord(Pin[][] PinGrid, int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    @Override
    public comp Copy(int xo, int yo) {
        fdb_link NewComponent = new fdb_link(this, xo, yo);
        NewComponent.x1 = this.x1 - xo;
        NewComponent.y1 = this.y1 - yo;
        NewComponent.x2 = this.x2 - xo;
        NewComponent.y2 = this.y2 - yo;
        NewComponent.setName("NEW_Link");
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setf_capacity(this.getf_capacity());
        NewComponent.setf_unit(this.getf_unit());
        NewComponent.setmy_f_modes(this.getmy_f_modes());
        NewComponent.setlength(this.getlength());
        NewComponent.setflow(this.getflow());
        NewComponent.setfuel_type(this.getfuel_type());
        NewComponent.set_f_link_emissions(this.get_f_link_emissions());
        return NewComponent;
    }

    @Override
    public void CheckPosition(PietEditFrame app) {
        if (this.x1 < 1) {
            this.x1 = 1;
        }
        if (this.x1 >= app.MaxXPoints) {
            this.x1 = app.MaxXPoints - 1;
        }
        if (this.y1 < 1) {
            this.y1 = 1;
        }
        if (this.y1 >= app.MaxYPoints) {
            this.y1 = app.MaxYPoints - 1;
        }
        if (this.x2 < 1) {
            this.x2 = 1;
        }
        if (this.x2 >= app.MaxXPoints) {
            this.x2 = app.MaxXPoints - 1;
        }
        if (this.y2 < 1) {
            this.y2 = 1;
        }
        if (this.y2 >= app.MaxYPoints) {
            this.y2 = app.MaxYPoints - 1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.xpoly[i] < 1) {
                this.xpoly[i] = 1;
            }
            if (this.xpoly[i] >= app.MaxXPoints) {
                this.xpoly[i] = app.MaxXPoints - 1;
            }
            if (this.ypoly[i] < 1) {
                this.ypoly[i] = 1;
            }
            if (this.ypoly[i] < app.MaxYPoints) continue;
            this.ypoly[i] = app.MaxYPoints - 1;
        }
    }

    @Override
    public void SimulateSetUp(int x, int y, Vector ActComps) {
        if (x == this.x1 && y == this.y1) {
            this.ConnComps1 = ActComps;
        }
        if (x == this.x2 && y == this.y2) {
            this.ConnComps2 = ActComps;
        }
    }

    public void InformAllComponents(Vector ActVector, int x, int y, PrintStream myPrintStream, int endline) {
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this) continue;
            ++nc;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                myPrintStream.println(" pot_top" + endline + "     " + "\"SIS." + ConnectedComponent.ComponentName + ".FeldIn" + inp + ".AT:2\"");
            }
            if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
            myPrintStream.println(" pot_top" + endline + "     " + "\"SIS." + ConnectedComponent.ComponentName + ".FeldOut" + out + ".AT:2\"");
        }
    }

    public String InformAllComponents(Vector ActVector, int x, int y, int endline) {
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this || !(ConnectedComponent instanceof fdb_comp)) continue;
            ++nc;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                if (endline == 1) {
                    this.setcon1(ConnectedComponent.ComponentName);
                }
                if (endline == 2) {
                    this.setcon2(ConnectedComponent.ComponentName);
                }
                return ConnectedComponent.ComponentName;
            }
            out = ConnectedComponent.InformOutput(this);
            if (out == -1) continue;
            if (endline == 1) {
                this.setcon1(ConnectedComponent.ComponentName);
            }
            if (endline == 2) {
                this.setcon2(ConnectedComponent.ComponentName);
            }
            return ConnectedComponent.ComponentName;
        }
        return "Not Conn.";
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        int i;
        boolean auxint = true;
        g.setColor(this.getmy_fuel_color());
        if (this.npoly > 0) {
            if (this.my_f_modes == 1) {
                GraphicsUtil.drawPipe(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, gs, 0);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawPipe(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, gs, 0);
                }
                GraphicsUtil.drawPipe(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
            } else if (this.my_f_modes == 2) {
                GraphicsUtil.drawTrain(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, gs, 0);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawTrain(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, gs, 0);
                }
                GraphicsUtil.drawTrain(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
            } else if (this.my_f_modes == 4) {
                GraphicsUtil.drawTruck(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, gs, 0);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawTruck(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, gs, 0);
                }
                GraphicsUtil.drawTruck(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
            } else if (this.my_f_modes == 8) {
                GraphicsUtil.drawShip(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, gs, 0);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawShip(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, gs, 0);
                }
                GraphicsUtil.drawShip(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
            } else {
                g.setColor(Color.red);
                GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, 2);
                for (i = 0; i < this.npoly - 1; ++i) {
                    GraphicsUtil.drawLine(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, 2);
                }
                GraphicsUtil.drawLine(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, 2);
            }
        } else if (this.my_f_modes == 1) {
            GraphicsUtil.drawPipe(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
        } else if (this.my_f_modes == 2) {
            GraphicsUtil.drawTrain(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
        } else if (this.my_f_modes == 4) {
            GraphicsUtil.drawTruck(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
        } else if (this.my_f_modes == 8) {
            GraphicsUtil.drawShip(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, gs, 1);
        } else {
            g.setColor(Color.red);
            GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, 4);
        }
        if (this.isSelected()) {
            g.setColor(TextColor3);
            if ((this.ChangingWire & 1) == 1) {
                g.drawRect((int)(((double)(this.x1 - xp) - 0.25) * (double)gs), (int)(((double)(this.y1 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
            if (this.ChangingWire == 3) {
                for (i = 0; i < this.npoly; ++i) {
                    g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
            }
            if ((this.ChangingWire & 2) == 2) {
                g.drawRect((int)(((double)(this.x2 - xp) - 0.25) * (double)gs), (int)(((double)(this.y2 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
        }
        g.setColor(TextColor3);
        for (i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1) continue;
            g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
        }
        g.setColor(TextColor2);
        if (gs >= 0 && gs < 8) {
            g.setFont(Font10);
        }
        if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font12);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font14);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font14);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        }
        if (gs >= 4) {
            if (gs >= 4) {
                g.setFont(Font9);
            } else if (gs >= 8) {
                g.setFont(Font10);
            } else if (gs >= 12) {
                g.setFont(Font12);
            }
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        int i;
        boolean emi = false;
        myPrintStream.println("describe component fdblink");
        myPrintStream.println(" pos " + this.x1 + " " + this.y1);
        myPrintStream.println(" pos2 " + this.x2 + " " + this.y2);
        for (i = 0; i < this.npoly; ++i) {
            myPrintStream.println(" pospoly " + this.xpoly[i] + " " + this.ypoly[i]);
        }
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" lifetime " + this.getlife_time());
        myPrintStream.println(" cost " + this.getinv_cost());
        myPrintStream.println(" owner " + this.getinv_owner());
        myPrintStream.println(" type " + this.getinv_type());
        myPrintStream.println(" fcapacity " + this.f_capacity);
        myPrintStream.println(" funit " + this.f_unit);
        myPrintStream.println(" myfmodes " + this.my_f_modes);
        myPrintStream.println(" length " + this.length);
        myPrintStream.println(" fueltype " + this.fuel_type);
        for (i = 0; i < 9; ++i) {
            if (this.f_link_emissions[i] == 0.0) continue;
            emi = true;
        }
        if (emi) {
            for (i = 0; i < 9; ++i) {
                myPrintStream.println(" flinkemissions " + this.f_link_emissions[i]);
            }
        }
        myPrintStream.println("end describe ");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = PietEditFrame.con.createStatement();
        String query = "INSERT INTO fdb_link (XPos, YPos, XPos2, YPos2, Name, entryperiod, exitperiod, type, owner, cost, lifetime, fcapacity, funit, myfmodes, length, fueltype,flinkemissions1, flinkemissions2, flinkemissions3, flinkemissions4, flinkemissions5, flinkemissions6, flinkemissions7, flinkemissions8, flinkemissions9) VALUES (" + String.valueOf(this.x1) + "," + String.valueOf(this.y1) + "," + String.valueOf(this.x2) + "," + String.valueOf(this.y2) + ",'" + this.ComponentName + "'," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + ",'" + this.getinv_type() + "','" + this.getinv_owner() + "'," + this.getinv_cost() + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.f_capacity) + ",'" + String.valueOf(this.f_unit) + "'," + String.valueOf(this.my_f_modes) + "," + String.valueOf(this.length) + ",'" + String.valueOf(this.fuel_type) + "'";
        for (int i = 0; i < 9; ++i) {
            query = query + "," + String.valueOf(this.f_link_emissions[i]);
        }
        query = query + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void Savenod(PrintStream myPrintStream, double sref, String sysname) {
    }

    public void calcnumint(int px1, int py1, int px2, int py2) {
        boolean i = false;
        double numint = Math.sqrt((double)(px1 - px2) * (double)(px1 - px2) + (double)(py1 - py2) * (double)(py1 - py2)) / 2.0;
    }

    @Override
    public void RemovePinsGrid(Pin[][] PinGrid) {
        this.RemovePin(PinGrid[this.x1][this.y1]);
        this.RemovePin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void RegisterPins(Pin[][] PinGrid, int x, int y) {
        if (PinGrid == null) {
            return;
        }
        if (PinGrid[this.x1][this.y1] == null) {
            PinGrid[this.x1][this.y1] = new Pin();
        }
        if (PinGrid[this.x2][this.y2] == null) {
            PinGrid[this.x2][this.y2] = new Pin();
        }
        this.RegisterPin(PinGrid[this.x1][this.y1]);
        this.RegisterPin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void PlacePinsHere(Pin[][] PinGrid) {
        if (PinGrid == null) {
            return;
        }
        this.RegisterPins(PinGrid, 0, 0);
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int tx1, int ty1, int tx2, int ty2) {
        boolean Sel = false;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            Sel = true;
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            Sel = true;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            Sel = true;
        }
        return Sel;
    }

    @Override
    public boolean AdjustPosition(Pin[][] PinGrid, int x, int y) {
        int nx1 = this.x1;
        int ny1 = this.y1;
        int nx2 = this.x2;
        int ny2 = this.y2;
        if ((this.ChangingWire & 1) == 1) {
            nx1 += x;
            ny1 += y;
        }
        if ((this.ChangingWire & 2) == 2) {
            nx2 += x;
            ny2 += y;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1 && this.ChangingWire != 3) continue;
            int n = i;
            this.xpoly[n] = this.xpoly[n] + x;
            int n2 = i;
            this.ypoly[n2] = this.ypoly[n2] + y;
        }
        if (nx1 == nx2 && ny1 == ny2) {
            return false;
        }
        this.x1 = nx1;
        this.y1 = ny1;
        this.x2 = nx2;
        this.y2 = ny2;
        return true;
    }

    public int sgn(int val) {
        if (val > 0) {
            return 1;
        }
        if (val < 0) {
            return -1;
        }
        return 0;
    }

    public boolean CheckIfPointInWire(int a, int b, int c, int d, int x, int y) {
        int n;
        int u = c - a;
        int v = d - b;
        int d1x = this.sgn(u);
        int d1y = this.sgn(v);
        int d2x = this.sgn(u);
        int d2y = 0;
        int m = Math.abs(u);
        if (m <= (n = Math.abs(v))) {
            d2x = 0;
            d2y = this.sgn(v);
            m = Math.abs(v);
            n = Math.abs(u);
        }
        int s = m / 2;
        for (int i = 0; i < m; ++i) {
            if (Math.abs(x - a) < 2 && Math.abs(y - b) < 2) {
                return true;
            }
            if ((s += n) >= m) {
                s -= m;
                a += d1x;
                b += d1y;
                continue;
            }
            a += d2x;
            b += d2y;
        }
        return false;
    }

    @Override
    public boolean CheckIfComponentClicked(int x, int y) {
        int i;
        if (x == this.x1 && y == this.y1) {
            this.ChangingWire = 1;
            return true;
        }
        if (x == this.x2 && y == this.y2) {
            this.ChangingWire = 2;
            return true;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            this.ChangingWirePoly = i + 1;
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.xpoly[0], this.ypoly[0], x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1], this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i], this.ypoly[i], this.xpoly[i + 1], this.ypoly[i + 1], x, y)) continue;
                this.ChangingWire = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean CheckIfComponentInSelectBox(int tx1, int ty1, int tx2, int ty2) {
        this.setSelected(false);
        this.ChangingWire = 0;
        this.ChangingWirePoly = 0;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            this.ChangingWire |= 1;
            this.setSelected(true);
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            this.ChangingWire |= 2;
            this.setSelected(true);
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            this.ChangingWirePoly = i + 1;
            this.setSelected(true);
        }
        return this.isSelected();
    }

    public boolean TryPlaceJunction(PietSchematic ActSchematic, Pin[][] PinGrid, int x, int y, int gs) {
        int i;
        if (x == this.x1 && y == this.y1) {
            return false;
        }
        if (x == this.x2 && y == this.y2) {
            return false;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            --this.npoly;
            for (int j = i; j < this.npoly; ++j) {
                this.xpoly[j] = this.xpoly[j + 1];
                this.ypoly[j] = this.ypoly[j + 1];
            }
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.xpoly[0] * gs, this.ypoly[0] * gs, x * gs, y * gs)) {
                for (i = this.npoly; i > 0; --i) {
                    this.xpoly[i] = this.xpoly[i - 1];
                    this.ypoly[i] = this.ypoly[i - 1];
                }
                this.xpoly[0] = x;
                this.ypoly[0] = y;
                ++this.npoly;
                this.ChangingWirePoly = 1;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1] * gs, this.ypoly[this.npoly - 1] * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i] * gs, this.ypoly[i] * gs, this.xpoly[i + 1] * gs, this.ypoly[i + 1] * gs, x * gs, y * gs)) continue;
                for (int j = this.npoly; j > i; --j) {
                    this.xpoly[j] = this.xpoly[j - 1];
                    this.ypoly[j] = this.ypoly[j - 1];
                }
                this.xpoly[i + 1] = x;
                this.ypoly[i + 1] = y;
                ++this.npoly;
                this.ChangingWirePoly = i + 1;
                return true;
            }
        }
        return false;
    }

    public String Statistics(int ix) {
        String linea = "";
        linea = linea + StringUtil.printf(ix, 6) + "    ";
        linea = linea + StringUtil.printf(this.getName(), 12) + " ";
        linea = linea + StringUtil.printf(this.InformAllComponents(this.ConnComps1, this.x1, this.y1, 1), 12) + " ";
        linea = linea + StringUtil.printf(this.InformAllComponents(this.ConnComps2, this.x2, this.y2, 2), 12) + " ";
        linea = linea + StringUtil.printf(String.valueOf(this.inv_cost), 6) + " ";
        linea = linea + StringUtil.printf(this.entry_period, 6) + " ";
        linea = linea + StringUtil.printf(this.exit_period, 6) + " ";
        linea = linea + StringUtil.printf(this.inv_owner, 7) + " ";
        linea = linea + StringUtil.printf(String.valueOf(this.getinv_type()), 6) + " ";
        linea = linea + StringUtil.printf(String.valueOf(this.fuel_type), 9) + " ";
        linea = linea + StringUtil.printf(String.valueOf(this.f_capacity), 9) + " ";
        linea = linea + StringUtil.printf(String.valueOf(this.length), 6);
        return linea;
    }
}

