/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.OutputPin;
import de.core.PietEditFrame;
import de.core.Pin;
import de.core.comp;
import de.core.fdb_station;
import de.utils.StringUtil;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

class fdb_injection
extends fdb_station {
    protected FontMetrics SimpleDialogFontMetrics;
    protected String origin = "NONE";
    protected double f_capacity = 0.0;
    protected int my_f_modes = 0x3FFFFFF;
    protected String f_capacity_unit = "m3";
    protected double[] f_mode_capacity = new double[26];
    protected double[] f_mode_flow = new double[26];
    private int numpines = 0;
    protected double[] f_inj_emissions = new double[9];
    protected String[] fuelList = new String[]{"Crudo", "Gas_de_Ciudad", "Gas_Licuado", "Gas_Natural", "Gas_Oil", "Gas_Refineria", "Gasolina_81", "Gasolina_86", "Gasolina_91", "Gasolina_93", "Gasolina_93_sin_plomo", "Gasolina_95_sin_plomo", "Gasolina_97_sin_plomo", "Gasolina_Aviacion", "Kerosene_Aviacion", "Kerosene_Domestico", "Nafta_Liviana", "P_Combustible_Ifo_180", "P_Combustible_Ifo_380", "P.Combustible__#5", "P.Combustible_#_6", "Petroleo_Diesel_A1", "Petroleo_Diesel_B", "Petroleo_Diesel_BESC", "Petroleo_Diesel_ENAP2", "Petroleo_Diesel_Invierno"};
    protected String[] fuelListAbrev = new String[]{"Cr", "GC", "GL", "GN", "GO", "GR", "G81", "G86", "G91", "G93", "G93S", "G95S", "G97S", "GA", "KA", "KD", "NL", "I180", "I380", "PC#5", "PC#6", "DA1", "DB", "DBESC", "DENAP2", "DI"};
    int CaptWidth;

    public fdb_injection(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod) {
        super(x, y, 52, 7, 1, 1, 52, 7, 0, 26, entryperiod, exitperiod);
        this.ComponentName = "NewFInjection";
        this.ClassName = "fdb_injection";
        this.numpines = 26;
        for (int i = 0; i < this.numpines; ++i) {
            this.OPin[i] = new OutputPin(this.fuelList[i], 3 + 2 * (i - 1), 7, 0, -3, 1, 0, 0);
        }
        this.RegisterPins(PinGrid, x, y);
    }

    public fdb_injection(Pin[][] PinGrid, int pines, int x, int y, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, double latitude, double longitude, String oorigin, double ff_capacity, int mmy_f_modes, String ff_capacity_unit, double[] ff_mode_capacity, double[] ff_inj_emissions) {
        super(x, y, 2 * pines, 7, 1, 1, 2 * pines, 7, 0, pines, Name, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude);
        this.ClassName = Name;
        this.origin = oorigin;
        this.f_capacity = ff_capacity;
        this.my_f_modes = mmy_f_modes;
        this.f_capacity_unit = ff_capacity_unit;
        this.f_mode_capacity = ff_mode_capacity;
        for (int i = 0; i < 9; ++i) {
            this.f_inj_emissions[i] = ff_inj_emissions[i];
        }
        int j = 0;
        for (int i = 0; i < 26; ++i) {
            int modo = this.my_f_modes & (int)Math.pow(2.0, i);
            if (modo == 0) continue;
            this.OPin[j] = new OutputPin(this.fuelList[i], 3 + 2 * (j - 1), 7, 0, -3, 1, 0, 0);
            ++this.numpines;
            ++j;
        }
        this.RegisterPins(PinGrid, x, y);
    }

    public fdb_injection(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.ClassName = "fdb_injection";
    }

    public String getorigin() {
        return this.origin;
    }

    public double getf_capacity() {
        return this.f_capacity;
    }

    public int getmy_f_modes() {
        return this.my_f_modes;
    }

    public int getmy_f_modes_at(int that) {
        int modo = this.my_f_modes & (int)Math.pow(2.0, that);
        if (modo != 0) {
            return 1;
        }
        return 0;
    }

    public String getf_capacity_unit() {
        return this.f_capacity_unit;
    }

    public double[] getf_mode_capacity() {
        return this.f_mode_capacity;
    }

    public double getf_mode_capacity_at(int i) {
        return this.f_mode_capacity[i];
    }

    public double[] getf_mode_flow() {
        return this.f_mode_flow;
    }

    public double getf_mode_floaw_at(int i) {
        return this.f_mode_flow[i];
    }

    public double[] get_f_inj_emissions() {
        return this.f_inj_emissions;
    }

    public double get_f_inj_emissions_at(int i) {
        return this.f_inj_emissions[i];
    }

    public void setorigin(String o) {
        this.origin = o;
    }

    public void setf_capacity(double fc) {
        this.f_capacity = fc;
    }

    public void setmy_f_modes(int mfm) {
        this.my_f_modes = mfm;
    }

    public void setmy_f_modes_at(int that, double tthis) {
        int aux = this.my_f_modes & (int)Math.pow(2.0, that);
        if (aux != 0) {
            this.my_f_modes -= (int)Math.pow(2.0, that);
        }
        this.my_f_modes += (int)(tthis * Math.pow(2.0, that));
    }

    public void setf_capacity_unit(String fcu) {
        this.f_capacity_unit = fcu;
    }

    public void setf_mode_capacity(double[] fmc) {
        this.f_mode_capacity = fmc;
    }

    public void setf_mode_capacity_at(int that, double tthis) {
        this.f_mode_capacity[that] = tthis;
    }

    public void setf_mode_flow(double[] fmf) {
        this.f_mode_flow = fmf;
    }

    public void setf_mode_flow_at(int that, double tthis) {
        this.f_mode_flow[that] = tthis;
    }

    public void set_f_inj_emissions(double[] em) {
        this.f_inj_emissions = em;
    }

    public void set_f_inj_emissions_at(int i, double em) {
        this.f_inj_emissions[i] = em;
    }

    @Override
    public comp Copy(int xo, int yo) {
        fdb_injection NewComponent = new fdb_injection(this, xo, yo);
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setLatitude(this.getLatitude());
        NewComponent.setLongitude(this.getLongitude());
        NewComponent.set_f_inj_emissions(this.get_f_inj_emissions());
        return NewComponent;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        boolean aux = true;
        int cx1 = this.Pos.x;
        int cy1 = this.Pos.y;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height;
        aux = x1 <= cx1 && y1 <= cy1 && cx1 <= x2 && cy1 <= y2 || x1 <= cx2 && y1 <= cy2 && cx2 <= x2 && cy2 <= y2;
        return aux;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        int i;
        boolean emi = false;
        myPrintStream.println("describe component fdbinjection");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.getinv_cost());
        myPrintStream.println(" owner " + this.getinv_owner());
        myPrintStream.println(" type " + this.getinv_type());
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" origin " + this.origin);
        myPrintStream.println(" fcapacity " + this.f_capacity);
        myPrintStream.println(" myfmodes " + this.my_f_modes);
        myPrintStream.println(" fcapacityunit " + this.f_capacity_unit);
        for (i = 0; i < 26; ++i) {
            myPrintStream.println(" fmodecapacity " + this.f_mode_capacity[i]);
        }
        for (i = 0; i < 9; ++i) {
            if (this.f_inj_emissions[i] == 0.0) continue;
            emi = true;
        }
        if (emi) {
            for (i = 0; i < 9; ++i) {
                myPrintStream.println(" finjemissions " + this.f_inj_emissions[i]);
            }
        }
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int i;
        int x = 0;
        Statement stmt = PietEditFrame.con.createStatement();
        String query = "INSERT INTO fdb_injection (XPos, YPos, Name, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, origin, fcapacity, myfmodes, fcapacityunit, fmodecapacity1, fmodecapacity2, fmodecapacity3, fmodecapacity4, fmodecapacity5, fmodecapacity6, fmodecapacity7, fmodecapacity8, fmodecapacity9, fmodecapacity10, fmodecapacity11, fmodecapacity12, fmodecapacity13, fmodecapacity14, fmodecapacity15, fmodecapacity16, fmodecapacity17, fmodecapacity18, fmodecapacity19, fmodecapacity20, fmodecapacity21, fmodecapacity22, fmodecapacity23, fmodecapacity24, fmodecapacity25, fmodecapacity26,finjemissions1, finjemissions2, finjemissions3, finjemissions4, finjemissions5, finjemissions6, finjemissions7, finjemissions8, finjemissions9) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.getinv_type() + "','" + this.getinv_owner() + "'," + this.getinv_cost() + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + ",'" + String.valueOf(this.origin) + "'," + String.valueOf(this.f_capacity) + "," + String.valueOf(this.my_f_modes) + ",'" + this.f_capacity_unit + "'";
        for (i = 0; i < 26; ++i) {
            query = query + "," + String.valueOf(this.f_mode_capacity[i]);
        }
        for (i = 0; i < 9; ++i) {
            query = query + "," + String.valueOf(this.f_inj_emissions[i]);
        }
        query = query + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void Savenod(PrintStream myPrintStream, double sref) {
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        g.setColor(TextColor2);
        if (gs > 2 && gs < 4) {
            g.setFont(Font8);
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            g.drawString(this.ComponentName, (x + 1 + 2 * this.numpines) * gs, (y + 4) * gs);
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
            g.drawString(this.ComponentName, (x + 1 + 2 * this.numpines) * gs, (y + 4) * gs);
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font12);
            g.drawString(this.ComponentName, (x + 1 + 2 * this.numpines) * gs, (y + 4) * gs);
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font16);
            g.drawString(this.ComponentName, (x + 1 + 2 * this.numpines) * gs, (y + 4) * gs);
            int ele = 0;
            int pos = 7;
            for (int j = 0; j < 26; ++j) {
                int modo = this.my_f_modes & (int)Math.pow(2.0, j);
                if (modo == 0) continue;
                g.setFont(Font12);
                if (pos == 7) {
                    g.drawString(this.fuelListAbrev[j], (x + 3 + 2 * (ele - 1)) * gs, (y + pos) * gs);
                    pos = 6;
                } else if (pos == 6) {
                    g.drawString(this.fuelListAbrev[j], (x + 3 + 2 * (ele - 1)) * gs, (y + pos) * gs);
                    pos = 7;
                }
                ++ele;
            }
        }
        int j = 0;
        for (int i = 0; i < 26; ++i) {
            int modo = this.my_f_modes & (int)Math.pow(2.0, i);
            if (modo == 0) continue;
            g.setColor(this.colorList[i]);
            g.drawLine((x + 3 + 2 * (j - 1)) * gs, (y + 4) * gs, (x + 3 + 2 * (j - 1)) * gs, (y + 7) * gs);
            ++j;
        }
        g.setColor(TextColor2);
        g.drawLine((x + 1) * gs, (y + 4) * gs, (x + 1 + 2 * (this.numpines - 1)) * gs, (y + 4) * gs);
        if (this.numpines % 2 != 0) {
            int[] sqx = new int[4];
            int[] sqy = new int[4];
            sqx[0] = (x - 1 + 1 * this.numpines) * gs;
            sqx[1] = (x - 1 + 1 * this.numpines) * gs;
            sqx[2] = (x + 1 + 1 * this.numpines) * gs;
            sqx[3] = (x + 0 + 1 * this.numpines) * gs;
            sqy[0] = (y + 3) * gs;
            sqy[1] = (y + 3) * gs;
            sqy[2] = (y + 3) * gs;
            sqy[3] = (y + 4) * gs;
            g.drawPolygon(sqx, sqy, 4);
            g.fillPolygon(sqx, sqy, 4);
            g.drawLine((x + 0 + 1 * this.numpines) / 1 * gs, (y + 3) * gs, (x + 0 + 1 * this.numpines) / 1 * gs, (y + 1) * gs);
        } else {
            int[] sqx = new int[4];
            int[] sqy = new int[4];
            sqx[0] = (x - 1 + 1 * this.numpines) * gs;
            sqx[1] = (x - 1 + 1 * this.numpines) * gs;
            sqx[2] = (x + 1 + 1 * this.numpines) * gs;
            sqx[3] = (x + 0 + 1 * this.numpines) * gs;
            sqy[0] = (y + 3) * gs;
            sqy[1] = (y + 3) * gs;
            sqy[2] = (y + 3) * gs;
            sqy[3] = (y + 4) * gs;
            g.drawPolygon(sqx, sqy, 4);
            g.fillPolygon(sqx, sqy, 4);
            g.drawLine((x + 0 + 1 * this.numpines) / 1 * gs, (y + 3) * gs, (x + 0 + 1 * this.numpines) / 1 * gs, (y + 1) * gs);
        }
    }

    public String Statistics(int ix) {
        String linea = "";
        linea = StringUtil.printf(ix, 4) + "    " + StringUtil.printf(this.getName(), 12) + " " + StringUtil.printf(this.entry_period, 7) + " " + StringUtil.printf(this.exit_period, 8) + " " + StringUtil.printf(String.valueOf(this.inv_cost), 6) + " " + StringUtil.printf(this.inv_owner, 12) + " " + StringUtil.printf(String.valueOf(this.latitude), 4) + " " + StringUtil.printf(String.valueOf(this.longitude), 4) + "    " + StringUtil.printf(this.origin, 5) + "   " + StringUtil.printf(String.valueOf(this.f_capacity), 9);
        for (int i = 0; i < 26; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(this.f_mode_capacity[i]), 5) + " ";
        }
        return linea;
    }
}

