/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.ComponentPin;
import de.core.DeepEdit;
import de.core.InputPin;
import de.core.OutputPin;
import de.core.PietEditFrame;
import de.core.Pin;
import de.core.Probe;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class comp {
    public static final double MAX_VOLTAGE_LEVEL = 765.0;
    public Point Pos;
    protected Dimension Dim;
    protected String ComponentName;
    protected String ClassName;
    protected Point HitBox;
    protected Dimension HitBoxSize;
    protected InputPin[] IPin;
    protected OutputPin[] OPin;
    protected int Inputs;
    protected int Outputs;
    public int numstates = 2;
    private boolean Selected = false;
    protected boolean verhor;
    private boolean active = true;
    protected boolean valid = true;
    protected boolean inservice = true;
    protected int entry_period;
    protected int exit_period;
    protected int entry_month = 1;
    protected int exit_month = 12;
    static final int MAXLOOPS = 100;
    public static Font Font7 = new Font("Arial", 0, 7);
    public static Font Font8 = new Font("Arial", 0, 8);
    public static Font Font9 = new Font("Arial", 0, 9);
    public static Font Font10 = new Font("Arial", 0, 10);
    public static Font Font11 = new Font("Arial", 0, 11);
    public static Font Font12 = new Font("Arial", 0, 12);
    public static Font Font14 = new Font("Arial", 0, 14);
    public static Font Font16 = new Font("Arial", 0, 16);
    public static Font Font18 = new Font("Arial", 0, 18);
    public static Font Font20 = new Font("Arial", 0, 20);
    protected static Color CaptionColor = Color.lightGray;
    public static Color TextColor1 = Color.lightGray;
    protected static Color TextColor2 = Color.lightGray.darker();
    public static Color TextColor3 = Color.green;
    public static Color Color1 = Color.red;
    public static Color Color2 = Color.orange;
    public static Color Color3 = Color.green;
    public static Color Color4 = Color.blue;
    public static Color Color5 = Color.yellow;
    public Color auxcolor = Color.green;
    public Color ProbeColor = Color.magenta;
    public Image img;
    protected String con1 = " ";
    protected String con2 = " ";
    protected String con3 = " ";
    protected String inv_type = "A";
    protected String inv_owner = "None";
    public String auxs = "";
    public double FOR = 0.0;
    private String[] compParameterList;
    protected Map<String, ParameterData> mData = new HashMap<String, ParameterData>();

    public comp() {
        this.active = true;
    }

    public comp(String Name, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.setName(Name);
        this.active = true;
    }

    public comp(String Name, int entryperiod, int exitperiod) {
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = 1;
        this.exit_month = 12;
        this.setName(Name);
        this.active = true;
    }

    public comp(String Name, String type, String owner, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.inv_type = type;
        this.inv_owner = owner;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.setName(Name);
        this.active = true;
    }

    public comp(String Name, String type, String owner, int entryperiod, int exitperiod) {
        this.inv_type = type;
        this.inv_owner = owner;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = 1;
        this.exit_month = 12;
        this.setName(Name);
        this.active = true;
    }

    public comp(int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.active = true;
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.Pos = new Point(x, y);
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, int entryperiod, int exitperiod) {
        this.Pos = new Point(x, y);
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = 1;
        this.exit_month = 12;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double sapo) {
        this.Pos = new Point(x, y);
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, boolean vverhor, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.Pos = new Point(x, y);
        this.verhor = vverhor;
        if (this.verhor) {
            this.Dim = new Dimension(h, w);
            this.HitBox = new Point(yh, xh);
            this.HitBoxSize = new Dimension(hh, wh);
        } else {
            this.Dim = new Dimension(w, h);
            this.HitBox = new Point(xh, yh);
            this.HitBoxSize = new Dimension(wh, hh);
        }
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, boolean vverhor, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double sapo) {
        this.Pos = new Point(x, y);
        this.verhor = vverhor;
        if (this.verhor) {
            this.Dim = new Dimension(h, w);
            this.HitBox = new Point(yh, xh);
            this.HitBoxSize = new Dimension(hh, wh);
        } else {
            this.Dim = new Dimension(w, h);
            this.HitBox = new Point(xh, yh);
            this.HitBoxSize = new Dimension(wh, hh);
        }
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, String type, String owner, boolean vverhor, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.Pos = new Point(x, y);
        this.verhor = vverhor;
        this.inv_type = type;
        this.inv_owner = owner;
        if (this.verhor) {
            this.Dim = new Dimension(h, w);
            this.HitBox = new Point(yh, xh);
            this.HitBoxSize = new Dimension(hh, wh);
        } else {
            this.Dim = new Dimension(w, h);
            this.HitBox = new Point(xh, yh);
            this.HitBoxSize = new Dimension(wh, hh);
        }
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o) {
        this.Pos = new Point(x, y);
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.Pos = new Point(x, y);
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, String type, String owner, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        this.Pos = new Point(x, y);
        this.inv_type = type;
        this.inv_owner = owner;
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = entrymonth;
        this.exit_month = exitmonth;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, String type, String owner, int entryperiod, int exitperiod) {
        this.Pos = new Point(x, y);
        this.inv_type = type;
        this.inv_owner = owner;
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
        this.active = true;
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.entry_month = 1;
        this.exit_month = 12;
        this.Inputs = i;
        this.Outputs = o;
        this.IPin = new InputPin[i];
        this.OPin = new OutputPin[o];
        this.setName(Name);
    }

    public comp(comp CompToCopy, int xo, int yo) {
        int ix;
        this.Pos = new Point(CompToCopy.Pos.x - xo, CompToCopy.Pos.y - yo);
        this.Dim = new Dimension(CompToCopy.Dim.width, CompToCopy.Dim.height);
        this.HitBox = new Point(CompToCopy.HitBox.x, CompToCopy.HitBox.y);
        this.HitBoxSize = new Dimension(CompToCopy.HitBoxSize.width, CompToCopy.HitBoxSize.height);
        this.Inputs = CompToCopy.Inputs;
        this.Outputs = CompToCopy.Outputs;
        this.ComponentName = CompToCopy.ComponentName;
        this.entry_period = CompToCopy.entry_period;
        this.exit_period = CompToCopy.exit_period;
        this.entry_month = CompToCopy.entry_month;
        this.exit_month = CompToCopy.exit_month;
        this.active = CompToCopy.getactive();
        this.valid = CompToCopy.getvalid();
        this.inservice = CompToCopy.getinservice();
        this.inv_type = CompToCopy.inv_type;
        this.inv_owner = CompToCopy.inv_owner;
        this.ClassName = CompToCopy.ClassName;
        this.IPin = new InputPin[this.Inputs];
        this.OPin = new OutputPin[this.Outputs];
        for (ix = 0; ix < this.Inputs; ++ix) {
            this.IPin[ix] = new InputPin(CompToCopy.IPin[ix]);
        }
        for (ix = 0; ix < this.Outputs; ++ix) {
            this.OPin[ix] = new OutputPin(CompToCopy.OPin[ix]);
        }
        this.active = true;
    }

    abstract comp Copy(int var1, int var2);

    public boolean getverhor() {
        return this.verhor;
    }

    public boolean getactive() {
        return this.active;
    }

    public boolean getvalid() {
        if ("Contraint".equalsIgnoreCase(this.getClassName()) || "Simulation".equalsIgnoreCase(this.getClassName())) {
            this.valid = false;
        }
        return this.valid;
    }

    public boolean getinservice() {
        return this.inservice;
    }

    public int getinservicei() {
        if (this.inservice) {
            return 1;
        }
        return 0;
    }

    public int getentry_period() {
        return this.entry_period;
    }

    public int getexit_period() {
        return this.exit_period;
    }

    public int getentry_month() {
        return this.entry_month;
    }

    public int getexit_month() {
        return this.exit_month;
    }

    public String getName() {
        return this.ComponentName;
    }

    public String getClassName() {
        if (this.ClassName == null) {
            this.ClassName = this.getClass().getSimpleName();
        }
        return this.ClassName;
    }

    public int getxpos() {
        return this.Pos.x;
    }

    public int getypos() {
        return this.Pos.y;
    }

    public static Color getCaptionColor() {
        return CaptionColor;
    }

    public static void setCaptionColor(Color CaptionColor) {
        comp.CaptionColor = CaptionColor;
    }

    public static Color getLabelTextColor() {
        return TextColor2;
    }

    public static void setLabelTextColor(Color TextColor2) {
        comp.TextColor2 = TextColor2;
    }

    public comp[] getConnectedComponentList() {
        ArrayList<comp> lComp = new ArrayList<comp>();
        lComp.addAll(Arrays.asList(this.getConnectedInputComponentList()));
        lComp.addAll(Arrays.asList(this.getConnectedOutputComponentList()));
        comp[] myConnectedComponents = lComp.toArray(new comp[lComp.size()]);
        return myConnectedComponents;
    }

    public comp[] getConnectedInputComponentList() {
        ArrayList<comp> lComp = new ArrayList<comp>();
        for (int ix = 0; ix < this.Inputs; ++ix) {
            Pin DEPin;
            int xp = this.Pos.x + this.IPin[ix].PinPos.x;
            int yp = this.Pos.y + this.IPin[ix].PinPos.y;
            if (xp < 0 || yp < 0 || (DEPin = DeepEdit.PinGrid[xp][yp]) == null) continue;
            for (Object o : DEPin.GetAllComponents()) {
                if (o == null || o.equals(this) || !(o instanceof comp)) continue;
                lComp.add((comp)o);
            }
        }
        comp[] myConnectedComponents = lComp.toArray(new comp[lComp.size()]);
        return myConnectedComponents;
    }

    public comp[] getConnectedOutputComponentList() {
        ArrayList<comp> lComp = new ArrayList<comp>();
        for (int ix = 0; ix < this.Outputs; ++ix) {
            Pin DEPin;
            int xp = this.Pos.x + this.OPin[ix].PinPos.x;
            int yp = this.Pos.y + this.OPin[ix].PinPos.y;
            if (xp < 0 || yp < 0 || (DEPin = DeepEdit.PinGrid[xp][yp]) == null) continue;
            for (Object o : DEPin.GetAllComponents()) {
                if (o == null || o.equals(this) || !(o instanceof comp)) continue;
                lComp.add((comp)o);
            }
        }
        comp[] myConnectedComponents = lComp.toArray(new comp[lComp.size()]);
        return myConnectedComponents;
    }

    public String getcon1() {
        return this.con1;
    }

    public String getcon2() {
        return this.con2;
    }

    public String getcon3() {
        return this.con3;
    }

    public String getinv_type() {
        return this.inv_type;
    }

    public String getinv_owner() {
        return this.inv_owner;
    }

    public void setHitbox(int w, int h, int xh, int yh, int wh, int hh) {
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
    }

    public void setHitboxthree(int w, int h, int xh, int yh, int wh, int hh) {
        this.Dim = new Dimension(w, h);
        this.HitBox = new Point(xh, yh);
        this.HitBoxSize = new Dimension(wh, hh);
    }

    public void setPins(int a1, int a2, int a3, int a4, int a5, int a6, int b1, int b2, int b3, int b4, int b5, int b6) {
        this.IPin[0] = new InputPin("A", a1, a2, a3, a4, a5, a6, 2);
        this.OPin[0] = new OutputPin("Q", b1, b2, b3, b4, b5, b6, 2);
    }

    public void setPinsThree(int a1, int a2, int a3, int a4, int a5, int a6, int b1, int b2, int b3, int b4, int b5, int b6, int c1, int c2, int c3, int c4, int c5, int c6) {
        this.IPin[0] = new InputPin("A", a1, a2, a3, a4, a5, a6, 2);
        this.OPin[0] = new OutputPin("P", b1, b2, b3, b4, b5, b6, 2);
        this.OPin[1] = new OutputPin("Q", c1, c2, c3, c4, c5, c6, 2);
    }

    public void setentry_period(int n) {
        this.entry_period = n;
        if (this.getexit_period() <= this.entry_period) {
            this.setexit_period(this.entry_period + 1);
        }
    }

    public void setexit_period(int n) {
        this.exit_period = n;
    }

    public void setentry_month(int n) {
        this.entry_month = n;
    }

    public void setexit_month(int n) {
        this.exit_month = n;
    }

    public void setverhor(boolean n) {
        this.verhor = n;
    }

    public void setactive(boolean n) {
        this.active = n;
    }

    public void setvalid(boolean n) {
        this.valid = n;
    }

    public void setinservice(boolean n) {
        this.inservice = n;
    }

    public void setinservicei(int n) {
        if (n == 1) {
            this.inservice = true;
        } else if (n == 0) {
            this.inservice = false;
        }
    }

    public final void setName(String n) {
        assert (n != null) : "Never pass a null name to a component!!";
        if (this.ComponentName != null && !this.ComponentName.equals(n)) {
            String oldName = this.ComponentName;
            this.ComponentName = n;
            while (!DeepEdit.isCompNameUnique(this)) {
                this.ComponentName = StringUtil.createUniqueCompName(this.ComponentName);
            }
            DeepEdit.registerCompName(oldName, this.ComponentName, this);
            return;
        }
        this.ComponentName = n;
    }

    public void setxpos(int x) {
        this.Pos.x = x;
    }

    public void setypos(int y) {
        this.Pos.y = y;
    }

    public void setcon1(String n) {
        this.con1 = n;
    }

    public void setcon2(String n) {
        this.con2 = n;
    }

    public void setcon3(String n) {
        this.con3 = n;
    }

    public void setinv_type(String n) {
        this.inv_type = n;
    }

    public void setinv_owner(String n) {
        if (n == null) {
            this.inv_owner = "None";
            return;
        }
        this.inv_owner = n;
    }

    public void settype(String n) {
        this.inv_type = n;
    }

    public void setowner(String n) {
        this.inv_owner = n;
    }

    public String getParameterValueFromDB(String ParameterName) {
        String strValue = null;
        String strQuery = "SELECT " + ParameterName + " FROM " + this.getClassName() + " WHERE Name = '" + this.getName() + "'";
        try {
            Connection myConn = DeepEdit.getDeepDBConnection();
            Statement stmt = myConn.createStatement();
            ResultSet rs = stmt.executeQuery(strQuery);
            while (rs.next()) {
                strValue = rs.getString(ParameterName);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error Openning connection with DeepBD: " + ex.getMessage());
            System.out.println("DeepEdit could not execute query: " + strQuery);
            ex.printStackTrace(System.out);
        }
        return strValue;
    }

    public String getParamaterValue(String sParameterName) {
        ParameterData pData = this.getDefaultParameterInfo(sParameterName);
        this.getParameterInfo(sParameterName, pData);
        return pData.getValue();
    }

    public DE_GeneralEnums.databaseDataType getParameterType(String sParameterName) {
        ParameterData pData = this.getDefaultParameterInfo(sParameterName);
        return pData.geteDataType();
    }

    public String getDefaultParameterValue(String sParameterName) {
        ParameterData pData = this.getDefaultParameterInfo(sParameterName);
        return pData.getValue();
    }

    public ParameterData getDefaultParameterInfo(String sParameterName) {
        return DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName);
    }

    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con1")) {
            sValue = this.getcon1();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con3")) {
            sValue = this.getcon3();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con1")) {
            this.setcon1(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con3")) {
            this.setcon3(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }

    public boolean setParameterValue(String sParameterName, String sValue) {
        ParameterData pData = this.getDefaultParameterInfo(sParameterName);
        assert (pData != null) : "Why parameter " + sParameterName + " couldn't be mapped to component " + this.getName();
        pData.setValue(sValue);
        return this.setParameterInfo(sParameterName, pData);
    }

    public boolean isSupportedParameter(String sParameterName) {
        if (sParameterName == null) {
            return false;
        }
        for (String sName : this.getParameterNamesFromXML()) {
            if (!sParameterName.equalsIgnoreCase(sName)) continue;
            return true;
        }
        return false;
    }

    public String[] getParameterNamesFromXML() {
        List<String> lParam = DeepEdit.getParameterNameList(this.ClassName);
        return lParam.toArray(new String[lParam.size()]);
    }

    public String[] getParameterNamesFromDB() {
        if (this.compParameterList != null && this.compParameterList.length > 0) {
            return this.compParameterList;
        }
        String strQuery = "SELECT * FROM " + this.getClassName();
        ArrayList<String> tempNamesArray = new ArrayList<String>();
        try {
            Connection myConn = DeepEdit.getDeepDBConnection();
            Statement stmt = myConn.createStatement();
            ResultSet rs = stmt.executeQuery(strQuery);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                tempNamesArray.add(rsmd.getColumnName(i));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            System.out.println("Error connecting to DeepBD: " + ex.getMessage());
            System.out.println("DeepEdit could not execute query: " + strQuery);
            ex.printStackTrace(System.err);
            return new String[0];
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.compParameterList = new String[tempNamesArray.size()];
        tempNamesArray.toArray(this.compParameterList);
        return this.compParameterList;
    }

    public List<ParameterData> getAllParametersInfo() {
        ArrayList<ParameterData> myParameters = new ArrayList<ParameterData>();
        for (String parName : this.getParameterNamesFromXML()) {
            ParameterData oData = new ParameterData(parName);
            if (!this.getParameterInfo(parName, oData)) continue;
            myParameters.add(oData);
        }
        return myParameters;
    }

    public int setAllParameterInfo(List<ParameterData> lData) {
        int nFalse = 0;
        for (ParameterData pData : lData) {
            if (this.setParameterInfo(pData.getName(), pData)) continue;
            ++nFalse;
        }
        return nFalse;
    }

    public void SimulateSetUpFlows(double sref) {
    }

    public void SimulateLogic() {
    }

    public void InformConnectedComponents(int id) {
        this.con2 = " ";
        this.con3 = " ";
        for (int o = 0; o < this.Outputs; ++o) {
            for (int ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                comp ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
                this.setcon2(ConnectedComponent.ComponentName);
                if (this.Outputs <= 1 || o != 1) continue;
                this.setcon3(ConnectedComponent.ComponentName);
            }
            if (this.OPin[o].ConnComps.size() <= 2 || !DeepEdit.PrintConnecWarnings) continue;
            System.out.println(this.ComponentName + ": More than one connection!!!");
        }
    }

    public void InformAllComponents() {
        comp ConnectedComponent;
        int ix;
        int numProbes;
        boolean nc = false;
        ArrayList<String> ConnectedBusbars = new ArrayList<String>();
        ArrayList<String> strOutputStream = new ArrayList<String>();
        if (this.Inputs != 0) {
            this.con1 = " ";
        }
        if (this.Outputs != 0) {
            this.con2 = " ";
        }
        if (this.Outputs == 2) {
            this.con3 = " ";
        }
        for (int o = 0; o < this.Outputs; ++o) {
            numProbes = 0;
            for (ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (ConnectedComponent instanceof Probe) {
                    ++numProbes;
                }
                if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
                ConnectedBusbars.add(ConnectedComponent.ComponentName);
                if (o == 0) {
                    this.setcon2(ConnectedComponent.ComponentName);
                    continue;
                }
                if (o != 1) continue;
                this.setcon3(ConnectedComponent.ComponentName);
            }
            if (this.OPin[o].ConnComps.size() <= 2 + numProbes) continue;
            strOutputStream.add("WARNING: Component '" + this.ComponentName + "' has more than 1 component connected to the same output pin (" + this.Pos.x + this.OPin[o].PinPos.x + "," + this.Pos.y + this.OPin[o].PinPos.y + ")");
            for (ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.OPin[o].ConnComps.get(ix);
                if (ConnectedComponent == this) continue;
                strOutputStream.add(" -" + ConnectedComponent.getName());
            }
        }
        if (ConnectedBusbars.size() > 1) {
            strOutputStream.add("WARNING: Component " + this.getName() + " is connected to more than 1 busbar:");
            for (Object e : ConnectedBusbars) {
                strOutputStream.add(" -" + e);
            }
        }
        ConnectedBusbars.clear();
        for (int i = 0; i < this.Inputs; ++i) {
            numProbes = 0;
            for (ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.IPin[i].ConnComps.elementAt(ix);
                if (ConnectedComponent instanceof Probe) {
                    ++numProbes;
                }
                if (ConnectedComponent == this || !(ConnectedComponent instanceof Busbar)) continue;
                ConnectedBusbars.add(ConnectedComponent.ComponentName);
                this.setcon1(ConnectedComponent.ComponentName);
            }
            if (this.IPin[i].ConnComps.size() <= 2 + numProbes) continue;
            strOutputStream.add("WARNING: Component '" + this.ComponentName + "' has more than 1 component connected to the same output pin (" + this.Pos.x + this.IPin[i].PinPos.x + "," + this.Pos.y + this.IPin[i].PinPos.y + ")");
            for (ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.IPin[i].ConnComps.get(ix);
                if (ConnectedComponent == this) continue;
                strOutputStream.add(" -" + ConnectedComponent.getName());
            }
        }
        if (ConnectedBusbars.size() > 1) {
            strOutputStream.add("WARNING: Component '" + this.getName() + "' is connected to more than 1 busbar:");
            for (Object e : ConnectedBusbars) {
                strOutputStream.add(" -" + e);
            }
        }
        if (DeepEdit.PrintConnecWarnings) {
            while (!strOutputStream.isEmpty()) {
                System.out.println(strOutputStream.remove(0));
            }
        }
    }

    public int InformInput(comp CompToCompare) {
        for (int i = 0; i < this.Inputs; ++i) {
            assert (this.IPin[i].ConnComps != null) : "Did you forget to call SimulateSetUp before calling your calculation routine??";
            for (int ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                comp ConnectedComponent = (comp)this.IPin[i].ConnComps.elementAt(ix);
                if (ConnectedComponent == this || ConnectedComponent != CompToCompare) continue;
                return i;
            }
        }
        return -1;
    }

    public int InformOutput(comp CompToCompare) {
        for (int o = 0; o < this.Outputs; ++o) {
            assert (this.OPin[o].ConnComps != null) : "Did you forget to call SimulateSetUp before calling your calculation routine??";
            for (int ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                comp ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (ConnectedComponent == this || ConnectedComponent != CompToCompare) continue;
                return o;
            }
        }
        return -1;
    }

    public ComponentPin InputPinInPosition(int x, int y) {
        for (int ix = 0; ix < this.Inputs; ++ix) {
            if (this.Pos.x + this.IPin[ix].PinPos.x != x || this.Pos.y + this.IPin[ix].PinPos.y != y) continue;
            return this.IPin[ix];
        }
        return null;
    }

    public ComponentPin OutputPinInPosition(int x, int y) {
        for (int ix = 0; ix < this.Outputs; ++ix) {
            if (this.Pos.x + this.OPin[ix].PinPos.x != x || this.Pos.y + this.OPin[ix].PinPos.y != y) continue;
            return this.OPin[ix];
        }
        return null;
    }

    public void SimulateSetUp(int x, int y, Vector ActComps) {
        int ix;
        for (ix = 0; ix < this.Inputs; ++ix) {
            if (this.Pos.x + this.IPin[ix].PinPos.x != x || this.Pos.y + this.IPin[ix].PinPos.y != y) continue;
            this.IPin[ix].ConnComps = ActComps;
        }
        for (ix = 0; ix < this.Outputs; ++ix) {
            if (this.Pos.x + this.OPin[ix].PinPos.x != x || this.Pos.y + this.OPin[ix].PinPos.y != y) continue;
            this.OPin[ix].ConnComps = ActComps;
        }
    }

    public boolean AdjustPosition(Pin[][] PinGrid, int x, int y) {
        this.Pos.x += x;
        this.Pos.y += y;
        return true;
    }

    public void CheckPosition(DeepEdit app) {
        if (this.Pos.x < 0) {
            this.Pos.x = 0;
        }
        if (this.Pos.y < 0) {
            this.Pos.y = 0;
        }
        if (this.Pos.x > DeepEdit.getMaxXPoints() - this.Dim.width) {
            this.Pos.x = DeepEdit.getMaxXPoints() - this.Dim.width;
        }
        if (this.Pos.y > DeepEdit.getMaxYPoints() - this.Dim.height) {
            this.Pos.y = DeepEdit.getMaxYPoints() - this.Dim.height;
        }
    }

    public void CheckPosition(PietEditFrame app) {
        if (this.Pos.x < 0) {
            this.Pos.x = 0;
        }
        if (this.Pos.y < 0) {
            this.Pos.y = 0;
        }
        if (this.Pos.x > DeepEdit.getMaxXPoints() - this.Dim.width) {
            this.Pos.x = DeepEdit.getMaxXPoints() - this.Dim.width;
        }
        if (this.Pos.y > DeepEdit.getMaxYPoints() - this.Dim.height) {
            this.Pos.y = DeepEdit.getMaxYPoints() - this.Dim.height;
        }
    }

    public void CheckActive(int actperiod, int actmonth) {
        this.active = false;
        if ((this.getentry_period() - 1) * 12 + this.getentry_month() <= (actperiod - 1) * 12 + actmonth && (this.getexit_period() - 1) * 12 + this.getexit_month() >= (actperiod - 1) * 12 + actmonth) {
            this.setactive(true);
        }
    }

    public boolean CheckIfComponentInSelectBox(int x1, int y1, int x2, int y2) {
        if (!this.isDrawnInSchematic()) {
            return false;
        }
        int cx1 = this.Pos.x + this.HitBox.x;
        int cy1 = this.Pos.y + this.HitBox.y;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height;
        this.Selected = x1 <= cx1 && cx2 <= x2 && y1 <= cy1 && cy2 <= y2;
        return this.Selected;
    }

    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        int y2min;
        if (!this.isDrawnInSchematic()) {
            return false;
        }
        int cx1 = this.Pos.x + this.HitBox.x;
        int cy1 = this.Pos.y + this.HitBox.y;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height;
        int x1max = cx1 > x1 ? cx1 : x1;
        int x2min = cx2 < x2 ? cx2 : x2;
        int y1max = cy1 > y1 ? cy1 : y1;
        int n = y2min = cy2 < y2 ? cy2 : y2;
        return x1max <= x2min && y1max <= y2min;
    }

    public boolean CheckIfComponentClicked(int x, int y) {
        if (!this.isDrawnInSchematic()) {
            return false;
        }
        return this.Pos.x + this.HitBox.x <= x && x <= this.Pos.x + this.HitBox.x + this.HitBoxSize.width && this.Pos.y + this.HitBox.y <= y && y <= this.Pos.y + this.HitBox.y + this.HitBoxSize.height;
    }

    public boolean isDrawnInSchematic() {
        return this.Pos != null && this.HitBox != null && this.HitBoxSize != null;
    }

    public boolean isLocatedAt(int x, int y) {
        return this.CheckIfComponentClicked(x, y);
    }

    protected void RegisterPin(Pin ActPin) {
        ActPin.AddComponent(this);
    }

    public void RegisterPins(Pin[][] PinGrid, int x, int y) {
        int yp;
        int xp;
        int ix;
        if (PinGrid == null) {
            return;
        }
        for (ix = 0; ix < this.Inputs; ++ix) {
            xp = x + this.IPin[ix].PinPos.x;
            yp = y + this.IPin[ix].PinPos.y;
            assert (xp >= 0 && yp >= 0) : "This component seems to be moved outside the pingrid area: " + this.ComponentName;
            if (PinGrid[xp][yp] == null) {
                PinGrid[xp][yp] = new Pin();
            }
            this.RegisterPin(PinGrid[xp][yp]);
        }
        for (ix = 0; ix < this.Outputs; ++ix) {
            xp = x + this.OPin[ix].PinPos.x;
            yp = y + this.OPin[ix].PinPos.y;
            assert (xp >= 0 && yp >= 0) : "This component seems to be moved outside the pingrid area: " + this.ComponentName;
            if (PinGrid[xp][yp] == null) {
                PinGrid[xp][yp] = new Pin();
            }
            this.RegisterPin(PinGrid[xp][yp]);
        }
    }

    protected void RemovePin(Pin ActPin) {
        if (ActPin != null) {
            ActPin.RemoveComponent(this);
        }
    }

    public void RemovePinsGrid(Pin[][] PinGrid) {
        int yp;
        int xp;
        int ix;
        for (ix = 0; ix < this.Inputs; ++ix) {
            xp = this.Pos.x + this.IPin[ix].PinPos.x;
            yp = this.Pos.y + this.IPin[ix].PinPos.y;
            this.RemovePin(PinGrid[xp][yp]);
        }
        for (ix = 0; ix < this.Outputs; ++ix) {
            xp = this.Pos.x + this.OPin[ix].PinPos.x;
            yp = this.Pos.y + this.OPin[ix].PinPos.y;
            this.RemovePin(PinGrid[xp][yp]);
        }
    }

    public void PlacePinsHere(Pin[][] PinGrid) {
        this.RegisterPins(PinGrid, this.Pos.x, this.Pos.y);
    }

    public boolean SimMouseDown() {
        return false;
    }

    public boolean SimMouseUp() {
        return false;
    }

    public void SaveDatabase() throws SQLException {
        String sqlQuery = "INSERT INTO " + this.getClassName() + " (";
        int contNames = 0;
        for (String sParameter : this.getParameterNamesFromDB()) {
            sqlQuery = sqlQuery + "," + sParameter;
            ++contNames;
        }
        if (contNames == 0) {
            return;
        }
        sqlQuery = sqlQuery.replaceFirst(",", "") + ") VALUES (";
        for (String sParameter : this.getParameterNamesFromDB()) {
            ParameterData pData = new ParameterData(sParameter);
            this.getParameterInfo(sParameter, pData);
            sqlQuery = sqlQuery + "," + pData.getValue();
        }
        sqlQuery = sqlQuery.replaceFirst(",", "") + ")";
        try {
            Statement stmt = DeepEdit.getDeepDBConnection().createStatement();
            stmt.executeUpdate(sqlQuery);
        }
        catch (SQLException e) {
            SQLException ae = new SQLException(e.getMessage() + ".\nExecuting query " + sqlQuery);
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public void saveToDatabase() throws SQLException {
        String sqlQuery = "INSERT INTO " + this.getClassName() + " (";
        for (String sParameter : this.getParameterNamesFromDB()) {
            sqlQuery = sqlQuery + "," + sParameter;
        }
        sqlQuery = sqlQuery.replaceFirst(",", "") + ") VALUES (";
        for (String sParameter : this.getParameterNamesFromDB()) {
            ParameterData pData = new ParameterData(sParameter);
            this.getParameterInfo(sParameter, pData);
            sqlQuery = sqlQuery + "," + pData.getValue();
        }
        sqlQuery = sqlQuery.replaceFirst(",", "") + ")";
        try {
            Statement stmt = DeepEdit.getDeepDBConnection().createStatement();
            stmt.executeUpdate(sqlQuery);
        }
        catch (SQLException e) {
            SQLException ae = new SQLException(e.getMessage() + ".\nExecuting query " + sqlQuery);
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.getClassName());
        for (ParameterData pData : this.getAllParametersInfo()) {
            myPrintStream.println(" " + pData.getName() + " " + pData.getValue());
        }
        myPrintStream.println("end describe component");
    }

    public void saveToFile(PrintStream ps) {
        ps.println("describe component " + this.getClassName());
        for (ParameterData pData : this.getAllParametersInfo()) {
            ps.println(" " + pData.getName() + " " + pData.getValue());
        }
        ps.println("end describe component");
    }

    public static Color floatToColor(double fkv) {
        switch (DeepEdit.getVoltageColorStyle()) {
            case Classic: {
                return comp.getClassicColor(fkv);
            }
            case Blue: {
                return comp.getLinearColor(fkv, Color.WHITE, Color.BLUE.darker());
            }
            case DarkGrayScale: {
                return comp.getLinearColor(fkv, Color.BLACK, Color.WHITE);
            }
            case LightGrayScale: {
                return comp.getLinearColor(fkv, Color.WHITE, Color.darkGray);
            }
        }
        return comp.getClassicColor(fkv);
    }

    private static Color getClassicColor(double dkV) {
        String kv = String.valueOf(Math.rint(dkV * 10.0) * 0.1);
        if ("0.0".equals(kv)) {
            return Color.black;
        }
        if ("0.4".equals(kv)) {
            return Color.lightGray;
        }
        if ("1.0".equals(kv)) {
            return Color.lightGray;
        }
        if ("3.0".equals(kv)) {
            return Color.lightGray;
        }
        if ("5.0".equals(kv)) {
            return Color.lightGray.darker();
        }
        if ("6.6".equals(kv)) {
            return Color.lightGray.darker();
        }
        if ("6.9".equals(kv)) {
            return Color.lightGray.darker();
        }
        if ("10.0".equals(kv)) {
            return Color.lightGray.darker();
        }
        if ("10.5".equals(kv)) {
            return Color.magenta;
        }
        if ("11.0".equals(kv)) {
            return Color.magenta;
        }
        if ("11.5".equals(kv)) {
            return Color.magenta;
        }
        if ("12.0".equals(kv)) {
            return Color.magenta;
        }
        if ("13.2".equals(kv)) {
            return Color.magenta;
        }
        if ("13.8".equals(kv)) {
            return Color.magenta;
        }
        if ("15.0".equals(kv)) {
            return Color.magenta.darker();
        }
        if ("15.8".equals(kv)) {
            return Color.magenta.darker();
        }
        if ("16.0".equals(kv)) {
            return Color.magenta.darker();
        }
        if ("16.5".equals(kv)) {
            return Color.magenta.darker();
        }
        if ("18.0".equals(kv)) {
            return Color.magenta.darker();
        }
        if ("20.0".equals(kv)) {
            return Color.blue;
        }
        if ("23.0".equals(kv)) {
            return Color.blue;
        }
        if ("25.0".equals(kv)) {
            return Color.blue;
        }
        if ("27.0".equals(kv)) {
            return Color.blue;
        }
        if ("30.0".equals(kv)) {
            return Color.blue;
        }
        if ("33.0".equals(kv)) {
            return Color.blue;
        }
        if ("44.0".equals(kv)) {
            return Color.orange;
        }
        if ("60.0".equals(kv)) {
            return Color.orange.darker();
        }
        if ("66.0".equals(kv)) {
            return Color.orange.darker();
        }
        if ("100.0".equals(kv)) {
            return Color.yellow;
        }
        if ("110.0".equals(kv)) {
            return Color.yellow;
        }
        if ("115.0".equals(kv)) {
            return Color.yellow;
        }
        if ("116.0".equals(kv)) {
            return Color.yellow;
        }
        if ("131.0".equals(kv)) {
            return Color.yellow;
        }
        if ("132.0".equals(kv)) {
            return Color.yellow;
        }
        if ("150.0".equals(kv)) {
            return Color.pink;
        }
        if ("154.0".equals(kv)) {
            return Color.pink;
        }
        if ("220.0".equals(kv)) {
            return Color.green.darker();
        }
        if ("230.0".equals(kv)) {
            return Color.green.darker();
        }
        if ("345.0".equals(kv)) {
            return Color.orange;
        }
        if ("400.0".equals(kv)) {
            return Color.orange;
        }
        if ("500.0".equals(kv)) {
            return Color.red;
        }
        if ("750.0".equals(kv)) {
            return Color.magenta;
        }
        return Color.black;
    }

    private static Color getLinearColor(double dkV, Color cHighVoltage, Color cLowVoltage) {
        double p = dkV / 765.0;
        int nRed = (int)((double)cHighVoltage.getRed() * p + (double)cLowVoltage.getRed() * (1.0 - p));
        int nBlue = (int)((double)cHighVoltage.getBlue() * p + (double)cLowVoltage.getBlue() * (1.0 - p));
        int nGrenn = (int)((double)cHighVoltage.getGreen() * p + (double)cLowVoltage.getGreen() * (1.0 - p));
        return new Color(nRed, nGrenn, nBlue);
    }

    public void DrawInputPins(Graphics2D g, int x, int y, int gs) {
        for (int ix = 0; ix < this.Inputs; ++ix) {
            this.IPin[ix].draw(g, x, y, gs);
        }
    }

    public void DrawOutputPins(Graphics2D g, int x, int y, int gs) {
        for (int ix = 0; ix < this.Outputs; ++ix) {
            this.OPin[ix].draw(g, x, y, gs);
        }
    }

    public void DrawOutputpin1(Graphics2D g, int x, int y, int gs) {
        this.OPin[0].draw(g, x, y, gs);
    }

    public void DrawOutputpin2(Graphics2D g, int x, int y, int gs) {
        this.OPin[1].draw(g, x, y, gs);
    }

    public void draw(Graphics2D g, int xp, int yp, int gs) {
        if (this.Selected) {
            int x = this.Pos.x - xp;
            int y = this.Pos.y - yp;
            if (gs > 1) {
                if (this.ClassName.equals("mdb_cust") || this.ClassName.equals("mdb_iso") || this.ClassName.equals("mdb_sup")) {
                    g.setColor(Color.lightGray);
                    g.setColor(Color.lightGray);
                    g.drawRect((int)(((double)(x + this.HitBox.x) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.5) * (double)gs), gs, gs);
                    g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.5) * (double)gs), gs, gs);
                    g.drawRect((int)(((double)(x + this.HitBox.x) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.5) * (double)gs), gs, gs);
                    g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.5) * (double)gs), gs, gs);
                } else {
                    g.setColor(Color.lightGray);
                    g.drawRect((int)(((double)(x + this.HitBox.x) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs), gs / 2, gs / 2);
                    g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs), gs / 2, gs / 2);
                    g.drawRect((int)(((double)(x + this.HitBox.x) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.25) * (double)gs), gs / 2, gs / 2);
                    g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
            } else if (this.ClassName.equals("mdb_cust") || this.ClassName.equals("mdb_iso") || this.ClassName.equals("mdb_sup")) {
                g.setColor(Color.lightGray);
                g.setColor(Color.lightGray);
                g.drawRect((int)(((double)(x + this.HitBox.x) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.5) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.5) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.5) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.5) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.5) * (double)gs), gs, gs);
            } else {
                g.setColor(Color.lightGray);
                g.drawRect((int)(((double)(x + this.HitBox.x) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.25) * (double)gs), gs, gs);
                g.drawRect((int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 0.25) * (double)gs), (int)(((double)(y + this.HitBox.y + this.HitBoxSize.height) - 0.25) * (double)gs), gs, gs);
            }
        }
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        if (this.Selected) {
            // empty if block
        }
    }

    public void DrawHitBox(Graphics2D g, int x, int y, int gs) {
        g.setColor(Color.green);
        g.drawRect((x + this.HitBox.x) * gs, (y + this.HitBox.y) * gs, this.HitBoxSize.width * gs, this.HitBoxSize.height * gs);
        g.setColor(Color.pink);
        g.drawRect(x * gs, (y + 1) * gs, this.Dim.width * gs, this.Dim.height * gs);
    }

    public boolean isSelected() {
        return this.Selected;
    }

    public void setSelected(boolean Selected) {
        this.Selected = Selected;
    }

    public String toString() {
        return this.getName();
    }

    public static void copyParameters(comp compFrom, comp compTo) {
        for (ParameterData pData : compFrom.getAllParametersInfo()) {
            compTo.setParameterInfo(pData.Name, pData);
        }
    }
}

