/*
 * Decompiled with CFR 0.152.
 */
package de.core;

public class chromosome {
    protected long genes = 0L;

    public void setGenes(long newGenes) {
        this.genes = newGenes;
    }

    public long getGenes() {
        return this.genes;
    }

    public static void crossOver(chromosome c1, chromosome c2, int splitPos) {
        long lowerMask = (long)Math.pow(2.0, splitPos) - 1L;
        long upperMask = lowerMask ^ 0xFFFFFFFFFFFFFFFFL;
        long lower1 = c1.genes & lowerMask;
        long upper1 = c1.genes & upperMask;
        long lower2 = c2.genes & lowerMask;
        long upper2 = c2.genes & upperMask;
        c1.genes = upper1 | lower2;
        c2.genes = upper2 | lower1;
    }

    public void flip(int bitNum) {
        long x = (long)Math.pow(2.0, bitNum);
        this.genes = (this.genes & x) != 0L ? (this.genes &= x ^ 0xFFFFFFFFFFFFFFFFL) : (this.genes |= x);
    }

    public void print(int chromCount) {
        for (int i = chromCount; i > 0; --i) {
            long j;
            if (i % 8 == 0) {
                System.out.print(" ");
            }
            if ((this.genes & (j = (long)Math.pow(2.0, i - 1))) != 0L) {
                System.out.print("1");
                continue;
            }
            System.out.print("0");
        }
        System.out.println(" " + this.genes);
    }
}

