/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class ZLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int numLines;
    protected int marginWidth;
    protected int marginHeight;
    protected int lineHeight;
    protected int lineAscent;
    protected int maxWidth;
    protected int alignment = 0;
    protected int[] lineWidths;

    protected void newLabel(String label) {
        StringTokenizer t = new StringTokenizer(label, "\n");
        this.numLines = t.countTokens();
        this.lines = new String[this.numLines];
        this.lineWidths = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i] = t.nextToken();
        }
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.lineHeight = fm.getHeight();
        this.lineAscent = fm.getAscent();
        this.maxWidth = 0;
        for (int i = 0; i < this.numLines; ++i) {
            this.lineWidths[i] = fm.stringWidth(this.lines[i]);
            if (this.lineWidths[i] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidths[i];
        }
    }

    public ZLabel(String label, int marginWidth, int marginHeight, int alignment) {
        this.newLabel(label);
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
        this.alignment = alignment;
    }

    public ZLabel(String label, int marginWidth, int marginHeight) {
        this(label, marginWidth, marginHeight, 0);
    }

    public ZLabel(String label, int alignment) {
        this(label, 10, 10, alignment);
    }

    public ZLabel(String label) {
        this(label, 10, 10, 0);
    }

    public void setLabel(String label) {
        this.newLabel(label);
        this.measure();
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
        this.repaint();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void setAlignment(int a) {
        this.alignment = a;
        this.repaint();
    }

    public void setMarginWidth(int mw) {
        this.marginWidth = mw;
        this.repaint();
    }

    public void setMarginHeight(int mh) {
        this.marginHeight = mh;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.maxWidth + 2 * this.marginWidth, this.numLines * this.lineHeight + 2 * this.marginHeight);
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(this.maxWidth, this.numLines * this.lineHeight);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int y = this.lineAscent + (d.height - this.numLines * this.lineHeight) / 2;
        int i = 0;
        while (i < this.numLines) {
            int x;
            switch (this.alignment) {
                case 0: {
                    x = this.marginWidth;
                    break;
                }
                case 2: {
                    x = d.width - this.marginWidth - this.lineWidths[i];
                    break;
                }
                default: {
                    x = (d.width - this.lineWidths[i]) / 2;
                }
            }
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.lineHeight;
        }
    }
}

