/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEditFrame;
import de.core.FontDialog;
import de.core.ZAnswerDialog;
import de.core.ZFileReadSmart;
import de.utils.StringUtil;
import java.awt.AWTError;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.StringTokenizer;

public class ZFileViewer
extends Frame
implements ActionListener,
WindowListener {
    DeepEditFrame frame;
    private Font ListDialogFont;
    FontDialog MyFontDialog;
    static final int minNumberOfChars = 7;
    static String appName = "ZFileViewer";
    static String newFilename = "Untitled";
    static String fileOpenSmartStr = "Open and get readable text...";
    String curFilename = newFilename;
    TextArea ta;
    MenuBar mainMenuBar;
    Menu menuFile;
    Menu menuHelp;

    void Open_Action() {
        try {
            FileDialog fd = new FileDialog((Frame)this, "Open a File", 0);
            fd.setDirectory("./results");
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.openFile(fd.getDirectory() + fd.getFile());
            }
        }
        catch (AWTError e) {
            this.showCatchError(e);
        }
    }

    void Option_Action() {
        if (this.MyFontDialog == null) {
            this.MyFontDialog = new FontDialog(this);
            this.MyFontDialog.setVisible(true);
        }
    }

    void Print_Action() {
        PrintJob pj = this.getToolkit().getPrintJob(this, this.getTitle(), null);
        if (pj != null) {
            Graphics pg = pj.getGraphics();
            if (pg != null) {
                String s = this.ta.getText();
                this.printLongString(pj, pg, s);
                pg.dispose();
            }
            pj.end();
        }
    }

    void printLongString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics context not PrintGraphics");
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height;
        int pageWidth = pjob.getPageDimension().width;
        int borderH = (int)((double)pageHeight / 29.5);
        int borderW = pageWidth / 21;
        pg.setFont(this.ListDialogFont);
        FontMetrics fm = pg.getFontMetrics(this.ListDialogFont);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = 2 * borderH;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                if (curHeight + fontHeight > pageHeight) {
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(this.ListDialogFont);
                    }
                    curHeight = 2 * borderW;
                }
                curHeight += fontHeight;
                if (pg != null) {
                    pg.drawString(nextLine, 2 * borderW, curHeight - fontDescent);
                    ++linesForThisPage;
                    ++linesForThisJob;
                    continue;
                }
                System.out.println("pg null");
            } while (nextLine != null);
            pg.dispose();
        }
        catch (EOFException eof) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void OpenSmart_Action() {
        try {
            FileDialog fd = new FileDialog((Frame)this, "Open a File", 0);
            fd.setDirectory("./results");
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.openFileSmart(fd.getDirectory() + fd.getFile());
            }
        }
        catch (AWTError e) {
            this.showCatchError(e);
        }
    }

    void Info_Action() {
        StringTokenizer t = new StringTokenizer(this.ta.getText(), "\n");
        int numLines = t.countTokens();
        int numCols = 0;
        for (int i = 0; i < numLines; ++i) {
            String curLine = t.nextToken();
            if (numCols >= curLine.length()) continue;
            numCols = curLine.length();
        }
        ZAnswerDialog infoDialog = new ZAnswerDialog((Frame)this, "File Info", "Total number of characters: " + this.ta.getText().length() + "\nTotal number of lines: " + numLines + "\nMax number of columns: " + numCols, "Ok");
        while (infoDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        infoDialog.dispose();
    }

    void About_Action() {
        ZAnswerDialog aboutDialog = new ZAnswerDialog(this, "About", "DeepEdit TextViewer\n \n(c) 1997, 1998", "Ok", 1);
        while (aboutDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        aboutDialog.dispose();
    }

    void Exit_Action() {
        this.quit(0);
    }

    void openFile(String filename) {
        if (!new File(filename).isFile()) {
            this.showErrorBox("File not found.");
            return;
        }
        try {
            StringUtil.printFileToTextArea(filename, this.ta);
            this.curFilename = filename;
            this.showTitle();
        }
        catch (FileNotFoundException e) {
            this.showCatchError(e);
        }
        catch (IOException e) {
            this.showCatchError(e);
        }
        this.showTitle();
    }

    protected void openFileSmart(String filename) {
        if (!new File(filename).isFile()) {
            this.showErrorBox("File not found.");
            return;
        }
        try {
            new ZFileReadSmart(filename, 7, this.ta);
            this.curFilename = filename;
        }
        catch (FileNotFoundException e) {
            this.showCatchError(e);
        }
        catch (IOException e) {
            this.showCatchError(e);
        }
        this.showTitle();
    }

    void showCatchError(Throwable e) {
        this.showErrorBox(e.toString());
    }

    void showErrorBox(String msg) {
        ZAnswerDialog errorDialog = new ZAnswerDialog((Frame)this, "Error", msg, "Ok");
        while (errorDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        errorDialog.dispose();
    }

    void showTitle() {
        String filename = !this.curFilename.equals(newFilename) ? new File(this.curFilename).getName() : newFilename;
        this.setTitle(appName + " - " + filename);
    }

    void quit(int i) {
        this.setVisible(false);
        this.dispose();
        this.frame.MyZFileViewer = null;
    }

    public void setfont(Font ff) {
        this.ListDialogFont = ff;
        FontMetrics ListDialogFontMetrics = this.getFontMetrics(this.ListDialogFont);
        this.setFont(this.ListDialogFont);
        this.ta.setFont(this.ListDialogFont);
        this.repaint();
    }

    public Font getfont() {
        return this.ListDialogFont;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String label = event.getActionCommand();
        if (label.equalsIgnoreCase("Open...")) {
            this.Open_Action();
        } else if (label.equalsIgnoreCase("Print...")) {
            this.Print_Action();
        } else if (label.equalsIgnoreCase("Option...")) {
            this.Option_Action();
        } else if (label.equalsIgnoreCase(fileOpenSmartStr)) {
            this.OpenSmart_Action();
        } else if (label.equalsIgnoreCase("Info...")) {
            this.Info_Action();
        } else if (label.equalsIgnoreCase("Exit")) {
            this.Exit_Action();
        } else if (label.equalsIgnoreCase("About")) {
            this.About_Action();
        }
    }

    @Override
    public void windowClosed(WindowEvent event) {
        this.quit(0);
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.quit(0);
    }

    public ZFileViewer(DeepEditFrame f) {
        this.frame = f;
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.addNotify();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ZFileViewer.this.setVisible(false);
                ZFileViewer.this.dispose();
                ZFileViewer.this.frame.MyZFileViewer = null;
            }
        });
        this.ListDialogFont = new Font("Monospaced", 0, 11);
        FontMetrics ListDialogFontMetrics = this.getFontMetrics(this.ListDialogFont);
        this.setFont(this.ListDialogFont);
        this.setSize(this.getInsets().left + this.getInsets().right + 400, this.getInsets().top + this.getInsets().bottom + 300);
        this.ta = new TextArea();
        this.ta.setEditable(false);
        this.ta.setBounds(this.getInsets().left + 0, this.getInsets().top + 0, 400, 300);
        this.add(this.ta);
        this.showTitle();
        this.mainMenuBar = new MenuBar();
        this.menuFile = new Menu("File");
        this.menuFile.add("Open...");
        this.menuFile.add(fileOpenSmartStr);
        this.menuFile.addSeparator();
        this.menuFile.add("Print...");
        this.menuFile.addSeparator();
        this.menuFile.add("Option...");
        this.menuFile.add("Info...");
        this.menuFile.addSeparator();
        this.menuFile.add("Exit");
        this.menuFile.addActionListener(this);
        this.mainMenuBar.add(this.menuFile);
        this.menuHelp = new Menu("Help");
        this.menuHelp.add("About");
        this.menuHelp.addActionListener(this);
        this.mainMenuBar.add(this.menuHelp);
        this.mainMenuBar.setHelpMenu(this.menuHelp);
        this.setMenuBar(this.mainMenuBar);
        this.requestFocus();
        this.setIconImage(f.applet.getFrameIconImage());
    }

    public ZFileViewer(DeepEditFrame f, String filename) {
        this(f);
        if (!filename.equals(" ")) {
            this.openFile(filename);
        }
    }

    public static void about() {
        System.out.println("\n ZFileViewer [<filename>]");
        System.exit(1);
    }
}

