/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEditFrame;
import de.core.ZAnswerDialog;
import de.utils.StringUtil;
import java.awt.AWTError;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;

public class ZFileEditor
extends Frame
implements ActionListener,
WindowListener,
KeyListener {
    DeepEditFrame frame;
    static String appName = "ZFileEditor";
    static String newFilename = "Untitled";
    String curFilename = newFilename;
    String clipboard = "";
    boolean modified = false;
    TextArea ta;
    MenuBar mainMenuBar;
    Menu menuFile;
    Menu menuEdit;
    Menu menuHelp;

    public void SelectAll_Action() {
        this.ta.requestFocus();
        this.ta.select(0, this.ta.getText().length() - 1);
    }

    public void Paste_Action() {
        if (this.clipboard.length() > 0) {
            this.ta.insert(this.clipboard, this.ta.getSelectionStart());
            this.modified = true;
        }
    }

    public void Copy_Action() {
        this.clipboard = this.ta.getSelectedText();
    }

    public void Cut_Action() {
        this.clipboard = this.ta.getSelectedText();
        if (this.clipboard.length() > 0) {
            this.ta.replaceRange("", this.ta.getSelectionStart(), this.ta.getSelectionEnd());
            this.modified = true;
        }
    }

    public void Uppercase_Action() {
        String s = this.ta.getSelectedText().toUpperCase();
        this.ta.replaceRange(s, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.modified = true;
    }

    public void Lowercase_Action() {
        String s = this.ta.getSelectedText().toLowerCase();
        this.ta.replaceRange(s, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.modified = true;
    }

    public void Save_Action() {
        if (!this.curFilename.equals(newFilename)) {
            this.saveFile(this.curFilename);
        } else {
            this.SaveAs_Action();
        }
    }

    public void SaveAs_Action() {
        try {
            FileDialog fd = new FileDialog((Frame)this, "Save File As...", 1);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.saveFile(fd.getFile());
            }
        }
        catch (AWTError e) {
            this.showCatchError(e);
        }
    }

    public void New_Action() {
        this.checkModified();
        this.ta.setText("");
        this.curFilename = newFilename;
        this.showTitle();
    }

    public void Open_Action() {
        try {
            FileDialog fd = new FileDialog((Frame)this, "Open a File", 0);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                this.openFile(fd.getFile());
            }
        }
        catch (AWTError e) {
            this.showCatchError(e);
        }
    }

    public void Info_Action() {
        StringTokenizer t = new StringTokenizer(this.ta.getText(), "\n");
        int numLines = t.countTokens();
        int numCols = 0;
        for (int i = 0; i < numLines; ++i) {
            String curLine = t.nextToken();
            if (numCols >= curLine.length()) continue;
            numCols = curLine.length();
        }
        ZAnswerDialog infoDialog = new ZAnswerDialog((Frame)this, "File Info", "Total number of characters: " + this.ta.getText().length() + "\nTotal number of lines: " + numLines + "\nMax number of columns: " + numCols, "Ok");
        while (infoDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        infoDialog.dispose();
    }

    public void About_Action() {
        ZAnswerDialog aboutDialog = new ZAnswerDialog(this, "About", "JavaZine's ZFileEditor\n \n(c) 1997, Andre Pinheiro", "Ok", 1);
        while (aboutDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        aboutDialog.dispose();
    }

    public void Exit_Action() {
        this.quit(0);
    }

    public void openFile(String filename) {
        if (!new File(filename).isFile()) {
            this.showErrorBox("File not found.");
            return;
        }
        this.checkModified();
        try {
            StringUtil.printFileToTextArea(filename, this.ta);
            this.curFilename = filename;
            this.modified = false;
            this.showTitle();
        }
        catch (FileNotFoundException e) {
            this.showCatchError(e);
        }
        catch (IOException e) {
            this.showCatchError(e);
        }
        this.showTitle();
    }

    public void saveFile(String filename) {
        try {
            StringUtil.printTextAreaToFile(filename, this.ta);
            this.curFilename = filename;
            this.modified = false;
            this.showTitle();
        }
        catch (IOException e) {
            this.showCatchError(e);
        }
    }

    public void showCatchError(Throwable e) {
        this.showErrorBox(e.toString());
    }

    public void checkModified() {
        if (this.modified) {
            ZAnswerDialog modifiedDialog = new ZAnswerDialog(this, "File Modified", "File has changed, do you wish to save it?", "Yes,No", 1);
            while (modifiedDialog.getAnswerId() == ZAnswerDialog.NONE) {
            }
            if (modifiedDialog.getAnswer().equalsIgnoreCase("Yes")) {
                this.Save_Action();
            }
            modifiedDialog.dispose();
            this.modified = false;
        }
    }

    public void showErrorBox(String msg) {
        ZAnswerDialog errorDialog = new ZAnswerDialog((Frame)this, "Error", msg, "Ok");
        while (errorDialog.getAnswerId() == ZAnswerDialog.NONE) {
        }
        errorDialog.dispose();
    }

    public void showTitle() {
        String filename = !this.curFilename.equals(newFilename) ? new File(this.curFilename).getName() : newFilename;
        if (this.modified) {
            this.setTitle(appName + " - " + filename + " (Modified)");
        } else {
            this.setTitle(appName + " - " + filename);
        }
    }

    public void quit(int i) {
        this.checkModified();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String label = event.getActionCommand();
        if (label.equalsIgnoreCase("Cut")) {
            this.Cut_Action();
        } else if (label.equalsIgnoreCase("Copy")) {
            this.Copy_Action();
        } else if (label.equalsIgnoreCase("Paste")) {
            this.Paste_Action();
        } else if (label.equalsIgnoreCase("Uppercase")) {
            this.Uppercase_Action();
        } else if (label.equalsIgnoreCase("Lowercase")) {
            this.Lowercase_Action();
        } else if (label.equalsIgnoreCase("Select All")) {
            this.SelectAll_Action();
        } else if (label.equalsIgnoreCase("Save")) {
            this.Save_Action();
        } else if (label.equalsIgnoreCase("Open...")) {
            this.Open_Action();
        } else if (label.equalsIgnoreCase("Save As...")) {
            this.SaveAs_Action();
        } else if (label.equalsIgnoreCase("Info...")) {
            this.Info_Action();
        } else if (label.equalsIgnoreCase("New")) {
            this.New_Action();
        } else if (label.equalsIgnoreCase("Exit")) {
            this.Exit_Action();
        } else if (label.equalsIgnoreCase("About")) {
            this.About_Action();
        }
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.quit(0);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getComponent() == this.ta) {
            switch (event.getKeyCode()) {
                case 127: {
                    this.modified = true;
                    this.showTitle();
                    break;
                }
                case 155: {
                    if ((event.getModifiers() & 1) == 0) break;
                    this.modified = true;
                    this.showTitle();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event.getComponent() == this.ta) {
            this.modified = true;
            this.showTitle();
        }
    }

    public ZFileEditor(DeepEditFrame f) {
        this.frame = f;
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.addWindowListener(this);
        this.addNotify();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ZFileEditor.this.setVisible(false);
                ZFileEditor.this.dispose();
                ZFileEditor.this.frame.MyZFileEditor = null;
            }
        });
        this.setSize(this.getInsets().left + this.getInsets().right + 400, this.getInsets().top + this.getInsets().bottom + 300);
        this.ta = new TextArea();
        this.ta.setBounds(this.getInsets().left + 0, this.getInsets().top + 0, 400, 300);
        this.ta.addKeyListener(this);
        this.add(this.ta);
        this.showTitle();
        this.mainMenuBar = new MenuBar();
        this.menuFile = new Menu("File");
        this.menuFile.add("New");
        this.menuFile.add("Open...");
        this.menuFile.add("Save");
        this.menuFile.add("Save As...");
        this.menuFile.addSeparator();
        this.menuFile.add("Info...");
        this.menuFile.addSeparator();
        this.menuFile.add("Exit");
        this.menuFile.addActionListener(this);
        this.mainMenuBar.add(this.menuFile);
        this.menuEdit = new Menu("Edit");
        this.menuEdit.add("Cut");
        this.menuEdit.add("Copy");
        this.menuEdit.add("Paste");
        this.menuEdit.addSeparator();
        this.menuEdit.add("Uppercase");
        this.menuEdit.add("Lowercase");
        this.menuEdit.addSeparator();
        this.menuEdit.add("Select All");
        this.menuEdit.addActionListener(this);
        this.mainMenuBar.add(this.menuEdit);
        this.menuHelp = new Menu("Help");
        this.mainMenuBar.setHelpMenu(this.menuHelp);
        this.menuHelp.add("About");
        this.menuHelp.addActionListener(this);
        this.mainMenuBar.add(this.menuHelp);
        this.requestFocus();
        this.setMenuBar(this.mainMenuBar);
    }

    public ZFileEditor(DeepEditFrame f, String filename) {
        this(f);
        this.openFile(filename);
    }

    @Override
    public synchronized void show() {
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    public static void about() {
        System.out.println("\n ZFileEditor [<filename>]");
    }
}

