/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;

public class YearlyToolStatisticalBarChart
extends ApplicationFrame
implements WindowListener {
    String[] busname;
    double[] meanvolt;
    double[] desvvolt;

    public YearlyToolStatisticalBarChart(String title, String[] bbusname, double[] mmeanvolt, double[] ddesvvolt) {
        super("YearlyTool Load Flows Voltage Statistics");
        this.busname = bbusname;
        this.meanvolt = mmeanvolt;
        this.desvvolt = ddesvvolt;
        StatisticalCategoryDataset dataset = this.createDataset(this.busname, this.meanvolt, this.desvvolt);
        CategoryAxis xAxis = new CategoryAxis("Barras");
        xAxis.setLowerMargin(0.05);
        xAxis.setUpperMargin(0.05);
        xAxis.setCategoryMargin(0.01);
        NumberAxis yAxis = new NumberAxis("Voltaje [pu]");
        yAxis.setLowerBound(this.getMinAxis(this.meanvolt, this.desvvolt));
        yAxis.setUpperBound(this.getMaxAxis(this.meanvolt, this.desvvolt));
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private StatisticalCategoryDataset createDataset(String[] name, double[] mean, double[] desv) {
        DefaultStatisticalCategoryDataset result = new DefaultStatisticalCategoryDataset();
        for (int u = 0; u < mean.length; ++u) {
            result.add(mean[u], desv[u], (Comparable)((Object)name[u]), (Comparable)((Object)"Type 1"));
        }
        return result;
    }

    double getMinAxis(double[] me, double[] de) {
        int u;
        int tam = me.length;
        double min = 999.0;
        double[] aux = new double[tam];
        for (u = 0; u < me.length; ++u) {
            aux[u] = me[u] - de[u];
        }
        for (u = 0; u < me.length; ++u) {
            if (!(min > aux[u])) continue;
            min = aux[u];
        }
        double axismin = min - 0.05;
        return axismin;
    }

    double getMaxAxis(double[] me, double[] de) {
        int u;
        int tam = me.length;
        double max = 0.0;
        double[] aux = new double[tam];
        for (u = 0; u < me.length; ++u) {
            aux[u] = me[u] + de[u];
        }
        for (u = 0; u < me.length; ++u) {
            if (!(max < aux[u])) continue;
            max = aux[u];
        }
        double axismax = max + 0.05;
        return axismax;
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (event.getWindow() == this) {
            this.dispose();
        }
    }
}

