/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class YearlyToolOverlaidXYPlot
extends ApplicationFrame
implements WindowListener {
    String titulo;
    double[][] puntos;
    double media;
    double desv;
    double fmax = 0.0;
    private Image DEimageIcon;

    public YearlyToolOverlaidXYPlot(String ttitulo, double[][] ppuntos, double mmedia, double ddesv, double ffmax) {
        super("YearlyTool DC Load Flows");
        this.titulo = ttitulo;
        this.puntos = ppuntos;
        this.media = mmedia;
        this.desv = ddesv;
        this.fmax = ffmax;
        JFreeChart chart = this.createOverlaidChart(true);
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)panel);
        this.DEimageIcon = this.getDeepEditIconImage();
        if (this.DEimageIcon != null) {
            this.setIconImage(this.DEimageIcon);
        }
    }

    public YearlyToolOverlaidXYPlot(String ttitulo, double[][] ppuntos, double mmedia, double ddesv, double ffmax, double[] detFlows) {
        super("YearlyTool DC Load Flows");
        this.titulo = ttitulo;
        this.puntos = ppuntos;
        this.media = mmedia;
        this.desv = ddesv;
        this.fmax = ffmax;
        JFreeChart chart = this.createOverlaidChart(false);
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)panel);
        this.DEimageIcon = this.getDeepEditIconImage();
        if (this.DEimageIcon != null) {
            this.setIconImage(this.DEimageIcon);
        }
    }

    private JFreeChart createOverlaidChart(boolean is) {
        StandardXYItemRenderer renderer6;
        StandardXYItemRenderer renderer5;
        StandardXYItemRenderer renderer4;
        StandardXYItemRenderer renderer3;
        StandardXYItemRenderer renderer2;
        XYSeries serie1 = new XYSeries((Comparable)((Object)"Flow Distribution"));
        if (this.puntos[0][1] > 0.0 && this.puntos[3][1] > 0.0 || this.puntos[0][1] < 0.0 && this.puntos[3][1] < 0.0) {
            serie1.add(this.puntos[0][0] + 1.0E-7, this.puntos[0][1] + 1.0E-6);
            serie1.add(this.puntos[3][0] + 1.0E-6, this.puntos[3][1] + 1.0E-6);
        } else if (this.puntos[0][1] > 0.0 && this.puntos[3][1] < 0.0) {
            serie1.add(0.0, 0.0);
            serie1.add(this.puntos[0][0] + 1.0E-7, this.puntos[0][1] + 1.0E-7);
            serie1.add(this.puntos[1][0] + 1.0E-6, this.puntos[1][1] + 1.0E-6);
            serie1.add(this.puntos[2][0] + 1.0E-5, this.puntos[2][1] + 1.0E-5);
            serie1.add(this.puntos[3][0] + 1.0E-4, this.puntos[3][1] + 1.0E-4);
            serie1.add(this.puntos[3][0] + 0.001, 0.001);
        }
        XYSeriesCollection dataset1 = new XYSeriesCollection(serie1);
        XYAreaRenderer renderer1 = new XYAreaRenderer();
        NumberAxis domainAxis = new NumberAxis("Time[%]");
        NumberAxis rangeAxis = new NumberAxis("Active Power[MW]");
        XYPlot plot = new XYPlot((XYDataset)dataset1, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer1);
        XYSeries serie2 = new XYSeries((Comparable)((Object)"Average Flow"));
        serie2.add(this.puntos[0][0], this.media);
        serie2.add(this.puntos[3][0], this.media);
        XYSeries serie3 = new XYSeries((Comparable)((Object)"Average Flow + Deviation"));
        serie3.add(this.puntos[0][0], this.media + this.desv);
        serie3.add(this.puntos[3][0], this.media + this.desv);
        XYSeries serie4 = new XYSeries((Comparable)((Object)"Average Flow - Deviation"));
        serie4.add(this.puntos[0][0], this.media - this.desv);
        serie4.add(this.puntos[3][0], this.media - this.desv);
        XYSeries serie5 = new XYSeries((Comparable)((Object)"Capacity +"));
        serie5.add(this.puntos[0][0], this.fmax);
        serie5.add(this.puntos[3][0], this.fmax);
        XYSeries serie6 = new XYSeries((Comparable)((Object)"Capacity -"));
        serie6.add(this.puntos[0][0], -this.fmax);
        serie6.add(this.puntos[3][0], -this.fmax);
        XYSeriesCollection dataset2 = new XYSeriesCollection(serie2);
        XYSeriesCollection dataset3 = new XYSeriesCollection(serie3);
        XYSeriesCollection dataset4 = new XYSeriesCollection(serie4);
        XYSeriesCollection dataset5 = new XYSeriesCollection(serie5);
        XYSeriesCollection dataset6 = new XYSeriesCollection(serie6);
        StandardXYItemRenderer r2 = renderer2 = new StandardXYItemRenderer();
        r2.setBasePaint((Paint)Color.blue);
        renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setDataset(1, (XYDataset)dataset2);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        StandardXYItemRenderer r3 = renderer3 = new StandardXYItemRenderer();
        r3.setBasePaint((Paint)Color.gray);
        renderer3.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setDataset(1, (XYDataset)dataset3);
        plot.setRenderer(1, (XYItemRenderer)renderer3);
        StandardXYItemRenderer r4 = renderer4 = new StandardXYItemRenderer();
        r4.setBasePaint((Paint)Color.gray);
        renderer4.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setDataset(1, (XYDataset)dataset4);
        plot.setRenderer(1, (XYItemRenderer)renderer4);
        StandardXYItemRenderer r5 = renderer5 = new StandardXYItemRenderer();
        r5.setBasePaint((Paint)Color.green);
        renderer5.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setDataset(1, (XYDataset)dataset5);
        plot.setRenderer(1, (XYItemRenderer)renderer5);
        StandardXYItemRenderer r6 = renderer6 = new StandardXYItemRenderer();
        r6.setBasePaint((Paint)Color.green);
        plot.setDataset(1, (XYDataset)dataset6);
        plot.setRenderer(1, (XYItemRenderer)renderer6);
        return new JFreeChart(this.titulo, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (event.getWindow() == this) {
            this.dispose();
        }
    }

    private Image getDeepEditIconImage() {
        Image tmpImg;
        try {
            URL imageURL = this.getClass().getResource("/images/DEfavicon.png");
            tmpImg = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpImg;
    }
}

