/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Label;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class YearlyStatTieFrame
extends JFrame
implements WindowListener {
    private Image DEimageIcon;

    public YearlyStatTieFrame(String titulo, double[][] puntos, double media, double desv, Vector<Double> detFlows) {
        super("Yearly DCLF Statistics Graphics Options");
        double[] dFlows = null;
        if (detFlows != null) {
            dFlows = new double[detFlows.size()];
            for (int i = 0; i < detFlows.size(); ++i) {
                dFlows[i] = detFlows.get(i);
            }
        }
        JFreeChart myChart = YearlyStatTieFrame.getOverlayChart(titulo, puntos, media, desv, dFlows);
        ChartPanel chartPanel = new ChartPanel(myChart);
        JPanel TextPanel = new JPanel();
        TextPanel.add(new Label(" Mean = " + Math.rint(media * 100.0) / 100.0 + " [MW]"));
        TextPanel.add(new Label(" std  = " + Math.rint(desv * 100.0) / 100.0 + " [MW]"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", (Component)chartPanel);
        this.getContentPane().add("South", TextPanel);
        this.pack();
        this.DEimageIcon = this.getDeepEditIconImage();
        if (this.DEimageIcon != null) {
            this.setIconImage(this.DEimageIcon);
        }
        this.setVisible(true);
    }

    public static JFreeChart getOverlayChart(String titulo, double[][] puntos, double media, double desv, double[] detFlows) {
        double[][] dNewY;
        double[][] dNewX;
        block3: {
            block1: {
                block2: {
                    if (detFlows != null) break block1;
                    dNewX = new double[1][6];
                    dNewY = new double[1][6];
                    if (!(puntos[0][1] > 0.0 && puntos[3][1] > 0.0) && (!(puntos[0][1] < 0.0) || !(puntos[3][1] < 0.0))) break block2;
                    dNewX[0][0] = 0.0;
                    dNewY[0][0] = 0.0;
                    dNewX[0][1] = puntos[0][0] + 1.0E-7;
                    dNewY[0][1] = puntos[0][1] + 1.0E-6;
                    dNewX[0][2] = puntos[3][0] + 1.0E-6;
                    dNewY[0][2] = puntos[3][1] + 1.0E-6;
                    dNewX[0][3] = puntos[3][0] + 1.0E-5;
                    dNewY[0][3] = 1.0E-7;
                    break block3;
                }
                if (!(puntos[0][1] > 0.0) || !(puntos[3][1] < 0.0)) break block3;
                dNewX[0][0] = 0.0;
                dNewY[0][0] = 0.0;
                dNewX[0][1] = puntos[0][0] + 1.0E-7;
                dNewY[0][1] = puntos[0][1] + 1.0E-7;
                dNewX[0][2] = puntos[1][0] + 1.0E-6;
                dNewY[0][2] = puntos[1][1] + 1.0E-6;
                dNewX[0][3] = puntos[2][0] + 1.0E-5;
                dNewY[0][3] = puntos[2][1] + 1.0E-5;
                dNewX[0][4] = puntos[3][0] + 1.0E-4;
                dNewY[0][4] = puntos[3][1] + 1.0E-4;
                dNewX[0][5] = puntos[3][0] + 0.001;
                dNewY[0][5] = 0.001;
                break block3;
            }
            dNewX = new double[1][detFlows.length];
            dNewY = new double[1][detFlows.length];
            double aux = 1.0 / (double)(detFlows.length - 1) * 100.0;
            for (int i = 0; i < detFlows.length; ++i) {
                dNewX[0][i] = aux * (double)i;
                dNewY[0][i] = detFlows[i];
            }
        }
        String[] sLabels = new String[]{"Flows Distribution"};
        return YearlyStatTieFrame.getOverlayChart(titulo, dNewY, dNewX, sLabels, "Flow[MW]", "Time[%]", true);
    }

    public static JFreeChart getOverlayChart(String sTitle, double[][] dYValues, double[][] dXValues, String[] seriesLabels, String yLabel, String xLabel, boolean bDisplayStats) {
        return YearlyStatTieFrame.getOverlayChart(sTitle, dYValues, dXValues, seriesLabels, null, "Flow[MW]", "Time[%]", bDisplayStats);
    }

    public static JFreeChart getOverlayChart(String sTitle, Point2D[][] seriesValues, String[] seriesLabels, Color[] seriesColors, String yLabel, String xLabel, boolean bDisplayStats) {
        double[][] dYValues = new double[seriesValues.length][];
        double[][] dXValues = new double[seriesValues.length][];
        for (int i = 0; i < seriesValues.length; ++i) {
            dYValues[i] = new double[seriesValues[i].length];
            dXValues[i] = new double[seriesValues[i].length];
            for (int k = 0; k < seriesValues[i].length; ++k) {
                dYValues[i][k] = seriesValues[i][k].getY();
                dXValues[i][k] = seriesValues[i][k].getX();
            }
        }
        return YearlyStatTieFrame.getOverlayChart(sTitle, dYValues, dXValues, seriesLabels, seriesColors, yLabel, xLabel, bDisplayStats);
    }

    public static JFreeChart getOverlayChart(String sTitle, double[][] dYValues, double[][] dXValues, String[] seriesLabels, Color[] seriesColors, String yLabel, String xLabel, boolean bDisplayStats) {
        int nSeries = dYValues.length;
        double dMaxX = 0.0;
        double dMinX = 0.0;
        assert (seriesLabels.length >= nSeries) : "You are missing labels for some of your series!! All labels must have a name";
        if (seriesColors != null) assert (seriesColors.length >= nSeries) : "You are missing Color definition for some of your series!! All series must have a Color!";
        XYPlot plot = new XYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        XYSeries[] mySeries = new XYSeries[nSeries];
        XYSeriesCollection datasetArea = new XYSeriesCollection();
        XYSeriesCollection datasetLine = new XYSeriesCollection();
        for (int s = 0; s < nSeries; ++s) {
            int nYdata = dYValues[s].length;
            if (dXValues[s] == null) {
                dXValues[s] = new double[nYdata];
                for (int i = 0; i < nYdata; ++i) {
                    dXValues[s][i] = Utils.safeDivision((double)i * 100.0, nYdata);
                }
            }
            assert (dYValues[s].length == dXValues[s].length) : "Series '" + s + "' has different number of x and y values. Series must have identical lengths!";
            mySeries[s] = new XYSeries((Comparable)((Object)seriesLabels[s]));
            for (int y = 0; y < dYValues[s].length; ++y) {
                mySeries[s].add(dXValues[s][y], dYValues[s][y]);
            }
            datasetArea.addSeries(mySeries[s]);
            dMaxX = Math.max(dMaxX, Utils.getMaximum(dXValues[s]));
            dMinX = Math.min(dMinX, Utils.getMinimum(dXValues[s]));
        }
        NumberAxis domain1 = new NumberAxis(xLabel);
        domain1.setUpperBound(dMaxX);
        NumberAxis range1 = new NumberAxis(yLabel);
        plot.setDomainAxis(0, (ValueAxis)domain1);
        plot.setRangeAxis(0, (ValueAxis)range1);
        StandardXYItemRenderer rendererLine = new StandardXYItemRenderer(3);
        if (bDisplayStats) {
            XYSeries serieMean = new XYSeries((Comparable)((Object)"Mean"));
            XYSeries serieMeanPlus = new XYSeries((Comparable)((Object)"Mean + STD"));
            XYSeries serieMeanMinus = new XYSeries((Comparable)((Object)"Mean - STD"));
            double media = Utils.getAverage(dYValues[0]);
            double desv = Utils.getStandardDeviation(dYValues[0]);
            serieMean.add(dMinX, media);
            serieMean.add(dMaxX, media);
            serieMeanPlus.add(dMinX, media + desv);
            serieMeanPlus.add(dMaxX, media + desv);
            serieMeanMinus.add(dMinX, media - desv);
            serieMeanMinus.add(dMaxX, media - desv);
            datasetLine.addSeries(serieMean);
            datasetLine.addSeries(serieMeanPlus);
            datasetLine.addSeries(serieMeanMinus);
        }
        plot.setDataset(0, (XYDataset)datasetLine);
        plot.setRenderer(0, (XYItemRenderer)rendererLine);
        NumberAxis domain2 = new NumberAxis();
        domain2.setVisible(false);
        NumberAxis range2 = new NumberAxis();
        range2.setVisible(false);
        plot.setDomainAxis(1, (ValueAxis)domain2);
        plot.setRangeAxis(1, (ValueAxis)range2);
        plot.mapDatasetToDomainAxis(0, 0);
        plot.mapDatasetToRangeAxis(0, 0);
        XYAreaRenderer rendererArea = new XYAreaRenderer(4);
        if (seriesColors != null) {
            for (int i = 0; i < nSeries; ++i) {
                rendererArea.setSeriesPaint(i, (Paint)seriesColors[i]);
            }
        }
        plot.setDataset(1, (XYDataset)datasetArea);
        plot.setRenderer(1, (XYItemRenderer)rendererArea);
        plot.mapDatasetToDomainAxis(1, 0);
        plot.mapDatasetToRangeAxis(1, 0);
        return new JFreeChart(sTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    public static void addSeriesToOverlayChart(JFreeChart myChart, Point2D[] dSeriesValues, int nDataset, String seriesLabel, Color seriesColor) {
        XYPlot myplot = myChart.getXYPlot();
        if (nDataset > myplot.getDatasetCount()) {
            return;
        }
        XYSeriesCollection datasetStat = (XYSeriesCollection)myplot.getDataset(nDataset);
        if (datasetStat == null) {
            return;
        }
        assert (datasetStat.getSeriesIndex((Comparable)((Object)seriesLabel)) == -1) : "Why are you adding series '" + nDataset + "' again??";
        XYSeries newSeries = new XYSeries((Comparable)((Object)seriesLabel));
        for (Point2D dSeriesValue : dSeriesValues) {
            newSeries.add(dSeriesValue.getX(), dSeriesValue.getY());
        }
        datasetStat.addSeries(newSeries);
        myplot.setDataset(nDataset, (XYDataset)datasetStat);
        int nLastSeries = datasetStat.getSeriesIndex((Comparable)((Object)seriesLabel));
        if (nLastSeries != -1 && seriesColor != null) {
            XYItemRenderer rendererLine = myplot.getRendererForDataset((XYDataset)datasetStat);
            rendererLine.setSeriesPaint(nLastSeries, (Paint)seriesColor);
            myplot.setRenderer(nDataset, rendererLine);
        }
        myplot.setDataset(nDataset, (XYDataset)datasetStat);
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (event.getWindow() == this) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private Image getDeepEditIconImage() {
        Image tmpImg;
        try {
            URL imageURL = this.getClass().getResource("/images/DEfavicon.png");
            tmpImg = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpImg;
    }
}

