/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.LaunchProgressFrame;
import de.core.Line;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.mdb_iso;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.StringUtil;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.Statement;

public class YearlySimulation
extends AnalysisTool {
    LaunchProgressFrame loadLaunchFrame = null;
    FileOutputStream os;
    FileOutputStream os1;
    FileOutputStream os3;
    String FileName = "./results/YearlySimulation.dat";
    String FileName2 = "./results/YearlySimulation.csv";
    String FileName3 = "./copyDS.bat";
    PrintStream myPrintStream;
    PrintStream myPrintStream2;
    PrintStream myPrintStream3;
    comp TempComponent;
    ndb_branch Tempbran = null;
    mdb_iso TempIso = null;
    Busbar TempBusbar = null;
    String linea;
    String query;
    String CTRLA;
    Statement stmt;
    Statement stmt1;
    ResultSet rs;
    boolean more;
    public String[] MaxDate;
    public String[] MinDate;
    public double[] P12min;
    public double[] P12max;
    public double[] Q12min;
    public double[] Q12max;
    public double[] SumP12;
    public double[] SumQ12;
    public double[] SumPP12;
    public double[] SumQQ12;
    public double[] P21min;
    public double[] P21max;
    public double[] Q21min;
    public double[] Q21max;
    public double[] SumP21;
    public double[] SumQ21;
    public double[] SumPP21;
    public double[] SumQQ21;
    public double[] Umin;
    public double[] Umax;
    public double[] SumU;
    public double[] SumUU;
    public int count = 0;
    public int countnod = 0;
    public int numbran = 0;
    public int numnod = 0;

    public YearlySimulation(Schematic sch, DeepEditFrame DF, String CCTRLA, String LFType) {
        super(sch, DF);
        int fx;
        this.CTRLA = CCTRLA;
        for (fx = 0; fx < this.ActSchematic.Components.size(); ++fx) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx);
            if ((this.TempComponent instanceof Line || this.TempComponent instanceof Trafo) && this.TempComponent.getactive() && this.TempComponent.getinservice()) {
                ++this.numbran;
            }
            if (this.TempComponent instanceof Busbar && this.TempComponent.getactive() && this.TempComponent.getinservice()) {
                ++this.numnod;
            }
            if (!(this.TempComponent instanceof mdb_iso)) continue;
            this.TempIso = (mdb_iso)this.TempComponent;
            this.TempIso.clearVector();
        }
        this.MinDate = new String[this.numbran];
        this.MaxDate = new String[this.numbran];
        this.P12min = new double[this.numbran];
        this.P12min = new double[this.numbran];
        this.P12max = new double[this.numbran];
        this.Q12min = new double[this.numbran];
        this.Q12max = new double[this.numbran];
        this.SumP12 = new double[this.numbran];
        this.SumQ12 = new double[this.numbran];
        this.SumPP12 = new double[this.numbran];
        this.SumQQ12 = new double[this.numbran];
        this.P21min = new double[this.numbran];
        this.P21min = new double[this.numbran];
        this.P21max = new double[this.numbran];
        this.Q21min = new double[this.numbran];
        this.Q21max = new double[this.numbran];
        this.SumP21 = new double[this.numbran];
        this.SumQ21 = new double[this.numbran];
        this.SumPP21 = new double[this.numbran];
        this.SumQQ21 = new double[this.numbran];
        this.Umin = new double[this.numnod];
        this.Umax = new double[this.numnod];
        this.SumU = new double[this.numnod];
        this.SumUU = new double[this.numnod];
        for (fx = 0; fx < this.ActSchematic.Components.size(); ++fx) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            if (this.TempIso != null) {
                this.TempIso.setNetworkElement(this.TempComponent);
                continue;
            }
            this.myPrintStream.println("******** There is no ISO in the Schematic!");
            System.out.println("There is no ISO in the Schematic !!!");
        }
        for (int jj = 0; jj < 12; ++jj) {
            int fx2;
            int i;
            for (i = 0; i < this.numbran; ++i) {
                this.MaxDate[i] = "No assigned";
                this.MinDate[i] = "No assigned";
                this.P12min[i] = 10000.0;
                this.P12max[i] = -10000.0;
                this.Q12min[i] = 10000.0;
                this.Q12max[i] = -10000.0;
                this.SumP12[i] = 0.0;
                this.SumQ12[i] = 0.0;
                this.SumPP12[i] = 0.0;
                this.SumQQ12[i] = 0.0;
                this.P21min[i] = 10000.0;
                this.P21max[i] = -10000.0;
                this.Q21min[i] = 10000.0;
                this.Q21max[i] = -10000.0;
                this.SumP21[i] = 0.0;
                this.SumQ21[i] = 0.0;
                this.SumPP21[i] = 0.0;
                this.SumQQ21[i] = 0.0;
            }
            for (i = 0; i < this.numnod; ++i) {
                this.Umin[i] = 10000.0;
                this.Umax[i] = -10000.0;
                this.SumU[i] = 0.0;
                this.SumUU[i] = 0.0;
            }
            this.ActSchematic.setactdaytype(this.getDayType(jj));
            this.FileName = "./results/" + this.ActSchematic.getactdaytype() + "YearlySimulation.dat";
            this.FileName2 = "./results/" + this.ActSchematic.getactdaytype() + "YearlySimulation.csv";
            try {
                this.os1 = new FileOutputStream(this.FileName2);
                this.myPrintStream2 = new PrintStream(this.os1);
            }
            catch (Exception e) {
                System.out.println("Error in File Yearly Simulation Statistic!" + e);
            }
            this.myPrintStream2.println("Excel File with Yearly Simulation Statistic:");
            try {
                this.os = new FileOutputStream(this.FileName);
                this.myPrintStream = new PrintStream(this.os);
            }
            catch (Exception e) {
                System.out.println("Error in PrintStream initialization! " + e);
            }
            this.loadLaunchFrame = new LaunchProgressFrame("Yearly Sim., Daytype: " + this.ActSchematic.getactdaytype() + " " + jj, 100L);
            this.loadLaunchFrame.show();
            if (this.loadLaunchFrame != null) {
                this.loadLaunchFrame.updateProgress();
            }
            System.out.println("---------- In Yearly Simulation Tool ------------");
            this.myPrintStream.println("==============================================================");
            this.myPrintStream.println("*                                                            *");
            this.myPrintStream.println("*       Documentation of the simulation-tool for the         *");
            this.myPrintStream.println("*               Yearly Simulation Statistics                  *");
            this.myPrintStream.println("*                                                            *");
            this.myPrintStream.println("==============================================================");
            this.myPrintStream.println("");
            this.myPrintStream.println("*   Date: " + this.ActSchematic.actperiod + "-> " + this.ActSchematic.getactdaytype() + " *");
            this.loadLaunchFrame.WindowLabel.setText("Loading System Information: ");
            if (this.loadLaunchFrame != null) {
                this.loadLaunchFrame.updateProgress();
            }
            this.myPrintStream.println("++++++++     getdemand   -->   TLC-Database");
            this.loadLaunchFrame.WindowLabel.setText("Loading Scenario: ");
            if (this.loadLaunchFrame != null) {
                this.loadLaunchFrame.updateProgress();
            }
            try {
                for (int i2 = 0; i2 < 24; ++i2) {
                    for (int j = 0; j < 4; ++j) {
                        this.assigncase(i2, j);
                        DF.updatecomponent();
                        if (this.TempIso != null) {
                            if (this.TempIso.getDailySimulation(this, this.CTRLA, i2, j)) {
                                System.out.println("Result not feasible for hour: " + i2);
                                this.myPrintStream.println("******** Result not feasible for hour: " + i2);
                                return;
                            }
                            System.out.println("**** OK ****  hour: " + i2 + " min: " + j * 15);
                            this.count = 0;
                            this.countnod = 0;
                            for (int fx3 = 0; fx3 < this.ActSchematic.Components.size(); ++fx3) {
                                this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx3);
                                if ((this.TempComponent instanceof Line || this.TempComponent instanceof Trafo) && this.TempComponent.getactive() && this.TempComponent.getinservice()) {
                                    this.Tempbran = (ndb_branch)this.TempComponent;
                                    this.P12min[this.count] = Math.min(this.P12min[this.count], this.Tempbran.getp12());
                                    if (this.P12min[this.count] == this.Tempbran.getp12()) {
                                        this.MinDate[this.count] = "h" + i2 + "m" + j * 15;
                                    }
                                    this.P12max[this.count] = Math.max(this.P12max[this.count], this.Tempbran.getp12());
                                    if (this.P12max[this.count] == this.Tempbran.getp12()) {
                                        this.MaxDate[this.count] = "h" + i2 + "m" + j * 15;
                                    }
                                    this.Q12min[this.count] = Math.min(this.Q12min[this.count], this.Tempbran.getq12());
                                    this.Q12max[this.count] = Math.max(this.Q12max[this.count], this.Tempbran.getq12());
                                    int n = this.count;
                                    this.SumP12[n] = this.SumP12[n] + this.Tempbran.getp12();
                                    int n2 = this.count;
                                    this.SumQ12[n2] = this.SumQ12[n2] + this.Tempbran.getq12();
                                    int n3 = this.count;
                                    this.SumPP12[n3] = this.SumPP12[n3] + this.Tempbran.getp12() * this.Tempbran.getp12();
                                    int n4 = this.count;
                                    this.SumQQ12[n4] = this.SumQQ12[n4] + this.Tempbran.getq12() * this.Tempbran.getq12();
                                    this.P21min[this.count] = Math.min(this.P21min[this.count], this.Tempbran.getp21());
                                    this.P21max[this.count] = Math.max(this.P21max[this.count], this.Tempbran.getp21());
                                    this.Q21min[this.count] = Math.min(this.Q21min[this.count], this.Tempbran.getq21());
                                    this.Q21max[this.count] = Math.max(this.Q21max[this.count], this.Tempbran.getq21());
                                    int n5 = this.count;
                                    this.SumP21[n5] = this.SumP21[n5] + this.Tempbran.getp21();
                                    int n6 = this.count;
                                    this.SumQ21[n6] = this.SumQ21[n6] + this.Tempbran.getq21();
                                    int n7 = this.count;
                                    this.SumPP21[n7] = this.SumPP21[n7] + this.Tempbran.getp21() * this.Tempbran.getp21();
                                    int n8 = this.count++;
                                    this.SumQQ21[n8] = this.SumQQ21[n8] + this.Tempbran.getq21() * this.Tempbran.getq21();
                                }
                                if (!(this.TempComponent instanceof Busbar) || !this.TempComponent.getactive() || !this.TempComponent.getinservice()) continue;
                                this.TempBusbar = (Busbar)this.TempComponent;
                                this.Umin[this.countnod] = Math.min(this.Umin[this.countnod], this.TempBusbar.getun2());
                                this.Umax[this.countnod] = Math.max(this.Umax[this.countnod], this.TempBusbar.getun2());
                                int n = this.countnod;
                                this.SumU[n] = this.SumU[n] + this.TempBusbar.getun2();
                                int n9 = this.countnod++;
                                this.SumUU[n9] = this.SumUU[n9] + this.TempBusbar.getun2() * this.TempBusbar.getun2();
                            }
                        } else {
                            System.out.println("******* There is no ISO in the Schematic !!!");
                        }
                        this.loadLaunchFrame.WindowLabel.setText("Simulate Hour " + i2 + " Minute " + j * 15);
                        if (this.loadLaunchFrame == null) continue;
                        this.loadLaunchFrame.updateProgress();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("<<<<<<<< Error in cycle >>>>>>>>>" + e);
                System.out.println("Error in cycle " + e);
            }
            this.myPrintStream2.println("*   Date: " + this.ActSchematic.actperiod + "-> " + this.ActSchematic.getactdaytype() + " *");
            this.myPrintStream.println("LINES");
            this.myPrintStream2.println("LINES");
            this.count = 0;
            this.linea = StringUtil.printf("Num", 4) + " " + StringUtil.printf("    NAME", 15) + " " + StringUtil.printf("    Ctrla", 15) + " " + StringUtil.printf("    MinDate", 15) + " " + StringUtil.printf("    MaxDate", 15) + " " + StringUtil.printf("    un", 10) + " " + StringUtil.printf("    INI", 15) + " " + StringUtil.printf("    END", 15) + " " + StringUtil.printf("    P12min", 12) + " " + StringUtil.printf("    P12med", 12) + " " + StringUtil.printf("    P12max", 12) + " " + StringUtil.printf("    StdP12", 12) + " " + StringUtil.printf("    SumPP12", 12) + " " + StringUtil.printf("    P21min", 12) + " " + StringUtil.printf("    P21med", 12) + " " + StringUtil.printf("    P21max", 12) + " " + StringUtil.printf("    StdP21", 12) + " " + StringUtil.printf("    SumPP21", 12) + " " + StringUtil.printf("    Q12min", 12) + " " + StringUtil.printf("    Q12med", 12) + " " + StringUtil.printf("    Q12max", 12) + " " + StringUtil.printf("    StdQ12", 12) + " " + StringUtil.printf("    SumQQ12", 12) + " " + StringUtil.printf("    Q21min", 12) + " " + StringUtil.printf("    Q21med", 12) + " " + StringUtil.printf("    Q21max", 12) + " " + StringUtil.printf("    StdQ21", 12) + " " + StringUtil.printf("    SumQQ21", 12);
            this.myPrintStream.println(this.linea);
            this.linea = StringUtil.printf("Num", 4) + "," + StringUtil.printf("    NAME", 15) + "," + StringUtil.printf("    Ctrla", 15) + "," + StringUtil.printf("    MinDate", 15) + "," + StringUtil.printf("    MaxDate", 15) + "," + StringUtil.printf("    un", 10) + "," + StringUtil.printf("    INI", 15) + "," + StringUtil.printf("    END", 15) + "," + StringUtil.printf("    P12min", 12) + "," + StringUtil.printf("    P12med", 12) + "," + StringUtil.printf("    P12max", 12) + "," + StringUtil.printf("    StdP12", 12) + "," + StringUtil.printf("    SumPP12", 12) + "," + StringUtil.printf("    P21min", 12) + "," + StringUtil.printf("    P21med", 12) + "," + StringUtil.printf("    P21max", 12) + "," + StringUtil.printf("    StdP21", 12) + "," + StringUtil.printf("    SumPP21", 12) + "," + StringUtil.printf("    Q12min", 12) + "," + StringUtil.printf("    Q12med", 12) + "," + StringUtil.printf("    Q12max", 12) + "," + StringUtil.printf("    StdQ12", 12) + "," + StringUtil.printf("    SumQQ12", 12) + "," + StringUtil.printf("    Q21min", 12) + "," + StringUtil.printf("    Q21med", 12) + "," + StringUtil.printf("    Q21max", 12) + "," + StringUtil.printf("    StdQ21", 12) + "," + StringUtil.printf("    SumQQ21", 12);
            this.myPrintStream2.println(this.linea);
            for (fx2 = 0; fx2 < this.ActSchematic.Components.size(); ++fx2) {
                this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx2);
                if (this.TempComponent instanceof Line && this.TempComponent.getactive() && this.TempComponent.getinservice()) {
                    this.Tempbran = (ndb_branch)this.TempComponent;
                    this.linea = StringUtil.printf(this.count, 4) + " " + StringUtil.printf(this.Tempbran.getName(), 15) + " " + StringUtil.printf(this.Tempbran.getctrla(), 15) + " " + StringUtil.printf(this.MinDate[this.count], 15) + " " + StringUtil.printf(this.MaxDate[this.count], 15) + " " + StringUtil.printf(this.Tempbran.getun1(), 10, 1) + " " + StringUtil.printf(this.Tempbran.getcon1(), 15) + " " + StringUtil.printf(this.Tempbran.getcon2(), 15) + " " + StringUtil.printf(this.P12min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumP12[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.P12max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumPP12[this.count] / 96.0 - this.SumP12[this.count] / 96.0 * (this.SumP12[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumPP12[this.count], 16, 5) + " " + StringUtil.printf(this.P21min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumP21[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.P21max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumPP21[this.count] / 96.0 - this.SumP21[this.count] / 96.0 * (this.SumP21[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumPP21[this.count], 16, 5) + " " + StringUtil.printf(this.Q12min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQ12[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.Q12max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumQQ12[this.count] / 96.0 - this.SumQ12[this.count] / 96.0 * (this.SumQ12[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQQ12[this.count], 16, 5) + " " + StringUtil.printf(this.Q21min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQ21[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.Q21max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumQQ21[this.count] / 96.0 - this.SumQ21[this.count] / 96.0 * (this.SumQ21[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQQ21[this.count], 16, 5);
                    this.myPrintStream.println(this.linea);
                    this.linea = StringUtil.printf(this.count, 4) + "," + StringUtil.printf(this.Tempbran.getName(), 15) + "," + StringUtil.printf(this.Tempbran.getctrla(), 15) + "," + StringUtil.printf(this.MinDate[this.count], 15) + "," + StringUtil.printf(this.MaxDate[this.count], 15) + "," + StringUtil.printf(this.Tempbran.getun1(), 10, 1) + "," + StringUtil.printf(this.Tempbran.getcon1(), 15) + "," + StringUtil.printf(this.Tempbran.getcon2(), 15) + "," + StringUtil.printf(this.P12min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumP12[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.P12max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumPP12[this.count] / 96.0 - this.SumP12[this.count] / 96.0 * (this.SumP12[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumPP12[this.count], 16, 5) + "," + StringUtil.printf(this.P21min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumP21[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.P21max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumPP21[this.count] / 96.0 - this.SumP21[this.count] / 96.0 * (this.SumP21[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumPP21[this.count], 16, 5) + "," + StringUtil.printf(this.Q12min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQ12[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.Q12max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumQQ12[this.count] / 96.0 - this.SumQ12[this.count] / 96.0 * (this.SumQ12[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQQ12[this.count], 16, 5) + "," + StringUtil.printf(this.Q21min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQ21[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.Q21max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumQQ21[this.count] / 96.0 - this.SumQ21[this.count] / 96.0 * (this.SumQ21[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQQ21[this.count], 16, 5);
                    this.myPrintStream2.println(this.linea);
                }
                if (!(this.TempComponent instanceof Line) && !(this.TempComponent instanceof Trafo) || !this.TempComponent.getactive() || !this.TempComponent.getinservice()) continue;
                ++this.count;
            }
            this.myPrintStream.println("TRANSFORMERS");
            this.myPrintStream2.println("TRANSFORMERS");
            this.count = 0;
            this.linea = StringUtil.printf("Num", 4) + " " + StringUtil.printf("    NAME", 15) + " " + StringUtil.printf("    Ctrla", 15) + " " + StringUtil.printf("    MinDate", 15) + " " + StringUtil.printf("    MaxDate", 15) + " " + StringUtil.printf("    un", 10) + " " + StringUtil.printf("    INI", 15) + " " + StringUtil.printf("    END", 15) + " " + StringUtil.printf("    P12min", 12) + " " + StringUtil.printf("    P12med", 12) + " " + StringUtil.printf("    P12max", 12) + " " + StringUtil.printf("    StdP12", 12) + " " + StringUtil.printf("    SumPP12", 12) + " " + StringUtil.printf("    P21min", 12) + " " + StringUtil.printf("    P21med", 12) + " " + StringUtil.printf("    P21max", 12) + " " + StringUtil.printf("    StdP21", 12) + " " + StringUtil.printf("    SumPP21", 12) + " " + StringUtil.printf("    Q12min", 12) + " " + StringUtil.printf("    Q12med", 12) + " " + StringUtil.printf("    Q12max", 12) + " " + StringUtil.printf("    StdQ12", 12) + " " + StringUtil.printf("    SumQQ12", 12) + " " + StringUtil.printf("    Q21min", 12) + " " + StringUtil.printf("    Q21med", 12) + " " + StringUtil.printf("    Q21max", 12) + " " + StringUtil.printf("    StdQ21", 12) + " " + StringUtil.printf("    SumQQ21", 12);
            this.myPrintStream.println(this.linea);
            this.linea = StringUtil.printf("Num", 4) + "," + StringUtil.printf("    NAME", 15) + "," + StringUtil.printf("    Ctrla", 15) + "," + StringUtil.printf("    MinDate", 15) + "," + StringUtil.printf("    MaxDate", 15) + "," + StringUtil.printf("    un", 10) + " " + StringUtil.printf("    INI", 15) + "," + StringUtil.printf("    END", 15) + "," + StringUtil.printf("    P12min", 12) + "," + StringUtil.printf("    P12med", 12) + "," + StringUtil.printf("    P12max", 12) + "," + StringUtil.printf("    StdP12", 12) + "," + StringUtil.printf("    SumPP12", 12) + "," + StringUtil.printf("    P21min", 12) + "," + StringUtil.printf("    P21med", 12) + "," + StringUtil.printf("    P21max", 12) + "," + StringUtil.printf("    StdP21", 12) + "," + StringUtil.printf("    SumPP21", 12) + "," + StringUtil.printf("    Q12min", 12) + "," + StringUtil.printf("    Q12med", 12) + "," + StringUtil.printf("    Q12max", 12) + "," + StringUtil.printf("    StdQ12", 12) + "," + StringUtil.printf("    SumQQ12", 12) + "," + StringUtil.printf("    Q21min", 12) + "," + StringUtil.printf("    Q21med", 12) + "," + StringUtil.printf("    Q21max", 12) + "," + StringUtil.printf("    StdQ21", 12) + "," + StringUtil.printf("    SumQQ21", 12);
            this.myPrintStream2.println(this.linea);
            for (fx2 = 0; fx2 < this.ActSchematic.Components.size(); ++fx2) {
                this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx2);
                if (this.TempComponent instanceof Trafo && this.TempComponent.getactive() && this.TempComponent.getinservice()) {
                    this.Tempbran = (ndb_branch)this.TempComponent;
                    this.linea = StringUtil.printf(this.count, 4) + " " + StringUtil.printf(this.Tempbran.getName(), 15) + " " + StringUtil.printf(this.Tempbran.getctrla(), 15) + " " + StringUtil.printf(this.MinDate[this.count], 15) + " " + StringUtil.printf(this.MaxDate[this.count], 15) + " " + StringUtil.printf(this.Tempbran.getun1(), 10, 1) + " " + StringUtil.printf(this.Tempbran.getcon1(), 15) + " " + StringUtil.printf(this.Tempbran.getcon2(), 15) + " " + StringUtil.printf(this.P12min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumP12[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.P12max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumPP12[this.count] / 96.0 - this.SumP12[this.count] / 96.0 * (this.SumP12[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumPP12[this.count], 16, 5) + " " + StringUtil.printf(this.P21min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumP21[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.P21max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumPP21[this.count] / 96.0 - this.SumP21[this.count] / 96.0 * (this.SumP21[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumPP21[this.count], 16, 5) + " " + StringUtil.printf(this.Q12min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQ12[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.Q12max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumQQ12[this.count] / 96.0 - this.SumQ12[this.count] / 96.0 * (this.SumQ12[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQQ12[this.count], 16, 5) + " " + StringUtil.printf(this.Q21min[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQ21[this.count] / 96.0 * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.Q21max[this.count] * Schematic.sref, 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumQQ21[this.count] / 96.0 - this.SumQ21[this.count] / 96.0 * (this.SumQ21[this.count] / 96.0)) * Schematic.sref, 16, 5) + " " + StringUtil.printf(this.SumQQ21[this.count], 16, 5);
                    this.myPrintStream.println(this.linea);
                    this.linea = StringUtil.printf(this.count, 4) + "," + StringUtil.printf(this.Tempbran.getName(), 15) + "," + StringUtil.printf(this.Tempbran.getctrla(), 15) + "," + StringUtil.printf(this.MinDate[this.count], 15) + "," + StringUtil.printf(this.MaxDate[this.count], 15) + "," + StringUtil.printf(this.Tempbran.getun1(), 10, 1) + "," + StringUtil.printf(this.Tempbran.getcon1(), 15) + "," + StringUtil.printf(this.Tempbran.getcon2(), 15) + "," + StringUtil.printf(this.P12min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumP12[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.P12max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumPP12[this.count] / 96.0 - this.SumP12[this.count] / 96.0 * (this.SumP12[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumPP12[this.count], 16, 5) + "," + StringUtil.printf(this.P21min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumP21[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.P21max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumPP21[this.count] / 96.0 - this.SumP21[this.count] / 96.0 * (this.SumP21[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumPP21[this.count], 16, 5) + "," + StringUtil.printf(this.Q12min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQ12[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.Q12max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumQQ12[this.count] / 96.0 - this.SumQ12[this.count] / 96.0 * (this.SumQ12[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQQ12[this.count], 16, 5) + "," + StringUtil.printf(this.Q21min[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQ21[this.count] / 96.0 * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.Q21max[this.count] * Schematic.sref, 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumQQ21[this.count] / 96.0 - this.SumQ21[this.count] / 96.0 * (this.SumQ21[this.count] / 96.0)) * Schematic.sref, 16, 5) + "," + StringUtil.printf(this.SumQQ21[this.count], 16, 5);
                    this.myPrintStream2.println(this.linea);
                }
                if (!(this.TempComponent instanceof Line) && !(this.TempComponent instanceof Trafo) || !this.TempComponent.getactive() || !this.TempComponent.getinservice()) continue;
                ++this.count;
            }
            this.count = 0;
            this.linea = StringUtil.printf("   Num", 4) + " " + StringUtil.printf("   NAME", 15) + " " + StringUtil.printf("   Ctrla", 15) + " " + StringUtil.printf("   un", 10) + " " + StringUtil.printf("   Umin", 12) + " " + StringUtil.printf("   Umed", 12) + " " + StringUtil.printf("   Umax", 12) + " " + StringUtil.printf("   StdU", 12) + " " + StringUtil.printf("   SumUU", 12);
            this.myPrintStream.println(this.linea);
            this.linea = StringUtil.printf("   Num", 4) + "," + StringUtil.printf("   NAME", 15) + "," + StringUtil.printf("   Ctrla", 15) + "," + StringUtil.printf("   un", 10) + "," + StringUtil.printf("   Umin", 12) + "," + StringUtil.printf("   Umed", 12) + "," + StringUtil.printf("   Umax", 12) + "," + StringUtil.printf("   StdU", 12) + "," + StringUtil.printf("   SumUU", 12);
            this.myPrintStream2.println(this.linea);
            this.myPrintStream.println("BUSBAR");
            this.myPrintStream2.println("BUSBAR");
            for (fx2 = 0; fx2 < this.ActSchematic.Components.size(); ++fx2) {
                this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx2);
                if (!(this.TempComponent instanceof Busbar) || !this.TempComponent.getactive() || !this.TempComponent.getinservice()) continue;
                this.TempBusbar = (Busbar)this.TempComponent;
                this.linea = StringUtil.printf(this.count, 4) + " " + StringUtil.printf(this.TempBusbar.getName(), 15) + " " + StringUtil.printf(this.TempBusbar.getctrla(), 15) + " " + StringUtil.printf(this.TempBusbar.getun1(), 10, 1) + " " + StringUtil.printf(this.Umin[this.count], 16, 5) + " " + StringUtil.printf(this.SumU[this.count] / 96.0, 16, 5) + " " + StringUtil.printf(this.Umax[this.count], 16, 5) + " " + StringUtil.printf(Math.sqrt(this.SumUU[this.count] / 96.0 - this.SumU[this.count] / 96.0 * (this.SumU[this.count] / 96.0)), 16, 5) + " " + StringUtil.printf(this.SumUU[this.count], 16, 5);
                this.myPrintStream.println(this.linea);
                this.linea = StringUtil.printf(this.count, 4) + "," + StringUtil.printf(this.TempBusbar.getName(), 15) + "," + StringUtil.printf(this.TempBusbar.getctrla(), 15) + "," + StringUtil.printf(this.TempBusbar.getun1(), 10, 1) + "," + StringUtil.printf(this.Umin[this.count], 16, 5) + "," + StringUtil.printf(this.SumU[this.count] / 96.0, 16, 5) + "," + StringUtil.printf(this.Umax[this.count], 16, 5) + "," + StringUtil.printf(Math.sqrt(this.SumUU[this.count] / 96.0 - this.SumU[this.count] / 96.0 * (this.SumU[this.count] / 96.0)), 16, 5) + "," + StringUtil.printf(this.SumUU[this.count], 16, 5);
                this.myPrintStream2.println(this.linea);
                ++this.count;
            }
            this.loadLaunchFrame.WindowLabel.setText("End Simulation");
            if (this.loadLaunchFrame != null) {
                this.loadLaunchFrame.updateProgress();
            }
            this.loadLaunchFrame.dispose();
            this.loadLaunchFrame = null;
            try {
                if (this.os != null) {
                    this.os.close();
                }
                if (this.os1 != null) {
                    this.os1.close();
                }
            }
            catch (Exception e) {
                System.out.println("<<<<<<<< Error in os*.close() >>>>>>>>>" + e);
                System.out.println("Error in os*.close() " + e);
            }
            try {
                if (this.FileName == null) continue;
                this.DoListResults(this.FileName);
                continue;
            }
            catch (Exception e) {
                this.message = e.toString();
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Error in DoListResults", this.message, DlgButtons, 1, 0, 0, 1);
            }
        }
        try {
            DeepEditFrame.conTGD.commit();
            DeepEditFrame.conTGD.close();
            DeepEditFrame.conTLC.commit();
            DeepEditFrame.conTLC.close();
        }
        catch (Exception e) {
            System.out.println("<<<<<<<< Error closing YearlySimulation-Databases  >>>>>>>>>" + e);
        }
    }

    public void assigncase(int hour, int minute) throws Exception {
        int hour2 = hour + 1;
        String shour = null;
        Object shour2 = null;
        Object shour3 = null;
        String smin = null;
        double auxf = 0.0;
        if (minute == 0) {
            smin = "00";
        }
        if (minute == 1) {
            smin = "15";
        }
        if (minute == 2) {
            smin = "30";
        }
        if (minute == 3) {
            smin = "45";
        }
        shour = hour < 10 ? "0" + hour + ":" : hour + ":";
        this.ActSchematic.setacthour(shour + smin);
        this.ActSchematic.LoadTLC(this.ActSchematic.getactdaytype(), shour + smin, "ALL LOADS", this.CTRLA);
        this.ActSchematic.LoadTGD(this.ActSchematic.getactdaytype(), shour + smin, "ALL GENERATORS", this.CTRLA);
    }

    public String getDayType(int tipo) {
        if (tipo == 0) {
            return "Frl_Wk";
        }
        if (tipo == 1) {
            return "Frl_Sa";
        }
        if (tipo == 2) {
            return "Frl_So";
        }
        if (tipo == 3) {
            return "Hrb_Wk";
        }
        if (tipo == 4) {
            return "Hrb_Sa";
        }
        if (tipo == 5) {
            return "Hrb_So";
        }
        if (tipo == 6) {
            return "Som_Wk";
        }
        if (tipo == 7) {
            return "Som_Sa";
        }
        if (tipo == 8) {
            return "Som_So";
        }
        if (tipo == 9) {
            return "Wnt_Wk";
        }
        if (tipo == 10) {
            return "Wnt_Sa";
        }
        if (tipo == 11) {
            return "Wnt_So";
        }
        return "Error";
    }
}

