/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import Acme.JPM.Encoders.GifEncoder;
import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

class YearlyDEMainChartFrame
extends JFrame
implements ActionListener,
Transferable,
ClipboardOwner {
    private DeepEdit myDE;
    private static JDesktopPane deskChartPanel;
    private static int frameCount;
    private static int offX;
    private static int offY;
    private static Integer layer;
    private Image lastClBdImg = null;
    private String lastSelChTitle = null;
    private static JButton b2GifF;
    private static JButton b2ClipB;
    private static Clipboard clip;
    private static JFileChooser chooser;

    YearlyDEMainChartFrame(DeepEdit applet, String wintitle) {
        super(wintitle);
        this.myDE = applet;
        this.setBounds(200, 0, 600, 580);
        deskChartPanel = new JDesktopPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)deskChartPanel, "Center");
        frameCount = 0;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                YearlyDEMainChartFrame.this.setVisible(false);
                YearlyDEMainChartFrame.this.dispose();
                YearlyDEMainChartFrame.this.myDE;
                DeepEditFrame.myMChartFrame = null;
            }
        });
        JToolBar toolBar = new JToolBar();
        b2GifF = new JButton("to Gif File");
        b2GifF.setToolTipText("Convert Selected Chart to a Gif File");
        b2GifF.addActionListener(this);
        b2ClipB = new JButton("to Clipboard");
        b2ClipB.setToolTipText("Copy Selected Chart to Clipboard");
        b2ClipB.addActionListener(this);
        toolBar.add(b2GifF);
        toolBar.add(b2ClipB);
        this.getContentPane().add((Component)toolBar, "North");
        clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.lastClBdImg = null;
        this.lastSelChTitle = "";
        this.setIconImage(applet.getFrameIconImage());
    }

    public void addChart(String inFrameTile, Chart pchart, String infoSt) {
        JInternalFrame currF = new JInternalFrame(inFrameTile, true, true, true, true);
        JPanel infoPanel = null;
        if (infoSt != null) {
            infoPanel = new JPanel();
        }
        currF.getContentPane().setLayout(new BorderLayout());
        currF.getContentPane().add("Center", pchart);
        if (infoPanel != null) {
            JTextArea infoArea = new JTextArea(infoSt);
            infoPanel.setBackground(Color.white);
            infoPanel.add(infoArea);
            infoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            currF.getContentPane().add("South", infoPanel);
        }
        currF.setLocation(offX * (frameCount % 10), offY * (frameCount % 10));
        currF.pack();
        try {
            currF.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        ++frameCount;
        deskChartPanel.add((Component)currF, layer);
        this.checkVisible();
        currF.setVisible(true);
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public static LineChart makeDefLineChart(double[][] data2, String[] seriesLabels, String[] samplesLabels, String[] graphLabels) {
        double floorENum;
        int ix;
        LineChart chart = new LineChart(data2.length, data2[0].length, 10.0);
        double maxV = Double.MIN_VALUE;
        double minV = Double.MAX_VALUE;
        for (ix = 0; ix < data2.length; ++ix) {
            for (int jx = 0; jx < data2[ix].length; ++jx) {
                if (data2[ix][jx] < minV) {
                    minV = data2[ix][jx];
                }
                if (!(data2[ix][jx] > maxV)) continue;
                maxV = data2[ix][jx];
            }
        }
        double sign = minV * maxV;
        if (sign > 0.0) {
            if (maxV > 0.0) {
                minV = 0.0;
                floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
                maxV = Math.ceil(maxV / floorENum) * floorENum;
            } else {
                maxV = 0.0;
                floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
                minV = Math.floor(minV / floorENum) * floorENum;
            }
        } else if (sign < 0.0) {
            floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
            maxV = Math.ceil(maxV / floorENum) * floorENum;
            floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
            minV = Math.floor(minV / floorENum) * floorENum;
        } else if (minV == 0.0) {
            floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
            maxV = Math.ceil(maxV / floorENum) * floorENum;
        } else {
            floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
            minV = Math.floor(minV / floorENum) * floorENum;
        }
        chart.setLowerRange(0, minV);
        chart.setRange(0, maxV);
        chart.setTitle(graphLabels[0]);
        for (ix = 0; ix < data2.length; ++ix) {
            chart.setConnectedLinesOn(ix, true);
            chart.setSeriesLabel(ix, seriesLabels[ix]);
            chart.setSampleValues(ix, data2[ix]);
        }
        chart.setSampleLabels(samplesLabels);
        chart.setLabel("sampleAxisLabel", graphLabels[1]);
        chart.setLabel("rangeAxisLabel", graphLabels[2]);
        chart.setRangeDecimalCount(0, 2);
        chart.setTitleOn(true);
        if (seriesLabels != null && seriesLabels.length > 1) {
            chart.setLegendOn(true);
        }
        chart.setValueLinesOn(true);
        chart.setRangeAdjusterOn(0, true);
        chart.setSampleLabelsOn(true);
        chart.setGridLinesOn(true);
        chart.setSampleScrollerOn(true);
        chart.setAutoLabelSpacingOn(true);
        chart.setPreferredSize(375, 250);
        return chart;
    }

    public static BarChart makeDefBarChart(double[][] data2, String[] seriesLabels, String[] samplesLabels, String[] graphLabels) {
        double floorENum;
        int ix;
        BarChart chart = new BarChart(data2.length, data2[0].length, 0.0, 10.0);
        double maxV = Double.MIN_VALUE;
        double minV = Double.MAX_VALUE;
        for (ix = 0; ix < data2.length; ++ix) {
            for (int jx = 0; jx < data2[ix].length; ++jx) {
                if (data2[ix][jx] < minV) {
                    minV = data2[ix][jx];
                }
                if (!(data2[ix][jx] > maxV)) continue;
                maxV = data2[ix][jx];
            }
        }
        double sign = minV * maxV;
        if (sign > 0.0) {
            if (maxV > 0.0) {
                minV = 0.0;
                floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
                maxV = Math.ceil(maxV / floorENum) * floorENum;
            } else {
                maxV = 0.0;
                floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
                minV = Math.floor(minV / floorENum) * floorENum;
            }
        } else if (sign < 0.0) {
            floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
            maxV = Math.ceil(maxV / floorENum) * floorENum;
            floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
            minV = Math.floor(minV / floorENum) * floorENum;
        } else if (minV == 0.0) {
            floorENum = Math.pow(10.0, Math.floor(Math.log(maxV) / Math.log(10.0)));
            maxV = Math.ceil(maxV / floorENum) * floorENum;
        } else {
            floorENum = Math.pow(10.0, Math.floor(Math.log(-minV) / Math.log(10.0)));
            minV = Math.floor(minV / floorENum) * floorENum;
        }
        chart.setLowerRange(0, minV);
        chart.setRange(0, maxV);
        chart.setTitle(graphLabels[0]);
        if (seriesLabels != null) {
            for (ix = 0; ix < data2.length; ++ix) {
                chart.setSeriesLabel(ix, seriesLabels[ix]);
                chart.setSampleValues(ix, data2[ix]);
            }
        } else {
            for (ix = 0; ix < data2.length; ++ix) {
                chart.setSampleValues(ix, data2[ix]);
            }
        }
        if (samplesLabels != null) {
            chart.setSampleLabels(samplesLabels);
        }
        chart.setLabel("sampleAxisLabel", graphLabels[1]);
        chart.setLabel("rangeAxisLabel", graphLabels[2]);
        chart.setRangeDecimalCount(-1, 2);
        chart.setSampleDecimalCount(-1, 2);
        chart.setTitleOn(true);
        if (seriesLabels != null && seriesLabels.length > 1) {
            chart.setLegendOn(true);
        }
        chart.setValueLinesOn(true);
        chart.setRangeAdjusterOn(0, true);
        chart.setGridLinesOn(true);
        chart.setSampleScrollerOn(true);
        chart.setAutoLabelSpacingOn(true);
        chart.setMultiColorOn(true);
        chart.setLabelAngle("barLabelAngle", 270);
        chart.setBarLabelsOn(true);
        chart.setPreferredSize(375, 250);
        chart.setBackground(new Color(158, 194, 214));
        return chart;
    }

    public static PieChart makeDefPieChart(double[][] data2, String[] seriesLabels, String[] samplesLabels, String[] graphLabels) {
        PieChart chart = new PieChart(data2.length, data2[0].length);
        chart.setTitle(graphLabels[0]);
        for (int ix = 0; ix < data2.length; ++ix) {
            chart.setSeriesLabel(ix, seriesLabels[ix]);
            chart.setSampleValues(ix, data2[ix]);
        }
        chart.setSampleLabels(samplesLabels);
        chart.setLegendPosition(3);
        chart.setLabel("sampleAxisLabel", graphLabels[1]);
        chart.setLabel("rangeAxisLabel", graphLabels[2]);
        chart.setPieLabelsOn(true);
        chart.setValueLabelsOn(-1, true);
        chart.setValueLabelStyle(0);
        chart.setSampleDecimalCount(-1, 2);
        chart.setTitleOn(true);
        if (seriesLabels != null && seriesLabels.length > 1) {
            chart.setLegendOn(true);
        }
        chart.setSelectionStyle(2);
        chart.set3DModeOn(true);
        chart.setSliceSeperatorOn(true);
        chart.setPreferredSize(375, 250);
        chart.setBackground(new Color(230, 236, 223));
        return chart;
    }

    public void doStatTie(YearlyDEMainChartFrame myMChartFrame, String titulo, double[][] puntos, double media, double desv, double fmax) {
        assert (false) : "Don't use this method to create an Overlay chart. It used completely deprecated (deleted) JFreeChart API";
    }

    public static void doExample(DEMainChartFrame myMChartFrame) {
        int ix;
        String[] seriesLabels = new String[]{"30*Log(x+1)", "1+1.5*x", "20/(20-x)"};
        String[] samplesLabels = new String[40];
        String[] graphLabels = new String[]{"Test de Funciones", "x", "Valor\nde F(x)"};
        double[][] data2 = new double[3][40];
        for (ix = 0; ix < 40; ++ix) {
            samplesLabels[ix] = "" + (double)ix * 0.5;
            data2[0][ix] = Math.log((double)ix * 0.5 + 1.0);
            data2[1][ix] = 1.0 + (double)ix * 0.5 / 10.0;
            data2[2][ix] = 20.0 / (20.0 - (double)ix * 0.5);
        }
        myMChartFrame.addChart("Without info", myMChartFrame.makeDefLineChart(data2, seriesLabels, samplesLabels, graphLabels), null);
        myMChartFrame.addChart("Default Line Chart", myMChartFrame.makeDefLineChart(data2, seriesLabels, samplesLabels, graphLabels), "The showing chart is the default Line Chart Pattern\nThis's just for testing purpose\nIf all OK... Smile Once More ;-)");
        myMChartFrame.addChart("Default Bar Chart", myMChartFrame.makeDefBarChart(data2, seriesLabels, samplesLabels, graphLabels), "The showing chart is the default Bar Chart Pattern\nThis's just for testing purpose\nIf all OK... Smile ;-)");
        samplesLabels = new String[8];
        data2 = new double[3][8];
        for (ix = 0; ix < 8; ++ix) {
            samplesLabels[ix] = "F(" + (double)ix * 2.5 + ")";
            data2[0][ix] = Math.log((double)ix * 2.5 + 1.0);
            data2[1][ix] = 1.0 + (double)ix * 2.5 / 10.0;
            data2[2][ix] = 20.0 / (20.0 - (double)ix * 2.5);
        }
        myMChartFrame.addChart("Default Pie Chart", myMChartFrame.makeDefPieChart(data2, seriesLabels, samplesLabels, graphLabels), "The showing chart is the default Pie Chart Pattern\nThis's just for testing purpose\nIf all OK... Smile ;-)");
    }

    public static void doBusbarVolt(YearlyDEMainChartFrame myMChartFrame, double[][] data2, String[] samplesLabels, String barra, int hydro, String[] estad) {
        String[] seriesLabels = new String[]{" "};
        String[] ssamplesLabels = samplesLabels;
        String[] graphLabels = new String[]{"Evoluci\u00f3n de Voltaje en Barra", "Tiempo[bloque]", "Voltaje[pu]"};
        double[][] ddata = data2;
        String mensaje = "Variacion temporal de la tensi\u00f3n en barra " + barra + " " + "en hidrolog\u00eda h" + hydro;
        myMChartFrame.addChart(mensaje, YearlyDEMainChartFrame.makeDefLineChart(ddata, seriesLabels, ssamplesLabels, graphLabels), "Media:" + estad[0] + " " + "pu" + "  " + "Desv:" + estad[1] + "  " + "Max:" + estad[2] + " " + "pu" + "  " + "Min:" + estad[3] + " " + "pu");
    }

    public static void doBusbarVolt(YearlyDEMainChartFrame myMChartFrame, double[][] data2, String[] samplesLabels, int hydro) {
        String[] seriesLabels = new String[]{" "};
        String[] ssamplesLabels = samplesLabels;
        String[] graphLabels = new String[]{"Desviaci\u00f3n porcentual entre tensi\u00f3n final y tensi\u00f3n inicial", "N\u00famero de barras", "Desviaci\u00f3n[%]"};
        double[][] ddata = data2;
        String mensaje = "Desviaci\u00f3n porcentual de tensi\u00f3n en hidrolog\u00eda h" + hydro;
        myMChartFrame.addChart(mensaje, YearlyDEMainChartFrame.makeDefBarChart(ddata, seriesLabels, ssamplesLabels, graphLabels), null);
    }

    public static void doBusbarMeanVolt(YearlyDEMainChartFrame myMChartFrame, double[][] data2, String[] samplesLabels, int hydro) {
        String[] seriesLabels = new String[]{" "};
        String[] ssamplesLabels = samplesLabels;
        String[] graphLabels = new String[]{"Voltaje medio en barras del sistema", "Nombre Barra", "Voltaje[p.u]"};
        double[][] ddata = data2;
        String mensaje = "Voltaje medio en barras del sistema en hidrolog\u00eda h" + hydro;
        myMChartFrame.addChart(mensaje, YearlyDEMainChartFrame.makeDefBarChart(ddata, seriesLabels, ssamplesLabels, graphLabels), null);
    }

    public static void doBusbarMeanVolt(YearlyDEMainChartFrame myMChartFrame, double[][] data2, String[] samplesLabels, String mean, String var, String namebusbar) {
        String[] seriesLabels = new String[]{" "};
        String[] ssamplesLabels = samplesLabels;
        String[] graphLabels = new String[]{"Voltaje medio: " + mean + " " + " " + " " + "Desviaci\u00f3n:" + " " + var, "Hidrolog\u00eda", "Voltaje[p.u]"};
        double[][] ddata = data2;
        String mensaje = "Voltaje medio en barra " + namebusbar;
        myMChartFrame.addChart(mensaje, YearlyDEMainChartFrame.makeDefBarChart(ddata, seriesLabels, ssamplesLabels, graphLabels), null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object actObj = e.getSource();
        if (actObj == b2GifF || actObj == b2ClipB) {
            Chart selChart = YearlyDEMainChartFrame.getSelectedChart(this.lastSelChTitle);
            if (selChart != null) {
                if (actObj == b2GifF) {
                    this.convert2GifF(selChart);
                } else {
                    Cursor currCursor = this.getCursor();
                    this.setCursor(new Cursor(3));
                    this.lastClBdImg = selChart.getImage(selChart.getWidth(), selChart.getHeight());
                    clip.setContents(this, this);
                    this.setCursor(currCursor);
                }
            } else {
                JOptionPane.showMessageDialog(this, "There's no selected Chart", this.getTitle(), 1);
            }
        }
    }

    private static Chart getSelectedChart(String frameName) {
        JInternalFrame[] allIntFrames = deskChartPanel.getAllFrames();
        frameName = "";
        for (int ix = 0; ix < allIntFrames.length; ++ix) {
            if (!allIntFrames[ix].isSelected()) continue;
            frameName = allIntFrames[ix].getTitle();
            Component[] allcomp = allIntFrames[ix].getContentPane().getComponents();
            for (int jx = 0; jx < allcomp.length; ++jx) {
                if (!(allcomp[jx] instanceof Chart)) continue;
                return (Chart)allcomp[jx];
            }
        }
        return null;
    }

    private void convert2GifF(Chart pChart) {
        int returnVal;
        if (chooser == null) {
            chooser = new JFileChooser();
            chooser.setDialogType(1);
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f != null) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String extension = this.getExtension(f);
                        if (extension != null && extension.equalsIgnoreCase("gif")) {
                            return true;
                        }
                    }
                    return false;
                }

                public String getExtension(File f) {
                    String filename;
                    int i;
                    if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                        return filename.substring(i + 1).toLowerCase();
                    }
                    return null;
                }

                @Override
                public String getDescription() {
                    return "GIF Image Files";
                }
            });
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0) {
            Cursor currCursor = this.getCursor();
            this.setCursor(new Cursor(3));
            File file2save = chooser.getSelectedFile();
            String filename = file2save.getName();
            int i = filename.lastIndexOf(46);
            if (i > 0 && i < filename.length() - 1) {
                if (!filename.substring(i + 1).equalsIgnoreCase("gif")) {
                    file2save = new File(file2save.getName() + ".gif");
                }
            } else {
                file2save = new File(file2save.getName() + ".gif");
            }
            if (!file2save.isAbsolute()) {
                file2save = new File(chooser.getCurrentDirectory().getPath() + "\\" + file2save.getName());
            }
            try {
                FileOutputStream out = new FileOutputStream(file2save);
                GifEncoder gif = new GifEncoder(pChart.getImage(pChart.getWidth(), pChart.getHeight()), (OutputStream)out);
                gif.encode();
                out.flush();
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Can't create output file", "Saving Gif File", 0);
            }
            this.setCursor(currCursor);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.stringFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.imageFlavor || flavor == DataFlavor.stringFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (flavor == DataFlavor.stringFlavor) {
            return this.lastSelChTitle;
        }
        if (flavor == DataFlavor.imageFlavor) {
            return this.lastClBdImg;
        }
        return new Object();
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable transfer) {
    }

    static {
        offX = 20;
        offY = 20;
        layer = new Integer(1);
        clip = null;
        chooser = null;
    }
}

