/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DBReadTableFrame;
import de.core.DeepEdit;
import de.core.YearlyDCLFStatistics;
import de.core.YearlyStatTieFrame;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class YearlyDCLFStatisticsVisualFrame
extends JFrame
implements KeyListener,
ActionListener {
    YearlyDCLFStatistics MyStat;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    JComboBox MyComboBranch = null;
    boolean DB = false;
    JCheckBox ch1 = null;
    JCheckBox ch2 = null;
    private DeepEdit myDeepEdit;

    public YearlyDCLFStatisticsVisualFrame(DeepEdit app, YearlyDCLFStatistics ms, boolean DBo) {
        super("Yearly DCLF Statistic Options");
        this.myDeepEdit = app;
        this.MyStat = ms;
        this.setBackground(Color.lightGray);
        this.DB = DBo;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        JPanel pp = new JPanel();
        JPanel P = new JPanel();
        P.setLayout(new BoxLayout(P, 1));
        JLabel titel = new JLabel("CALCULATION OPTIONS");
        titel.setForeground(Color.blue);
        P.add(titel);
        this.ch1 = new JCheckBox("Make detailed charts ", true);
        pp.add(this.ch1);
        this.ch2 = new JCheckBox("Make detailed branch file", false);
        pp.add(this.ch2);
        P.add(pp);
        P.add(new JLabel("Select Branch"));
        this.MyComboBranch = new JComboBox();
        for (int l = 0; l < this.MyStat.numallbran; ++l) {
            this.MyComboBranch.addItem(this.MyStat.NomBra[l]);
        }
        P.add(this.MyComboBranch);
        pp = new JPanel();
        JButton buttonSelectedBranch = new JButton("Selected Branch");
        buttonSelectedBranch.setActionCommand("Selected Branch");
        buttonSelectedBranch.addActionListener(this);
        JButton buttonShowBranch = new JButton("Show Branch");
        buttonShowBranch.setActionCommand("Show Branch");
        buttonShowBranch.addActionListener(this);
        JButton buttonShowTables = new JButton("Show Data");
        buttonShowTables.setActionCommand("Show Data");
        buttonShowTables.addActionListener(this);
        JButton buttonExitBranch = new JButton("Exit");
        buttonExitBranch.setActionCommand("Exit");
        buttonExitBranch.addActionListener(this);
        pp.add(buttonSelectedBranch);
        pp.add(buttonShowBranch);
        P.add(pp);
        pp = new JPanel();
        pp.add(buttonShowTables);
        pp.add(buttonExitBranch);
        P.add(pp);
        this.add(P);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                YearlyDCLFStatisticsVisualFrame.this.setVisible(false);
                YearlyDCLFStatisticsVisualFrame.this.dispose();
                YearlyDCLFStatisticsVisualFrame.this.MyStat.MyYearlyDCLFStatisticsFrame = null;
            }
        });
        this.setIconImage(this.myDeepEdit.getFrameIconImage());
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.MyStat.MyYearlyDCLFStatisticsFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof JButton) {
            comp TempComponent;
            if (label.equals("Selected Branch")) {
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || !TempComponent.isSelected()) continue;
                    this.MyComboBranch.setSelectedItem(TempComponent.getName());
                    return;
                }
            }
            if (label.equals("Show Branch")) {
                int rama = 0;
                int selected = -1;
                String con1 = "na";
                String con2 = "na";
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp) || !(TempComponent instanceof ndb_branch)) continue;
                    if (TempComponent.getName().equals(this.MyComboBranch.getSelectedItem())) {
                        ndb_branch tb = (ndb_branch)TempComponent;
                        selected = rama;
                        con1 = tb.getcon1();
                        con2 = tb.getcon2();
                        break;
                    }
                    ++rama;
                }
                String titulo = "Flows Distribution at Branch " + this.MyComboBranch.getSelectedItem() + "  From  " + con1 + "  to  " + con2 + "";
                double[][] puntos = new double[4][2];
                double media = 0.0;
                double desv = 0.0;
                Vector<Double> detFlows = null;
                if (!this.DB) {
                    puntos[0][0] = 0.0;
                    puntos[0][1] = 100.0 * this.MyStat.maxAllFlujo[rama];
                    puntos[1][0] = this.MyStat.tPAll[rama] / this.MyStat.simDuration[rama] * 100.0;
                    puntos[1][1] = 0.0;
                    puntos[2][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[2][1] = 0.0;
                    puntos[3][0] = (this.MyStat.tPAll[rama] + this.MyStat.tCAll[rama] + this.MyStat.tNAll[rama]) / this.MyStat.simDuration[rama] * 100.0;
                    puntos[3][1] = 100.0 * this.MyStat.minAllFlujo[rama];
                    media = 100.0 * this.MyStat.acumAllFlujo[rama];
                    desv = 100.0 * Math.sqrt(this.MyStat.varAllFlujo[rama]);
                } else {
                    try {
                        Connection conYearlyStat = DeepEdit.OpenCSVasDB("DataBase");
                        Statement s = conYearlyStat.createStatement();
                        String mul = (String)this.MyComboBranch.getSelectedItem();
                        ResultSet r = s.executeQuery("SELECT * FROM YearlyStatBranch.csv  WHERE Rama='" + mul + "'");
                        double sdur = 0.0;
                        r.next();
                        sdur = r.getDouble("Dur(h)");
                        puntos[0][0] = 0.0;
                        puntos[0][1] = r.getDouble("Flujo_Max(MW)");
                        double auxa = r.getDouble("Tiempo_Positivo(h)");
                        puntos[1][0] = auxa / sdur * 100.0;
                        puntos[1][1] = 0.0;
                        double auxc = r.getDouble("Tiempo_Cero(h)");
                        puntos[2][0] = puntos[1][0] + auxc / sdur * 100.0;
                        puntos[2][1] = 0.0;
                        double auxb = r.getDouble("Tiempo_Negativo(h)");
                        puntos[3][0] = 100.0;
                        puntos[3][1] = r.getDouble("Flujo_Min(MW)");
                        media = r.getDouble("Flujo_Medio(MW)");
                        desv = r.getDouble("Desv(MW)");
                        if (this.ch1.isSelected() || this.ch2.isSelected()) {
                            r = s.executeQuery("SELECT Flux FROM YearlyStatBranchPot.csv WHERE Branch='" + mul + "'" + " ORDER BY Flux DESC");
                            detFlows = new Vector<Double>((int)((double)this.MyStat.numactbran * 1.05), 10);
                            while (r.next()) {
                                detFlows.add(r.getDouble(1));
                            }
                            if (this.ch2.isSelected()) {
                                String ss = mul;
                                PrintStream myPrintStream = new PrintStream(new FileOutputStream("./results/BranchDetail.csv"), true);
                                for (int i = 0; i < detFlows.size(); ++i) {
                                    ss = ss + "," + detFlows.elementAt(i);
                                }
                                myPrintStream.println(ss);
                                myPrintStream.close();
                            }
                            if (!this.ch1.isSelected()) {
                                detFlows = null;
                            }
                        }
                        conYearlyStat.commit();
                        conYearlyStat.close();
                    }
                    catch (FileNotFoundException ee) {
                        System.out.println("No se encontro el archivo de resultados: " + ee.getMessage());
                        ee.printStackTrace(System.err);
                    }
                    catch (SQLException ee) {
                        System.out.println("Error en Lectura de Estad\u00edsticas. Detalles: " + ee);
                        ee.printStackTrace(System.err);
                    }
                }
                boolean casoq = false;
                if (Math.abs(puntos[0][0] - puntos[3][0]) < 1.0E-5) {
                    casoq = true;
                }
                if (!casoq) {
                    YearlyStatTieFrame MyYearlyStatTieFrame = new YearlyStatTieFrame(titulo, puntos, media, desv, detFlows);
                    MyYearlyStatTieFrame.setVisible(true);
                }
            }
            if (label.equals("Show Data")) {
                try {
                    DBReadTableFrame showCSV = new DBReadTableFrame("database", "Estad\u00edsticas de Flujo por Ramas", "YearlyStatBranch.csv", 400, 600, "No Importa");
                    DBReadTableFrame showCSV1 = new DBReadTableFrame("database", "Estad\u00edsticas de Generaci\u00f3n", "YearlyStatGen.csv", 400, 600, "No Importa");
                    DBReadTableFrame showCSV2 = new DBReadTableFrame("database", "Estad\u00edsticas de Demanda", "YearlyStatLoad.csv", 400, 600, "No Importa");
                }
                catch (Exception ee) {
                    System.out.println("Error reading statistics: " + ee.toString());
                    ee.printStackTrace(System.err);
                }
            }
            if (label.equals("Exit")) {
                this.setVisible(false);
                this.dispose();
                this.MyStat.MyYearlyDCLFStatisticsVisualFrame = null;
            }
        }
    }
}

