/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DCLF;
import de.core.DEMainChartFrame;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.JavaLF;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TP;
import de.core.TPCNE;
import de.core.Trafo;
import de.core.YearlyDCLFStatisticsFrame;
import de.core.YearlyDCLFStatisticsVisualFrame;
import de.core.YearlyDCLFStatisticsVisualFrameVolt;
import de.core.YearlyDEMainChartFrame;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;

public final class YearlyDCLFStatistics
extends TP {
    static YearlyDEMainChartFrame MyYearlyChartFrame = null;
    static DEMainChartFrame MyDEMainChartFrame = null;
    YearlyDCLFStatisticsFrame MyYearlyDCLFStatisticsFrame = null;
    YearlyDCLFStatisticsVisualFrame MyYearlyDCLFStatisticsVisualFrame = null;
    YearlyDCLFStatisticsVisualFrameVolt MyYearlyDCLFStatisticsVisualFrameVolt = null;
    DeepEdit applet;
    JavaLF MyJavaLF;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numlast = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    FileOutputStream os_yearly = null;
    FileOutputStream os_yearlyDC = null;
    PrintStream salidaCSV1;
    FileOutputStream osCSV1;
    PrintStream salidaCSV2;
    FileOutputStream osCSV2;
    PrintStream salidaCSV3;
    FileOutputStream osCSV3;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pg;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    double[] COSPHI;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int ny1;
    int ny2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    boolean solouno = false;
    int actPeriod;
    int actMonth;
    int slackNode;
    int slackGenerator;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = 0;
    int numallowner = 0;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int nrobl = -1;
    double[] simDuration;
    double[] simDurationVolt;
    double sdur = 0.0;
    double[] acumActFlujo;
    double[] acumAllFlujo;
    int[] AllBranchI;
    int[] AllBranchJ;
    double[] minActFlujo;
    double[] maxActFlujo;
    double[] minAllFlujo;
    double[] maxAllFlujo;
    double[] varActFlujo;
    double[] varAllFlujo;
    double[] medActGen;
    double[] maxActGen;
    double[] minActGen;
    double[] varActGen;
    double[] medAllGen;
    double[] maxAllGen;
    double[] minAllGen;
    double[] varAllGen;
    double[] actGen;
    double[] actVolt;
    double[] genDuration;
    double[] medActLas;
    double[] maxActLas;
    double[] minActLas;
    double[] varActLas1;
    double[] varActLas2;
    double[] medAllLas;
    double[] maxAllLas;
    double[] minAllLas;
    double[] varAllLas;
    double[] varAllLas1;
    double[] varAllLas2;
    double[] actLas;
    double[] reactLas;
    double[][] medActVolt;
    double[][] varActVolt1;
    double[][] varActVolt2;
    double[][] medAllVolt;
    double[][] varAllVolt;
    double[][] varAllVolt1;
    double[][] varAllVolt2;
    double[][] maxActVolt;
    double[][] minActVolt;
    double[][] maxAllVolt;
    double[][] minAllVolt;
    double[] lasDuration;
    boolean somelfacdiv = false;
    int countdcflow = 0;
    int countacflow = 0;
    int[] countacdiv;
    int[] countdcdiv;
    double[][] intervolt;
    boolean converdclfwloss = true;
    boolean converdclfwlossact = true;
    int lhidro = 0;
    int lblock = 0;
    int lmonth = 0;
    int lyear = 0;
    boolean showrep = false;
    boolean one = false;
    int tipoflujo = 99;
    boolean flujoac = false;
    double toleran = 0.01;
    boolean vis = true;
    double[] tPAct;
    double[] tNAct;
    double[] tCAct;
    double[] tMaunoAct;
    double[] tMeunoAct;
    double[] tCeunoAct;
    double[] tPAll;
    double[] tNAll;
    double[] tCAll;
    double[] tMaunoAll;
    double[] tMeunoAll;
    double[] tCeunoAll;
    protected boolean isTPresDB = true;
    protected Connection conTPresDB = null;
    private static String SensiJAVAdat = AnalysisTool.RESULT_FOLDER + File.separator + "YearlyDCLFStatistics.dat";

    YearlyDCLFStatistics(Schematic sch, DeepEdit aapplet, Connection db) {
        super(sch);
        this.applet = aapplet;
        this.sref = this.getSref();
        System.out.println("---------- In YearlyDCLFStatistics ------------");
        if (!this.existTPDB()) {
            return;
        }
        if (this.MyYearlyDCLFStatisticsFrame == null) {
            this.conTPDB = db;
            this.MyYearlyDCLFStatisticsFrame = new YearlyDCLFStatisticsFrame(this, db);
        } else {
            this.MyYearlyDCLFStatisticsFrame.setVisible(true);
        }
    }

    YearlyDCLFStatistics(Schematic sch, boolean VisDB) {
        super(sch);
        this.sref = this.getSref();
        System.out.println("---------- In YearlyDCLFStatistics ------------ 2");
        this.InitAllNetwork();
    }

    YearlyDCLFStatistics(TPCNE myCNE, String CTRLA, boolean rep, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH) {
        super(myCNE.ActSchematic);
        this.conTPDB = myCNE.conTPDB;
        this.sref = this.getSref();
        System.out.println("---------- In CNE_DCLF_Statistics ------------ v2");
        this.isTPresDB = DBrep;
        this.CalculateTPCNE(CTRLA, rep, SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH);
        this.showrep = rep;
    }

    private void CalculateTPCNE(String cctrla, boolean rep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH) {
        long time = System.currentTimeMillis();
        long timeT = System.currentTimeMillis();
        this.ctrla = cctrla;
        String yearlysalDC = "." + File.separator + "database" + File.separator + "YearlyStatBranchPot.csv";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            if (this.isTPresDB) {
                this.conTPresDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                Statement s = this.conTPresDB.createStatement();
                s.executeUpdate("DELETE FROM flow_disp");
                s.executeUpdate("DELETE FROM flow_stat");
                this.conTPresDB.commit();
                this.conTPresDB.close();
            } else {
                this.os_yearlyDC = new FileOutputStream(yearlysalDC);
            }
        }
        catch (Exception ex) {
            System.out.println("Could not write flows results !!!");
            return;
        }
        try {
            int i;
            this.InitAllNetwork();
            System.out.println("Inicializa red en: " + (double)(System.currentTimeMillis() - time) / 1000.0 + " [s]");
            time = System.currentTimeMillis();
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, true);
            System.out.println("Obtiene despachos en: " + (double)(System.currentTimeMillis() - time) / 1000.0 + " [s]");
            time = System.currentTimeMillis();
            this.GetActiveNetwork();
            System.out.println("Carga referencias en: " + (System.currentTimeMillis() - time) / 1000L + " [s]");
            time = System.currentTimeMillis();
            this.countdcdiv = new int[this.HydroNumberDB];
            for (int hi = 0; hi < this.HydroNumberDB; ++hi) {
                this.countdcdiv[hi] = 0;
            }
            for (i = 0; i < this.numactlast; ++i) {
                this.medActLas[i] = 0.0;
                this.maxActLas[i] = -100000.0;
                this.minActLas[i] = 100000.0;
                this.varActLas1[i] = 0.0;
                this.varActLas2[i] = 0.0;
            }
            this.countdcflow = 0;
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            for (int y = this.year1; y <= this.year2; ++y) {
                this.lyear = this.year2 - this.year1;
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : this.MonthNumberDB;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int ii;
                    this.lmonth = limmes2 - limmes1;
                    this.ActSchematic.setactperiod(y);
                    this.ActSchematic.setactmonth(m);
                    this.ActSchematic.Modifiedstate = true;
                    this.ActSchematic.Modified = true;
                    this.ActSchematic.CheckActive();
                    this.GetActiveNetwork();
                    if (this.MyDCLF != null) {
                        this.MyDCLF = null;
                    }
                    this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    this.sdur = 0.0;
                    for (i = 0; i < this.numactbran; ++i) {
                        this.minActFlujo[i] = 1000000.0;
                        this.maxActFlujo[i] = -1000000.0;
                        this.tPAct[i] = 0.0;
                        this.tNAct[i] = 0.0;
                        this.tCAct[i] = 0.0;
                    }
                    for (i = 0; i < this.numactnod; ++i) {
                        this.tMaunoAct[i] = 0.0;
                        this.tMeunoAct[i] = 0.0;
                        this.tCeunoAct[i] = 0.0;
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        this.minActGen[i] = 1000000.0;
                        this.maxActGen[i] = -1000000.0;
                    }
                    for (i = 0; i < this.numactlast; ++i) {
                        this.minActLas[i] = 1000000.0;
                        this.maxActLas[i] = -1000000.0;
                    }
                    for (int b = limblock1; b <= limblock2; ++b) {
                        this.lblock = limblock2 - limblock1;
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        this.lhidro = limhidro2 - limhidro1;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            ++this.countdcflow;
                            this.build_Injection(y, m, b, h);
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo, this);
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.Flujo[i] < this.minActFlujo[i]) {
                                    this.minActFlujo[i] = this.Flujo[i];
                                }
                                if (this.Flujo[i] > this.maxActFlujo[i]) {
                                    this.maxActFlujo[i] = this.Flujo[i];
                                }
                                int n = i;
                                this.acumActFlujo[n] = this.acumActFlujo[n] + this.Flujo[i] * this.blockTime[this.nrobl - 1];
                                int n2 = i;
                                this.varActFlujo[n2] = this.varActFlujo[n2] + this.Flujo[i] * this.Flujo[i] * this.blockTime[this.nrobl - 1];
                            }
                            this.node_pg[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pg[n] = this.node_pg[n] + this.Flujo[i] * this.sref;
                                    continue;
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pg[n] = this.node_pg[n] - this.Flujo[i] * this.sref;
                            }
                            this.node_pg[this.slackNode] = Math.max(0.0, this.node_pg[this.slackNode]);
                            this.actGen[this.slackGenerator] = this.node_pg[this.slackNode];
                            for (i = 0; i < this.numactgen; ++i) {
                                if (this.actGen[i] < this.minActGen[i]) {
                                    this.minActGen[i] = this.actGen[i];
                                }
                                if (this.actGen[i] > this.maxActGen[i]) {
                                    this.maxActGen[i] = this.actGen[i];
                                }
                                int n = i;
                                this.medActGen[n] = this.medActGen[n] + this.actGen[i] * this.blockTime[this.nrobl - 1];
                                int n3 = i;
                                this.varActGen[n3] = this.varActGen[n3] + this.actGen[i] * this.actGen[i] * this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactlast; ++i) {
                                if (this.actLas[i] < this.minActLas[i]) {
                                    this.minActLas[i] = this.actLas[i];
                                }
                                if (this.actLas[i] > this.maxActLas[i]) {
                                    this.maxActLas[i] = this.actLas[i];
                                }
                                int n = i;
                                this.medActLas[n] = this.medActLas[n] + this.actLas[i];
                                int n4 = i;
                                this.varActLas1[n4] = this.varActLas1[n4] + this.actLas[i] * this.actLas[i];
                                int n5 = i;
                                this.varActLas2[n5] = this.varActLas2[n5] + this.actLas[i];
                            }
                            this.sdur += this.blockTime[this.nrobl - 1];
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.Flujo[i] > 1.0E-6) {
                                    int n = i;
                                    this.tPAct[n] = this.tPAct[n] + this.blockTime[this.nrobl - 1];
                                    continue;
                                }
                                if (this.Flujo[i] < -1.0E-6) {
                                    int n = i;
                                    this.tNAct[n] = this.tNAct[n] + this.blockTime[this.nrobl - 1];
                                    continue;
                                }
                                int n = i;
                                this.tCAct[n] = this.tCAct[n] + this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactnod; ++i) {
                                if (this.actVolt[i] >= 1.0) {
                                    int n = i;
                                    this.tMaunoAct[n] = this.tMaunoAct[n] + this.blockTime[this.nrobl - 1];
                                }
                                if (this.actVolt[i] < 1.0) {
                                    int n = i;
                                    this.tMeunoAct[n] = this.tMeunoAct[n] + this.blockTime[this.nrobl - 1];
                                }
                                if (this.actVolt[i] != 0.0) continue;
                                int n = i;
                                this.tCeunoAct[n] = this.tCeunoAct[n] + this.blockTime[this.nrobl - 1];
                            }
                            ++this.nitera;
                        }
                    }
                    System.out.println("y:" + y + " m:" + m + " => flow:" + this.countdcflow + " in " + (double)(System.currentTimeMillis() - timeT) / 1000.0 + " [s]");
                    block22: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii].equals(this.NomBra[i])) continue;
                            if (this.minAllFlujo[i] > this.minActFlujo[ii]) {
                                this.minAllFlujo[i] = this.minActFlujo[ii];
                            }
                            if (this.maxAllFlujo[i] < this.maxActFlujo[ii]) {
                                this.maxAllFlujo[i] = this.maxActFlujo[ii];
                            }
                            int n = i;
                            this.acumAllFlujo[n] = this.acumAllFlujo[n] + this.acumActFlujo[ii];
                            int n6 = i;
                            this.varAllFlujo[n6] = this.varAllFlujo[n6] + this.varActFlujo[ii];
                            int n7 = i;
                            this.simDuration[n7] = this.simDuration[n7] + this.sdur;
                            int n8 = i;
                            this.tPAll[n8] = this.tPAll[n8] + this.tPAct[ii];
                            int n9 = i;
                            this.tNAll[n9] = this.tNAll[n9] + this.tNAct[ii];
                            int n10 = i;
                            this.tCAll[n10] = this.tCAll[n10] + this.tCAct[ii];
                            continue block22;
                        }
                    }
                    block24: for (ii = 0; ii < this.numactgen; ++ii) {
                        for (i = ii; i < this.numallgen; ++i) {
                            if (!this.NomActGen[ii].equals(this.NomGen[i])) continue;
                            if (this.minAllGen[i] > this.minActGen[ii]) {
                                this.minAllGen[i] = this.minActGen[ii];
                            }
                            if (this.maxAllGen[i] < this.maxActGen[ii]) {
                                this.maxAllGen[i] = this.maxActGen[ii];
                            }
                            int n = i;
                            this.medAllGen[n] = this.medAllGen[n] + this.medActGen[ii];
                            int n11 = i;
                            this.varAllGen[n11] = this.varAllGen[n11] + this.varActGen[ii];
                            int n12 = i;
                            this.genDuration[n12] = this.genDuration[n12] + this.sdur;
                            continue block24;
                        }
                    }
                    block26: for (ii = 0; ii < this.numactlast; ++ii) {
                        for (i = ii; i < this.numalllast; ++i) {
                            if (!this.NomActLas[ii].equals(this.NomLas[i])) continue;
                            if (this.minAllLas[i] > this.minActLas[ii]) {
                                this.minAllLas[i] = this.minActLas[ii];
                            }
                            if (this.maxAllLas[i] < this.maxActLas[ii]) {
                                this.maxAllLas[i] = this.maxActLas[ii];
                            }
                            int n = i;
                            this.medAllLas[n] = this.medAllLas[n] + this.medActLas[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n13 = i;
                            this.varAllLas1[n13] = this.varAllLas1[n13] + this.varActLas1[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n14 = i;
                            this.varAllLas2[n14] = this.varAllLas2[n14] + this.varActLas2[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n15 = i;
                            this.lasDuration[n15] = this.lasDuration[n15] + this.sdur;
                            continue block26;
                        }
                    }
                    for (i = 0; i < this.numactbran; ++i) {
                        this.acumActFlujo[i] = 0.0;
                        this.varActFlujo[i] = 0.0;
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        this.medActGen[i] = 0.0;
                        this.varActGen[i] = 0.0;
                    }
                    for (i = 0; i < this.numactlast; ++i) {
                        this.medActLas[i] = 0.0;
                        this.varActLas1[i] = 0.0;
                        this.varActLas2[i] = 0.0;
                    }
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            for (i = 0; i < this.numallbran; ++i) {
                if (this.simDuration[i] > 1.0E-6) {
                    this.acumAllFlujo[i] = this.acumAllFlujo[i] / this.simDuration[i];
                    this.varAllFlujo[i] = this.varAllFlujo[i] / this.simDuration[i] - this.acumAllFlujo[i] * this.acumAllFlujo[i];
                    if (!(this.varAllFlujo[i] < 0.0)) continue;
                    this.varAllFlujo[i] = 0.0;
                    continue;
                }
                this.minAllFlujo[i] = 0.0;
                this.maxAllFlujo[i] = 0.0;
                this.acumAllFlujo[i] = 0.0;
            }
            for (i = 0; i < this.numallgen; ++i) {
                if (this.genDuration[i] > 1.0E-6) {
                    this.medAllGen[i] = this.medAllGen[i] / this.genDuration[i];
                    this.varAllGen[i] = this.varAllGen[i] / this.genDuration[i] - this.medAllGen[i] * this.medAllGen[i];
                    if (!(this.varAllGen[i] < 0.0)) continue;
                    this.varAllGen[i] = 0.0;
                    continue;
                }
                this.minAllGen[i] = 0.0;
                this.maxAllGen[i] = 0.0;
                this.medAllGen[i] = 0.0;
            }
            for (i = 0; i < this.numalllast; ++i) {
                if (this.lasDuration[i] > 1.0E-6) {
                    this.varAllLas[i] = this.varAllLas1[i] - 2.0 * (this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1))) * this.varAllLas2[i] + this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1)) * (this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1))) * (double)((this.lmonth + 1) * (this.lyear + 1));
                    this.medAllLas[i] = this.medAllLas[i] / (double)(this.lmonth + 1);
                    if (!(this.varAllLas[i] < 0.0)) continue;
                    this.varAllLas[i] = 0.0;
                    continue;
                }
                this.minAllLas[i] = 0.0;
                this.maxAllLas[i] = 0.0;
                this.medAllLas[i] = 0.0;
            }
            if (rep) {
                this.os = new FileOutputStream(SensiJAVAdat);
                this.myPPrintStream = new PrintStream(this.os);
                System.out.println("Making Report File");
                System.out.println(" Time = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas Generales");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Selecci\u00f3n de Flujos  :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
                this.myPPrintStream.println(" Flujo Inicial        :" + StringUtil.numformat(this.year1, 8) + "/" + StringUtil.numformat(this.month1, 8) + "/" + StringUtil.numformat(this.block1, 8) + "/" + StringUtil.numformat(this.hidro1, 8) + "/" + StringUtil.numformat(this.flow1, 8));
                this.myPPrintStream.println(" Flujo Final          :" + StringUtil.numformat(this.year2, 8) + "/" + StringUtil.numformat(this.month2, 8) + "/" + StringUtil.numformat(this.block2, 8) + "/" + StringUtil.numformat(this.hidro2, 8) + "/" + StringUtil.numformat(this.flow2, 8));
                this.myPPrintStream.println(" Total Barras         :    " + this.numallnod);
                this.myPPrintStream.println(" Total Ramas          :    " + this.numallbran);
                this.myPPrintStream.println(" Total Generadores    :    " + this.numallgen);
                this.myPPrintStream.println(" Total Cargas         :    " + this.numalllast);
                this.myPPrintStream.println(" Total L\u00edneas         :    " + this.numalllin);
                this.myPPrintStream.println(" Total Transformadores:    " + this.numalltrafo);
                this.myPPrintStream.println(" Total Execution Time :    " + (double)(System.currentTimeMillis() - time) / 1000.0 + " [s]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                System.out.println("Report File Done");
                System.out.println(" ");
                this.closefile();
            }
            if (this.isTPresDB) {
                this.conTPresDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                Statement s = this.conTPresDB.createStatement();
                for (i = 0; i < this.numallbran; ++i) {
                    cctrla = this.AllBranchI[i] == -1 || this.AllBranchJ[i] == -1 ? "INSERT INTO flow_stat VALUES ('" + this.NomBra[i] + "','-1','-1'," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i] + ")" : "INSERT INTO flow_stat VALUES ('" + this.NomBra[i] + "','" + this.NomNod[this.AllBranchI[i]] + "','" + this.NomNod[this.AllBranchJ[i]] + "'," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i] + ")";
                    s.executeUpdate(cctrla);
                }
                this.conTPresDB.commit();
                this.conTPresDB.close();
            } else {
                this.osCSV1 = new FileOutputStream("." + File.separator + "database" + File.separator + "YearlyStatBranch.csv");
                this.salidaCSV1 = new PrintStream(this.osCSV1);
                this.salidaCSV1.println("Rama,Desde,Hasta,Flujo_Medio[MW],Flujo_Max[MW],Flujo_Min[MW],Desv[MW],Dur[h],Tiempo_Positivo[h],Tiempo_Negativo[h],Tiempo_Cero[h]");
                for (i = 0; i < this.numallbran; ++i) {
                    if (this.AllBranchI[i] == -1 || this.AllBranchJ[i] == -1) {
                        this.salidaCSV1.println("" + this.NomBra[i] + ",-1,-1," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i]);
                        continue;
                    }
                    this.salidaCSV1.println("" + this.NomBra[i] + "," + this.NomNod[this.AllBranchI[i]] + "," + this.NomNod[this.AllBranchJ[i]] + "," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i]);
                }
                this.closefileCSV1();
                this.osCSV2 = new FileOutputStream("./database/YearlyStatGen.csv");
                this.salidaCSV2 = new PrintStream(this.osCSV2);
                this.salidaCSV2.println("Generador,Gen_Media[MW],Gen_Max[MW],Gen_Min[MW],Desv[MW]");
                for (i = 0; i < this.numallgen; ++i) {
                    this.salidaCSV2.println("" + this.NomGen[i] + "," + this.medAllGen[i] + "," + this.maxAllGen[i] + "," + this.minAllGen[i] + "," + Math.sqrt(this.varAllGen[i]));
                }
                this.closefileCSV2();
                this.osCSV3 = new FileOutputStream("./database/YearlyStatLoad.csv");
                this.salidaCSV3 = new PrintStream(this.osCSV3);
                this.salidaCSV3.println("Carga,Dem_Media[MW],Dem_Max[MW],Dem_Min[MW],Desv[MW]");
                for (i = 0; i < this.numalllast; ++i) {
                    this.salidaCSV3.println("" + this.NomLas[i] + "," + this.medAllLas[i] + "," + this.maxAllLas[i] + "," + this.minAllLas[i] + "," + Math.sqrt(this.varAllLas[i]));
                }
                this.closefileCSV3();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        System.out.println("TOTAL EXECUTION TIME = " + (double)(System.currentTimeMillis() - timeT) / 1000.0 + " [s]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad " + SensiJAVAdat);
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
    }

    public void Calculate(String cctrla, boolean rep, boolean DBrep, boolean viso, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, int ttipoflujo, boolean fflujoac, double ttoleran) {
        this.isTPresDB = DBrep;
        this.vis = viso;
        long time = System.currentTimeMillis();
        this.ctrla = cctrla;
        String yearlysal = "." + File.separator + "database" + File.separator + "YearlyStatVolt.csv";
        String yearlysalDC = "." + File.separator + "database" + File.separator + "YearlyStatBranchPot.csv";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        this.tipoflujo = ttipoflujo;
        this.flujoac = fflujoac;
        this.toleran = ttoleran;
        try {
            this.os_yearly = new FileOutputStream(yearlysal);
            this.os_yearlyDC = new FileOutputStream(yearlysalDC);
        }
        catch (Exception ex) {
            System.out.println("Could not write in /results .dat");
            return;
        }
        try {
            int hi;
            int hi2;
            int i;
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork();
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork();
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, true);
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
            System.out.println(" ");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            this.medActVolt = new double[this.numallnod][this.HydroNumberDB];
            this.varActVolt1 = new double[this.numallnod][this.HydroNumberDB];
            this.varActVolt2 = new double[this.numallnod][this.HydroNumberDB];
            this.medAllVolt = new double[this.numallnod][this.HydroNumberDB];
            this.varAllVolt = new double[this.numallnod][this.HydroNumberDB];
            this.varAllVolt1 = new double[this.numallnod][this.HydroNumberDB];
            this.varAllVolt2 = new double[this.numallnod][this.HydroNumberDB];
            this.maxActVolt = new double[this.numallnod][this.HydroNumberDB];
            this.minActVolt = new double[this.numallnod][this.HydroNumberDB];
            this.maxAllVolt = new double[this.numallnod][this.HydroNumberDB];
            this.minAllVolt = new double[this.numallnod][this.HydroNumberDB];
            double[][] inivolt = new double[this.numallnod][this.HydroNumberDB];
            double[][] finvolt = new double[this.numallnod][this.HydroNumberDB];
            double[][] porcvarvolt = new double[this.numallnod][this.HydroNumberDB];
            this.intervolt = new double[9][this.HydroNumberDB];
            this.countacdiv = new int[this.HydroNumberDB];
            this.countdcdiv = new int[this.HydroNumberDB];
            for (i = 0; i < this.numactlast; ++i) {
                this.medActLas[i] = 0.0;
                this.maxActLas[i] = -100000.0;
                this.minActLas[i] = 100000.0;
                this.varActLas1[i] = 0.0;
                this.varActLas2[i] = 0.0;
            }
            for (hi2 = 0; hi2 < this.HydroNumberDB; ++hi2) {
                for (i = 0; i < this.numallnod; ++i) {
                    this.medActVolt[i][hi2] = 0.0;
                    this.varActVolt1[i][hi2] = 0.0;
                    this.varActVolt2[i][hi2] = 0.0;
                    this.medAllVolt[i][hi2] = 0.0;
                    this.varAllVolt[i][hi2] = 0.0;
                    this.varAllVolt1[i][hi2] = 0.0;
                    this.varAllVolt2[i][hi2] = 0.0;
                    this.maxActVolt[i][hi2] = -10000.0;
                    this.minActVolt[i][hi2] = 10000.0;
                    this.maxAllVolt[i][hi2] = -10000.0;
                    this.minAllVolt[i][hi2] = 10000.0;
                    inivolt[i][hi2] = 0.0;
                    finvolt[i][hi2] = 0.0;
                    porcvarvolt[i][hi2] = 0.0;
                }
            }
            for (hi2 = 0; hi2 < this.HydroNumberDB; ++hi2) {
                for (i = 0; i < 9; ++i) {
                    this.intervolt[i][hi2] = 0.0;
                }
            }
            this.countdcflow = 0;
            for (int hi3 = 0; hi3 < this.HydroNumberDB; ++hi3) {
                this.countacdiv[hi3] = 0;
                this.countdcdiv[hi3] = 0;
            }
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            for (int y = this.year1; y <= this.year2; ++y) {
                this.lyear = this.year2 - this.year1;
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : this.MonthNumberDB;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int hi4;
                    int ii;
                    this.lmonth = limmes2 - limmes1;
                    this.ActSchematic.setactperiod(y);
                    this.ActSchematic.setactmonth(m);
                    this.ActSchematic.Modifiedstate = true;
                    this.ActSchematic.Modified = true;
                    this.ActSchematic.CheckActive();
                    this.GetActiveNetwork();
                    if (this.MyDCLF != null) {
                        this.MyDCLF = null;
                    }
                    this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    this.sdur = 0.0;
                    for (i = 0; i < this.numactbran; ++i) {
                        this.minActFlujo[i] = 1000000.0;
                        this.maxActFlujo[i] = -1000000.0;
                        this.tPAct[i] = 0.0;
                        this.tNAct[i] = 0.0;
                        this.tCAct[i] = 0.0;
                    }
                    for (i = 0; i < this.numactnod; ++i) {
                        this.tMaunoAct[i] = 0.0;
                        this.tMeunoAct[i] = 0.0;
                        this.tCeunoAct[i] = 0.0;
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        this.minActGen[i] = 1000000.0;
                        this.maxActGen[i] = -1000000.0;
                    }
                    for (i = 0; i < this.numactlast; ++i) {
                        this.minActLas[i] = 1000000.0;
                        this.maxActLas[i] = -1000000.0;
                    }
                    for (int b = limblock1; b <= limblock2; ++b) {
                        this.lblock = limblock2 - limblock1;
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        this.lhidro = limhidro2 - limhidro1;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            if (y == this.year1 && m == this.month1 && this.nitera == 0) {
                                System.out.println("    This is the first seleted flow!");
                                System.out.println("      DCLF variables initialization ... ");
                                this.ActSchematic.setactperiod(y);
                                this.ActSchematic.setactmonth(m);
                                this.ActSchematic.Modifiedstate = true;
                                this.ActSchematic.Modified = true;
                                this.ActSchematic.CheckActive();
                                System.out.println(" ");
                                System.out.println("Making GetActiveNetwork");
                                this.GetActiveNetwork();
                                System.out.println("GetActiveNetwork    Done");
                                System.out.println(" ");
                                if (this.MyDCLF != null) {
                                    this.MyDCLF = null;
                                }
                                this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                            }
                            ++this.countdcflow;
                            this.build_Injection(y, m, b, h);
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            if (this.tipoflujo == 1) {
                                this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo, this);
                            }
                            if (this.tipoflujo == 2) {
                                this.converdclfwlossact = this.MyDCLF.calcular_DCLFwLoss(this.PDCLF, this.Flujo, this);
                                if (!this.converdclfwlossact) {
                                    this.converdclfwloss = false;
                                    System.out.println("Flujo DC con p\u00e9rdida sin convergencia. Se anula el estudio en proceso!!!");
                                }
                            }
                            if (this.solouno) {
                                this.MyDCLF.writeresults();
                            }
                            if (this.flujoac) {
                                if (this.MyJavaLF != null) {
                                    this.MyJavaLF = null;
                                }
                                this.MyJavaLF = new JavaLF(this.applet, this.ActSchematic, this);
                                this.MyJavaLF.setParameters(this.toleran, true, true, false, false, true);
                                try {
                                    int q;
                                    this.MyJavaLF.yearlylf = true;
                                    ++this.countacflow;
                                    System.out.println("Numero de Flujo AC en Proceso: " + this.countacflow);
                                    this.MyJavaLF.Calculate(cctrla, this.actVolt);
                                    if (this.MyJavaLF.conver < 0) {
                                        this.somelfacdiv = true;
                                        System.out.println("Flujo AC sin convergencia. Se anula el estudio en proceso!!!");
                                    }
                                    if (y == this.year1 && m == this.month1 && b == this.block1) {
                                        for (q = 0; q < this.numallnod; ++q) {
                                            inivolt[q][h - 1] = this.actVolt[q];
                                        }
                                    }
                                    if (y == this.year2 && m == this.month2 && b == this.block2 && this.MyJavaLF.conver > 0) {
                                        for (q = 0; q < this.numallnod; ++q) {
                                            finvolt[q][h - 1] = this.actVolt[q];
                                        }
                                    }
                                    if (y == this.year2 && m == this.month2 && b == this.block2 && this.MyJavaLF.conver < 0) {
                                        System.out.println("El ultimo flujo AC diverge, por lo NO ES APLICABLE ESTUDIO DE VARIACION DE VOLTAJE !!!");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.Flujo[i] < this.minActFlujo[i]) {
                                    this.minActFlujo[i] = this.Flujo[i];
                                }
                                if (this.Flujo[i] > this.maxActFlujo[i]) {
                                    this.maxActFlujo[i] = this.Flujo[i];
                                }
                                int n = i;
                                this.acumActFlujo[n] = this.acumActFlujo[n] + this.Flujo[i] * this.blockTime[this.nrobl - 1];
                                int n2 = i;
                                this.varActFlujo[n2] = this.varActFlujo[n2] + this.Flujo[i] * this.Flujo[i] * this.blockTime[this.nrobl - 1];
                            }
                            this.node_pg[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pg[n] = this.node_pg[n] + this.Flujo[i] * this.sref;
                                    continue;
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pg[n] = this.node_pg[n] - this.Flujo[i] * this.sref;
                            }
                            this.node_pg[this.slackNode] = Math.max(0.0, this.node_pg[this.slackNode]);
                            this.actGen[this.slackGenerator] = this.node_pg[this.slackNode];
                            for (i = 0; i < this.numactgen; ++i) {
                                if (this.actGen[i] < this.minActGen[i]) {
                                    this.minActGen[i] = this.actGen[i];
                                }
                                if (this.actGen[i] > this.maxActGen[i]) {
                                    this.maxActGen[i] = this.actGen[i];
                                }
                                int n = i;
                                this.medActGen[n] = this.medActGen[n] + this.actGen[i] * this.blockTime[this.nrobl - 1];
                                int n3 = i;
                                this.varActGen[n3] = this.varActGen[n3] + this.actGen[i] * this.actGen[i] * this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactlast; ++i) {
                                if (this.actLas[i] < this.minActLas[i]) {
                                    this.minActLas[i] = this.actLas[i];
                                }
                                if (this.actLas[i] > this.maxActLas[i]) {
                                    this.maxActLas[i] = this.actLas[i];
                                }
                                int n = i;
                                this.medActLas[n] = this.medActLas[n] + this.actLas[i];
                                int n4 = i;
                                this.varActLas1[n4] = this.varActLas1[n4] + this.actLas[i] * this.actLas[i];
                                int n5 = i;
                                this.varActLas2[n5] = this.varActLas2[n5] + this.actLas[i];
                            }
                            for (i = 0; i < this.numactnod; ++i) {
                                if (this.actVolt[i] == 0.0) continue;
                                if (this.actVolt[i] < this.minActVolt[i][h - 1]) {
                                    this.minActVolt[i][h - 1] = this.actVolt[i];
                                }
                                if (this.actVolt[i] > this.maxActVolt[i][h - 1]) {
                                    this.maxActVolt[i][h - 1] = this.actVolt[i];
                                }
                                double[] dArray = this.medActVolt[i];
                                int n = h - 1;
                                dArray[n] = dArray[n] + this.actVolt[i];
                                double[] dArray2 = this.varActVolt1[i];
                                int n6 = h - 1;
                                dArray2[n6] = dArray2[n6] + this.actVolt[i] * this.actVolt[i];
                                double[] dArray3 = this.varActVolt2[i];
                                int n7 = h - 1;
                                dArray3[n7] = dArray3[n7] + this.actVolt[i];
                            }
                            this.sdur += this.blockTime[this.nrobl - 1];
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.Flujo[i] > 1.0E-6) {
                                    int n = i;
                                    this.tPAct[n] = this.tPAct[n] + this.blockTime[this.nrobl - 1];
                                    continue;
                                }
                                if (this.Flujo[i] < -1.0E-6) {
                                    int n = i;
                                    this.tNAct[n] = this.tNAct[n] + this.blockTime[this.nrobl - 1];
                                    continue;
                                }
                                int n = i;
                                this.tCAct[n] = this.tCAct[n] + this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactnod; ++i) {
                                if (this.actVolt[i] >= 1.0) {
                                    int n = i;
                                    this.tMaunoAct[n] = this.tMaunoAct[n] + this.blockTime[this.nrobl - 1];
                                }
                                if (this.actVolt[i] < 1.0) {
                                    int n = i;
                                    this.tMeunoAct[n] = this.tMeunoAct[n] + this.blockTime[this.nrobl - 1];
                                }
                                if (this.actVolt[i] != 0.0) continue;
                                int n = i;
                                this.tCeunoAct[n] = this.tCeunoAct[n] + this.blockTime[this.nrobl - 1];
                            }
                            ++this.nitera;
                        }
                    }
                    block33: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii].equals(this.NomBra[i])) continue;
                            if (this.minAllFlujo[i] > this.minActFlujo[ii]) {
                                this.minAllFlujo[i] = this.minActFlujo[ii];
                            }
                            if (this.maxAllFlujo[i] < this.maxActFlujo[ii]) {
                                this.maxAllFlujo[i] = this.maxActFlujo[ii];
                            }
                            int n = i;
                            this.acumAllFlujo[n] = this.acumAllFlujo[n] + this.acumActFlujo[ii];
                            int n8 = i;
                            this.varAllFlujo[n8] = this.varAllFlujo[n8] + this.varActFlujo[ii];
                            int n9 = i;
                            this.simDuration[n9] = this.simDuration[n9] + this.sdur;
                            int n10 = i;
                            this.tPAll[n10] = this.tPAll[n10] + this.tPAct[ii];
                            int n11 = i;
                            this.tNAll[n11] = this.tNAll[n11] + this.tNAct[ii];
                            int n12 = i;
                            this.tCAll[n12] = this.tCAll[n12] + this.tCAct[ii];
                            continue block33;
                        }
                    }
                    block35: for (ii = 0; ii < this.numactgen; ++ii) {
                        for (i = ii; i < this.numallgen; ++i) {
                            if (!this.NomActGen[ii].equals(this.NomGen[i])) continue;
                            if (this.minAllGen[i] > this.minActGen[ii]) {
                                this.minAllGen[i] = this.minActGen[ii];
                            }
                            if (this.maxAllGen[i] < this.maxActGen[ii]) {
                                this.maxAllGen[i] = this.maxActGen[ii];
                            }
                            int n = i;
                            this.medAllGen[n] = this.medAllGen[n] + this.medActGen[ii];
                            int n13 = i;
                            this.varAllGen[n13] = this.varAllGen[n13] + this.varActGen[ii];
                            int n14 = i;
                            this.genDuration[n14] = this.genDuration[n14] + this.sdur;
                            continue block35;
                        }
                    }
                    block37: for (ii = 0; ii < this.numactlast; ++ii) {
                        for (i = ii; i < this.numalllast; ++i) {
                            if (!this.NomActLas[ii].equals(this.NomLas[i])) continue;
                            if (this.minAllLas[i] > this.minActLas[ii]) {
                                this.minAllLas[i] = this.minActLas[ii];
                            }
                            if (this.maxAllLas[i] < this.maxActLas[ii]) {
                                this.maxAllLas[i] = this.maxActLas[ii];
                            }
                            int n = i;
                            this.medAllLas[n] = this.medAllLas[n] + this.medActLas[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n15 = i;
                            this.varAllLas1[n15] = this.varAllLas1[n15] + this.varActLas1[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n16 = i;
                            this.varAllLas2[n16] = this.varAllLas2[n16] + this.varActLas2[ii] / (double)((this.lhidro + 1) * (this.lblock + 1));
                            int n17 = i;
                            this.lasDuration[n17] = this.lasDuration[n17] + this.sdur;
                            continue block37;
                        }
                    }
                    for (hi4 = 0; hi4 < this.HydroNumberDB; ++hi4) {
                        block40: for (int ii2 = 0; ii2 < this.numactnod; ++ii2) {
                            for (i = ii2; i < this.numallnod; ++i) {
                                if (!this.NomActNod[ii2].equals(this.NomNod[i])) continue;
                                if (this.minAllVolt[i][hi4] > this.minActVolt[ii2][hi4]) {
                                    this.minAllVolt[i][hi4] = this.minActVolt[ii2][hi4];
                                }
                                if (this.maxAllVolt[i][hi4] < this.maxActVolt[ii2][hi4]) {
                                    this.maxAllVolt[i][hi4] = this.maxActVolt[ii2][hi4];
                                }
                                double[] dArray = this.medAllVolt[i];
                                int n = hi4;
                                dArray[n] = dArray[n] + this.medActVolt[ii2][hi4] / (double)(this.lblock + 1 - this.countacdiv[hi4]);
                                double[] dArray4 = this.varAllVolt1[i];
                                int n18 = hi4;
                                dArray4[n18] = dArray4[n18] + this.varActVolt1[ii2][hi4] / (double)(this.lblock + 1 - this.countacdiv[hi4]);
                                double[] dArray5 = this.varAllVolt2[i];
                                int n19 = hi4;
                                dArray5[n19] = dArray5[n19] + this.varActVolt2[ii2][hi4] / (double)(this.lblock + 1 - this.countacdiv[hi4]);
                                int n20 = i;
                                this.simDurationVolt[n20] = this.simDurationVolt[n20] + this.sdur;
                                int n21 = i;
                                this.tMaunoAll[n21] = this.tMaunoAll[n21] + this.tMaunoAct[ii2];
                                int n22 = i;
                                this.tMeunoAll[n22] = this.tMeunoAll[n22] + this.tMeunoAct[ii2];
                                int n23 = i;
                                this.tCeunoAll[n23] = this.tCeunoAll[n23] + this.tCeunoAct[ii2];
                                continue block40;
                            }
                        }
                    }
                    for (i = 0; i < this.numactbran; ++i) {
                        this.acumActFlujo[i] = 0.0;
                        this.varActFlujo[i] = 0.0;
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        this.medActGen[i] = 0.0;
                        this.varActGen[i] = 0.0;
                    }
                    for (i = 0; i < this.numactlast; ++i) {
                        this.medActLas[i] = 0.0;
                        this.varActLas1[i] = 0.0;
                        this.varActLas2[i] = 0.0;
                    }
                    for (hi4 = 0; hi4 < this.HydroNumberDB; ++hi4) {
                        for (i = 0; i < this.numactnod; ++i) {
                            this.medActVolt[i][hi4] = 0.0;
                            this.varActVolt1[i][hi4] = 0.0;
                            this.varActVolt2[i][hi4] = 0.0;
                        }
                    }
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            for (i = 0; i < this.numallbran; ++i) {
                if (this.simDuration[i] > 1.0E-6) {
                    this.acumAllFlujo[i] = this.acumAllFlujo[i] / this.simDuration[i];
                    this.varAllFlujo[i] = this.varAllFlujo[i] / this.simDuration[i] - this.acumAllFlujo[i] * this.acumAllFlujo[i];
                    if (!(this.varAllFlujo[i] < 0.0)) continue;
                    this.varAllFlujo[i] = 0.0;
                    continue;
                }
                this.minAllFlujo[i] = 0.0;
                this.maxAllFlujo[i] = 0.0;
                this.acumAllFlujo[i] = 0.0;
            }
            for (i = 0; i < this.numallgen; ++i) {
                if (this.genDuration[i] > 1.0E-6) {
                    this.medAllGen[i] = this.medAllGen[i] / this.genDuration[i];
                    this.varAllGen[i] = this.varAllGen[i] / this.genDuration[i] - this.medAllGen[i] * this.medAllGen[i];
                    if (!(this.varAllGen[i] < 0.0)) continue;
                    this.varAllGen[i] = 0.0;
                    continue;
                }
                this.minAllGen[i] = 0.0;
                this.maxAllGen[i] = 0.0;
                this.medAllGen[i] = 0.0;
            }
            for (i = 0; i < this.numalllast; ++i) {
                if (this.lasDuration[i] > 1.0E-6) {
                    this.varAllLas[i] = this.varAllLas1[i] - 2.0 * (this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1))) * this.varAllLas2[i] + this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1)) * (this.medAllLas[i] / (double)((this.lmonth + 1) * (this.lyear + 1))) * (double)((this.lmonth + 1) * (this.lyear + 1));
                    this.medAllLas[i] = this.medAllLas[i] / (double)(this.lmonth + 1);
                    if (!(this.varAllLas[i] < 0.0)) continue;
                    this.varAllLas[i] = 0.0;
                    continue;
                }
                this.minAllLas[i] = 0.0;
                this.maxAllLas[i] = 0.0;
                this.medAllLas[i] = 0.0;
            }
            for (i = 0; i < this.numallnod; ++i) {
                if (this.simDurationVolt[i] > 1.0E-6) {
                    for (hi = 0; hi < this.HydroNumberDB; ++hi) {
                        this.varAllVolt[i][hi] = this.varAllVolt1[i][hi] - 2.0 * (this.medAllVolt[i][hi] / (double)((this.lmonth + 1) * (this.lyear + 1))) * this.varAllVolt2[i][hi] + this.medAllVolt[i][hi] / (double)((this.lmonth + 1) * (this.lyear + 1)) * (this.medAllVolt[i][hi] / (double)((this.lmonth + 1) * (this.lyear + 1))) * (double)((this.lmonth + 1) * (this.lyear + 1));
                        if (!(this.varAllVolt[i][hi] < 0.0)) continue;
                        this.varAllVolt[i][hi] = 0.0;
                    }
                    continue;
                }
                for (hi = 0; hi < this.HydroNumberDB; ++hi) {
                    this.minAllVolt[i][hi] = 0.0;
                    this.maxAllVolt[i][hi] = 0.0;
                    this.medAllVolt[i][hi] = 0.0;
                }
            }
            for (hi = 0; hi < this.HydroNumberDB; ++hi) {
                for (int k = 0; k < this.numallnod; ++k) {
                    porcvarvolt[k][hi] = 100.0 * (finvolt[k][hi] - inivolt[k][hi]) / inivolt[k][hi];
                }
            }
            for (int hu = 0; hu < this.HydroNumberDB; ++hu) {
                for (int g = 0; g < this.numallnod; ++g) {
                    if (porcvarvolt[g][hu] <= -10.0) {
                        double[] dArray = this.intervolt[0];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > -10.0 && porcvarvolt[g][hu] <= -5.0) {
                        double[] dArray = this.intervolt[1];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > -5.0 && porcvarvolt[g][hu] <= -2.5) {
                        double[] dArray = this.intervolt[2];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > -2.5 && porcvarvolt[g][hu] < 0.0) {
                        double[] dArray = this.intervolt[3];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] == 0.0) {
                        double[] dArray = this.intervolt[4];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > 0.0 && porcvarvolt[g][hu] <= 2.5) {
                        double[] dArray = this.intervolt[5];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > 2.5 && porcvarvolt[g][hu] <= 5.0) {
                        double[] dArray = this.intervolt[6];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (porcvarvolt[g][hu] > 5.0 && porcvarvolt[g][hu] < 10.0) {
                        double[] dArray = this.intervolt[7];
                        int n = hu;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if (!(porcvarvolt[g][hu] >= 10.0)) continue;
                    double[] dArray = this.intervolt[8];
                    int n = hu;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            if (rep) {
                this.os = new FileOutputStream(SensiJAVAdat);
                this.myPPrintStream = new PrintStream(this.os);
                System.out.println("Making Report File");
                System.out.println(" Time = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas Generales");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Selecci\u00f3n de Flujos  :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
                this.myPPrintStream.println(" Flujo Inicial        :" + StringUtil.numformat(this.year1, 8) + "/" + StringUtil.numformat(this.month1, 8) + "/" + StringUtil.numformat(this.block1, 8) + "/" + StringUtil.numformat(this.hidro1, 8) + "/" + StringUtil.numformat(this.flow1, 8));
                this.myPPrintStream.println(" Flujo Final          :" + StringUtil.numformat(this.year2, 8) + "/" + StringUtil.numformat(this.month2, 8) + "/" + StringUtil.numformat(this.block2, 8) + "/" + StringUtil.numformat(this.hidro2, 8) + "/" + StringUtil.numformat(this.flow2, 8));
                this.myPPrintStream.println(" Total Barras         :    " + this.numallnod);
                this.myPPrintStream.println(" Total Ramas          :    " + this.numallbran);
                this.myPPrintStream.println(" Total Generadores    :    " + this.numallgen);
                this.myPPrintStream.println(" Total Cargas         :    " + this.numalllast);
                this.myPPrintStream.println(" Total L\u00edneas         :    " + this.numalllin);
                this.myPPrintStream.println(" Total Transformadores:    " + this.numalltrafo);
                this.myPPrintStream.println(" Total Execution Time :    " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                if (this.converdclfwloss && this.tipoflujo == 2) {
                    this.myPPrintStream.println("---------------------------------------------------------");
                    this.myPPrintStream.println("OBSERVACION:");
                    this.myPPrintStream.println("Todos los Flujos DC con p\u00e9rdida presentaron convergencia.");
                    this.myPPrintStream.println(" ");
                    this.myPPrintStream.println("---------------------------------------------------------");
                }
                if (!this.converdclfwloss) {
                    this.myPPrintStream.println("---------------------------------------------------------");
                    this.myPPrintStream.println("OBSERVACION:");
                    this.myPPrintStream.println("Flujos DC con p\u00e9rdida sin convergencia presentados es los periodos:");
                    this.myPPrintStream.println("Se presenta un flujos DC con perdidas sin convergencia. Se anula el estudio en proceso.");
                    this.myPPrintStream.println(" ");
                    this.myPPrintStream.println("---------------------------------------------------------");
                }
                if (!this.somelfacdiv && this.flujoac) {
                    this.myPPrintStream.println("---------------------------------------------------------");
                    this.myPPrintStream.println("OBSERVACION:");
                    this.myPPrintStream.println("Todos los Flujos AC presentaron convergencia.");
                    this.myPPrintStream.println(" ");
                    this.myPPrintStream.println("---------------------------------------------------------");
                }
                if (this.somelfacdiv) {
                    this.myPPrintStream.println("---------------------------------------------------------");
                    this.myPPrintStream.println("OBSERVACION:");
                    this.myPPrintStream.println("Se presenta un flujos AC sin convergencia. Se anula el estudio en proceso.");
                    this.myPPrintStream.println(" ");
                    this.myPPrintStream.println("---------------------------------------------------------");
                }
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
            try {
                this.osCSV1 = new FileOutputStream("." + File.separator + "database" + File.separator + "YearlyStatBranch.csv");
                this.salidaCSV1 = new PrintStream(this.osCSV1);
                this.osCSV2 = new FileOutputStream("." + File.separator + "database" + File.separator + "YearlyStatGen.csv");
                this.salidaCSV2 = new PrintStream(this.osCSV2);
                this.osCSV3 = new FileOutputStream("." + File.separator + "database" + File.separator + "YearlyStatLoad.csv");
                this.salidaCSV3 = new PrintStream(this.osCSV3);
                this.salidaCSV2.println("Generador,Gen_Media[MW],Gen_Max[MW],Gen_Min[MW],Desv[MW]");
                for (i = 0; i < this.numallgen; ++i) {
                    this.salidaCSV2.println("" + this.NomGen[i] + "," + this.medAllGen[i] + "," + this.maxAllGen[i] + "," + this.minAllGen[i] + "," + Math.sqrt(this.varAllGen[i]));
                }
                this.salidaCSV3.println("Carga,Dem_Media[MW],Dem_Max[MW],Dem_Min[MW],Desv[MW]");
                for (i = 0; i < this.numalllast; ++i) {
                    this.salidaCSV3.println("" + this.NomLas[i] + "," + this.medAllLas[i] + "," + this.maxAllLas[i] + "," + this.minAllLas[i] + "," + Math.sqrt(this.varAllLas[i]));
                }
                this.salidaCSV1.println("Rama,Desde,Hasta,Flujo_Medio[MW],Flujo_Max[MW],Flujo_Min[MW],Desv[MW],Dur[h],Tiempo_Positivo[h],Tiempo_Negativo[h],Tiempo_Cero[h]");
                for (i = 0; i < this.numallbran; ++i) {
                    if (this.AllBranchI[i] == -1 || this.AllBranchJ[i] == -1) {
                        this.salidaCSV1.println("" + this.NomBra[i] + ",-1,-1," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i]);
                        continue;
                    }
                    this.salidaCSV1.println("" + this.NomBra[i] + "," + this.NomNod[this.AllBranchI[i]] + "," + this.NomNod[this.AllBranchJ[i]] + "," + 100.0 * this.acumAllFlujo[i] + "," + 100.0 * this.maxAllFlujo[i] + "," + 100.0 * this.minAllFlujo[i] + "," + 100.0 * Math.sqrt(this.varAllFlujo[i]) + "," + (this.tPAll[i] + this.tCAll[i] + this.tNAll[i]) + "," + this.tPAll[i] + "," + this.tNAll[i] + "," + this.tCAll[i]);
                }
                this.closefileCSV1();
                this.closefileCSV2();
                this.closefileCSV3();
            }
            catch (Exception e) {
                System.out.println("Archivos de escritura en uso. No es posible escribir nuevos resultados.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.closefile();
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        this.writeresults();
        System.out.println("TOTAL EXECUTION TIME = " + StringUtil.numformat((System.currentTimeMillis() - time) / 1000L / 60L, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad " + SensiJAVAdat);
            }
            catch (IOException e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace(System.err);
            }
        }
        if (this.vis && this.flow2 > this.flow1) {
            if (this.MyYearlyDCLFStatisticsVisualFrameVolt == null) {
                this.MyYearlyDCLFStatisticsVisualFrameVolt = new YearlyDCLFStatisticsVisualFrameVolt(this.applet, MyDEMainChartFrame, this, false, this.flujoac);
            } else {
                this.MyYearlyDCLFStatisticsVisualFrameVolt.setVisible(true);
            }
        }
    }

    public void InitAllNetwork() {
        int i;
        int i2;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement(TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.actVolt = new double[this.numallnod];
        this.LosOwner = new String[this.numallgen];
        this.acumAllFlujo = new double[this.numallbran];
        this.AllBranchI = new int[this.numallbran];
        this.AllBranchJ = new int[this.numallbran];
        this.simDuration = new double[this.numallbran];
        this.simDurationVolt = new double[this.numallnod];
        this.minAllFlujo = new double[this.numallbran];
        this.maxAllFlujo = new double[this.numallbran];
        this.varAllFlujo = new double[this.numallbran];
        for (i2 = 0; i2 < this.numallbran; ++i2) {
            this.acumAllFlujo[i2] = 0.0;
            this.AllBranchI[i2] = -1;
            this.AllBranchJ[i2] = -1;
            this.simDuration[i2] = 0.0;
            this.minAllFlujo[i2] = 1000000.0;
            this.maxAllFlujo[i2] = -1000000.0;
            this.varAllFlujo[i2] = 0.0;
        }
        this.medAllGen = new double[this.numallgen];
        this.maxAllGen = new double[this.numallgen];
        this.minAllGen = new double[this.numallgen];
        this.varAllGen = new double[this.numallgen];
        this.genDuration = new double[this.numallgen];
        for (i2 = 0; i2 < this.numallgen; ++i2) {
            this.medAllGen[i2] = 0.0;
            this.maxAllGen[i2] = -100000.0;
            this.minAllGen[i2] = 100000.0;
            this.varAllGen[i2] = 0.0;
            this.genDuration[i2] = 0.0;
        }
        this.medAllLas = new double[this.numalllast];
        this.maxAllLas = new double[this.numalllast];
        this.minAllLas = new double[this.numalllast];
        this.varAllLas = new double[this.numalllast];
        this.varAllLas1 = new double[this.numalllast];
        this.varAllLas2 = new double[this.numalllast];
        this.lasDuration = new double[this.numalllast];
        for (i2 = 0; i2 < this.numalllast; ++i2) {
            this.medAllLas[i2] = 0.0;
            this.maxAllLas[i2] = -100000.0;
            this.minAllLas[i2] = 100000.0;
            this.varAllLas[i2] = 0.0;
            this.varAllLas1[i2] = 0.0;
            this.varAllLas2[i2] = 0.0;
            this.lasDuration[i2] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        this.tPAll = new double[this.numallbran];
        this.tNAll = new double[this.numallbran];
        this.tCAll = new double[this.numallbran];
        this.tMaunoAll = new double[this.numallnod];
        this.tMeunoAll = new double[this.numallnod];
        this.tCeunoAll = new double[this.numallnod];
        for (i = 0; i < this.numallbran; ++i) {
            this.tPAll[i] = 0.0;
            this.tNAll[i] = 0.0;
            this.tCAll[i] = 0.0;
        }
        for (i = 0; i < this.numallnod; ++i) {
            this.tMaunoAll[i] = 0.0;
            this.tMeunoAll[i] = 0.0;
            this.tCeunoAll[i] = 0.0;
            this.simDurationVolt[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempLine.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempLine.getcon2());
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempTrafo.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempTrafo.getcon2());
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                this.LosOwner[countGen] = TempGenerator.getinv_owner();
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            ++countLas;
        }
        int aux = 0;
        if (this.numallgen >= 2) {
            for (int i3 = 0; i3 < this.numallgen; ++i3) {
                aux = 0;
                for (int j = i3 + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i3].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallowner;
            }
        } else {
            this.numallowner = this.numallgen;
        }
        this.NomOwner = new String[this.numallowner];
        aux = 0;
        int cmul = 0;
        if (this.numallgen >= 2) {
            for (int i4 = 0; i4 < this.numallgen; ++i4) {
                aux = 0;
                for (int j = i4 + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i4].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomOwner[cmul] = this.LosOwner[i4];
                ++cmul;
            }
        } else {
            this.NomOwner[0] = this.LosOwner[0];
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro) {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        String tempoName = "";
        int IdDespActual = this.getDispatchID(ano, mes, bloque, hidro);
        this.PDCLF = new double[this.numactnod];
        for (i = 0; i < this.numactnod; ++i) {
            this.PDCLF[i] = 0.0;
            this.node_pg[i] = 0.0;
            for (int k = 0; k < this.numactowner; ++k) {
                this.PGenOwn[k][i] = 0.0;
            }
        }
        for (i = 0; i < this.numactgen; ++i) {
            this.actGen[i] = 0.0;
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        int NroDdaActual = -1;
        int NroDdaActual2 = -1;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
            Generator TempGenerator = (Generator)TempComponent;
            block4: for (i = 0; i < this.dimDBGen; ++i) {
                if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                int n = this.GenNode[countG];
                this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                int n2 = this.GenNode[countG];
                this.node_pg[n2] = this.node_pg[n2] + this.PDB[i];
                this.TotGen += this.PDB[i];
                this.actGen[countG] = this.PDB[i];
                for (int k = 0; k < this.numactowner; ++k) {
                    if (!this.NomActOwner[k].equals(TempGenerator.getinv_owner())) continue;
                    double[] dArray = this.PGenOwn[k];
                    int n3 = this.GenNode[countG];
                    dArray[n3] = dArray[n3] + this.PDB[i];
                    break block4;
                }
                break;
            }
            ++countG;
        }
        if (this.directDx) {
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
                Load TempLoad = (Load)TempComponent;
                tempoName = TempLoad.getName().trim();
                if (this.ht_dem.containsKey(tempoName)) {
                    i = (Integer)this.ht_dem.get(tempoName);
                    NroDdaActual = (IdDespActual - this.flow1) / this.HydroNumberDB;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual] / this.sref;
                    this.actLas[countL] = this.PLDB[i][NroDdaActual];
                    this.reactLas[countL] = this.actLas[countL] * 0.3286841;
                    this.TotDem += this.PLDB[i][NroDdaActual];
                }
                ++countL;
            }
        } else {
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
                Load TempLoad = (Load)TempComponent;
                if (!this.one) {
                    NroDdaActual = this.BlockNumberDB * (mes - 1) + bloque;
                    for (i = 0; i < this.dimDBLoad; ++i) {
                        if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                        int n = this.LasNode[countL];
                        this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * (this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.blockTime[NroDdaActual - 1]) / this.sref;
                        this.actLas[countL] = this.PLDB[i][NroDdaActual - 1] * (this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.blockTime[NroDdaActual - 1]);
                        this.reactLas[countL] = this.actLas[countL] * Math.tan(Math.acos(this.COSPHI[i]));
                        this.TotDem += this.PLDB[i][NroDdaActual - 1] * (this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.blockTime[NroDdaActual - 1]);
                        break;
                    }
                } else {
                    NroDdaActual2 = this.MonthNumberDB * (ano - this.InitialYearDB) + mes;
                    for (i = 0; i < this.dimDBLoad2; ++i) {
                        if (!this.NameLDB2[i].equals(TempLoad.getName())) continue;
                        int n = this.LasNode[countL];
                        this.PDCLF[n] = this.PDCLF[n] - this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen / this.sref;
                        this.actLas[countL] = this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                        this.reactLas[countL] = this.actLas[countL] * Math.tan(Math.acos(this.COSPHI[i]));
                        this.TotDem += this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                        break;
                    }
                }
                ++countL;
            }
        }
    }

    public boolean GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa) {
        return false;
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = this.MonthNumberDB;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = TempNdb_comp.getentry_period();
            m1 = TempNdb_comp.getentry_month();
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = nmes;
            int rano = nano;
            if (rmes == 1) {
                rmes = this.MonthNumberDB;
                --rano;
            } else if (rmes >= 2 && rmes <= this.MonthNumberDB) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork() {
        comp TempComponent;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.LosActOwner = new String[this.numactgen];
        this.acumActFlujo = new double[this.numactbran];
        this.minActFlujo = new double[this.numactbran];
        this.maxActFlujo = new double[this.numactbran];
        this.varActFlujo = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            this.acumActFlujo[i] = 0.0;
            this.minActFlujo[i] = 1000000.0;
            this.maxActFlujo[i] = -1000000.0;
            this.varActFlujo[i] = 0.0;
        }
        this.medActGen = new double[this.numactgen];
        this.maxActGen = new double[this.numactgen];
        this.minActGen = new double[this.numactgen];
        this.varActGen = new double[this.numactgen];
        this.actGen = new double[this.numactgen];
        for (i = 0; i < this.numactgen; ++i) {
            this.medActGen[i] = 0.0;
            this.maxActGen[i] = -100000.0;
            this.minActGen[i] = 100000.0;
            this.varActGen[i] = 0.0;
        }
        this.medActLas = new double[this.numactlast];
        this.maxActLas = new double[this.numactlast];
        this.minActLas = new double[this.numactlast];
        this.varActLas1 = new double[this.numactlast];
        this.varActLas2 = new double[this.numactlast];
        this.actLas = new double[this.numactlast];
        this.reactLas = new double[this.numactlast];
        for (i = 0; i < this.numactlast; ++i) {
            this.medActLas[i] = 0.0;
            this.maxActLas[i] = -100000.0;
            this.minActLas[i] = 100000.0;
            this.varActLas1[i] = 0.0;
            this.varActLas2[i] = 0.0;
        }
        for (int ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        this.tPAct = new double[this.numactbran];
        this.tNAct = new double[this.numactbran];
        this.tCAct = new double[this.numactbran];
        this.tMaunoAct = new double[this.numactnod];
        this.tMeunoAct = new double[this.numactnod];
        this.tCeunoAct = new double[this.numactnod];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slack = this.numbus(TempGenerator.getcon2());
                    this.slackGenerator = countGen;
                    this.slackNode = this.slack;
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            Busbar TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return -1;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return -1;
    }

    public void closefile() {
        try {
            if (this.myPPrintStream != null) {
                this.myPPrintStream.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.os_yearly != null) {
                this.os_yearly.close();
            }
            if (this.os_yearlyDC != null) {
                this.os_yearlyDC.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public void closefileCSV1() {
        try {
            this.salidaCSV1.close();
            if (this.osCSV1 != null) {
                this.osCSV1.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public void closefileCSV2() {
        try {
            this.salidaCSV2.close();
            if (this.osCSV2 != null) {
                this.osCSV2.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public void closefileCSV3() {
        try {
            this.salidaCSV3.close();
            if (this.osCSV3 != null) {
                this.osCSV3.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public void writeresults() {
        int ix = 0;
        boolean count = false;
        boolean con1 = false;
        boolean con2 = false;
        int countBra = 0;
        int countGen = 0;
        int countLas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            ndb_comp TempNdb_comp;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                ndb_branch TempBran = (ndb_branch)TempComponent;
                TempBran.setp12(this.acumAllFlujo[countBra]);
                TempBran.setp21(-this.acumAllFlujo[countBra]);
                ++countBra;
                continue;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                TempGenerator.setp(this.medAllGen[countGen]);
                ++countGen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            TempLoad.setpini(this.medAllLas[countLas]);
            TempLoad.setp0(this.medAllLas[countLas]);
            TempLoad.setgrate(0.0);
            ++countLas;
        }
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, int SDY, int SDM, int SDB, int SDH, int EDY, int EDM, int EDB, int EDH, boolean HydroDB, boolean ERep, boolean ssisentido) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ssisentido) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, String CritSel, double percent, double umbral) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, String CritSel, double percent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

