/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.VisualImport;
import de.core.VisualImportDBJDialog;
import de.data.DE_GeneralEnums;
import java.awt.Color;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class VisualImportFrame
extends JDialog {
    private VisualImport myVisualImport = null;
    private final DeepEdit myDeepEdit;
    private Thread ShCThread;
    private static final String EMPTY = "Empty";
    private JButton BrowseInputFolder;
    private JButton BrowseOutputFolder;
    private JButton CancelBtn;
    private JButton ClearServerTablebtn;
    private JButton ConfigDBbtn;
    private JPanel ConfirmationPanel;
    private JRadioButton CurrentSchematicbtn;
    private JRadioButton DBSchematicbtn;
    private JPanel DBSourcePanel;
    private JLabel DateFromlbl;
    private JLabel DateServerFromlbl;
    private JLabel DateServerTolbl;
    private JLabel DateTolbl;
    private JCheckBox ExternalDBChk;
    private JButton LoadCasesbtn;
    private JTextField LocalSourcetxt;
    private JPanel LocalTab;
    private JTabbedPane MainTab;
    private JButton Okbtn;
    private JPanel OutputFilePanel;
    private JTextField OutputFoldertxt;
    private JPanel OutputTab;
    private JTable RetrieveCaseslServertbl;
    private JPanel SchematicPanel;
    private JPanel ServerTab;
    private JPanel SourcePanel;
    private JLabel StatusMessagelbl;
    private JPanel SupportFormatPanel;
    private JPanel SupportServerFormatPanel;
    private JTable TimeControlLocaltbl;
    private JPanel TimeControlPanel;
    private JPanel TimeControlServerPanel;
    private JTable TimeControlServertbl;
    private JCheckBox UpdateDBChk;
    private JButton UpdateDeepEditDB;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblLocalDataFrom;
    private JLabel lblLocalDateTo;
    private JLabel lblServDataFrom;
    private JLabel lblServDataTo;
    private JRadioButton ose_localbutton;
    private JRadioButton ose_serverbtn;
    private JRadioButton pcp_localbutton;
    private JRadioButton pcp_serverbtn;
    private JRadioButton pet_localbutton;
    private JRadioButton plexos_localbutton;
    private JRadioButton plexos_serverbtn;
    private JRadioButton plp_localbutton;
    private JRadioButton plp_serverbtn;
    private ButtonGroup schematic_group;
    private ButtonGroup supportlocal_group;
    private ButtonGroup supportserver_group;
    private JTextField txtCurrentCase;
    private BindingGroup bindingGroup;

    public String getTypedb() {
        return this.myVisualImport.getTypedb();
    }

    public void setTypedb(String Typedb) {
        this.myVisualImport.setTypedb(Typedb);
    }

    public String getHost() {
        return this.myVisualImport.getHost();
    }

    public void setHost(String Host) {
        this.myVisualImport.setHost(Host);
    }

    public String getNamedb_smme() {
        return this.myVisualImport.getNamedb_smme();
    }

    public void setNamedb_smme(String Namedb_smme) {
        this.myVisualImport.setNamedb_smme(Namedb_smme);
    }

    public String getUserdb() {
        return this.myVisualImport.getUserdb();
    }

    public void setUserdb(String Userdb) {
        this.myVisualImport.setUserdb(Userdb);
    }

    public String getPassdb() {
        return this.myVisualImport.getPassdb();
    }

    public void setPassdb(String Passdb) {
        this.myVisualImport.setPassdb(Passdb);
    }

    public String getNamedb_dispatch() {
        return this.myVisualImport.getNamedb_dispatch();
    }

    public void setNamedb_dispatch(String namedb_dispatch) {
        this.myVisualImport.setNamedb_dispatch(namedb_dispatch);
    }

    public void setCurrentCase(String casePath) {
        if (casePath == null) {
            this.txtCurrentCase.setText(EMPTY);
        } else {
            this.txtCurrentCase.setText(casePath);
        }
    }

    public VisualImportFrame(DeepEditFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.RetrieveCaseslServertbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                VisualImportFrame.this.retrieveCasesServertblvalueChanged(evt);
            }
        });
        this.myDeepEdit = parent.applet;
        if (this.myVisualImport == null) {
            this.myVisualImport = new VisualImport(DeepEdit.getActiveSchematic(), parent, this);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.supportlocal_group = new ButtonGroup();
        this.schematic_group = new ButtonGroup();
        this.supportserver_group = new ButtonGroup();
        this.ConfirmationPanel = new JPanel();
        this.CancelBtn = new JButton();
        this.Okbtn = new JButton();
        this.StatusMessagelbl = new JLabel();
        this.MainTab = new JTabbedPane();
        this.LocalTab = new JPanel();
        this.SupportFormatPanel = new JPanel();
        this.ose_localbutton = new JRadioButton();
        this.pcp_localbutton = new JRadioButton();
        this.plexos_localbutton = new JRadioButton();
        this.plp_localbutton = new JRadioButton();
        this.pet_localbutton = new JRadioButton();
        this.SourcePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.LocalSourcetxt = new JTextField();
        this.BrowseInputFolder = new JButton();
        this.txtCurrentCase = new JTextField();
        this.jLabel3 = new JLabel();
        this.TimeControlPanel = new JPanel();
        this.lblLocalDataFrom = new JLabel();
        this.DateFromlbl = new JLabel();
        this.lblLocalDateTo = new JLabel();
        this.DateTolbl = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.TimeControlLocaltbl = new JTable();
        this.ServerTab = new JPanel();
        this.SupportServerFormatPanel = new JPanel();
        this.ose_serverbtn = new JRadioButton();
        this.pcp_serverbtn = new JRadioButton();
        this.plexos_serverbtn = new JRadioButton();
        this.plp_serverbtn = new JRadioButton();
        this.DBSourcePanel = new JPanel();
        this.LoadCasesbtn = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.RetrieveCaseslServertbl = new JTable();
        this.ClearServerTablebtn = new JButton();
        this.TimeControlServerPanel = new JPanel();
        this.lblServDataFrom = new JLabel();
        this.DateServerFromlbl = new JLabel();
        this.lblServDataTo = new JLabel();
        this.DateServerTolbl = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.TimeControlServertbl = new JTable();
        this.ExternalDBChk = new JCheckBox();
        this.ConfigDBbtn = new JButton();
        this.OutputTab = new JPanel();
        this.OutputFilePanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.OutputFoldertxt = new JTextField();
        this.BrowseOutputFolder = new JButton();
        this.SchematicPanel = new JPanel();
        this.CurrentSchematicbtn = new JRadioButton();
        this.DBSchematicbtn = new JRadioButton();
        this.UpdateDBChk = new JCheckBox();
        this.UpdateDeepEditDB = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Visualization Importer");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VisualImportFrame.this.formWindowClosing(evt);
            }
        });
        this.CancelBtn.setText("Close");
        this.CancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.CancelBtnActionPerformed(evt);
            }
        });
        this.Okbtn.setText("Load");
        this.Okbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.OkbtnActionPerformed(evt);
            }
        });
        this.StatusMessagelbl.setText("Select source...");
        GroupLayout ConfirmationPanelLayout = new GroupLayout(this.ConfirmationPanel);
        this.ConfirmationPanel.setLayout(ConfirmationPanelLayout);
        ConfirmationPanelLayout.setHorizontalGroup(ConfirmationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ConfirmationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.StatusMessagelbl, -2, 410, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Okbtn, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelBtn, -2, 64, -2).addContainerGap(19, Short.MAX_VALUE)));
        ConfirmationPanelLayout.setVerticalGroup(ConfirmationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ConfirmationPanelLayout.createSequentialGroup().addGroup(ConfirmationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelBtn).addComponent(this.Okbtn)).addGap(0, 10, Short.MAX_VALUE)).addComponent(this.StatusMessagelbl, -1, -1, Short.MAX_VALUE));
        this.MainTab.setToolTipText("");
        this.SupportFormatPanel.setBorder(BorderFactory.createTitledBorder(null, "Supported Formats", 1, 0, null, new Color(0, 0, 255)));
        this.SupportFormatPanel.setToolTipText("Select format source. Deep-Editor don't select this option automatically. It has to be introduced by user");
        this.supportlocal_group.add(this.ose_localbutton);
        this.ose_localbutton.setText("OSE2000");
        this.ose_localbutton.setName("OSE2000");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${!selected}"), (Object)this.ose_localbutton, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.supportlocal_group.add(this.pcp_localbutton);
        this.pcp_localbutton.setText("PCP");
        this.pcp_localbutton.setToolTipText("");
        this.pcp_localbutton.setName("PCP");
        this.supportlocal_group.add(this.plexos_localbutton);
        this.plexos_localbutton.setText("PLEXOS");
        this.plexos_localbutton.setActionCommand("PLEXOS_ST");
        this.plexos_localbutton.setName("PLEXOS_ST");
        this.supportlocal_group.add(this.plp_localbutton);
        this.plp_localbutton.setSelected(true);
        this.plp_localbutton.setText("PLP");
        this.plp_localbutton.setToolTipText("PLP result files");
        this.plp_localbutton.setName("PLP");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${!selected}"), (Object)this.plp_localbutton, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.plp_localbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.plp_localbuttonActionPerformed(evt);
            }
        });
        this.supportlocal_group.add(this.pet_localbutton);
        this.pet_localbutton.setText("PET");
        this.pet_localbutton.setName("PET");
        GroupLayout SupportFormatPanelLayout = new GroupLayout(this.SupportFormatPanel);
        this.SupportFormatPanel.setLayout(SupportFormatPanelLayout);
        SupportFormatPanelLayout.setHorizontalGroup(SupportFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SupportFormatPanelLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(SupportFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pet_localbutton).addComponent(this.ose_localbutton).addComponent(this.pcp_localbutton).addComponent(this.plexos_localbutton).addComponent(this.plp_localbutton)).addContainerGap(60, Short.MAX_VALUE)));
        SupportFormatPanelLayout.setVerticalGroup(SupportFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SupportFormatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plp_localbutton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ose_localbutton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcp_localbutton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plexos_localbutton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pet_localbutton).addContainerGap(35, Short.MAX_VALUE)));
        this.plexos_localbutton.getAccessibleContext().setAccessibleName("PLEXOS_ST");
        this.SourcePanel.setBorder(BorderFactory.createTitledBorder(null, "Local Folder Source", 0, 0, null, Color.blue));
        this.jLabel1.setText("Folder:");
        this.LocalSourcetxt.setEditable(false);
        this.LocalSourcetxt.setText("Complete path to external source files...");
        this.LocalSourcetxt.setToolTipText("Introduce complete path to external source root folder");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${!selected}"), (Object)this.LocalSourcetxt, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.BrowseInputFolder.setText("Browse");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${!selected}"), (Object)this.BrowseInputFolder, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.BrowseInputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.BrowseInputFolderActionPerformed(evt);
            }
        });
        this.txtCurrentCase.setEditable(false);
        this.txtCurrentCase.setForeground(new Color(0, 51, 204));
        this.txtCurrentCase.setText(EMPTY);
        this.txtCurrentCase.setToolTipText("Introduce complete path to external source root folder");
        this.txtCurrentCase.setBorder(null);
        this.jLabel3.setText("Current:");
        GroupLayout SourcePanelLayout = new GroupLayout(this.SourcePanel);
        this.SourcePanel.setLayout(SourcePanelLayout);
        SourcePanelLayout.setHorizontalGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SourcePanelLayout.createSequentialGroup().addContainerGap().addGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3, -2, 51, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtCurrentCase).addGroup(SourcePanelLayout.createSequentialGroup().addComponent(this.LocalSourcetxt, -2, 345, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.BrowseInputFolder))).addContainerGap(25, Short.MAX_VALUE)));
        SourcePanelLayout.setVerticalGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SourcePanelLayout.createSequentialGroup().addContainerGap().addGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.LocalSourcetxt, -2, -1, -2).addComponent(this.BrowseInputFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(SourcePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCurrentCase, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        this.TimeControlPanel.setBorder(BorderFactory.createTitledBorder(null, "Time Control", 0, 0, null, Color.blue));
        this.lblLocalDataFrom.setText("Data From:");
        this.DateFromlbl.setForeground(new Color(128, 128, 128));
        this.DateFromlbl.setText("dd/mm/yyyy");
        this.lblLocalDateTo.setText("Data To:");
        this.DateTolbl.setForeground(new Color(128, 128, 128));
        this.DateTolbl.setText("dd/mm/yyyy");
        this.TimeControlLocaltbl.setModel(new DefaultTableModel(new Object[][]{{"Hour", "1"}, {"Day", "1"}, {"Month", "1"}, {"Year", "2016"}, {"Stage", "1"}, {"Block", "1"}, {"Simulation", "1"}}, new String[]{"Parameter", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.TimeControlLocaltbl.setToolTipText("<html>Select dispatch (or case) data: <br>\n- PLP: User needs to introduce STAGE (ie. etapa in PLP) and SIM (ie. hidrologia in PLP). HOUR, DAY, MONTH, YEAR will be ignored.  <br>\n- OSE2000: User needs to define YEAR, MONTH, STAGE (ie. bloque in OSE) and SIM (ie. hidrologia in OSE). HOUR, DAY will be ignored.  <br>\n- PCP: User needs to define DAY, HOUR AND SIM (ie. bloque in OSE) and SIM (ie. hidrologia in OSE). HOUR, DAY will be ignored.  <br>\n- PLEXOS:  User needs to define HOUR, DAY, MONTH AND YEAR. STAGE and SIM are going to be ignored (it is expected deterministic solution from PLEXOS) <br>\n- PET: User needs to define BLOCK (bloque), STAGE (periodo), YEAR (agno) and SIM (hidrologia).\n</html>");
        this.TimeControlLocaltbl.setName("Time Control for Local Files");
        this.TimeControlLocaltbl.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.TimeControlLocaltbl);
        GroupLayout TimeControlPanelLayout = new GroupLayout(this.TimeControlPanel);
        this.TimeControlPanel.setLayout(TimeControlPanelLayout);
        TimeControlPanelLayout.setHorizontalGroup(TimeControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TimeControlPanelLayout.createSequentialGroup().addContainerGap().addGroup(TimeControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocalDataFrom).addComponent(this.DateFromlbl).addComponent(this.lblLocalDateTo).addComponent(this.DateTolbl)).addGap(27, 27, 27).addComponent(this.jScrollPane1, -2, 226, -2).addContainerGap(-1, Short.MAX_VALUE)));
        TimeControlPanelLayout.setVerticalGroup(TimeControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TimeControlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblLocalDataFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DateFromlbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLocalDateTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DateTolbl).addContainerGap(-1, Short.MAX_VALUE)).addGroup(TimeControlPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addContainerGap()));
        GroupLayout LocalTabLayout = new GroupLayout(this.LocalTab);
        this.LocalTab.setLayout(LocalTabLayout);
        LocalTabLayout.setHorizontalGroup(LocalTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LocalTabLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(LocalTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(LocalTabLayout.createSequentialGroup().addComponent(this.SupportFormatPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.TimeControlPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.SourcePanel, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
        LocalTabLayout.setVerticalGroup(LocalTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LocalTabLayout.createSequentialGroup().addContainerGap().addComponent(this.SourcePanel, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LocalTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SupportFormatPanel, -1, -1, Short.MAX_VALUE).addComponent(this.TimeControlPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(90, Short.MAX_VALUE)));
        this.MainTab.addTab("Local", this.LocalTab);
        this.SupportServerFormatPanel.setBorder(BorderFactory.createTitledBorder(null, "Supported Formats", 1, 0, null, new Color(0, 0, 255)));
        this.SupportServerFormatPanel.setToolTipText("Supported formats: PCP and PLEXOS only");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.SupportServerFormatPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.supportserver_group.add(this.ose_serverbtn);
        this.ose_serverbtn.setText("OSE2000");
        this.ose_serverbtn.setEnabled(false);
        this.ose_serverbtn.setName("OSE2000");
        this.supportserver_group.add(this.pcp_serverbtn);
        this.pcp_serverbtn.setSelected(true);
        this.pcp_serverbtn.setText("PCP");
        this.pcp_serverbtn.setName("PCP");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.pcp_serverbtn, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.supportserver_group.add(this.plexos_serverbtn);
        this.plexos_serverbtn.setText("PLEXOS");
        this.plexos_serverbtn.setActionCommand("PLEXOS_ST");
        this.plexos_serverbtn.setName("PLEXOS_ST");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.plexos_serverbtn, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.supportserver_group.add(this.plp_serverbtn);
        this.plp_serverbtn.setText("PLP");
        this.plp_serverbtn.setToolTipText("");
        this.plp_serverbtn.setEnabled(false);
        this.plp_serverbtn.setName("PLP");
        this.plp_serverbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.plp_serverbtnActionPerformed(evt);
            }
        });
        GroupLayout SupportServerFormatPanelLayout = new GroupLayout(this.SupportServerFormatPanel);
        this.SupportServerFormatPanel.setLayout(SupportServerFormatPanelLayout);
        SupportServerFormatPanelLayout.setHorizontalGroup(SupportServerFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SupportServerFormatPanelLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(SupportServerFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ose_serverbtn).addComponent(this.pcp_serverbtn).addComponent(this.plexos_serverbtn).addComponent(this.plp_serverbtn)).addContainerGap(60, Short.MAX_VALUE)));
        SupportServerFormatPanelLayout.setVerticalGroup(SupportServerFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SupportServerFormatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plp_serverbtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ose_serverbtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcp_serverbtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plexos_serverbtn).addContainerGap(21, Short.MAX_VALUE)));
        this.plexos_serverbtn.getAccessibleContext().setAccessibleName("PLEXOS_ST");
        this.DBSourcePanel.setBorder(BorderFactory.createTitledBorder(null, "Available Cases in Database", 0, 0, null, Color.blue));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.DBSourcePanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.LoadCasesbtn.setText("Retrieve Cases");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.LoadCasesbtn, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.LoadCasesbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.LoadCasesbtnActionPerformed(evt);
            }
        });
        this.RetrieveCaseslServertbl.setAutoCreateRowSorter(true);
        this.RetrieveCaseslServertbl.setModel(new DefaultTableModel(new Object[0][], new String[]{"System", "ID_Case", "DateFrom", "Date To"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.RetrieveCaseslServertbl.setToolTipText("<html>\nAvailable cases in Server <br>\nClick on Configure DB to configure the server <br>\nClick on Retrieve Cases to populate with information in server <br>\n</html>");
        this.RetrieveCaseslServertbl.setName("Server Available Cases");
        this.RetrieveCaseslServertbl.getTableHeader().setReorderingAllowed(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.RetrieveCaseslServertbl, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane3.setViewportView(this.RetrieveCaseslServertbl);
        this.ClearServerTablebtn.setText("Clear");
        this.ClearServerTablebtn.setEnabled(false);
        this.ClearServerTablebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.ClearServerTablebtnActionPerformed(evt);
            }
        });
        GroupLayout DBSourcePanelLayout = new GroupLayout(this.DBSourcePanel);
        this.DBSourcePanel.setLayout(DBSourcePanelLayout);
        DBSourcePanelLayout.setHorizontalGroup(DBSourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DBSourcePanelLayout.createSequentialGroup().addGroup(DBSourcePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, DBSourcePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.ClearServerTablebtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LoadCasesbtn)).addGroup(GroupLayout.Alignment.LEADING, DBSourcePanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jScrollPane3, -2, 478, -2))).addContainerGap(21, Short.MAX_VALUE)));
        DBSourcePanelLayout.setVerticalGroup(DBSourcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DBSourcePanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(DBSourcePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ClearServerTablebtn).addComponent(this.LoadCasesbtn)).addGap(6, 6, 6)));
        this.TimeControlServerPanel.setBorder(BorderFactory.createTitledBorder(null, "Time Control", 0, 0, null, Color.blue));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.TimeControlServerPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.lblServDataFrom.setText("Data From:");
        this.DateServerFromlbl.setForeground(new Color(128, 128, 128));
        this.DateServerFromlbl.setText("dd/mm/yyyy");
        this.lblServDataTo.setText("Data To:");
        this.DateServerTolbl.setForeground(new Color(128, 128, 128));
        this.DateServerTolbl.setText("dd/mm/yyyy");
        this.TimeControlServertbl.setModel(new DefaultTableModel(new Object[][]{{"Hour", new Integer(1)}, {"Day", new Integer(1)}, {"Month", new Integer(1)}, {"Year", new Integer(2013)}, {"Stage", new Integer(1)}}, new String[]{"Parameter", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.TimeControlServertbl.setToolTipText("<html>Select dispatch (or case) data: <br>\n- PCP: User needs to define DAY, HOUR AND SIM (ie. bloque in OSE) and SIM (ie. hidrologia in OSE). HOUR, DAY will be ignored.  <br>\n- PLEXOS:  User needs to define HOUR, DAY, MONTH AND YEAR. STAGE and SIM are going to be ignored (it is expected deterministic solution from PLEXOS)\n</html>");
        this.TimeControlServertbl.setAutoscrolls(false);
        this.TimeControlServertbl.setName("Time Control for Server");
        this.TimeControlServertbl.getTableHeader().setReorderingAllowed(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.TimeControlServertbl, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane2.setViewportView(this.TimeControlServertbl);
        GroupLayout TimeControlServerPanelLayout = new GroupLayout(this.TimeControlServerPanel);
        this.TimeControlServerPanel.setLayout(TimeControlServerPanelLayout);
        TimeControlServerPanelLayout.setHorizontalGroup(TimeControlServerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TimeControlServerPanelLayout.createSequentialGroup().addContainerGap().addGroup(TimeControlServerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblServDataFrom).addComponent(this.DateServerFromlbl).addComponent(this.lblServDataTo).addComponent(this.DateServerTolbl)).addGap(18, 18, 18).addComponent(this.jScrollPane2, -2, 226, -2).addContainerGap(-1, Short.MAX_VALUE)));
        TimeControlServerPanelLayout.setVerticalGroup(TimeControlServerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TimeControlServerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblServDataFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DateServerFromlbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblServDataTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DateServerTolbl).addContainerGap(36, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE));
        this.ExternalDBChk.setText("Retrieve from external source (database)");
        this.ExternalDBChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.ExternalDBChkActionPerformed(evt);
            }
        });
        this.ConfigDBbtn.setText("Configure BD");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.ExternalDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.ConfigDBbtn, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.ConfigDBbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.ConfigDBbtnActionPerformed(evt);
            }
        });
        GroupLayout ServerTabLayout = new GroupLayout(this.ServerTab);
        this.ServerTab.setLayout(ServerTabLayout);
        ServerTabLayout.setHorizontalGroup(ServerTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ServerTabLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(ServerTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(ServerTabLayout.createSequentialGroup().addComponent(this.ExternalDBChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ConfigDBbtn)).addGroup(ServerTabLayout.createSequentialGroup().addComponent(this.SupportServerFormatPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.TimeControlServerPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.DBSourcePanel, -2, -1, -2)).addContainerGap(29, Short.MAX_VALUE)));
        ServerTabLayout.setVerticalGroup(ServerTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ServerTabLayout.createSequentialGroup().addContainerGap().addGroup(ServerTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ExternalDBChk).addComponent(this.ConfigDBbtn)).addGap(7, 7, 7).addComponent(this.DBSourcePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ServerTabLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.SupportServerFormatPanel, -2, -1, -2).addComponent(this.TimeControlServerPanel, -2, -1, -2)).addContainerGap()));
        this.MainTab.addTab("Server", this.ServerTab);
        this.OutputFilePanel.setBorder(BorderFactory.createTitledBorder(null, "Log File Location", 0, 0, null, Color.blue));
        this.jLabel6.setText("Folder:");
        this.OutputFoldertxt.setText("Complete path to output files...");
        this.BrowseOutputFolder.setText("Browse");
        this.BrowseOutputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.BrowseOutputFolderActionPerformed(evt);
            }
        });
        GroupLayout OutputFilePanelLayout = new GroupLayout(this.OutputFilePanel);
        this.OutputFilePanel.setLayout(OutputFilePanelLayout);
        OutputFilePanelLayout.setHorizontalGroup(OutputFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OutputFilePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addGap(27, 27, 27).addComponent(this.OutputFoldertxt, -2, 345, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.BrowseOutputFolder).addContainerGap(23, Short.MAX_VALUE)));
        OutputFilePanelLayout.setVerticalGroup(OutputFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OutputFilePanelLayout.createSequentialGroup().addContainerGap().addGroup(OutputFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.OutputFoldertxt, -2, -1, -2).addComponent(this.BrowseOutputFolder)).addContainerGap(-1, Short.MAX_VALUE)));
        this.SchematicPanel.setBorder(BorderFactory.createTitledBorder(null, "Schematic", 0, 0, null, new Color(0, 0, 255)));
        this.schematic_group.add(this.CurrentSchematicbtn);
        this.CurrentSchematicbtn.setSelected(true);
        this.CurrentSchematicbtn.setText("Use Current Schematic");
        this.schematic_group.add(this.DBSchematicbtn);
        this.DBSchematicbtn.setText("Use Schematic from DeepDB.db");
        this.UpdateDBChk.setText("Update DeepDB.db with schematic");
        this.UpdateDBChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.UpdateDBChkActionPerformed(evt);
            }
        });
        this.UpdateDeepEditDB.setText("Update");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.UpdateDBChk, (Property)ELProperty.create((String)"${selected}"), (Object)this.UpdateDeepEditDB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.UpdateDeepEditDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualImportFrame.this.UpdateDeepEditDBActionPerformed(evt);
            }
        });
        GroupLayout SchematicPanelLayout = new GroupLayout(this.SchematicPanel);
        this.SchematicPanel.setLayout(SchematicPanelLayout);
        SchematicPanelLayout.setHorizontalGroup(SchematicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SchematicPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(SchematicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SchematicPanelLayout.createSequentialGroup().addComponent(this.UpdateDBChk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.UpdateDeepEditDB)).addGroup(SchematicPanelLayout.createSequentialGroup().addComponent(this.CurrentSchematicbtn).addGap(61, 61, 61).addComponent(this.DBSchematicbtn))).addContainerGap(-1, Short.MAX_VALUE)));
        SchematicPanelLayout.setVerticalGroup(SchematicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SchematicPanelLayout.createSequentialGroup().addGroup(SchematicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CurrentSchematicbtn).addComponent(this.DBSchematicbtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addGroup(SchematicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UpdateDBChk).addComponent(this.UpdateDeepEditDB)).addContainerGap()));
        GroupLayout OutputTabLayout = new GroupLayout(this.OutputTab);
        this.OutputTab.setLayout(OutputTabLayout);
        OutputTabLayout.setHorizontalGroup(OutputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(OutputTabLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(OutputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SchematicPanel, -1, -1, Short.MAX_VALUE).addComponent(this.OutputFilePanel, -1, -1, Short.MAX_VALUE)).addContainerGap(29, Short.MAX_VALUE)));
        OutputTabLayout.setVerticalGroup(OutputTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, OutputTabLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.SchematicPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.OutputFilePanel, -2, -1, -2).addGap(158, 158, 158)));
        this.MainTab.addTab("Output", this.OutputTab);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfirmationPanel, -2, -1, -2).addComponent(this.MainTab, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.MainTab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfirmationPanel, -2, -1, -2)));
        this.bindingGroup.bind();
        this.pack();
    }

    private void UpdateDBChkActionPerformed(ActionEvent evt) {
    }

    private void UpdateDeepEditDBActionPerformed(ActionEvent evt) {
        if (!DeepEdit.getActiveSchematic().getComponents().isEmpty()) {
            try {
                this.setVisible(false);
                this.myDeepEdit.UserWantsSaveDatabase();
                this.setVisible(true);
                this.setStatusMessage("Finished saving Schematic into DeepEdit database");
            }
            catch (Exception e) {
                this.setStatusMessage("Error connecting to the database. Current schematic not loaded to DeedEdit database.  " + e.getMessage());
                JOptionPane.showMessageDialog(this, "Error connecting to the DeepEdit 'DeepDB.db' database " + e.getMessage(), "Database connection error", 0);
            }
        } else {
            this.setStatusMessage("Not valid Schematic. Nothing to save");
        }
    }

    private void BrowseOutputFolderActionPerformed(ActionEvent evt) {
        String InputFolder = this.GetChooserFile();
        if (InputFolder != null) {
            this.OutputFoldertxt.setText(InputFolder);
        }
    }

    private void CancelBtnActionPerformed(ActionEvent evt) {
        this.UserWantsToExit();
    }

    private void OkbtnActionPerformed(ActionEvent evt) {
        this.UserWantsExecute();
    }

    private void plp_serverbtnActionPerformed(ActionEvent evt) {
    }

    private void ExternalDBChkActionPerformed(ActionEvent evt) {
    }

    private void ConfigDBbtnActionPerformed(ActionEvent evt) {
        Window parentWindow = SwingUtilities.windowForComponent(this.ConfigDBbtn);
        VisualImportDBJDialog mydbframe = new VisualImportDBJDialog(this, true);
        mydbframe.setLocationRelativeTo(parentWindow);
        mydbframe.setVisible(true);
    }

    private void BrowseInputFolderActionPerformed(ActionEvent evt) {
        String InputFolder = this.GetChooserFile();
        if (InputFolder != null) {
            this.LocalSourcetxt.setText(InputFolder);
        }
    }

    private void plp_localbuttonActionPerformed(ActionEvent evt) {
    }

    private void LoadCasesbtnActionPerformed(ActionEvent evt) {
        ArrayList myCases = null;
        this.setStatusMessage("Initializing connection to database " + this.getNamedb_smme() + ". Please wait...");
        this.RetrieveCaseslServertbl.selectAll();
        this.RetrieveCaseslServertbl.clearSelection();
        try {
            myCases = this.myVisualImport.RetreiveDBCases();
        }
        catch (SQLException e) {
            this.setStatusMessage("Error connecting to the database " + this.getNamedb_smme() + e.getMessage());
            JOptionPane.showMessageDialog(this, "Error connecting to the database " + this.getNamedb_smme() + System.getProperty("line.separator") + "Executing query: " + e.getSQLState(), "Database connection error", 0);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this, "Unexpected error parsing dates in database " + this.getNamedb_smme() + System.getProperty("line.separator") + e.getMessage(), "Database connection error", 0);
            this.setStatusMessage("Unexpected error parsing dates in database " + this.getNamedb_smme() + e.getMessage());
        }
        if (myCases != null) {
            for (Object myCase : myCases) {
                String lineCase = (String)myCase;
                Object[] splitlineCase = lineCase.split(",");
                DefaultTableModel defaultModel = (DefaultTableModel)this.RetrieveCaseslServertbl.getModel();
                defaultModel.addRow(splitlineCase);
            }
            this.ClearServerTablebtn.setEnabled(true);
            this.setStatusMessage("Connection successful. Total retrieved Cases: " + myCases.size());
        }
    }

    private void ClearServerTablebtnActionPerformed(ActionEvent evt) {
        DefaultTableModel defaultModel = (DefaultTableModel)this.RetrieveCaseslServertbl.getModel();
        for (int i = defaultModel.getRowCount() - 1; i >= 0; --i) {
            defaultModel.removeRow(i);
        }
        this.ClearServerTablebtn.setEnabled(false);
        this.setStatusMessage("Select source...");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.UserWantsToExit();
    }

    public void retrieveCasesServertblvalueChanged(ListSelectionEvent evt) {
        if (this.RetrieveCaseslServertbl.getRowCount() < 1 || this.RetrieveCaseslServertbl.getSelectedRowCount() != 1) {
            return;
        }
        String dateIni = this.RetrieveCaseslServertbl.getValueAt(this.RetrieveCaseslServertbl.getSelectedRow(), 2).toString();
        this.DateServerFromlbl.setText(dateIni);
        Date parsedIniDate = null;
        SimpleDateFormat myFormatyyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            parsedIniDate = myFormatyyyy_mm_dd.parse(dateIni);
        }
        catch (ParseException e) {
            this.setStatusMessage("Unexpected error parsing dates of selected case. Check values in 'Date From' and 'Date To' columns");
        }
        Calendar myCalendarIni = Calendar.getInstance();
        myCalendarIni.setTime(parsedIniDate);
        this.setTimeControlValues(myCalendarIni, this.TimeControlServertbl);
        this.DateServerTolbl.setText(this.RetrieveCaseslServertbl.getValueAt(this.RetrieveCaseslServertbl.getSelectedRow(), 3).toString());
    }

    private String GetChooserFile() throws HeadlessException {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle(this.getTitle());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void setStatusMessage(String msg) {
        this.StatusMessagelbl.setText(msg);
        this.StatusMessagelbl.setToolTipText(msg);
        this.repaint();
    }

    private int getLocalHour(JTable InputTable) {
        int hour = 1;
        try {
            hour = InputTable.equals(this.TimeControlLocaltbl) ? Integer.valueOf(this.TimeControlLocaltbl.getValueAt(0, 1).toString()).intValue() : Integer.valueOf(this.TimeControlServertbl.getValueAt(0, 1).toString()).intValue();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + " Not a valid hour entry ", "Input error", 0);
        }
        return hour;
    }

    private String getTblEntry(JTable InputTable, int row) {
        if (InputTable.equals(this.TimeControlLocaltbl)) {
            return this.TimeControlLocaltbl.getValueAt(row, 1).toString();
        }
        return this.TimeControlServertbl.getValueAt(row, 1).toString();
    }

    private int getLocalDay(JTable InputTable) {
        int day = 1;
        try {
            day = InputTable.equals(this.TimeControlLocaltbl) ? Integer.valueOf(this.TimeControlLocaltbl.getValueAt(1, 1).toString()).intValue() : Integer.valueOf(this.TimeControlServertbl.getValueAt(1, 1).toString()).intValue();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + " Not a valid day entry ", "Input error", 0);
        }
        return day;
    }

    private int getLocalMonth(JTable InputTable) {
        int month = 1;
        try {
            month = InputTable.equals(this.TimeControlLocaltbl) ? Integer.valueOf(this.TimeControlLocaltbl.getValueAt(2, 1).toString()).intValue() : Integer.valueOf(this.TimeControlServertbl.getValueAt(2, 1).toString()).intValue();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + " Not a valid month entry ", "Input error", 0);
        }
        return month;
    }

    private int getLocalYear(JTable InputTable) throws NumberFormatException {
        int year = 2013;
        year = InputTable.equals(this.TimeControlLocaltbl) ? Integer.valueOf(this.TimeControlLocaltbl.getValueAt(3, 1).toString()).intValue() : Integer.valueOf(this.TimeControlServertbl.getValueAt(3, 1).toString()).intValue();
        return year;
    }

    private int getLocalStage(JTable InputTable) throws NumberFormatException {
        int stage = 1;
        stage = InputTable.equals(this.TimeControlLocaltbl) ? Integer.valueOf(this.TimeControlLocaltbl.getValueAt(4, 1).toString()).intValue() : Integer.valueOf(this.TimeControlServertbl.getValueAt(4, 1).toString()).intValue();
        return stage;
    }

    private int getLocalSim(JTable InputTable) throws NumberFormatException {
        int sim = 1;
        if (InputTable.equals(this.TimeControlLocaltbl)) {
            sim = Integer.valueOf(this.TimeControlLocaltbl.getValueAt(5, 1).toString());
        } else assert (false) : "Reading simulation from server is not implemented!!!";
        return sim;
    }

    private int getSelectedId_Case() {
        int id_case = 1;
        String strId_Case = "";
        try {
            strId_Case = this.RetrieveCaseslServertbl.getValueAt(this.RetrieveCaseslServertbl.getSelectedRow(), 1).toString();
            id_case = Integer.valueOf(strId_Case);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + " There is a corruption in the origin DB. ID_Case " + strId_Case + "couldn't be transformed to Integer", "Input error", 0);
        }
        return id_case;
    }

    private String getTxtFolder(JTextField myJTxt) {
        String sourceFolder = "";
        try {
            sourceFolder = myJTxt.getText();
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + sourceFolder + " is not a valid folder", "Input error", 0);
        }
        return sourceFolder;
    }

    private String getSelectedButtonLabel(ButtonGroup mygroup) {
        Enumeration<AbstractButton> allRadioButton = mygroup.getElements();
        while (allRadioButton.hasMoreElements()) {
            JRadioButton temp = (JRadioButton)allRadioButton.nextElement();
            if (!temp.isSelected() || !temp.isEnabled()) continue;
            String strName = temp.getName();
            if (strName != null) {
                return strName;
            }
            return temp.getText();
        }
        JOptionPane.showMessageDialog(this, "Please select a valid supported format", "Input error", 0);
        return "";
    }

    private boolean isValidSource() {
        if (this.ExternalDBChk.isSelected()) {
            int year;
            int month;
            int day;
            if (this.RetrieveCaseslServertbl.getRowCount() < 1) {
                this.setStatusMessage("Not a valid Case. First run 'Retrieve cases' from server");
                return false;
            }
            if (this.RetrieveCaseslServertbl.getSelectedRowCount() != 1) {
                this.setStatusMessage("Please select 1 case (and only 1) from cases available");
                return false;
            }
            int hour = this.getLocalHour(this.TimeControlServertbl);
            if (!this.isValidDate(hour, day = this.getLocalDay(this.TimeControlServertbl), month = this.getLocalMonth(this.TimeControlServertbl), year = this.getLocalYear(this.TimeControlServertbl))) {
                this.setStatusMessage("Invalid date set in column " + this.TimeControlServertbl.getColumnName(1) + " in table " + this.TimeControlServertbl.getName());
                return false;
            }
            Calendar setDate = this.convertDateToCalendar(hour, day, month, year);
            Calendar iniDate = this.convertDateToCalendar(this.DateServerFromlbl.getText());
            Calendar endDate = this.convertDateToCalendar(this.DateServerTolbl.getText());
            endDate.add(5, 1);
            if (setDate.compareTo(iniDate) < 0 || setDate.compareTo(endDate) > 0) {
                this.setStatusMessage("Data Error: Introduced Date out of range [" + this.DateServerFromlbl.getText() + " to " + this.DateServerTolbl.getText() + "]");
                return false;
            }
            String sistema = this.RetrieveCaseslServertbl.getValueAt(this.RetrieveCaseslServertbl.getSelectedRow(), 0).toString();
            if (sistema.equals("SING") && !"PLEXOS_ST".equals(this.getSelectedButtonLabel(this.supportserver_group))) {
                this.setStatusMessage("Selected case is not a valid PLEXOS case");
                return false;
            }
            if (sistema.equals("SIC") && !"PCP".equals(this.getSelectedButtonLabel(this.supportserver_group))) {
                this.setStatusMessage("Selected case is not a valid PCP case");
                return false;
            }
        } else {
            String year;
            String sourceFolder = this.getTxtFolder(this.LocalSourcetxt);
            String sourceType = this.getSelectedButtonLabel(this.supportlocal_group);
            DE_GeneralEnums.DispatchSoftware sourceDisp = DE_GeneralEnums.DispatchSoftware.valueOf(sourceType);
            if (sourceType.equals("")) {
                this.setStatusMessage("Select a valid format for local source");
                return false;
            }
            switch (sourceDisp) {
                case PLP: {
                    if (this.isValidLocalDate()) break;
                    this.setStatusMessage("Invalid date set in column " + this.TimeControlLocaltbl.getColumnName(1) + " in table " + this.TimeControlLocaltbl.getName());
                    return false;
                }
                case PET: {
                    break;
                }
                default: {
                    if (this.isValidLocalDate()) break;
                    this.setStatusMessage("Invalid date set in column " + this.TimeControlLocaltbl.getColumnName(1) + " in table " + this.TimeControlLocaltbl.getName());
                    return false;
                }
            }
            if (!VisualImport.isValidSolutionFolder(sourceDisp, sourceFolder, year = this.getTblEntry(this.TimeControlLocaltbl, 3))) {
                this.setStatusMessage("Valid Solution not found for '" + sourceType + "' in selected source folder!");
                return false;
            }
        }
        return true;
    }

    private boolean isValidOutput() {
        if (this.getSelectedButtonLabel(this.schematic_group).equals("")) {
            assert (false) : "How in the world did it get deselected???";
            return false;
        }
        return true;
    }

    private String getSelectedFolder(JTextField myTxtField) {
        String outFolder = this.getTxtFolder(myTxtField);
        if (!AnalysisTool.DirectoryExist(outFolder)) {
            this.setStatusMessage("WARNING: Invalid output folderFolder " + outFolder + ". Default 'result' folder will be used");
            return AnalysisTool.RESULT_FOLDER;
        }
        return outFolder;
    }

    private boolean isValidLocalDate() {
        int hour = this.getLocalHour(this.TimeControlLocaltbl);
        int day = this.getLocalDay(this.TimeControlLocaltbl);
        int month = this.getLocalMonth(this.TimeControlLocaltbl);
        int year = this.getLocalYear(this.TimeControlLocaltbl);
        return this.isValidDate(hour, day, month, year);
    }

    public boolean isValidDate(int hour, int day, int month, int year) {
        Calendar cal = this.convertDateToCalendar(hour, day, month, year);
        return cal.get(11) == hour && cal.get(5) == day && cal.get(2) == month - 1 && cal.get(1) == year;
    }

    public Calendar convertDateToCalendar(int hour, int day, int month, int year) {
        Calendar myCalendar = Calendar.getInstance();
        myCalendar.set(1, year);
        myCalendar.set(2, month - 1);
        myCalendar.set(5, day);
        myCalendar.set(11, hour);
        return myCalendar;
    }

    public Calendar convertDateToCalendar(String dateIn) {
        Date parsedIniDate = null;
        SimpleDateFormat myFormatyyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            parsedIniDate = myFormatyyyy_mm_dd.parse(dateIn);
        }
        catch (ParseException e) {
            this.setStatusMessage("Unexpected error parsing dates of selected case. Check values in 'Date From' and 'Date To' columns");
        }
        Calendar myCalendarIn = Calendar.getInstance();
        myCalendarIn.setTime(parsedIniDate);
        return myCalendarIn;
    }

    private void setTimeControlValues(Calendar cal, JTable myJTable) {
        int hour = 1;
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        try {
            myJTable.setValueAt(hour, 0, 1);
            myJTable.setValueAt(day, 1, 1);
            myJTable.setValueAt(month, 2, 1);
            myJTable.setValueAt(year, 3, 1);
        }
        catch (NullPointerException e) {
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UserWantsExecute() {
        if (this.isValidSource() && this.isValidOutput()) {
            if (this.DBSchematicbtn.isSelected()) {
                this.setStatusMessage("Loading Schematic from DeepDB.db...");
                try {
                    this.myDeepEdit.UserWantsOpenDatabase();
                }
                catch (Exception e) {
                    this.setStatusMessage("Error loading Schematic from DeepDB.db: " + e.getMessage());
                }
                this.setStatusMessage("Finished Loading Schematic from DeepDB.db");
            }
            if (this.ExternalDBChk.isSelected()) {
                this.setStatusMessage("Loading files from server for " + this.getSelectedButtonLabel(this.supportserver_group) + "...");
                String tmplocalfolder = this.getSelectedFolder(this.OutputFoldertxt);
                int tempyear = this.getLocalYear(this.TimeControlServertbl);
                int tempmonth = this.getLocalMonth(this.TimeControlServertbl);
                int tempday = this.getLocalDay(this.TimeControlServertbl);
                int temphour = this.getLocalHour(this.TimeControlServertbl);
                int id_case = this.getSelectedId_Case();
                try {
                    if (this.pcp_serverbtn.isSelected()) {
                        this.myVisualImport.SetDispatchSICfromDB(this.myDeepEdit, tmplocalfolder, this.getTypedb(), this.getHost(), this.getNamedb_dispatch(), this.getUserdb(), this.getPassdb(), temphour, tempday, tempmonth, tempyear, id_case);
                    } else if (this.plexos_serverbtn.isSelected()) {
                        this.myVisualImport.SetDispatchSINGfromDB(this.myDeepEdit, tmplocalfolder, this.getTypedb(), this.getHost(), this.getNamedb_dispatch(), this.getUserdb(), this.getPassdb(), temphour, tempday, tempmonth, tempyear, id_case);
                    } else assert (false) : "How did get here?? Did you modify the GUI???";
                }
                catch (Exception e) {
                    this.setStatusMessage("Error while retrieving data: " + e.getMessage());
                }
                this.setStatusMessage("Finished Loading solution from server successful");
            } else {
                this.setStatusMessage("Loading local files for " + this.getSelectedButtonLabel(this.supportlocal_group) + "...");
                String tmplocalfolder = this.getTxtFolder(this.LocalSourcetxt);
                String tmpoutputfolder = this.getSelectedFolder(this.OutputFoldertxt);
                try {
                    if (this.plp_localbutton.isSelected()) {
                        int tempyear = this.getLocalYear(this.TimeControlLocaltbl);
                        int tempstage = this.getLocalStage(this.TimeControlLocaltbl);
                        int tempsim = this.getLocalSim(this.TimeControlLocaltbl);
                        this.myVisualImport.initDispatch(this.myDeepEdit, tmplocalfolder, tmpoutputfolder, this.plp_localbutton.getText(), 0, 0, 0, tempyear, tempstage, tempsim);
                        this.ShCThread = new Thread((Runnable)this.myVisualImport, "Thread-Calculate");
                        this.ShCThread.start();
                        this.setStatusMessage("Loading solution from local files. Please wait...");
                        return;
                    }
                    if (this.ose_localbutton.isSelected()) {
                        int tempyear = this.getLocalYear(this.TimeControlServertbl);
                        int tempmonth = this.getLocalMonth(this.TimeControlServertbl);
                        int tempstage = this.getLocalStage(this.TimeControlLocaltbl);
                        int tempsim = this.getLocalSim(this.TimeControlLocaltbl);
                        this.myVisualImport.SetDispatchOSE2000(this.myDeepEdit, tmplocalfolder, tmpoutputfolder, tempstage, tempmonth, tempyear, tempsim);
                    } else if (this.pcp_localbutton.isSelected()) {
                        int tempyear = this.getLocalYear(this.TimeControlServertbl);
                        int tempmonth = this.getLocalMonth(this.TimeControlServertbl);
                        int tempday = this.getLocalDay(this.TimeControlServertbl);
                        int temphour = this.getLocalHour(this.TimeControlServertbl);
                        this.myVisualImport.SetDispatchSIC(this.myDeepEdit, tmplocalfolder, tmpoutputfolder, temphour, tempday, tempmonth, tempyear);
                    } else if (this.plexos_localbutton.isSelected()) {
                        int tempyear = this.getLocalYear(this.TimeControlServertbl);
                        int tempmonth = this.getLocalMonth(this.TimeControlServertbl);
                        int tempday = this.getLocalDay(this.TimeControlServertbl);
                        int temphour = this.getLocalHour(this.TimeControlServertbl);
                        this.myVisualImport.SetDispatchSING(this.myDeepEdit, tmplocalfolder, tmpoutputfolder, temphour, tempday, tempmonth, tempyear);
                    } else {
                        if (this.pet_localbutton.isSelected()) {
                            String[] files = new String[]{tmplocalfolder};
                            this.myVisualImport.initDispatch(files, DE_GeneralEnums.DispatchSoftware.PET, this.getTblEntry(this.TimeControlLocaltbl, 3), null, null, null, this.getTblEntry(this.TimeControlLocaltbl, 4), this.getTblEntry(this.TimeControlLocaltbl, 5), this.getTblEntry(this.TimeControlLocaltbl, 6));
                            this.ShCThread = new Thread((Runnable)this.myVisualImport, "Thread-Calculate");
                            this.ShCThread.start();
                            this.setStatusMessage("Loading PET solution from local files. Please wait...");
                            return;
                        }
                        assert (false) : "How did get here?? Did you modify the GUI???";
                    }
                    this.setStatusMessage("Finished Loading solution from local files");
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage() + " Not a valid DATE entry ", "Input error", 0);
                    this.setStatusMessage("Calidation Error: Invalid selected date " + e.getMessage());
                }
                catch (Exception e) {
                    this.setStatusMessage("Error while retrieving data: " + e.getMessage());
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    private void UserWantsToExit() {
        if (this.ShCThread != null && this.ShCThread.isAlive()) {
            int resp = JOptionPane.showConfirmDialog(this, "Are you sure you want to interrupt loading?", "Unsafe Interruption", 2);
            if (resp == 0) {
                this.setStatusMessage("Loading interrupted...");
                System.out.println("Loading interrupted...");
                this.ShCThread.stop();
                this.dispose();
            }
            return;
        }
        this.dispose();
    }
}

