/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Trafo;
import de.core.VVVisual;
import de.core.comp;
import de.core.ndb_comp;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class VVVisualFrame
extends Frame
implements KeyListener,
ActionListener,
ItemListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoicename = null;
    Choice MyChoicecriteria = null;
    VVVisual MyVVV = null;
    Button button1;
    Button button2;
    comp TempComponent;
    ndb_comp Tempndb;
    int entryp = 0;
    int exitp = 0;
    int entrym = 0;
    int exitm = 0;
    double gLP_SYS = 0.0;
    double gLP_NS = 0.0;
    double gLP_USP_MS_NS = 0.0;
    double gLP_MS = 0.0;
    double gLP_USP_HS_MS = 0.0;
    double gLP_HS = 0.0;
    double gLP_USP_HOS_HS = 0.0;
    double gLP_HOS = 0.0;
    double LP_SYS = 0.0;
    double LP_NS = 0.0;
    double LP_USP_MS_NS = 0.0;
    double LP_MS = 0.0;
    double LP_USP_HS_MS = 0.0;
    double LP_HS = 0.0;
    double LP_USP_HOS_HS = 0.0;
    double LP_HOS = 0.0;

    public VVVisualFrame(VVVisual aVisual) {
        super("VV visualization parameters");
        this.setBackground(Color.lightGray);
        this.MyVVV = aVisual;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "VERBAENDEVEREINBARUNG VISUALIZATION", gridbag, c, Color.blue);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicename = new Choice();
        this.MyChoicecriteria = new Choice();
        for (int ix = 0; ix < this.MyVVV.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MyVVV.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !(this.TempComponent instanceof Load)) continue;
            this.MyChoicename.addItem(this.TempComponent.getName());
        }
        this.MyChoicecriteria.addItem("Load");
        this.MyChoicecriteria.addItem("Generator");
        gridbag.setConstraints(this.MyChoicename, c);
        gridbag.setConstraints(this.MyChoicecriteria, c);
        this.MyChoicecriteria.addItemListener(this);
        this.add(this.MyChoicename);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicecriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Visualization of the percentage of payment from the", gridbag, c, Color.black);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "selected component for each line or transformer.", gridbag, c, Color.black);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button1 = new Button("Show");
        button1.setActionCommand("Show");
        button1.addActionListener(this);
        gridbag.setConstraints(button1, c);
        this.add(button1);
        Button button2 = new Button("Exit");
        button2.setActionCommand("Exit");
        button2.addActionListener(this);
        gridbag.setConstraints(button2, c);
        this.add(button2);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                VVVisualFrame.this.setVisible(false);
                VVVisualFrame.this.dispose();
                try {
                    VVVisualFrame.this.MyVVV.MyColorSpec.setVisible(false);
                    VVVisualFrame.this.MyVVV.MyColorSpec.dispose();
                    VVVisualFrame.this.MyVVV.closeVV();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                VVVisualFrame.this.MyVVV.MyVVVisualFrame = null;
            }
        });
        this.setIconImage(this.MyVVV.ActFrame.applet.getFrameIconImage());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            try {
                this.MyVVV.MyColorSpec.setVisible(false);
                this.MyVVV.MyColorSpec.dispose();
                this.MyVVV.closeVV();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.MyVVV.MyVVVisualFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        this.refreshchoice(this.MyChoicecriteria.getSelectedItem());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                try {
                    this.MyVVV.MyColorSpec.setVisible(false);
                    this.MyVVV.MyColorSpec.dispose();
                    this.MyVVV.closeVV();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.MyVVV.MyVVVisualFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else {
                try {
                    this.visualization(this.MyChoicename.getSelectedItem(), this.MyChoicecriteria.getSelectedItem());
                    DeepEdit.MySchematicPanel.repaint();
                    this.repaint();
                }
                catch (Exception e) {
                    System.out.println("Exception in actioperformed");
                }
            }
        }
    }

    public void visualization(String nombre, String modelo) throws SQLException {
        String query;
        double auxf = 0.0;
        int lauf = 0;
        double auxf1 = 0.0;
        double auxf2 = 0.0;
        double auxf3 = 0.0;
        double auxf4 = 0.0;
        double auxf5 = 0.0;
        double auxf6 = 0.0;
        double auxf7 = 0.0;
        double auxf8 = 0.0;
        double auxf9 = 0.0;
        this.gLP_SYS = 0.0;
        this.gLP_NS = 0.0;
        this.gLP_USP_MS_NS = 0.0;
        this.gLP_MS = 0.0;
        this.gLP_USP_HS_MS = 0.0;
        this.gLP_HS = 0.0;
        this.gLP_USP_HOS_HS = 0.0;
        this.gLP_HOS = 0.0;
        this.LP_SYS = 0.0;
        this.LP_NS = 0.0;
        this.LP_USP_MS_NS = 0.0;
        this.LP_MS = 0.0;
        this.LP_USP_HS_MS = 0.0;
        this.LP_HS = 0.0;
        this.LP_USP_HOS_HS = 0.0;
        this.LP_HOS = 0.0;
        Statement stmt = DeepEditFrame.conVV.createStatement();
        ResultSet rs = stmt.executeQuery(query = "SELECT * FROM Results");
        boolean more = rs.next();
        if (!more) {
            System.out.println("No Contract found in VVVisual.");
            return;
        }
        if (modelo.equals("Load")) {
            while (more) {
                this.entryp = rs.getInt("entry_period");
                this.exitp = rs.getInt("exit_period");
                this.entrym = rs.getInt("entrymon");
                this.exitm = rs.getInt("exitmon");
                lauf = this.checktime(this.MyVVV.ActSchematic.getactperiod());
                if (lauf > 0) {
                    auxf = rs.getDouble("ConPower") * (double)lauf * rs.getDouble("G") / rs.getDouble("lifetime");
                    auxf1 = rs.getDouble("bLP_SYS");
                    auxf2 = rs.getDouble("bLP_NS");
                    auxf3 = rs.getDouble("bLP_USP_MS_NS");
                    auxf4 = rs.getDouble("bLP_MS");
                    auxf5 = rs.getDouble("bLP_USP_HS_MS");
                    auxf6 = rs.getDouble("bLP_HS");
                    auxf7 = rs.getDouble("bLP_USP_HOS_HS");
                    auxf8 = rs.getDouble("bLP_HOS") * rs.getDouble("LP_HOS");
                    auxf9 = rs.getDouble("bLP_Dis") * rs.getDouble("LP_Dis") * (rs.getDouble("Distance") - 100.0);
                    this.gLP_SYS += auxf * auxf1;
                    this.gLP_NS += auxf * auxf2;
                    this.gLP_USP_MS_NS += auxf * auxf3;
                    this.gLP_MS += auxf * auxf4;
                    this.gLP_USP_HS_MS += auxf * auxf5;
                    this.gLP_HS += auxf * auxf6;
                    this.gLP_USP_HOS_HS += auxf * auxf7;
                    this.gLP_HOS += auxf * (auxf8 + auxf9);
                    if (rs.getString("LoadName").equals(nombre)) {
                        this.LP_SYS += auxf * auxf1;
                        this.LP_NS += auxf * auxf2;
                        this.LP_USP_MS_NS += auxf * auxf3;
                        this.LP_MS += auxf * auxf4;
                        this.LP_USP_HS_MS += auxf * auxf5;
                        this.LP_HS += auxf * auxf6;
                        this.LP_USP_HOS_HS += auxf * auxf7;
                        this.LP_HOS += auxf * (auxf8 + auxf9);
                    }
                }
                more = rs.next();
            }
        }
        if (modelo.equals("Generator")) {
            while (more) {
                this.entryp = rs.getInt("entry_period");
                this.exitp = rs.getInt("exit_period");
                this.entrym = rs.getInt("entrymon");
                this.exitm = rs.getInt("exitmon");
                lauf = this.checktime(this.MyVVV.ActSchematic.getactperiod());
                if (lauf > 0) {
                    auxf = rs.getDouble("ConPower") * (double)lauf * rs.getDouble("G") / rs.getDouble("lifetime");
                    auxf1 = rs.getDouble("bLP_SYS");
                    auxf2 = rs.getDouble("bLP_NS");
                    auxf3 = rs.getDouble("bLP_USP_MS_NS");
                    auxf4 = rs.getDouble("bLP_MS");
                    auxf5 = rs.getDouble("bLP_USP_HS_MS");
                    auxf6 = rs.getDouble("bLP_HS");
                    auxf7 = rs.getDouble("bLP_USP_HOS_HS");
                    auxf8 = rs.getDouble("bLP_HOS") * rs.getDouble("LP_HOS");
                    auxf9 = rs.getDouble("bLP_Dis") * rs.getDouble("LP_Dis") * (rs.getDouble("Distance") - 100.0);
                    this.gLP_SYS += auxf * auxf1;
                    this.gLP_NS += auxf * auxf2;
                    this.gLP_USP_MS_NS += auxf * auxf3;
                    this.gLP_MS += auxf * auxf4;
                    this.gLP_USP_HS_MS += auxf * auxf5;
                    this.gLP_HS += auxf * auxf6;
                    this.gLP_USP_HOS_HS += auxf * auxf7;
                    this.gLP_HOS += auxf * (auxf8 + auxf9);
                    if (rs.getString("InjName").equals(nombre)) {
                        this.LP_SYS += auxf * auxf1;
                        this.LP_NS += auxf * auxf2;
                        this.LP_USP_MS_NS += auxf * auxf3;
                        this.LP_MS += auxf * auxf4;
                        this.LP_USP_HS_MS += auxf * auxf5;
                        this.LP_HS += auxf * auxf6;
                        this.LP_USP_HOS_HS += auxf * auxf7;
                        this.LP_HOS += auxf * (auxf8 + auxf9);
                    }
                }
                more = rs.next();
            }
        }
        rs.close();
        stmt.close();
        if (this.LP_SYS != 0.0) {
            this.LP_SYS /= 0.1 * this.gLP_SYS;
        }
        if (this.LP_NS != 0.0) {
            this.LP_NS /= 0.1 * this.gLP_NS;
        }
        if (this.LP_USP_MS_NS != 0.0) {
            this.LP_USP_MS_NS /= 0.1 * this.gLP_USP_MS_NS;
        }
        if (this.LP_MS != 0.0) {
            this.LP_MS /= 0.1 * this.gLP_MS;
        }
        if (this.LP_USP_HS_MS != 0.0) {
            this.LP_USP_HS_MS /= 0.1 * this.gLP_USP_HS_MS;
        }
        if (this.LP_HS != 0.0) {
            this.LP_HS /= 0.1 * this.gLP_HS;
        }
        if (this.LP_USP_HOS_HS != 0.0) {
            this.LP_USP_HOS_HS /= 0.1 * this.gLP_USP_HOS_HS;
        }
        if (this.LP_HOS != 0.0) {
            this.LP_HOS /= 0.1 * this.gLP_HOS;
        }
        for (int ix = 0; ix < this.MyVVV.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MyVVV.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !(this.TempComponent instanceof ndb_comp)) continue;
            this.Tempndb = (ndb_comp)this.TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.gray;
            ndb_comp.Color2 = Color.gray;
            ndb_comp.Color3 = Color.gray;
            if (this.TempComponent instanceof Line || this.TempComponent instanceof Busbar) {
                auxf = this.assignper(this.Tempndb.getun1());
                this.Tempndb.lw = (int)auxf + 1;
                this.Tempndb.setAlternatekv_Color(this.floatToColor(auxf));
                continue;
            }
            if (this.TempComponent instanceof Load && this.TempComponent.getName().equals(nombre)) {
                this.Tempndb.setAlternatekv_Color(this.floatToColor(this.LP_SYS));
                continue;
            }
            if (this.TempComponent instanceof Generator && this.TempComponent.getName().equals(nombre)) {
                this.Tempndb.setAlternatekv_Color(this.floatToColor(this.LP_SYS));
                continue;
            }
            if (this.TempComponent instanceof Trafo) {
                auxf = this.assignper(this.Tempndb.getun1(), this.Tempndb.getun2());
                this.Tempndb.lw = (int)auxf + 1;
                this.Tempndb.setAlternatekv_Color(this.floatToColor(auxf));
                continue;
            }
            this.Tempndb.setAlternatekv_Color(Color.gray);
        }
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    public Color floatToColor(double f) {
        int elec = (int)f;
        Color acolor = Color.gray;
        switch (elec) {
            case 0: {
                acolor = new Color(0, 204, 0);
                break;
            }
            case 1: {
                acolor = new Color(68, 204, 0);
                break;
            }
            case 2: {
                acolor = new Color(102, 204, 0);
                break;
            }
            case 3: {
                acolor = new Color(170, 204, 0);
                break;
            }
            case 4: {
                acolor = new Color(204, 204, 0);
                break;
            }
            case 5: {
                acolor = new Color(204, 170, 0);
                break;
            }
            case 6: {
                acolor = new Color(204, 136, 0);
                break;
            }
            case 7: {
                acolor = new Color(204, 102, 0);
                break;
            }
            case 8: {
                acolor = new Color(204, 68, 0);
                break;
            }
            case 9: {
                acolor = new Color(255, 0, 0);
                break;
            }
            case 10: {
                acolor = new Color(255, 0, 0);
            }
        }
        if (elec > 10) {
            acolor = Color.blue;
        }
        if (f == 0.0) {
            acolor = Color.gray;
        }
        return acolor;
    }

    public void refreshchoice(String crit) {
        this.MyChoicename.removeAll();
        if (crit.equals("Load")) {
            for (int ix = 0; ix < this.MyVVV.ActSchematic.Components.size(); ++ix) {
                this.TempComponent = (comp)this.MyVVV.ActSchematic.Components.elementAt(ix);
                if (!this.TempComponent.getactive() || !(this.TempComponent instanceof Load)) continue;
                this.MyChoicename.addItem(this.TempComponent.getName());
            }
        } else {
            for (int ix = 0; ix < this.MyVVV.ActSchematic.Components.size(); ++ix) {
                this.TempComponent = (comp)this.MyVVV.ActSchematic.Components.elementAt(ix);
                if (!this.TempComponent.getactive() || !(this.TempComponent instanceof Generator)) continue;
                this.MyChoicename.addItem(this.TempComponent.getName());
            }
        }
    }

    public int checktime(int curr) {
        if (curr > this.entryp && curr < this.exitp) {
            return 12;
        }
        if (curr == this.entryp) {
            return 12 - this.entrym + 1;
        }
        if (curr == this.exitp) {
            return this.entrym;
        }
        return 0;
    }

    public double assignper(double un) {
        double per = 0.0;
        if (un >= 0.0 && un <= 1.0) {
            per = this.LP_NS;
        }
        if (un > 1.0 && un <= 60.0) {
            per = this.LP_MS;
        }
        if (un > 60.0 && un <= 150.0) {
            per = this.LP_HS;
        }
        if (un > 150.0) {
            per = this.LP_HOS;
        }
        return per;
    }

    public double assignper(double un, double un2) {
        double per = 0.0;
        if (un > un2) {
            un = un2;
        }
        if (un >= 0.0 && un <= 1.0) {
            per = this.LP_USP_MS_NS;
        }
        if (un > 1.0 && un <= 60.0) {
            per = this.LP_USP_HS_MS;
        }
        if (un > 60.0) {
            per = this.LP_USP_HOS_HS;
        }
        return per;
    }
}

