/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.VV;
import de.core.VVMFrame;
import de.core.comp;
import de.core.mdb_cust;
import de.core.mdb_sup;
import de.core.mdb_wheel;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.data.DE_GeneralEnums;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class VVM
extends AnalysisTool {
    public double LPdis;
    public double GEHSSt;
    public double GEHSLa;
    public double GE20St;
    public double GE20La;
    public double GE10St;
    public double GE10La;
    public double GENSSt;
    public double GENSLa;
    public double LPHOS;
    public double LPHS;
    public double LPMS;
    public double LPNS;
    public double LPUSP_HOS_HS;
    public double LPUSP_HS_MS;
    public double LPUSP_MS_NS;
    public double LPsys;
    public double T1;
    public double G1;
    public double T2;
    public double G2;
    public double T3;
    public double G3;
    VV MyVV = null;
    VVMFrame MyVVMFrame = null;
    public int beg = 0;
    public int end = 0;
    public double power = 0.0;
    public double energy = 0.0;
    protected Vector contracts;
    FileOutputStream os;
    String FileName = "./results/VVM.dat";
    PrintStream myPrintStream;
    mdb_wheel Tempcontract;
    mdb_wheel Tempcontractnew;
    Load Tempload;
    comp TempComponent;
    ndb_inj Tempinj;
    Generator Tempgen;
    DeepEdit applet;
    int connum = 0;

    public VVM(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        if (this.MyVV == null) {
            this.MyVV = new VV(this.ActSchematic);
        }
        if (this.MyVVMFrame == null) {
            this.MyVVMFrame = new VVMFrame(this.MyVV, this);
        } else {
            this.MyVVMFrame.setVisible(true);
        }
    }

    public void Calculate() throws Exception {
        int nummon = (this.end - this.beg + 1) * 12;
        boolean numload = false;
        try {
            this.os = new FileOutputStream(this.FileName);
            this.myPrintStream = new PrintStream(this.os);
            this.myPrintStream.println("--------------------------------------");
            this.myPrintStream.println("Deep-Edit Verb\u0081\u00e4ndevereinbarungsmarkt");
            this.myPrintStream.println("--------------------------------------");
            this.myPrintStream.println(" ");
            this.myPrintStream.println(" ");
            this.myPrintStream.println("System Name             : " + this.ActSchematic.getsysname());
            this.myPrintStream.println("Simulation Time         : " + this.beg + "-" + this.end);
            for (int ix = 1; ix < nummon + 1; ++ix) {
                System.out.println("ciclo " + ix);
                this.contracts = new Vector();
                this.updatecontracts(ix, this.contracts);
                if (!this.checkloads(ix)) {
                    System.out.println("Load " + this.Tempload.getName() + " must have a customer for the whole simulation time!");
                }
                this.contracts = null;
            }
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Verb\u0081\u00e4ndevereinbarungsmarkt main", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.FileName != null) {
            this.DoListResults(this.FileName);
        }
        VVM.closeTLC();
        DeepEdit.MySchematicPanel.repaint();
        DeepEdit.frame.MyVVM = null;
    }

    public void updatecontracts(int mon, Vector cont) {
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof mdb_wheel)) continue;
            this.Tempcontract = (mdb_wheel)this.TempComponent;
            if ((this.beg - this.ActSchematic.getiniperiod()) * 12 + mon < this.Tempcontract.getbeg(this.ActSchematic.getiniperiod()) || (this.beg - this.ActSchematic.getiniperiod()) * 12 + mon > this.Tempcontract.getend(this.ActSchematic.getiniperiod())) continue;
            cont.addElement(this.Tempcontract);
        }
    }

    public boolean checkloads(int mon) throws SQLException {
        int act = this.beg + mon / 12;
        int laufzeit = 0;
        int conbeg = 0;
        int conend = 0;
        boolean check = false;
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof Load)) continue;
            this.Tempload = (Load)this.TempComponent;
            if (this.Tempload.getinv_owner().equals("None")) {
                return false;
            }
            if (this.Tempload.getentry_period() > act || this.Tempload.getexit_period() < act || (check = this.compare(this.Tempload.getName()))) continue;
            laufzeit = this.getlaufzeit(this.Tempload, mon);
            try {
                this.getenergy(this.Tempload, laufzeit, mon);
            }
            catch (Exception e) {
                this.message = e.toString();
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading VVM-Load information", this.message, DlgButtons, 1, 0, 0, 1);
            }
            this.Tempcontractnew = null;
            this.getbestoffer(mon, laufzeit);
            if (this.Tempcontractnew != null) {
                ++this.connum;
                ndb_comp Tempndb = (ndb_comp)this.Tempcontractnew.getparty2();
                Point conpos1 = this.getposload(Tempndb.getName(), Tempndb.getinv_owner());
                this.Tempcontractnew.setx1(conpos1.x);
                this.Tempcontractnew.sety1(conpos1.y);
                Tempndb = (ndb_comp)this.Tempcontractnew.getparty1();
                Point conpos2 = this.getposgen(Tempndb.getName(), Tempndb.getinv_owner());
                this.Tempcontractnew.setx2(conpos2.x);
                this.Tempcontractnew.sety2(conpos2.y);
                conbeg = this.beg * 12 + mon;
                conend = this.beg * 12 + mon - 1 + laufzeit;
                if (conbeg % 12 != 0) {
                    this.Tempcontractnew.setentry_period(conbeg / 12);
                    this.Tempcontractnew.setentry_month(conbeg % 12);
                } else {
                    this.Tempcontractnew.setentry_period(conbeg / 12 - 1);
                    this.Tempcontractnew.setentry_month(12);
                }
                if (conend % 12 != 0) {
                    this.Tempcontractnew.setexit_period(conend / 12);
                    this.Tempcontractnew.setexit_month(conend % 12);
                } else {
                    this.Tempcontractnew.setexit_period(conend / 12 - 1);
                    this.Tempcontractnew.setexit_month(12);
                }
                this.myPrintStream.println(this.Tempcontractnew.getName() + "   " + this.Tempcontractnew.getparty1().getName() + "    " + this.Tempcontractnew.getparty2().getName() + "    " + this.Tempcontractnew.getentry_month() + "/" + this.Tempcontractnew.getentry_period() + "  " + this.Tempcontractnew.getexit_month() + "/" + this.Tempcontractnew.getexit_period() + "  " + laufzeit + "    " + this.Tempcontractnew.getenergy() * 1000.0 + "    " + this.Tempcontractnew.getpmax() + "   " + this.Tempcontractnew.getprice() + "   " + this.Tempcontractnew.getprice() / this.Tempcontractnew.getenergy() / 1000.0);
                DeepEdit.addComponent(this.TempComponent);
                this.Tempcontractnew.CheckActive(this.ActSchematic.getactperiod(), this.ActSchematic.getactmonth());
                if (DeepEdit.getEditor() == DE_GeneralEnums.editor.Power || DeepEdit.getEditor() == DE_GeneralEnums.editor.Hydro) {
                    this.Tempcontractnew.setvalid(false);
                }
                this.Tempcontractnew.PlacePinsHere(DeepEdit.PinGrid);
                this.applet.SimulateSetUpOnePoint(this.Tempcontractnew.getx1(), this.Tempcontractnew.gety1());
                this.applet.SimulateSetUpOnePoint(this.Tempcontractnew.getx2(), this.Tempcontractnew.gety2());
                this.Tempcontractnew.InformPartner(this.Tempcontractnew.ConnComps1, this.Tempcontractnew.getx1(), this.Tempcontractnew.gety1(), 1);
                this.Tempcontractnew.InformPartner(this.Tempcontractnew.ConnComps2, this.Tempcontractnew.getx2(), this.Tempcontractnew.gety2(), 2);
                continue;
            }
            System.out.println("Tempcontractnew = NULL");
        }
        return true;
    }

    public boolean compare(String saux) {
        for (int ixx = 0; ixx < this.contracts.size(); ++ixx) {
            this.Tempcontract = (mdb_wheel)this.contracts.elementAt(ixx);
            if (!this.Tempcontract.getparty2().getName().equals(saux)) continue;
            return true;
        }
        return false;
    }

    public boolean comparegen(String saux, int monini, int monlauf) {
        double energymon = 0.0;
        double powermon = 0.0;
        double energycon = 0.0;
        int ixx = monini;
        if (ixx < monini + monlauf) {
            Vector acon = new Vector();
            this.updatecontracts(ixx, acon);
            energymon = 0.0;
            powermon = 0.0;
            for (int iy = 0; iy < acon.size(); ++iy) {
                this.Tempcontract = (mdb_wheel)acon.elementAt(iy);
                if (this.Tempcontract.getparty1().getName().equals(saux)) {
                    energymon += this.Tempcontract.getenergy() / (double)this.Tempcontract.getlauf();
                    powermon += this.Tempcontract.getpmax();
                }
                energycon = this.energy / (double)monlauf / 1000.0;
                if (!(this.Tempcontract.getparty1() instanceof ndb_inj)) {
                    System.out.println("Party 1 is not instance of ndb_inj !!!");
                    return false;
                }
                this.Tempinj = (ndb_inj)this.Tempcontract.getparty1();
                if (this.Tempinj.getpmax() * 30.0 * 24.0 <= energymon + energycon) {
                    return false;
                }
                if (!(this.Tempinj.getpmax() <= powermon + this.power / 1000.0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int rand(int limit) {
        return (int)(Math.random() * (double)(limit - 1) + 1.0);
    }

    public void getbestoffer(int mmon, int llaufzeit) {
        boolean check = true;
        double bestoffer = 0.0;
        double offer = 0.0;
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof Generator)) continue;
            this.Tempgen = (Generator)this.TempComponent;
            check = this.comparegen(this.Tempgen.getName(), mmon, llaufzeit);
            if (check) {
                offer = this.calcoffer(this.Tempgen, this.Tempload, llaufzeit, mmon);
                if (bestoffer < 0.1) {
                    bestoffer = offer;
                }
                if (!(offer <= bestoffer)) continue;
                bestoffer = offer;
                this.Tempcontractnew = new mdb_wheel(DeepEdit.PinGrid, 0, 0, 0, 0, String.valueOf(this.connum), 0.0, 0.0, 0.0, 0.0, 0, this.ActSchematic.getiniperiod(), this.ActSchematic.getendperiod(), 1, 12, this.power, this.energy / 1000.0);
                this.Tempcontractnew.setparty1(this.Tempgen);
                this.Tempcontractnew.setparty2(this.Tempload);
                this.Tempcontractnew.setprice(bestoffer);
                continue;
            }
            System.out.println(this.Tempgen.getName() + ": Not enough energy to make an offer!!!");
        }
    }

    public void getenergy(Load aload, int laufz, int mon) throws Exception {
        SimpleDialog ExceptionDialog;
        String[] DlgButtons;
        int iaux = 0;
        int W = 0;
        int F = 0;
        int S = 0;
        int H = 0;
        Statement stmt = DeepEditFrame.conTLC.createStatement();
        for (int ix = mon; ix < laufz + mon; ++ix) {
            iaux = ix % 12;
            if (iaux >= 0 && iaux <= 2) {
                ++W;
            }
            if (iaux >= 3 && iaux <= 5) {
                ++F;
            }
            if (iaux >= 6 && iaux <= 8) {
                ++S;
            }
            if (iaux < 9 || iaux > 11) continue;
            ++H;
        }
        this.power = 0.0;
        this.energy = 0.0;
        if (W > 0) {
            try {
                this.getday("Wnt_", aload.getName(), stmt, W);
            }
            catch (Exception e) {
                this.message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Wnt-Load information", this.message, DlgButtons, 1, 0, 0, 1);
            }
        }
        if (F > 0) {
            try {
                this.getday("Frl_", aload.getName(), stmt, F);
            }
            catch (Exception e) {
                this.message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Frl-Load information", this.message, DlgButtons, 1, 0, 0, 1);
            }
        }
        if (S > 0) {
            try {
                this.getday("Som_", aload.getName(), stmt, S);
            }
            catch (Exception e) {
                this.message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Som-Load information", this.message, DlgButtons, 1, 0, 0, 1);
            }
        }
        if (H > 0) {
            try {
                this.getday("Hrb_", aload.getName(), stmt, H);
            }
            catch (Exception e) {
                this.message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Hrb-Load information", this.message, DlgButtons, 1, 0, 0, 1);
            }
        }
        stmt.close();
    }

    public void getday(String season, String aname, Statement stmt, int repeat) throws Exception {
        Object shour = null;
        double faux = 0.0;
        String query = "SELECT " + aname + " FROM " + season + "So";
        ResultSet rs = stmt.executeQuery(query);
        boolean more = rs.next();
        if (!more) {
            System.out.println("No " + aname + " found in getday.");
            return;
        }
        while (more) {
            faux = rs.getDouble(aname);
            this.energy += faux / 4.0 * 6.0 * (double)repeat;
            this.power = Math.max(faux, this.power);
            more = rs.next();
        }
        rs.close();
        query = "SELECT " + aname + " FROM " + season + "Sa";
        rs = stmt.executeQuery(query);
        more = rs.next();
        if (!more) {
            System.out.println("No " + aname + " found in getday.");
            return;
        }
        while (more) {
            faux = rs.getDouble(aname);
            this.energy += faux / 4.0 * 4.0 * (double)repeat;
            this.power = Math.max(faux, this.power);
            more = rs.next();
        }
        rs.close();
        query = "SELECT " + aname + " FROM " + season + "Wk";
        rs = stmt.executeQuery(query);
        more = rs.next();
        if (!more) {
            System.out.println("No " + aname + " found in getday.");
            return;
        }
        while (more) {
            faux = rs.getDouble(aname);
            this.energy += faux / 4.0 * 20.0 * (double)repeat;
            this.power = Math.max(faux, this.power);
            more = rs.next();
        }
        rs.close();
    }

    public int getlaufzeit(Load aload, int mon) {
        int min = (this.end - this.beg + 1) * 12;
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof mdb_wheel)) continue;
            this.Tempcontract = (mdb_wheel)this.TempComponent;
            if (!this.Tempcontract.getparty2().getName().equals(aload.getName()) || this.Tempcontract.getbeg(this.ActSchematic.getiniperiod()) <= (this.beg - this.ActSchematic.getiniperiod()) * 12 + mon) continue;
            min = Math.min(min, this.Tempcontract.getbeg(this.ActSchematic.getiniperiod()) - ((this.beg - this.ActSchematic.getiniperiod()) * 12 + mon));
        }
        min = Math.min(min, (this.ActSchematic.getendperiod() - this.beg + 1) * 12 - mon + 1);
        return Math.min(this.rand((this.end - this.beg + 1) * 12), min);
    }

    public double calcoffer(Generator agen, Load aload, int laufzeit, int mon) {
        double pener = 0.0;
        double ptrans = 0.0;
        double monener = 0.0;
        mdb_wheel Tempcontractvirt = null;
        for (int ixx = mon; ixx < mon + laufzeit; ++ixx) {
            Vector acon = new Vector();
            this.updatecontracts(ixx, acon);
            for (int iy = 0; iy < acon.size(); ++iy) {
                this.Tempcontract = (mdb_wheel)acon.elementAt(iy);
                if (!this.Tempcontract.getparty1().getName().equals(agen.getName())) continue;
                monener += this.Tempcontract.getpcontract();
            }
            pener += (monener + this.energy / 1000.0) * (this.Tempgen.getbeta() + 2.0 * this.Tempgen.getgamma() * (monener + this.energy / 1000.0)) - monener * (this.Tempgen.getbeta() + 2.0 * this.Tempgen.getgamma() * monener);
        }
        Tempcontractvirt = new mdb_wheel(DeepEdit.PinGrid, 0, 0, 0, 0, "noname", 0.0, 0.0, 0.0, 0.0, 0, 0, 0, 1, laufzeit, this.power, this.energy / 1000.0);
        Tempcontractvirt.setparty1(this.Tempgen);
        Tempcontractvirt.setparty2(this.Tempload);
        ptrans = this.MyVV.VV(Tempcontractvirt);
        return pener + ptrans;
    }

    static void closeTLC() throws SQLException {
        try {
            DeepEditFrame.conTLC.commit();
            DeepEditFrame.conTLC.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Point getposload(String loadn, String loadown) {
        Point loadpos = new Point(0, 0);
        loadpos.x = 0;
        loadpos.y = 0;
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof mdb_cust) || !this.TempComponent.getName().equals(loadown)) continue;
            mdb_cust Tempcust = (mdb_cust)this.TempComponent;
            for (int ixx = 0; ixx < Tempcust.Components.size(); ++ixx) {
                comp TempComponent1 = (comp)Tempcust.Components.elementAt(ixx);
                if (!TempComponent1.getName().equals(loadn)) continue;
                loadpos.x = Tempcust.Pos.x + 8 + 5 * ixx;
                loadpos.y = Tempcust.Pos.y;
                return loadpos;
            }
        }
        return loadpos;
    }

    public Point getposgen(String genn, String genown) {
        Point genpos = new Point(0, 0);
        genpos.x = 0;
        genpos.y = 0;
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (!(this.TempComponent instanceof mdb_sup) || !this.TempComponent.getName().equals(genown)) continue;
            mdb_sup Tempsup = (mdb_sup)this.TempComponent;
            for (int ixx = 0; ixx < Tempsup.Components.size(); ++ixx) {
                comp TempComponent1 = (comp)Tempsup.Components.elementAt(ixx);
                if (!TempComponent1.getName().equals(genn)) continue;
                genpos.x = Tempsup.Pos.x + (5 * ixx + 8 - (Tempsup.getnum() * 5 + 1) / 2);
                genpos.y = Tempsup.Pos.y + 16;
                return genpos;
            }
        }
        return genpos;
    }
}

