/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.VVFrame;
import de.core.comp;
import de.core.mdb_wheel;
import de.core.ndb_inj;
import de.utils.StringUtil;
import de.utils.Utils;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

public class VV
extends AnalysisTool {
    public double LPdis;
    public double GEHSSt;
    public double GEHSLa;
    public double GE20St;
    public double GE20La;
    public double GE10St;
    public double GE10La;
    public double GENSSt;
    public double GENSLa;
    public double LPHOS;
    public double LPHS;
    public double LPMS;
    public double LPNS;
    public double LPUSP_HOS_HS;
    public double LPUSP_HS_MS;
    public double LPUSP_MS_NS;
    public double LPsys;
    public double T1;
    public double G1;
    public double T2;
    public double G2;
    public double T3;
    public double G3;
    VVFrame MyVVFrame = null;
    double distance = 0.0;
    Load load;
    ndb_inj inj;
    int LP_SYS = 1;
    int LP_NS = 0;
    int LP_USP_MS_NS = 0;
    int LP_MS = 0;
    int LP_USP_HS_MS = 0;
    int LP_HS = 0;
    int LP_USP_HOS_HS = 0;
    int LP_HOS = 0;
    int LP_Dis = 0;
    double g = 0.0;

    public VV(Schematic sch) {
        super(sch);
        System.out.println("---------- In VV ------------");
        this.LPdis = 0.125;
        this.GEHSSt = 11.6;
        this.GEHSLa = 33.4;
        this.GE20St = 4.4;
        this.GE20La = 14.4;
        this.GE10St = 2.6;
        this.GE10La = 9.4;
        this.GENSSt = 0.4;
        this.GENSLa = 2.0;
        this.LPHOS = 35.0;
        this.LPHS = 40.0;
        this.LPMS = 90.0;
        this.LPNS = 170.0;
        this.LPUSP_HOS_HS = 15.0;
        this.LPUSP_HS_MS = 35.0;
        this.LPUSP_MS_NS = 80.0;
        this.LPsys = 24.0;
        this.T1 = 0.0;
        this.G1 = 0.1;
        this.T2 = 2500.0;
        this.G2 = 0.7;
        this.T3 = 8760.0;
        this.G3 = 1.0;
    }

    public void openVVFrame() {
        if (this.MyVVFrame == null) {
            this.MyVVFrame = new VVFrame(this);
        } else {
            this.MyVVFrame.setVisible(true);
        }
    }

    public void Calculate() throws SQLException {
        FileOutputStream os;
        String query;
        int x = 0;
        boolean selec = false;
        String FileName = "./results/VV.dat";
        Statement stmt = DeepEditFrame.conVV.createStatement();
        String[] listselec = this.MyVVFrame.list.getSelectedItems();
        if (this.MyVVFrame.MyCheckbox.getState()) {
            query = "DELETE * FROM Results";
            x = stmt.executeUpdate(query);
        }
        try {
            os = new FileOutputStream(FileName);
            PrintStream myPrintStream = new PrintStream(os);
            myPrintStream.println("--------------------------------------");
            myPrintStream.println("Deep-Edit Verb\u0081\u00e4ndevereinbarung-Tool");
            myPrintStream.println("--------------------------------------");
            myPrintStream.println(" ");
            myPrintStream.println(" ");
            myPrintStream.println("System Name             : " + this.ActSchematic.getsysname());
            myPrintStream.println("Current Year            : " + this.ActSchematic.getactperiod());
            myPrintStream.println(" ");
            myPrintStream.println(" ");
            myPrintStream.println("--------------------------------------");
            myPrintStream.println("Wheeling Transactions Description:    ");
            myPrintStream.println("--------------------------------------");
            myPrintStream.println(" ");
            myPrintStream.println(" ");
            myPrintStream.println("-----------------------------------------------------------------------------------------------------------------------------------------------------------------");
            myPrintStream.println("       Contract      | Generation    Owner     Voltage|   Load     Owner     Voltage   Place |  Distance |    Energy    |   Peak Load   |       Price        |");
            myPrintStream.println("                     |                           [kV] |                       [kV]           |    [km]   |  [kWh/year]  |      [kW]     |  [$/year] [$/kWh]  |");
            myPrintStream.println("-----------------------------------------------------------------------------------------------------------------------------------------------------------------");
            for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
                comp TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
                if (!(TempComponent instanceof mdb_wheel) || !TempComponent.getactive()) continue;
                mdb_wheel TempContract = (mdb_wheel)TempComponent;
                this.load = (Load)TempContract.getparty2();
                this.inj = (ndb_inj)TempContract.getparty1();
                String saux1 = this.load.getName() + "-" + this.inj.getName();
                selec = false;
                for (int ixx = 0; ixx < this.MyVVFrame.list.getSelectedIndexes().length; ++ixx) {
                    if (!saux1.equals(listselec[ixx]) && !listselec[ixx].equals("ALL")) continue;
                    selec = true;
                }
                if (!selec) continue;
                this.LP_SYS = 1;
                this.LP_NS = 0;
                this.LP_USP_MS_NS = 0;
                this.LP_MS = 0;
                this.LP_USP_HS_MS = 0;
                this.LP_HS = 0;
                this.LP_USP_HOS_HS = 0;
                this.LP_HOS = 0;
                this.LP_Dis = 0;
                TempContract.setprice(this.VV(TempContract));
                TempContract.setCalcModel("Verb\u0081\u00e4ndevereinbarung");
                TempContract.setlabel1("[$/year]");
                TempContract.setlabel2("[$/kWh]");
                query = "INSERT INTO Results (ContractName,InjName,InjOwner,InjVoltage,LoadName,LoadOwner,LoadVoltage,LoadPlace,entrymon,entry_period,exit_month,exit_period, lifetime, Distance,ConEnergy,ConPower,ComPrice1,ComPrice2,bLP_SYS,bLP_NS,bLP_USP_MS_NS,bLP_MS,bLP_USP_HS_MS,bLP_HS,bLP_USP_HOS_HS,bLP_HOS,bLP_Dis,LP_SYS,LP_NS,LP_USP_MS_NS,LP_MS,LP_USP_HS_MS,LP_HS,LP_USP_HOS_HS,LP_HOS,LP_Dis,G) VALUES ('" + TempContract.getName() + "','" + this.inj.getName() + "','" + this.inj.getinv_owner() + "'," + this.inj.getun1() + ",'" + this.load.getName() + "','" + this.load.getinv_owner() + "'," + this.load.getun1() + ",'" + this.load.getplace() + "'," + TempContract.getentry_month() + "," + TempContract.getentry_period() + "," + TempContract.getexit_month() + "," + TempContract.getexit_period() + "," + TempContract.getlauf() + "," + this.distance + "," + TempContract.getenergy() * 1000.0 + "," + TempContract.getpmax() * 1000.0 + "," + TempContract.getprice() + "," + TempContract.getprice() / TempContract.getenergy() / 1000.0 + "," + this.LP_SYS + "," + this.LP_NS + "," + this.LP_USP_MS_NS + "," + this.LP_MS + "," + this.LP_USP_HS_MS + "," + this.LP_HS + "," + this.LP_USP_HOS_HS + "," + this.LP_HOS + "," + this.LP_Dis + "," + this.LPsys + "," + this.LPNS + "," + this.LPUSP_MS_NS + "," + this.LPMS + "," + this.LPUSP_HS_MS + "," + this.LPHS + "," + this.LPUSP_HOS_HS + "," + this.LPHOS + "," + this.LPdis + "," + this.g + ")";
                x = stmt.executeUpdate(query);
                myPrintStream.println(StringUtil.printf(TempContract.getName(), 20) + "   " + StringUtil.printf(this.inj.getName(), 12) + "   " + StringUtil.printf(this.inj.getinv_owner(), 12) + "   " + StringUtil.printf(this.inj.getun1(), 6, 1) + "   " + StringUtil.printf(this.load.getName(), 12) + "   " + StringUtil.printf(this.load.getinv_owner(), 12) + "   " + StringUtil.printf(this.load.getun1(), 6, 1) + "    " + StringUtil.printf(this.load.getplace(), 6) + "    " + StringUtil.printf(this.distance, 9, 2) + "      " + StringUtil.printf(TempContract.getenergy() * 1000.0, 15, 2) + "    " + StringUtil.printf(TempContract.getpmax() * 1000.0, 15, 2) + "   " + StringUtil.printf(TempContract.getprice(), 15, 2) + "   " + StringUtil.printf(TempContract.getprice() / TempContract.getenergy() / 1000.0, 12, 6));
            }
            myPrintStream.println(" ");
            myPrintStream.println("-----------------------------------------------------------------------------------------------------------------------------------------------------------------");
            myPrintStream.println("END");
            myPrintStream.println("-----------------------------------------------------------------------------------------------------------------------------------------------------------------");
            myPrintStream.println(" ");
        }
        catch (Exception e) {
            stmt.close();
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Verb\u0081\u00e4ndevereinbarung", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        stmt.close();
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (FileName != null) {
            this.DoListResults(FileName);
        }
    }

    public double g(double T) {
        double m = 0.0;
        if (T >= this.T1 && T < this.T2) {
            m = (this.G2 - this.G1) / (this.T2 - this.T1);
            return this.G1 + m * (T - this.T1);
        }
        if (T >= this.T2 && T <= this.T3) {
            m = (this.G3 - this.G2) / (this.T3 - this.T2);
            return this.G2 + m * (T - this.T2);
        }
        System.out.println("Error: T in contract not in existing intervals!");
        return 0.0;
    }

    public double VV(mdb_wheel TempContract) {
        double price = 0.0;
        this.load = (Load)TempContract.getparty2();
        this.inj = (ndb_inj)TempContract.getparty1();
        this.distance = Utils.getGeoDistance(this.load.getlatitude(), this.inj.getlatitude(), this.load.getlongitude(), this.inj.getlongitude());
        double GEHS = 0.0;
        double GENS = 0.0;
        double GEMS = 0.0;
        double energy = TempContract.getenergy() / (double)TempContract.getlauf() * 12.0 * 1000.0;
        double pmax = TempContract.getpmax() * 1000.0;
        double T = energy / pmax;
        this.g = this.g(T);
        price = this.LPsys;
        this.LP_SYS = 1;
        boolean NS = false;
        boolean MS = false;
        boolean HS = false;
        double un = this.load.getun1();
        double uninj = this.inj.getun1();
        if (this.load.getplace().equals("Land")) {
            GEHS = this.GEHSLa;
            GENS = this.GENSLa;
            if (un > 1.0 && un <= 15.0) {
                GEMS = this.GE10La;
            } else if (un > 15.0 && un <= 60.0) {
                GEMS = this.GE20La;
            }
        } else if (this.load.getplace().equals("Stadt")) {
            GEHS = this.GEHSSt;
            GENS = this.GENSSt;
            if (un > 1.0 && un <= 15.0) {
                GEMS = this.GE10St;
            } else if (un > 15.0 && un <= 60.0) {
                GEMS = this.GE20St;
            }
        } else {
            System.out.println("Error: Load must be in \"Stadt\" or \"Land\" !");
        }
        if (un >= 0.0 && un <= 1.0) {
            price += this.LPNS;
            this.LP_NS = 1;
            if (uninj <= 1.0 && this.distance <= GENS) {
                price = price * this.g * pmax;
                return price;
            }
            price += this.LPUSP_MS_NS + this.LPMS;
            this.LP_MS = 1;
            this.LP_USP_MS_NS = 1;
            NS = true;
        }
        if (un > 1.0 && un <= 60.0) {
            price += this.LPMS;
            this.LP_MS = 1;
        }
        if (un > 1.0 && un <= 60.0 || NS) {
            if (uninj <= 60.0 && this.distance <= GEMS) {
                price = price * this.g * pmax;
                return price;
            }
            if (uninj > 60.0) {
                price += this.LPUSP_HS_MS + this.LPHS;
                this.LP_USP_HS_MS = 1;
                this.LP_HS = 1;
                MS = true;
            }
            if (uninj <= 60.0 && this.distance > GEMS) {
                price += this.LPUSP_HS_MS + this.LPHS;
                this.LP_USP_HS_MS = 1;
                this.LP_HS = 1;
                if (this.distance <= GEHS) {
                    price = price * this.g * pmax;
                    return price;
                }
                price += this.LPUSP_HOS_HS + this.LPHOS;
                this.LP_USP_HOS_HS = 1;
                this.LP_HOS = 1;
                HS = true;
            }
        }
        if (un > 60.0 && un <= 150.0) {
            price += this.LPHS;
            this.LP_HS = 1;
        }
        if (un > 60.0 && un <= 150.0 || MS) {
            if (uninj <= 150.0 && this.distance <= GEHS) {
                price = price * this.g * pmax;
                return price;
            }
            price += this.LPUSP_HOS_HS + this.LPHOS;
            this.LP_USP_HOS_HS = 1;
            this.LP_HOS = 1;
            HS = true;
        }
        if (un > 150.0) {
            price += this.LPHOS;
            this.LP_HOS = 1;
        }
        if ((un > 150.0 || HS) && this.distance > 100.0) {
            price += this.LPdis * (this.distance - 100.0);
            this.LP_Dis = 1;
        }
        price = price * this.g * pmax / 12.0 * (double)TempContract.getlauf();
        return price;
    }

    static void closeVV() throws SQLException {
        try {
            DeepEditFrame.conVV.commit();
            DeepEditFrame.conVV.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

