/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.InputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_branch;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class Upfc
extends ndb_branch {
    protected double excv;
    protected double boostv;
    protected double excang;
    protected double boostang;
    protected double pfinj;
    protected double qeinj;
    protected double qbinj;
    protected double pspec;
    protected double vspec;
    protected double emax;
    protected double bmax;
    protected double emin;
    protected double bmin;
    protected double iemax;
    protected double ibmax;
    protected double pdcmax;
    protected double sconv1;
    protected double sconv2;
    protected double rexc;
    protected double xexc;
    protected double rboost;
    protected double xboost;
    protected double qspec;
    protected double vispec;
    public double simxx1;
    public double simxx2;
    public double simyy1;
    public double simyy2;
    protected boolean above = true;

    public Upfc(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(1, x, y, 2, entryperiod, exitperiod, entrymonth, exitmonth);
        this.setName("Upfc");
        this.ClassName = "Upfc";
        this.verhor = false;
        this.swapPS = false;
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
        this.IPin[0] = this.verhor ? new InputPin("A", 3, 1, 0, 3, 0, 0, 2) : new InputPin("A", 1, 3, 3, 0, 0, 0, 2);
        this.entry_period = entryperiod;
        this.exit_period = exitperiod;
        this.un[0] = 220.0;
        this.un[1] = 220.0;
        this.inv_type = "A";
        this.q21 = 0.0;
        this.p21 = 0.0;
        this.q12 = 0.0;
        this.p12 = 0.0;
        this.boostang = 0.0;
        this.excang = 0.0;
        this.boostv = 0.0;
        this.excv = 0.0;
        this.emax = 242.0;
        this.bmax = 132.0;
        this.emin = 0.0;
        this.bmin = 0.0;
        this.pdcmax = 0.0;
        this.ibmax = 0.0;
        this.iemax = 0.0;
        this.qbinj = 0.0;
        this.qeinj = 0.0;
        this.pfinj = 0.0;
        this.pspec = 0.0;
        this.qspec = 0.0;
        this.vispec = 0.0;
        this.vspec = 220.0;
        this.sconv1 = 4.8;
        this.sconv2 = 6.0;
        this.rboost = 0.0;
        this.xboost = 1.0;
        this.rexc = 0.0;
        this.xexc = 300.0;
        this.sc = 1.0;
        this.RegisterPins(PinGrid, x, y);
    }

    public Upfc(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, String ctrla, double cost, double coym, double un1, double un2, double ssmax, double ssn, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double incomep, double incomeq, double eexcv, double bboostv, double eexcang, double bboostang, double ppfinj, double qqeinj, double qqbinj, double ppspec, double qqspec, double vvispec, double vvspec, double eemax, double bbmax, double eemin, double bbmin, double iiemax, double iibmax, double ppdcmax, double ssconv1, double ssconv2, double rrexc, double xxexc, double rrboost, double xxboost, boolean vverhor, boolean sswapPS, int pplanning, String pproject, String aalternative, boolean ssuggest, double ssc) {
        super(1, x, y, 2, Name, type, Name, owner, ctrla, cost, coym, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, vverhor, pplanning, ssc);
        this.project = pproject;
        this.alternative = aalternative;
        this.suggest = ssuggest;
        this.swapPS = sswapPS;
        this.ClassName = "Upfc";
        this.verhor = vverhor;
        this.IPin[0] = this.verhor ? new InputPin("A", 3, 1, 0, 3, 0, 0, 2) : new InputPin("A", 1, 3, 3, 0, 0, 0, 2);
        this.sn = ssn;
        this.q21 = 0.0;
        this.p21 = 0.0;
        this.q12 = 0.0;
        this.p12 = 0.0;
        this.excv = eexcv;
        this.boostv = bboostv;
        this.excang = eexcang;
        this.boostang = bboostang;
        this.pfinj = ppfinj;
        this.qeinj = qqeinj;
        this.qbinj = qqbinj;
        this.pspec = ppspec;
        this.qspec = qqspec;
        this.vispec = vvispec;
        this.vspec = vvspec;
        this.emax = eemax;
        this.bmax = bbmax;
        this.emin = eemin;
        this.bmin = bbmin;
        this.iemax = iiemax;
        this.ibmax = iibmax;
        this.pdcmax = ppdcmax;
        this.sconv1 = ssconv1;
        this.sconv2 = ssconv2;
        this.rexc = rrexc;
        this.xexc = xxexc;
        this.rboost = rrboost;
        this.xboost = xxboost;
        this.un[0] = un1;
        this.un[1] = un2;
        this.RegisterPins(PinGrid, x, y);
    }

    public Upfc(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.project = "NONE";
        this.alternative = "NONE";
        this.suggest = false;
    }

    public double getexcv() {
        return this.excv;
    }

    public double getboostv() {
        return this.boostv;
    }

    public double getexcang() {
        return this.excang;
    }

    public double getboostang() {
        return this.boostang;
    }

    public double getpfinj() {
        return this.pfinj;
    }

    public double getqeinj() {
        return this.qeinj;
    }

    public double getqbinj() {
        return this.qbinj;
    }

    public double getpspec() {
        return this.pspec;
    }

    public double getqspec() {
        return this.qspec;
    }

    public double getvispec() {
        return this.vispec;
    }

    public double getvspec() {
        return this.vspec;
    }

    public double getemax() {
        return this.emax;
    }

    public double getbmax() {
        return this.bmax;
    }

    public double getemin() {
        return this.emin;
    }

    public double getbmin() {
        return this.bmin;
    }

    public double getiemax() {
        return this.iemax;
    }

    public double getibmax() {
        return this.ibmax;
    }

    public double getpdcmax() {
        return this.pdcmax;
    }

    public double getsconv1() {
        return this.sconv1;
    }

    public double getsconv2() {
        return this.sconv2;
    }

    public double getrexc() {
        return this.rexc;
    }

    public double getxexc() {
        return this.xexc;
    }

    public double getrboost() {
        return this.rboost;
    }

    public double getxboost() {
        return this.xboost;
    }

    public void setexcv(double n) {
        this.excv = n;
    }

    public void setboostv(double n) {
        this.boostv = n;
    }

    public void setexcang(double n) {
        this.excang = n;
    }

    public void setboostang(double n) {
        this.boostang = n;
    }

    public void setpfinj(double n) {
        this.pfinj = n;
    }

    public void setqeinj(double n) {
        this.qeinj = n;
    }

    public void setqbinj(double n) {
        this.qbinj = n;
    }

    public void setpspec(double n) {
        this.pspec = n;
    }

    public void setqspec(double n) {
        this.qspec = n;
    }

    public void setvispec(double n) {
        this.vispec = n;
    }

    public void setvspec(double n) {
        this.vspec = n;
    }

    public void setemax(double n) {
        this.emax = n;
    }

    public void setbmax(double n) {
        this.bmax = n;
    }

    public void setemin(double n) {
        this.emin = n;
    }

    public void setbmin(double n) {
        this.bmin = n;
    }

    public void setiemax(double n) {
        this.iemax = n;
    }

    public void setibmax(double n) {
        this.ibmax = n;
    }

    public void setpdcmax(double n) {
        this.pdcmax = n;
    }

    public void setsconv1(double n) {
        this.sconv1 = n;
    }

    public void setsconv2(double n) {
        this.sconv2 = n;
    }

    public void setrexc(double n) {
        this.rexc = n;
    }

    public void setxexc(double n) {
        this.xexc = n;
    }

    public void setrboost(double n) {
        this.rboost = n;
    }

    public void setxboost(double n) {
        this.xboost = n;
    }

    @Override
    public void setverhor(boolean n) {
        if (this.verhor != n) {
            this.RemovePinsGrid(DeepEdit.PinGrid);
            if (n) {
                this.setHitbox(4, 12, 1, 4, 4, 6);
                this.setPins(3, 1, 0, 3, 0, 0, 3, 13, 0, -3, 0, 0);
            } else {
                this.setHitbox(12, 4, 4, 1, 6, 4);
                this.setPins(1, 3, 3, 0, 0, 0, 13, 3, -3, 0, 0, 0);
            }
            this.verhor = n;
            this.RegisterPins(DeepEdit.PinGrid, this.getxpos(), this.getypos());
        }
    }

    @Override
    public comp Copy(int xo, int yo) {
        Upfc NewComponent = new Upfc(this, xo, yo);
        NewComponent.setun1(this.getun1());
        NewComponent.setun2(this.getun2());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setcoym(this.getcoym());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setm_incomep(this.getm_incomep());
        NewComponent.setm_incomeq(this.getm_incomeq());
        NewComponent.setexcv(this.getexcv());
        NewComponent.setboostv(this.getboostv());
        NewComponent.setexcang(this.getexcang());
        NewComponent.setboostang(this.getboostang());
        NewComponent.setpfinj(this.getpfinj());
        NewComponent.setqeinj(this.getqeinj());
        NewComponent.setqbinj(this.getqbinj());
        NewComponent.setpspec(this.getpspec());
        NewComponent.setqspec(this.getqspec());
        NewComponent.setvispec(this.getvispec());
        NewComponent.setvspec(this.getvspec());
        NewComponent.setemax(this.getemax());
        NewComponent.setbmax(this.getbmax());
        NewComponent.setemin(this.getemin());
        NewComponent.setbmin(this.getbmin());
        NewComponent.setiemax(this.getiemax());
        NewComponent.setibmax(this.getibmax());
        NewComponent.setpdcmax(this.getpdcmax());
        NewComponent.setsconv1(this.getsconv1());
        NewComponent.setsconv2(this.getsconv2());
        NewComponent.setrexc(this.getrexc());
        NewComponent.setxexc(this.getxexc());
        NewComponent.setrboost(this.getrboost());
        NewComponent.setxboost(this.getxboost());
        NewComponent.setverhor(this.getverhor());
        NewComponent.setswapPS(this.getswapPS());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setsc(this.getsc());
        NewComponent.setsn(this.getsn());
        NewComponent.setctrla(this.getctrla());
        return NewComponent;
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        double belastung2;
        double counterflow = Math.abs(this.p12) + Math.abs(this.p21);
        double diffflow = Math.abs(this.p12) - Math.abs(this.p21);
        this.simxx1 = 0.0;
        double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
        double belastung = Math.max(belastung1, belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12))) / (this.getsmax() * this.sc) * sref;
        this.auxcolor = belastung >= 0.9 ? Color.red : (belastung >= 0.5 ? Color.orange : Color.green);
        if (counterflow == 0.0) {
            return;
        }
        if (this.verhor) {
            if (Math.abs(this.p12) > Math.abs(this.p21) || diffflow == 0.0 && this.p12 > this.p21) {
                this.simxx1 = 3.0;
                this.simxx2 = 3.0;
                if (this.swapPS) {
                    this.simyy1 = 12.0;
                    this.simyy2 = 2.0;
                } else {
                    this.simyy1 = 2.0;
                    this.simyy2 = 12.0;
                }
            } else {
                this.simxx1 = 3.0;
                this.simxx2 = 3.0;
                if (this.swapPS) {
                    this.simyy1 = 2.0;
                    this.simyy2 = 12.0;
                } else {
                    this.simyy1 = 12.0;
                    this.simyy2 = 2.0;
                }
            }
        } else if (Math.abs(this.p12) > Math.abs(this.p21) || diffflow == 0.0 && this.p12 > this.p21) {
            if (this.swapPS) {
                this.simxx1 = 12.0;
                this.simxx2 = 2.0;
            } else {
                this.simxx1 = 2.0;
                this.simxx2 = 12.0;
            }
            this.simyy1 = 3.0;
            this.simyy2 = 3.0;
        } else {
            if (this.swapPS) {
                this.simxx1 = 2.0;
                this.simxx2 = 12.0;
            } else {
                this.simxx1 = 12.0;
                this.simxx2 = 2.0;
            }
            this.simyy1 = 3.0;
            this.simyy2 = 3.0;
        }
    }

    public boolean InformRelativePosition(Vector ActVector) {
        boolean nc = false;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this) continue;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                this.above = true;
            }
            if ((out = ConnectedComponent.InformOutput(this)) != -1) {
                this.above = false;
            }
            return true;
        }
        return false;
    }

    public String Statistic(int ix, double sref) {
        this.InformAllComponents();
        return " ";
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, boolean ShowReactive, double sref) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        boolean auxint = true;
        boolean relative1 = true;
        boolean relative2 = true;
        if (!Simulate) {
            int[] sqy;
            int[] sqx;
            if (!this.swapPS && !this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 1) * gs, (y + 3) * gs, (x + 4) * gs, (y + 3) * gs);
                g.drawLine((x + 10) * gs, (y + 3) * gs, (x + 13) * gs, (y + 3) * gs);
                g.drawLine((x + 5) * gs, (y + 1) * gs, (x + 9) * gs, (y + 1) * gs);
                g.drawLine((x + 5) * gs, (y + 5) * gs, (x + 9) * gs, (y + 5) * gs);
                g.drawLine((x + 4) * gs, (y + 3) * gs, (x + 5) * gs, (y + 1) * gs);
                g.drawLine((x + 9) * gs, (y + 1) * gs, (x + 10) * gs, (y + 3) * gs);
                g.drawLine((x + 4) * gs, (y + 3) * gs, (x + 5) * gs, (y + 5) * gs);
                g.drawLine((x + 9) * gs, (y + 5) * gs, (x + 10) * gs, (y + 3) * gs);
                g.drawLine((x + 5) * gs, (y + 1) * gs, (x + 5) * gs, (y + 5) * gs);
                sqx = new int[4];
                sqy = new int[4];
                sqx[0] = (x + 5) * gs;
                sqx[1] = (x + 5) * gs;
                sqx[2] = (x + 4) * gs;
                sqx[3] = (x + 5) * gs;
                sqy[0] = (y + 1) * gs;
                sqy[1] = (y + 1) * gs;
                sqy[2] = (y + 3) * gs;
                sqy[3] = (y + 5) * gs;
                g.drawPolygon(sqx, sqy, 4);
                g.fillPolygon(sqx, sqy, 4);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 4) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                }
            }
            if (this.swapPS && !this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 1) * gs, (y + 3) * gs, (x + 4) * gs, (y + 3) * gs);
                g.drawLine((x + 10) * gs, (y + 3) * gs, (x + 13) * gs, (y + 3) * gs);
                g.drawLine((x + 5) * gs, (y + 1) * gs, (x + 9) * gs, (y + 1) * gs);
                g.drawLine((x + 5) * gs, (y + 5) * gs, (x + 9) * gs, (y + 5) * gs);
                g.drawLine((x + 4) * gs, (y + 3) * gs, (x + 5) * gs, (y + 1) * gs);
                g.drawLine((x + 9) * gs, (y + 1) * gs, (x + 10) * gs, (y + 3) * gs);
                g.drawLine((x + 4) * gs, (y + 3) * gs, (x + 5) * gs, (y + 5) * gs);
                g.drawLine((x + 9) * gs, (y + 5) * gs, (x + 10) * gs, (y + 3) * gs);
                g.drawLine((x + 9) * gs, (y + 1) * gs, (x + 9) * gs, (y + 5) * gs);
                sqx = new int[4];
                sqy = new int[4];
                sqx[0] = (x + 9) * gs;
                sqx[1] = (x + 9) * gs;
                sqx[2] = (x + 10) * gs;
                sqx[3] = (x + 9) * gs;
                sqy[0] = (y + 1) * gs;
                sqy[1] = (y + 1) * gs;
                sqy[2] = (y + 3) * gs;
                sqy[3] = (y + 5) * gs;
                g.drawPolygon(sqx, sqy, 4);
                g.fillPolygon(sqx, sqy, 4);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 4) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 6) * gs, (y + 3) * gs);
                }
            }
            if (!this.swapPS && this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 3) * gs, (y + 1) * gs, (x + 3) * gs, (y + 4) * gs);
                g.drawLine((x + 3) * gs, (y + 4) * gs, (x + 1) * gs, (y + 5) * gs);
                g.drawLine((x + 3) * gs, (y + 4) * gs, (x + 5) * gs, (y + 5) * gs);
                g.drawLine((x + 1) * gs, (y + 5) * gs, (x + 1) * gs, (y + 9) * gs);
                g.drawLine((x + 5) * gs, (y + 5) * gs, (x + 5) * gs, (y + 9) * gs);
                g.drawLine((x + 1) * gs, (y + 9) * gs, (x + 3) * gs, (y + 10) * gs);
                g.drawLine((x + 5) * gs, (y + 9) * gs, (x + 3) * gs, (y + 10) * gs);
                g.drawLine((x + 3) * gs, (y + 10) * gs, (x + 3) * gs, (y + 13) * gs);
                g.drawLine((x + 1) * gs, (y + 5) * gs, (x + 5) * gs, (y + 5) * gs);
                sqx = new int[4];
                sqy = new int[4];
                sqx[0] = (x + 3) * gs;
                sqx[1] = (x + 3) * gs;
                sqx[2] = (x + 1) * gs;
                sqx[3] = (x + 5) * gs;
                sqy[0] = (y + 4) * gs;
                sqy[1] = (y + 4) * gs;
                sqy[2] = (y + 5) * gs;
                sqy[3] = (y + 5) * gs;
                g.drawPolygon(sqx, sqy, 4);
                g.fillPolygon(sqx, sqy, 4);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                }
            }
            if (this.swapPS && this.verhor) {
                g.setColor(this.getkv_color1());
                g.drawLine((x + 3) * gs, (y + 1) * gs, (x + 3) * gs, (y + 4) * gs);
                g.drawLine((x + 3) * gs, (y + 4) * gs, (x + 1) * gs, (y + 5) * gs);
                g.drawLine((x + 3) * gs, (y + 4) * gs, (x + 5) * gs, (y + 5) * gs);
                g.drawLine((x + 1) * gs, (y + 5) * gs, (x + 1) * gs, (y + 9) * gs);
                g.drawLine((x + 5) * gs, (y + 5) * gs, (x + 5) * gs, (y + 9) * gs);
                g.drawLine((x + 1) * gs, (y + 9) * gs, (x + 3) * gs, (y + 10) * gs);
                g.drawLine((x + 5) * gs, (y + 9) * gs, (x + 3) * gs, (y + 10) * gs);
                g.drawLine((x + 3) * gs, (y + 10) * gs, (x + 3) * gs, (y + 13) * gs);
                g.drawLine((x + 1) * gs, (y + 9) * gs, (x + 5) * gs, (y + 9) * gs);
                sqx = new int[4];
                sqy = new int[4];
                sqx[0] = (x + 3) * gs;
                sqx[1] = (x + 3) * gs;
                sqx[2] = (x + 1) * gs;
                sqx[3] = (x + 5) * gs;
                sqy[0] = (y + 10) * gs;
                sqy[1] = (y + 10) * gs;
                sqy[2] = (y + 9) * gs;
                sqy[3] = (y + 9) * gs;
                g.drawPolygon(sqx, sqy, 4);
                g.fillPolygon(sqx, sqy, 4);
                g.setColor(Color.gray);
                if (gs > 2 && gs < 4) {
                    g.setFont(Font8);
                } else if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 10 && gs < 14) {
                    g.setFont(Font12);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                } else if (gs >= 14 && gs < 18) {
                    g.setFont(Font16);
                    g.drawString(this.ComponentName, (x + 2) * gs, (y + 7) * gs);
                }
            }
            if (gs >= 4) {
                if (gs >= 4 && gs < 8) {
                    g.setFont(Font8);
                } else if (gs >= 8 && gs < 10) {
                    g.setFont(Font9);
                } else {
                    g.setFont(Font10);
                }
                if (!Modifiedstate && this.getinservice()) {
                    int y2;
                    int y1;
                    int x2;
                    int x1;
                    if (this.verhor) {
                        x1 = x + 3;
                        x2 = x + 3;
                        if (this.swapPS) {
                            y1 = y + 13;
                            y2 = y + 1;
                        } else {
                            y1 = y + 1;
                            y2 = y + 13;
                        }
                    } else {
                        y1 = y + 3;
                        y2 = y + 3;
                        if (this.swapPS) {
                            x1 = x + 13;
                            x2 = x + 1;
                        } else {
                            x1 = x + 1;
                            x2 = x + 13;
                        }
                    }
                    double counterflow = Math.abs(this.p12) + Math.abs(this.p21) + Math.abs(this.q21) + Math.abs(this.q12);
                    double belastung1 = Math.sqrt(Math.abs(this.p21) * Math.abs(this.p21) + Math.abs(this.q21) * Math.abs(this.q21));
                    double belastung2 = Math.sqrt(Math.abs(this.p12) * Math.abs(this.p12) + Math.abs(this.q12) * Math.abs(this.q12));
                    double belastung = Math.max(belastung1, belastung2) / (this.getsmax() * this.sc) * sref;
                    if (belastung >= 0.9) {
                        g.setColor(Color.red);
                    } else if (belastung >= 0.5) {
                        g.setColor(Color.orange);
                    } else {
                        g.setColor(Color.green);
                    }
                    if (this.verhor) {
                        g.fillArc((x + 6) * gs, (y + 6) * gs, 2 * gs, 2 * gs, 90 - (int)(belastung * 360.0), (int)(belastung * 360.0));
                        g.setColor(TextColor1);
                        g.drawOval((x + 6) * gs, (y + 6) * gs, 2 * gs, 2 * gs);
                    } else {
                        g.fillArc((x + 5) * gs, (y + 8) * gs, 2 * gs, 2 * gs, 90 - (int)(belastung * 360.0), (int)(belastung * 360.0));
                        g.setColor(TextColor1);
                        g.drawOval((x + 5) * gs, (y + 8) * gs, 2 * gs, 2 * gs);
                    }
                    if (counterflow != 0.0) {
                        int posy;
                        int posx;
                        relative1 = this.swapPS ? this.InformRelativePosition(this.OPin[0].ConnComps) : this.InformRelativePosition(this.IPin[0].ConnComps);
                        if (relative1) {
                            posx = (int)(((double)x1 - 0.5) * (double)gs);
                            posy = y1 * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (this.p12 > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy + 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p12 < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (this.p12 > 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy - 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p12 < 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q12) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q12 > 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q12 < 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                        if (relative2 = this.swapPS ? this.InformRelativePosition(this.IPin[0].ConnComps) : this.InformRelativePosition(this.OPin[0].ConnComps)) {
                            posx = (int)(((double)x2 - 0.5) * (double)gs);
                            posy = y2 * gs;
                            if (this.above) {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 1.2 * (double)gs));
                                }
                                if (this.p21 > 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy + 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p21 < 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy + 2.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy + 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy + 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            } else {
                                g.setColor(Color1);
                                if (this.p21 != 0.0 || this.p12 != 0.0) {
                                    g.drawString(StringUtil.printf(Math.abs(this.p21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 2.2 * (double)gs));
                                }
                                if (this.p21 > 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy - 2 * gs, posx, posy, 1, (int)((double)gs * 0.3));
                                } else if (this.p21 < 0.0 && this.p21 != 0.0) {
                                    GraphicsUtil.drawArrow(g, posx, posy, posx, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                }
                                if (ShowReactive) {
                                    g.setColor(TextColor1);
                                    if (this.q21 != 0.0 || this.q12 != 0.0) {
                                        g.drawString(StringUtil.printf(Math.abs(this.q21) * sref, 10, 2), posx - 4 * gs, (int)((double)posy - 1.2 * (double)gs));
                                    }
                                    if (this.q21 > 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy - 2 * gs, posx + gs, posy, 1, (int)((double)gs * 0.3));
                                    } else if (this.q21 < 0.0 && this.q21 != 0.0) {
                                        GraphicsUtil.drawArrow(g, posx + gs, posy, posx + gs, posy - 2 * gs, 1, (int)((double)gs * 0.3));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (this.simxx1 != 0.0) {
            g.setColor(this.auxcolor);
            if (cycle) {
                GraphicsUtil.drawArrow(g, (int)(((double)x + this.simxx1) * (double)gs), (int)(((double)y + this.simyy1) * (double)gs), (int)(((double)x + (this.simxx2 + this.simxx1) / 2.0) * (double)gs), (int)(((double)y + (this.simyy2 + this.simyy1) / 2.0) * (double)gs), 1, (int)((double)gs * 1.5));
            } else {
                GraphicsUtil.drawArrow(g, (int)(((double)x + (this.simxx2 + this.simxx1) / 2.0) * (double)gs), (int)(((double)y + (this.simyy2 + this.simyy1) / 2.0) * (double)gs), (int)(((double)x + this.simxx2) * (double)gs), (int)(((double)y + this.simyy2) * (double)gs), 1, (int)((double)gs * 1.5));
            }
        }
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        boolean aux = true;
        int cx1 = this.Pos.x + this.HitBox.x - 3;
        int cy1 = this.Pos.y + this.HitBox.y - 3;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width + 3;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height + 3;
        aux = x1 <= cx1 && y1 <= cy1 && cx1 <= x2 && cy1 <= y2 || x1 <= cx2 && y1 <= cy2 && cx2 <= x2 && cy2 <= y2;
        return aux;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" coym " + this.coym);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" un2 " + this.un[1]);
        myPrintStream.println(" smax " + this.smax);
        myPrintStream.println(" sn " + this.sn);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" excv " + this.excv);
        myPrintStream.println(" boostv " + this.boostv);
        myPrintStream.println(" excang " + this.excang);
        myPrintStream.println(" boostang " + this.boostang);
        myPrintStream.println(" pfinj " + this.pfinj);
        myPrintStream.println(" qeinj " + this.qeinj);
        myPrintStream.println(" qbinj " + this.qbinj);
        myPrintStream.println(" pspec " + this.pspec);
        myPrintStream.println(" qspec " + this.qspec);
        myPrintStream.println(" vispec " + this.vispec);
        myPrintStream.println(" vspec " + this.vspec);
        myPrintStream.println(" emax " + this.emax);
        myPrintStream.println(" bmax " + this.bmax);
        myPrintStream.println(" emin " + this.emin);
        myPrintStream.println(" bmin " + this.bmin);
        myPrintStream.println(" iemax " + this.iemax);
        myPrintStream.println(" ibmax " + this.ibmax);
        myPrintStream.println(" pdcmax " + this.pdcmax);
        myPrintStream.println(" sconv1 " + this.sconv1);
        myPrintStream.println(" sconv2 " + this.sconv2);
        myPrintStream.println(" rexc " + this.rexc);
        myPrintStream.println(" xexc " + this.xexc);
        myPrintStream.println(" rboost " + this.rboost);
        myPrintStream.println(" xboost " + this.xboost);
        myPrintStream.println(" incomep " + this.m_incomep);
        myPrintStream.println(" incomeq " + this.m_incomeq);
        myPrintStream.println(" verhor " + this.verhor);
        myPrintStream.println(" swapPS " + this.swapPS);
        myPrintStream.println(" planning " + this.planning);
        myPrintStream.println(" project " + this.project);
        myPrintStream.println(" alternative " + this.alternative);
        myPrintStream.println(" suggest " + this.suggest);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO Upfc (XPos, YPos, Name, type, owner, ctrla, cost, coym, un1, un2, smax, sn, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, excv, boostv, excang, boostang, pfinj, qeinj, qbinj, pspec, qspec, vispec, vspec, emax, bmax, emin, bmin, iemax, ibmax, pdcmax, sconv1, sconv2, rexc, xexc, rboost, xboost, verhor, swapPS, planning,U1,U2,delta1,delta2,p12,q12,p21,q21,project,alternative,suggest,con1,con2) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.coym) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.un[1]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.sn) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.m_incomep) + "," + String.valueOf(this.m_incomeq) + "," + String.valueOf(this.excv) + "," + String.valueOf(this.boostv) + "," + String.valueOf(this.excang) + "," + String.valueOf(this.boostang) + "," + String.valueOf(this.pfinj) + "," + String.valueOf(this.qeinj) + "," + String.valueOf(this.qbinj) + "," + String.valueOf(this.pspec) + "," + String.valueOf(this.qspec) + "," + String.valueOf(this.vispec) + "," + String.valueOf(this.vspec) + "," + String.valueOf(this.emax) + "," + String.valueOf(this.bmax) + "," + String.valueOf(this.emin) + "," + String.valueOf(this.bmin) + "," + String.valueOf(this.iemax) + "," + String.valueOf(this.ibmax) + "," + String.valueOf(this.pdcmax) + "," + String.valueOf(this.sconv1) + "," + String.valueOf(this.sconv2) + "," + String.valueOf(this.rexc) + "," + String.valueOf(this.xexc) + "," + String.valueOf(this.rboost) + "," + String.valueOf(this.xboost) + "," + (this.verhor ? 1 : 0) + "," + (this.swapPS ? 1 : 0) + "," + String.valueOf(this.planning) + "," + String.valueOf(this.getun2()) + "," + String.valueOf(this.getun3()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.getdelta3()) + "," + String.valueOf(this.p12) + "," + String.valueOf(this.q12) + "," + String.valueOf(this.p21) + "," + String.valueOf(this.q21) + ",'" + this.project + "','" + this.alternative + "'," + (this.suggest ? 1 : 0) + ",'" + this.con1 + "','" + this.con2 + "')";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public void InformAllComponents() {
        comp ConnectedComponent;
        int ix;
        Busbar MyBusbar = null;
        int nc = 0;
        int inp = -1;
        int out = -1;
        this.setcon1(" ");
        this.setcon2(" ");
        for (int o = 0; o < this.Outputs; ++o) {
            for (ix = 0; ix < this.OPin[o].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.OPin[o].ConnComps.elementAt(ix);
                if (ConnectedComponent instanceof Busbar) {
                    MyBusbar = (Busbar)ConnectedComponent;
                }
                if (ConnectedComponent == this) continue;
                if (++nc > 1 && DeepEdit.PrintConnecWarnings) {
                    System.out.println(" !!!Error: mas de una componente al final de un Upfc!!!");
                }
                if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                    if (this.swapPS) {
                        this.setcon1(ConnectedComponent.ComponentName);
                        this.ctrla1 = MyBusbar.getctrla();
                    } else {
                        this.setcon2(ConnectedComponent.ComponentName);
                        this.ctrla2 = MyBusbar.getctrla();
                    }
                }
                if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
                if (this.swapPS) {
                    this.setcon1(ConnectedComponent.ComponentName);
                    this.ctrla1 = MyBusbar.getctrla();
                    continue;
                }
                this.setcon2(ConnectedComponent.ComponentName);
                this.ctrla2 = MyBusbar.getctrla();
            }
        }
        nc = 0;
        for (int i = 0; i < this.Inputs; ++i) {
            for (ix = 0; ix < this.IPin[i].ConnComps.size(); ++ix) {
                ConnectedComponent = (comp)this.IPin[i].ConnComps.elementAt(ix);
                if (ConnectedComponent == this) continue;
                if (++nc > 1 && DeepEdit.PrintConnecWarnings) {
                    System.out.println(" !!!Error: mas de una componente al final de una linea Inputs= " + this.Inputs);
                }
                if ((inp = ConnectedComponent.InformInput(this)) != -1) {
                    if (this.swapPS) {
                        this.setcon2(ConnectedComponent.ComponentName);
                        this.ctrla2 = MyBusbar.getctrla();
                    } else {
                        this.setcon1(ConnectedComponent.ComponentName);
                        this.ctrla1 = MyBusbar.getctrla();
                    }
                }
                if ((out = ConnectedComponent.InformOutput(this)) == -1) continue;
                if (this.swapPS) {
                    this.setcon2(ConnectedComponent.ComponentName);
                    this.ctrla2 = MyBusbar.getctrla();
                    continue;
                }
                this.setcon1(ConnectedComponent.ComponentName);
                this.ctrla1 = MyBusbar.getctrla();
            }
        }
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alias")) {
            sValue = this.getalias();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con1")) {
            sValue = this.getcon1();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un2")) {
            sValue = String.valueOf(this.getun2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U2")) {
            sValue = String.valueOf(this.getun2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sc")) {
            sValue = String.valueOf(this.getsc());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta1")) {
            sValue = String.valueOf(this.getdelta2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta2")) {
            sValue = String.valueOf(this.getdelta3());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("ibmax")) {
            sValue = String.valueOf(this.getibmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("iemax")) {
            sValue = String.valueOf(this.getiemax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p12")) {
            sValue = String.valueOf(this.getp12());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p21")) {
            sValue = String.valueOf(this.getp21());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q12")) {
            sValue = String.valueOf(this.getq12());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q21")) {
            sValue = String.valueOf(this.getq21());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("bmax")) {
            sValue = String.valueOf(this.getbmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("bmin")) {
            sValue = String.valueOf(this.getbmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("boostang")) {
            sValue = String.valueOf(this.getboostang());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("boostv")) {
            sValue = String.valueOf(this.getboostv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("emax")) {
            sValue = String.valueOf(this.getemax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("emin")) {
            sValue = String.valueOf(this.getemin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("excang")) {
            sValue = String.valueOf(this.getexcang());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("excv")) {
            sValue = String.valueOf(this.getexcv());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pdcmax")) {
            sValue = String.valueOf(this.getpdcmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pfinj")) {
            sValue = String.valueOf(this.getpfinj());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pspec")) {
            sValue = String.valueOf(this.getpspec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qbinj")) {
            sValue = String.valueOf(this.getqbinj());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qeinj")) {
            sValue = String.valueOf(this.getqeinj());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qspec")) {
            sValue = String.valueOf(this.getqspec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("rboost")) {
            sValue = String.valueOf(this.getrboost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("rexc")) {
            sValue = String.valueOf(this.getrexc());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sconv1")) {
            sValue = String.valueOf(this.getsconv1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sconv2")) {
            sValue = String.valueOf(this.getsconv2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("vispec")) {
            sValue = String.valueOf(this.getvispec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("vspec")) {
            sValue = String.valueOf(this.getvspec());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xboost")) {
            sValue = String.valueOf(this.getxboost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xexc")) {
            sValue = String.valueOf(this.getxexc());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("coym")) {
            sValue = String.valueOf(this.getcoym());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alternative")) {
            sValue = this.getalternative();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("planning")) {
            sValue = String.valueOf(this.getplanning());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("project")) {
            sValue = this.getproject();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomep")) {
            sValue = String.valueOf(this.getm_incomep());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("incomeq")) {
            sValue = String.valueOf(this.getm_incomeq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("suggest")) {
            sValue = String.valueOf(this.getsuggest());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("swapPS")) {
            sValue = String.valueOf(this.getswapPS());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("verhor")) {
            sValue = String.valueOf(this.getverhor());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alias")) {
            this.setalias(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con1")) {
            this.setcon1(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un2")) {
            this.setun2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U2")) {
            this.setun2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sc")) {
            this.setsc(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta1")) {
            this.setdelta2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta2")) {
            this.setdelta3(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ibmax")) {
            this.setibmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("iemax")) {
            this.setiemax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p12")) {
            this.setp12(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p21")) {
            this.setp21(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q12")) {
            this.setq12(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q21")) {
            this.setq21(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("bmax")) {
            this.setbmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("bmin")) {
            this.setbmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("boostang")) {
            this.setboostang(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("boostv")) {
            this.setboostv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("emax")) {
            this.setemax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("emin")) {
            this.setemin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("excang")) {
            this.setexcang(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("excv")) {
            this.setexcv(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pdcmax")) {
            this.setpdcmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pfinj")) {
            this.setpfinj(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pspec")) {
            this.setpspec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qbinj")) {
            this.setqbinj(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qeinj")) {
            this.setqeinj(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qspec")) {
            this.setqspec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("rboost")) {
            this.setrboost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("rexc")) {
            this.setrexc(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sconv1")) {
            this.setsconv1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sconv2")) {
            this.setsconv2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("vispec")) {
            this.setvispec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("vspec")) {
            this.setvspec(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xboost")) {
            this.setxboost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xexc")) {
            this.setxexc(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("swapPS")) {
            this.setswapPS(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("verhor")) {
            this.setverhor(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("coym")) {
            this.setcoym(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alternative")) {
            this.setalternative(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("planning")) {
            this.setplanning((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("project")) {
            this.setproject(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomep")) {
            this.setm_incomep(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("incomeq")) {
            this.setm_incomeq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("suggest")) {
            this.setsuggest(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

