/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Generator;
import de.core.Load;
import de.core.Schematic;
import de.core.comp;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class Test
extends AnalysisTool {
    FileOutputStream os;
    String FileName = "./results/Test.dat";
    PrintStream MyPrintStream;
    static int INFI = 1000000;
    static double UNSER = 1000.0;
    public int numgen;
    public int numstate;
    public int numperiod;
    protected Vector generators;
    protected Vector actgen;
    public int inistate;
    public int finalstate;
    public double[][] Fcost;
    public double[][] Pcost;
    public double[][] Tcost;
    public int[][] STRAT;
    public int[] optstrat;
    public double[] totdem;
    public double bestsolution;
    public int currstate;
    public int bestfinalstate;
    public double auxf;
    BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
    public int aux;

    public Test(Schematic sch) {
        super(sch);
        int pc;
        comp TempComponent;
        int ix;
        try {
            this.os = new FileOutputStream(this.FileName);
            this.MyPrintStream = new PrintStream(this.os);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.MyPrintStream.println("---------- In Dynamic Programming ------------");
        this.numperiod = 24;
        this.totdem = new double[this.numperiod];
        this.bestsolution = INFI;
        this.bestfinalstate = 0;
        this.MyPrintStream.println("---------- Ini Demand");
        this.totdem[0] = 450.0;
        this.totdem[1] = 450.0;
        this.totdem[2] = 450.0;
        this.totdem[3] = 530.0;
        this.totdem[4] = 530.0;
        this.totdem[5] = 530.0;
        this.totdem[6] = 600.0;
        this.totdem[7] = 600.0;
        this.totdem[8] = 600.0;
        this.totdem[9] = 540.0;
        this.totdem[10] = 540.0;
        this.totdem[11] = 540.0;
        this.totdem[12] = 400.0;
        this.totdem[13] = 400.0;
        this.totdem[14] = 400.0;
        this.totdem[15] = 280.0;
        this.totdem[16] = 280.0;
        this.totdem[17] = 280.0;
        this.totdem[18] = 290.0;
        this.totdem[19] = 290.0;
        this.totdem[20] = 290.0;
        this.totdem[21] = 500.0;
        this.totdem[22] = 500.0;
        this.totdem[23] = 500.0;
        this.generators = new Vector();
        this.actgen = new Vector();
        this.numgen = 0;
        this.numload = 0;
        this.MyPrintStream.println("---------- Read Schematic");
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.insertgenerator(TempGenerator);
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            ++this.numload;
        }
        this.MyPrintStream.println("---------- Ini dimension");
        this.numstate = (int)Math.pow(2.0, this.numgen);
        this.Fcost = new double[this.numperiod][this.numstate];
        this.Pcost = new double[this.numperiod][this.numstate];
        this.STRAT = new int[this.numperiod][this.numstate];
        this.MyPrintStream.println("---------- numstate: " + this.numstate);
        for (ix = 0; ix < this.numgen; ++ix) {
            TempComponent = (comp)this.generators.elementAt(ix);
            this.MyPrintStream.println("Nombre gen " + (ix + 1) + ": " + TempComponent.getName());
        }
        for (int sc = 0; sc < this.numstate; ++sc) {
            this.currstate = sc;
            this.asspark(sc);
            for (pc = 0; pc < this.numperiod; ++pc) {
                this.Pcost[pc][sc] = this.calcPcost(pc);
            }
        }
        for (int inistate = 0; inistate < this.numstate; ++inistate) {
            int ix2;
            this.MyPrintStream.println("Enter inistate: " + inistate);
            this.MyPrintStream.println("---------- Total costs period 1");
            for (ix2 = 0; ix2 < this.numstate; ++ix2) {
                this.Fcost[0][ix2] = INFI;
            }
            this.asspark(inistate);
            this.Fcost[0][inistate] = this.Pcost[0][inistate];
            for (pc = 1; pc < this.numperiod; ++pc) {
                for (int sc = 0; sc < this.numstate; ++sc) {
                    this.calcFcost(pc, sc);
                }
            }
            this.MyPrintStream.println("---------- Search for optimal strategie");
            this.auxf = INFI;
            this.finalstate = 0;
            for (ix2 = 0; ix2 < this.numstate; ++ix2) {
                if (!(this.Fcost[this.numperiod - 1][ix2] <= this.auxf)) continue;
                this.auxf = this.Fcost[this.numperiod - 1][ix2];
                this.finalstate = ix2;
            }
            if (!(this.auxf <= this.bestsolution)) continue;
            this.bestsolution = this.auxf;
            this.bestfinalstate = this.finalstate;
            this.optstrat = new int[this.numperiod];
            this.optstrat[this.numperiod - 1] = this.STRAT[this.numperiod - 1][this.finalstate];
            for (ix2 = this.numperiod - 2; ix2 > 0; --ix2) {
                this.optstrat[ix2] = this.STRAT[ix2][this.optstrat[ix2 + 1]];
            }
        }
        this.MyPrintStream.println("---------- Print optimal strategie");
        this.MyPrintStream.println("Best Solution Found: " + this.bestsolution + " (cost)");
        for (ix = 1; ix < this.numperiod; ++ix) {
            this.MyPrintStream.print("Period: " + ix + " Demand= " + this.totdem[ix] + " -->");
            this.printstate(this.optstrat[ix]);
        }
        this.MyPrintStream.print("Final State: " + this.bestfinalstate + "-->");
        this.printstate(this.bestfinalstate);
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.FileName != null) {
            this.DoListResults(this.FileName);
        }
    }

    public void calcFcost(int ppc, int ssc) {
        double mincost = INFI;
        double actcost = 0.0;
        int beststate = 0;
        for (int sc = 0; sc < this.numstate; ++sc) {
            actcost = this.Fcost[ppc - 1][sc] + this.calcTcost(ppc - 1, sc, ppc, ssc);
            if (!(actcost <= mincost)) continue;
            beststate = sc;
            mincost = actcost;
        }
        this.Fcost[ppc][ssc] = this.Pcost[ppc][ssc] + mincost;
        this.STRAT[ppc][ssc] = beststate;
    }

    public void printstate(long state) {
        for (int i = this.numgen; i > 0; --i) {
            long j;
            if (i % 8 == 0) {
                this.MyPrintStream.print(" ");
            }
            if ((state & (j = (long)Math.pow(2.0, i - 1))) != 0L) {
                this.MyPrintStream.print("1");
                continue;
            }
            this.MyPrintStream.print("0");
        }
        this.MyPrintStream.println(": (" + state + ")");
    }

    public void asspark(long state) {
        this.actgen.removeAllElements();
        for (int i = 1; i < this.numgen + 1; ++i) {
            long j = (long)Math.pow(2.0, i - 1);
            if ((state & j) == 0L) continue;
            this.actgen.addElement((Generator)this.generators.elementAt(i - 1));
        }
    }

    public void insertgenerator(Generator newgen) {
        double cost = newgen.getbeta();
        int porte = this.generators.size();
        for (int i = 0; i < porte; ++i) {
            Generator TempGenerator = (Generator)this.generators.elementAt(i);
            if (!(TempGenerator.getbeta() >= cost)) continue;
            this.generators.insertElementAt(newgen, i);
            return;
        }
        this.generators.addElement(newgen);
    }

    public double calcPcost(int per) {
        Generator TempGenerator;
        int i;
        double cost = 0.0;
        double servload = 0.0;
        for (i = 0; i < this.actgen.size(); ++i) {
            TempGenerator = (Generator)this.actgen.elementAt(i);
            if (servload + TempGenerator.getpmin() >= this.totdem[per]) {
                this.MyPrintStream.println("Sum of PMIN greater than totdem in period :" + per);
                this.MyPrintStream.println("System state:");
                this.printstate(this.currstate);
                return INFI;
            }
            cost += TempGenerator.getalpha();
            servload += TempGenerator.getpmin();
        }
        for (i = 0; i < this.actgen.size(); ++i) {
            TempGenerator = (Generator)this.actgen.elementAt(i);
            if (servload + TempGenerator.getpmax() >= this.totdem[per]) {
                return cost += TempGenerator.getbeta() * (this.totdem[per] - servload);
            }
            cost += TempGenerator.getbeta() * TempGenerator.getpmax();
            servload += TempGenerator.getpmax();
        }
        this.MyPrintStream.println("The system need unserved energy in period :" + per);
        this.MyPrintStream.println("System state:");
        this.printstate(this.currstate);
        return cost += UNSER * (this.totdem[per] - servload);
    }

    public double calcTcost(int per1, int s1, int per2, int s2) {
        double cost = 0.0;
        return cost;
    }

    public void waits(String mess) {
        if (!mess.equals(" ")) {
            this.MyPrintStream.println(mess);
        }
        try {
            this.aux = Integer.parseInt(this.din.readLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

