/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPSSTxFrame;
import de.core.TPSSTxVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPSSTx
extends AnalysisTool {
    TPSSTxFrame MyTPSSTxFrame = null;
    TPSSTxVisualFrame MyTPSSTxVisualFrame = null;
    ColorSpec MyColorSpec = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pg;
    double[] node_pl;
    boolean[] node_pg_SSTx;
    boolean[] node_pl_SSTx;
    boolean[] Lin_SSTx;
    int numallnod = 0;
    int numallgen = 0;
    int numallload = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactload = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NomActOwnerL;
    String[] NomOwnerL;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBLoad;
    int dimDBYear;
    double[] blockTime;
    public double[] Flujo;
    public boolean[] SentidoFlujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    int slackGenerator;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    double[][] ProrrateoActL;
    double[][] AProrrateoActL;
    public double[][] ProrrateoL;
    double[][] OProrrateoActL;
    double[][] AOProrrateoActL;
    public double[][] OProrrateoL;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    int[][] OFrecuenciaL;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleMatrix GLDF;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    double[][] PLoadOwn;
    int numactowner = 0;
    int numactownerL = 0;
    int numallowner = 0;
    int numallownerL = 0;
    String[] LosOwner;
    String[] LosActOwner;
    String[] LosOwnerL;
    String[] LosActOwnerL;
    int nitera = 0;
    double[] PLA1;
    double[] PLA2;
    double[] PLA1L;
    double[] PLA2L;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int block1;
    int hidro1;
    int block2;
    int hidro2;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int ndem;
    public double[] AVNR_COyM;
    public double[][] PagoBarra;
    public double[][] PagoOwner;
    public double[][] PagoBarraL;
    public double[][] PagoOwnerL;
    double nTotHoras = 0.0;
    int nrobl = -1;
    double[] simDuration;
    double sdur = 0.0;
    double[][] PUnitsAct;
    double[][] APUnitsAct;
    public double[][] PUnits;
    int[][] FUnits;
    double[] PLA3;
    double[][] PGenUnits;
    public double[][] PagoUnits;
    int ndem2;
    String[] NameLDB2;
    double[][] PLDB2;
    int dimDBLoad2;
    boolean one = false;
    boolean noloss = true;
    double[] AVNR_COyMAct;
    private double sref = this.getSref();

    TPSSTx(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPSSTx ------------");
    }

    public TPSSTx(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, boolean Nloss) {
        super(sch);
    }

    public TPSSTx(Schematic sch, boolean VisDB) {
        super(sch);
        System.out.println("---------- In TPSSTx ------------ 2");
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, boolean Nloss) {
        this.noloss = Nloss;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPSSTx.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
    }

    public void InitAllNetwork() {
        boolean ix = false;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numallload = 0;
        this.numallowner = 0;
        this.numallownerL = 0;
        Vector OwnVector = new Vector();
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro, boolean HydroDBa, boolean sentido) {
        boolean i = false;
        boolean ix = false;
        boolean countG = false;
        boolean countL = false;
        String auxname = " ";
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
    }

    public void build_GGDF(double[] flux, double[] pg) {
        int i = 0;
        int j = 0;
        double PGges = 0.0;
        double[] vec_DrefG = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            vec_DrefG[i] = 0.0;
        }
        for (i = 0; i < this.numactnod; ++i) {
            PGges += pg[i];
        }
        i = 0;
        while (i < this.numactbran) {
            vec_DrefG[i] = flux[i] * this.sref;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                vec_DrefG[n] = vec_DrefG[n] - this.GSDFS.getElement(i, j) * pg[j];
            }
            int n = i++;
            vec_DrefG[n] = vec_DrefG[n] / PGges;
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GGDF.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GGDF.setElement(i, j, this.GSDFS.getElement(i, j) + vec_DrefG[i]);
            }
        }
    }

    public void build_GLDF(double[] flux, double[] pl) {
        int i = 0;
        int j = 0;
        double PLges = 0.0;
        double[] vec_DrefL = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            vec_DrefL[i] = 0.0;
        }
        for (i = 0; i < this.numactnod; ++i) {
            PLges += pl[i];
        }
        i = 0;
        while (i < this.numactbran) {
            vec_DrefL[i] = flux[i] * this.sref;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                vec_DrefL[n] = vec_DrefL[n] + this.GSDFS.getElement(i, j) * pl[j];
            }
            int n = i++;
            vec_DrefL[n] = vec_DrefL[n] / PLges;
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GLDF.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GLDF.setElement(i, j, -this.GSDFS.getElement(i, j) + vec_DrefL[i]);
            }
        }
    }

    public void build_Participa(double[] flux) {
        int k;
        int i = 0;
        int j = 0;
        double[][] GGDFGEN = new double[this.numactbran][this.numactnod];
        double[][] GLDFCON = new double[this.numactbran][this.numactnod];
        double[] PFAF = new double[this.numactbran];
        double[] PFGDFF = new double[this.numactbran];
        double[] PFGLDFF = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            PFAF[i] = 0.0;
            PFGDFF[i] = 0.0;
            for (j = 0; j < this.numactnod; ++j) {
                GGDFGEN[i][j] = 0.0;
                GLDFCON[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            if (!this.Lin_SSTx[i]) continue;
            if (!(flux[i] >= 0.0 && this.SentidoFlujo[i] || flux[i] < 0.0 && !this.SentidoFlujo[i])) {
                for (j = 0; j < this.numactnod; ++j) {
                    GGDFGEN[i][j] = this.node_pg[j] > 0.0 && this.GGDF.getElement(i, j) * flux[i] > 0.0 && this.node_pg_SSTx[j] ? this.GGDF.getElement(i, j) : 0.0;
                }
                continue;
            }
            for (j = 0; j < this.numactnod; ++j) {
                GLDFCON[i][j] = this.node_pl[j] > 0.0 && this.GLDF.getElement(i, j) * flux[i] > 0.0 && this.node_pl_SSTx[j] ? this.GLDF.getElement(i, j) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                if (GGDFGEN[i][j] > 1.0) {
                    GGDFGEN[i][j] = 1.0;
                }
                if (GGDFGEN[i][j] < -1.0) {
                    GGDFGEN[i][j] = -1.0;
                }
                PFGDFF[i] = PFGDFF[i] + GGDFGEN[i][j] * this.node_pg[j];
                if (GLDFCON[i][j] > 1.0) {
                    GLDFCON[i][j] = 1.0;
                }
                if (GLDFCON[i][j] < -1.0) {
                    GLDFCON[i][j] = -1.0;
                }
                PFGLDFF[i] = PFGLDFF[i] + GLDFCON[i][j] * this.node_pl[j];
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = 0.0;
                this.ProrrateoActL[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = PFGDFF[i] > 1.0E-7 || PFGDFF[i] < -1.0E-7 ? Math.abs(GGDFGEN[i][j] * this.node_pg[j] / PFGDFF[i] * 100.0) : 0.0;
                this.ProrrateoActL[i][j] = PFGLDFF[i] > 1.0E-7 || PFGLDFF[i] < -1.0E-7 ? Math.abs(GLDFCON[i][j] * this.node_pl[j] / PFGLDFF[i] * 100.0) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactowner; ++k) {
                this.OProrrateoAct[i][k] = 0.0;
            }
            for (k = 0; k < this.numactownerL; ++k) {
                this.OProrrateoActL[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                for (k = 0; k < this.numactowner; ++k) {
                    if (!(this.node_pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.OProrrateoAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PGenOwn[k][j] / this.node_pg[j];
                }
                for (k = 0; k < this.numactgen; ++k) {
                    if (!(this.node_pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.PUnitsAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PGenUnits[k][j] / this.node_pg[j];
                }
            }
            for (j = 0; j < this.numactnod; ++j) {
                for (k = 0; k < this.numactownerL; ++k) {
                    if (!(this.node_pl[j] > 1.0E-6)) continue;
                    double[] dArray = this.OProrrateoActL[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoActL[i][j] * this.PLoadOwn[k][j] / this.node_pl[j];
                }
            }
        }
    }

    public void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa, boolean HydroDBa) {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
            this.year1 = Integer.parseInt(SDYa);
            this.year2 = Integer.parseInt(EDYa);
            for (i = 0; i < 12; ++i) {
                if (mes[i].equals(SDMa)) {
                    this.month1 = i + 1;
                }
                if (!mes[i].equals(EDMa)) continue;
                this.month2 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.block2 = Integer.parseInt(EDBa);
            this.hidro2 = Integer.parseInt(EDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            this.flow2 = ((this.year2 - this.InitialYearDB) * 12 + (this.month2 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block2 - 1) * this.HydroNumberDB + this.hidro2;
            if (this.flow2 < this.flow1) {
                System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
                int mulanga = this.flow2;
                this.flow2 = this.flow1;
                this.flow1 = mulanga;
                System.out.println(" ........ Problema resuelto autom\u00e1ticamente (inverse selection)");
            } else if (this.flow2 == this.flow1) {
                this.one = true;
            }
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("Flow Selection Details");
            System.out.println("----------------------");
            System.out.println("Total DB flows  :    " + tflo);
            System.out.println("Total DB years  :    " + this.YearNumberDB);
            System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
            System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
            System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
            System.out.println("Inicio          :" + TPSSTx.numformat(this.year1, 8) + "/" + TPSSTx.numformat(this.month1, 8) + "/" + TPSSTx.numformat(this.block1, 8) + "/" + TPSSTx.numformat(this.hidro1, 8) + "/" + TPSSTx.numformat(this.flow1, 8));
            System.out.println("Final           :" + TPSSTx.numformat(this.year2, 8) + "/" + TPSSTx.numformat(this.month2, 8) + "/" + TPSSTx.numformat(this.block2, 8) + "/" + TPSSTx.numformat(this.hidro2, 8) + "/" + TPSSTx.numformat(this.flow2, 8));
            System.out.println(" ");
            this.ndem = this.BlockNumberDB * 12;
            this.blockTime = new double[this.ndem];
            ResultSet r0 = s.executeQuery("SELECT *\tFROM blockTime");
            r0.next();
            for (j = 1; j <= this.ndem; ++j) {
                this.blockTime[j - 1] = r0.getDouble("d" + j);
            }
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            if (HydroDBa) {
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
                ResultSet r3 = s.executeQuery("SELECT Year\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    ++i;
                }
                this.dimDBYear = i;
                this.TotDemDB = new double[this.dimDBYear][this.ndem];
                this.HidYearNameLDB = new int[this.dimDBYear];
                for (i = 0; i < this.dimDBYear; ++i) {
                    this.HidYearNameLDB[i] = 1;
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = 123456.0;
                    }
                }
                r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    this.HidYearNameLDB[i] = r3.getInt("Year");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                    }
                    ++i;
                }
            } else {
                this.ndem2 = this.YearNumberDB * 12;
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad2 = i;
                this.NameLDB2 = new String[this.dimDBLoad2];
                this.PLDB2 = new double[this.dimDBLoad2][this.ndem2];
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    this.NameLDB2[i] = "nada";
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB2[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
            }
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        boolean count = false;
        int y1 = 1900;
        boolean m1 = true;
        int y2 = 2020;
        int m2 = 12;
        return true;
    }

    public void GetActiveNetwork() {
        int ixi;
        Trafo TempTrafo;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactload = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    TempTrafo = (Trafo)TempComponent;
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactload;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.node_pl != null || this.Flujo != null || this.GenNode != null || this.LasNode != null || this.Lin_SSTx != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.node_pl = null;
            this.Flujo = null;
            this.SentidoFlujo = null;
            this.GenNode = null;
            this.LasNode = null;
            this.Lin_SSTx = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactload];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.Lin_SSTx = new boolean[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.node_pl = new double[this.numactnod];
        this.node_pg_SSTx = new boolean[this.numactnod];
        this.node_pl_SSTx = new boolean[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.SentidoFlujo = new boolean[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactload];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.AVNR_COyMAct = new double[this.numactbran];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
            this.node_pl[ixi] = 0.0;
            this.node_pg_SSTx[i] = false;
            this.node_pl_SSTx[i] = false;
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
            this.SentidoFlujo[ixi] = true;
            this.Lin_SSTx[ixi] = false;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GGDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GLDF = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                this.AVNR_COyMAct[countBra] = TempLine.getannuity(this.ActSchematic.intrate) * 1000.0;
                this.Lin_SSTx[count] = TempLine.getctrla().equals(this.ctrla);
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                this.AVNR_COyMAct[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate) * 1000.0;
                this.Lin_SSTx[count] = TempTrafo.getctrla().equals(this.ctrla);
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    slack = this.numbus(TempGenerator.getcon2());
                    this.slackGenerator = countGen;
                    this.slackNode = slack;
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                    System.out.println("slack Owner  = " + this.nomSlackOwner);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        this.PGenUnits = new double[this.numactgen][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numactnod - 1; ++ii) {
            for (int jj = 0; jj < this.numactnod - 1; ++jj) {
                MatXX.setElement(ii, jj, MatY.getElement(ii, jj));
            }
        }
        System.out.println(" ");
        System.out.println("Inverting MatXX Matrix");
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        System.out.println("MatXX Matrix Inverted");
        for (i = 0; i < this.numactnod - 1; ++i) {
            for (j = 0; j < this.numactnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numactnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slack));
                }
            }
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.node_pl = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GGDF = null;
        this.GLDF = null;
        this.ProrrateoAct = null;
        this.ProrrateoActL = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.SentidoFlujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        boolean ix = false;
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error on close: " + e);
            e.printStackTrace();
        }
    }
}

