/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPPanamaFrame;
import de.core.TPPanamaVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPPanama
extends AnalysisTool {
    TPPanamaFrame MyTPPanamaFrame = null;
    TPPanamaVisualFrame MyTPPanamaVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pg;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBLoad;
    int dimDBYear;
    double[] blockTime;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    int slackGenerator;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = 0;
    int numallowner = 0;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    double[] PLA1;
    double[] PLA2;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int block1;
    int hidro1;
    int block2;
    int hidro2;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int ndem;
    public double[] AVNR_COyM;
    public double[][] PagoBarra;
    public double[][] PagoOwner;
    double nTotHoras = 0.0;
    int nrobl = -1;
    double[] simDuration;
    double sdur = 0.0;
    double[][] PUnitsAct;
    double[][] APUnitsAct;
    public double[][] PUnits;
    int[][] FUnits;
    double[] PLA3;
    double[][] PGenUnits;
    public double[][] PagoUnits;
    int ndem2;
    String[] NameLDB2;
    double[][] PLDB2;
    int dimDBLoad2;
    boolean one = false;
    double[] AVNR_COyMAct;
    int y;
    int m;
    int b;
    int h;
    double[] TenNomNodAct;
    double[] TenNomLinAct;
    double[] AVNR_COyMActLin;
    double[] Longitud;
    Vector NV;
    double[] IPSPT;
    double[] CU;
    double Largos;
    double[][] USOEG;
    double[][] USOED;
    double[][] USORG;
    double[][] USORD;
    PrintStream PanamaStream;
    FileOutputStream osPanama;
    double[] node_pl;
    double[] FLinAct;
    double[] CapLinAct;
    double[] CNODEG;
    double[] CNODED;
    double[] CNODRG;
    double[] CNODRD;
    int dimPMNC;
    String[] ZonaDB;
    double[] PMNCDB;
    double[] CInstGZDB;
    int[] LinBra;
    int[] InvType;
    String[] NodZone;
    double[] CInstG;
    double[] PMa;
    double[] CUNod;
    double[] CULin;
    double[][] FIG;
    double[][] FID;
    double[] FIT;
    Vector NZ;
    double[] CZONEG;
    double[] CZONED;
    double[] CZONRG;
    double[] CZONRD;
    double TTRAE;
    double TTRAR;
    double TCZONEG;
    double TCZONED;
    double TCZONRG;
    double TCZONRD;
    double CInstGTot;
    double PMaTot;
    double[] CInstGZ;
    double[] PMaZ;
    int limmes1;
    int limmes2;
    int nfl;
    int cuenta = 0;
    double TCZONEGM;
    double TCZONEDM;
    double TCZONRGM;
    double TCZONRDM;
    double[] CZONEGM;
    double[] CZONEDM;
    double[] CZONRGM;
    double[] CZONRDM;
    int Flujo1;
    int Flujo2;
    double[][][] USOEGBin;
    double[][][] USOEDBin;
    double[][][] USORGBin;
    double[][][] USORDBin;
    double[][] FST;
    private double sref = this.getSref();

    public TPPanama(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPPanama ------------");
    }

    public TPPanama(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, String Crit, double Percent) {
        super(sch);
    }

    public TPPanama(Schematic sch, boolean VisDB) {
        super(sch);
        System.out.println("---------- In TPPanama ------------ 2");
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, String CritSel, double percent) {
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPPanama.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
    }

    public void InitAllNetwork() {
        boolean ix = false;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro, boolean HydroDBa) {
        boolean i = false;
        boolean ix = false;
        boolean countG = false;
        boolean countL = false;
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
    }

    public void build_Panama() {
        int k;
        int i;
        int j = 0;
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 1) continue;
            for (j = 0; j < this.numactnod; ++j) {
                if (Math.abs(this.CapLinAct[i]) > 1.0E-6 && Math.abs(this.Flujo[this.LinBra[i]]) > 1.0E-6) {
                    this.USOEG[i][j] = this.node_pg[j] * this.GSDFS.getElement(this.LinBra[i], j) / this.Flujo[this.LinBra[i]] * Math.abs(this.Flujo[this.LinBra[i]]) / this.CapLinAct[i] / 100.0;
                    this.USOED[i][j] = -this.node_pl[j] * this.GSDFS.getElement(this.LinBra[i], j) / this.Flujo[this.LinBra[i]] * Math.abs(this.Flujo[this.LinBra[i]]) / this.CapLinAct[i] / 100.0;
                    this.USOEGBin[i][j][this.nfl - this.Flujo1] = this.USOEG[i][j];
                    this.USOEDBin[i][j][this.nfl - this.Flujo1] = this.USOED[i][j];
                    continue;
                }
                this.USOEG[i][j] = 0.0;
                this.USOED[i][j] = 0.0;
                this.USOEGBin[i][j][this.nfl - this.Flujo1] = 0.0;
                this.USOEDBin[i][j][this.nfl - this.Flujo1] = 0.0;
            }
        }
        for (j = 0; j < this.numactnod; ++j) {
            this.CNODEG[j] = 0.0;
            this.CNODED[j] = 0.0;
        }
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 1) continue;
            for (j = 0; j < this.numactnod; ++j) {
                int n = j;
                this.CNODEG[n] = this.CNODEG[n] + this.CULin[i] * this.Longitud[i] * this.USOEG[i][j];
                int n2 = j;
                this.CNODED[n2] = this.CNODED[n2] + this.CULin[i] * this.Longitud[i] * this.USOED[i][j];
            }
        }
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 2) continue;
            for (j = 0; j < this.numactnod; ++j) {
                if (Math.abs(this.Flujo[this.LinBra[i]]) > 1.0E-5) {
                    this.FIG[i][j] = Math.max(0.0, this.node_pg[j] * this.GSDFS.getElement(this.LinBra[i], j) / this.Flujo[this.LinBra[i]] * Math.abs(this.Flujo[this.LinBra[i]]));
                    this.FID[i][j] = Math.max(0.0, -this.node_pl[j] * this.GSDFS.getElement(this.LinBra[i], j) / this.Flujo[this.LinBra[i]] * Math.abs(this.Flujo[this.LinBra[i]]));
                    continue;
                }
                this.FIG[i][j] = 0.0;
                this.FID[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactlin; ++i) {
            this.FIT[i] = 0.0;
        }
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 2) continue;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                this.FIT[n] = this.FIT[n] + (this.FIG[i][j] + this.FID[i][j]);
            }
        }
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 2) continue;
            for (j = 0; j < this.numactnod; ++j) {
                if (Math.abs(this.FIT[i]) > 1.0E-5) {
                    this.USORG[i][j] = this.FIG[i][j] / this.FIT[i];
                    this.USORD[i][j] = this.FID[i][j] / this.FIT[i];
                    this.USORGBin[i][j][this.nfl - this.Flujo1] = this.USORG[i][j];
                    this.USORDBin[i][j][this.nfl - this.Flujo1] = this.USORD[i][j];
                    continue;
                }
                this.USORG[i][j] = 0.0;
                this.USORD[i][j] = 0.0;
                this.USORGBin[i][j][this.nfl - this.Flujo1] = 0.0;
                this.USORDBin[i][j][this.nfl - this.Flujo1] = 0.0;
            }
        }
        for (j = 0; j < this.numactnod; ++j) {
            this.CNODRG[j] = 0.0;
            this.CNODRD[j] = 0.0;
        }
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 2) continue;
            for (j = 0; j < this.numactnod; ++j) {
                int n = j;
                this.CNODRG[n] = this.CNODRG[n] + this.CULin[i] * this.Longitud[i] * this.USORG[i][j];
                int n3 = j;
                this.CNODRD[n3] = this.CNODRD[n3] + this.CULin[i] * this.Longitud[i] * this.USORD[i][j];
            }
        }
        for (k = 0; k < this.NZ.size(); ++k) {
            for (i = 0; i < this.numactnod; ++i) {
                this.CZONEG[k] = 0.0;
                this.CZONED[k] = 0.0;
                this.CZONRG[k] = 0.0;
                this.CZONRD[k] = 0.0;
            }
        }
        for (k = 0; k < this.NZ.size(); ++k) {
            for (i = 0; i < this.numactnod; ++i) {
                if (!((String)this.NZ.elementAt(k)).equals(this.NodZone[i])) continue;
                int n = k;
                this.CZONEG[n] = this.CZONEG[n] + this.CNODEG[i];
                int n4 = k;
                this.CZONED[n4] = this.CZONED[n4] + this.CNODED[i];
                int n5 = k;
                this.CZONRG[n5] = this.CZONRG[n5] + this.CNODRG[i];
                int n6 = k;
                this.CZONRD[n6] = this.CZONRD[n6] + this.CNODRD[i];
            }
        }
        for (i = 0; i < this.NZ.size(); ++i) {
            this.TCZONEG = 0.0;
            this.TCZONED = 0.0;
            this.TCZONRG = 0.0;
            this.TCZONRD = 0.0;
        }
        for (i = 0; i < this.NZ.size(); ++i) {
            this.TCZONEG += this.CZONEG[i];
            this.TCZONED += this.CZONED[i];
            this.TCZONRG += this.CZONRG[i];
            this.TCZONRD += this.CZONRD[i];
        }
    }

    public void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa, boolean HydroDBa) {
        int i = 0;
        int j = 0;
        try {
            ResultSet r2;
            System.out.println("Loading TPDB Information ...");
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
            this.year1 = Integer.parseInt(SDYa);
            this.year2 = Integer.parseInt(EDYa);
            for (i = 0; i < 12; ++i) {
                if (mes[i].equals(SDMa)) {
                    this.month1 = i + 1;
                }
                if (!mes[i].equals(EDMa)) continue;
                this.month2 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.block2 = Integer.parseInt(EDBa);
            this.hidro2 = Integer.parseInt(EDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            this.flow2 = ((this.year2 - this.InitialYearDB) * 12 + (this.month2 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block2 - 1) * this.HydroNumberDB + this.hidro2;
            if (this.flow2 < this.flow1) {
                System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
                int mulanga = this.flow2;
                this.flow2 = this.flow1;
                this.flow1 = mulanga;
                System.out.println(" ........ Problema resuelto autom\u00e1ticamente (inverse selection)");
            } else if (this.flow2 == this.flow1) {
                this.one = true;
            }
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("Flow Selection Details");
            System.out.println("----------------------");
            System.out.println("Total DB flows  :    " + tflo);
            System.out.println("Total DB years  :    " + this.YearNumberDB);
            System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
            System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
            System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
            System.out.println("Inicio          :" + TPPanama.numformat(this.year1, 8) + "/" + TPPanama.numformat(this.month1, 8) + "/" + TPPanama.numformat(this.block1, 8) + "/" + TPPanama.numformat(this.hidro1, 8) + "/" + TPPanama.numformat(this.flow1, 8));
            System.out.println("Final           :" + TPPanama.numformat(this.year2, 8) + "/" + TPPanama.numformat(this.month2, 8) + "/" + TPPanama.numformat(this.block2, 8) + "/" + TPPanama.numformat(this.hidro2, 8) + "/" + TPPanama.numformat(this.flow2, 8));
            System.out.println(" ");
            this.ndem = this.BlockNumberDB * 12;
            this.blockTime = new double[this.ndem];
            ResultSet r0 = s.executeQuery("SELECT *\tFROM blockTime");
            r0.next();
            for (j = 1; j <= this.ndem; ++j) {
                this.blockTime[j - 1] = r0.getDouble("d" + j);
            }
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            if (HydroDBa) {
                r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
                ResultSet r3 = s.executeQuery("SELECT Year\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    ++i;
                }
                this.dimDBYear = i;
                this.TotDemDB = new double[this.dimDBYear][this.ndem];
                this.HidYearNameLDB = new int[this.dimDBYear];
                for (i = 0; i < this.dimDBYear; ++i) {
                    this.HidYearNameLDB[i] = 1;
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = 123456.0;
                    }
                }
                r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    this.HidYearNameLDB[i] = r3.getInt("Year");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                    }
                    ++i;
                }
            } else {
                this.ndem2 = this.YearNumberDB * 12;
                r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad2 = i;
                this.NameLDB2 = new String[this.dimDBLoad2];
                this.PLDB2 = new double[this.dimDBLoad2][this.ndem2];
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    this.NameLDB2[i] = "nada";
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB2[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
            }
            ResultSet r3 = s.executeQuery("SELECT Zona\tFROM DatosPanama   ORDER BY Zona");
            i = 0;
            while (r3.next()) {
                ++i;
            }
            this.dimPMNC = i;
            this.ZonaDB = new String[this.dimPMNC];
            this.PMNCDB = new double[this.dimPMNC];
            this.CInstGZDB = new double[this.dimPMNC];
            i = 0;
            r3 = s.executeQuery("SELECT *\tFROM DatosPanama   ORDER BY Zona");
            while (r3.next()) {
                this.ZonaDB[i] = r3.getString("Zona");
                this.PMNCDB[i] = r3.getDouble("PMa");
                this.CInstGZDB[i] = r3.getDouble("CInstGZ");
                ++i;
            }
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        boolean count = false;
        int y1 = 1900;
        boolean m1 = true;
        int y2 = 2020;
        int m2 = 12;
        return true;
    }

    public void GetActiveNetwork() {
        Load TempLoad;
        Generator TempGenerator;
        int ixi;
        Trafo TempTrafo;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    TempTrafo = (Trafo)TempComponent;
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.Flujo != null || this.GenNode != null || this.LasNode != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.Flujo = null;
            this.GenNode = null;
            this.LasNode = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.AVNR_COyMAct = new double[this.numactbran];
        this.TenNomNodAct = new double[this.numactnod];
        this.TenNomLinAct = new double[this.numactlin];
        this.AVNR_COyMActLin = new double[this.numactlin];
        this.Longitud = new double[this.numactlin];
        this.FLinAct = new double[this.numactlin];
        this.CapLinAct = new double[this.numactlin];
        this.USOEG = new double[this.numactlin][this.numactnod];
        this.USOED = new double[this.numactlin][this.numactnod];
        this.node_pl = new double[this.numactnod];
        this.FIT = new double[this.numactlin];
        this.USORG = new double[this.numactlin][this.numactnod];
        this.USORD = new double[this.numactlin][this.numactnod];
        this.FIG = new double[this.numactlin][this.numactnod];
        this.FID = new double[this.numactlin][this.numactnod];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GGDF = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                this.AVNR_COyMAct[countBra] = TempLine.getannuity(this.ActSchematic.intrate);
                this.AVNR_COyMActLin[countLin] = TempLine.getannuity(this.ActSchematic.intrate);
                this.TenNomLinAct[countLin] = TempLine.getun1();
                this.Longitud[countLin] = TempLine.getlen();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                this.AVNR_COyMAct[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate);
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    slack = this.numbus(TempGenerator.getcon2());
                    this.slackGenerator = countGen;
                    this.slackNode = slack;
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                    System.out.println("slack Owner  = " + this.nomSlackOwner);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            this.TenNomNodAct[countNod] = TempBusbar.getun1();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        this.PGenUnits = new double[this.numactgen][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numactnod - 1; ++ii) {
            for (int jj = 0; jj < this.numactnod - 1; ++jj) {
                MatXX.setElement(ii, jj, MatY.getElement(ii, jj));
            }
        }
        System.out.println(" ");
        System.out.println("Inverting MatXX Matrix");
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        System.out.println("MatXX Matrix Inverted");
        for (i = 0; i < this.numactnod - 1; ++i) {
            for (j = 0; j < this.numactnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numactnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slack));
                }
            }
        }
        this.NV = new Vector();
        this.NV.addElement(new Float(this.TenNomNodAct[0]));
        for (k = 1; k < this.numactnod; ++k) {
            j = 0;
            for (i = 0; i < this.NV.size(); ++i) {
                if (((Float)this.NV.elementAt(i)).doubleValue() != this.TenNomNodAct[k]) continue;
                ++j;
            }
            if (j != 0) continue;
            this.NV.addElement(new Float(this.TenNomNodAct[k]));
        }
        this.CNODEG = new double[this.numactnod];
        this.CNODED = new double[this.numactnod];
        this.CNODRG = new double[this.numactnod];
        this.CNODRD = new double[this.numactnod];
        int idl = 0;
        int idb = 0;
        int idn = 0;
        int idg = 0;
        int idlast = 0;
        this.LinBra = new int[this.numactlin];
        this.InvType = new int[this.numactlin];
        this.CInstG = new double[this.numactgen];
        this.PMa = new double[this.numactlast];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.FLinAct[idl] = this.Flujo[idb];
                    this.CapLinAct[idl] = TempLine.getsmax() / this.sref;
                    this.LinBra[idl] = idb;
                    this.InvType[idl] = TempLine.getinv_type().equals("A") ? 1 : (TempLine.getinv_type().equals("B") ? 2 : 3);
                    ++idl;
                    ++idb;
                }
                if (TempComponent instanceof Trafo) {
                    ++idb;
                }
            }
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                ++idn;
            }
            if (TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                this.CInstG[idg] = TempGenerator.getpmax();
                ++idg;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempLoad = (Load)TempComponent;
            this.PMa[idlast] = TempLoad.getpini();
            ++idlast;
        }
        this.IPSPT = new double[this.NV.size()];
        this.CU = new double[this.NV.size()];
        this.Largos = 0.0;
        this.CUNod = new double[this.numactnod];
        this.CULin = new double[this.numactlin];
        for (k = 0; k < this.NV.size(); ++k) {
            this.Largos = 0.0;
            for (i = 0; i < this.numactlin; ++i) {
                if (!(Math.abs(this.TenNomLinAct[i] - ((Float)this.NV.elementAt(k)).doubleValue()) < 1.0E-5) || this.InvType[i] != 1 && this.InvType[i] != 2) continue;
                int n = k;
                this.IPSPT[n] = this.IPSPT[n] + this.AVNR_COyMActLin[i];
                this.Largos += this.Longitud[i];
            }
            this.CU[k] = Math.abs(this.Largos) < 1.0E-7 ? 0.0 : this.IPSPT[k] / this.Largos;
        }
        for (k = 0; k < this.NV.size(); ++k) {
            for (i = 0; i < this.numactnod; ++i) {
                if (!(Math.abs(((Float)this.NV.elementAt(k)).doubleValue() - this.TenNomNodAct[i]) < 1.0E-5)) continue;
                this.CUNod[i] = this.CU[k];
            }
            for (i = 0; i < this.numactlin; ++i) {
                if (!(Math.abs(((Float)this.NV.elementAt(k)).doubleValue() - this.TenNomLinAct[i]) < 1.0E-5)) continue;
                this.CULin[i] = this.CU[k];
            }
        }
        this.TTRAE = 0.0;
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 1) continue;
            for (k = 0; k < this.NV.size(); ++k) {
                if (!(Math.abs(this.TenNomLinAct[i] - ((Float)this.NV.elementAt(k)).doubleValue()) < 1.0E-5)) continue;
                this.TTRAE += this.CULin[i] * this.Longitud[i];
            }
        }
        this.TTRAR = 0.0;
        for (i = 0; i < this.numactlin; ++i) {
            if (this.InvType[i] != 2) continue;
            for (k = 0; k < this.NV.size(); ++k) {
                if (!(Math.abs(this.TenNomLinAct[i] - ((Float)this.NV.elementAt(k)).doubleValue()) < 1.0E-5)) continue;
                this.TTRAR += this.CULin[i] * this.Longitud[i];
            }
        }
        this.CInstGTot = 0.0;
        this.PMaTot = 0.0;
        this.CInstGZ = new double[this.NZ.size()];
        this.PMaZ = new double[this.NZ.size()];
        block29: for (i = 0; i < this.dimPMNC; ++i) {
            for (j = 0; j < this.NZ.size(); ++j) {
                if (!this.ZonaDB[i].equals((String)this.NZ.elementAt(j))) continue;
                this.PMaZ[j] = this.PMNCDB[i];
                int n = j;
                this.CInstGZ[n] = this.CInstGZ[n] + this.CInstGZDB[i];
                this.PMaTot += this.PMNCDB[i];
                this.CInstGTot += this.CInstGZDB[i];
                continue block29;
            }
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GGDF = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        boolean ix = false;
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }
}

