/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPMWMFrame;
import de.core.TPMWMVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.mdb_wheel;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPMWM
extends AnalysisTool {
    TPMWMFrame MyTPMWMFrame = null;
    TPMWMVisualFrame MyTPMWMVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    int[] AllBranchI;
    int[] AllBranchJ;
    double[] node_pg;
    double[] node_pl;
    int numallnod = -1;
    int numallgen = -1;
    int numalllast = -1;
    int numalllin = -1;
    int numalltrafo = -1;
    int numallbran = -1;
    int numactnod = -1;
    int numactgen = -1;
    int numactlast = -1;
    int numactlin = -1;
    int numacttrafo = -1;
    int numactbran = -1;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBLoad;
    int dimDBYear;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] AllGenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = -1;
    int numallowner = -1;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    Vector BusGen;
    Vector[] Dom;
    Vector[] AlimBus;
    String[] AlimBusName;
    Vector Common;
    int[] Rank;
    int[] Ord;
    int[] BusCom;
    int[] RankCom;
    int[] OrdCom;
    Vector Garbage;
    double[] I;
    double[] E;
    double[] G;
    double[][] C;
    double[][] FL;
    double[][][] FLG;
    int block1;
    int hidro1;
    int block2;
    int hidro2;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int ndem;
    double[] FlujoMensual;
    double[] FlujoAnual;
    double[] mensual_pg;
    double[] anual_pg;
    int[] FrecFlujo;
    int[] Frec_pg;
    int[] BranCom;
    int[] ComI;
    int[] ComJ;
    double[][] ProAnual;
    int anos = 0;
    double[][] mensualOwner_pg;
    double[][] anualOwner_pg;
    int[][] OFrec_pg;
    double[][] OProAnual;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int[][] FreProAnual;
    int[][] FreOProAnual;
    int numactcontrato = -1;
    String[] NomActContrato;
    int[] BGW;
    int[] BCW;
    double[] Largo;
    double[] MWkmRama;
    double[][] MWkmDelta;
    double[] MWkmContrato;
    double[] CMWkmDB;
    String[] NMWkmDB;
    int dimDBCost;
    double[] Pc;
    private double sref = this.getSref();

    public TPMWM(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPMWM ------------");
        if (this.MyTPMWMFrame == null) {
            this.MyTPMWMFrame = new TPMWMFrame(this);
        } else {
            this.MyTPMWMFrame.setVisible(true);
        }
    }

    public TPMWM(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH) {
        super(sch);
        System.out.println("---------- In TPMWM ------------ 1");
        this.Calculate(CTRLA, rep, vis, DBrep, SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH);
    }

    public TPMWM(Schematic sch, boolean VisDB) {
        super(sch);
        System.out.println("---------- In TPMWM ------------ 2");
        this.InitAllNetwork();
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH) {
        int j;
        int i;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPMWM.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork();
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork();
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH);
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            int FY = this.ny1;
            int LY = this.ny2;
            int FM = this.nm1;
            int LM = this.nm2;
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            this.anos = 0;
            for (int y = this.year1; y <= this.year2; ++y) {
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : 12;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int ii;
                    System.out.println(" ");
                    System.out.println("-------------------------------");
                    System.out.println(" IN MONTH " + m + " CALCULATION");
                    System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                    System.out.println("-------------------------------");
                    if (this.Plan_Obra(y, m)) {
                        System.out.println(" Month " + m + " ESTA en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPMWM.numformat(this.year1, 8) + "/" + TPMWM.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPMWM.numformat(this.year2, 8) + "/" + TPMWM.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPMWM.numformat(y, 8) + "/" + TPMWM.numformat(m, 8));
                        this.ActSchematic.setactperiod(y);
                        this.ActSchematic.setactmonth(m);
                        this.ActSchematic.Modifiedstate = true;
                        this.ActSchematic.Modified = true;
                        this.ActSchematic.CheckActive();
                        System.out.println(" ");
                        System.out.println("Making GetActiveNetwork");
                        this.GetActiveNetwork();
                        System.out.println("GetActiveNetwork    Done");
                        System.out.println(" ");
                        if (this.MyDCLF != null) {
                            this.MyDCLF = null;
                        }
                        this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    } else {
                        System.out.println(" Month " + m + " NO esta en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPMWM.numformat(this.year1, 8) + "/" + TPMWM.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPMWM.numformat(this.year2, 8) + "/" + TPMWM.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPMWM.numformat(y, 8) + "/" + TPMWM.numformat(m, 8));
                    }
                    if (this.AProrrateoAct != null) {
                        this.AProrrateoAct = null;
                    }
                    this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                    if (this.AOProrrateoAct != null) {
                        this.AOProrrateoAct = null;
                    }
                    this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                    for (i = 0; i < this.numactbran; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.AProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactowner; ++j) {
                            this.AOProrrateoAct[i][j] = 0.0;
                        }
                    }
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    for (int b = limblock1; b <= limblock2; ++b) {
                        System.out.println(" ");
                        System.out.println("  ........................................");
                        System.out.println("   IN BLOCK " + b + " CALCULATION");
                        System.out.println("   Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                        System.out.print("  ");
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            if (y == this.year1 && m == this.month1 && this.nitera == 0) {
                                System.out.println("    This is the first seleted flow!");
                                System.out.println("      DCLF variables initialization ... ");
                                this.ActSchematic.setactperiod(y);
                                this.ActSchematic.setactmonth(m);
                                this.ActSchematic.Modifiedstate = true;
                                this.ActSchematic.Modified = true;
                                this.ActSchematic.CheckActive();
                                System.out.println(" ");
                                System.out.println("Making GetActiveNetwork");
                                this.GetActiveNetwork();
                                System.out.println("GetActiveNetwork    Done");
                                System.out.println(" ");
                                if (this.MyDCLF != null) {
                                    this.MyDCLF = null;
                                }
                                this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                                if (this.AProrrateoAct != null) {
                                    this.AProrrateoAct = null;
                                }
                                this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                                if (this.AOProrrateoAct != null) {
                                    this.AOProrrateoAct = null;
                                }
                                this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                                for (i = 0; i < this.numactbran; ++i) {
                                    for (j = 0; j < this.numactnod; ++j) {
                                        this.AProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactowner; ++j) {
                                        this.AOProrrateoAct[i][j] = 0.0;
                                    }
                                }
                            }
                            System.out.print(".");
                            this.build_Injection(y, m, b, h);
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo);
                            this.node_pg[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pg[n] = this.node_pg[n] + this.Flujo[i];
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pg[n] = this.node_pg[n] - this.Flujo[i];
                            }
                            this.node_pg[this.slackNode] = Math.max(0.0, this.node_pg[this.slackNode]);
                            this.node_pl[this.slackNode] = Math.abs(Math.min(0.0, this.node_pg[this.slackNode]));
                            if (this.node_pg[this.slackNode] >= 0.0) {
                                this.PGenOwn[this.slackOwner][this.slackNode] = this.node_pg[this.slackNode] * 100.0;
                            }
                            for (i = 0; i < this.numactbran; ++i) {
                                int n = i;
                                this.FlujoMensual[n] = this.FlujoMensual[n] + this.Flujo[i];
                            }
                            for (i = 0; i < this.numactnod; ++i) {
                                int n = i;
                                this.mensual_pg[n] = this.mensual_pg[n] + this.node_pg[i];
                            }
                            for (i = 0; i < this.numactowner; ++i) {
                                for (j = 0; j < this.numactnod; ++j) {
                                    double[] dArray = this.mensualOwner_pg[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + this.PGenOwn[i][j];
                                }
                            }
                            ++this.nitera;
                        }
                    }
                    for (i = 0; i < this.numactbran; ++i) {
                        this.FlujoMensual[i] = this.FlujoMensual[i] / (double)this.nitera;
                    }
                    for (i = 0; i < this.numactnod; ++i) {
                        this.mensual_pg[i] = this.mensual_pg[i] / (double)this.nitera;
                    }
                    for (i = 0; i < this.numactowner; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.mensualOwner_pg[i][j] = this.mensualOwner_pg[i][j] / (double)this.nitera;
                        }
                    }
                    boolean kiebra = false;
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Mensual de flujos promedio");
                    block25: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (this.NomActBra[ii].equals(this.NomBra[i])) {
                                int n = i;
                                this.FlujoAnual[n] = this.FlujoAnual[n] + this.FlujoMensual[ii];
                                int n2 = i;
                                this.FrecFlujo[n2] = this.FrecFlujo[n2] + 1;
                                kiebra = true;
                                continue block25;
                            }
                            kiebra = false;
                            if (kiebra) continue block25;
                        }
                    }
                    kiebra = false;
                    block27: for (ii = 0; ii < this.numactnod; ++ii) {
                        for (i = ii; i < this.numallnod; ++i) {
                            if (this.NomActNod[ii].equals(this.NomNod[i])) {
                                int n = i;
                                this.anual_pg[n] = this.anual_pg[n] + this.mensual_pg[ii];
                                int n3 = i;
                                this.Frec_pg[n3] = this.Frec_pg[n3] + 1;
                                kiebra = true;
                                continue block27;
                            }
                            kiebra = false;
                            if (kiebra) continue block27;
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactnod; ++ii) {
                        for (int jj = 0; jj < this.numactowner; ++jj) {
                            for (i = 0; i < this.numallnod; ++i) {
                                for (j = 0; j < this.numallowner; ++j) {
                                    if (!this.NomActNod[ii].equals(this.NomNod[i]) || !this.NomActOwner[jj].equals(this.NomOwner[j])) continue;
                                    double[] dArray = this.anualOwner_pg[j];
                                    int n = i;
                                    dArray[n] = dArray[n] + this.mensualOwner_pg[jj][ii];
                                    int[] nArray = this.OFrec_pg[j];
                                    int n4 = i;
                                    nArray[n4] = nArray[n4] + 1;
                                }
                            }
                        }
                    }
                    System.out.println("   - Flujos promedio actualizados ");
                    for (i = 0; i < this.numactnod; ++i) {
                        this.mensual_pg[i] = 0.0;
                        for (j = 0; j < this.numactowner; ++j) {
                            this.mensualOwner_pg[j][i] = 0.0;
                        }
                    }
                    for (j = 0; j < this.numactbran; ++j) {
                        this.FlujoMensual[j] = 0.0;
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    if (this.FrecFlujo[i] <= 0) continue;
                    this.FlujoAnual[i] = this.FlujoAnual[i] / (double)this.FrecFlujo[i];
                }
                for (i = 0; i < this.numallnod; ++i) {
                    if (this.Frec_pg[i] <= 0) continue;
                    this.anual_pg[i] = this.anual_pg[i] / (double)this.Frec_pg[i];
                }
                for (i = 0; i < this.numallnod; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (this.OFrec_pg[j][i] <= 0) continue;
                        this.anualOwner_pg[j][i] = this.anualOwner_pg[j][i] / (double)this.OFrec_pg[j][i] / 100.0;
                    }
                }
                ++this.anos;
                for (i = 0; i < this.numallnod; ++i) {
                    this.anual_pg[i] = 0.0;
                    this.Frec_pg[i] = 0;
                    for (j = 0; j < this.numallowner; ++j) {
                        this.anualOwner_pg[j][i] = 0.0;
                        this.OFrec_pg[j][i] = 0;
                    }
                }
                for (j = 0; j < this.numallbran; ++j) {
                    this.FlujoAnual[j] = 0.0;
                    this.FrecFlujo[j] = 0;
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            System.out.println(" ");
            System.out.println("Building MWkm");
            this.build_MWkm();
            System.out.println("Building MWkm Done");
            System.out.println(" ");
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    if (this.FreProAnual[i][j] <= 0) continue;
                    this.Prorrateo[i][j] = 100.0 * this.ProAnual[i][j] / (double)this.FreProAnual[i][j];
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallowner; ++j) {
                    if (this.FreOProAnual[i][j] <= 0) continue;
                    this.OProrrateo[i][j] = 100.0 * this.OProAnual[i][j] / (double)this.FreOProAnual[i][j];
                }
            }
            if (rep) {
                System.out.println("Making Report File");
                System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Total Barras         : " + this.numallnod);
                this.myPPrintStream.println("Total Ramas          : " + this.numallbran);
                this.myPPrintStream.println("Total Generadores    : " + this.numallgen);
                this.myPPrintStream.println("Total Cargas         : " + this.numalllast);
                this.myPPrintStream.println("Total L\u00edneas         : " + this.numalllin);
                this.myPPrintStream.println("Total Transformadores: " + this.numalltrafo);
                this.myPPrintStream.println("Total Execution Time : " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ************************");
                this.myPPrintStream.println(" Informaci\u00f3n de contratos");
                this.myPPrintStream.println(" ************************");
                this.myPPrintStream.println(" Contrato    -    Nodo Oferta    -    Nodo Demanda");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numactcontrato; ++i) {
                    this.myPPrintStream.println(TPMWM.strformat(this.NomActContrato[i], 8) + "    -    " + TPMWM.strformat(this.NomActNod[this.BGW[i]], 8) + "    -    " + TPMWM.strformat(this.NomActNod[this.BCW[i]], 8));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" **********");
                this.myPPrintStream.println(" Los Flujos");
                this.myPPrintStream.println(" **********");
                this.myPPrintStream.println(" Nombre rama    -    Flujo");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numactbran; ++i) {
                    this.myPPrintStream.println(this.NomActBra[i] + "    -    " + this.Flujo[i]);
                }
                this.myPPrintStream.println(" ");
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        if (DBrep) {
            try {
                System.out.println("-Saving TPResDB ... ");
                System.out.println(" Time = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                Statement s = conTPResDB.createStatement();
                s.executeUpdate("DELETE * FROM MWM_Barra");
                s.executeUpdate("DELETE * FROM MWM_Empresa");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (this.Prorrateo[i][j] == 0.0) continue;
                        s.executeUpdate("INSERT INTO MWM_Barra (rama,barra,prorrata) VALUES ('" + this.NomBra[i] + "','" + this.NomNod[j] + "'," + this.Prorrateo[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (this.OProrrateo[i][j] == 0.0) continue;
                        s.executeUpdate("INSERT INTO MWM_Empresa (rama,empresa,prorrata) VALUES ('" + this.NomBra[i] + "','" + this.NomOwner[j] + "'," + this.OProrrateo[i][j] + ")");
                    }
                }
                System.out.println("");
                System.out.println("-TPResDB Saved ");
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Guardar Base de Datos " + e);
                e.printStackTrace();
            }
        }
        System.out.println("TOTAL EXECUTION TIME = " + TPMWM.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/TPMWM.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
        if (vis) {
            if (this.MyTPMWMVisualFrame == null) {
                this.MyTPMWMVisualFrame = new TPMWMVisualFrame(this, this.ctrla, false);
            } else {
                this.MyTPMWMVisualFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("TPMWM Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
        if (!vis) {
            this.finalize();
        }
    }

    public void InitAllNetwork() {
        int j;
        int i;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement((Busbar)TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.LosOwner = new String[this.numallgen];
        this.FlujoAnual = new double[this.numallbran];
        this.FrecFlujo = new int[this.numallbran];
        this.anual_pg = new double[this.numallnod];
        this.Frec_pg = new int[this.numallnod];
        this.AllBranchI = new int[this.numallbran];
        this.AllBranchJ = new int[this.numallbran];
        this.AllGenNode = new int[this.numallgen];
        this.BranCom = new int[this.numallbran];
        this.ComI = new int[this.numallbran];
        this.ComJ = new int[this.numallbran];
        this.ProAnual = new double[this.numallbran][this.numallnod];
        this.FreProAnual = new int[this.numallbran][this.numallnod];
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempLine.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempLine.getcon2());
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempTrafo.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempTrafo.getcon2());
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                this.LosOwner[countGen] = TempGenerator.getinv_owner();
                this.AllGenNode[countGen] = this.numbusALL(TempGenerator.getcon2());
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            ++countLas;
        }
        int aux = 0;
        if (this.numallgen >= 2) {
            for (int i2 = 0; i2 < this.numallgen; ++i2) {
                aux = 0;
                for (int j2 = i2 + 1; j2 < this.numallgen; ++j2) {
                    if (!this.LosOwner[i2].equals(this.LosOwner[j2])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallowner;
            }
        } else {
            this.numallowner = this.numallgen;
        }
        this.OProrrateo = new double[this.numallbran][this.numallowner];
        this.OFrecuencia = new int[this.numallbran][this.numallowner];
        this.Prorrateo = new double[this.numallbran][this.numallnod];
        this.Frecuencia = new int[this.numallbran][this.numallnod];
        this.NomOwner = new String[this.numallowner];
        this.anualOwner_pg = new double[this.numallowner][this.numallnod];
        this.OFrec_pg = new int[this.numallowner][this.numallnod];
        this.OProAnual = new double[this.numallbran][this.numallowner];
        this.FreOProAnual = new int[this.numallbran][this.numallowner];
        aux = 0;
        int cmul = 0;
        if (this.numallgen >= 2) {
            for (i = 0; i < this.numallgen; ++i) {
                aux = 0;
                for (j = i + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomOwner[cmul] = this.LosOwner[i];
                ++cmul;
            }
        } else {
            this.NomOwner[0] = this.LosOwner[0];
        }
        for (i = 0; i < this.numallbran; ++i) {
            this.FlujoAnual[i] = 0.0;
            this.FrecFlujo[i] = 0;
            for (int jj = 0; jj < this.numallowner; ++jj) {
                this.OProAnual[i][jj] = 0.0;
                this.OProrrateo[i][jj] = 0.0;
                this.OFrecuencia[i][jj] = 0;
                this.FreOProAnual[i][jj] = 0;
            }
            for (j = 0; j < this.numallnod; ++j) {
                this.FreProAnual[i][j] = 0;
                this.ProAnual[i][j] = 0.0;
                this.Prorrateo[i][j] = 0.0;
                this.Frecuencia[i][j] = 0;
            }
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro) {
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
        this.PDCLF = new double[this.numactnod];
        double FactorCreci = Math.pow(1.3, ano - 1);
        for (i = 0; i < this.numactnod; ++i) {
            this.PDCLF[i] = 0.0;
            this.node_pg[i] = 0.0;
            this.node_pl[i] = 0.0;
            for (int k = 0; k < this.numactowner; ++k) {
                this.PGenOwn[k][i] = 0.0;
            }
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        int NroDdaActual = -1;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                block3: for (i = 0; i < this.dimDBGen; ++i) {
                    if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                    int n = this.GenNode[countG];
                    this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                    int n2 = this.GenNode[countG];
                    this.node_pg[n2] = this.node_pg[n2] + this.PDB[i] / this.sref;
                    this.TotGen += this.PDB[i];
                    for (int k = 0; k < this.numactowner; ++k) {
                        if (!this.NomActOwner[k].equals(TempGenerator.getinv_owner())) continue;
                        double[] dArray = this.PGenOwn[k];
                        int n3 = this.GenNode[countG];
                        dArray[n3] = dArray[n3] + this.PDB[i];
                        break block3;
                    }
                    break;
                }
                ++countG;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            NroDdaActual = this.BlockNumberDB * (mes - 1) + bloque;
            for (i = 0; i < this.dimDBLoad; ++i) {
                if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                int n = this.LasNode[countL];
                this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                this.TotDem += this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                int n4 = this.LasNode[countL];
                this.node_pl[n4] = this.node_pl[n4] + this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                break;
            }
            ++countL;
        }
    }

    public void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa) {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
            this.year1 = Integer.parseInt(SDYa);
            this.year2 = Integer.parseInt(EDYa);
            for (i = 0; i < 12; ++i) {
                if (mes[i].equals(SDMa)) {
                    this.month1 = i + 1;
                }
                if (!mes[i].equals(EDMa)) continue;
                this.month2 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.block2 = Integer.parseInt(EDBa);
            this.hidro2 = Integer.parseInt(EDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            this.flow2 = ((this.year2 - this.InitialYearDB) * 12 + (this.month2 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block2 - 1) * this.HydroNumberDB + this.hidro2;
            if (this.flow2 < this.flow1) {
                System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
                int mulanga = this.flow2;
                this.flow2 = this.flow1;
                this.flow1 = mulanga;
                System.out.println(" ........ Problema resuelto autom\u00e1ticamente (inverse selection)");
            }
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("Flow Selection Details");
            System.out.println("----------------------");
            System.out.println("Total DB flows  :    " + tflo);
            System.out.println("Total DB years  :    " + this.YearNumberDB);
            System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
            System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
            System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
            System.out.println("Inicio          :" + TPMWM.numformat(this.year1, 8) + "/" + TPMWM.numformat(this.month1, 8) + "/" + TPMWM.numformat(this.block1, 8) + "/" + TPMWM.numformat(this.hidro1, 8) + "/" + TPMWM.numformat(this.flow1, 8));
            System.out.println("Final           :" + TPMWM.numformat(this.year2, 8) + "/" + TPMWM.numformat(this.month2, 8) + "/" + TPMWM.numformat(this.block2, 8) + "/" + TPMWM.numformat(this.hidro2, 8) + "/" + TPMWM.numformat(this.flow2, 8));
            System.out.println(" ");
            this.ndem = this.BlockNumberDB * 12;
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
            i = 0;
            while (r2.next()) {
                ++i;
            }
            this.dimDBLoad = i;
            this.NameLDB = new String[this.dimDBLoad];
            this.PLDB = new double[this.dimDBLoad][this.ndem];
            for (i = 0; i < this.dimDBLoad; ++i) {
                this.NameLDB[i] = "nada";
                for (j = 1; j <= this.ndem; ++j) {
                    this.PLDB[i][j - 1] = 123456.0;
                }
            }
            r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
            i = 0;
            while (r2.next()) {
                this.NameLDB[i] = r2.getString("name");
                for (j = 1; j <= this.ndem; ++j) {
                    this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                }
                ++i;
            }
            ResultSet r3 = s.executeQuery("SELECT Year\tFROM loadPower   ORDER BY Year");
            i = 0;
            while (r3.next()) {
                ++i;
            }
            this.dimDBYear = i;
            this.TotDemDB = new double[this.dimDBYear][this.ndem];
            this.HidYearNameLDB = new int[this.dimDBYear];
            for (i = 0; i < this.dimDBYear; ++i) {
                this.HidYearNameLDB[i] = 1;
                for (j = 1; j <= this.ndem; ++j) {
                    this.TotDemDB[i][j - 1] = 123456.0;
                }
            }
            r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY Year");
            i = 0;
            while (r3.next()) {
                this.HidYearNameLDB[i] = r3.getInt("Year");
                for (j = 1; j <= this.ndem; ++j) {
                    this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                }
                ++i;
            }
            ResultSet r5 = s.executeQuery("SELECT cost\tFROM costMWkm");
            i = 0;
            while (r5.next()) {
                ++i;
            }
            this.dimDBCost = i;
            this.CMWkmDB = new double[this.dimDBCost];
            this.NMWkmDB = new String[this.dimDBCost];
            r5 = s.executeQuery("SELECT *\tFROM costMWkm");
            i = 0;
            while (r5.next()) {
                this.NMWkmDB[i] = r5.getString("name");
                this.CMWkmDB[i] = r5.getDouble("cost");
                ++i;
            }
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = 12;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = TempNdb_comp.getentry_period();
            m1 = TempNdb_comp.getentry_month();
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = nmes;
            int rano = nano;
            if (rmes == 1) {
                rmes = 12;
                --rano;
            } else if (rmes >= 2 && rmes <= 12) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork() {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        this.numactcontrato = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempComponent instanceof mdb_wheel) {
                TempComponent.InformAllComponents();
                ++this.numactcontrato;
                continue;
            }
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.Flujo != null || this.GenNode != null || this.LasNode != null || this.node_pl != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.node_pl = null;
            this.Flujo = null;
            this.GenNode = null;
            this.LasNode = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.node_pl = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.FlujoMensual = new double[this.numactbran];
        this.mensual_pg = new double[this.numactnod];
        this.NomActContrato = new String[this.numactcontrato];
        this.BGW = new int[this.numactcontrato];
        this.BCW = new int[this.numactcontrato];
        this.MWkmRama = new double[this.numactbran];
        this.Largo = new double[this.numactbran];
        this.MWkmDelta = new double[this.numactbran][this.numactcontrato];
        this.MWkmContrato = new double[this.numactcontrato];
        this.Pc = new double[this.numactcontrato];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
            this.node_pl[ixi] = 0.0;
            this.mensual_pg[ixi] = 0.0;
            for (int colu = 0; colu < this.numactnod; ++colu) {
                this.MatX.setElement(ixi, colu, 0.0);
                MatY.setElement(ixi, colu, 0.0);
            }
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
            this.FlujoMensual[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        int countContrato = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GGDF = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                this.Largo[countBra] = TempLine.getlen();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                this.Largo[countBra] = 1.0;
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slackNode = slack = this.numbus(TempGenerator.getcon2());
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof mdb_wheel)) continue;
            mdb_wheel TempContrato = (mdb_wheel)TempComponent;
            this.NomActContrato[countContrato] = TempContrato.getName();
            this.Pc[countContrato] = TempContrato.getenergy() * 1000.0;
            for (i = 0; i < this.numactgen; ++i) {
                if (!this.NomActGen[i].equals(TempContrato.getparty1().getName())) continue;
                this.BGW[countContrato] = this.GenNode[i];
                break;
            }
            for (i = 0; i < this.numactlast; ++i) {
                if (!this.NomActLas[i].equals(TempContrato.getparty2().getName())) continue;
                this.BCW[countContrato] = this.LasNode[i];
                break;
            }
            ++countContrato;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        this.mensualOwner_pg = new double[this.numactowner][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numactnod - 1; ++ii) {
            for (int jj = 0; jj < this.numactnod - 1; ++jj) {
                MatXX.setElement(ii, jj, MatY.getElement(ii, jj));
            }
        }
        System.out.println(" ");
        System.out.println("Inverting MatXX Matrix");
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        System.out.println("MatXX Matrix Inverted");
        for (i = 0; i < this.numactnod - 1; ++i) {
            for (j = 0; j < this.numactnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numactnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slack));
                }
            }
        }
    }

    public void build_MWkm() {
        int i = -1;
        int j = -1;
        int k = -1;
        double[][] AGEN = new double[this.numactbran][this.numactnod];
        double[] PFAF = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            PFAF[i] = 0.0;
            for (j = 0; j < this.numactnod; ++j) {
                AGEN[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                AGEN[i][j] = this.node_pg[j] > 0.0 && this.GSDFS.getElement(i, j) * this.Flujo[i] > 0.0 ? this.GSDFS.getElement(i, j) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                if (AGEN[i][j] > 1.0) {
                    AGEN[i][j] = 1.0;
                }
                if (AGEN[i][j] < -1.0) {
                    AGEN[i][j] = -1.0;
                }
                PFAF[i] = PFAF[i] + AGEN[i][j] * this.node_pg[j];
            }
        }
        for (k = 0; k < this.numactcontrato; ++k) {
            block7: for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.dimDBCost; ++j) {
                    if (!this.NMWkmDB[j].equals(this.NomActBra[i])) continue;
                    this.MWkmRama[i] = this.Flujo[i] * this.Largo[i] * this.CMWkmDB[j];
                    this.MWkmDelta[i][k] = (this.GSDFS.getElement(i, this.BGW[k]) - this.GSDFS.getElement(i, this.BCW[k])) * this.Pc[k] * this.Largo[i] * this.CMWkmDB[j];
                    continue block7;
                }
            }
        }
        double TMWkm = 0.0;
        double[] PagoContrato = new double[this.numactcontrato];
        double[] Proporcion = new double[this.numactcontrato];
        for (i = 0; i < this.numactbran; ++i) {
            TMWkm += Math.abs(this.MWkmRama[i]);
        }
        for (i = 0; i < this.numactcontrato; ++i) {
            PagoContrato[i] = 0.0;
            Proporcion[i] = 0.0;
        }
        for (k = 0; k < this.numactcontrato; ++k) {
            for (i = 0; i < this.numactbran; ++i) {
                int n = k;
                PagoContrato[n] = PagoContrato[n] + Math.abs(this.MWkmDelta[i][k]);
            }
        }
        if (TMWkm > 1.0E-6) {
            for (k = 0; k < this.numactcontrato; ++k) {
                Proporcion[k] = PagoContrato[k] / TMWkm;
            }
        }
        this.myPPrintStream.println(" ");
        this.myPPrintStream.println(" MWkmRama ");
        for (i = 0; i < this.numactbran; ++i) {
            this.myPPrintStream.println(" MWkmRama[" + this.NomActBra[i] + "] = " + this.MWkmRama[i]);
        }
        this.myPPrintStream.println(" ");
        this.myPPrintStream.println(" MWkmDelta");
        for (k = 0; k < this.numactcontrato - 1; ++k) {
            this.myPPrintStream.print(TPMWM.strformat(this.NomActContrato[k], 10) + "   ");
        }
        this.myPPrintStream.println(TPMWM.strformat(this.NomActContrato[this.numactcontrato - 1], 10) + "   ");
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactcontrato - 1; ++k) {
                if (k == 0) {
                    this.myPPrintStream.print(TPMWM.strformat(this.NomActBra[i], 10) + "   ");
                }
                this.myPPrintStream.print(TPMWM.numformat(this.MWkmDelta[i][k], 10, 3) + "   ");
            }
            this.myPPrintStream.println(TPMWM.numformat(this.MWkmDelta[i][this.numactcontrato - 1], 10, 3));
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.node_pl = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GGDF = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }
}

