/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.TPBarFrame;
import de.core.TPKirschen;
import de.core.TPPieFrame;
import de.core.TPUnitsSelectionDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

class TPKirschenVisualFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoicename = null;
    Choice MyChoicecriteria = null;
    Choice MyChoiceline = null;
    Choice MyChoicelinecriteria = null;
    Choice MyChoicetrafo = null;
    Choice MyChoicetrafocriteria = null;
    TPKirschen MySensi = null;
    Button button1;
    Button button2;
    Button button3;
    Button button4;
    Button button5;
    Button button6;
    Button button7;
    Button button8;
    Button button9;
    Button button71;
    Button button81;
    Button button91;
    Choice MyChoicesup = null;
    Choice MyChoicesupcriteria = null;
    Button button5s;
    Button button6s;
    Button button9s;
    Button button91s;
    comp TempComponent;
    double[] sensi;
    double[] osensi;
    double GenTot = 0.0;
    String[] NomGen;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomNod;
    PrintStream myPPrintStream;
    FileOutputStream os;
    boolean VisFromDB = false;
    String[] BarrasDB;
    String[] RamasDB;
    double[] ProrratasDB;
    String[] EmpresasDB;
    String[] ERamasDB;
    double[] EProrratasDB;
    int dimDB1 = -1;
    int dimDB2 = -1;
    double[] PagoDB;
    double[] EPagoDB;
    double[] sensi2;
    double[] osensi2;
    Button button5sG;
    Button button6sG;
    Button button91sG;
    Vector lista;
    double[] usensi;
    double[] usensi2;
    String[] UnitsDB;
    String[] URamasDB;
    double[] PUnitsDB;
    double[] PagoUnitsDB;
    int dimDB3 = -1;
    double[] gsensi;
    double[] gsensi2;

    public TPKirschenVisualFrame(TPKirschen aaSensi, String ctrla, boolean VisFromDBo) {
        super("TP Kirschen visualization parameters");
        int ix;
        this.setBackground(Color.lightGray);
        this.MySensi = aaSensi;
        this.VisFromDB = VisFromDBo;
        this.lista = new Vector();
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "TRANSMISSION PRICING Kirschen VISUALIZATION", gridbag, c, Color.blue);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Visualization of the cost allocation between participants.", gridbag, c, Color.black);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Selected Control Area: " + ctrla, gridbag, c, Color.red);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Generator: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicename = new Choice();
        this.MyChoicecriteria = new Choice();
        this.NomBra = new String[this.MySensi.numallbran];
        this.NomLin = new String[this.MySensi.numalllin];
        this.NomTra = new String[this.MySensi.numalltrafo];
        this.NomNod = new String[this.MySensi.numallnod];
        this.NomGen = new String[this.MySensi.numallgen];
        int countB = 0;
        int countL = 0;
        int countT = 0;
        int countN = 0;
        int countG = 0;
        this.GenTot = 0.0;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice()) continue;
            if (this.TempComponent instanceof Busbar) {
                this.NomNod[countN] = this.TempComponent.getName();
                ++countN;
            }
            if (this.TempComponent instanceof Line) {
                this.NomLin[countL] = this.TempComponent.getName();
                this.NomBra[countB] = this.TempComponent.getName();
                ++countL;
                ++countB;
            }
            if (this.TempComponent instanceof Trafo) {
                this.NomTra[countT] = this.TempComponent.getName();
                this.NomBra[countB] = this.TempComponent.getName();
                ++countT;
                ++countB;
            }
            if (!(this.TempComponent instanceof Generator)) continue;
            this.MyChoicename.addItem(this.TempComponent.getName());
            Generator TempInj = (Generator)this.TempComponent;
            this.NomGen[countG] = TempInj.getName();
            this.GenTot += TempInj.getp();
            ++countG;
        }
        this.MyChoicecriteria.addItem("Kirschen");
        gridbag.setConstraints(this.MyChoicename, c);
        gridbag.setConstraints(this.MyChoicecriteria, c);
        this.add(this.MyChoicename);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicecriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.button1 = new Button("Show");
        this.button1.setActionCommand("Show");
        this.button1.addActionListener(this);
        gridbag.setConstraints(this.button1, c);
        this.add(this.button1);
        this.button2 = new Button("Exit");
        this.button2.setActionCommand("Exit");
        this.button2.addActionListener(this);
        gridbag.setConstraints(this.button2, c);
        this.add(this.button2);
        this.button7 = new Button("Selected Generator");
        this.button7.setActionCommand("SelectBusbar");
        this.button7.addActionListener(this);
        gridbag.setConstraints(this.button7, c);
        this.add(this.button7);
        this.button71 = new Button("Show Detail");
        this.button71.setActionCommand("MakeFileBus");
        this.button71.addActionListener(this);
        gridbag.setConstraints(this.button71, c);
        this.add(this.button71);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Line: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoiceline = new Choice();
        this.MyChoicelinecriteria = new Choice();
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof Line)) continue;
            this.MyChoiceline.addItem(this.TempComponent.getName());
        }
        this.MyChoicelinecriteria.addItem("Kirschen");
        gridbag.setConstraints(this.MyChoiceline, c);
        gridbag.setConstraints(this.MyChoicelinecriteria, c);
        this.add(this.MyChoiceline);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicelinecriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.button3 = new Button("Show");
        this.button3.setActionCommand("Showline");
        this.button3.addActionListener(this);
        gridbag.setConstraints(this.button3, c);
        this.add(this.button3);
        this.button4 = new Button("Exit");
        this.button4.setActionCommand("Exit");
        this.button4.addActionListener(this);
        gridbag.setConstraints(this.button4, c);
        this.add(this.button4);
        this.button8 = new Button("Selected Line");
        this.button8.setActionCommand("SelectLine");
        this.button8.addActionListener(this);
        gridbag.setConstraints(this.button8, c);
        this.add(this.button8);
        this.button81 = new Button("Show Detail");
        this.button81.setActionCommand("MakeFileLine");
        this.button81.addActionListener(this);
        gridbag.setConstraints(this.button81, c);
        this.add(this.button81);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Transformer: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicetrafo = new Choice();
        this.MyChoicetrafocriteria = new Choice();
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof Trafo)) continue;
            this.MyChoicetrafo.addItem(this.TempComponent.getName());
        }
        this.MyChoicetrafocriteria.addItem("Kirschen");
        gridbag.setConstraints(this.MyChoicetrafo, c);
        gridbag.setConstraints(this.MyChoicetrafocriteria, c);
        this.add(this.MyChoicetrafo);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicetrafocriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.button5 = new Button("Show");
        this.button5.setActionCommand("Showtrafo");
        this.button5.addActionListener(this);
        gridbag.setConstraints(this.button5, c);
        this.add(this.button5);
        this.button6 = new Button("Exit");
        this.button6.setActionCommand("Exit");
        this.button6.addActionListener(this);
        gridbag.setConstraints(this.button6, c);
        this.add(this.button6);
        this.button9 = new Button("Selected Transformer");
        this.button9.setActionCommand("SelectTrafo");
        this.button9.addActionListener(this);
        gridbag.setConstraints(this.button9, c);
        this.add(this.button9);
        this.button91 = new Button("Show Detail");
        this.button91.setActionCommand("MakeFileTrafo");
        this.button91.addActionListener(this);
        gridbag.setConstraints(this.button91, c);
        this.add(this.button91);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Supplier: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicesup = new Choice();
        this.MyChoicesupcriteria = new Choice();
        int aux = 0;
        int cogen = 0;
        for (int ix2 = 0; ix2 < this.MySensi.ActSchematic.Components.size(); ++ix2) {
            this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix2);
            if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof ndb_inj)) continue;
            Generator TempInj1 = (Generator)this.TempComponent;
            if (cogen == 0) {
                this.MyChoicesup.addItem(TempInj1.getinv_owner());
            } else {
                aux = 0;
                for (int cx = 0; cx < this.MyChoicesup.getItemCount(); ++cx) {
                    if (!this.MyChoicesup.getItem(cx).equals(TempInj1.getinv_owner())) continue;
                    ++aux;
                }
                if (aux == 0) {
                    this.MyChoicesup.addItem(TempInj1.getinv_owner());
                }
            }
            ++cogen;
        }
        this.MyChoicesupcriteria.addItem("Kirschen");
        gridbag.setConstraints(this.MyChoicesup, c);
        gridbag.setConstraints(this.MyChoicesupcriteria, c);
        this.add(this.MyChoicesup);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicesupcriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.button5s = new Button("Show");
        this.button5s.setActionCommand("Showsup");
        this.button5s.addActionListener(this);
        gridbag.setConstraints(this.button5s, c);
        this.add(this.button5s);
        this.button6s = new Button("Exit");
        this.button6s.setActionCommand("Exit");
        this.button6s.addActionListener(this);
        gridbag.setConstraints(this.button6s, c);
        this.add(this.button6s);
        this.button9s = new Button("Selected Generator");
        this.button9s.setActionCommand("SelectGenerator");
        this.button9s.addActionListener(this);
        gridbag.setConstraints(this.button9s, c);
        this.add(this.button9s);
        this.button91s = new Button("Show Detail");
        this.button91s.setActionCommand("MakeFileSup");
        this.button91s.addActionListener(this);
        gridbag.setConstraints(this.button91s, c);
        this.add(this.button91s);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Units: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button buttonsel = new Button("pick");
        gridbag.setConstraints(buttonsel, c);
        this.add(buttonsel);
        buttonsel.setActionCommand("pick");
        buttonsel.addActionListener(this);
        this.button5sG = new Button("Paint Network");
        this.button5sG.setActionCommand("Paint Network");
        this.button5sG.addActionListener(this);
        gridbag.setConstraints(this.button5sG, c);
        this.add(this.button5sG);
        this.button91sG = new Button("Show Detail");
        this.button91sG.setActionCommand("MakeFileGroup");
        this.button91sG.addActionListener(this);
        gridbag.setConstraints(this.button91sG, c);
        this.add(this.button91sG);
        this.button6sG = new Button("Exit");
        this.button6sG.setActionCommand("Exit");
        this.button6sG.addActionListener(this);
        gridbag.setConstraints(this.button6sG, c);
        this.add(this.button6sG);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TPKirschenVisualFrame.this.setVisible(false);
                TPKirschenVisualFrame.this.dispose();
                try {
                    TPKirschenVisualFrame.this.MySensi.MyColorSpec.setVisible(false);
                    TPKirschenVisualFrame.this.MySensi.MyColorSpec.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TPKirschenVisualFrame.this.MySensi.MyTPKirschenVisualFrame = null;
            }
        });
        this.pack();
        this.setVisible(true);
        if (this.VisFromDB) {
            try {
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                int i = 0;
                boolean j = false;
                Statement s = conTPResDB.createStatement();
                ResultSet r1 = s.executeQuery("SELECT rama\tFROM Kirschen_Barra");
                this.dimDB1 = 0;
                while (r1.next()) {
                    ++this.dimDB1;
                }
                r1 = s.executeQuery("SELECT *\tFROM Kirschen_Barra");
                this.BarrasDB = new String[this.dimDB1];
                this.RamasDB = new String[this.dimDB1];
                this.ProrratasDB = new double[this.dimDB1];
                this.PagoDB = new double[this.dimDB1];
                i = 0;
                while (r1.next()) {
                    this.BarrasDB[i] = r1.getString("barra");
                    this.RamasDB[i] = r1.getString("rama");
                    this.ProrratasDB[i] = r1.getDouble("prorrata");
                    this.PagoDB[i] = r1.getDouble("pago");
                    ++i;
                }
                ResultSet r2 = s.executeQuery("SELECT rama\tFROM Kirschen_Empresa");
                this.dimDB2 = 0;
                while (r2.next()) {
                    ++this.dimDB2;
                }
                r2 = s.executeQuery("SELECT *\tFROM Kirschen_Empresa");
                this.EmpresasDB = new String[this.dimDB2];
                this.ERamasDB = new String[this.dimDB2];
                this.EProrratasDB = new double[this.dimDB2];
                this.EPagoDB = new double[this.dimDB2];
                i = 0;
                while (r2.next()) {
                    this.EmpresasDB[i] = r2.getString("empresa");
                    this.ERamasDB[i] = r2.getString("rama");
                    this.EProrratasDB[i] = r2.getDouble("prorrata");
                    this.EPagoDB[i] = r2.getDouble("pago");
                    ++i;
                }
                ResultSet r3 = s.executeQuery("SELECT rama\tFROM Kirschen_Generador");
                this.dimDB3 = 0;
                while (r3.next()) {
                    ++this.dimDB3;
                }
                r3 = s.executeQuery("SELECT *\tFROM Kirschen_Generador");
                this.UnitsDB = new String[this.dimDB3];
                this.URamasDB = new String[this.dimDB3];
                this.PUnitsDB = new double[this.dimDB3];
                this.PagoUnitsDB = new double[this.dimDB3];
                i = 0;
                while (r3.next()) {
                    this.UnitsDB[i] = r3.getString("generador");
                    this.URamasDB[i] = r3.getString("rama");
                    this.PUnitsDB[i] = r3.getDouble("prorrata");
                    this.PagoUnitsDB[i] = r3.getDouble("pago");
                    ++i;
                }
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Leer TPResDB " + e);
                e.printStackTrace();
            }
        }
        String titulo = "Prorrateo Total por Empresas [US$]";
        String titulo2 = "Prorrateo Total por Empresas [%]";
        double[] sliceValue = new double[this.MySensi.numallowner];
        double[] sliceValue2 = new double[this.MySensi.numallowner];
        int i = 0;
        for (i = 0; i < this.MySensi.numallowner; ++i) {
            sliceValue[i] = 0.0;
            sliceValue2[i] = 0.0;
        }
        try {
            Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            Statement s = conTPResDB.createStatement();
            ResultSet r = s.executeQuery("SELECT empresa,pago,prorrata\tFROM Kirschen_Empresa   ORDER BY empresa");
            String OwnEste = "nada";
            while (r.next()) {
                OwnEste = r.getString("empresa");
                for (i = 0; i < this.MySensi.numallowner; ++i) {
                    if (!this.MySensi.NomOwner[i].equals(OwnEste)) continue;
                    int n = i;
                    sliceValue[n] = sliceValue[n] + r.getDouble("pago");
                    int n2 = i;
                    sliceValue2[n2] = sliceValue2[n2] + r.getDouble("prorrata");
                }
            }
            s.close();
        }
        catch (Exception e) {
            System.out.println("Error al Leer Base de Datos " + e);
            e.printStackTrace();
        }
        String file = "./results/PagosEmpresa.dat";
        i = 0;
        try {
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            double tot = 0.0;
            this.myPPrintStream.println("\t\t\t*******************");
            this.myPPrintStream.println(" \t\t\t Pagos por Empresa ");
            this.myPPrintStream.println(" \t\t\t*******************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Empresa          Pago Total [US$]");
            this.myPPrintStream.println("        -------          ----------------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallowner; ++i) {
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.MySensi.NomOwner[i], 15) + "        " + TPKirschen.numformat(sliceValue[i], 10, 3));
                tot += sliceValue[i];
            }
            this.myPPrintStream.println("        -------          ----------------");
            this.myPPrintStream.println("TOTAL   " + TPKirschen.numformat(this.MySensi.numallowner, 4) + "             " + TPKirschen.numformat(tot, 10, 3));
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
        TPPieFrame MyTPPieFrame = new TPPieFrame(titulo, this.MySensi.numallowner, this.MySensi.NomOwner, sliceValue);
        TPPieFrame MyTPPieFrame2 = new TPPieFrame(titulo2, this.MySensi.numallowner, this.MySensi.NomOwner, sliceValue2);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            try {
                this.MySensi.MyColorSpec.setVisible(false);
                this.MySensi.MyColorSpec.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.MySensi.MyTPKirschenVisualFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                try {
                    this.MySensi.MyColorSpec.setVisible(false);
                    this.MySensi.MyColorSpec.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.MySensi.MyTPKirschenVisualFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else if (label.equals("Show")) {
                this.visualizationgen(this.MyChoicename.getSelectedItem(), this.MyChoicecriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("Showline")) {
                this.visualizationline(this.MyChoiceline.getSelectedItem(), this.MyChoicelinecriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("Showtrafo") && this.MyChoicetrafo.getSelectedItem() != null) {
                this.visualizationtrafo(this.MyChoicetrafo.getSelectedItem(), this.MyChoicetrafocriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("SelectBusbar")) {
                for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                    this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                    if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof Generator) || !this.TempComponent.isSelected()) continue;
                    this.MyChoicename.select(this.TempComponent.getName());
                    return;
                }
            } else if (label.equals("SelectLine")) {
                for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                    this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                    if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof Line) || !this.TempComponent.isSelected()) continue;
                    this.MyChoiceline.select(this.TempComponent.getName());
                    return;
                }
            } else if (label.equals("SelectTrafo")) {
                for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                    this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                    if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof Trafo) || !this.TempComponent.isSelected()) continue;
                    this.MyChoicetrafo.select(this.TempComponent.getName());
                    return;
                }
            } else {
                if (label.equals("MakeFileBus")) {
                    this.DoGenFile(this.MyChoicename.getSelectedItem(), this.MyChoicecriteria.getSelectedItem());
                    this.BuildGenBar(this.MyChoicename.getSelectedItem(), this.MyChoicecriteria.getSelectedItem());
                    return;
                }
                if (label.equals("MakeFileLine")) {
                    this.DoLineFile(this.MyChoiceline.getSelectedItem(), this.MyChoicelinecriteria.getSelectedItem());
                    this.BuildBranPie(this.MyChoiceline.getSelectedItem(), this.MyChoicelinecriteria.getSelectedItem());
                    return;
                }
                if (label.equals("MakeFileTrafo") && this.MyChoicetrafo.getSelectedItem() != null) {
                    this.DoTrafoFile(this.MyChoicetrafo.getSelectedItem(), this.MyChoicetrafocriteria.getSelectedItem());
                    this.BuildBranPie(this.MyChoicetrafo.getSelectedItem(), this.MyChoicetrafocriteria.getSelectedItem());
                    return;
                }
                if (label.equals("SelectGenerator")) {
                    for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                        this.TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                        if (!this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof ndb_inj) || !this.TempComponent.isSelected()) continue;
                        Generator TempInj = (Generator)this.TempComponent;
                        this.MyChoicesup.select(TempInj.getinv_owner());
                        return;
                    }
                } else if (label.equals("Showsup")) {
                    this.visualizationowner(this.MyChoicesup.getSelectedItem(), this.MyChoicesupcriteria.getSelectedItem());
                    DeepEdit.MySchematicPanel.repaint();
                    this.repaint();
                } else {
                    if (label.equals("MakeFileSup")) {
                        this.DoOwnerFile(this.MyChoicesup.getSelectedItem(), this.MyChoicesupcriteria.getSelectedItem());
                        this.BuildOwnerBar(this.MyChoicesup.getSelectedItem(), this.MyChoicesupcriteria.getSelectedItem());
                        return;
                    }
                    if (label.equals("pick")) {
                        this.lista = new Vector();
                        TPUnitsSelectionDialog MyTPUnitsSelectionDialog = new TPUnitsSelectionDialog((Frame)this, this.MySensi.ActSchematic, this.lista);
                        MyTPUnitsSelectionDialog.setVisible(true);
                        if (this.lista.size() == 0) {
                            System.out.println("WARNING: No generators were selected");
                        }
                    } else if (label.equals("Paint Network")) {
                        if (this.lista.size() > 0) {
                            this.visualizationunits(this.lista);
                            DeepEdit.MySchematicPanel.repaint();
                            this.repaint();
                        } else {
                            System.out.println("WARNING: No generators were selected");
                        }
                    } else if (label.equals("MakeFileGroup")) {
                        if (this.lista.size() > 0) {
                            this.DoUnitsFile(this.lista);
                            this.BuildUnitsBar(this.lista);
                            this.BuildUnitsPie(this.lista);
                        } else {
                            System.out.println("WARNING: No generators were selected");
                        }
                    }
                }
            }
        }
    }

    public void visualization(String nombre, String modelo) {
        Object os1 = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        int counterL = 0;
        int counterT = 0;
        int counterB = 0;
        if (!this.VisFromDB) {
            this.ReadSens(nombre, modelo);
        } else {
            this.ReadSensDB(nombre, modelo);
        }
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            if (TempComponent instanceof Line) {
                Tempndb.lw = (int)(this.sensi[counterB] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.sensi[counterB]));
                ++counterB;
                ++counterL;
                continue;
            }
            if (TempComponent instanceof Busbar && TempComponent.getName().equals(nombre)) {
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Tempndb.lw = (int)(this.sensi[counterB] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.sensi[counterB]));
                ++counterT;
                ++counterB;
                continue;
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("Kirschen"))) {
                TempGenerator = (Generator)TempComponent;
                if (TempGenerator.getcon2().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                continue;
            }
            if (TempComponent instanceof Load && (modelo.equals("GSDF (Loads)") || modelo.equals("GLDF (Loads)"))) {
                TempLoad = (Load)TempComponent;
                if (TempLoad.getcon2().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
        }
    }

    public void visualizationgen(String nombre, String modelo) {
        comp TempComponent;
        int ix;
        Object os1 = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        int counterL = 0;
        int counterT = 0;
        int counterB = 0;
        if (!this.VisFromDB) {
            this.ReadGenSens(nombre, modelo);
        } else {
            this.ReadGenSensDB(nombre, modelo);
        }
        String nombreb = "na";
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator) || !(TempGenerator = (Generator)TempComponent).getName().equals(nombre)) continue;
            nombreb = TempGenerator.getcon2();
            break;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            if (TempComponent instanceof Line) {
                Tempndb.lw = (int)(this.gsensi[counterB] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.gsensi[counterB]));
                ++counterB;
                ++counterL;
                continue;
            }
            if (TempComponent instanceof Busbar && TempComponent.getName().equals(nombreb)) {
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Tempndb.lw = (int)(this.gsensi[counterB] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.gsensi[counterB]));
                ++counterT;
                ++counterB;
                continue;
            }
            if (TempComponent instanceof Generator && modelo.equals("Kirschen")) {
                TempGenerator = (Generator)TempComponent;
                if (TempGenerator.getName().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                continue;
            }
            if (TempComponent instanceof Load && (modelo.equals("GSDF (Loads)") || modelo.equals("GLDF (Loads)"))) {
                TempLoad = (Load)TempComponent;
                if (TempLoad.getcon2().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
        }
    }

    public void visualizationline(String nombre, String modelo) {
        ndb_comp Tempndb;
        comp TempComponent;
        int ix;
        ndb_branch BTempLine = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        double acum = 0.0;
        double anteil = 0.0;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.lw = 1;
            if (!(TempComponent instanceof Line) || !TempComponent.getName().equals(nombre)) continue;
            BTempLine = (Line)TempComponent;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Busbar) {
                anteil = this.visualization(nombre, TempComponent.getName(), modelo);
                acum += anteil;
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("Kirschen"))) {
                TempGenerator = (Generator)TempComponent;
                anteil = this.visualization(nombre, TempGenerator.getcon2(), modelo);
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (!(TempComponent instanceof Load) || !modelo.equals("GSDF (Loads)") && !modelo.equals("GLDF (Loads)")) continue;
            TempLoad = (Load)TempComponent;
            anteil = this.visualization(nombre, TempLoad.getcon2(), modelo);
            Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
        }
        if (acum == 0.0) {
            System.out.println("WARNING: Line " + nombre + " is not paid.");
        }
        ((Line)BTempLine).lw = 5;
        if (acum == 0.0) {
            BTempLine.setAlternatekv_Color(Color.darkGray);
        } else {
            BTempLine.setAlternatekv_Color(Color.red);
        }
    }

    public void visualizationtrafo(String nombre, String modelo) {
        ndb_comp Tempndb;
        comp TempComponent;
        int ix;
        ndb_branch BTempTrafo = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        double acum = 0.0;
        double anteil = 0.0;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.lw = 1;
            if (!(TempComponent instanceof Trafo) || !TempComponent.getName().equals(nombre)) continue;
            BTempTrafo = (Trafo)TempComponent;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Busbar) {
                anteil = this.visualization(nombre, TempComponent.getName(), modelo);
                acum += anteil;
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("Kirschen"))) {
                TempGenerator = (Generator)TempComponent;
                anteil = this.visualization(nombre, TempGenerator.getcon2(), modelo);
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (!(TempComponent instanceof Load) || !modelo.equals("GSDF (Loads)") && !modelo.equals("GLDF (Loads)")) continue;
            TempLoad = (Load)TempComponent;
            anteil = this.visualization(nombre, TempLoad.getcon2(), modelo);
            Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
        }
        if (acum == 0.0) {
            System.out.println("WARNING: Trafo " + nombre + " is not paid.");
        }
        ((Trafo)BTempTrafo).lw = 5;
        if (acum == 0.0) {
            BTempTrafo.setAlternatekv_Color(Color.darkGray);
        } else {
            BTempTrafo.setAlternatekv_Color(Color.red);
        }
    }

    public double visualization(String nombran, String nombre, String modelo) {
        Object os1 = null;
        int counterL = 0;
        int counterT = 0;
        int counterB = 0;
        comp TempComponent = null;
        ndb_comp Tempndb = null;
        if (!this.VisFromDB) {
            this.ReadSens(nombre, modelo);
        } else {
            this.ReadSensDB(nombre, modelo);
        }
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Line) {
                if (TempComponent.getName().equals(nombran)) {
                    return this.sensi[counterB];
                }
                ++counterL;
                ++counterB;
            }
            if (!(TempComponent instanceof Trafo)) continue;
            if (TempComponent.getName().equals(nombran)) {
                return this.sensi[counterB];
            }
            ++counterT;
            ++counterB;
        }
        System.out.println("Not found: " + nombre + ", " + nombran);
        return 0.0;
    }

    public void visualizationowner(String owner, String modelo) {
        comp TempComponent;
        int ix;
        if (!this.VisFromDB) {
            this.ReadOwnerSens(owner, modelo);
        } else {
            this.ReadOwnerSensDB(owner, modelo);
        }
        Object os1 = null;
        int counterL = 0;
        int counterT = 0;
        int counterB = 0;
        int counterG = 0;
        int i = 0;
        boolean j = false;
        boolean k = false;
        boolean h = false;
        double AcumLine = 0.0;
        double AcumTrafo = 0.0;
        boolean[] OwnGen = new boolean[this.MySensi.numallgen];
        String[] NomGen = new String[this.MySensi.numallgen];
        String[] BusGen = new String[this.MySensi.numallgen];
        double[] Gen = new double[this.MySensi.numallgen];
        Generator TempGenerator = null;
        Object TempLoad = null;
        Line TempLine = null;
        Trafo TempTrafo = null;
        Busbar TempBusbar = null;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            TempGenerator = (Generator)TempComponent;
            if (TempGenerator.getinv_owner().equals(owner)) {
                OwnGen[counterG] = true;
                BusGen[counterG] = TempGenerator.getcon2();
                NomGen[counterG] = TempGenerator.getName();
                Gen[counterG] = TempGenerator.getp();
            } else {
                OwnGen[counterG] = false;
                BusGen[counterG] = "false";
                NomGen[counterG] = "false";
                Gen[counterG] = 0.0;
            }
            ++counterG;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                AcumLine = 0.0;
                Tempndb.lw = (int)((AcumLine += this.osensi[counterB]) / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(AcumLine));
                ++counterB;
                ++counterL;
                continue;
            }
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                int auxi = 0;
                for (i = 0; i < this.MySensi.numallgen; ++i) {
                    if (!TempBusbar.getName().equals(BusGen[i])) continue;
                    ++auxi;
                }
                if (auxi <= 0) continue;
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            if (TempComponent instanceof Trafo) {
                TempTrafo = (Trafo)TempComponent;
                AcumTrafo = 0.0;
                Tempndb.lw = (int)((AcumTrafo += this.osensi[counterB]) / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(AcumTrafo));
                ++counterT;
                ++counterB;
                continue;
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("Kirschen"))) {
                TempGenerator = (Generator)TempComponent;
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                int auxii = 0;
                for (i = 0; i < this.MySensi.numallgen; ++i) {
                    if (!NomGen[i].equals(TempGenerator.getName())) continue;
                    ++auxii;
                }
                if (auxii <= 0) continue;
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
        }
    }

    public void visualizationunits(Vector lis) {
        comp TempComponent;
        int ix;
        if (!this.VisFromDB) {
            this.ReadUnitsSens(lis);
        } else {
            this.ReadUnitsSensDB(lis);
        }
        Object os1 = null;
        int counterL = 0;
        int counterT = 0;
        int counterB = 0;
        int counterG = 0;
        int i = 0;
        boolean j = false;
        boolean k = false;
        boolean h = false;
        double AcumLine = 0.0;
        double AcumTrafo = 0.0;
        boolean[] LisGen = new boolean[this.MySensi.numallgen];
        String[] NomGen = new String[this.MySensi.numallgen];
        String[] BusGen = new String[this.MySensi.numallgen];
        double[] Gen = new double[this.MySensi.numallgen];
        Generator TempGenerator = null;
        Object TempLoad = null;
        Line TempLine = null;
        Trafo TempTrafo = null;
        Busbar TempBusbar = null;
        String auxs = "na";
        for (i = 0; i < this.MySensi.numallgen; ++i) {
            LisGen[i] = false;
            BusGen[i] = "false";
            NomGen[i] = "false";
            Gen[i] = 0.0;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
            TempGenerator = (Generator)TempComponent;
            for (i = 0; i < lis.size(); ++i) {
                auxs = ((Generator)lis.elementAt(i)).getName();
                if (!TempGenerator.getName().equals(auxs)) continue;
                System.out.println(" encontr\u00f3 : " + auxs);
                LisGen[counterG] = true;
                BusGen[counterG] = TempGenerator.getcon2();
                NomGen[counterG] = TempGenerator.getName();
                Gen[counterG] = TempGenerator.getp();
            }
            ++counterG;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.darkGray;
            ndb_comp.Color2 = Color.darkGray;
            ndb_comp.Color3 = Color.darkGray;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                AcumLine = 0.0;
                Tempndb.lw = (int)((AcumLine += this.usensi[counterB]) / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(AcumLine));
                ++counterB;
                ++counterL;
                continue;
            }
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                int auxi = 0;
                for (i = 0; i < this.MySensi.numallgen; ++i) {
                    if (!TempBusbar.getName().equals(BusGen[i])) continue;
                    ++auxi;
                }
                if (auxi > 0) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                continue;
            }
            if (TempComponent instanceof Trafo) {
                TempTrafo = (Trafo)TempComponent;
                AcumTrafo = 0.0;
                Tempndb.lw = (int)((AcumTrafo += this.usensi[counterB]) / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(AcumTrafo));
                ++counterT;
                ++counterB;
                continue;
            }
            if (TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                Tempndb.setAlternatekv_Color(Color.darkGray);
                Tempndb.setAlternatekv_Color(Color.darkGray);
                int auxii = 0;
                for (i = 0; i < this.MySensi.numallgen; ++i) {
                    if (!NomGen[i].equals(TempGenerator.getName())) continue;
                    ++auxii;
                }
                if (auxii <= 0) continue;
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.darkGray);
            Tempndb.setAlternatekv_Color(Color.darkGray);
        }
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    public void ReadSens(String barra, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int nn = this.MySensi.numallnod;
        int i = 0;
        boolean j = false;
        this.sensi = new double[nb];
        this.sensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.sensi[i] = 0.0;
            this.sensi2[i] = 0.0;
        }
        int jnumbus = this.MySensi.numbusALL(barra);
        if (criteria.equals("Kirschen")) {
            for (i = 0; i < nb; ++i) {
                this.sensi[i] = this.MySensi.Prorrateo[i][jnumbus];
                this.sensi2[i] = this.MySensi.PagoBarra[i][jnumbus];
            }
        }
    }

    public void ReadGenSensDB(String gen, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int nn = this.MySensi.numallnod;
        int i = 0;
        boolean j = false;
        int k = 0;
        this.gsensi = new double[nb];
        this.gsensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.gsensi[i] = 0.0;
            this.gsensi2[i] = 0.0;
        }
        if (criteria.equals("Kirschen")) {
            block1: for (k = 0; k < this.dimDB3; ++k) {
                if (!gen.equals(this.UnitsDB[k])) continue;
                for (i = 0; i < nb; ++i) {
                    if (!this.URamasDB[k].equals(this.NomBra[i])) continue;
                    this.gsensi[i] = this.PUnitsDB[k];
                    this.gsensi2[i] = this.PagoUnitsDB[k];
                    continue block1;
                }
            }
        }
    }

    public void ReadGenSens(String gen, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int nn = this.MySensi.numallnod;
        int i = 0;
        boolean j = false;
        this.gsensi = new double[nb];
        this.gsensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.gsensi[i] = 0.0;
            this.gsensi2[i] = 0.0;
        }
        int esteGen = -1;
        for (i = 0; i < this.MySensi.numallgen; ++i) {
            if (!this.MySensi.NomGen[i].equals(gen)) continue;
            esteGen = i;
            break;
        }
        if (esteGen == -1) {
            System.out.println("Generator not Founded");
            esteGen = 0;
        }
        if (criteria.equals("Kirschen")) {
            for (i = 0; i < nb; ++i) {
                this.gsensi[i] = this.MySensi.PUnits[i][esteGen];
                this.gsensi2[i] = this.MySensi.PagoUnits[i][esteGen];
            }
        }
    }

    public void ReadSensDB(String barra, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int nn = this.MySensi.numallnod;
        int i = 0;
        boolean j = false;
        int k = 0;
        this.sensi = new double[nb];
        this.sensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.sensi[i] = 0.0;
            this.sensi2[i] = 0.0;
        }
        int jnumbus = this.MySensi.numbusALL(barra);
        if (criteria.equals("Kirschen")) {
            block1: for (k = 0; k < this.dimDB1; ++k) {
                if (!barra.equals(this.BarrasDB[k])) continue;
                for (i = 0; i < nb; ++i) {
                    if (!this.RamasDB[k].equals(this.NomBra[i])) continue;
                    this.sensi[i] = this.ProrratasDB[k];
                    this.sensi2[i] = this.PagoDB[k];
                    continue block1;
                }
            }
        }
    }

    public void ReadUnitsSens(Vector lis) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int no = this.MySensi.numallowner;
        int i = 0;
        int j = 0;
        int k = 0;
        String as = "na";
        this.usensi = new double[nb];
        this.usensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.usensi[i] = 0.0;
            this.usensi2[i] = 0.0;
        }
        for (i = 0; i < nb; ++i) {
            block2: for (j = 0; j < lis.size(); ++j) {
                as = ((Generator)lis.elementAt(j)).getName();
                for (k = 0; k < this.MySensi.numallgen; ++k) {
                    if (!this.MySensi.NomGen[k].equals(as)) continue;
                    int n = i;
                    this.usensi[n] = this.usensi[n] + this.MySensi.PUnits[i][k];
                    int n2 = i;
                    this.usensi2[n2] = this.usensi2[n2] + this.MySensi.PagoUnits[i][k];
                    continue block2;
                }
            }
        }
    }

    public void ReadUnitsSensDB(Vector lis) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int no = this.MySensi.numallowner;
        int i = 0;
        int j = 0;
        int k = 0;
        String as = "na";
        this.usensi = new double[nb];
        this.usensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.usensi[i] = 0.0;
            this.usensi2[i] = 0.0;
        }
        for (j = 0; j < lis.size(); ++j) {
            as = ((Generator)lis.elementAt(j)).getName();
            block2: for (i = 0; i < nb; ++i) {
                for (k = 0; k < this.dimDB3; ++k) {
                    if (!this.URamasDB[k].equals(this.MySensi.NomBra[i]) || !this.UnitsDB[k].equals(as)) continue;
                    int n = i;
                    this.usensi[n] = this.usensi[n] + this.PUnitsDB[k];
                    int n2 = i;
                    this.usensi2[n2] = this.usensi2[n2] + this.PagoUnitsDB[k];
                    continue block2;
                }
            }
        }
    }

    public void ReadOwnerSens(String owner, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int no = this.MySensi.numallowner;
        int i = 0;
        boolean j = false;
        this.osensi = new double[nb];
        this.osensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.osensi[i] = 0.0;
            this.osensi2[i] = 0.0;
        }
        int jowner = -1;
        for (i = 0; i < no; ++i) {
            if (!this.MySensi.NomOwner[i].equals(owner)) continue;
            jowner = i;
        }
        if (jowner == -1) {
            System.out.println(" Serious Problems... You should call your provider");
        }
        if (criteria.equals("Kirschen")) {
            for (i = 0; i < nb; ++i) {
                this.osensi[i] = this.MySensi.OProrrateo[i][jowner];
                this.osensi2[i] = this.MySensi.PagoOwner[i][jowner];
            }
        }
    }

    public void ReadOwnerSensDB(String owner, String criteria) {
        int nb = this.MySensi.numallbran;
        int nl = this.MySensi.numalllin;
        int nt = this.MySensi.numalltrafo;
        int no = this.MySensi.numallowner;
        int i = 0;
        boolean j = false;
        int k = 0;
        this.osensi = new double[nb];
        this.osensi2 = new double[nb];
        for (i = 0; i < nb; ++i) {
            this.osensi[i] = 0.0;
            this.osensi2[i] = 0.0;
        }
        if (criteria.equals("Kirschen")) {
            block1: for (k = 0; k < this.dimDB2; ++k) {
                if (!owner.equals(this.EmpresasDB[k])) continue;
                for (i = 0; i < nb; ++i) {
                    if (!this.ERamasDB[k].equals(this.NomBra[i])) continue;
                    this.osensi[i] = this.EProrratasDB[k];
                    this.osensi2[i] = this.EPagoDB[k];
                    continue block1;
                }
            }
        }
    }

    public void DoBusFile(String barra, String metodo) {
        String file = "./results/Bus" + metodo + ".dat";
        int i = 0;
        try {
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            if (!this.VisFromDB) {
                this.ReadSens(barra, metodo);
            } else {
                this.ReadSensDB(barra, metodo);
            }
            this.myPPrintStream.println("\t\t\t********************************");
            this.myPPrintStream.println(" \t\t\t Prorrateos Barra : " + barra);
            this.myPPrintStream.println(" \t\t\t M\u00e9todo           : " + metodo);
            this.myPPrintStream.println(" \t\t\t********************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Branch          Prorrateo [%]          Pago [US$]");
            this.myPPrintStream.println("        -------------          -------------          ----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallbran; ++i) {
                if (this.sensi[i] == 0.0) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomBra[i], 15) + "        " + TPKirschen.numformat(this.sensi[i], 10, 3) + "        " + this.sensi2[i]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public void DoGenFile(String gen, String metodo) {
        String file = "./results/Generator" + metodo + ".dat";
        int i = 0;
        try {
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            if (!this.VisFromDB) {
                this.ReadGenSens(gen, metodo);
            } else {
                this.ReadGenSensDB(gen, metodo);
            }
            this.myPPrintStream.println("\t\t\t********************************");
            this.myPPrintStream.println(" \t\t\t Prorrateos Generador : " + gen);
            this.myPPrintStream.println(" \t\t\t M\u00e9todo               : " + metodo);
            this.myPPrintStream.println(" \t\t\t********************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Branch          Prorrateo [%]          Pago [US$]");
            this.myPPrintStream.println("        -------------          -------------          ----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallbran; ++i) {
                if (this.gsensi[i] == 0.0) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomBra[i], 15) + "        " + TPKirschen.numformat(this.gsensi[i], 10, 3) + "        " + this.gsensi2[i]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public void DoLineFile(String linea, String metodo) {
        String file = "./results/Line" + metodo + ".dat";
        int i = 0;
        try {
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            int actual = -1;
            int cuenta = 0;
            for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                comp TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line)) continue;
                if (TempComponent.getName().equals(linea)) {
                    actual = cuenta;
                }
                ++cuenta;
            }
            double auxAVNR = 0.0;
            for (i = 0; i < this.MySensi.numallnod; ++i) {
                if (!this.VisFromDB) {
                    this.ReadSens(this.NomNod[i], metodo);
                } else {
                    this.ReadSensDB(this.NomNod[i], metodo);
                }
                auxAVNR += this.sensi2[actual];
            }
            this.myPPrintStream.println("\t\t\t*************************************************************");
            this.myPPrintStream.println(" \t\t\t Prorrateos L\u00ednea                : " + linea);
            this.myPPrintStream.println(" \t\t\t M\u00e9todo                          : " + metodo);
            this.myPPrintStream.println(" \t\t\t AVNR+COyM             [US$/a\u00f1o] : " + TPKirschen.numformat(this.MySensi.AVNR_COyM[actual], 15, 7));
            this.myPPrintStream.println(" \t\t\t AVNR+COyM considerado [US$]     : " + TPKirschen.numformat(auxAVNR, 15, 7));
            this.myPPrintStream.println(" \t\t\t*************************************************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Barra\t\tProrrateo [%]\t\tPago [US$]");
            this.myPPrintStream.println("        ------------\t\t-------------\t\t----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallnod; ++i) {
                if (!this.VisFromDB) {
                    this.ReadSens(this.NomNod[i], metodo);
                } else {
                    this.ReadSensDB(this.NomNod[i], metodo);
                }
                if (this.sensi[actual] == 0.0) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomNod[i], 15) + "        " + TPKirschen.numformat(this.sensi[actual], 10, 3) + "           " + this.sensi2[actual]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public void DoTrafoFile(String trafo, String metodo) {
        String file = "./results/Trafo" + metodo + ".dat";
        int i = 0;
        try {
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            int actual = -1;
            int cuenta = 0;
            for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
                comp TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                if (TempComponent.getName().equals(trafo)) {
                    actual = cuenta;
                }
                ++cuenta;
            }
            double auxAVNR = 0.0;
            for (i = 0; i < this.MySensi.numallnod; ++i) {
                if (!this.VisFromDB) {
                    this.ReadSens(this.NomNod[i], metodo);
                } else {
                    this.ReadSensDB(this.NomNod[i], metodo);
                }
                auxAVNR += this.sensi2[actual];
            }
            this.myPPrintStream.println("\t*************************************************************");
            this.myPPrintStream.println(" \t Prorrateos Trafo                : " + trafo);
            this.myPPrintStream.println(" \t M\u00e9todo                          : " + metodo);
            this.myPPrintStream.println(" \t AVNR+COyM             [US$/a\u00f1o] : " + TPKirschen.numformat(this.MySensi.AVNR_COyM[actual], 15, 7));
            this.myPPrintStream.println(" \t AVNR+COyM considerado [US$]     : " + TPKirschen.numformat(auxAVNR, 15, 7));
            this.myPPrintStream.println(" \t*************************************************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Barra\t\tProrrateo [%]\t\tPago [US$]");
            this.myPPrintStream.println("        ------------\t\t-------------\t\t----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallnod; ++i) {
                if (!this.VisFromDB) {
                    this.ReadSens(this.NomNod[i], metodo);
                } else {
                    this.ReadSensDB(this.NomNod[i], metodo);
                }
                if (this.sensi[actual] == 0.0) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomNod[i], 15) + "        " + TPKirschen.numformat(this.sensi[actual], 10, 3) + "           " + this.sensi2[actual]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public void DoOwnerFile(String owner, String metodo) {
        String file = "./results/Owner" + metodo + ".dat";
        int i = 0;
        try {
            if (!this.VisFromDB) {
                this.ReadOwnerSens(owner, metodo);
            } else {
                this.ReadOwnerSensDB(owner, metodo);
            }
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            Object os1 = null;
            this.myPPrintStream.println("\t\t\t***********************************");
            this.myPPrintStream.println(" \t\t\t Prorrateos Owner      : " + owner);
            this.myPPrintStream.println(" \t\t\t M\u00e9todo                : " + metodo);
            this.myPPrintStream.println(" \t\t\t***********************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Branch\t\t\tProrrateo [%]\t\t\tPago [US$]");
            this.myPPrintStream.println("        -------------\t\t\t-------------\t\t\t----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallbran; ++i) {
                if (this.osensi[i] == 0.0) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomBra[i], 15) + "        " + TPKirschen.numformat(this.osensi[i], 10, 3) + "        " + this.osensi2[i]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public void DoUnitsFile(Vector lis) {
        String file = "./results/UnitsKirschen.dat";
        int i = 0;
        try {
            if (!this.VisFromDB) {
                this.ReadUnitsSens(lis);
            } else {
                this.ReadUnitsSensDB(lis);
            }
            this.os = new FileOutputStream(file);
            this.myPPrintStream = new PrintStream(this.os);
            Object os1 = null;
            this.myPPrintStream.println("\t\t\t********************");
            this.myPPrintStream.println(" \t\t\t Prorrateo Unidades ");
            this.myPPrintStream.println(" \t\t\t  M\u00e9todo  Kirschen");
            this.myPPrintStream.println(" \t\t\t********************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println(" Selected Units");
            for (i = 0; i < lis.size(); ++i) {
                this.myPPrintStream.println("  - " + ((Generator)lis.elementAt(i)).getName());
            }
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("        Nombre Branch\t\t\tProrrateo [%]\t\t\tPago [US$]");
            this.myPPrintStream.println("        -------------\t\t\t-------------\t\t\t----------");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.MySensi.numallbran; ++i) {
                if (!(this.usensi[i] > 1.0E-5)) continue;
                this.myPPrintStream.println("        " + TPKirschen.strformat(this.NomBra[i], 15) + "        " + TPKirschen.numformat(this.usensi[i], 10, 3) + "        " + this.usensi2[i]);
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec("notepad " + file);
        }
        catch (Exception e) {
            System.out.println(e + ": error al abrir notepad");
        }
    }

    public Color floatToColor(double f) {
        int elec = (int)(f / 10.0 + 1.0);
        Color acolor = Color.darkGray;
        switch (elec) {
            case 0: {
                acolor = Color.darkGray;
                break;
            }
            case 1: {
                acolor = Color.white;
                break;
            }
            case 2: {
                acolor = Color.cyan;
                break;
            }
            case 3: {
                acolor = Color.green;
                break;
            }
            case 4: {
                acolor = Color.yellow;
                break;
            }
            case 5: {
                acolor = Color.pink;
                break;
            }
            case 6: {
                acolor = Color.blue;
                break;
            }
            case 7: {
                acolor = Color.magenta;
                break;
            }
            case 8: {
                acolor = Color.orange;
                break;
            }
            case 9: {
                acolor = new Color(204, 136, 0);
                break;
            }
            case 10: {
                acolor = Color.red;
            }
        }
        if (elec > 10 && elec <= 11) {
            acolor = Color.red;
        }
        if (elec > 11) {
            acolor = Color.black;
        }
        if (f <= 1.0) {
            acolor = Color.darkGray;
        }
        return acolor;
    }

    public void BuildBranPie(String branch, String metodo) {
        try {
            Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            int i = 0;
            Statement s = conTPResDB.createStatement();
            ResultSet r1 = s.executeQuery("SELECT rama\tFROM Kirschen_Barra   WHERE rama = '" + branch + "'");
            int dim1 = 0;
            while (r1.next()) {
                ++dim1;
            }
            r1 = s.executeQuery("SELECT barra,prorrata\tFROM Kirschen_Barra   WHERE rama = '" + branch + "'");
            String[] sliceName1 = new String[dim1];
            double[] sliceValue1 = new double[dim1];
            while (r1.next()) {
                sliceName1[i] = r1.getString("barra");
                sliceValue1[i] = r1.getDouble("prorrata");
                ++i;
            }
            String titulo1 = "Barras Pagan Rama " + branch;
            TPPieFrame MyTPPieFrame1 = new TPPieFrame(titulo1, dim1, sliceName1, sliceValue1);
            MyTPPieFrame1.setVisible(true);
            ResultSet r2 = s.executeQuery("SELECT rama\tFROM Kirschen_Empresa   WHERE rama = '" + branch + "'");
            int dim2 = 0;
            while (r2.next()) {
                ++dim2;
            }
            r2 = s.executeQuery("SELECT empresa,prorrata\tFROM Kirschen_Empresa   WHERE rama = '" + branch + "'");
            String[] sliceName2 = new String[dim2];
            double[] sliceValue2 = new double[dim2];
            i = 0;
            while (r2.next()) {
                sliceName2[i] = r2.getString("empresa");
                sliceValue2[i] = r2.getDouble("prorrata");
                ++i;
            }
            String titulo2 = "Empresas Pagan Rama" + branch;
            TPPieFrame MyTPPieFrame2 = new TPPieFrame(titulo2, dim2, sliceName2, sliceValue2);
            MyTPPieFrame2.setVisible(true);
            s.close();
        }
        catch (Exception e) {
            System.out.println("Error al Leer TPResDB " + e);
            e.printStackTrace();
        }
    }

    public void BuildBusBar(String barra, String metodo) {
        try {
            Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            int i = 0;
            Statement s = conTPResDB.createStatement();
            ResultSet r1 = s.executeQuery("SELECT rama\tFROM Kirschen_Barra   WHERE barra = '" + barra + "'");
            int dim1 = 0;
            while (r1.next()) {
                ++dim1;
            }
            r1 = s.executeQuery("SELECT rama,prorrata\tFROM Kirschen_Barra   WHERE barra = '" + barra + "'");
            String[] barName1 = new String[dim1];
            double[] barValue1 = new double[dim1];
            while (r1.next()) {
                barName1[i] = r1.getString("rama");
                barValue1[i] = r1.getDouble("prorrata");
                ++i;
            }
            String titulo1 = "Barra " + barra + " Paga";
            TPBarFrame MyTPBarFrame1 = new TPBarFrame(titulo1, dim1, barName1, barValue1);
            MyTPBarFrame1.setVisible(true);
            s.close();
        }
        catch (Exception e) {
            System.out.println("Error al Leer TPResDB " + e);
            e.printStackTrace();
        }
    }

    public void BuildGenBar(String gen, String metodo) {
        try {
            Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            int i = 0;
            Statement s = conTPResDB.createStatement();
            ResultSet r1 = s.executeQuery("SELECT generador\tFROM Kirschen_Generador   WHERE generador = '" + gen + "'");
            int dim1 = 0;
            while (r1.next()) {
                ++dim1;
            }
            r1 = s.executeQuery("SELECT rama,prorrata\tFROM Kirschen_Generador   WHERE generador = '" + gen + "'");
            String[] barName1 = new String[dim1];
            double[] barValue1 = new double[dim1];
            while (r1.next()) {
                barName1[i] = r1.getString("rama");
                barValue1[i] = r1.getDouble("prorrata");
                ++i;
            }
            String titulo1 = "Generador " + gen + " Paga";
            TPBarFrame MyTPBarFrame1 = new TPBarFrame(titulo1, dim1, barName1, barValue1);
            MyTPBarFrame1.setVisible(true);
            s.close();
            conTPResDB.commit();
            conTPResDB.close();
        }
        catch (Exception e) {
            System.out.println("Error al Leer TPResDB " + e);
            e.printStackTrace();
        }
    }

    public void BuildOwnerBar(String owner, String metodo) {
        try {
            Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            int i = 0;
            Statement s = conTPResDB.createStatement();
            ResultSet r1 = s.executeQuery("SELECT rama\tFROM Kirschen_Empresa   WHERE empresa = '" + owner + "'");
            int dim1 = 0;
            while (r1.next()) {
                ++dim1;
            }
            r1 = s.executeQuery("SELECT rama,prorrata\tFROM Kirschen_Empresa   WHERE empresa = '" + owner + "'");
            String[] barName1 = new String[dim1];
            double[] barValue1 = new double[dim1];
            while (r1.next()) {
                barName1[i] = r1.getString("rama");
                barValue1[i] = r1.getDouble("prorrata");
                ++i;
            }
            String titulo1 = "Empresa " + owner + " Paga";
            TPBarFrame MyTPBarFrame1 = new TPBarFrame(titulo1, dim1, barName1, barValue1);
            MyTPBarFrame1.setVisible(true);
            s.close();
        }
        catch (Exception e) {
            System.out.println("Error al Leer TPResDB " + e);
            e.printStackTrace();
        }
    }

    public void BuildUnitsBar(Vector lis) {
        int i = 0;
        int j = 0;
        boolean k = false;
        int dim = lis.size();
        String titulo = "Pagos Totales de Unidades Seleccionadas";
        String[] barName = new String[dim];
        double[] barValue = new double[dim];
        for (i = 0; i < dim; ++i) {
            barName[i] = ((Generator)lis.elementAt(i)).getName();
            if (this.VisFromDB) {
                this.ReadGenSensDB(((Generator)lis.elementAt(i)).getName(), "Kirschen");
            } else {
                this.ReadGenSens(((Generator)lis.elementAt(i)).getName(), "Kirschen");
            }
            for (j = 0; j < this.MySensi.numallbran; ++j) {
                int n = i;
                barValue[n] = barValue[n] + this.gsensi2[j];
            }
        }
        TPBarFrame MyTPBarFrame = new TPBarFrame(titulo, dim, barName, barValue);
        MyTPBarFrame.setVisible(true);
    }

    public void BuildUnitsPie(Vector lis) {
        int i = 0;
        int j = 0;
        int k = 0;
        String aux = "na";
        int dim = 2;
        String titulo = "Pagos Unidades Seleccionadas v/s Total";
        String[] pieName = new String[dim];
        double[] pieValue = new double[dim];
        double TotalValues = 0.0;
        pieName[0] = "Selected Group";
        pieName[1] = "Other Units";
        for (i = 0; i < lis.size(); ++i) {
            aux = ((Generator)lis.elementAt(i)).getName();
            if (this.VisFromDB) {
                for (j = 0; j < this.dimDB3; ++j) {
                    if (aux.equals(this.UnitsDB[j])) {
                        pieValue[0] = pieValue[0] + this.PagoUnitsDB[j];
                    }
                    TotalValues += this.PagoUnitsDB[j];
                }
                continue;
            }
            for (j = 0; j < this.MySensi.numallgen; ++j) {
                for (k = 0; k < this.MySensi.numallbran; ++k) {
                    if (this.MySensi.NomGen[j].equals(aux)) {
                        pieValue[0] = pieValue[0] + this.MySensi.PagoUnits[k][j];
                    }
                    TotalValues += this.MySensi.PagoUnits[k][j];
                }
            }
        }
        pieValue[1] = (TotalValues /= (double)lis.size()) - pieValue[0];
        TPPieFrame MyTPPieFrame = new TPPieFrame(titulo, dim, pieName, pieValue);
        MyTPPieFrame.setVisible(true);
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
        }
    }
}

