/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPKirschenFrame;
import de.core.TPKirschenVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPKirschen
extends AnalysisTool {
    TPKirschenFrame MyTPKirschenFrame = null;
    TPKirschenVisualFrame MyTPKirschenVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    int[] AllBranchI;
    int[] AllBranchJ;
    double[] node_pg;
    double[] node_pl;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBLoad;
    int dimDBYear;
    double[] blockTime;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] AllGenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = 0;
    int numallowner = 0;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    Vector BusGen;
    Vector[] Dom;
    Vector[] AlimBus;
    String[] AlimBusName;
    Vector Common;
    int[] Rank;
    int[] Ord;
    int[] BusCom;
    int[] RankCom;
    int[] OrdCom;
    Vector Garbage;
    double[] I;
    double[] E;
    double[] G;
    double[][] C;
    double[][] FL;
    double[][][] FLG;
    int block1;
    int hidro1;
    int block2;
    int hidro2;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int ndem;
    double[] FlujoMensual;
    double[] FlujoAnual;
    double[] mensual_pg;
    double[] anual_pg;
    int[] FrecFlujo;
    int[] Frec_pg;
    int[] BranCom;
    int[] ComI;
    int[] ComJ;
    double[][] ProAnual;
    int anos = 0;
    double[][] mensualOwner_pg;
    double[][] anualOwner_pg;
    int[][] OFrec_pg;
    double[][] OProAnual;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int[][] FreProAnual;
    int[][] FreOProAnual;
    double[] PLA1;
    double[] PLA2;
    double[] AVNR_COyM;
    double[][] PagoBarra;
    double[][] PagoOwner;
    double nTotHoras = 0.0;
    int nrobl = -1;
    double[] simDuration;
    double sdur = 0.0;
    double[][] PUnitsAct;
    double[][] APUnitsAct;
    public double[][] PUnits;
    int[][] FUnits;
    double[] PLA3;
    double[][] PGenUnits;
    public double[][] PagoUnits;
    double[][] mensualUnits_pg;
    double[][] anualUnits_pg;
    int[][] UFrec_pg;
    double[][] UProAnual;
    int[][] FreUProAnual;
    int ndem2;
    String[] NameLDB2;
    double[][] PLDB2;
    int dimDBLoad2;
    int slackGenerator;
    boolean one = false;
    private double sref = this.getSref();

    public TPKirschen(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPKirschen ------------");
        if (this.MyTPKirschenFrame == null) {
            this.MyTPKirschenFrame = new TPKirschenFrame(this);
        } else {
            this.MyTPKirschenFrame.setVisible(true);
        }
    }

    public TPKirschen(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB) {
        super(sch);
        System.out.println("---------- In TPKirschen ------------ 1");
        this.Calculate(CTRLA, rep, vis, DBrep, SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, HydroDB);
    }

    public TPKirschen(Schematic sch, boolean VisDB) {
        super(sch);
        System.out.println("---------- In TPKirschen ------------ 2");
        this.InitAllNetwork();
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB) {
        int j;
        int i;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPKirschen.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork();
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork();
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, HydroDB);
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            int FY = this.ny1;
            int LY = this.ny2;
            int FM = this.nm1;
            int LM = this.nm2;
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            this.anos = 0;
            for (int y = this.year1; y <= this.year2; ++y) {
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : 12;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int jj;
                    int ii;
                    System.out.println(" ");
                    System.out.println("-------------------------------");
                    System.out.println(" IN MONTH " + m + " CALCULATION");
                    System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                    System.out.println("-------------------------------");
                    if (this.Plan_Obra(y, m)) {
                        System.out.println(" Month " + m + " ESTA en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPKirschen.numformat(this.year1, 8) + "/" + TPKirschen.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPKirschen.numformat(this.year2, 8) + "/" + TPKirschen.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPKirschen.numformat(y, 8) + "/" + TPKirschen.numformat(m, 8));
                        this.ActSchematic.setactperiod(y);
                        this.ActSchematic.setactmonth(m);
                        this.ActSchematic.Modifiedstate = true;
                        this.ActSchematic.Modified = true;
                        this.ActSchematic.CheckActive();
                        System.out.println(" ");
                        System.out.println("Making GetActiveNetwork");
                        this.GetActiveNetwork();
                        System.out.println("GetActiveNetwork    Done");
                        System.out.println(" ");
                        if (this.MyDCLF != null) {
                            this.MyDCLF = null;
                        }
                        this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    } else {
                        System.out.println(" Month " + m + " NO esta en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPKirschen.numformat(this.year1, 8) + "/" + TPKirschen.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPKirschen.numformat(this.year2, 8) + "/" + TPKirschen.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPKirschen.numformat(y, 8) + "/" + TPKirschen.numformat(m, 8));
                    }
                    if (this.APUnitsAct != null) {
                        this.APUnitsAct = null;
                    }
                    this.APUnitsAct = new double[this.numactbran][this.numactgen];
                    if (this.AProrrateoAct != null) {
                        this.AProrrateoAct = null;
                    }
                    this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                    if (this.AOProrrateoAct != null) {
                        this.AOProrrateoAct = null;
                    }
                    this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                    for (i = 0; i < this.numactbran; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.AProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactowner; ++j) {
                            this.AOProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactgen; ++j) {
                            this.APUnitsAct[i][j] = 0.0;
                        }
                    }
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    this.nTotHoras = 0.0;
                    this.sdur = 0.0;
                    for (int b = limblock1; b <= limblock2; ++b) {
                        System.out.println(" ");
                        System.out.println("  ........................................");
                        System.out.println("   IN BLOCK " + b + " CALCULATION");
                        System.out.println("   Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                        System.out.print("  ");
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            if (y == this.year1 && m == this.month1 && this.nitera == 0) {
                                System.out.println("    This is the first seleted flow!");
                                System.out.println("      DCLF variables initialization ... ");
                                this.ActSchematic.setactperiod(y);
                                this.ActSchematic.setactmonth(m);
                                this.ActSchematic.Modifiedstate = true;
                                this.ActSchematic.Modified = true;
                                this.ActSchematic.CheckActive();
                                System.out.println(" ");
                                System.out.println("Making GetActiveNetwork");
                                this.GetActiveNetwork();
                                System.out.println("GetActiveNetwork    Done");
                                System.out.println(" ");
                                if (this.MyDCLF != null) {
                                    this.MyDCLF = null;
                                }
                                this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                                if (this.APUnitsAct != null) {
                                    this.APUnitsAct = null;
                                }
                                this.APUnitsAct = new double[this.numactbran][this.numactgen];
                                if (this.AProrrateoAct != null) {
                                    this.AProrrateoAct = null;
                                }
                                this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                                if (this.AOProrrateoAct != null) {
                                    this.AOProrrateoAct = null;
                                }
                                this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                                for (i = 0; i < this.numactbran; ++i) {
                                    for (j = 0; j < this.numactnod; ++j) {
                                        this.AProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactowner; ++j) {
                                        this.AOProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactgen; ++j) {
                                        this.APUnitsAct[i][j] = 0.0;
                                    }
                                }
                            }
                            System.out.print(".");
                            this.build_Injection(y, m, b, h, HydroDB);
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo);
                            if (this.one) {
                                this.MyDCLF.writeresults();
                            }
                            this.node_pg[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pg[n] = this.node_pg[n] + this.Flujo[i];
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pg[n] = this.node_pg[n] - this.Flujo[i];
                            }
                            this.node_pg[this.slackNode] = Math.max(0.0, this.node_pg[this.slackNode]);
                            this.node_pl[this.slackNode] = Math.abs(Math.min(0.0, this.node_pg[this.slackNode]));
                            if (this.node_pg[this.slackNode] >= 0.0) {
                                this.PGenOwn[this.slackOwner][this.slackNode] = this.node_pg[this.slackNode] * 100.0;
                                this.PGenUnits[this.slackGenerator][this.slackNode] = this.node_pg[this.slackNode] * 100.0;
                            }
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            for (i = 0; i < this.numactbran; ++i) {
                                int n = i;
                                this.FlujoMensual[n] = this.FlujoMensual[n] + this.Flujo[i] * this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactnod; ++i) {
                                int n = i;
                                this.mensual_pg[n] = this.mensual_pg[n] + this.node_pg[i] * this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactowner; ++i) {
                                for (j = 0; j < this.numactnod; ++j) {
                                    double[] dArray = this.mensualOwner_pg[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + this.PGenOwn[i][j] * this.blockTime[this.nrobl - 1];
                                }
                            }
                            for (i = 0; i < this.numactgen; ++i) {
                                for (j = 0; j < this.numactnod; ++j) {
                                    double[] dArray = this.mensualUnits_pg[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + this.PGenUnits[i][j] * this.blockTime[this.nrobl - 1];
                                }
                            }
                            this.nTotHoras += this.blockTime[this.nrobl - 1];
                            ++this.nitera;
                        }
                        this.nrobl = this.BlockNumberDB * (m - 1) + b;
                        this.sdur += this.blockTime[this.nrobl - 1];
                    }
                    for (i = 0; i < this.numactbran; ++i) {
                        this.FlujoMensual[i] = this.FlujoMensual[i] / this.nTotHoras;
                    }
                    for (i = 0; i < this.numactnod; ++i) {
                        this.mensual_pg[i] = this.mensual_pg[i] / this.nTotHoras;
                    }
                    for (i = 0; i < this.numactowner; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.mensualOwner_pg[i][j] = this.mensualOwner_pg[i][j] / this.nTotHoras;
                        }
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.mensualUnits_pg[i][j] = this.mensualUnits_pg[i][j] / this.nTotHoras;
                        }
                    }
                    boolean kiebra = false;
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Mensual de flujos promedio");
                    block31: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (this.NomActBra[ii].equals(this.NomBra[i])) {
                                int n = i;
                                this.FlujoAnual[n] = this.FlujoAnual[n] + this.FlujoMensual[ii];
                                int n2 = i;
                                this.FrecFlujo[n2] = this.FrecFlujo[n2] + 1;
                                kiebra = true;
                                continue block31;
                            }
                            kiebra = false;
                            if (kiebra) continue block31;
                        }
                    }
                    kiebra = false;
                    block33: for (ii = 0; ii < this.numactnod; ++ii) {
                        for (i = ii; i < this.numallnod; ++i) {
                            if (this.NomActNod[ii].equals(this.NomNod[i])) {
                                int n = i;
                                this.anual_pg[n] = this.anual_pg[n] + this.mensual_pg[ii];
                                int n3 = i;
                                this.Frec_pg[n3] = this.Frec_pg[n3] + 1;
                                kiebra = true;
                                continue block33;
                            }
                            kiebra = false;
                            if (kiebra) continue block33;
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactnod; ++ii) {
                        for (jj = 0; jj < this.numactowner; ++jj) {
                            for (i = 0; i < this.numallnod; ++i) {
                                for (j = 0; j < this.numallowner; ++j) {
                                    if (!this.NomActNod[ii].equals(this.NomNod[i]) || !this.NomActOwner[jj].equals(this.NomOwner[j])) continue;
                                    double[] dArray = this.anualOwner_pg[j];
                                    int n = i;
                                    dArray[n] = dArray[n] + this.mensualOwner_pg[jj][ii];
                                    int[] nArray = this.OFrec_pg[j];
                                    int n4 = i;
                                    nArray[n4] = nArray[n4] + 1;
                                }
                            }
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactnod; ++ii) {
                        for (jj = 0; jj < this.numactgen; ++jj) {
                            for (i = 0; i < this.numallnod; ++i) {
                                for (j = 0; j < this.numallgen; ++j) {
                                    if (!this.NomActNod[ii].equals(this.NomNod[i]) || !this.NomActGen[jj].equals(this.NomGen[j])) continue;
                                    double[] dArray = this.anualUnits_pg[j];
                                    int n = i;
                                    dArray[n] = dArray[n] + this.mensualUnits_pg[jj][ii];
                                    int[] nArray = this.UFrec_pg[j];
                                    int n5 = i;
                                    nArray[n5] = nArray[n5] + 1;
                                }
                            }
                        }
                    }
                    System.out.println("   - Flujos promedio actualizados ");
                    for (i = 0; i < this.numactnod; ++i) {
                        this.mensual_pg[i] = 0.0;
                        for (j = 0; j < this.numactowner; ++j) {
                            this.mensualOwner_pg[j][i] = 0.0;
                        }
                        for (j = 0; j < this.numactgen; ++j) {
                            this.mensualUnits_pg[j][i] = 0.0;
                        }
                    }
                    for (j = 0; j < this.numactbran; ++j) {
                        this.FlujoMensual[j] = 0.0;
                    }
                    block47: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii].equals(this.NomBra[i])) continue;
                            int n = i;
                            this.simDuration[n] = this.simDuration[n] + this.sdur;
                            continue block47;
                        }
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    if (this.FrecFlujo[i] <= 0) continue;
                    this.FlujoAnual[i] = this.FlujoAnual[i] / (double)this.FrecFlujo[i];
                }
                for (i = 0; i < this.numallnod; ++i) {
                    if (this.Frec_pg[i] <= 0) continue;
                    this.anual_pg[i] = this.anual_pg[i] / (double)this.Frec_pg[i];
                }
                for (i = 0; i < this.numallnod; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (this.OFrec_pg[j][i] <= 0) continue;
                        this.anualOwner_pg[j][i] = this.anualOwner_pg[j][i] / (double)this.OFrec_pg[j][i] / 100.0;
                    }
                    for (j = 0; j < this.numallgen; ++j) {
                        if (this.UFrec_pg[j][i] <= 0) continue;
                        this.anualUnits_pg[j][i] = this.anualUnits_pg[j][i] / (double)this.UFrec_pg[j][i] / 100.0;
                    }
                }
                System.out.println(" ");
                System.out.println(" Calculating Anual Kirschen");
                System.out.println(" ");
                System.out.println(" ");
                System.out.println(" Building commons");
                this.build_Common(this.FlujoAnual);
                this.myPPrintStream.println("Flujos Anuales");
                for (i = 0; i < this.numallbran; ++i) {
                    this.myPPrintStream.println("Flujo[" + this.NomBra[i] + "]" + this.FlujoAnual[i]);
                }
                System.out.println(" Commons OK");
                System.out.println(" ");
                System.out.println(" Building BusCom");
                this.build_BusCom();
                System.out.println(" BusCom OK");
                System.out.println(" ");
                System.out.println(" Building RankCom");
                this.build_RankCom();
                System.out.println(" RankCom OK");
                System.out.println(" ");
                System.out.println(" Building OrdCom");
                this.build_OrdCom();
                System.out.println(" OrdCom OK");
                System.out.println(" ");
                System.out.println(" Building Contribuciones");
                this.build_Contribuciones();
                System.out.println(" Contribuciones OK");
                System.out.println(" ");
                System.out.println(" Building Participaciones");
                this.build_Participa();
                System.out.println(" Participaciones OK");
                System.out.println(" ");
                System.out.println(" ");
                System.out.println(" Anual Kirschen Done");
                ++this.anos;
                for (i = 0; i < this.numallnod; ++i) {
                    this.anual_pg[i] = 0.0;
                    this.Frec_pg[i] = 0;
                    for (j = 0; j < this.numallowner; ++j) {
                        this.anualOwner_pg[j][i] = 0.0;
                        this.OFrec_pg[j][i] = 0;
                    }
                    for (j = 0; j < this.numallgen; ++j) {
                        this.anualUnits_pg[j][i] = 0.0;
                        this.UFrec_pg[j][i] = 0;
                    }
                }
                for (j = 0; j < this.numallbran; ++j) {
                    this.FlujoAnual[j] = 0.0;
                    this.FrecFlujo[j] = 0;
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            for (i = 0; i < this.numallbran; ++i) {
                this.PLA1[i] = 0.0;
                this.PLA2[i] = 0.0;
                this.PLA3[i] = 0.0;
                for (j = 0; j < this.numallnod; ++j) {
                    if (this.FreProAnual[i][j] <= 0) continue;
                    this.Prorrateo[i][j] = 100.0 * this.ProAnual[i][j] / (double)this.FreProAnual[i][j];
                    int n = i;
                    this.PLA1[n] = this.PLA1[n] + this.Prorrateo[i][j];
                }
                for (j = 0; j < this.numallowner; ++j) {
                    if (this.FreOProAnual[i][j] <= 0) continue;
                    this.OProrrateo[i][j] = 100.0 * this.OProAnual[i][j] / (double)this.FreOProAnual[i][j];
                    int n = i;
                    this.PLA2[n] = this.PLA2[n] + this.OProrrateo[i][j];
                }
                for (j = 0; j < this.numallgen; ++j) {
                    if (this.FreUProAnual[i][j] <= 0) continue;
                    this.PUnits[i][j] = 100.0 * this.UProAnual[i][j] / (double)this.FreUProAnual[i][j];
                    int n = i;
                    this.PLA3[n] = this.PLA3[n] + this.PUnits[i][j];
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    if (!(Math.abs(this.PLA1[i]) > 0.01)) continue;
                    this.Prorrateo[i][j] = this.Prorrateo[i][j] / this.PLA1[i] * 100.0;
                }
                for (j = 0; j < this.numallowner; ++j) {
                    if (!(Math.abs(this.PLA2[i]) > 0.01)) continue;
                    this.OProrrateo[i][j] = this.OProrrateo[i][j] / this.PLA2[i] * 100.0;
                }
                for (j = 0; j < this.numallgen; ++j) {
                    if (!(Math.abs(this.PLA3[i]) > 0.01)) continue;
                    this.PUnits[i][j] = this.PUnits[i][j] / this.PLA3[i] * 100.0;
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    this.PagoBarra[i][j] = this.one ? this.Prorrateo[i][j] / 100.0 * this.AVNR_COyM[i] : this.Prorrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numallowner; ++j) {
                    this.PagoOwner[i][j] = this.one ? this.OProrrateo[i][j] / 100.0 * this.AVNR_COyM[i] : this.OProrrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numallgen; ++j) {
                    this.PagoUnits[i][j] = this.one ? this.PUnits[i][j] / 100.0 * this.AVNR_COyM[i] : this.PUnits[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
            }
            if (rep) {
                System.out.println("Making Report File");
                System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Total Barras         : " + this.numallnod);
                this.myPPrintStream.println("Total Ramas          : " + this.numallbran);
                this.myPPrintStream.println("Total Generadores    : " + this.numallgen);
                this.myPPrintStream.println("Total Cargas         : " + this.numalllast);
                this.myPPrintStream.println("Total L\u00edneas         : " + this.numalllin);
                this.myPPrintStream.println("Total Transformadores: " + this.numalltrafo);
                this.myPPrintStream.println("Total Execution Time : " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Barra ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Barra             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(Math.abs(this.Prorrateo[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPKirschen.strformat(this.NomBra[i], 30) + "  " + TPKirschen.strformat(this.NomNod[j], 30) + "  " + TPKirschen.numformat(this.Prorrateo[i][j], 15, 5) + "               " + TPKirschen.numformat(this.PagoBarra[i][j], 15, 5));
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Owner ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Owner             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (!(Math.abs(this.OProrrateo[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPKirschen.strformat(this.NomBra[i], 30) + "    " + TPKirschen.strformat(this.NomOwner[j], 30) + "    " + TPKirschen.numformat(this.OProrrateo[i][j], 15, 5) + "               " + TPKirschen.numformat(this.PagoOwner[i][j], 15, 5));
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Generadores ");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Unidad             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallgen; ++j) {
                        if (!(this.PUnits[i][j] > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPKirschen.strformat(this.NomBra[i], 30) + "    " + TPKirschen.strformat(this.NomGen[j], 30) + "    " + TPKirschen.numformat(this.PUnits[i][j], 15, 5) + "               " + this.PagoUnits[i][j]);
                    }
                }
                this.myPPrintStream.println(" ");
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        if (DBrep) {
            try {
                System.out.println("-Saving TPResDB ... ");
                System.out.println(" Time = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                Statement s = conTPResDB.createStatement();
                s.executeUpdate("DELETE * FROM Kirschen_Barra");
                s.executeUpdate("DELETE * FROM Kirschen_Empresa");
                s.executeUpdate("DELETE * FROM Kirschen_Generador");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(this.Prorrateo[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Kirschen_Barra (rama,barra,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomNod[j] + "'," + this.Prorrateo[i][j] + "," + this.PagoBarra[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (!(this.OProrrateo[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Kirschen_Empresa (rama,empresa,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomOwner[j] + "'," + this.OProrrateo[i][j] + "," + this.PagoOwner[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallgen; ++j) {
                        if (!(this.PUnits[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Kirschen_Generador (rama,generador,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomGen[j] + "'," + this.PUnits[i][j] + "," + this.PagoUnits[i][j] + ")");
                    }
                }
                System.out.println("");
                System.out.println("-TPResDB Saved ");
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Guardar Base de Datos " + e);
                e.printStackTrace();
            }
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = true;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        if (this.one) {
            this.ActSchematic.Modifiedstate = false;
        }
        System.out.println("TOTAL EXECUTION TIME = " + TPKirschen.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/TPKirschen.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
        if (vis) {
            if (this.MyTPKirschenVisualFrame == null) {
                this.MyTPKirschenVisualFrame = new TPKirschenVisualFrame(this, this.ctrla, false);
            } else {
                this.MyTPKirschenVisualFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("TPKirschen Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
        if (!vis) {
            this.finalize();
        }
    }

    public void InitAllNetwork() {
        int j;
        int i;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement((Busbar)TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.LosOwner = new String[this.numallgen];
        this.FlujoAnual = new double[this.numallbran];
        this.FrecFlujo = new int[this.numallbran];
        this.anual_pg = new double[this.numallnod];
        this.Frec_pg = new int[this.numallnod];
        this.AllBranchI = new int[this.numallbran];
        this.AllBranchJ = new int[this.numallbran];
        this.AllGenNode = new int[this.numallgen];
        this.BranCom = new int[this.numallbran];
        this.ComI = new int[this.numallbran];
        this.ComJ = new int[this.numallbran];
        this.ProAnual = new double[this.numallbran][this.numallnod];
        this.FreProAnual = new int[this.numallbran][this.numallnod];
        this.PLA1 = new double[this.numallbran];
        this.PLA2 = new double[this.numallbran];
        this.PLA3 = new double[this.numallbran];
        this.AVNR_COyM = new double[this.numallbran];
        this.PagoBarra = new double[this.numallbran][this.numallnod];
        this.simDuration = new double[this.numallbran];
        this.PUnits = new double[this.numallbran][this.numallgen];
        this.FUnits = new int[this.numallbran][this.numallgen];
        this.PagoUnits = new double[this.numallbran][this.numallgen];
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempLine.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempLine.getcon2());
                    this.AVNR_COyM[countBra] = TempLine.getannuity(this.ActSchematic.intrate);
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempTrafo.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempTrafo.getcon2());
                    this.AVNR_COyM[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate);
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                this.LosOwner[countGen] = TempGenerator.getinv_owner();
                this.AllGenNode[countGen] = this.numbusALL(TempGenerator.getcon2());
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            ++countLas;
        }
        int aux = 0;
        if (this.numallgen >= 2) {
            for (int i2 = 0; i2 < this.numallgen; ++i2) {
                aux = 0;
                for (int j2 = i2 + 1; j2 < this.numallgen; ++j2) {
                    if (!this.LosOwner[i2].equals(this.LosOwner[j2])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallowner;
            }
        } else {
            this.numallowner = this.numallgen;
        }
        this.OProrrateo = new double[this.numallbran][this.numallowner];
        this.OFrecuencia = new int[this.numallbran][this.numallowner];
        this.Prorrateo = new double[this.numallbran][this.numallnod];
        this.Frecuencia = new int[this.numallbran][this.numallnod];
        this.NomOwner = new String[this.numallowner];
        this.anualOwner_pg = new double[this.numallowner][this.numallnod];
        this.OFrec_pg = new int[this.numallowner][this.numallnod];
        this.OProAnual = new double[this.numallbran][this.numallowner];
        this.FreOProAnual = new int[this.numallbran][this.numallowner];
        this.PagoOwner = new double[this.numallbran][this.numallowner];
        this.PUnits = new double[this.numallbran][this.numallgen];
        this.FUnits = new int[this.numallbran][this.numallgen];
        this.PagoUnits = new double[this.numallbran][this.numallgen];
        this.UProAnual = new double[this.numallbran][this.numallgen];
        this.FreUProAnual = new int[this.numallbran][this.numallgen];
        this.anualUnits_pg = new double[this.numallgen][this.numallnod];
        this.UFrec_pg = new int[this.numallgen][this.numallnod];
        aux = 0;
        int cmul = 0;
        if (this.numallgen >= 2) {
            for (i = 0; i < this.numallgen; ++i) {
                aux = 0;
                for (j = i + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomOwner[cmul] = this.LosOwner[i];
                ++cmul;
            }
        } else {
            this.NomOwner[0] = this.LosOwner[0];
        }
        for (i = 0; i < this.numallbran; ++i) {
            this.FlujoAnual[i] = 0.0;
            this.FrecFlujo[i] = 0;
            this.simDuration[i] = 0.0;
            for (int jj = 0; jj < this.numallowner; ++jj) {
                this.OProAnual[i][jj] = 0.0;
                this.OProrrateo[i][jj] = 0.0;
                this.OFrecuencia[i][jj] = 0;
                this.FreOProAnual[i][jj] = 0;
            }
            for (j = 0; j < this.numallnod; ++j) {
                this.FreProAnual[i][j] = 0;
                this.ProAnual[i][j] = 0.0;
                this.Prorrateo[i][j] = 0.0;
                this.Frecuencia[i][j] = 0;
            }
            for (j = 0; j < this.numallgen; ++j) {
                this.PUnits[i][j] = 0.0;
                this.FUnits[i][j] = 0;
                this.UProAnual[i][j] = 0.0;
                this.FreUProAnual[i][j] = 0;
            }
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro, boolean HydroDBa) {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
        this.PDCLF = new double[this.numactnod];
        double FactorCreci = Math.pow(1.3, ano - 1);
        for (i = 0; i < this.numactnod; ++i) {
            int k;
            this.PDCLF[i] = 0.0;
            this.node_pg[i] = 0.0;
            this.node_pl[i] = 0.0;
            for (k = 0; k < this.numactowner; ++k) {
                this.PGenOwn[k][i] = 0.0;
            }
            for (k = 0; k < this.numactgen; ++k) {
                this.PGenUnits[k][i] = 0.0;
            }
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        int NroDdaActual = -1;
        int NroDdaActual2 = -1;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
            Generator TempGenerator = (Generator)TempComponent;
            block4: for (i = 0; i < this.dimDBGen; ++i) {
                if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                int n = this.GenNode[countG];
                this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                int n2 = this.GenNode[countG];
                this.node_pg[n2] = this.node_pg[n2] + this.PDB[i] / this.sref;
                this.TotGen += this.PDB[i];
                double[] dArray = this.PGenUnits[countG];
                int n3 = this.GenNode[countG];
                dArray[n3] = dArray[n3] + this.PDB[i];
                for (int k = 0; k < this.numactowner; ++k) {
                    if (!this.NomActOwner[k].equals(TempGenerator.getinv_owner())) continue;
                    double[] dArray2 = this.PGenOwn[k];
                    int n4 = this.GenNode[countG];
                    dArray2[n4] = dArray2[n4] + this.PDB[i];
                    break block4;
                }
                break;
            }
            ++countG;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            if (HydroDBa) {
                NroDdaActual = this.BlockNumberDB * (mes - 1) + bloque;
                for (i = 0; i < this.dimDBLoad; ++i) {
                    if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                    this.TotDem += this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                    int n5 = this.LasNode[countL];
                    this.node_pl[n5] = this.node_pl[n5] + this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                    break;
                }
            } else {
                NroDdaActual2 = 12 * (ano - this.InitialYearDB) + mes;
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    if (!this.NameLDB2[i].equals(TempLoad.getName())) continue;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen / this.sref;
                    this.TotDem += this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                    int n6 = this.LasNode[countL];
                    this.node_pl[n6] = this.node_pl[n6] + this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen / this.sref;
                    break;
                }
            }
            ++countL;
        }
    }

    public void build_Vecino(Vector Dom, double[] flux, String barra) {
        int i = 0;
        int k = 0;
        String vecino = "nada";
        boolean esta = false;
        if (Dom.size() == 0) {
            Dom.addElement(barra);
        }
        for (i = 0; i < this.numallbran; ++i) {
            if (flux[i] > 1.0E-6 && this.AllBranchI[i] == this.numbusALL(barra)) {
                vecino = this.NomNod[this.AllBranchJ[i]];
                esta = false;
                for (k = 0; k < Dom.size(); ++k) {
                    if (!vecino.equals((String)Dom.elementAt(k))) continue;
                    esta = true;
                }
                if (esta) continue;
                Dom.addElement(vecino);
                this.build_Vecino(Dom, flux, vecino);
                continue;
            }
            if (!(flux[i] < -1.0E-6) || this.AllBranchJ[i] != this.numbusALL(barra)) continue;
            vecino = this.NomNod[this.AllBranchI[i]];
            esta = false;
            for (k = 0; k < Dom.size(); ++k) {
                if (!vecino.equals((String)Dom.elementAt(k))) continue;
                esta = true;
            }
            if (esta) continue;
            Dom.addElement(vecino);
            this.build_Vecino(Dom, flux, vecino);
        }
    }

    public void build_Dominio(double[] flux) {
        int i;
        System.out.println("   Domain construction");
        this.BusGen = new Vector();
        boolean id = false;
        boolean numb = false;
        boolean esta = false;
        int countBus = 0;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar)) continue;
            Busbar TempBusbar = (Busbar)TempComponent;
            for (i = 0; i < this.numallgen; ++i) {
                if (this.AllGenNode[i] != countBus || !(this.anual_pg[this.AllGenNode[i]] > 1.0E-6)) continue;
                this.BusGen.addElement(TempBusbar.getName());
                break;
            }
            ++countBus;
        }
        this.Dom = new Vector[this.BusGen.size()];
        for (i = 0; i < this.BusGen.size(); ++i) {
            this.Dom[i] = new Vector();
            this.build_Vecino(this.Dom[i], flux, (String)this.BusGen.elementAt(i));
        }
    }

    public void build_AlimBus() {
        int i = 0;
        int j = 0;
        int k = 0;
        boolean esta = false;
        this.AlimBus = new Vector[this.numallnod];
        this.Rank = new int[this.numallnod];
        for (i = 0; i < this.numallnod; ++i) {
            this.AlimBus[i] = new Vector();
            for (j = 0; j < this.BusGen.size(); ++j) {
                for (k = 0; k < this.Dom[j].size(); ++k) {
                    if (!this.NomNod[i].equals((String)this.Dom[j].elementAt(k))) continue;
                    this.AlimBus[i].addElement(this.NomNod[this.numbusALL((String)this.BusGen.elementAt(j))]);
                }
            }
        }
        for (i = 0; i < this.numallnod; ++i) {
            this.Rank[i] = this.AlimBus[i].size();
        }
    }

    public boolean BarraEnCommon(Vector Gar, String barra) {
        if (Gar.size() == 0) {
            return false;
        }
        int i = 0;
        boolean j = false;
        for (i = 0; i < Gar.size(); ++i) {
            if (!barra.equals((String)Gar.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void build_Common(double[] flux) {
        int i = 0;
        boolean j = false;
        int k = 0;
        boolean esta = false;
        this.build_Dominio(flux);
        this.build_AlimBus();
        this.Ord = new int[this.numallnod];
        for (i = 0; i < this.numallnod; ++i) {
            this.Ord[i] = i;
        }
        int auxId = 0;
        for (k = 0; k < this.numallnod + 1; ++k) {
            for (i = 0; i < this.numallnod - 1; ++i) {
                if (this.Rank[this.Ord[i]] <= this.Rank[this.Ord[i + 1]]) continue;
                auxId = this.Ord[i];
                this.Ord[i] = this.Ord[i + 1];
                this.Ord[i + 1] = auxId;
            }
        }
        this.Common = new Vector();
        Vector TempCommon = new Vector();
        this.Garbage = new Vector();
        for (k = 0; k < this.numallnod; ++k) {
            TempCommon = null;
            TempCommon = new Vector();
            this.build_ReCom(this.Garbage, this.Ord[k], TempCommon, this.NomNod[this.Ord[k]]);
            if (TempCommon.size() == 0) continue;
            this.Common.addElement(TempCommon);
        }
    }

    public void build_ReCom(Vector Garba, int OrdK, Vector TeCom, String barra) {
        int i = 0;
        boolean j = false;
        if (!this.BarraEnCommon(Garba, barra)) {
            TeCom.addElement(barra);
            Garba.addElement(barra);
            for (i = 0; i < this.numallbran; ++i) {
                if (this.AllBranchI[i] == OrdK) {
                    if (this.BarraEnCommon(Garba, this.NomNod[this.AllBranchJ[i]]) || this.Rank[this.numbusALL(barra)] != this.Rank[this.AllBranchJ[i]] || !this.EqAlimBus(this.AlimBus[this.AllBranchJ[i]], this.AlimBus[OrdK])) continue;
                    this.build_ReCom(Garba, this.AllBranchJ[i], TeCom, this.NomNod[this.AllBranchJ[i]]);
                    continue;
                }
                if (this.AllBranchJ[i] != OrdK || this.BarraEnCommon(Garba, this.NomNod[this.AllBranchI[i]]) || this.Rank[this.numbusALL(barra)] != this.Rank[this.AllBranchI[i]] || !this.EqAlimBus(this.AlimBus[this.AllBranchI[i]], this.AlimBus[OrdK])) continue;
                this.build_ReCom(Garba, this.AllBranchI[i], TeCom, this.NomNod[this.AllBranchI[i]]);
            }
        } else {
            return;
        }
    }

    public boolean EqAlimBus(Vector alim1, Vector alim2) {
        int a = alim1.size();
        int b = alim2.size();
        int i = 0;
        int j = 0;
        int acum = 0;
        int acumTot = 0;
        String aux1 = "nada";
        String aux2 = "nada";
        if (a == b) {
            acumTot = 0;
            for (i = 0; i < a; ++i) {
                acum = 0;
                aux1 = (String)alim1.elementAt(i);
                for (j = 0; j < a; ++j) {
                    aux2 = (String)alim2.elementAt(j);
                    if (!aux1.equals(aux2)) continue;
                    ++acum;
                }
                if (acum == 1) {
                    ++acumTot;
                    continue;
                }
                if (acum == 0) {
                    return false;
                }
                System.out.println(" Fatal Error in EqAlimBus: Duplicated element");
            }
            return acumTot == a;
        }
        System.out.println(" Fatal Error in EqAlimBus: Error in Rank evaluation, call your provider");
        return false;
    }

    public void build_BusCom() {
        int i = 0;
        int j = 0;
        int k = 0;
        this.BusCom = new int[this.numallnod];
        for (i = 0; i < this.numallnod; ++i) {
            for (j = 0; j < this.Common.size(); ++j) {
                for (k = 0; k < ((Vector)this.Common.elementAt(j)).size(); ++k) {
                    if (!this.NomNod[i].equals((String)((Vector)this.Common.elementAt(j)).elementAt(k))) continue;
                    this.BusCom[i] = j;
                }
            }
        }
    }

    public void build_RankCom() {
        int i = 0;
        this.RankCom = new int[this.Common.size()];
        for (i = 0; i < this.Common.size(); ++i) {
            this.RankCom[i] = this.Rank[this.numbusALL((String)((Vector)this.Common.elementAt(i)).elementAt(0))];
        }
    }

    public void build_OrdCom() {
        int i = 0;
        int k = 0;
        int auxId = 0;
        this.OrdCom = new int[this.Common.size()];
        for (i = 0; i < this.Common.size(); ++i) {
            this.OrdCom[i] = i;
        }
        for (k = 0; k < this.Common.size() + 1; ++k) {
            for (i = 0; i < this.Common.size() - 1; ++i) {
                if (this.RankCom[this.OrdCom[i]] <= this.RankCom[this.OrdCom[i + 1]]) continue;
                auxId = this.OrdCom[i];
                this.OrdCom[i] = this.OrdCom[i + 1];
                this.OrdCom[i + 1] = auxId;
            }
        }
    }

    public void build_Contribuciones() {
        int i = 0;
        int j = 0;
        int k = 0;
        int w = 0;
        int cs = this.Common.size();
        int bgs = this.BusGen.size();
        this.I = new double[cs];
        this.E = new double[cs];
        this.G = new double[cs];
        this.C = new double[bgs][cs];
        this.FL = new double[cs][cs];
        this.FLG = new double[bgs][cs][cs];
        for (j = 0; j < cs; ++j) {
            this.I[j] = 0.0;
            this.E[j] = 0.0;
            this.G[j] = 0.0;
            for (k = 0; k < cs; ++k) {
                this.FL[j][k] = 0.0;
                for (i = 0; i < bgs; ++i) {
                    this.C[i][k] = 0.0;
                    this.FLG[i][k][j] = 0.0;
                }
            }
        }
        for (j = 0; j < cs; ++j) {
            if (this.RankCom[j] != 1) continue;
            for (i = 0; i < this.numallnod; ++i) {
                if (this.BusCom[i] != j) continue;
                int n = j;
                this.I[n] = this.I[n] + this.anual_pg[i];
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            if (this.BusCom[this.AllBranchI[i]] == this.BusCom[this.AllBranchJ[i]]) continue;
            double[] dArray = this.FL[this.BusCom[this.AllBranchI[i]]];
            int n = this.BusCom[this.AllBranchJ[i]];
            dArray[n] = dArray[n] + this.FlujoAnual[i];
            double[] dArray2 = this.FL[this.BusCom[this.AllBranchJ[i]]];
            int n2 = this.BusCom[this.AllBranchI[i]];
            dArray2[n2] = dArray2[n2] - this.FlujoAnual[i];
        }
        for (j = 1; j < cs; ++j) {
            if (this.RankCom[j] <= 1) continue;
            for (i = 0; i < this.numallnod; ++i) {
                if (this.BusCom[i] != j) continue;
                int n = j;
                this.I[n] = this.I[n] + this.anual_pg[i];
                int n3 = j;
                this.G[n3] = this.G[n3] + this.anual_pg[i];
            }
            for (i = 0; i < cs; ++i) {
                if (i == j) continue;
                if (this.FL[i][j] > 1.0E-6) {
                    int n = j;
                    this.I[n] = this.I[n] + this.FL[i][j];
                }
                if (!(this.FL[j][i] > 1.0E-6)) continue;
                int n = j;
                this.E[n] = this.E[n] + this.FL[j][i];
            }
        }
        for (k = 0; k < cs; ++k) {
            for (j = 0; j < bgs; ++j) {
                if (this.BusCom[this.numbusALL((String)this.BusGen.elementAt(j))] != this.OrdCom[k]) continue;
                if (this.I[this.OrdCom[k]] != 0.0) {
                    this.C[j][this.OrdCom[k]] = this.anual_pg[this.numbusALL((String)this.BusGen.elementAt(j))] / this.I[this.OrdCom[k]];
                }
                for (int ji = 0; ji < cs; ++ji) {
                    if (!(this.FL[this.OrdCom[k]][this.OrdCom[ji]] > 1.0E-6) || this.RankCom[this.OrdCom[ji]] < this.RankCom[this.OrdCom[k]] || k == ji) continue;
                    this.FLG[j][this.OrdCom[k]][this.OrdCom[ji]] = this.C[j][this.OrdCom[k]] * this.FL[this.OrdCom[k]][this.OrdCom[ji]];
                    if (this.I[this.OrdCom[ji]] == 0.0) continue;
                    this.C[j][this.OrdCom[ji]] = this.FLG[j][this.OrdCom[k]][this.OrdCom[ji]] / this.I[this.OrdCom[ji]];
                }
            }
        }
        for (k = 0; k < cs; ++k) {
            for (j = 0; j < bgs; ++j) {
                if (this.BusCom[this.numbusALL((String)this.BusGen.elementAt(j))] == this.OrdCom[k]) continue;
                for (w = 0; w < cs; ++w) {
                    if (this.RankCom[this.OrdCom[w]] < this.RankCom[this.OrdCom[k]] || !(this.FL[this.OrdCom[k]][this.OrdCom[w]] > 1.0E-6) || k == w) continue;
                    this.FLG[j][this.OrdCom[k]][this.OrdCom[w]] = this.C[j][this.OrdCom[k]] * this.FL[this.OrdCom[k]][this.OrdCom[w]];
                    if (this.I[this.OrdCom[w]] == 0.0) continue;
                    double[] dArray = this.C[j];
                    int n = this.OrdCom[w];
                    dArray[n] = dArray[n] + this.FLG[j][this.OrdCom[k]][this.OrdCom[w]] / this.I[this.OrdCom[w]];
                }
            }
        }
    }

    public void build_Participa() {
        int i = -1;
        int j = -1;
        int k = -1;
        int ai = -1;
        for (i = 0; i < this.numallbran; ++i) {
            if (this.BusCom[this.AllBranchI[i]] == this.BusCom[this.AllBranchJ[i]]) {
                this.BranCom[i] = this.BusCom[this.AllBranchI[i]];
                this.ComI[i] = -1;
                this.ComJ[i] = -1;
                continue;
            }
            this.BranCom[i] = -1;
            this.ComI[i] = this.BusCom[this.AllBranchI[i]];
            this.ComJ[i] = this.BusCom[this.AllBranchJ[i]];
        }
        double[][] FBG = new double[this.BusGen.size()][this.numallbran];
        for (i = 0; i < this.BusGen.size(); ++i) {
            for (j = 0; j < this.numallbran; ++j) {
                if (this.BranCom[j] == -1) {
                    if (this.FLG[i][this.ComI[j]][this.ComJ[j]] > 1.0E-13) {
                        FBG[i][j] = this.C[i][this.ComI[j]] * this.FlujoAnual[j];
                        continue;
                    }
                    if (!(this.FLG[i][this.ComJ[j]][this.ComI[j]] > 1.0E-11)) continue;
                    FBG[i][j] = this.C[i][this.ComJ[j]] * this.FlujoAnual[j];
                    continue;
                }
                FBG[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.BusGen.size(); ++i) {
            ai = this.numbusALL((String)this.BusGen.elementAt(i));
            for (j = 0; j < this.numallbran; ++j) {
                if (this.BranCom[j] != -1 && Math.abs(this.FlujoAnual[j]) > 1.0E-12) {
                    double[] dArray = this.ProAnual[j];
                    int n = ai;
                    dArray[n] = dArray[n] + this.C[i][this.BranCom[j]];
                    continue;
                }
                if (!(Math.abs(this.FlujoAnual[j]) > 1.0E-12)) continue;
                if (this.FLG[i][this.ComI[j]][this.ComJ[j]] > 1.0E-12) {
                    double[] dArray = this.ProAnual[j];
                    int n = ai;
                    dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]);
                    continue;
                }
                if (!(this.FLG[i][this.ComJ[j]][this.ComI[j]] > 1.0E-12)) continue;
                double[] dArray = this.ProAnual[j];
                int n = ai;
                dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]);
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            if (!(Math.abs(this.FlujoAnual[i]) > 1.0E-12)) continue;
            j = 0;
            while (j < this.numallnod) {
                int[] nArray = this.FreProAnual[i];
                int n = j++;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (i = 0; i < this.BusGen.size(); ++i) {
            ai = this.numbusALL((String)this.BusGen.elementAt(i));
            for (j = 0; j < this.numallbran; ++j) {
                if (this.BranCom[j] != -1 && Math.abs(this.FlujoAnual[j]) > 1.0E-12) {
                    for (k = 0; k < this.numallowner; ++k) {
                        if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                        double[] dArray = this.OProAnual[j];
                        int n = k;
                        dArray[n] = dArray[n] + this.C[i][this.BranCom[j]] * this.anualOwner_pg[k][ai] / this.anual_pg[ai];
                    }
                    continue;
                }
                if (!(Math.abs(this.FlujoAnual[j]) > 1.0E-12)) continue;
                if (this.FLG[i][this.ComI[j]][this.ComJ[j]] > 1.0E-12) {
                    for (k = 0; k < this.numallowner; ++k) {
                        if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                        double[] dArray = this.OProAnual[j];
                        int n = k;
                        dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]) * this.anualOwner_pg[k][ai] / this.anual_pg[ai];
                    }
                    continue;
                }
                if (!(this.FLG[i][this.ComJ[j]][this.ComI[j]] > 1.0E-12)) continue;
                for (k = 0; k < this.numallowner; ++k) {
                    if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                    double[] dArray = this.OProAnual[j];
                    int n = k;
                    dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]) * this.anualOwner_pg[k][ai] / this.anual_pg[ai];
                }
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            if (!(Math.abs(this.FlujoAnual[i]) > 1.0E-12)) continue;
            j = 0;
            while (j < this.numallowner) {
                int[] nArray = this.FreOProAnual[i];
                int n = j++;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (i = 0; i < this.BusGen.size(); ++i) {
            ai = this.numbusALL((String)this.BusGen.elementAt(i));
            for (j = 0; j < this.numallbran; ++j) {
                if (this.BranCom[j] != -1 && Math.abs(this.FlujoAnual[j]) > 1.0E-12) {
                    for (k = 0; k < this.numallgen; ++k) {
                        if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                        double[] dArray = this.UProAnual[j];
                        int n = k;
                        dArray[n] = dArray[n] + this.C[i][this.BranCom[j]] * this.anualUnits_pg[k][ai] / this.anual_pg[ai];
                    }
                    continue;
                }
                if (!(Math.abs(this.FlujoAnual[j]) > 1.0E-12)) continue;
                if (this.FLG[i][this.ComI[j]][this.ComJ[j]] > 1.0E-12) {
                    for (k = 0; k < this.numallgen; ++k) {
                        if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                        double[] dArray = this.UProAnual[j];
                        int n = k;
                        dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]) * this.anualUnits_pg[k][ai] / this.anual_pg[ai];
                    }
                    continue;
                }
                if (!(this.FLG[i][this.ComJ[j]][this.ComI[j]] > 1.0E-12)) continue;
                for (k = 0; k < this.numallgen; ++k) {
                    if (!(this.anual_pg[ai] > 1.0E-6)) continue;
                    double[] dArray = this.UProAnual[j];
                    int n = k;
                    dArray[n] = dArray[n] + Math.abs(FBG[i][j] / this.FlujoAnual[j]) * this.anualUnits_pg[k][ai] / this.anual_pg[ai];
                }
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            if (!(Math.abs(this.FlujoAnual[i]) > 1.0E-12)) continue;
            j = 0;
            while (j < this.numallgen) {
                int[] nArray = this.FreUProAnual[i];
                int n = j++;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    public void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa, boolean HydroDBa) {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
            this.year1 = Integer.parseInt(SDYa);
            this.year2 = Integer.parseInt(EDYa);
            for (i = 0; i < 12; ++i) {
                if (mes[i].equals(SDMa)) {
                    this.month1 = i + 1;
                }
                if (!mes[i].equals(EDMa)) continue;
                this.month2 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.block2 = Integer.parseInt(EDBa);
            this.hidro2 = Integer.parseInt(EDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            this.flow2 = ((this.year2 - this.InitialYearDB) * 12 + (this.month2 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block2 - 1) * this.HydroNumberDB + this.hidro2;
            if (this.flow2 < this.flow1) {
                System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
                int mulanga = this.flow2;
                this.flow2 = this.flow1;
                this.flow1 = mulanga;
                System.out.println(" ........ Problema resuelto autom\u00e1ticamente (inverse selection)");
            } else if (this.flow2 == this.flow1) {
                this.one = true;
            }
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("Flow Selection Details");
            System.out.println("----------------------");
            System.out.println("Total DB flows  :    " + tflo);
            System.out.println("Total DB years  :    " + this.YearNumberDB);
            System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
            System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
            System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
            System.out.println("Inicio          :" + TPKirschen.numformat(this.year1, 8) + "/" + TPKirschen.numformat(this.month1, 8) + "/" + TPKirschen.numformat(this.block1, 8) + "/" + TPKirschen.numformat(this.hidro1, 8) + "/" + TPKirschen.numformat(this.flow1, 8));
            System.out.println("Final           :" + TPKirschen.numformat(this.year2, 8) + "/" + TPKirschen.numformat(this.month2, 8) + "/" + TPKirschen.numformat(this.block2, 8) + "/" + TPKirschen.numformat(this.hidro2, 8) + "/" + TPKirschen.numformat(this.flow2, 8));
            System.out.println(" ");
            this.ndem = this.BlockNumberDB * 12;
            this.blockTime = new double[this.ndem];
            ResultSet r0 = s.executeQuery("SELECT *\tFROM blockTime");
            r0.next();
            for (j = 1; j <= this.ndem; ++j) {
                this.blockTime[j - 1] = r0.getDouble("d" + j);
            }
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            if (HydroDBa) {
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
                ResultSet r3 = s.executeQuery("SELECT Year\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    ++i;
                }
                this.dimDBYear = i;
                this.TotDemDB = new double[this.dimDBYear][this.ndem];
                this.HidYearNameLDB = new int[this.dimDBYear];
                for (i = 0; i < this.dimDBYear; ++i) {
                    this.HidYearNameLDB[i] = 1;
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = 123456.0;
                    }
                }
                r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    this.HidYearNameLDB[i] = r3.getInt("Year");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                    }
                    ++i;
                }
            } else {
                this.ndem2 = this.YearNumberDB * 12;
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad2 = i;
                this.NameLDB2 = new String[this.dimDBLoad2];
                this.PLDB2 = new double[this.dimDBLoad2][this.ndem2];
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    this.NameLDB2[i] = "nada";
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB2[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
            }
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = 12;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = TempNdb_comp.getentry_period();
            m1 = TempNdb_comp.getentry_month();
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = nmes;
            int rano = nano;
            if (rmes == 1) {
                rmes = 12;
                --rano;
            } else if (rmes >= 2 && rmes <= 12) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork() {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.Flujo != null || this.GenNode != null || this.LasNode != null || this.node_pl != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.node_pl = null;
            this.Flujo = null;
            this.GenNode = null;
            this.LasNode = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.node_pl = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.FlujoMensual = new double[this.numactbran];
        this.mensual_pg = new double[this.numactnod];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
            this.node_pl[ixi] = 0.0;
            this.mensual_pg[ixi] = 0.0;
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
            this.FlujoMensual[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GGDF = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slackNode = slack = this.numbus(TempGenerator.getcon2());
                    this.slackGenerator = countGen;
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        this.mensualOwner_pg = new double[this.numactowner][this.numactnod];
        this.PGenUnits = new double[this.numactgen][this.numactnod];
        this.mensualUnits_pg = new double[this.numactgen][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.node_pl = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GGDF = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }
}

