/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TP;
import de.core.TPFrame;
import de.core.TPGLDFVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;

public final class TPGLDF
extends TP {
    TPGLDFVisualFrame MyTPGLDFVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pl;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActLoad;
    String[] NomLoad;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int block;
    int hidro;
    int actPeriod;
    int actMonth;
    int slackNode;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    int[][] Frecuencia;
    double[][] LProrrateoAct;
    double[][] ALProrrateoAct;
    public double[][] LProrrateo;
    int[][] LFrecuencia;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleSquareMatrix MatX;
    DoubleMatrix GLDF;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PConLoad;
    int numactload = 0;
    int numallload = 0;
    String[] LosLoad;
    String[] LosActLoad;
    boolean sisentido = false;
    int nitera = 0;
    double[] PLA1;
    double[] PLA2;
    double[] AVNR_COyM;
    double[][] PagoBarra;
    double nTotHoras = 0.0;
    int nrobl = -1;
    double[] simDuration;
    double[] simDurationsen;
    double simDurationtot = 0.0;
    double sdur = 0.0;
    double[][] PLasAct;
    double[][] APLasAct;
    public double[][] PLas;
    int[][] FLas;
    double[] PLA3;
    double[][] PConLas;
    public double[][] PagoLas;
    public double[][] PagoLoad;
    boolean one = false;

    public TPGLDF(Schematic sch) {
        super(sch);
        this.sref = this.getSref();
        System.out.println("---------- In TPGLDF ------------");
        if (!this.existTPDB()) {
            return;
        }
        if (this.MyTPFrame == null) {
            this.MyTPFrame = new TPFrame(this, "TP GLDF Calculation Options");
        } else {
            this.MyTPFrame.setVisible(true);
        }
    }

    public TPGLDF(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, boolean ssisentido) {
        super(sch);
        this.sref = this.getSref();
        if (!this.existTPDB()) {
            return;
        }
        System.out.println("---------- In TPGLDF ------------ 1");
        this.Calculate(CTRLA, rep, vis, DBrep, Integer.parseInt(SDY), Integer.parseInt(SDM), Integer.parseInt(SDB), Integer.parseInt(SDH), Integer.parseInt(EDY), Integer.parseInt(EDM), Integer.parseInt(EDB), Integer.parseInt(EDH), HydroDB, ERep, ssisentido);
    }

    public TPGLDF(Schematic sch, boolean VisDB) {
        super(sch);
        this.sref = this.getSref();
        System.out.println("---------- In TPGLDF ------------ 2");
        if (!this.existTPDB()) {
            return;
        }
        this.InitAllNetwork();
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ssisentido) {
        int j;
        int i;
        this.sisentido = ssisentido;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPGLDF.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork();
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork();
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, HydroDB);
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("********************************");
            System.out.println(" DB Simulation Information");
            System.out.println("********************************");
            System.out.println(" ");
            System.out.println(" IntialYearDB  = " + this.InitialYearDB);
            System.out.println(" IntialMonthDB = " + this.InitialMonthDB);
            System.out.println(" FinalYearDB   = " + this.FinalYearDB);
            System.out.println(" FinalMonthDB  = " + this.FinalMonthDB);
            System.out.println(" ");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println(" DB Simulation Information");
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("  IntialYearDB  = " + this.InitialYearDB);
            this.myPPrintStream.println("  IntialMonthDB = " + this.InitialMonthDB);
            this.myPPrintStream.println("  FinalYearDB   = " + this.FinalYearDB);
            this.myPPrintStream.println("  FinalMonthDB  = " + this.FinalMonthDB);
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println("  ");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            for (int y = this.year1; y <= this.year2; ++y) {
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : 12;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int jj;
                    int ii;
                    System.out.println(" ");
                    System.out.println("-------------------------------");
                    System.out.println(" IN MONTH " + m + " CALCULATION");
                    System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                    System.out.println("-------------------------------");
                    if (this.Plan_Obra(y, m)) {
                        System.out.println(" Month " + m + " ESTA en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPGLDF.numformat(this.year1, 8) + "/" + TPGLDF.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPGLDF.numformat(this.year2, 8) + "/" + TPGLDF.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPGLDF.numformat(y, 8) + "/" + TPGLDF.numformat(m, 8));
                        this.ActSchematic.setactperiod(y);
                        this.ActSchematic.setactmonth(m);
                        this.ActSchematic.Modifiedstate = true;
                        this.ActSchematic.Modified = true;
                        this.ActSchematic.CheckActive();
                        System.out.println(" ");
                        System.out.println("Making GetActiveNetwork");
                        this.GetActiveNetwork();
                        System.out.println("GetActiveNetwork    Done");
                        System.out.println(" ");
                        if (this.MyDCLF != null) {
                            this.MyDCLF = null;
                        }
                        this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    } else {
                        System.out.println(" Month " + m + " NO esta en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPGLDF.numformat(this.year1, 8) + "/" + TPGLDF.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPGLDF.numformat(this.year2, 8) + "/" + TPGLDF.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPGLDF.numformat(y, 8) + "/" + TPGLDF.numformat(m, 8));
                    }
                    if (this.APLasAct != null) {
                        this.APLasAct = null;
                    }
                    this.APLasAct = new double[this.numactbran][this.numactnod];
                    if (this.AProrrateoAct != null) {
                        this.AProrrateoAct = null;
                    }
                    this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                    if (this.ALProrrateoAct != null) {
                        this.ALProrrateoAct = null;
                    }
                    this.ALProrrateoAct = new double[this.numactbran][this.numactload];
                    for (i = 0; i < this.numactbran; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.AProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactload; ++j) {
                            this.ALProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactlast; ++j) {
                            this.APLasAct[i][j] = 0.0;
                        }
                    }
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    this.nTotHoras = 0.0;
                    this.sdur = 0.0;
                    for (int b = limblock1; b <= limblock2; ++b) {
                        System.out.println(" ");
                        System.out.println("  ........................................");
                        System.out.println("   IN BLOCK " + b + " CALCULATION");
                        System.out.println("   Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                        System.out.print("  ");
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            if (y == this.year1 && m == this.month1 && this.nitera == 0) {
                                System.out.println("    This is the first seleted flow!");
                                System.out.println("      DCLF variables initialization ... ");
                                this.ActSchematic.setactperiod(y);
                                this.ActSchematic.setactmonth(m);
                                this.ActSchematic.Modifiedstate = true;
                                this.ActSchematic.Modified = true;
                                this.ActSchematic.CheckActive();
                                System.out.println(" ");
                                System.out.println("Making GetActiveNetwork");
                                this.GetActiveNetwork();
                                System.out.println("GetActiveNetwork    Done");
                                System.out.println(" ");
                                if (this.MyDCLF != null) {
                                    this.MyDCLF = null;
                                }
                                this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                                if (this.APLasAct != null) {
                                    this.APLasAct = null;
                                }
                                this.APLasAct = new double[this.numactbran][this.numactnod];
                                if (this.AProrrateoAct != null) {
                                    this.AProrrateoAct = null;
                                }
                                this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                                if (this.ALProrrateoAct != null) {
                                    this.ALProrrateoAct = null;
                                }
                                this.ALProrrateoAct = new double[this.numactbran][this.numactload];
                                for (i = 0; i < this.numactbran; ++i) {
                                    for (j = 0; j < this.numactnod; ++j) {
                                        this.AProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactload; ++j) {
                                        this.ALProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactlast; ++j) {
                                        this.APLasAct[i][j] = 0.0;
                                    }
                                }
                            }
                            System.out.print(".");
                            this.build_Injection(y, m, b, h, HydroDB);
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo);
                            if (this.one) {
                                this.MyDCLF.writeresults();
                            }
                            this.node_pl[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pl[n] = this.node_pl[n] + this.Flujo[i] * this.sref;
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pl[n] = this.node_pl[n] - this.Flujo[i] * this.sref;
                            }
                            this.node_pl[this.slackNode] = Math.abs(Math.min(0.0, this.node_pl[this.slackNode]));
                            this.build_GDF(this.Flujo, this.node_pl);
                            if (this.PLasAct != null) {
                                this.PLasAct = null;
                            }
                            this.PLasAct = new double[this.numactbran][this.numactnod];
                            if (this.ProrrateoAct != null) {
                                this.ProrrateoAct = null;
                            }
                            this.ProrrateoAct = new double[this.numactbran][this.numactnod];
                            if (this.LProrrateoAct != null) {
                                this.LProrrateoAct = null;
                            }
                            this.LProrrateoAct = new double[this.numactbran][this.numactload];
                            this.build_Participa(this.Flujo, this.node_pl);
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            this.simDurationtot += this.blockTime[this.nrobl - 1];
                            for (i = 0; i < this.numactbran; ++i) {
                                int k;
                                if (this.Flujo[i] < 0.0 && this.sisentido) {
                                    int n = i;
                                    this.simDurationsen[n] = this.simDurationsen[n] + this.blockTime[this.nrobl - 1];
                                }
                                for (j = 0; j < this.numactnod; ++j) {
                                    double[] dArray = this.AProrrateoAct[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.blockTime[this.nrobl - 1];
                                }
                                for (k = 0; k < this.numactload; ++k) {
                                    double[] dArray = this.ALProrrateoAct[i];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.LProrrateoAct[i][k];
                                }
                                for (k = 0; k < this.numactlast; ++k) {
                                    double[] dArray = this.APLasAct[i];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.PLasAct[i][k];
                                }
                            }
                            this.nTotHoras += this.blockTime[this.nrobl - 1];
                            ++this.nitera;
                        }
                        this.nrobl = this.BlockNumberDB * (m - 1) + b;
                        this.sdur += this.blockTime[this.nrobl - 1];
                    }
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Mensual de matrices de resumen ");
                    boolean kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        block24: for (jj = 0; jj < this.numactnod; ++jj) {
                            for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numallnod; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActNod[jj].equals(this.NomNod[j])) {
                                        int[] nArray = this.Frecuencia[i];
                                        int n = j;
                                        nArray[n] = (int)((double)nArray[n] + this.nTotHoras);
                                        double[] dArray = this.Prorrateo[i];
                                        int n2 = j;
                                        dArray[n2] = dArray[n2] + this.AProrrateoAct[ii][jj];
                                        kiebra = true;
                                        break;
                                    }
                                    kiebra = false;
                                }
                                if (kiebra) continue block24;
                            }
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        for (jj = 0; jj < this.numactload; ++jj) {
                            block29: for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numallload; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActLoad[jj].equals(this.NomLoad[j])) {
                                        if (this.nitera < 120) {
                                            int[] nArray = this.LFrecuencia[i];
                                            int n = j;
                                            nArray[n] = nArray[n] + this.nitera;
                                        } else {
                                            int[] nArray = this.LFrecuencia[i];
                                            int n = j;
                                            nArray[n] = nArray[n] + 120;
                                        }
                                        double[] dArray = this.LProrrateo[i];
                                        int n = j;
                                        dArray[n] = dArray[n] + this.ALProrrateoAct[ii][jj];
                                        kiebra = true;
                                        continue block29;
                                    }
                                    kiebra = false;
                                }
                            }
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        block32: for (jj = 0; jj < this.numactlast; ++jj) {
                            for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numalllast; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActLas[jj].equals(this.NomLas[j])) {
                                        int[] nArray = this.FLas[i];
                                        int n = j;
                                        nArray[n] = (int)((double)nArray[n] + this.nTotHoras);
                                        double[] dArray = this.PLas[i];
                                        int n3 = j;
                                        dArray[n3] = dArray[n3] + this.APLasAct[ii][jj];
                                        kiebra = true;
                                        break;
                                    }
                                    kiebra = false;
                                }
                                if (kiebra) continue block32;
                            }
                        }
                    }
                    block35: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii].equals(this.NomBra[i])) continue;
                            int n = i;
                            this.simDuration[n] = this.simDuration[n] + this.sdur;
                            continue block35;
                        }
                    }
                    System.out.println("   - Matrices actualizadas ");
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            System.out.println(" ");
            System.out.println("Construcci\u00f3n Prorrateo resumen");
            for (i = 0; i < this.numallbran; ++i) {
                this.PLA1[i] = 0.0;
                this.PLA2[i] = 0.0;
                this.PLA3[i] = 0.0;
                for (j = 0; j < this.numallnod; ++j) {
                    if (this.Frecuencia[i][j] <= 0) continue;
                    this.Prorrateo[i][j] = this.Prorrateo[i][j] / (double)this.Frecuencia[i][j];
                    int n = i;
                    this.PLA1[n] = this.PLA1[n] + this.Prorrateo[i][j];
                }
                for (j = 0; j < this.numallload; ++j) {
                    if (this.LFrecuencia[i][j] <= 0) continue;
                    this.LProrrateo[i][j] = this.LProrrateo[i][j] / (double)this.LFrecuencia[i][j];
                    int n = i;
                    this.PLA2[n] = this.PLA2[n] + this.LProrrateo[i][j];
                }
                for (j = 0; j < this.numalllast; ++j) {
                    if (this.FLas[i][j] <= 0) continue;
                    this.PLas[i][j] = this.PLas[i][j] / (double)this.FLas[i][j];
                    int n = i;
                    this.PLA3[n] = this.PLA3[n] + this.PLas[i][j];
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    if (!(Math.abs(this.PLA1[i]) > 0.01)) continue;
                    this.Prorrateo[i][j] = this.Prorrateo[i][j] / this.PLA1[i] * 100.0;
                }
                for (j = 0; j < this.numallload; ++j) {
                    if (!(Math.abs(this.PLA2[i]) > 0.01)) continue;
                    this.LProrrateo[i][j] = this.LProrrateo[i][j] / this.PLA2[i] * 100.0;
                }
                for (j = 0; j < this.numalllast; ++j) {
                    if (!(Math.abs(this.PLA3[i]) > 0.01)) continue;
                    this.PLas[i][j] = this.PLas[i][j] / this.PLA3[i] * 100.0;
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    this.PagoBarra[i][j] = this.one ? this.Prorrateo[i][j] / 100.0 * this.AVNR_COyM[i] : this.Prorrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numallload; ++j) {
                    this.PagoLoad[i][j] = this.one ? this.LProrrateo[i][j] / 100.0 * this.AVNR_COyM[i] : this.LProrrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numalllast; ++j) {
                    this.PagoLas[i][j] = this.one ? this.PLas[i][j] / 100.0 * this.AVNR_COyM[i] : this.PLas[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
            }
            System.out.println("Construcci\u00f3n Prorrateo resumen Ejecutada");
            if (rep) {
                System.out.println("Making Report File");
                System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Total Barras         : " + this.numallnod);
                this.myPPrintStream.println("Total Ramas          : " + this.numallbran);
                this.myPPrintStream.println("Total Generadores    : " + this.numallgen);
                this.myPPrintStream.println("Total Cargas         : " + this.numalllast);
                this.myPPrintStream.println("Total L\u00edneas         : " + this.numalllin);
                this.myPPrintStream.println("Total Transformadores: " + this.numalltrafo);
                this.myPPrintStream.println("Total Execution Time : " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Barra ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Barra             -             Prorrateo             -             Pago          -    % AVI+COMA-IT a considerar");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(Math.abs(this.Prorrateo[i][j]) > 1.0E-6)) continue;
                        if (this.sisentido) {
                            this.myPPrintStream.println(TPGLDF.strformat(this.NomBra[i], 40) + "  " + TPGLDF.strformat(this.NomNod[j], 30) + "  " + TPGLDF.numformat(this.Prorrateo[i][j], 15, 3) + "               " + TPGLDF.numformat(this.PagoBarra[i][j], 20, 0) + "               " + TPGLDF.numformat(this.simDurationsen[i] / this.simDurationtot * 100.0, 5, 1));
                            continue;
                        }
                        this.myPPrintStream.println(TPGLDF.strformat(this.NomBra[i], 40) + "  " + TPGLDF.strformat(this.NomNod[j], 30) + "  " + TPGLDF.numformat(this.Prorrateo[i][j], 15, 3) + "               " + TPGLDF.numformat(this.PagoBarra[i][j], 20, 0) + "               " + TPGLDF.numformat(100.0, 5, 1));
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("*************************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Consumos (Empresa) ");
                this.myPPrintStream.println("*************************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Barra             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallload; ++j) {
                        if (!(Math.abs(this.LProrrateo[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPGLDF.strformat(this.NomBra[i], 30) + "  " + TPGLDF.strformat(this.NomLoad[j], 30) + "  " + TPGLDF.numformat(this.LProrrateo[i][j], 15, 5) + "               " + this.PagoLoad[i][j]);
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Carga ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Carga             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numalllast; ++j) {
                        if (!(Math.abs(this.PLas[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPGLDF.strformat(this.NomBra[i], 30) + "  " + TPGLDF.strformat(this.NomLas[j], 30) + "  " + TPGLDF.numformat(this.PLas[i][j], 15, 5) + "               " + this.PagoLas[i][j]);
                    }
                }
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        if (DBrep) {
            try {
                System.out.println("-Saving TPResDB ... ");
                System.out.println(" Time = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                if (conTPResDB == null) {
                    return;
                }
                Statement s = conTPResDB.createStatement();
                s.executeUpdate("DELETE * FROM GLDF_Barra");
                s.executeUpdate("DELETE * FROM GLDF_Empresa");
                s.executeUpdate("DELETE * FROM GLDF_Carga");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(Math.abs(this.Prorrateo[i][j]) > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO GLDF_Barra (rama,barra,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomNod[j] + "'," + this.Prorrateo[i][j] + "," + this.PagoBarra[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallload; ++j) {
                        if (!(Math.abs(this.LProrrateo[i][j]) > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO GLDF_Empresa (rama,empresa,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomLoad[j] + "'," + this.LProrrateo[i][j] + "," + this.PagoLoad[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numalllast; ++j) {
                        if (!(Math.abs(this.PLas[i][j]) > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO GLDF_Carga (rama,carga,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomLas[j] + "'," + this.PLas[i][j] + "," + this.PagoLas[i][j] + ")");
                    }
                }
                System.out.println("");
                System.out.println("-TPResDB Saved ");
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Guardar Base de Datos " + e);
                e.printStackTrace();
            }
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = true;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        if (this.one) {
            this.ActSchematic.Modifiedstate = false;
        }
        System.out.println("TOTAL EXECUTION TIME = " + TPGLDF.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/TPGLDF.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
        if (vis) {
            if (this.MyTPGLDFVisualFrame == null) {
                this.MyTPGLDFVisualFrame = new TPGLDFVisualFrame(this, this.ctrla, false);
            } else {
                this.MyTPGLDFVisualFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("TPGLDF Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
        if (!vis) {
            this.finalize();
        }
    }

    public void InitAllNetwork() {
        int j;
        int i;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallload = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement(TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.LosLoad = new String[this.numalllast];
        this.PLA1 = new double[this.numallbran];
        this.PLA2 = new double[this.numallbran];
        this.PLA3 = new double[this.numallbran];
        this.AVNR_COyM = new double[this.numallbran];
        this.PagoBarra = new double[this.numallbran][this.numallnod];
        this.simDuration = new double[this.numallbran];
        this.simDurationsen = new double[this.numallbran];
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    this.AVNR_COyM[countBra] = TempLine.getannuity(this.ActSchematic.intrate);
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    this.AVNR_COyM[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate);
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            this.LosLoad[countLas] = TempLoad.getinv_owner();
            ++countLas;
        }
        int aux = 0;
        if (this.numalllast >= 2) {
            for (int i2 = 0; i2 < this.numalllast; ++i2) {
                aux = 0;
                for (int j2 = i2 + 1; j2 < this.numalllast; ++j2) {
                    if (!this.LosLoad[i2].equals(this.LosLoad[j2])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallload;
            }
        } else {
            this.numallload = this.numalllast;
        }
        this.LProrrateo = new double[this.numallbran][this.numallload];
        this.LFrecuencia = new int[this.numallbran][this.numallload];
        this.Prorrateo = new double[this.numallbran][this.numallnod];
        this.Frecuencia = new int[this.numallbran][this.numallnod];
        this.NomLoad = new String[this.numallload];
        this.PLas = new double[this.numallbran][this.numalllast];
        this.FLas = new int[this.numallbran][this.numalllast];
        this.PagoLas = new double[this.numallbran][this.numalllast];
        this.PagoLoad = new double[this.numallbran][this.numallload];
        aux = 0;
        int cmul = 0;
        if (this.numalllast >= 2) {
            for (i = 0; i < this.numalllast; ++i) {
                aux = 0;
                for (j = i + 1; j < this.numalllast; ++j) {
                    if (!this.LosLoad[i].equals(this.LosLoad[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomLoad[cmul] = this.LosLoad[i];
                ++cmul;
            }
        } else {
            this.NomLoad[0] = this.LosLoad[0];
        }
        for (i = 0; i < this.numallbran; ++i) {
            this.simDuration[i] = 0.0;
            this.simDurationsen[i] = 0.0;
            for (j = 0; j < this.numallnod; ++j) {
                this.Prorrateo[i][j] = 0.0;
                this.Frecuencia[i][j] = 0;
            }
            for (int jj = 0; jj < this.numallload; ++jj) {
                this.LProrrateo[i][jj] = 0.0;
                this.LFrecuencia[i][jj] = 0;
            }
            for (j = 0; j < this.numalllast; ++j) {
                this.PLas[i][j] = 0.0;
                this.FLas[i][j] = 0;
            }
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro, boolean HydroDBa) {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        String tempoName = "";
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
        this.PDCLF = new double[this.numactnod];
        for (i = 0; i < this.numactnod; ++i) {
            int k;
            this.PDCLF[i] = 0.0;
            this.node_pl[i] = 0.0;
            for (k = 0; k < this.numactload; ++k) {
                this.PConLoad[k][i] = 0.0;
            }
            for (k = 0; k < this.numactlast; ++k) {
                this.PConLas[k][i] = 0.0;
            }
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        int NroDdaActual = -1;
        int NroDdaActual2 = -1;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
            Generator TempGenerator = (Generator)TempComponent;
            for (i = 0; i < this.dimDBGen; ++i) {
                if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                int n = this.GenNode[countG];
                this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                this.TotGen += this.PDB[i];
                break;
            }
            ++countG;
        }
        if (this.directDx) {
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
                Load TempLoad = (Load)TempComponent;
                tempoName = TempLoad.getName().trim();
                if (this.ht_dem.containsKey(tempoName)) {
                    i = (Integer)this.ht_dem.get(tempoName);
                    NroDdaActual = (IdDespActual - this.flow1) / this.HydroNumberDB;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual] / this.sref;
                    this.TotDem += this.PLDB[i][NroDdaActual];
                }
                ++countL;
            }
        } else {
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                block15: {
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
                    Load TempLoad = (Load)TempComponent;
                    if (HydroDBa) {
                        NroDdaActual = this.BlockNumberDB * (mes - 1) + bloque;
                        for (i = 0; i < this.dimDBLoad; ++i) {
                            if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                            int n = this.LasNode[countL];
                            this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                            int n2 = this.LasNode[countL];
                            this.node_pl[n2] = this.node_pl[n2] + this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                            this.TotDem += this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                            double[] dArray = this.PConLas[countL];
                            int n3 = this.LasNode[countL];
                            dArray[n3] = dArray[n3] + this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                            for (int k = 0; k < this.numactload; ++k) {
                                if (!this.NomActLoad[k].equals(TempLoad.getinv_owner())) continue;
                                double[] dArray2 = this.PConLoad[k];
                                int n4 = this.LasNode[countL];
                                dArray2[n4] = dArray2[n4] + this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                                break block15;
                            }
                            break;
                        }
                    } else {
                        NroDdaActual2 = 12 * (ano - this.InitialYearDB) + mes;
                        for (i = 0; i < this.dimDBLoad2; ++i) {
                            if (!this.NameLDB2[i].equals(TempLoad.getName())) continue;
                            int n = this.LasNode[countL];
                            this.PDCLF[n] = this.PDCLF[n] - this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen / this.sref;
                            int n5 = this.LasNode[countL];
                            this.node_pl[n5] = this.node_pl[n5] + this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                            this.TotDem += this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                            double[] dArray = this.PConLas[countL];
                            int n6 = this.LasNode[countL];
                            dArray[n6] = dArray[n6] + this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                            break;
                        }
                    }
                }
                ++countL;
            }
        }
    }

    public void build_GDF(double[] flux, double[] pl) {
        int i = 0;
        int j = 0;
        double PLges = 0.0;
        double[] vec_DrefL = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            vec_DrefL[i] = 0.0;
        }
        for (i = 0; i < this.numactnod; ++i) {
            PLges += pl[i];
        }
        i = 0;
        while (i < this.numactbran) {
            vec_DrefL[i] = flux[i] * this.sref;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                vec_DrefL[n] = vec_DrefL[n] + this.GSDFS.getElement(i, j) * pl[j];
            }
            int n = i++;
            vec_DrefL[n] = vec_DrefL[n] / PLges;
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GLDF.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GLDF.setElement(i, j, -this.GSDFS.getElement(i, j) + vec_DrefL[i]);
            }
        }
    }

    public void build_Participa(double[] flux, double[] pl) {
        int k;
        int i = 0;
        int j = 0;
        double[][] GCDFCON = new double[this.numactbran][this.numactnod];
        double[][] ACON = new double[this.numactbran][this.numactnod];
        double[] PFAD = new double[this.numactbran];
        double[] PFGDFD = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            PFAD[i] = 0.0;
            PFGDFD[i] = 0.0;
            for (j = 0; j < this.numactnod; ++j) {
                ACON[i][j] = 0.0;
                GCDFCON[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                ACON[i][j] = this.node_pl[j] > 0.0 && this.GSDFS.getElement(i, j) * flux[i] < 0.0 ? (flux[i] > 0.0 && this.sisentido ? 0.0 : this.GSDFS.getElement(i, j)) : 0.0;
                if (this.node_pl[j] > 0.0 && this.GLDF.getElement(i, j) * flux[i] > 0.0) {
                    if (flux[i] > 0.0 && this.sisentido) {
                        GCDFCON[i][j] = 0.0;
                        continue;
                    }
                    GCDFCON[i][j] = this.GLDF.getElement(i, j);
                    continue;
                }
                GCDFCON[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                if (ACON[i][j] > 1.0) {
                    ACON[i][j] = 1.0;
                }
                if (ACON[i][j] < -1.0) {
                    ACON[i][j] = -1.0;
                }
                PFAD[i] = PFAD[i] - ACON[i][j] * pl[j];
                if (GCDFCON[i][j] > 1.0) {
                    GCDFCON[i][j] = 1.0;
                }
                if (GCDFCON[i][j] < -1.0) {
                    GCDFCON[i][j] = -1.0;
                }
                PFGDFD[i] = PFGDFD[i] + GCDFCON[i][j] * pl[j];
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = PFGDFD[i] > 1.0E-7 || PFGDFD[i] < -1.0E-7 ? Math.abs(GCDFCON[i][j] * pl[j] / PFGDFD[i] * 100.0) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactload; ++k) {
                this.LProrrateoAct[i][k] = 0.0;
            }
            for (k = 0; k < this.numactlast; ++k) {
                this.PLasAct[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                for (k = 0; k < this.numactload; ++k) {
                    if (!(pl[j] > 1.0E-6)) continue;
                    double[] dArray = this.LProrrateoAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PConLoad[k][j] / pl[j];
                }
                for (k = 0; k < this.numactlast; ++k) {
                    if (!(pl[j] > 1.0E-6)) continue;
                    double[] dArray = this.PLasAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PConLas[k][j] / pl[j];
                }
            }
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = 12;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = TempNdb_comp.getentry_period();
            m1 = TempNdb_comp.getentry_month();
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = nmes;
            int rano = nano;
            if (rmes == 1) {
                rmes = 12;
                --rano;
            } else if (rmes >= 2 && rmes <= 12) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork() {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactload = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pl = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActLoad = new String[this.numactlast];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pl[ixi] = 0.0;
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GLDF = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slackNode = slack = this.numbus(TempGenerator.getcon2());
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                this.LosActLoad[countLas] = TempLoad.getinv_owner();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactlast >= 2) {
            for (i = 0; i < this.numactlast; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactlast; ++j) {
                    if (!this.LosActLoad[i].equals(this.LosActLoad[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactload;
            }
        } else {
            this.numactload = this.numactlast;
        }
        this.PConLoad = new double[this.numactload][this.numactnod];
        this.NomActLoad = new String[this.numactload];
        this.PConLas = new double[this.numactlast][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactlast >= 2) {
            for (i = 0; i < this.numactlast; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactlast; ++j) {
                    if (!this.LosActLoad[i].equals(this.LosActLoad[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActLoad[mulina] = this.LosActLoad[i];
                ++mulina;
            }
        } else {
            this.NomActLoad[0] = this.LosActLoad[0];
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numactnod - 1; ++ii) {
            for (int jj = 0; jj < this.numactnod - 1; ++jj) {
                MatXX.setElement(ii, jj, MatY.getElement(ii, jj));
            }
        }
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        for (i = 0; i < this.numactnod - 1; ++i) {
            for (j = 0; j < this.numactnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numactnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slack));
                }
            }
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pl = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GLDF = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, int SDY, int SDM, int SDB, int SDH, int EDY, int EDM, int EDB, int EDH, boolean HydroDB, boolean ERep, boolean ssisentido) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, String CritSel, double percent, double umbral) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean ERep, String CritSel, double percent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

