/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPEstampillaFrame;
import de.core.TPEstampillaVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPEstampilla
extends AnalysisTool {
    TPEstampillaFrame MyTPEstampillaFrame = null;
    TPEstampillaVisualFrame MyTPEstampillaVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pg;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    int dimDBGen;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBLoad;
    int dimDBYear;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = 0;
    int numallowner = 0;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    double[] p_nod;
    double[] p_bran;
    double[] p_inj;
    double[] Ug;
    double[][] CB;
    double[][] D;
    DoubleSquareMatrix Au;
    DoubleSquareMatrix Bu;
    double[][] PagoBialek;
    double[] BiaFlux;
    double[] AcumFlows;
    double[] AnualFlows;
    int[] FreFlo;
    private double sref = this.getSref();

    public TPEstampilla(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPEstampilla ------------");
        if (this.MyTPEstampillaFrame == null) {
            this.MyTPEstampillaFrame = new TPEstampillaFrame(this);
        } else {
            this.MyTPEstampillaFrame.setVisible(true);
        }
    }

    public TPEstampilla(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String EDY, String EDM, String B, String H) {
        super(sch);
        System.out.println("---------- In TPEstampilla ------------ 1");
        this.Calculate(CTRLA, rep, vis, DBrep, SDY, SDM, EDY, EDM, B, H);
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String EDY, String EDM, String B, String H) {
        int i;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPEstampilla.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork();
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making FlowSelection");
            this.FlowSelection(SDY, SDM, EDY, EDM, B, H);
            System.out.println("FlowSelection           Done");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork();
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDatabase();
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            int FY = this.ny1;
            int LY = this.ny2;
            int FM = this.nm1;
            int LM = this.nm2;
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            this.nitera = 0;
            for (int y = FY; y <= LY; ++y) {
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == FY ? FM : 1;
                int limmes2 = y == LY ? LM : 12;
                for (int m = limmes1; m <= limmes2; ++m) {
                    System.out.println(" ");
                    System.out.println("-------------------------------");
                    System.out.println(" IN MONTH " + m + " CALCULATION");
                    System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                    System.out.println("-------------------------------");
                    if (this.Plan_Obra(y, m) && m != limmes1) {
                        System.out.println(" Month " + m + " ESTA en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPEstampilla.numformat(this.year1, 8) + "/" + TPEstampilla.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPEstampilla.numformat(this.year2, 8) + "/" + TPEstampilla.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPEstampilla.numformat(this.RealYear(y, m), 8) + "/" + TPEstampilla.numformat(this.RealMonth(m), 8));
                        this.ActSchematic.setactperiod(this.RealYear(y, m));
                        this.ActSchematic.setactmonth(this.RealMonth(m));
                        this.ActSchematic.Modifiedstate = true;
                        this.ActSchematic.Modified = true;
                        this.ActSchematic.CheckActive();
                        System.out.println(" ");
                        System.out.println("Making GetActiveNetwork");
                        this.GetActiveNetwork();
                        System.out.println("GetActiveNetwork    Done");
                        System.out.println(" ");
                        if (this.MyDCLF != null) {
                            this.MyDCLF = null;
                        }
                        this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    } else {
                        System.out.println(" Month " + m + " NO esta en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPEstampilla.numformat(this.year1, 8) + "/" + TPEstampilla.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPEstampilla.numformat(this.year2, 8) + "/" + TPEstampilla.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPEstampilla.numformat(this.RealYear(y, m), 8) + "/" + TPEstampilla.numformat(this.RealMonth(m), 8));
                    }
                    if (this.AProrrateoAct != null) {
                        this.AProrrateoAct = null;
                    }
                    this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                    if (this.AOProrrateoAct != null) {
                        this.AOProrrateoAct = null;
                    }
                    this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                    for (int b = 1; b <= this.block; ++b) {
                        System.out.println(" ");
                        System.out.println("  ........................................");
                        System.out.println("   IN BLOCK " + b + " CALCULATION");
                        System.out.println("   Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                        System.out.print("  ");
                        for (int h = 1; h <= this.hidro; ++h) {
                            System.out.print(".");
                            this.build_Injection(y, m, b, h);
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo);
                            if (this.ProrrateoAct != null) {
                                this.ProrrateoAct = null;
                            }
                            this.ProrrateoAct = new double[this.numactbran][this.numactnod];
                            if (this.OProrrateoAct != null) {
                                this.OProrrateoAct = null;
                            }
                            this.OProrrateoAct = new double[this.numactbran][this.numactowner];
                            if (this.PagoBialek != null) {
                                this.PagoBialek = null;
                            }
                            this.PagoBialek = new double[this.numactbran][this.numactnod];
                            for (i = 0; i < this.numactbran; ++i) {
                                int n = i;
                                this.AcumFlows[n] = this.AcumFlows[n] + this.Flujo[i];
                            }
                            ++this.nitera;
                        }
                    }
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Anual de flujos promedio");
                    boolean kiebra = false;
                    block11: for (int ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (this.NomActBra[ii].equals(this.NomBra[i])) {
                                int n = i;
                                this.AnualFlows[n] = this.AnualFlows[n] + this.AcumFlows[ii];
                                int n2 = i;
                                this.FreFlo[n2] = this.FreFlo[n2] + 1;
                                kiebra = true;
                                continue block11;
                            }
                            kiebra = false;
                            if (kiebra) continue block11;
                        }
                    }
                    System.out.println("   - Matrices actualizadas ");
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            System.out.println(" ");
            System.out.println("Construcci\u00f3n Flujos Promedio Anuales");
            for (i = 0; i < this.numallbran; ++i) {
                if (this.FreFlo[i] <= 0) continue;
                this.AnualFlows[i] = this.AnualFlows[i] / (double)this.FreFlo[i];
            }
            System.out.println("Construcci\u00f3n Flujos Medios Ended");
            if (rep) {
                System.out.println("Making Report File");
                System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Flujos medios anuales");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Nombre Rama    -    Flujo");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numallbran; ++i) {
                    this.myPPrintStream.println(this.NomBra[i] + "    -    " + this.AnualFlows[i]);
                }
                this.myPPrintStream.println(" ");
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        if (DBrep) {
            try {
                int j;
                System.out.println("-Saving TPResDB ... ");
                System.out.println(" Time = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                Statement s = conTPResDB.createStatement();
                s.executeUpdate("DELETE * FROM Estampilla_Barra");
                s.executeUpdate("DELETE * FROM Estampilla_Empresa");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (this.Prorrateo[i][j] == 0.0) continue;
                        s.executeUpdate("INSERT INTO Estampilla_Barra (rama,barra,prorrata) VALUES ('" + this.NomBra[i] + "','" + this.NomNod[j] + "'," + this.Prorrateo[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (this.OProrrateo[i][j] == 0.0) continue;
                        s.executeUpdate("INSERT INTO Estampilla_Empresa (rama,empresa,prorrata) VALUES ('" + this.NomBra[i] + "','" + this.NomOwner[j] + "'," + this.OProrrateo[i][j] + ")");
                    }
                }
                System.out.println("");
                System.out.println("-TPResDB Saved ");
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Guardar Base de Datos " + e);
                e.printStackTrace();
            }
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = true;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        System.out.println("TOTAL EXECUTION TIME = " + TPEstampilla.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/TPEstampilla.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
        if (vis) {
            if (this.MyTPEstampillaVisualFrame == null) {
                this.MyTPEstampillaVisualFrame = new TPEstampillaVisualFrame(this, this.ctrla);
            } else {
                this.MyTPEstampillaVisualFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("TPEstampilla Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
        if (!vis) {
            this.finalize();
        }
    }

    public void InitAllNetwork() {
        int i;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement(TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.LosOwner = new String[this.numallgen];
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                this.LosOwner[countGen] = TempGenerator.getinv_owner();
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            ++countLas;
        }
        int aux = 0;
        if (this.numallgen >= 2) {
            for (int i2 = 0; i2 < this.numallgen; ++i2) {
                aux = 0;
                for (int j = i2 + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i2].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallowner;
            }
        } else {
            this.numallowner = this.numallgen;
        }
        this.OProrrateo = new double[this.numallbran][this.numallowner];
        this.OFrecuencia = new int[this.numallbran][this.numallowner];
        this.Prorrateo = new double[this.numallbran][this.numallnod];
        this.Frecuencia = new int[this.numallbran][this.numallnod];
        this.NomOwner = new String[this.numallowner];
        this.AnualFlows = new double[this.numallbran];
        this.FreFlo = new int[this.numallbran];
        aux = 0;
        int cmul = 0;
        if (this.numallgen >= 2) {
            for (i = 0; i < this.numallgen; ++i) {
                aux = 0;
                for (int j = i + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomOwner[cmul] = this.LosOwner[i];
                ++cmul;
            }
        } else {
            this.NomOwner[0] = this.LosOwner[0];
        }
        for (i = 0; i < this.numallbran; ++i) {
            this.AnualFlows[i] = 0.0;
            this.FreFlo[i] = 0;
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro) {
        int k;
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        int IdDespActual = 1440 * (ano - 1) + 120 * (mes - 1) + 40 * (bloque - 1) + hidro;
        this.PDCLF = new double[this.numactnod];
        for (i = 0; i < this.numactnod; ++i) {
            this.PDCLF[i] = 0.0;
            this.node_pg[i] = 0.0;
            this.p_inj[i] = 0.0;
            this.p_nod[i] = 0.0;
            for (k = 0; k < this.numactowner; ++k) {
                this.PGenOwn[k][i] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            this.p_bran[i] = 0.0;
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                block4: for (i = 0; i < this.dimDBGen; ++i) {
                    if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                    int n = this.GenNode[countG];
                    this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                    int n2 = this.GenNode[countG];
                    this.node_pg[n2] = this.node_pg[n2] + this.PDB[i];
                    int n3 = this.GenNode[countG];
                    this.p_inj[n3] = this.p_inj[n3] + this.PDB[i];
                    this.TotGen += this.PDB[i];
                    for (k = 0; k < this.numactowner; ++k) {
                        if (!this.NomActOwner[k].equals(TempGenerator.getinv_owner())) continue;
                        double[] dArray = this.PGenOwn[k];
                        int n4 = this.GenNode[countG];
                        dArray[n4] = dArray[n4] + this.PDB[i];
                        break block4;
                    }
                    break;
                }
                ++countG;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            int NroDdaActual = 3 * (mes - 1) + bloque;
            for (i = 0; i < this.dimDBLoad; ++i) {
                if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                int n = this.LasNode[countL];
                this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - 1][NroDdaActual - 1] / this.sref;
                this.TotDem += this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - 1][NroDdaActual - 1];
                break;
            }
            ++countL;
        }
    }

    public void FlowSelection(String SDYa, String SDMa, String EDYa, String EDMa, String Ba, String Ha) {
        String[] mes = new String[]{"NADA", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre", "Enero", "Febrero", "Marzo"};
        this.year1 = Integer.parseInt(SDYa);
        this.year2 = Integer.parseInt(EDYa);
        for (int i = 1; i <= 12; ++i) {
            if (mes[i].equals(SDMa)) {
                this.nm1 = i;
            }
            if (!mes[i].equals(EDMa)) continue;
            this.nm2 = i;
        }
        if (this.year1 == 203) {
            this.ny1 = 1;
        } else if (this.year1 == 304) {
            this.ny1 = 2;
        } else if (this.year1 == 405) {
            this.ny1 = 3;
        } else if (this.year1 == 506) {
            this.ny1 = 4;
        } else if (this.year1 == 607) {
            this.ny1 = 5;
        }
        if (this.year2 == 203) {
            this.ny2 = 1;
        } else if (this.year2 == 304) {
            this.ny2 = 2;
        } else if (this.year2 == 405) {
            this.ny2 = 3;
        } else if (this.year2 == 506) {
            this.ny2 = 4;
        } else if (this.year2 == 607) {
            this.ny2 = 5;
        }
        this.year1 = this.RealYear(this.ny1, this.nm1);
        this.year2 = this.RealYear(this.ny2, this.nm2);
        this.month1 = this.RealMonth(this.nm1);
        this.month2 = this.RealMonth(this.nm2);
        this.block = Integer.parseInt(Ba);
        this.hidro = Integer.parseInt(Ha);
        this.flow1 = 1440 * (this.ny1 - 1) + 120 * (this.nm1 - 1) + 0 + 1;
        this.flow2 = 1440 * (this.ny2 - 1) + 120 * (this.nm2 - 1) + 40 * (this.block - 1) + this.hidro;
        if (this.flow2 < this.flow1) {
            System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
            int mulanga = this.flow2;
            this.flow2 = this.flow1;
            this.flow1 = mulanga;
            System.out.println(" ........ Problema resuelto autom\u00e1ticamente");
        }
        System.out.println(" ");
        System.out.println("Flow Selection Details");
        System.out.println("----------------------");
        System.out.println("Total flows  :    7200");
        System.out.println("Total years  :    5");
        System.out.println("Total Blocks :    " + this.block);
        System.out.println("Total Hidros :    " + this.hidro);
        System.out.println("Flujo        :    YEAR/   MONTH/    FLOW");
        System.out.println("Inicio       :" + TPEstampilla.numformat(this.year1, 8) + "/" + TPEstampilla.numformat(this.month1, 8) + "/" + TPEstampilla.numformat(this.flow1, 8));
        System.out.println("Final        :" + TPEstampilla.numformat(this.year2, 8) + "/" + TPEstampilla.numformat(this.month2, 8) + "/" + TPEstampilla.numformat(this.flow2, 8));
        System.out.println(" ");
    }

    public void GetDatabase() {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
            i = 0;
            while (r2.next()) {
                ++i;
            }
            this.dimDBLoad = i;
            this.NameLDB = new String[this.dimDBLoad];
            this.PLDB = new double[this.dimDBLoad][36];
            for (i = 0; i < this.dimDBLoad; ++i) {
                this.NameLDB[i] = "nada";
                for (j = 1; j <= 36; ++j) {
                    this.PLDB[i][j - 1] = 123456.0;
                }
            }
            r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
            i = 0;
            while (r2.next()) {
                this.NameLDB[i] = r2.getString("name");
                for (j = 1; j <= 36; ++j) {
                    this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                }
                ++i;
            }
            ResultSet r3 = s.executeQuery("SELECT HidroYear\tFROM loadPower   ORDER BY HidroYear");
            i = 0;
            while (r3.next()) {
                ++i;
            }
            this.dimDBYear = i;
            this.TotDemDB = new double[this.dimDBYear][36];
            this.HidYearNameLDB = new int[this.dimDBYear];
            for (i = 0; i < this.dimDBYear; ++i) {
                this.HidYearNameLDB[i] = 1;
                for (j = 1; j <= 36; ++j) {
                    this.TotDemDB[i][j - 1] = 123456.0;
                }
            }
            r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY HidroYear");
            i = 0;
            while (r3.next()) {
                this.HidYearNameLDB[i] = r3.getInt("HidroYear");
                for (j = 1; j <= 36; ++j) {
                    this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                }
                ++i;
            }
            s.close();
            conTPDB.rollback();
            conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = 12;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = this.NumYear(TempNdb_comp.getentry_period(), TempNdb_comp.getentry_month());
            m1 = this.NumMonth(TempNdb_comp.getentry_month());
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = this.RealMonth(nmes);
            int rano = this.RealYear(nano, nmes);
            if (rmes == 1) {
                rmes = 12;
                --rano;
            } else if (rmes >= 2 && rmes <= 12) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork() {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numacttrafo;
                }
                ++this.numactbran;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.Flujo != null || this.GenNode != null || this.LasNode != null || this.p_nod != null || this.p_bran != null || this.p_inj != null || this.D != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.Flujo = null;
            this.GenNode = null;
            this.LasNode = null;
            this.p_nod = null;
            this.p_bran = null;
            this.p_inj = null;
            this.D = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.p_nod = new double[this.numactnod];
        this.p_bran = new double[this.numactbran];
        this.p_inj = new double[this.numactnod];
        this.D = new double[this.numactbran][this.numactnod];
        this.AcumFlows = new double[this.numactbran];
        if (this.Au != null) {
            this.Au = null;
        }
        if (this.Bu != null) {
            this.Bu = null;
        }
        this.Au = new DoubleSquareMatrix(this.numactnod);
        this.Bu = new DoubleSquareMatrix(this.numactnod);
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
            for (int colu = 0; colu < this.numactnod; ++colu) {
                this.MatX.setElement(ixi, colu, 0.0);
                MatY.setElement(ixi, colu, 0.0);
            }
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
            this.AcumFlows[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slackNode = slack = this.numbus(TempGenerator.getcon2());
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                }
                ++count1;
                ++countGen;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
    }

    public void build_Estampilla(double[] flux) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (j = 0; j < this.numactbran; ++j) {
            this.p_bran[j] = flux[j] * flux[j] < 1.0E-4 ? 0.001 : flux[j] * 100.0;
        }
        for (i = 0; i < this.numactnod; ++i) {
            this.p_nod[i] = i == this.slackNode ? Math.max(0.0, this.p_inj[i]) : this.p_inj[i];
            for (j = 0; j < this.numactbran; ++j) {
                if (this.p_bran[j] < 0.0 && this.BranchI[j] == i) {
                    int n = i;
                    this.p_nod[n] = this.p_nod[n] + Math.abs(this.p_bran[j]);
                    continue;
                }
                if (this.p_bran[j] > 0.0 && this.BranchJ[j] == i) {
                    int n = i;
                    this.p_nod[n] = this.p_nod[n] + Math.abs(this.p_bran[j]);
                    continue;
                }
                if (this.p_bran[j] != 0.0) continue;
                int n = i;
                this.p_nod[n] = this.p_nod[n] + 0.0;
            }
        }
        for (i = 0; i < this.numactnod; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.Au.setElement(i, j, 0.0);
                this.Bu.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numactnod; ++i) {
            for (j = 0; j < this.numactbran; ++j) {
                if (this.p_bran[j] < 0.0 && this.BranchI[j] == i) {
                    this.Au.setElement(i, this.BranchI[j], 1.0);
                    if (this.p_nod[this.BranchJ[j]] == 0.0) continue;
                    this.Au.setElement(i, this.BranchJ[j], this.Au.getElement(i, this.BranchJ[j]) - Math.abs(this.p_bran[j]) / this.p_nod[this.BranchJ[j]]);
                    continue;
                }
                if (this.p_bran[j] > 0.0 && this.BranchJ[j] == i) {
                    this.Au.setElement(i, this.BranchJ[j], 1.0);
                    if (this.p_nod[this.BranchI[j]] == 0.0) continue;
                    this.Au.setElement(i, this.BranchI[j], this.Au.getElement(i, this.BranchI[j]) - Math.abs(this.p_bran[j]) / this.p_nod[this.BranchI[j]]);
                    continue;
                }
                if (this.p_bran[j] < 0.0 && this.BranchJ[j] == i) {
                    this.Au.setElement(i, this.BranchJ[j], 1.0);
                    continue;
                }
                if (this.p_bran[j] > 0.0 && this.BranchI[j] == i) {
                    this.Au.setElement(i, this.BranchI[j], 1.0);
                    continue;
                }
                if (this.p_bran[j] == 0.0 && this.BranchJ[j] == i) {
                    this.Au.setElement(i, this.BranchJ[j], 1.0);
                    continue;
                }
                if (this.p_bran[j] != 0.0 || this.BranchI[j] != i) continue;
                this.Au.setElement(i, this.BranchI[j], 1.0);
            }
        }
        this.Bu = (DoubleSquareMatrix)this.Au.inverse();
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactnod; ++k) {
                this.D[i][k] = this.p_nod[this.BranchI[i]] != 0.0 ? this.Bu.getElement(this.BranchI[i], k) * Math.abs(this.p_bran[i]) / this.p_nod[this.BranchI[i]] : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.PagoBialek[i][j] = this.D[i][j] * this.p_inj[j] / Math.abs(this.p_bran[i]) * 100.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactowner; ++k) {
                this.OProrrateoAct[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactowner; ++k) {
                for (j = 0; j < this.numactnod; ++j) {
                    if (this.p_inj[j] == 0.0) continue;
                    double[] dArray = this.OProrrateoAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.PagoBialek[i][j] * this.PGenOwn[k][j] / this.p_inj[j];
                }
            }
        }
        if (this.BiaFlux != null) {
            this.BiaFlux = null;
        }
        this.BiaFlux = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            this.BiaFlux[i] = 0.0;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                this.BiaFlux[n] = this.BiaFlux[n] + this.D[i][j] * this.p_inj[j];
            }
        }
    }

    public int RealYear(int nroyear, int nromes) {
        if (nroyear == 1) {
            if (nromes >= 1 && nromes <= 9) {
                return 2002;
            }
            if (nromes >= 10 && nromes <= 12) {
                return 2003;
            }
        } else if (nroyear == 2) {
            if (nromes >= 1 && nromes <= 9) {
                return 2003;
            }
            if (nromes >= 10 && nromes <= 12) {
                return 2004;
            }
        } else if (nroyear == 3) {
            if (nromes >= 1 && nromes <= 9) {
                return 2004;
            }
            if (nromes >= 10 && nromes <= 12) {
                return 2005;
            }
        } else if (nroyear == 4) {
            if (nromes >= 1 && nromes <= 9) {
                return 2005;
            }
            if (nromes >= 10 && nromes <= 12) {
                return 2006;
            }
        } else if (nroyear == 5) {
            if (nromes >= 1 && nromes <= 9) {
                return 2006;
            }
            if (nromes >= 10 && nromes <= 12) {
                return 2007;
            }
        }
        System.out.println("Some problems in RealYear");
        return -1;
    }

    public int RealMonth(int nromes) {
        if (nromes == 1) {
            return 4;
        }
        if (nromes == 2) {
            return 5;
        }
        if (nromes == 3) {
            return 6;
        }
        if (nromes == 4) {
            return 7;
        }
        if (nromes == 5) {
            return 8;
        }
        if (nromes == 6) {
            return 9;
        }
        if (nromes == 7) {
            return 10;
        }
        if (nromes == 8) {
            return 11;
        }
        if (nromes == 9) {
            return 12;
        }
        if (nromes == 10) {
            return 1;
        }
        if (nromes == 11) {
            return 2;
        }
        if (nromes == 12) {
            return 3;
        }
        System.out.println("Some problems in RealMonth");
        return -1;
    }

    public int NumMonth(int nmes) {
        if (nmes == 1) {
            return 10;
        }
        if (nmes == 2) {
            return 11;
        }
        if (nmes == 3) {
            return 12;
        }
        if (nmes == 4) {
            return 1;
        }
        if (nmes == 5) {
            return 2;
        }
        if (nmes == 6) {
            return 3;
        }
        if (nmes == 7) {
            return 4;
        }
        if (nmes == 8) {
            return 5;
        }
        if (nmes == 9) {
            return 6;
        }
        if (nmes == 10) {
            return 7;
        }
        if (nmes == 11) {
            return 8;
        }
        if (nmes == 12) {
            return 9;
        }
        System.out.println("Some problems in NumMonth");
        return -1;
    }

    public int NumYear(int nyear, int nmes) {
        if (nyear == 2002) {
            if (nmes < 4) {
                return -1;
            }
            if (nmes >= 4 && nmes <= 12) {
                return 1;
            }
        } else if (nyear == 2003) {
            if (nmes >= 1 && nmes <= 3) {
                return 1;
            }
            if (nmes >= 4 && nmes <= 12) {
                return 2;
            }
        } else if (nyear == 2004) {
            if (nmes >= 1 && nmes <= 3) {
                return 2;
            }
            if (nmes >= 4 && nmes <= 12) {
                return 3;
            }
        } else if (nyear == 2005) {
            if (nmes >= 1 && nmes <= 3) {
                return 3;
            }
            if (nmes >= 4 && nmes <= 12) {
                return 4;
            }
        } else if (nyear == 2006) {
            if (nmes >= 1 && nmes <= 3) {
                return 4;
            }
            if (nmes >= 4 && nmes <= 12) {
                return 5;
            }
        } else if (nyear == 2007) {
            if (nmes >= 1 && nmes <= 3) {
                return 5;
            }
            if (nmes >= 4) {
                return -1;
            }
        }
        return -1;
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }
}

