/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.TPDBData;
import de.core.blockTime;
import de.core.hydroInfo;
import de.core.plexosPeriodID;
import de.core.plpManLiData;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import de.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;

public class TPDBProcessor
implements Runnable {
    private static JFileChooser jFileChooser;
    public static final String INPUT_DATE_FORMAT = "dd/MM/yyyy";
    public static final int SIMULATION_ID = 1;
    public static final String PAR_VATT = "vatt";
    public static final String PAR_FLOW_P = "flow";
    public static final String PAR_GEN_P = "gen_p";
    public static final String PAR_LOAD_P = "load_p";
    public static final String PAR_GEN_Q = "gen_q";
    public static final String PAR_LOAD_Q = "load_q";
    public static final String PAR_CMG_P = "cmg";
    public static final String PAR_MAX_FLOW_P = "maxflow_p";
    public static final String PAR_MIN_FLOW_P = "minflow_p";
    public static final String PAR_INSERVICE = "units";
    public static final int PLP_FIRST_HYDROSAMPLE = 0;
    public static final int PCP_FIRST_HYDROSAMPLE = 0;
    public static final int PLEXOS_FIRST_HYDROSAMPLE = 0;
    public static final int DETERMINISTIC_SAMPLE = 0;
    public static final String CASE_PLP = "PLP";
    public static final String CASE_PCP = "PCP";
    public static final String CASE_PLEXOS_ST = "PLEXOS_ST";
    public static final String qryALLVALUES_TBDB_T_H = "SELECT objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject  WHERE ((resultName=? AND blockTime.BlockNumber=? AND dispatchInfo.hydroID=?) AND (((objectInfo.objectName) Not Like 'FALLA_*')))";
    public static final String qryALLVALUES_TPDB = "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ";
    public static final String qryALLVALUES_TPDB_ACCESS = "qryGetAllvalues";
    private String nSelectedCase = "PLEXOS_ST";
    private String strPLPInputFolder;
    private String strPLPOutputFolder;
    private String strDBConnection;

    protected static void load(Connection con) {
        block29: {
            String[] token = null;
            Pattern p = Pattern.compile(",");
            int hMax = 52;
            try {
                if (con == null) {
                    System.out.println("TPDB connection not reached.");
                    return;
                }
                jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                int returnVal = jFileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    int h;
                    String lineText;
                    double d;
                    int k;
                    String line;
                    Statement s = con.createStatement();
                    File f = new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separator + "etapas.csv");
                    if (!f.exists()) {
                        System.out.println("Definici\u00f3n de etapas no encontrado (etapas.csv).");
                        return;
                    }
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    if (!br.readLine().contains("#Numero, Nombre, Tipo, Anno, Mes, Duracion, FactEner, PctjMes")) {
                        System.out.println("Archivo de etapas no es v\u00e1lido.");
                        return;
                    }
                    int j = 0;
                    ArrayList<ArrayList> pesos = new ArrayList<ArrayList>();
                    ArrayList temp = null;
                    while ((line = br.readLine()) != null) {
                        token = p.split(line);
                        k = Integer.parseInt(token[4].trim());
                        if (j != k) {
                            if (j != 0) {
                                pesos.add(temp);
                            }
                            j = k;
                            temp = new ArrayList();
                            temp.add(Double.parseDouble(token[5].trim()));
                            continue;
                        }
                        temp.add(Double.parseDouble(token[5].trim()));
                    }
                    pesos.add(temp);
                    int i = Integer.parseInt(token[0].trim());
                    int[] indexM = new int[i];
                    int[] indexB = new int[i];
                    double[] hMes = new double[pesos.size()];
                    i = 0;
                    for (j = 0; j < pesos.size(); ++j) {
                        d = 0.0;
                        temp = (ArrayList)pesos.get(j);
                        k = 0;
                        while (k < temp.size()) {
                            d += ((Double)temp.get(k)).doubleValue();
                            indexB[i] = k++;
                            indexM[i] = j;
                            ++i;
                        }
                        hMes[j] = d;
                        lineText = "UPDATE blockTime SET d" + (j + 1) + "=" + d;
                        s.executeUpdate(lineText);
                    }
                    f = new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separator + "simuls.csv");
                    if (!f.exists()) {
                        System.out.println("Definici\u00f3n de etapas no encontrado (simuls.csv).");
                        return;
                    }
                    br = new BufferedReader(new FileReader(f));
                    if (!br.readLine().contains("#Numero, Nombre")) {
                        System.out.println("Archivo de series hidrol\u00f3gicas no es v\u00e1lido.");
                        return;
                    }
                    while ((line = br.readLine()) != null) {
                        token = p.split(line);
                    }
                    br.close();
                    hMax = Integer.parseInt(token[0].trim());
                    s.executeUpdate("DELETE FROM SimInfo");
                    try {
                        line = jFileChooser.getSelectedFile().getName();
                        j = line.indexOf("201");
                        line = line.substring(j, j + 6);
                        h = Integer.parseInt(line.substring(0, 4));
                        k = Integer.parseInt(line.substring(4));
                    }
                    catch (Exception asaa) {
                        System.out.println("Carpeta sin informaci\u00f3n sobre fecha. Se establece inicio en 2013/01.");
                        h = 2013;
                        k = 1;
                    }
                    i = hMes.length;
                    lineText = "INSERT INTO SimInfo VALUES (" + h + "," + k + "," + i / 12 + "," + i % 12 + "," + 1 + "," + hMax + ")";
                    s.executeUpdate(lineText);
                    con.commit();
                    f = new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separator + "plpbar.csv");
                    if (!f.exists()) {
                        System.out.println("Definici\u00f3n de demandas no encontrado (plpbar.csv).");
                        return;
                    }
                    br = new BufferedReader(new FileReader(f));
                    if (!br.readLine().contains("Hidro,Etapa,TipoEtapa,BarNum,BarNom,CMgBar,DemBarP,DemBarE,PerBarP,PerBarE,BarRetP,BarRetE")) {
                        System.out.println("Archivo de demandas no es v\u00e1lido.");
                        return;
                    }
                    s.executeUpdate("DELETE FROM demand");
                    con.commit();
                    k = 0;
                    d = 0.0;
                    String aux = "";
                    while ((line = br.readLine()) != null && (token = p.split(line))[0].contains(" 1")) {
                        i = Integer.parseInt(token[1].trim()) - 1;
                        if (indexM[i] != k && d != 0.0) {
                            h = i == 0 ? indexM.length - 1 : i - 1;
                            j = hMax * indexM[h] + 1;
                            lineText = "INSERT INTO demand VALUES ('" + aux + "'," + j + "," + d / hMes[indexM[h]] + ")";
                            s.executeUpdate(lineText);
                            d = 0.0;
                        }
                        d += Double.parseDouble(token[6].trim()) * (Double)((ArrayList)pesos.get(indexM[i])).get(indexB[i]);
                        k = indexM[i];
                        aux = token[4].trim();
                    }
                    if (d != 0.0) {
                        j = hMax * indexM[i] + 1;
                        lineText = "INSERT INTO demand VALUES ('" + aux + "'," + j + "," + d / hMes[indexM[i]] + ")";
                        s.executeUpdate(lineText);
                    }
                    con.commit();
                    f = new File(jFileChooser.getSelectedFile().getAbsolutePath() + File.separator + "plpcen.csv");
                    if (!f.exists()) {
                        System.out.println("Definici\u00f3n de generaci\u00f3n no encontrado (plpcen.csv).");
                        return;
                    }
                    br = new BufferedReader(new FileReader(f));
                    if (!br.readLine().contains("Hidro,Etapa,TipoEtapa,CenNum,CenNom,CenTip,CenBar,BarNom,CenQgen,CenPgen,CenEgen,CenInyP,CenInyE")) {
                        System.out.println("Archivo de generaci\u00f3n no es v\u00e1lido.");
                        return;
                    }
                    s.executeUpdate("DELETE FROM generator");
                    con.commit();
                    k = 0;
                    d = 0.0;
                    aux = "";
                    while ((line = br.readLine()) != null) {
                        token = p.split(line);
                        if (token[0].contains("MEDIA")) {
                            h = hMax;
                        } else {
                            line = token[0].substring(token[0].indexOf(" ")).trim();
                            h = Integer.parseInt(line);
                            if (h % 15 == 0) {
                                con.commit();
                            }
                        }
                        i = Integer.parseInt(token[1].trim()) - 1;
                        if (indexM[i] != k && d != 0.0) {
                            j = i == 0 ? indexM.length - 1 : i - 1;
                            lineText = "INSERT INTO generator VALUES ('" + aux + "'," + (hMax * indexM[j] + h) + "," + d / hMes[indexM[j]] + ")";
                            s.executeUpdate(lineText);
                            d = 0.0;
                        }
                        d += Double.parseDouble(token[9].trim()) * (Double)((ArrayList)pesos.get(indexM[i])).get(indexB[i]);
                        k = indexM[i];
                        aux = token[4].trim();
                    }
                    if (d != 0.0) {
                        j = hMax * indexM[i] + h;
                        lineText = "INSERT INTO generator VALUES ('" + aux + "'," + j + "," + d / hMes[indexM[i]] + ")";
                        s.executeUpdate(lineText);
                    }
                    con.commit();
                    br.close();
                    System.out.println("Base de datos guardada con \u00e9xito.");
                    con.close();
                    break block29;
                }
                System.out.println("Operaci\u00f3n abortada por el usuario.");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TPDBProcessor(String conn, String inputFolder, String outputFolder, String nSelectedCase) {
        this.strDBConnection = conn;
        this.strPLPInputFolder = inputFolder;
        this.strPLPOutputFolder = outputFolder;
        this.nSelectedCase = nSelectedCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatchFileDataToDatabase(String DataBaseName, String inputPath, String outputPath, String nSelectedCase) {
        TPDBData oData;
        long startTime;
        long lastTime = startTime = System.currentTimeMillis();
        if (inputPath == null || outputPath == null || DataBaseName == null) {
            System.out.println("No valid input or output folder specify. Please specify a correct folder and try again");
            return;
        }
        System.out.println("Reading " + nSelectedCase + " input files. Please wait...");
        if (nSelectedCase.equals(CASE_PLP)) {
            oData = TPDBProcessor.readPLPData(inputPath, outputPath);
        } else if (nSelectedCase.equals(CASE_PLEXOS_ST)) {
            oData = TPDBProcessor.readPLEXOSData(outputPath, inputPath);
        } else if (nSelectedCase.equals(CASE_PCP)) {
            oData = TPDBProcessor.readPCPData(inputPath, outputPath);
        } else {
            assert (false) : "Why you introduced an invalid nSelectedCase entry: " + nSelectedCase;
            oData = null;
        }
        if (oData == null) {
            System.out.println("Reading " + nSelectedCase + " files process interrupted...");
            System.out.println("TPDB database has NOT been updated!");
            return;
        }
        long elapsed = System.currentTimeMillis() - lastTime;
        lastTime = System.currentTimeMillis();
        System.out.println("Finished reading data in files. Time: " + elapsed / 1000L + " [seg]");
        Connection conn = DeepEdit.OpenJDBCConnection(DataBaseName, false);
        System.out.println("Deleting previous data from TPDB. Please wait...");
        try {
            TPDBProcessor.clearAllTPDB(conn);
        }
        catch (SQLException e) {
            System.out.println("Error deleting data from TPDB database: " + e.getMessage());
            e.printStackTrace(System.out);
            DeepEdit.CloseJDBCConnection(conn);
            return;
        }
        elapsed = System.currentTimeMillis() - lastTime;
        lastTime = System.currentTimeMillis();
        System.out.println("Finished deleting previous data in TPDB database. Time: " + elapsed / 1000L + " [seg]");
        System.out.println("Storing values into TPDB database. Please wait this process may take up to 15 minutes...");
        try {
            TPDBProcessor.SaveTPDBDatabase(conn, oData);
        }
        catch (SQLException e) {
            System.out.println("Error storing data to database: " + e.getMessage());
            e.printStackTrace(System.out);
            return;
        }
        finally {
            DeepEdit.CloseJDBCConnection(conn);
        }
        elapsed = System.currentTimeMillis() - lastTime;
        System.out.println("Finished storing data into TPDB database. Time: " + elapsed / 1000L + " [seg]");
        System.out.println("Process finished successfully! Total records: " + oData.data.size());
        System.out.println("Total time: " + (System.currentTimeMillis() - startTime) / 1000L + " [seg]");
    }

    protected static TPDBData readPLPData(String inputFolder, String outputFolder) {
        TPDBData oData = new TPDBData();
        File f = null;
        Pattern p = Pattern.compile(",");
        int nLine = 1;
        java.util.Date inDate = Utils.getExternalDate(INPUT_DATE_FORMAT);
        if (inDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(inDate);
        int nYear = cal.get(1);
        int nMonth = cal.get(2) + 1;
        int nDay = cal.get(5);
        try {
            String[] opoint;
            String currentObject;
            String strHydro;
            int nHydroID;
            int nBlockNumber;
            String[] token;
            String line;
            f = new File(outputFolder + File.separator + "etapas.csv");
            if (!f.exists()) {
                System.out.println("LDC definition file (etapas.csv) not found");
                return null;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("#Numero, Nombre, Tipo, Anno, Mes, Duracion, FactEner, PctjMes")) {
                System.out.println("LDC definition file (etapas.csv) is not valid");
                return null;
            }
            int nBlockCount = 0;
            nLine = 2;
            while ((line = br.readLine()) != null) {
                token = p.split(line);
                nBlockNumber = Integer.parseInt(token[0].trim());
                String strNombre = token[1];
                double nDuracion = Double.parseDouble(token[5].trim());
                assert (nBlockCount == nBlockNumber - 1) : "This is going to crash the TA. Why the periods are not consecutive in etapas.csv? Check etapas line " + nLine;
                oData.addblockTime(nBlockCount, strNombre, nDuracion, "Hours", null);
                ++nLine;
                ++nBlockCount;
            }
            br.close();
            f = new File(outputFolder + File.separator + "simuls.csv");
            if (!f.exists()) {
                System.out.println("Hydro sample file (simuls.csv) not found");
                return null;
            }
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("#Numero, Nombre")) {
                System.out.println("Hydro sample file (simuls.csv) is not valid");
                return null;
            }
            int nHydroCount = 0;
            nLine = 2;
            while ((line = br.readLine()) != null) {
                token = p.split(line);
                nHydroID = Integer.parseInt(token[0].trim());
                String strDescription = token[1].trim();
                assert (nHydroCount == nHydroID - 1) : "This is going to crash the TA. Why the hydro samples are not consecutive in simuls.csv? Check simuls.csv line " + nLine;
                oData.addhydroInfo(nHydroCount, strDescription);
                ++nLine;
                ++nHydroCount;
            }
            br.close();
            System.out.println("Finished reading PLP hydro-info file simuls.csv");
            oData.addSimInfo(1, nYear, nMonth, nDay, 1, 1, nBlockCount, nHydroCount, CASE_PLP, " ");
            for (hydroInfo hydroInfo2 : oData.hydroInfo) {
                for (blockTime blockTime2 : oData.blockTime) {
                    nHydroID = hydroInfo2.hydroID;
                    nBlockNumber = blockTime2.BlockNumber;
                    oData.adddispatchInfo(nBlockNumber, nHydroID, 1);
                }
            }
            f = new File(outputFolder + File.separator + "plpbar.csv");
            if (!f.exists()) {
                System.out.println("PLP busbar file (plpbar.csv) not found");
                return null;
            }
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("Hidro,Etapa,TipoEtapa,BarNum,BarNom,CMgBar,DemBarP,DemBarE,PerBarP,PerBarE,BarRetP,BarRetE")) {
                System.out.println("PLP busbar file (plpbar.csv) is not valid");
                return null;
            }
            nLine = 2;
            while ((line = br.readLine()) != null && (token = p.split(line))[0].contains("Sim ")) {
                int nBlock = Integer.parseInt(token[1].trim()) - 1;
                strHydro = token[0].replaceAll("Sim ", "");
                int nHydro = Integer.parseInt(strHydro.trim()) - 1;
                currentObject = token[4].trim();
                double dCmg = Double.parseDouble(token[5].trim());
                double dLoad = Double.parseDouble(token[6].trim());
                if (oData.getObjectID(currentObject, PAR_LOAD_P) == TPDBData.VALUE_NOT_FOUND) {
                    oData.addobjectInfo(currentObject, PAR_LOAD_P, "");
                }
                if (oData.getObjectID(currentObject, PAR_CMG_P) == TPDBData.VALUE_NOT_FOUND) {
                    oData.addobjectInfo(currentObject, PAR_CMG_P, "");
                }
                if (nHydro == 0) {
                    oData.adddata(currentObject, PAR_LOAD_P, nHydro, nBlock, dLoad);
                }
                oData.adddata(currentObject, PAR_CMG_P, nHydro, nBlock, dCmg);
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PLP busbar file plpbar.csv");
            f = new File(outputFolder + File.separator + "plpcen.csv");
            if (!f.exists()) {
                System.out.println("PLP generation solution file (plpcen.csv) not found");
                return null;
            }
            nLine = 2;
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("Hidro,Etapa,TipoEtapa,CenNum,CenNom,CenTip,CenBar,BarNom,CenQgen,CenPgen,CenEgen,CenInyP,CenInyE")) {
                System.out.println("PLP generation solution file (plpcen.csv) is not valid");
                return null;
            }
            while ((line = br.readLine()) != null && (token = p.split(line))[0].contains("Sim ")) {
                int nBlock = Integer.parseInt(token[1].trim()) - 1;
                strHydro = token[0].replaceAll("Sim ", "");
                int nHydro = Integer.parseInt(strHydro.trim()) - 1;
                currentObject = token[4].trim();
                double dCenPgen = Double.parseDouble(token[9].trim());
                if (oData.getObjectID(currentObject, PAR_GEN_P) == TPDBData.VALUE_NOT_FOUND) {
                    oData.addobjectInfo(currentObject, PAR_GEN_P, "");
                }
                oData.adddata(currentObject, PAR_GEN_P, nHydro, nBlock, dCenPgen);
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PLP generation solution file plpcen.csv");
            f = new File(outputFolder + File.separator + "plplin.csv");
            if (!f.exists()) {
                System.out.println("PLP line's flow solution file (plplin.csv) not found");
                return null;
            }
            nLine = 2;
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("Hidro,Etapa,TipoEtapa,LinNum,LinNom,BarA,BarB,LinFluP,LinFluE,LinPerP,LinPerE,LinPer2P,LinPer2E,LinITP,LinITE")) {
                System.out.println("PLP line's flow solution file (plplin.csv) not found");
                return null;
            }
            while ((line = br.readLine()) != null && (token = p.split(line))[0].contains("Sim ")) {
                int nBlock = Integer.parseInt(token[1].trim()) - 1;
                strHydro = token[0].replaceAll("Sim ", "");
                int nHydro = Integer.parseInt(strHydro.trim()) - 1;
                currentObject = token[4].trim();
                double LinFluP = Double.parseDouble(token[7].trim());
                if (oData.getObjectID(currentObject, PAR_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                    oData.addobjectInfo(currentObject, PAR_FLOW_P, "");
                    oData.addobjectInfo(currentObject, PAR_MIN_FLOW_P, "");
                    oData.addobjectInfo(currentObject, PAR_MAX_FLOW_P, "");
                    oData.addobjectInfo(currentObject, PAR_VATT, "");
                }
                oData.adddata(currentObject, PAR_FLOW_P, nHydro, nBlock, LinFluP);
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PLP line's flow solution file plplin.csv");
            f = new File(inputFolder + File.separator + "plpcnfli.dat");
            if (!f.exists()) {
                System.out.println("Transmission line data input file not found: plpcnfli.dat");
                return null;
            }
            nLine = 2;
            br = new BufferedReader(new FileReader(f));
            int n_lineas = 1;
            int cont_lineas = 1;
            int cont = 1;
            ArrayList<String> lLineNames = new ArrayList<String>();
            HashMap<String, Double> lFmax = new HashMap<String, Double>();
            HashMap<String, Double> lFmin = new HashMap<String, Double>();
            while ((line = br.readLine()) != null & cont_lineas <= n_lineas) {
                if (cont == 3) {
                    opoint = StringUtil.SplitLineWhitespace(line);
                    n_lineas = Integer.parseInt(opoint[0]);
                }
                if (cont > 5) {
                    String[] line_aux = line.split("'");
                    opoint = StringUtil.SplitLineWhitespace(line_aux[2]);
                    String nombre = line_aux[1];
                    double fmaxAB = Double.parseDouble(opoint[0]);
                    double fmaxBA = Double.parseDouble(opoint[1]) * -1.0;
                    double dUnits = 1.0;
                    String operativa = opoint[9];
                    if (operativa.trim().equals("T")) {
                        dUnits = 1.0;
                    } else if (operativa.trim().equals("F")) {
                        dUnits = 0.0;
                    } else assert (false) : "Is this a supported file. Couldnt cast value " + operativa + " in line " + cont;
                    lLineNames.add(nombre);
                    lFmax.put(nombre, fmaxAB * dUnits);
                    lFmin.put(nombre, fmaxBA * dUnits);
                    ++cont_lineas;
                }
                ++cont;
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PLP line's input file plpcnfli.dat");
            f = new File(inputFolder + File.separator + "plpmanli.dat");
            if (!f.exists()) {
                System.out.println("Line maintenance input file not found: plpmanli.dat");
                return null;
            }
            nLine = 1;
            int currentStage = 0;
            int nextLineName = 0;
            int nextStageLine = 0;
            int nextDataLine = 0;
            int nStages = 0;
            String strNameLine = "";
            ArrayList<plpManLiData> lManLi = new ArrayList<plpManLiData>();
            br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                opoint = StringUtil.SplitLineWhitespace(line);
                if (nLine == 3) {
                    nextLineName = nLine + 2;
                }
                if (nLine == nextLineName) {
                    currentStage = 1;
                    strNameLine = opoint[0].replaceAll("'", "");
                    nextStageLine = nLine + 2;
                }
                if (nLine == nextStageLine) {
                    nStages = Integer.parseInt(opoint[0]);
                    nextLineName = nLine + nStages + 3;
                    nextDataLine = nStages == 0 ? nextLineName + 4 : nLine + 2;
                }
                if (nLine == nextDataLine) {
                    int stage = Integer.parseInt(opoint[0]);
                    double PotMaxAB = Double.parseDouble(opoint[1]);
                    double PotMaxBA = Double.parseDouble(opoint[2]);
                    lManLi.add(new plpManLiData(strNameLine, stage, PotMaxAB, PotMaxBA));
                    if (currentStage < nStages) {
                        ++currentStage;
                        ++nextDataLine;
                    } else {
                        nextDataLine = nLine + 6;
                    }
                }
                ++nLine;
            }
            System.out.println("Finished reading PLP Line maintenance input file solution file plpmanli.dat");
            for (String strCurrentLineName : lLineNames) {
                for (int t = 0; t < nBlockCount; ++t) {
                    double dFlowMaxBase = (Double)lFmax.get(strCurrentLineName);
                    double dFlowMinBase = (Double)lFmin.get(strCurrentLineName);
                    for (plpManLiData olindata : lManLi) {
                        if (!olindata.Name.equals(strCurrentLineName) || olindata.NumeroEtapa != t + 1) continue;
                        dFlowMaxBase = olindata.PotMaxAB;
                        dFlowMinBase = olindata.PotMaxAB;
                    }
                    oData.adddata(strCurrentLineName, PAR_MAX_FLOW_P, 0, t, dFlowMaxBase);
                    oData.adddata(strCurrentLineName, PAR_MIN_FLOW_P, 0, t, dFlowMinBase);
                }
            }
            return oData;
        }
        catch (IOException e) {
            if (f != null) {
                System.out.println("Error reading file: " + f.getAbsolutePath());
                System.out.println("Last line succesfully read: " + nLine);
            }
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
            return null;
        }
        catch (NumberFormatException e) {
            if (f != null) {
                System.out.println("Error parsing numeric value from file: " + f.getAbsolutePath());
                System.out.println("Last line succesfully read: " + nLine);
            }
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
            return null;
        }
    }

    protected static TPDBData readPCPData(String inputFolder, String outputFolder) {
        TPDBData oData = new TPDBData();
        File f = null;
        Pattern p = Pattern.compile(",");
        int nLine = 1;
        java.util.Date inDate = Utils.getExternalDate(INPUT_DATE_FORMAT);
        if (inDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(inDate);
        int nYear = cal.get(1);
        int nMonth = cal.get(2) + 1;
        int nDay = cal.get(5);
        try {
            int nDuration;
            String currentObject;
            int nCurrentHour;
            int nCurrentDay;
            String[] token;
            String line;
            f = new File(inputFolder + File.separator + "pcpeta.dat");
            if (!f.exists()) {
                System.out.println("LDC block definition file not found (pcpeta.dat)");
                return null;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            nLine = 1;
            int n_etapas = 1;
            int nBlockCount = 0;
            while ((line = br.readLine()) != null & nBlockCount <= n_etapas) {
                if (nLine == 3) {
                    token = StringUtil.SplitLineWhitespace(line);
                    n_etapas = Integer.valueOf(token[0]);
                }
                if (nLine >= 5) {
                    token = StringUtil.SplitLineWhitespace(line);
                    String strBlockName = token[2].trim();
                    double nDuracion = Double.parseDouble(token[4].trim());
                    oData.addblockTime(nBlockCount, strBlockName, nDuracion, "Hours", null);
                    ++nBlockCount;
                }
                ++nLine;
            }
            br.close();
            oData.addSimInfo(1, nYear, nMonth, nDay, 1, 1, nBlockCount, 1, CASE_PCP, " ");
            oData.addhydroInfo(0, "Deterministic");
            for (int nBlock = 0; nBlock < oData.blockTime.size(); ++nBlock) {
                int nBlockNumber = oData.blockTime.get((int)nBlock).BlockNumber;
                oData.adddispatchInfo(nBlockNumber, 0, 1);
            }
            f = new File(outputFolder + File.separator + "pcpbar.csv");
            if (!f.exists()) {
                System.out.println("Busbar result file not found (pcpbar.csv).");
                return null;
            }
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("DiaD,HoraH,BarNum,BarNom,CMgBar,DemBar,PerBar")) {
                System.out.println("Busbar result file format not supported");
                return null;
            }
            nLine = 2;
            int nTotalHours = 0;
            int nBlock = 0;
            int nextLine = 2;
            while ((line = br.readLine()) != null && nBlock < n_etapas) {
                if (nLine == nextLine) {
                    token = p.split(line);
                    nCurrentDay = Integer.parseInt(token[0].trim());
                    nCurrentHour = Integer.parseInt(token[1].trim());
                    nTotalHours = (nCurrentDay - 1) * 24 + nCurrentHour;
                    currentObject = token[3].trim();
                    double dCmg = Double.parseDouble(token[4].trim());
                    double dLoad = Double.parseDouble(token[5].trim());
                    nBlock = oData.getBlockNumber(nTotalHours);
                    if (nBlock == TPDBData.VALUE_NOT_FOUND) {
                        System.out.println("Warning: Line " + nLine + " contains an invalid block number (unknown 'etapa') " + nCurrentHour);
                        System.out.println("Execution interrupted...");
                        return null;
                    }
                    nDuration = (int)oData.blockTime.get((int)nBlock).duration;
                    nextLine += nDuration;
                    if (oData.getObjectID(currentObject, PAR_LOAD_P) == TPDBData.VALUE_NOT_FOUND) {
                        oData.addobjectInfo(currentObject, PAR_LOAD_P, "");
                    }
                    if (oData.getObjectID(currentObject, PAR_CMG_P) == TPDBData.VALUE_NOT_FOUND) {
                        oData.addobjectInfo(currentObject, PAR_CMG_P, "");
                    }
                    oData.adddata(currentObject, PAR_LOAD_P, 0, nBlock, dLoad);
                    oData.adddata(currentObject, PAR_CMG_P, 0, nBlock, dCmg);
                }
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PCP busbar file pcpbar.csv");
            f = new File(outputFolder + File.separator + "pcpcen.csv");
            if (!f.exists()) {
                System.out.println("Generation result file not found (pcpcen.csv).");
                return null;
            }
            nLine = 2;
            nTotalHours = 0;
            nBlock = 0;
            nextLine = 2;
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("DiaD,HoraH,CenNum,CenNom,CenTip,CenBar,BarNom,CenQgen,CenPgen")) {
                System.out.println("Generation result file format not supported");
                return null;
            }
            while ((line = br.readLine()) != null && nBlock < n_etapas) {
                if (nLine == nextLine) {
                    token = p.split(line);
                    nCurrentDay = Integer.parseInt(token[0].trim());
                    nCurrentHour = Integer.parseInt(token[1].trim());
                    nTotalHours = (nCurrentDay - 1) * 24 + nCurrentHour;
                    currentObject = token[3].trim();
                    double dPGen = Double.parseDouble(token[8].trim());
                    nBlock = oData.getBlockNumber(nTotalHours);
                    if (nBlock == TPDBData.VALUE_NOT_FOUND) {
                        System.out.println("Warning: Line " + nLine + " contains an invalid block number (unknown 'etapa') " + nCurrentHour);
                        System.out.println("Execution interrupted...");
                        return null;
                    }
                    nDuration = (int)oData.blockTime.get((int)nBlock).duration;
                    nextLine += nDuration;
                    if (oData.getObjectID(currentObject, PAR_GEN_P) == TPDBData.VALUE_NOT_FOUND) {
                        oData.addobjectInfo(currentObject, PAR_GEN_P, "");
                    }
                    oData.adddata(currentObject, PAR_GEN_P, 0, nBlock, dPGen);
                }
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PCP generation solution file pcpcen.csv");
            f = new File(inputFolder + File.separator + "pcpcnfli.dat");
            if (!f.exists()) {
                System.out.println("Transmission line data input file not found: pcpcnfli.csv).");
                return null;
            }
            nLine = 2;
            br = new BufferedReader(new FileReader(f));
            int n_lineas = 1;
            int cont_lineas = 1;
            int cont = 1;
            ArrayList<String> lLineNames = new ArrayList<String>();
            HashMap<String, Double> lFmax = new HashMap<String, Double>();
            HashMap<String, Double> lFmin = new HashMap<String, Double>();
            while ((line = br.readLine()) != null & cont_lineas <= n_lineas) {
                String[] opoint;
                if (cont == 3) {
                    opoint = StringUtil.SplitLineWhitespace(line);
                    n_lineas = Integer.parseInt(opoint[0]);
                }
                if (cont > 5) {
                    String[] line_aux = line.split("'");
                    opoint = StringUtil.SplitLineWhitespace(line_aux[2]);
                    String nombre = line_aux[1];
                    double fmaxAB = Double.parseDouble(opoint[0]);
                    double fmaxBA = Double.parseDouble(opoint[1]) * -1.0;
                    double dUnits = 1.0;
                    String operativa = opoint[9];
                    if (operativa.trim().equals("T")) {
                        dUnits = 1.0;
                    } else if (operativa.trim().equals("F")) {
                        dUnits = 0.0;
                    } else assert (false) : "Is this a supported file. Couldnt cast value " + operativa + " in line " + cont;
                    lLineNames.add(nombre);
                    lFmax.put(nombre, fmaxAB * dUnits);
                    lFmin.put(nombre, fmaxBA * dUnits);
                    ++cont_lineas;
                }
                ++cont;
                ++nLine;
            }
            br.close();
            f = new File(inputFolder + File.separator + "pcpmanli.dat");
            if (!f.exists()) {
                System.out.println("Line maintenance input file not found: pcpmanli.csv).");
                return null;
            }
            nLine = 1;
            int currentStage = 0;
            int nextLineName = 0;
            int nextStageLine = 0;
            int nextDataLine = 0;
            int nStages = 0;
            String strNameLine = "";
            ArrayList<plpManLiData> lManLi = new ArrayList<plpManLiData>();
            br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                String[] opoint = StringUtil.SplitLineWhitespace(line);
                if (nLine == 3) {
                    nextLineName = nLine + 2;
                }
                if (nLine == nextLineName) {
                    currentStage = 1;
                    strNameLine = opoint[0].replaceAll("'", "");
                    nextStageLine = nLine + 2;
                }
                if (nLine == nextStageLine) {
                    nStages = Integer.parseInt(opoint[0]);
                    nextLineName = nLine + nStages + 3;
                    nextDataLine = nLine + 2;
                }
                if (nLine == nextDataLine) {
                    int stage = Integer.parseInt(opoint[0]);
                    double PotMaxAB = Double.parseDouble(opoint[1]);
                    double PotMaxBA = Double.parseDouble(opoint[2]);
                    lManLi.add(new plpManLiData(strNameLine, stage, PotMaxAB, PotMaxBA));
                    if (currentStage < nStages) {
                        ++currentStage;
                        ++nextDataLine;
                    } else {
                        nextDataLine = nLine + 6;
                    }
                }
                ++nLine;
            }
            for (String strCurrentLineName : lLineNames) {
                if (oData.getObjectID(strCurrentLineName, PAR_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                    oData.addobjectInfo(strCurrentLineName, PAR_FLOW_P, "");
                    oData.addobjectInfo(strCurrentLineName, PAR_MIN_FLOW_P, "");
                    oData.addobjectInfo(strCurrentLineName, PAR_MAX_FLOW_P, "");
                }
                for (int s = 0; s < nBlockCount; ++s) {
                    double dFlowMaxBase = (Double)lFmax.get(strCurrentLineName);
                    double dFlowMinBase = (Double)lFmin.get(strCurrentLineName);
                    for (plpManLiData olindata : lManLi) {
                        if (!olindata.Name.equals(strCurrentLineName) || olindata.NumeroEtapa != s + 1) continue;
                        dFlowMaxBase = olindata.PotMaxAB;
                        dFlowMinBase = olindata.PotMaxAB;
                    }
                    oData.adddata(strCurrentLineName, PAR_MAX_FLOW_P, 0, s, dFlowMaxBase);
                    oData.adddata(strCurrentLineName, PAR_MIN_FLOW_P, 0, s, dFlowMinBase);
                }
            }
            f = new File(outputFolder + File.separator + "pcplin.csv");
            if (!f.exists()) {
                System.out.println("Line flow result file not found (pcplin.csv).");
                return null;
            }
            nLine = 2;
            nTotalHours = 0;
            nBlock = 0;
            nextLine = 2;
            br = new BufferedReader(new FileReader(f));
            if (!br.readLine().contains("DiaD,HoraH,LinNum,LinNom,BarA,BarB,LinFlu,LinPer,LinPer2,LinIT_UM")) {
                System.out.println("Line flow result file format not supported");
                return null;
            }
            while ((line = br.readLine()) != null && nBlock < n_etapas) {
                if (nLine == nextLine) {
                    token = p.split(line);
                    int nCurrentDay2 = Integer.parseInt(token[0].trim());
                    int nCurrentHour2 = Integer.parseInt(token[1].trim());
                    nTotalHours = (nCurrentDay2 - 1) * 24 + nCurrentHour2;
                    String currentObject2 = token[3].trim();
                    double dFlow = Double.parseDouble(token[6].trim());
                    nBlock = oData.getBlockNumber(nTotalHours);
                    if (nBlock == TPDBData.VALUE_NOT_FOUND) {
                        System.out.println("Warning: Line " + nLine + " contains an invalid block number (unknown 'etapa') " + nCurrentHour2);
                        System.out.println("Execution interrupted...");
                        return null;
                    }
                    nDuration = (int)oData.blockTime.get((int)nBlock).duration;
                    nextLine += nDuration;
                    if (oData.getObjectID(currentObject2 = TPDBProcessor.getNonTruncatedName(lLineNames, currentObject2), PAR_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                        oData.addobjectInfo(currentObject2, PAR_FLOW_P, "");
                    }
                    oData.adddata(currentObject2, PAR_FLOW_P, 0, nBlock, dFlow);
                }
                ++nLine;
            }
            br.close();
            System.out.println("Finished reading PCP line's flow solution file pcplin.csv");
            return oData;
        }
        catch (IOException e) {
            if (f != null) {
                System.out.println("Error reading file: " + f.getAbsolutePath());
                System.out.println("Last line succesfully read: " + nLine);
            }
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
            return null;
        }
        catch (NumberFormatException e) {
            if (f != null) {
                System.out.println("Error parsing numeric value from file: " + f.getAbsolutePath());
                System.out.println("Last line succesfully read: " + nLine);
            }
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TPDBData readPLEXOSData(String outputDatabasePath, String inputPath) {
        int nPeriod_id;
        int nInterval;
        double dValue;
        String strProperty;
        String strCollection;
        String strObjectName;
        ResultSet rs;
        int nDay;
        int nMonth;
        int nYear;
        Statement stmt;
        java.util.Date iniDate = Calendar.getInstance().getTime();
        ArrayList ldatatime = new ArrayList();
        ArrayList<plexosPeriodID> lperiod_id = new ArrayList<plexosPeriodID>();
        Calendar cal = Calendar.getInstance();
        File f = new File(outputDatabasePath);
        if (!f.isFile()) {
            outputDatabasePath = outputDatabasePath + File.separator + "Model CDEC-BASE Solution.mdb";
        }
        TPDBData oData = new TPDBData();
        Connection conn = DeepEdit.OpenODBC_JDBCConnection(outputDatabasePath, false);
        if (conn == null) {
            return null;
        }
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            System.out.println("Unexpected error creating statement. Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
            return null;
        }
        int nMaxInterval_0 = 0;
        double nDuration = 0.0;
        double nPreviousHour = 0.0;
        int nBlockCount = 0;
        ArrayList<Timestamp> lDispatchDates = new ArrayList<Timestamp>();
        ArrayList<Integer> lIntervalId = new ArrayList<Integer>();
        ArrayList lDuration = new ArrayList();
        String strQuery = "SELECT Max(t_data_0.period_id) FROM t_data_0";
        try {
            ResultSet rs2 = stmt.executeQuery(strQuery);
            if (rs2.next()) {
                nMaxInterval_0 = rs2.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("Error retrieving the number of periods in database");
            System.out.println("Database: " + outputDatabasePath);
            System.out.println("SQL Exception: " + e.getMessage());
            DeepEdit.CloseJDBCConnection(conn);
            return null;
        }
        strQuery = "SELECT * FROM t_period_0";
        try {
            ResultSet rs2 = stmt.executeQuery(strQuery);
            while (rs2.next()) {
                nYear = rs2.getInt("year");
                nMonth = rs2.getInt("month_of_year");
                nDay = rs2.getInt("day_of_month");
                int nInterval2 = rs2.getInt("interval_id");
                int nCurrentHour = rs2.getInt("hour_id");
                int nPeriodOfDay = rs2.getInt("period_of_day");
                int nHourOfDay = rs2.getInt("hour_of_day");
                Timestamp curDate = rs2.getTimestamp("datetime");
                lDispatchDates.add(curDate);
                lIntervalId.add(nPeriodOfDay);
                if (nBlockCount == 0) {
                    iniDate = curDate;
                    nDuration = nCurrentHour;
                } else {
                    nDuration = (double)nCurrentHour - nPreviousHour;
                }
                lperiod_id.add(new plexosPeriodID(nYear, nMonth, nDay, nHourOfDay, nPeriodOfDay, nBlockCount, nDuration));
                oData.addblockTime(nBlockCount, Integer.toString(nInterval2), nDuration, "Hours", curDate);
                nPreviousHour = nCurrentHour;
                ++nBlockCount;
            }
        }
        catch (SQLException e) {
            System.out.println("Error querying t_period_0 table. Error reading line " + (nBlockCount + 1));
            System.out.println("Database: " + outputDatabasePath);
            System.out.println("SQL Exception: " + e.getMessage());
            DeepEdit.CloseJDBCConnection(conn);
            return null;
        }
        int nIniYear = 0;
        int nYears = 0;
        if (lDispatchDates.size() > 0) {
            Calendar cIniDate = Calendar.getInstance();
            Calendar cEndDate = Calendar.getInstance();
            cIniDate.setTime(iniDate);
            cEndDate.setTime((java.util.Date)lDispatchDates.get(lDispatchDates.size() - 1));
            nIniYear = cIniDate.get(1);
            nYears = cEndDate.get(1) - nIniYear + 1;
        }
        int[][][][] date_HourToPeriodId = new int[nYears][12][31][24];
        int[][][][] date_IntervalToPeriodId = new int[nYears][12][31][24];
        int nPeriodId = 0;
        int MILLI_TO_HOUR = 3600000;
        long nHoursDiff = 1L;
        Calendar cActDate = Calendar.getInstance();
        for (java.util.Date date : lDispatchDates) {
            cActDate.setTime(date);
            nYear = cActDate.get(1) - nIniYear;
            nMonth = cActDate.get(2);
            nDay = cActDate.get(5) - 1;
            int nHour = cActDate.get(11);
            date_HourToPeriodId[nYear][nMonth][nDay][nHour] = nPeriodId;
            date_IntervalToPeriodId[nYear][nMonth][nDay][((Integer)lIntervalId.get((int)nPeriodId)).intValue() - 1] = nPeriodId;
            if (nPeriodId < lDispatchDates.size() - 1) {
                nHoursDiff = (((java.util.Date)lDispatchDates.get(nPeriodId + 1)).getTime() - ((java.util.Date)lDispatchDates.get(nPeriodId)).getTime()) / 3600000L;
            }
            int i = 1;
            while ((long)i < nHoursDiff) {
                cActDate.add(11, 1);
                nYear = cActDate.get(1) - nIniYear;
                nMonth = cActDate.get(2);
                nDay = cActDate.get(5) - 1;
                nHour = cActDate.get(11);
                date_HourToPeriodId[nYear][nMonth][nDay][nHour] = nPeriodId;
                ++i;
            }
            ++nPeriodId;
        }
        oData.addhydroInfo(0, "Deterministic");
        cal.setTime(iniDate);
        int nInitialYear = cal.get(1);
        int n = cal.get(2) + 1;
        int nInitialDay = cal.get(5);
        int nInitialHour = cal.get(11);
        if (nMaxInterval_0 == 0) {
            nMaxInterval_0 = nBlockCount;
        }
        oData.addSimInfo(1, nInitialYear, n, nInitialDay, nInitialHour, 1, nMaxInterval_0, 1, CASE_PLEXOS_ST, " ");
        for (int nBlock = 0; nBlock < oData.blockTime.size() && nBlock < nMaxInterval_0; ++nBlock) {
            int nBlockNumber = oData.blockTime.get((int)nBlock).BlockNumber;
            oData.adddispatchInfo(nBlockNumber, 0, 1);
        }
        boolean bHasMaxFlowData = false;
        strQuery = "SELECT * FROM get_Data_0";
        strQuery = strQuery + " WHERE Property='Price' OR Property='Load' OR Property='Generation' OR Property='Flow' OR Property='Export Limit' OR Property='Import Limit'";
        System.out.println("Querying hourly data. Please wait...");
        nBlockCount = 0;
        try {
            rs = stmt.executeQuery(strQuery);
            while (rs.next()) {
                strObjectName = rs.getString("Child");
                strCollection = rs.getString("Collection");
                strProperty = rs.getString("Property");
                dValue = rs.getDouble("Value");
                nYear = rs.getInt("Year");
                nMonth = rs.getInt("Month");
                nDay = rs.getInt("Day");
                nInterval = rs.getInt("Interval");
                nPeriod_id = date_IntervalToPeriodId[nYear - nIniYear][nMonth - 1][nDay - 1][nInterval - 1];
                if (strCollection.equals("Nodes")) {
                    if (strProperty.equals("Price")) {
                        if (oData.getObjectID(strObjectName, PAR_CMG_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_CMG_P, "");
                        }
                        oData.adddata(strObjectName, PAR_CMG_P, 0, nPeriod_id, dValue);
                    } else if (strProperty.equals("Load")) {
                        if (oData.getObjectID(strObjectName, PAR_LOAD_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_LOAD_P, "");
                        }
                        oData.adddata(strObjectName, PAR_LOAD_P, 0, nPeriod_id, dValue);
                    }
                } else if (strCollection.equals("Generators")) {
                    if (strProperty.equals("Generation")) {
                        if (oData.getObjectID(strObjectName, PAR_GEN_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_GEN_P, "");
                        }
                        oData.adddata(strObjectName, PAR_GEN_P, 0, nPeriod_id, dValue);
                    }
                } else if (strCollection.equals("Lines")) {
                    if (strProperty.equals("Flow")) {
                        if (oData.getObjectID(strObjectName, PAR_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_FLOW_P, "");
                        }
                        oData.adddata(strObjectName, PAR_FLOW_P, 0, nPeriod_id, dValue);
                    }
                    if (strProperty.equals("Export Limit")) {
                        bHasMaxFlowData = true;
                        if (oData.getObjectID(strObjectName, PAR_MAX_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_MAX_FLOW_P, "");
                        }
                        oData.adddata(strObjectName, PAR_MAX_FLOW_P, 0, nPeriod_id, dValue);
                    }
                    if (strProperty.equals("Import Limit")) {
                        bHasMaxFlowData = true;
                        if (oData.getObjectID(strObjectName, PAR_MIN_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                            oData.addobjectInfo(strObjectName, PAR_MIN_FLOW_P, "");
                        }
                        oData.adddata(strObjectName, PAR_MIN_FLOW_P, 0, nPeriod_id, dValue);
                    }
                }
                ++nBlockCount;
            }
        }
        catch (SQLException e) {
            System.out.println("Error executing query 'get_data_0'. Error reading line " + (nBlockCount + 1));
            System.out.println("Database: " + outputDatabasePath);
            System.out.println("SQL Exception: " + e.getMessage());
            DeepEdit.CloseJDBCConnection(conn);
            return null;
        }
        if (!bHasMaxFlowData) {
            strQuery = "SELECT * FROM get_Data_1 WHERE Property='Max Flow' OR Property='Min Flow' OR Property='Export Limit' OR Property='Import Limit'";
            System.out.println("Querying daily summary data. Please wait...");
            nBlockCount = 0;
            try {
                rs = stmt.executeQuery(strQuery);
                while (rs.next()) {
                    strObjectName = rs.getString("Child");
                    strCollection = rs.getString("Collection");
                    strProperty = rs.getString("Property");
                    dValue = rs.getDouble("Value");
                    nYear = rs.getInt("Year");
                    nPeriod_id = date_IntervalToPeriodId[nYear - nIniYear][(nMonth = rs.getInt("Month")) - 1][(nDay = rs.getInt("Day")) - 1][nInterval = 0];
                    if (nPeriod_id >= nMaxInterval_0) continue;
                    if (strCollection.equals("Lines")) {
                        if (strProperty.equals("Export Limit")) {
                            bHasMaxFlowData = true;
                            if (oData.getObjectID(strObjectName, PAR_MAX_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                                oData.addobjectInfo(strObjectName, PAR_MAX_FLOW_P, "");
                            }
                            oData.adddata(strObjectName, PAR_MAX_FLOW_P, 0, nPeriod_id, dValue);
                        } else if (strProperty.equals("Max Flow")) {
                            if (oData.getObjectID(strObjectName, PAR_MAX_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                                oData.addobjectInfo(strObjectName, PAR_MAX_FLOW_P, "");
                            }
                            oData.adddata(strObjectName, PAR_MAX_FLOW_P, 0, nPeriod_id, dValue);
                        }
                        if (strProperty.equals("Import Limit")) {
                            if (oData.getObjectID(strObjectName, PAR_MIN_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                                oData.addobjectInfo(strObjectName, PAR_MIN_FLOW_P, "");
                            }
                            oData.adddata(strObjectName, PAR_MIN_FLOW_P, 0, nPeriod_id, dValue);
                        } else if (strProperty.equals("Min Flow")) {
                            if (oData.getObjectID(strObjectName, PAR_MIN_FLOW_P) == TPDBData.VALUE_NOT_FOUND) {
                                oData.addobjectInfo(strObjectName, PAR_MIN_FLOW_P, "");
                            }
                            oData.adddata(strObjectName, PAR_MIN_FLOW_P, 0, nPeriod_id, dValue);
                        }
                    }
                    ++nBlockCount;
                }
            }
            catch (SQLException e) {
                System.out.println("Error executing query 'get_data_1'. Error reading line " + (nBlockCount + 1));
                System.out.println("Database: " + outputDatabasePath);
                System.out.println("SQL Exception: " + e.getMessage());
                strCollection = null;
                return strCollection;
            }
            finally {
                DeepEdit.CloseJDBCConnection(conn);
            }
        }
        if (!bHasMaxFlowData && nBlockCount == 0) {
            ArrayList<ParameterData> oParamMaxFlow = TPDBProcessor.readPLEXOSnamebandcolumFile(new File(inputPath + File.separator + "line_MaxRating.csv"), PAR_MAX_FLOW_P);
            ArrayList<ParameterData> oParamMinFlow = TPDBProcessor.readPLEXOSnamebandcolumFile(new File(inputPath + File.separator + "line_MinRating.csv"), PAR_MIN_FLOW_P);
            ArrayList<ParameterData> oParamUnits = TPDBProcessor.readPLEXOSnamebandcolumFile(new File(inputPath + File.separator + "line_units.csv"), PAR_INSERVICE);
            TPDBProcessor.addPLEXOSParameterData2TPDB(oParamMaxFlow, lperiod_id, oData);
            TPDBProcessor.addPLEXOSParameterData2TPDB(oParamMinFlow, lperiod_id, oData);
            TPDBProcessor.addPLEXOSParameterData2TPDB(oParamUnits, lperiod_id, oData);
        }
        return oData;
    }

    public static ArrayList<ParameterData> readPLEXOSnamebandcolumFile(File nameBandinColumnFile, String strProperty) {
        ArrayList<ParameterData> oDataList = new ArrayList<ParameterData>();
        Pattern p = Pattern.compile(",");
        int nLine = 0;
        if (!nameBandinColumnFile.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(nameBandinColumnFile));
            if (!br.readLine().contains("NAME,BAND,YEAR,MONTH,DAY,PERIOD,VALUE")) {
                System.out.println("File for property " + strProperty + " is not name-band-in-columns format: " + nameBandinColumnFile.getName());
                return null;
            }
            nLine = 2;
            while ((line = br.readLine()) != null) {
                String[] token = p.split(line);
                if (token.length > 6) {
                    String strObjectName = token[0];
                    int nBand = Integer.parseInt(token[1]) - 1;
                    int nYear = Integer.parseInt(token[2]);
                    int nMonth = Integer.parseInt(token[3]) - 1;
                    int nDay = Integer.parseInt(token[4]);
                    int nPeriod = Integer.parseInt(token[5]);
                    double dValue = Double.parseDouble(token[6]);
                    Calendar cDateFrom = Calendar.getInstance();
                    cDateFrom.set(nYear, nMonth, nDay, nPeriod, 0);
                    ParameterData oData = new ParameterData(strProperty);
                    oData.setdValue(dValue);
                    oData.setcDateFrom(cDateFrom);
                    oData.setnHydro(nBand);
                    oData.setStrOwnerName(strObjectName);
                    oDataList.add(oData);
                } else {
                    System.out.println("Unrecognized format found in file " + nameBandinColumnFile.getName() + ". Fewer fields than expected in line " + nLine);
                }
                ++nLine;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TPDBProcessor.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex.getMessage());
            System.out.println("Check that the file exists in the selected folder. Values for Property '" + strProperty + "' were not stored in database");
        }
        catch (IOException ex) {
            Logger.getLogger(TPDBProcessor.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Error parsing file: " + nameBandinColumnFile.getName());
            System.out.println("Exception message: " + ex.getMessage());
            System.out.println("Values for Property '" + strProperty + "' were not stored in database");
        }
        catch (NumberFormatException ex) {
            System.out.println("Parsing error while reading file " + nameBandinColumnFile.getName() + " line " + nLine);
            System.out.println("Exception details: " + ex.getMessage());
        }
        return oDataList;
    }

    public static void SaveTPDBDatabase(Connection conn, TPDBData oData) throws SQLException {
        Statement s = conn.createStatement();
        String strSQL = "INSERT INTO SimInfo VALUES (" + oData.SimInfo.SimulationID + ", " + oData.SimInfo.InitialYear + ", " + oData.SimInfo.InitialMonth + ", " + oData.SimInfo.InitialDay + ", " + oData.SimInfo.InitialHour + ", " + oData.SimInfo.InitialBlock + ", " + oData.SimInfo.BlockNumber + ", " + oData.SimInfo.HydroNumber + ", '" + oData.SimInfo.SoftwareSource + "', '" + oData.SimInfo.SoftwareSource + "')";
        s.executeUpdate(strSQL);
        String insertTableSQL = "INSERT INTO objectInfo (idObject, objectName, resultName, description) VALUES (?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(insertTableSQL);
        Iterator<Object> i$ = oData.objectInfo.keySet().iterator();
        while (i$.hasNext()) {
            int id = i$.next();
            ps.setInt(1, id);
            ps.setString(2, oData.objectInfo.get((Object)Integer.valueOf((int)id)).objectName.replaceAll("'", "''"));
            ps.setString(3, oData.objectInfo.get((Object)Integer.valueOf((int)id)).resultName);
            ps.setString(4, oData.objectInfo.get((Object)Integer.valueOf((int)id)).description.replaceAll("'", "''"));
            ps.addBatch();
        }
        ps.executeBatch();
        for (hydroInfo hydroInfo2 : oData.hydroInfo) {
            strSQL = "INSERT INTO hydroInfo VALUES (" + hydroInfo2.hydroID + ", '" + hydroInfo2.description + "')";
            s.executeUpdate(strSQL);
        }
        Calendar c = Calendar.getInstance();
        c.set(oData.SimInfo.InitialYear, oData.SimInfo.InitialMonth - 1, oData.SimInfo.InitialDay, oData.SimInfo.InitialHour, 0);
        insertTableSQL = "INSERT INTO blockTime (BlockNumber, BlockName, Duration, Units, iniDate) VALUES (?,?,?,?,?)";
        ps = conn.prepareStatement(insertTableSQL);
        for (blockTime blockTime2 : oData.blockTime) {
            ps.setInt(1, blockTime2.BlockNumber);
            ps.setString(2, blockTime2.BlockName);
            ps.setDouble(3, blockTime2.duration);
            ps.setString(4, blockTime2.units);
            ps.setDate(5, new Date(c.getTimeInMillis()));
            c.add(11, (int)blockTime2.duration);
            ps.addBatch();
        }
        ps.executeBatch();
        insertTableSQL = "INSERT INTO dispatchInfo (idDesp, BlockNumber, hydroID, SimulationID) VALUES (?,?,?,?)";
        ps = conn.prepareStatement(insertTableSQL);
        Iterator<Object> i$2 = oData.dispatchInfo.keySet().iterator();
        while (i$2.hasNext()) {
            int id = (Integer)i$2.next();
            ps.setInt(1, oData.dispatchInfo.get((Object)Integer.valueOf((int)id)).idDesp);
            ps.setInt(2, oData.dispatchInfo.get((Object)Integer.valueOf((int)id)).BlockNumber);
            ps.setInt(3, oData.dispatchInfo.get((Object)Integer.valueOf((int)id)).hydroID);
            ps.setInt(4, oData.dispatchInfo.get((Object)Integer.valueOf((int)id)).SimulationID);
            ps.addBatch();
        }
        ps.executeBatch();
        long startTime = System.currentTimeMillis();
        for (int id = 0; id < oData.data.size(); ++id) {
            strSQL = "INSERT INTO data VALUES (" + oData.data.get((int)id).idDesp + ", " + oData.data.get((int)id).idObject + ", " + oData.data.get((int)id).dataValue + ")";
            s.executeUpdate(strSQL);
            if (id % 500000 != 0 || id == 0) continue;
            s.close();
            boolean isAccess = false;
            String sUrl = conn.getMetaData().getURL();
            if (sUrl.contains(".mdb")) {
                isAccess = true;
                sUrl = sUrl.contains(".accdb") ? sUrl.substring(64) : sUrl.substring(55);
            } else {
                sUrl = sUrl.replaceAll("jdbc:sqlite:", "");
            }
            DeepEdit.CloseJDBCConnection(conn);
            long elapsed = (System.currentTimeMillis() - startTime) / 1000L;
            double dTimeLeft = (double)(oData.data.size() - id) / ((double)id / (double)elapsed);
            System.out.println("   -Records stored so far " + id + " of " + oData.data.size() + ". Estimated time left: " + Math.round(dTimeLeft) + "[seg]");
            conn = DeepEdit.OpenJDBCConnection(sUrl, isAccess);
            s = conn.createStatement();
        }
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
    }

    public static void clearAllTPDB(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("DELETE FROM data");
        s.executeUpdate("DELETE FROM objectinfo");
        s.executeUpdate("DELETE FROM dispatchInfo");
        s.executeUpdate("DELETE FROM hydroInfo");
        s.executeUpdate("DELETE FROM blockTime");
        s.executeUpdate("DELETE FROM SimInfo");
    }

    private static int getPLEXOSPeriod_id(ArrayList<plexosPeriodID> myList, int nYear, int nMonth, int nDay, int nInterval) {
        for (plexosPeriodID id : myList) {
            if (id.nYear != nYear || id.nMonth != nMonth || id.nDay != nDay || id.nInterval != nInterval) continue;
            return id.nPeriod_id;
        }
        return TPDBData.VALUE_NOT_FOUND;
    }

    private static int getPLEXOSPeriod_id2(ArrayList<plexosPeriodID> myList, int nYear, int nMonth, int nDay, int nHour) {
        for (plexosPeriodID id : myList) {
            if (id.nYear != nYear || id.nMonth != nMonth || id.nDay != nDay || id.nHour > nHour || !((double)nHour < (double)id.nHour + id.nDuration)) continue;
            return id.nPeriod_id;
        }
        return TPDBData.VALUE_NOT_FOUND;
    }

    private static void addPLEXOSParameterData2TPDB(ArrayList<ParameterData> oPLEXOSParamaterData, ArrayList<plexosPeriodID> lperiod_id, TPDBData oData) {
        if (oPLEXOSParamaterData == null) {
            return;
        }
        for (ParameterData p : oPLEXOSParamaterData) {
            int nHour;
            int nDay;
            int nMonth;
            int nYear = p.getcDateFrom().get(1);
            int nPeriod_id = TPDBProcessor.getPLEXOSPeriod_id2(lperiod_id, nYear, nMonth = p.getcDateFrom().get(2) + 1, nDay = p.getcDateFrom().get(5), nHour = p.getcDateFrom().get(11));
            if (nPeriod_id == TPDBData.VALUE_NOT_FOUND) continue;
            if (oData.getObjectID(p.getStrOwnerName(), p.Name) == TPDBData.VALUE_NOT_FOUND) {
                oData.addobjectInfo(p.getStrOwnerName(), p.Name, "");
            }
            oData.adddata(p.getStrOwnerName(), p.Name, 0, nPeriod_id, p.getdValue());
        }
    }

    private static String getNonTruncatedName(ArrayList<String> lLineNames, String refObject) {
        for (String s : lLineNames) {
            if (!(s.length() > refObject.length() ? s.substring(0, refObject.length()).equals(refObject) : s.equals(refObject))) continue;
            return s;
        }
        return null;
    }

    public static ArrayList<String> getObjectNameInTPDBDatabase(String TPDBparameterName, Connection conTADB) throws SQLException {
        ArrayList<String> lObject = new ArrayList<String>();
        String strSQLQuery = "SELECT * FROM objectInfo WHERE resultName = '" + TPDBparameterName + "'";
        Statement s = conTADB.createStatement();
        ResultSet r = s.executeQuery(strSQLQuery);
        while (r.next()) {
            lObject.add(r.getString("objectName"));
        }
        return lObject;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(String TPDBparameterName, String strStoreQuery, Connection conTADB, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        String strWhereClause = "resultName='" + TPDBparameterName + "'";
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, strStoreQuery, strWhereClause, DeepEditParameterName, DeepEditParameterClass);
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(Connection conTADB, String strStoreQuery, String TPDBparameterName, String strObjectName, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        String strWhereClause = "resultName='" + TPDBparameterName + "' AND objectName='" + strObjectName + "'";
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, strStoreQuery, strWhereClause, DeepEditParameterName, DeepEditParameterClass);
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(Connection conTADB, String strStoreQuery, String strWhereClause, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        ArrayList<ParameterData> lData = new ArrayList<ParameterData>();
        String strSQLQuery = strStoreQuery + " WHERE ((" + strWhereClause + ") AND (((objectInfo.objectName) Not Like 'FALLA_*')))";
        if (conTADB == null) {
            return lData;
        }
        if (conTADB.isClosed()) {
            return lData;
        }
        Statement s = conTADB.createStatement();
        ResultSet r = s.executeQuery(strSQLQuery);
        while (r.next()) {
            ParameterData pData = new ParameterData(DeepEditParameterName);
            pData.setStrOwnerName(r.getObject("objectName").toString());
            pData.setdValue(r.getDouble("dataValue"));
            pData.setnBlock(r.getInt("nBlockID"));
            pData.setnHydro(r.getInt("nHydroID"));
            pData.seteType(DE_GeneralEnums.databaseDataType.DoubleValue);
            pData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
            if (DeepEditParameterClass != null) {
                pData.setClassName(DeepEditParameterClass);
            }
            lData.add(pData);
        }
        r.close();
        s.close();
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(Connection conTADB, String strStoreQuery, String strParameterName, String strWhereClause, int nBlock, int nHydro, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        strWhereClause = strWhereClause + " AND resultName='" + strParameterName + "' AND blockNumber=" + nBlock + " AND hydroID=" + nHydro;
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, strStoreQuery, strWhereClause, DeepEditParameterName, DeepEditParameterClass);
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(Connection conTADB, String strStoreQuery, String strParameterName, int nBlock, int nHydro, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        String strWhereClause = "resultName='" + strParameterName + "' AND blockTime.blockNumber=" + nBlock + " AND hydroInfo.hydroID=" + nHydro;
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, strStoreQuery, strWhereClause, DeepEditParameterName, DeepEditParameterClass);
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(Connection conTADB, String strStoreQuery, String strParameterName, int nBlock, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        String strWhereClause = "resultName='" + strParameterName + "' AND blockTime.blockNumber=" + nBlock;
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, strStoreQuery, strWhereClause, DeepEditParameterName, DeepEditParameterClass);
        return lData;
    }

    public static ArrayList<ParameterData> executeTPDBQuery(PreparedStatement ps, String strResultName, int nBlock, int nHydro, String DeepEditParameterName, String DeepEditParameterClass) throws SQLException {
        ArrayList<ParameterData> lData = new ArrayList<ParameterData>();
        ps.setString(1, strResultName);
        ps.setInt(2, nBlock);
        ps.setInt(3, nHydro);
        ResultSet r = ps.executeQuery();
        while (r.next()) {
            ParameterData pData = new ParameterData(DeepEditParameterName);
            pData.setStrOwnerName(r.getObject(1).toString());
            pData.setdValue(r.getDouble(2));
            pData.setnBlock(nBlock);
            pData.setnHydro(nHydro);
            pData.seteType(DE_GeneralEnums.databaseDataType.DoubleValue);
            pData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
            if (DeepEditParameterClass != null) {
                pData.setClassName(DeepEditParameterClass);
            }
            lData.add(pData);
        }
        return lData;
    }

    @Override
    public void run() {
        TPDBProcessor.dispatchFileDataToDatabase(this.strDBConnection, this.strPLPInputFolder, this.strPLPOutputFolder, this.nSelectedCase);
    }
}

