/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.SimInfo;
import de.core.blockTime;
import de.core.data;
import de.core.dispatchInfo;
import de.core.hydroInfo;
import de.core.objectInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class TPDBData {
    public static final int INIT_OBJECTINFO = 2400;
    public static final int INIT_DISPATCHINFO = 8760;
    Map<Integer, objectInfo> objectInfo = new HashMap<Integer, objectInfo>(2400);
    ArrayList<data> data = new ArrayList();
    ArrayList<blockTime> blockTime = new ArrayList();
    ArrayList<hydroInfo> hydroInfo = new ArrayList();
    SimInfo SimInfo;
    Map<Integer, dispatchInfo> dispatchInfo = new HashMap<Integer, dispatchInfo>(8760);
    public static int VALUE_NOT_FOUND = -1;

    public void addobjectInfo(int idObject, String objectName, String resultName, String description) {
        objectInfo o = new objectInfo(idObject, objectName, resultName, description);
        this.objectInfo.put(idObject, o);
    }

    public int addobjectInfo(String objectName, String resultName, String description) {
        int nObjectCount = (objectName + resultName).hashCode();
        objectInfo o = new objectInfo(nObjectCount, objectName, resultName, description);
        this.objectInfo.put(nObjectCount, o);
        return nObjectCount;
    }

    public void addblockTime(int BlockNumber, String BlockName, double duration, String units, Date iniDate) {
        blockTime o = new blockTime(BlockNumber, BlockName, duration, units, iniDate);
        this.blockTime.add(o);
    }

    public void addhydroInfo(int hydroID, String description) {
        hydroInfo o = new hydroInfo(hydroID, description);
        this.hydroInfo.add(o);
    }

    public void addSimInfo(int SimulationID, int InitialYear, int InitialMonth, int InitialDay, int InitialHour, int InitialBlock, int BlockNumber, int HydroNumber, String SoftwareSource, String SchematicPath) {
        this.SimInfo = new SimInfo(SimulationID, InitialYear, InitialMonth, InitialDay, InitialHour, InitialBlock, BlockNumber, HydroNumber, SoftwareSource, SchematicPath);
    }

    public void adddispatchInfo(int idDesp, int BlockNumber, int hydroID, int SimulationID) {
        dispatchInfo o = new dispatchInfo(idDesp, BlockNumber, hydroID, SimulationID);
        this.dispatchInfo.put(idDesp, o);
    }

    public void adddispatchInfo(int BlockNumber, int hydroID, int SimulationID) {
        int idDesp = (BlockNumber + "_" + hydroID + "_" + SimulationID).hashCode();
        dispatchInfo o = new dispatchInfo(idDesp, BlockNumber, hydroID, SimulationID);
        this.dispatchInfo.put(idDesp, o);
    }

    public void adddata(String objectName, String resultName, int hydroID, int BlockNumber, double dataValue) {
        int idDesp = this.getdispatchID(BlockNumber, hydroID, 1);
        int idObject = this.getObjectID(objectName, resultName);
        if (idDesp != VALUE_NOT_FOUND && idObject != VALUE_NOT_FOUND) {
            data o = new data(idDesp, idObject, dataValue);
            this.data.add(o);
        }
    }

    public void setSimInfo(int SimulationID, int InitialYear, int InitialMonth, int InitialDay, int InitialHour, int InitialBlock, int BlockNumber, int HydroNumber, String SoftwareSource, String SchematicPath) {
        this.SimInfo = new SimInfo(SimulationID, InitialYear, InitialMonth, InitialDay, InitialHour, InitialBlock, BlockNumber, HydroNumber, SoftwareSource, SchematicPath);
    }

    public int getObjectID(String objectName, String resultName) {
        int idObject = (objectName + resultName).hashCode();
        if (this.objectInfo.containsKey(idObject)) {
            return idObject;
        }
        return VALUE_NOT_FOUND;
    }

    public int getdispatchID(int BlockNumber, int hydroID) {
        for (dispatchInfo o : this.dispatchInfo.values()) {
            if (o.BlockNumber != BlockNumber || o.hydroID != hydroID) continue;
            return o.idDesp;
        }
        return VALUE_NOT_FOUND;
    }

    public int getdispatchID(int BlockNumber, int hydroID, int SimulationID) {
        int idDesp = (BlockNumber + "_" + hydroID + "_" + SimulationID).hashCode();
        return idDesp;
    }

    public int getBlockNumber(Date iniDate) {
        for (blockTime o : this.blockTime) {
            if (!o.iniDate.equals(iniDate)) continue;
            return o.BlockNumber;
        }
        return VALUE_NOT_FOUND;
    }

    public int getBlockNumber(int hourOfHorizon) {
        double cummulatedHours = 0.0;
        for (blockTime o : this.blockTime) {
            if (!((cummulatedHours += o.duration) >= (double)hourOfHorizon)) continue;
            return o.BlockNumber;
        }
        return VALUE_NOT_FOUND;
    }
}

