/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DCLF;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.TPChileanFrame;
import de.core.TPChileanVisualFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TPChilean
extends AnalysisTool {
    TPChileanFrame MyTPChileanFrame = null;
    TPChileanVisualFrame MyTPChileanVisualFrame = null;
    ColorSpec MyColorSpec = null;
    Schematic MySch = null;
    DCLF MyDCLF;
    public String ctrla = null;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    PrintStream myPPrintStream;
    FileOutputStream os;
    protected Vector BusbarVector;
    protected Vector BusbarVectorALL;
    double[] BranchR;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    double[] node_pg;
    int numallnod = 0;
    int numallgen = 0;
    int numalllast = 0;
    int numalllin = 0;
    int numalltrafo = 0;
    int numallbran = 0;
    int numactnod = 0;
    int numactgen = 0;
    int numactlast = 0;
    int numactlin = 0;
    int numacttrafo = 0;
    int numactbran = 0;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] NomLas;
    String[] NomActBra;
    String[] NomActLin;
    String[] NomActTra;
    String[] NomActGen;
    String[] NomActNod;
    String[] NomActLas;
    String[] NomActOwner;
    String[] NomOwner;
    String[] NameGenDB;
    int[] IdDespDB;
    double[] PDB;
    String[] NameLDB;
    double[][] PLDB;
    double[][] TotDemDB;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBLoad;
    int dimDBYear;
    double[] blockTime;
    public double[] Flujo;
    double[] PDCLF;
    int[] GenNode;
    int[] LasNode;
    int year1;
    int year2;
    int ny1;
    int ny2;
    int month1;
    int month2;
    int nm1;
    int nm2;
    int block;
    int hidro;
    int flow1;
    int flow2;
    int actPeriod;
    int actMonth;
    int slackNode;
    int slackGenerator;
    double[][] ProrrateoAct;
    double[][] AProrrateoAct;
    public double[][] Prorrateo;
    double[][] OProrrateoAct;
    double[][] AOProrrateoAct;
    public double[][] OProrrateo;
    int[][] Frecuencia;
    int[][] OFrecuencia;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleSquareMatrix MatX;
    double TotGen = 0.0;
    double TotDem = 0.0;
    double[][] PGenOwn;
    int numactowner = 0;
    int numallowner = 0;
    String[] LosOwner;
    String[] LosActOwner;
    int nitera = 0;
    double[] PLA1;
    double[] PLA2;
    String nomSlackOwner = "NADA";
    int slackOwner = -1;
    int block1;
    int hidro1;
    int block2;
    int hidro2;
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int ndem;
    public double[] AVNR_COyM;
    public double[][] PagoBarra;
    public double[][] PagoOwner;
    double nTotHoras = 0.0;
    int nrobl = -1;
    double[] simDuration;
    double sdur = 0.0;
    double[][] PUnitsAct;
    double[][] APUnitsAct;
    public double[][] PUnits;
    int[][] FUnits;
    double[] PLA3;
    double[][] PGenUnits;
    public double[][] PagoUnits;
    int ndem2;
    String[] NameLDB2;
    double[][] PLDB2;
    int dimDBLoad2;
    DoubleMatrix GSDFLC;
    double[][] AI;
    double zdur = 0.0;
    double[] acumActFlujo;
    double[] acumAllFlujo;
    int[] AllBranchI;
    int[] AllBranchJ;
    double[] minActFlujo;
    double[] maxActFlujo;
    double[] minAllFlujo;
    double[] maxAllFlujo;
    double[] varActFlujo;
    double[] varAllFlujo;
    double[] medActGen;
    double[] maxActGen;
    double[] minActGen;
    double[] varActGen;
    double[] medAllGen;
    double[] maxAllGen;
    double[] minAllGen;
    double[] varAllGen;
    double[] actGen;
    double[] genDuration;
    double[] medActLas;
    double[] maxActLas;
    double[] minActLas;
    double[] varActLas;
    double[] medAllLas;
    double[] maxAllLas;
    double[] minAllLas;
    double[] varAllLas;
    double[] actLas;
    double[] lasDuration;
    double[] zimDuration;
    double[][] ProrrateoAll;
    double[][] AProrrateoAll;
    double[][] OProrrateoAll;
    double[][] AOProrrateoAll;
    DoubleMatrix GSDFAll;
    DoubleMatrix GSDFSAll;
    DoubleMatrix GGDFAll;
    DoubleSquareMatrix MatXAll;
    double[][] PUnitsAll;
    double[][] APUnitsAll;
    double[][] PGenUnitsAll;
    double[][] PGenOwnAll;
    DoubleMatrix GSDFLCAll;
    double[][] AIAll;
    double[] AllBranchX;
    double[] medAllpg;
    double[] maxAllpg;
    double[] minAllpg;
    double[] varAllpg;
    double[] medActpg;
    double[] maxActpg;
    double[] minActpg;
    double[] varActpg;
    double[] actpg;
    double[] pgDuration;
    Connection conTPDB = null;
    private double sref = this.getSref();

    TPChilean(Schematic sch) {
        super(sch);
        System.out.println("---------- In TPChilean ------------");
        if (this.MyTPChileanFrame == null) {
            this.MyTPChileanFrame = new TPChileanFrame(this);
        } else {
            this.MyTPChileanFrame.setVisible(true);
        }
    }

    TPChilean(Schematic sch, String CTRLA, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean Normal2, String loadCenter) {
        super(sch);
        System.out.println("---------- In TPChilean ------------ 1");
        this.Calculate(CTRLA, rep, vis, DBrep, SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, HydroDB, Normal2, loadCenter);
    }

    TPChilean(Schematic sch, boolean VisDB, String Bus) {
        super(sch);
        System.out.println("---------- In TPChilean ------------ 2");
        this.InitAllNetwork(Bus);
    }

    public void Calculate(String cctrla, boolean rep, boolean vis, boolean DBrep, String SDY, String SDM, String SDB, String SDH, String EDY, String EDM, String EDB, String EDH, boolean HydroDB, boolean Normal2, String loadCenter) {
        int j;
        int i;
        double inicio = System.currentTimeMillis();
        this.ctrla = cctrla;
        String SensiJAVAdat = "./results/TPChilean.dat";
        this.actPeriod = this.ActSchematic.getactperiod();
        this.actMonth = this.ActSchematic.getactmonth();
        try {
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("******************");
            this.myPPrintStream.println("  Balance Flujos  ");
            this.myPPrintStream.println("******************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("Nro. Flujo    -    Flujo Slack    -    TotGen    -    TotDem    -    Gen-Dem");
            this.myPPrintStream.println(" ");
            System.out.println(" ");
            System.out.println("Making InitAllNetwork");
            this.InitAllNetwork(loadCenter);
            System.out.println("InitAllNetwork          Done");
            System.out.println(" ");
            System.out.println("Making GetActiveNetwork");
            this.GetActiveNetwork(loadCenter);
            System.out.println("GetActiveNetwork    Done");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println("Making GetDatabase");
            this.GetDBAndFlowSelection(SDY, SDM, SDB, SDH, EDY, EDM, EDB, EDH, HydroDB);
            System.out.println("GetDatabase             Done");
            System.out.println(" ");
            System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("********************************");
            System.out.println(" DB Simulation Information");
            System.out.println("********************************");
            System.out.println(" ");
            System.out.println(" IntialYearDB  = " + this.InitialYearDB);
            System.out.println(" IntialMonthDB = " + this.InitialMonthDB);
            System.out.println(" FinalYearDB   = " + this.FinalYearDB);
            System.out.println(" FinalMonthDB  = " + this.FinalMonthDB);
            System.out.println(" ");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println(" DB Simulation Information");
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("  IntialYearDB  = " + this.InitialYearDB);
            this.myPPrintStream.println("  IntialMonthDB = " + this.InitialMonthDB);
            this.myPPrintStream.println("  FinalYearDB   = " + this.FinalYearDB);
            this.myPPrintStream.println("  FinalMonthDB  = " + this.FinalMonthDB);
            this.myPPrintStream.println("**************************************");
            this.myPPrintStream.println("  ");
            this.ActSchematic.setactperiod(this.year1);
            this.ActSchematic.setactmonth(this.month1);
            this.ActSchematic.Modifiedstate = true;
            this.ActSchematic.Modified = true;
            this.ActSchematic.CheckActive();
            int FY = this.ny1;
            int LY = this.ny2;
            int FM = this.nm1;
            int LM = this.nm2;
            int FB = this.block1;
            int LB = this.block2;
            int FH = this.hidro1;
            int LH = this.hidro2;
            if (this.MyDCLF != null) {
                this.MyDCLF = null;
            }
            this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
            System.out.println("INICIO Loop Principal");
            boolean nf = false;
            this.nTotHoras = 0.0;
            for (int y = this.year1; y <= this.year2; ++y) {
                System.out.println(" ");
                System.out.println("********************************************");
                System.out.println(" IN YEAR " + y + " CALCULATION");
                System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                System.out.println("********************************************");
                System.out.println(" ");
                int limmes1 = y == this.year1 ? this.month1 : 1;
                int limmes2 = y == this.year2 ? this.month2 : 12;
                for (int m = limmes1; m <= limmes2; ++m) {
                    int jj;
                    int ii;
                    int ii2;
                    System.out.println(" ");
                    System.out.println("-------------------------------");
                    System.out.println(" IN MONTH " + m + " CALCULATION");
                    System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                    System.out.println("-------------------------------");
                    if (this.Plan_Obra(y, m)) {
                        System.out.println(" Month " + m + " ESTA en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPChilean.numformat(this.year1, 8) + "/" + TPChilean.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPChilean.numformat(this.year2, 8) + "/" + TPChilean.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPChilean.numformat(y, 8) + "/" + TPChilean.numformat(m, 8));
                        this.ActSchematic.setactperiod(y);
                        this.ActSchematic.setactmonth(m);
                        this.ActSchematic.Modifiedstate = true;
                        this.ActSchematic.Modified = true;
                        this.ActSchematic.CheckActive();
                        System.out.println(" ");
                        System.out.println("Making GetActiveNetwork");
                        this.GetActiveNetwork(loadCenter);
                        System.out.println("GetActiveNetwork    Done");
                        System.out.println(" ");
                        if (this.MyDCLF != null) {
                            this.MyDCLF = null;
                        }
                        this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                    } else {
                        System.out.println(" Month " + m + " NO esta en plan de obra");
                        System.out.println(" Fecha Inicio :" + TPChilean.numformat(this.year1, 8) + "/" + TPChilean.numformat(this.month1, 8));
                        System.out.println(" Fecha Fin    :" + TPChilean.numformat(this.year2, 8) + "/" + TPChilean.numformat(this.month2, 8));
                        System.out.println(" Fecha Actual :" + TPChilean.numformat(y, 8) + "/" + TPChilean.numformat(m, 8));
                    }
                    if (this.APUnitsAct != null) {
                        this.APUnitsAct = null;
                    }
                    this.APUnitsAct = new double[this.numactbran][this.numactgen];
                    if (this.AProrrateoAct != null) {
                        this.AProrrateoAct = null;
                    }
                    this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                    if (this.AOProrrateoAct != null) {
                        this.AOProrrateoAct = null;
                    }
                    this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                    for (i = 0; i < this.numactbran; ++i) {
                        for (j = 0; j < this.numactnod; ++j) {
                            this.AProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactowner; ++j) {
                            this.AOProrrateoAct[i][j] = 0.0;
                        }
                        for (j = 0; j < this.numactgen; ++j) {
                            this.APUnitsAct[i][j] = 0.0;
                        }
                    }
                    int limblock1 = -1;
                    int limblock2 = -1;
                    limblock1 = y == this.year1 && m == this.month1 ? this.block1 : 1;
                    limblock2 = y == this.year2 && m == this.month2 ? this.block2 : this.BlockNumberDB;
                    this.nitera = 0;
                    this.nTotHoras = 0.0;
                    this.sdur = 0.0;
                    for (int b = limblock1; b <= limblock2; ++b) {
                        System.out.println(" ");
                        System.out.println("  ........................................");
                        System.out.println("   IN BLOCK " + b + " CALCULATION");
                        System.out.println("   Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                        System.out.print("  ");
                        int limhidro1 = -1;
                        int limhidro2 = -1;
                        limhidro1 = y == this.year1 && m == this.month1 && b == this.block1 ? this.hidro1 : 1;
                        limhidro2 = y == this.year2 && m == this.month2 && b == this.block2 ? this.hidro2 : this.HydroNumberDB;
                        for (int h = limhidro1; h <= limhidro2; ++h) {
                            if (y == this.year1 && m == this.month1 && this.nitera == 0) {
                                System.out.println("    This is the first seleted flow!");
                                System.out.println("      DCLF variables initialization ... ");
                                this.ActSchematic.setactperiod(y);
                                this.ActSchematic.setactmonth(m);
                                this.ActSchematic.Modifiedstate = true;
                                this.ActSchematic.Modified = true;
                                this.ActSchematic.CheckActive();
                                System.out.println(" ");
                                System.out.println("Making GetActiveNetwork");
                                this.GetActiveNetwork(loadCenter);
                                System.out.println("GetActiveNetwork    Done");
                                System.out.println(" ");
                                if (this.MyDCLF != null) {
                                    this.MyDCLF = null;
                                }
                                this.MyDCLF = new DCLF(this.ActSchematic, cctrla);
                                for (i = 0; i < this.numactbran; ++i) {
                                    this.minActFlujo[i] = 1000000.0;
                                    this.maxActFlujo[i] = -1000000.0;
                                }
                                for (i = 0; i < this.numactgen; ++i) {
                                    this.minActGen[i] = 1000000.0;
                                    this.maxActGen[i] = -1000000.0;
                                }
                                for (i = 0; i < this.numactlast; ++i) {
                                    this.minActLas[i] = 1000000.0;
                                    this.maxActLas[i] = -1000000.0;
                                }
                                if (this.APUnitsAct != null) {
                                    this.APUnitsAct = null;
                                }
                                this.APUnitsAct = new double[this.numactbran][this.numactgen];
                                if (this.AProrrateoAct != null) {
                                    this.AProrrateoAct = null;
                                }
                                this.AProrrateoAct = new double[this.numactbran][this.numactnod];
                                if (this.AOProrrateoAct != null) {
                                    this.AOProrrateoAct = null;
                                }
                                this.AOProrrateoAct = new double[this.numactbran][this.numactowner];
                                for (i = 0; i < this.numactbran; ++i) {
                                    for (j = 0; j < this.numactnod; ++j) {
                                        this.AProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactowner; ++j) {
                                        this.AOProrrateoAct[i][j] = 0.0;
                                    }
                                    for (j = 0; j < this.numactgen; ++j) {
                                        this.APUnitsAct[i][j] = 0.0;
                                    }
                                }
                            }
                            System.out.print(".");
                            this.build_Injection(y, m, b, h, HydroDB);
                            this.MyDCLF.calcular_DCLF(this.PDCLF, this.Flujo);
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.Flujo[i] < this.minActFlujo[i]) {
                                    this.minActFlujo[i] = this.Flujo[i];
                                }
                                if (this.Flujo[i] > this.maxActFlujo[i]) {
                                    this.maxActFlujo[i] = this.Flujo[i];
                                }
                                int n = i;
                                this.acumActFlujo[n] = this.acumActFlujo[n] + this.Flujo[i] * this.blockTime[this.nrobl - 1];
                                int n2 = i;
                                this.varActFlujo[n2] = this.varActFlujo[n2] + this.Flujo[i] * this.Flujo[i] * this.blockTime[this.nrobl - 1];
                            }
                            this.node_pg[this.slackNode] = 0.0;
                            for (i = 0; i < this.numactbran; ++i) {
                                if (this.BranchI[i] == this.slackNode) {
                                    int n = this.slackNode;
                                    this.node_pg[n] = this.node_pg[n] + this.Flujo[i] * this.sref;
                                    continue;
                                }
                                if (this.BranchJ[i] != this.slackNode) continue;
                                int n = this.slackNode;
                                this.node_pg[n] = this.node_pg[n] - this.Flujo[i] * this.sref;
                            }
                            this.node_pg[this.slackNode] = Math.max(0.0, this.node_pg[this.slackNode]);
                            this.actGen[this.slackGenerator] = this.node_pg[this.slackNode];
                            if (this.node_pg[this.slackNode] > 1.0E-6) {
                                this.PGenOwn[this.slackOwner][this.slackNode] = this.node_pg[this.slackNode];
                                this.PGenUnits[this.slackGenerator][this.slackNode] = this.node_pg[this.slackNode];
                            }
                            int nfl = ((y - this.InitialYearDB) * 12 + (m - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (b - 1) * this.HydroNumberDB + h;
                            this.myPPrintStream.println(TPChilean.numformat(nfl, 5) + "    -    " + TPChilean.numformat(this.node_pg[this.slackNode], 7, 3) + "    -    " + TPChilean.numformat(this.TotGen, 7, 3) + "    -    " + TPChilean.numformat(this.TotDem, 7, 3) + "    -    " + TPChilean.numformat(this.TotGen - this.TotDem, 7, 3));
                            this.build_GDF(this.Flujo, this.node_pg);
                            if (this.PUnitsAct != null) {
                                this.PUnitsAct = null;
                            }
                            this.PUnitsAct = new double[this.numactbran][this.numactgen];
                            if (this.ProrrateoAct != null) {
                                this.ProrrateoAct = null;
                            }
                            this.ProrrateoAct = new double[this.numactbran][this.numactnod];
                            if (this.OProrrateoAct != null) {
                                this.OProrrateoAct = null;
                            }
                            this.OProrrateoAct = new double[this.numactbran][this.numactowner];
                            this.build_Participa(this.Flujo, this.node_pg);
                            this.nrobl = this.BlockNumberDB * (m - 1) + b;
                            for (i = 0; i < this.numactbran; ++i) {
                                int k;
                                for (j = 0; j < this.numactnod; ++j) {
                                    double[] dArray = this.AProrrateoAct[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.blockTime[this.nrobl - 1];
                                }
                                for (k = 0; k < this.numactowner; ++k) {
                                    double[] dArray = this.AOProrrateoAct[i];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.OProrrateoAct[i][k] * this.blockTime[this.nrobl - 1];
                                }
                                for (k = 0; k < this.numactgen; ++k) {
                                    double[] dArray = this.APUnitsAct[i];
                                    int n = k;
                                    dArray[n] = dArray[n] + this.PUnitsAct[i][k] * this.blockTime[this.nrobl - 1];
                                }
                            }
                            for (i = 0; i < this.numactgen; ++i) {
                                if (this.actGen[i] < this.minActGen[i]) {
                                    this.minActGen[i] = this.actGen[i];
                                }
                                if (this.actGen[i] > this.maxActGen[i]) {
                                    this.maxActGen[i] = this.actGen[i];
                                }
                                int n = i;
                                this.medActGen[n] = this.medActGen[n] + this.actGen[i] * this.blockTime[this.nrobl - 1];
                                int n3 = i;
                                this.varActGen[n3] = this.varActGen[n3] + this.actGen[i] * this.actGen[i] * this.blockTime[this.nrobl - 1];
                            }
                            for (i = 0; i < this.numactlast; ++i) {
                                if (this.actLas[i] < this.minActLas[i]) {
                                    this.minActLas[i] = this.actLas[i];
                                }
                                if (this.actLas[i] > this.maxActLas[i]) {
                                    this.maxActLas[i] = this.actLas[i];
                                }
                                int n = i;
                                this.medActLas[n] = this.medActLas[n] + this.actLas[i] * this.blockTime[this.nrobl - 1];
                                int n4 = i;
                                this.varActLas[n4] = this.varActLas[n4] + this.actLas[i] * this.actLas[i] * this.blockTime[this.nrobl - 1];
                            }
                            this.zdur += this.blockTime[this.nrobl - 1];
                            this.nTotHoras += this.blockTime[this.nrobl - 1];
                            ++this.nitera;
                        }
                        this.nrobl = this.BlockNumberDB * (m - 1) + b;
                        this.sdur += this.blockTime[this.nrobl - 1];
                    }
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Mensual de Estad\u00edsticas");
                    block29: for (ii2 = 0; ii2 < this.numactbran; ++ii2) {
                        for (i = ii2; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii2].equals(this.NomBra[i])) continue;
                            if (this.minAllFlujo[i] > this.minActFlujo[ii2]) {
                                this.minAllFlujo[i] = this.minActFlujo[ii2];
                            }
                            if (this.maxAllFlujo[i] < this.maxActFlujo[ii2]) {
                                this.maxAllFlujo[i] = this.maxActFlujo[ii2];
                            }
                            int n = i;
                            this.acumAllFlujo[n] = this.acumAllFlujo[n] + this.acumActFlujo[ii2];
                            int n5 = i;
                            this.varAllFlujo[n5] = this.varAllFlujo[n5] + this.varActFlujo[ii2];
                            int n6 = i;
                            this.zimDuration[n6] = this.zimDuration[n6] + this.zdur;
                            continue block29;
                        }
                    }
                    block31: for (ii2 = 0; ii2 < this.numactgen; ++ii2) {
                        for (i = ii2; i < this.numallgen; ++i) {
                            if (!this.NomActGen[ii2].equals(this.NomGen[i])) continue;
                            if (this.minAllGen[i] > this.minActGen[ii2]) {
                                this.minAllGen[i] = this.minActGen[ii2];
                            }
                            if (this.maxAllGen[i] < this.maxActGen[ii2]) {
                                this.maxAllGen[i] = this.maxActGen[ii2];
                            }
                            int n = i;
                            this.medAllGen[n] = this.medAllGen[n] + this.medActGen[ii2];
                            int n7 = i;
                            this.varAllGen[n7] = this.varAllGen[n7] + this.varActGen[ii2];
                            int n8 = i;
                            this.genDuration[n8] = this.genDuration[n8] + this.sdur;
                            continue block31;
                        }
                    }
                    block33: for (ii2 = 0; ii2 < this.numactlast; ++ii2) {
                        for (i = ii2; i < this.numalllast; ++i) {
                            if (!this.NomActLas[ii2].equals(this.NomLas[i])) continue;
                            if (this.minAllLas[i] > this.minActLas[ii2]) {
                                this.minAllLas[i] = this.minActLas[ii2];
                            }
                            if (this.maxAllLas[i] < this.maxActLas[ii2]) {
                                this.maxAllLas[i] = this.maxActLas[ii2];
                            }
                            int n = i;
                            this.medAllLas[n] = this.medAllLas[n] + this.medActLas[ii2];
                            int n9 = i;
                            this.varAllLas[n9] = this.varAllLas[n9] + this.varActLas[ii2];
                            int n10 = i;
                            this.lasDuration[n10] = this.lasDuration[n10] + this.sdur;
                            continue block33;
                        }
                    }
                    block35: for (ii2 = 0; ii2 < this.numactnod; ++ii2) {
                        for (i = ii2; i < this.numallnod; ++i) {
                            if (!this.NomActNod[ii2].equals(this.NomNod[i])) continue;
                            if (this.minAllpg[i] > this.minActpg[ii2]) {
                                this.minAllpg[i] = this.minActpg[ii2];
                            }
                            if (this.maxAllpg[i] < this.maxActpg[ii2]) {
                                this.maxAllpg[i] = this.maxActpg[ii2];
                            }
                            int n = i;
                            this.medAllpg[n] = this.medAllpg[n] + this.medActpg[ii2];
                            int n11 = i;
                            this.varAllpg[n11] = this.varAllpg[n11] + this.varActpg[ii2];
                            int n12 = i;
                            this.pgDuration[n12] = this.pgDuration[n12] + this.sdur;
                            continue block35;
                        }
                    }
                    System.out.println("   - Fin Actualizaci\u00f3n de Estad\u00edsticas ");
                    System.out.println("");
                    System.out.println("   - Actualizaci\u00f3n Mensual de matrices de resumen ");
                    boolean kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        block38: for (jj = 0; jj < this.numactnod; ++jj) {
                            for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numallnod; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActNod[jj].equals(this.NomNod[j])) {
                                        int[] nArray = this.Frecuencia[i];
                                        int n = j;
                                        nArray[n] = (int)((double)nArray[n] + this.nTotHoras);
                                        double[] dArray = this.Prorrateo[i];
                                        int n13 = j;
                                        dArray[n13] = dArray[n13] + this.AProrrateoAct[ii][jj];
                                        kiebra = true;
                                        break;
                                    }
                                    kiebra = false;
                                }
                                if (kiebra) continue block38;
                            }
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        block42: for (jj = 0; jj < this.numactowner; ++jj) {
                            for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numallowner; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActOwner[jj].equals(this.NomOwner[j])) {
                                        int[] nArray = this.OFrecuencia[i];
                                        int n = j;
                                        nArray[n] = (int)((double)nArray[n] + this.nTotHoras);
                                        double[] dArray = this.OProrrateo[i];
                                        int n14 = j;
                                        dArray[n14] = dArray[n14] + this.AOProrrateoAct[ii][jj];
                                        kiebra = true;
                                        break;
                                    }
                                    kiebra = false;
                                }
                                if (kiebra) continue block42;
                            }
                        }
                    }
                    kiebra = false;
                    for (ii = 0; ii < this.numactbran; ++ii) {
                        block46: for (jj = 0; jj < this.numactgen; ++jj) {
                            for (i = ii; i < this.numallbran; ++i) {
                                for (j = jj; j < this.numallgen; ++j) {
                                    if (this.NomActBra[ii].equals(this.NomBra[i]) && this.NomActGen[jj].equals(this.NomGen[j])) {
                                        int[] nArray = this.FUnits[i];
                                        int n = j;
                                        nArray[n] = (int)((double)nArray[n] + this.nTotHoras);
                                        double[] dArray = this.PUnits[i];
                                        int n15 = j;
                                        dArray[n15] = dArray[n15] + this.APUnitsAct[ii][jj];
                                        kiebra = true;
                                        break;
                                    }
                                    kiebra = false;
                                }
                                if (kiebra) continue block46;
                            }
                        }
                    }
                    block49: for (ii = 0; ii < this.numactbran; ++ii) {
                        for (i = ii; i < this.numallbran; ++i) {
                            if (!this.NomActBra[ii].equals(this.NomBra[i])) continue;
                            int n = i;
                            this.simDuration[n] = this.simDuration[n] + this.sdur;
                            continue block49;
                        }
                    }
                    System.out.println("   - Matrices actualizadas ");
                    for (i = 0; i < this.numactbran; ++i) {
                        this.acumActFlujo[i] = 0.0;
                        this.varActFlujo[i] = 0.0;
                    }
                    for (i = 0; i < this.numactgen; ++i) {
                        this.medActGen[i] = 0.0;
                        this.varActGen[i] = 0.0;
                    }
                    for (i = 0; i < this.numactlast; ++i) {
                        this.medActLas[i] = 0.0;
                        this.varActLas[i] = 0.0;
                    }
                }
            }
            System.out.println(" ");
            System.out.println("FIN Loop Principal");
            for (i = 0; i < this.numallbran; ++i) {
                if (this.zimDuration[i] > 1.0E-6) {
                    this.acumAllFlujo[i] = this.acumAllFlujo[i] / this.zimDuration[i];
                    this.varAllFlujo[i] = this.varAllFlujo[i] / this.zimDuration[i] - this.acumAllFlujo[i] * this.acumAllFlujo[i];
                    continue;
                }
                this.minAllFlujo[i] = 0.0;
                this.maxAllFlujo[i] = 0.0;
                this.acumAllFlujo[i] = 0.0;
            }
            for (i = 0; i < this.numallgen; ++i) {
                if (this.genDuration[i] > 1.0E-6) {
                    this.medAllGen[i] = this.medAllGen[i] / this.genDuration[i];
                    this.varAllGen[i] = this.varAllGen[i] / this.genDuration[i] - this.medAllGen[i] * this.medAllGen[i];
                    continue;
                }
                this.minAllGen[i] = 0.0;
                this.maxAllGen[i] = 0.0;
                this.medAllGen[i] = 0.0;
            }
            for (i = 0; i < this.numalllast; ++i) {
                if (this.lasDuration[i] > 1.0E-6) {
                    this.medAllLas[i] = this.medAllLas[i] / this.lasDuration[i];
                    this.varAllLas[i] = this.varAllLas[i] / this.lasDuration[i] - this.medAllLas[i] * this.medAllLas[i];
                    continue;
                }
                this.minAllLas[i] = 0.0;
                this.maxAllLas[i] = 0.0;
                this.medAllLas[i] = 0.0;
            }
            for (i = 0; i < this.numallnod; ++i) {
                if (this.pgDuration[i] > 1.0E-6) {
                    this.medAllpg[i] = this.medAllpg[i] / this.pgDuration[i];
                    this.varAllpg[i] = this.varAllpg[i] / this.pgDuration[i] - this.medAllpg[i] * this.medAllpg[i];
                    continue;
                }
                this.minAllpg[i] = 0.0;
                this.maxAllpg[i] = 0.0;
                this.medAllpg[i] = 0.0;
            }
            if (Normal2) {
                this.build_Participa2(this.acumAllFlujo, this.medAllpg);
            }
            System.out.println(" ");
            System.out.println("Construcci\u00f3n Prorrateo resumen");
            for (i = 0; i < this.numallbran; ++i) {
                this.PLA1[i] = 0.0;
                this.PLA2[i] = 0.0;
                this.PLA3[i] = 0.0;
                for (j = 0; j < this.numallnod; ++j) {
                    if (this.Frecuencia[i][j] <= 0) continue;
                    this.Prorrateo[i][j] = this.Prorrateo[i][j] / (double)this.Frecuencia[i][j];
                    int n = i;
                    this.PLA1[n] = this.PLA1[n] + this.Prorrateo[i][j];
                }
                for (j = 0; j < this.numallowner; ++j) {
                    if (this.OFrecuencia[i][j] <= 0) continue;
                    this.OProrrateo[i][j] = this.OProrrateo[i][j] / (double)this.OFrecuencia[i][j];
                    int n = i;
                    this.PLA2[n] = this.PLA2[n] + this.OProrrateo[i][j];
                }
                for (j = 0; j < this.numallgen; ++j) {
                    if (this.FUnits[i][j] <= 0) continue;
                    this.PUnits[i][j] = this.PUnits[i][j] / (double)this.FUnits[i][j];
                    int n = i;
                    this.PLA3[n] = this.PLA3[n] + this.PUnits[i][j];
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    if (!(this.PLA1[i] > 1.0E-6) && !(this.PLA1[i] < -1.0E-6)) continue;
                    this.Prorrateo[i][j] = this.Prorrateo[i][j] / this.PLA1[i] * 100.0;
                }
                for (j = 0; j < this.numallowner; ++j) {
                    if (!(this.PLA2[i] > 1.0E-6) && !(this.PLA2[i] < -1.0E-6)) continue;
                    this.OProrrateo[i][j] = this.OProrrateo[i][j] / this.PLA2[i] * 100.0;
                }
                for (j = 0; j < this.numallgen; ++j) {
                    if (!(this.PLA3[i] > 1.0E-6) && !(this.PLA3[i] < -1.0E-6)) continue;
                    this.PUnits[i][j] = this.PUnits[i][j] / this.PLA3[i] * 100.0;
                }
            }
            for (i = 0; i < this.numallbran; ++i) {
                for (j = 0; j < this.numallnod; ++j) {
                    this.PagoBarra[i][j] = this.Prorrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numallowner; ++j) {
                    this.PagoOwner[i][j] = this.OProrrateo[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
                for (j = 0; j < this.numallgen; ++j) {
                    this.PagoUnits[i][j] = this.PUnits[i][j] / 100.0 * this.AVNR_COyM[i] * (this.simDuration[i] / 8760.0);
                }
            }
            System.out.println("Construcci\u00f3n Prorrateo resumen Ejecutada");
            if (rep) {
                System.out.println("Making Report File");
                System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas Generales");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Selecci\u00f3n de Flujos  :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
                this.myPPrintStream.println(" Flujo Inicial        :" + TPChilean.numformat(this.year1, 8) + "/" + TPChilean.numformat(this.month1, 8) + "/" + TPChilean.numformat(this.block1, 8) + "/" + TPChilean.numformat(this.hidro1, 8) + "/" + TPChilean.numformat(this.flow1, 8));
                this.myPPrintStream.println(" Flujo Final          :" + TPChilean.numformat(this.year2, 8) + "/" + TPChilean.numformat(this.month2, 8) + "/" + TPChilean.numformat(this.block2, 8) + "/" + TPChilean.numformat(this.hidro2, 8) + "/" + TPChilean.numformat(this.flow2, 8));
                this.myPPrintStream.println(" Total Barras         :    " + this.numallnod);
                this.myPPrintStream.println(" Total Ramas          :    " + this.numallbran);
                this.myPPrintStream.println(" Total Generadores    :    " + this.numallgen);
                this.myPPrintStream.println(" Total Cargas         :    " + this.numalllast);
                this.myPPrintStream.println(" Total L\u00edneas         :    " + this.numalllin);
                this.myPPrintStream.println(" Total Transformadores:    " + this.numalltrafo);
                this.myPPrintStream.println(" Total Execution Time :    " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" Estad\u00edsticas de Simulaci\u00f3n");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Estad\u00edsticas de Flujos por Elementos de Transmisi\u00f3n");
                this.myPPrintStream.println(" ---------------------------------------------------");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Rama                      |      Desde      |     Hasta      |  Flujo Medio [pu]  |   Flujo Max [pu]   |   Flujo Min [pu]  |   Desviaci\u00f3n");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numallbran; ++i) {
                    this.myPPrintStream.println(" " + TPChilean.strformat(this.NomBra[i], 25) + " | " + TPChilean.strformat(this.NomNod[this.AllBranchI[i]], 15) + " | " + TPChilean.strformat(this.NomNod[this.AllBranchJ[i]], 14) + " | " + TPChilean.numformat(this.acumAllFlujo[i], 18, 4) + " | " + TPChilean.numformat(this.maxAllFlujo[i], 18, 4) + " | " + TPChilean.numformat(this.minAllFlujo[i], 17, 4) + " | " + TPChilean.numformat(Math.sqrt(this.varAllFlujo[i]), 12, 4));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Estad\u00edsticas de Generaci\u00f3n de Unidades");
                this.myPPrintStream.println(" --------------------------------------");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Generador                 |  Generaci\u00f3n Media [pu]  |   Generaci\u00f3n Max [pu]   |   Generaci\u00f3n Min [pu]  |   Desviaci\u00f3n");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numallgen; ++i) {
                    this.myPPrintStream.println(" " + TPChilean.strformat(this.NomGen[i], 25) + " | " + TPChilean.numformat(this.medAllGen[i], 23, 4) + " | " + TPChilean.numformat(this.maxAllGen[i], 23, 4) + " | " + TPChilean.numformat(this.minAllGen[i], 22, 4) + " | " + TPChilean.numformat(Math.sqrt(this.varAllGen[i]), 12, 4));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Estad\u00edsticas de Demanda de Cargas");
                this.myPPrintStream.println(" ---------------------------------");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Carga                     |     Demanda Media [pu]  |      Demanda Max [pu]   |      Demanda Min [pu]  |   Desviaci\u00f3n");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numalllast; ++i) {
                    this.myPPrintStream.println(" " + TPChilean.strformat(this.NomLas[i], 25) + " | " + TPChilean.numformat(this.medAllLas[i], 23, 4) + " | " + TPChilean.numformat(this.maxAllLas[i], 23, 4) + " | " + TPChilean.numformat(this.minAllLas[i], 22, 4) + " | " + TPChilean.numformat(Math.sqrt(this.varAllLas[i]), 12, 4));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Estad\u00edsticas de Generaci\u00f3n Nodal");
                this.myPPrintStream.println(" --------------------------------");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" Nodo                     |     Generaci\u00f3n Media [pu]  |      Generaci\u00f3n Max [pu]   |      Generaci\u00f3n Min [pu]  |   Desviaci\u00f3n");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numallnod; ++i) {
                    this.myPPrintStream.println(" " + TPChilean.strformat(this.NomNod[i], 25) + " | " + TPChilean.numformat(this.medAllpg[i], 23, 4) + " | " + TPChilean.numformat(this.maxAllpg[i], 23, 4) + " | " + TPChilean.numformat(this.minAllpg[i], 22, 4) + " | " + TPChilean.numformat(Math.sqrt(this.varAllpg[i]), 12, 4));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Barra ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Barra             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(Math.abs(this.Prorrateo[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPChilean.strformat(this.NomBra[i], 30) + "  " + TPChilean.strformat(this.NomNod[j], 30) + "  " + TPChilean.numformat(this.Prorrateo[i][j], 15, 5) + "               " + this.PagoBarra[i][j]);
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Owner ");
                this.myPPrintStream.println("**************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Owner             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (!(Math.abs(this.OProrrateo[i][j]) > 1.0E-6)) continue;
                        this.myPPrintStream.println(TPChilean.strformat(this.NomBra[i], 30) + "    " + TPChilean.strformat(this.NomOwner[j], 30) + "    " + TPChilean.numformat(this.OProrrateo[i][j], 15, 5) + "               " + this.PagoOwner[i][j]);
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Resumen Generadores ");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Unidad             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallgen; ++j) {
                        if (!(Math.abs(this.PUnits[i][j]) > 0.0)) continue;
                        this.myPPrintStream.println(TPChilean.strformat(this.NomBra[i], 30) + "    " + TPChilean.strformat(this.NomGen[j], 30) + "    " + TPChilean.numformat(this.PUnits[i][j], 15, 5) + "               " + this.PagoUnits[i][j]);
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println("Resultado de Prorrateos Barra All\t\t\t");
                this.myPPrintStream.println("********************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("           Branch             -             Barra             -             Prorrateo             -             Pago");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(Math.abs(this.ProrrateoAll[i][j]) > 0.0)) continue;
                    }
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("*******************************************************");
                this.myPPrintStream.println("IMPRESI\u00d3N DE MATRICES DE FACTORES (Last Active Network)");
                this.myPPrintStream.println("*******************************************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GSDF MATRIX");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numactbran; ++i) {
                    for (j = 0; j < this.numactnod - 1; ++j) {
                        this.myPPrintStream.print("" + TPChilean.numformat(this.GSDF.getElement(i, j), 10, 5) + "  ");
                    }
                    this.myPPrintStream.println("" + TPChilean.numformat(this.GSDF.getElement(i, this.numactnod - 1), 10, 5));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GSDFLC MATRIX");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numactbran; ++i) {
                    for (j = 0; j < this.numactnod - 1; ++j) {
                        this.myPPrintStream.print("" + TPChilean.numformat(this.GSDFLC.getElement(i, j), 10, 3) + "  ");
                    }
                    this.myPPrintStream.println("" + TPChilean.numformat(this.GSDFLC.getElement(i, this.numactnod - 1), 10, 3));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("\u00c1rea de Influencia");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numactbran; ++i) {
                    for (j = 0; j < this.numactnod - 1; ++j) {
                        this.myPPrintStream.print("" + TPChilean.numformat(this.AI[i][j], 10, 3) + "  ");
                    }
                    this.myPPrintStream.println("" + TPChilean.numformat(this.AI[i][this.numactnod - 1], 10, 3));
                }
                System.out.println("Report File Done");
                System.out.println(" ");
            }
            this.closefile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closefile();
        }
        if (DBrep) {
            try {
                System.out.println("-Saving TPResDB ... ");
                System.out.println(" Time = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
                Connection conTPResDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
                if (conTPResDB == null) {
                    return;
                }
                Statement s = conTPResDB.createStatement();
                s.executeUpdate("DELETE * FROM Chilean_Barra");
                s.executeUpdate("DELETE * FROM Chilean_Empresa");
                s.executeUpdate("DELETE * FROM Chilean_Generador");
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallnod; ++j) {
                        if (!(this.Prorrateo[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Chilean_Barra (rama,barra,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomNod[j] + "'," + this.Prorrateo[i][j] + "," + this.PagoBarra[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallowner; ++j) {
                        if (!(this.OProrrateo[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Chilean_Empresa (rama,empresa,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomOwner[j] + "'," + this.OProrrateo[i][j] + "," + this.PagoOwner[i][j] + ")");
                    }
                }
                for (i = 0; i < this.numallbran; ++i) {
                    for (j = 0; j < this.numallgen; ++j) {
                        if (!(this.PUnits[i][j] > 1.0E-6)) continue;
                        s.executeUpdate("INSERT INTO Chilean_Generador (rama,generador,prorrata,pago) VALUES ('" + this.NomBra[i] + "','" + this.NomGen[j] + "'," + this.PUnits[i][j] + "," + this.PagoUnits[i][j] + ")");
                    }
                }
                System.out.println("");
                System.out.println("-TPResDB Saved ");
                s.close();
                conTPResDB.commit();
                conTPResDB.close();
            }
            catch (Exception e) {
                System.out.println("Error al Guardar Base de Datos " + e);
                e.printStackTrace();
            }
        }
        this.ActSchematic.setactperiod(this.actPeriod);
        this.ActSchematic.setactmonth(this.actMonth);
        this.ActSchematic.Modifiedstate = true;
        this.ActSchematic.Modified = true;
        this.ActSchematic.CheckActive();
        System.out.println("TOTAL EXECUTION TIME = " + TPChilean.numformat(((double)System.currentTimeMillis() - inicio) / 1000.0 / 60.0, 5, 2) + " [m]");
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/TPChilean.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
                e.printStackTrace();
            }
        }
        if (vis) {
            if (this.MyTPChileanVisualFrame == null) {
                this.MyTPChileanVisualFrame = new TPChileanVisualFrame(this, this.ctrla, false);
            } else {
                this.MyTPChileanVisualFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("TPChilean Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
        if (!vis) {
            this.finalize();
        }
    }

    public void InitAllNetwork(String lc) {
        int i;
        int j;
        int i2;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int ix = 0;
        this.numallnod = 0;
        this.numalllin = 0;
        this.numalltrafo = 0;
        this.numallbran = 0;
        this.numallgen = 0;
        this.numalllast = 0;
        this.numallowner = 0;
        Vector OwnVector = new Vector();
        if (this.BusbarVectorALL != null) {
            this.BusbarVectorALL = null;
        }
        this.BusbarVectorALL = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorALL.addElement(TempComponent);
                TempBusbar = (Busbar)TempComponent;
                ++this.numallnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numalllin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numalltrafo;
                }
                ++this.numallbran;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                ++this.numallgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numalllast;
        }
        this.NomBra = new String[this.numallbran];
        this.NomLin = new String[this.numalllin];
        this.NomTra = new String[this.numalltrafo];
        this.NomGen = new String[this.numallgen];
        this.NomLas = new String[this.numalllast];
        this.NomNod = new String[this.numallnod];
        this.LosOwner = new String[this.numallgen];
        this.PLA1 = new double[this.numallbran];
        this.PLA2 = new double[this.numallbran];
        this.PLA3 = new double[this.numallbran];
        this.AVNR_COyM = new double[this.numallbran];
        this.PagoBarra = new double[this.numallbran][this.numallnod];
        this.acumAllFlujo = new double[this.numallbran];
        this.AllBranchI = new int[this.numallbran];
        this.AllBranchJ = new int[this.numallbran];
        this.simDuration = new double[this.numallbran];
        this.zimDuration = new double[this.numallbran];
        this.minAllFlujo = new double[this.numallbran];
        this.maxAllFlujo = new double[this.numallbran];
        this.varAllFlujo = new double[this.numallbran];
        for (i2 = 0; i2 < this.numallbran; ++i2) {
            this.acumAllFlujo[i2] = 0.0;
            this.AllBranchI[i2] = -1;
            this.AllBranchJ[i2] = -1;
            this.simDuration[i2] = 0.0;
            this.zimDuration[i2] = 0.0;
            this.minAllFlujo[i2] = 1000000.0;
            this.maxAllFlujo[i2] = -1000000.0;
            this.varAllFlujo[i2] = 0.0;
        }
        this.medAllGen = new double[this.numallgen];
        this.maxAllGen = new double[this.numallgen];
        this.minAllGen = new double[this.numallgen];
        this.varAllGen = new double[this.numallgen];
        this.genDuration = new double[this.numallgen];
        for (i2 = 0; i2 < this.numallgen; ++i2) {
            this.medAllGen[i2] = 0.0;
            this.maxAllGen[i2] = -100000.0;
            this.minAllGen[i2] = 100000.0;
            this.varAllGen[i2] = 0.0;
        }
        this.medAllLas = new double[this.numalllast];
        this.maxAllLas = new double[this.numalllast];
        this.minAllLas = new double[this.numalllast];
        this.varAllLas = new double[this.numalllast];
        this.lasDuration = new double[this.numalllast];
        for (i2 = 0; i2 < this.numalllast; ++i2) {
            this.medAllLas[i2] = 0.0;
            this.maxAllLas[i2] = -100000.0;
            this.minAllLas[i2] = 100000.0;
            this.varAllLas[i2] = 0.0;
        }
        this.medAllpg = new double[this.numallnod];
        this.maxAllpg = new double[this.numallnod];
        this.minAllpg = new double[this.numallnod];
        this.varAllpg = new double[this.numallnod];
        this.pgDuration = new double[this.numallnod];
        for (i2 = 0; i2 < this.numallnod; ++i2) {
            this.medAllpg[i2] = 0.0;
            this.maxAllpg[i2] = -100000.0;
            this.minAllpg[i2] = 100000.0;
            this.varAllpg[i2] = 0.0;
        }
        DoubleSquareMatrix MatXXall = new DoubleSquareMatrix(this.numallnod - 1);
        this.MatXAll = new DoubleSquareMatrix(this.numallnod);
        this.GSDFAll = new DoubleMatrix(this.numallbran, this.numallnod);
        this.GSDFSAll = new DoubleMatrix(this.numallbran, this.numallnod);
        this.GGDFAll = new DoubleMatrix(this.numallbran, this.numallnod);
        this.GSDFLCAll = new DoubleMatrix(this.numallbran, this.numallnod);
        this.AllBranchX = new double[this.numallbran];
        this.ProrrateoAll = new double[this.numallbran][this.numallnod];
        this.AProrrateoAll = new double[this.numallbran][this.numallnod];
        this.PUnitsAll = new double[this.numallbran][this.numallnod];
        this.APUnitsAll = new double[this.numallbran][this.numallnod];
        this.PGenUnitsAll = new double[this.numallgen][this.numallnod];
        this.PGenOwnAll = new double[this.numallgen][this.numallnod];
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countLas = 0;
        int countNod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.NomNod[countNod] = TempBusbar.getName();
                ++countNod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    this.AVNR_COyM[countBra] = TempLine.getannuity(this.ActSchematic.intrate);
                    this.NomLin[countLin] = TempLine.getName();
                    this.NomBra[countBra] = TempLine.getName();
                    this.AllBranchI[countBra] = this.numbusALL(TempLine.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempLine.getcon2());
                    this.AllBranchX[countBra] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                    ++countLin;
                }
                if (TempComponent instanceof Trafo) {
                    double treac;
                    Trafo TempTrafo = (Trafo)TempComponent;
                    this.NomTra[countTra] = TempTrafo.getName();
                    this.NomBra[countBra] = TempTrafo.getName();
                    this.AVNR_COyM[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate);
                    this.AllBranchI[countBra] = this.numbusALL(TempTrafo.getcon1());
                    this.AllBranchJ[countBra] = this.numbusALL(TempTrafo.getcon2());
                    double tueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    double tres = TempTrafo.getpcu() * 0.001 * tueb * tueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    double tz = TempTrafo.getuk() * 0.01 * tueb * tueb * this.sref / TempTrafo.getsn();
                    this.AllBranchX[countBra] = treac = Math.sqrt(tz * tz - tres * tres);
                    ++countTra;
                }
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.NomGen[countGen] = TempGenerator.getName();
                this.LosOwner[countGen] = TempGenerator.getinv_owner();
                ++countGen;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.NomLas[countLas] = TempLoad.getName();
            ++countLas;
        }
        int aux = 0;
        if (this.numallgen >= 2) {
            for (int i3 = 0; i3 < this.numallgen; ++i3) {
                aux = 0;
                for (int j2 = i3 + 1; j2 < this.numallgen; ++j2) {
                    if (!this.LosOwner[i3].equals(this.LosOwner[j2])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                ++this.numallowner;
            }
        } else {
            this.numallowner = this.numallgen;
        }
        this.OProrrateo = new double[this.numallbran][this.numallowner];
        this.OFrecuencia = new int[this.numallbran][this.numallowner];
        this.Prorrateo = new double[this.numallbran][this.numallnod];
        this.Frecuencia = new int[this.numallbran][this.numallnod];
        this.NomOwner = new String[this.numallowner];
        this.PagoOwner = new double[this.numallbran][this.numallowner];
        this.OProrrateoAll = new double[this.numallbran][this.numallowner];
        this.AOProrrateoAll = new double[this.numallbran][this.numallowner];
        this.PUnits = new double[this.numallbran][this.numallgen];
        this.FUnits = new int[this.numallbran][this.numallgen];
        this.PagoUnits = new double[this.numallbran][this.numallgen];
        aux = 0;
        int cmul = 0;
        if (this.numallgen >= 2) {
            for (int i4 = 0; i4 < this.numallgen; ++i4) {
                aux = 0;
                for (j = i4 + 1; j < this.numallgen; ++j) {
                    if (!this.LosOwner[i4].equals(this.LosOwner[j])) continue;
                    ++aux;
                }
                if (aux != 0) continue;
                this.NomOwner[cmul] = this.LosOwner[i4];
                ++cmul;
            }
        } else {
            this.NomOwner[0] = this.LosOwner[0];
        }
        for (int i5 = 0; i5 < this.numallbran; ++i5) {
            this.simDuration[i5] = 0.0;
            this.zimDuration[i5] = 0.0;
            for (int jj = 0; jj < this.numallowner; ++jj) {
                this.OProrrateo[i5][jj] = 0.0;
                this.OFrecuencia[i5][jj] = 0;
            }
            for (j = 0; j < this.numallnod; ++j) {
                this.Prorrateo[i5][j] = 0.0;
                this.Frecuencia[i5][j] = 0;
            }
            for (j = 0; j < this.numallgen; ++j) {
                this.PUnits[i5][j] = 0.0;
                this.FUnits[i5][j] = 0;
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            double reac = this.AllBranchX[countD];
            for (i = 0; i < this.numallnod - 1; ++i) {
                double y1 = this.MatXAll.getElement(this.AllBranchI[countD], i);
                double y2 = this.MatXAll.getElement(this.AllBranchJ[countD], i);
                this.GSDFAll.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (this.slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (int i6 = 0; i6 < this.numallbran; ++i6) {
                for (int j3 = 0; j3 < this.numallnod; ++j3) {
                    this.GSDFSAll.setElement(i6, j3, this.GSDFAll.getElement(i6, j3) - this.GSDFAll.getElement(i6, this.slack));
                }
            }
        }
        int slc = this.numbusALL(lc);
        if (slc == -1) {
            System.out.println("Load Center bad defined, It must be active in all dispatches");
        } else {
            for (i = 0; i < this.numallbran; ++i) {
                for (int j4 = 0; j4 < this.numallnod; ++j4) {
                    this.GSDFLCAll.setElement(i, j4, this.GSDFAll.getElement(i, j4) - this.GSDFAll.getElement(i, slc));
                }
            }
        }
    }

    public void build_Injection(int ano, int mes, int bloque, int hidro, boolean HydroDBa) {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int countG = 0;
        int countL = 0;
        int IdDespActual = ((ano - this.InitialYearDB) * 12 + (mes - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (bloque - 1) * this.HydroNumberDB + hidro;
        this.PDCLF = new double[this.numactnod];
        for (i = 0; i < this.numactnod; ++i) {
            int k;
            this.PDCLF[i] = 0.0;
            this.node_pg[i] = 0.0;
            for (k = 0; k < this.numactowner; ++k) {
                this.PGenOwn[k][i] = 0.0;
            }
            for (k = 0; k < this.numactgen; ++k) {
                this.PGenUnits[k][i] = 0.0;
            }
        }
        this.TotGen = 0.0;
        this.TotDem = 0.0;
        int NroDdaActual = -1;
        int NroDdaActual2 = -1;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Generator)) continue;
            Generator TempGenerator = (Generator)TempComponent;
            block4: for (i = 0; i < this.dimDBGen; ++i) {
                if (!this.NameGenDB[i].equals(TempGenerator.getName()) || this.IdDespDB[i] != IdDespActual) continue;
                int n = this.GenNode[countG];
                this.PDCLF[n] = this.PDCLF[n] + this.PDB[i] / this.sref;
                int n2 = this.GenNode[countG];
                this.node_pg[n2] = this.node_pg[n2] + this.PDB[i];
                this.TotGen += this.PDB[i];
                this.actGen[countG] = this.PDB[i];
                double[] dArray = this.PGenUnits[countG];
                int n3 = this.GenNode[countG];
                dArray[n3] = dArray[n3] + this.PDB[i];
                for (int k = 0; k < this.numactowner; ++k) {
                    if (!this.NomActOwner[k].equals(TempGenerator.getinv_owner())) continue;
                    double[] dArray2 = this.PGenOwn[k];
                    int n4 = this.GenNode[countG];
                    dArray2[n4] = dArray2[n4] + this.PDB[i];
                    break block4;
                }
                break;
            }
            ++countG;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            if (HydroDBa) {
                NroDdaActual = this.BlockNumberDB * (mes - 1) + bloque;
                for (i = 0; i < this.dimDBLoad; ++i) {
                    if (!this.NameLDB[i].equals(TempLoad.getName())) continue;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1] / this.sref;
                    this.actLas[countL] = this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                    this.TotDem += this.PLDB[i][NroDdaActual - 1] * this.TotDemDB[ano - this.InitialYearDB][NroDdaActual - 1];
                    break;
                }
            } else {
                NroDdaActual2 = 12 * (ano - this.InitialYearDB) + mes;
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    if (!this.NameLDB2[i].equals(TempLoad.getName())) continue;
                    int n = this.LasNode[countL];
                    this.PDCLF[n] = this.PDCLF[n] - this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen / this.sref;
                    this.TotDem += this.PLDB2[i][NroDdaActual2 - 1] * this.TotGen;
                    break;
                }
            }
            ++countL;
        }
    }

    public void build_GDF(double[] flux, double[] pg) {
        int i = 0;
        int j = 0;
        double PGges = 0.0;
        double[] vec_DrefG = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            vec_DrefG[i] = 0.0;
        }
        for (i = 0; i < this.numactnod; ++i) {
            PGges += pg[i];
        }
        i = 0;
        while (i < this.numactbran) {
            vec_DrefG[i] = flux[i] * this.sref;
            for (j = 0; j < this.numactnod; ++j) {
                int n = i;
                vec_DrefG[n] = vec_DrefG[n] - this.GSDFS.getElement(i, j) * pg[j];
            }
            int n = i++;
            vec_DrefG[n] = vec_DrefG[n] / PGges;
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GGDF.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.GGDF.setElement(i, j, this.GSDFS.getElement(i, j) + vec_DrefG[i]);
            }
        }
    }

    public void build_Participa(double[] flux, double[] pg) {
        int k;
        int i = 0;
        int j = 0;
        double[][] AGEN = new double[this.numactbran][this.numactnod];
        double[][] GGDFGEN = new double[this.numactbran][this.numactnod];
        double[] PFAF = new double[this.numactbran];
        double[] PFGDFF = new double[this.numactbran];
        this.AI = new double[this.numactbran][this.numactnod];
        double[] NAI = new double[this.numactbran];
        for (i = 0; i < this.numactbran; ++i) {
            PFAF[i] = 0.0;
            PFGDFF[i] = 0.0;
            NAI[i] = 0.0;
            for (j = 0; j < this.numactnod; ++j) {
                AGEN[i][j] = 0.0;
                GGDFGEN[i][j] = 0.0;
                this.AI[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                if (pg[j] > 0.0 && this.GSDFLC.getElement(i, j) * flux[i] > 0.0) {
                    AGEN[i][j] = this.GSDFLC.getElement(i, j);
                    this.AI[i][j] = 1.0;
                    int n = i;
                    NAI[n] = NAI[n] + pg[j];
                } else {
                    AGEN[i][j] = 0.0;
                    this.AI[i][j] = 0.0;
                }
                GGDFGEN[i][j] = pg[j] > 0.0 && this.GGDF.getElement(i, j) * flux[i] > 0.0 ? this.GGDF.getElement(i, j) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                if (AGEN[i][j] > 1.0) {
                    AGEN[i][j] = 1.0;
                }
                if (AGEN[i][j] < -1.0) {
                    AGEN[i][j] = -1.0;
                }
                PFAF[i] = PFAF[i] + AGEN[i][j] * pg[j];
                if (GGDFGEN[i][j] > 1.0) {
                    GGDFGEN[i][j] = 1.0;
                }
                if (GGDFGEN[i][j] < -1.0) {
                    GGDFGEN[i][j] = -1.0;
                }
                PFGDFF[i] = PFGDFF[i] + GGDFGEN[i][j] * pg[j];
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                this.ProrrateoAct[i][j] = Math.abs(NAI[i]) > 1.0E-6 ? Math.abs(this.AI[i][j] * pg[j] / NAI[i] * 100.0) : 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (k = 0; k < this.numactowner; ++k) {
                this.OProrrateoAct[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.numactbran; ++i) {
            for (j = 0; j < this.numactnod; ++j) {
                for (k = 0; k < this.numactowner; ++k) {
                    if (!(pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.OProrrateoAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PGenOwn[k][j] / pg[j];
                }
                for (k = 0; k < this.numactgen; ++k) {
                    if (!(pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.PUnitsAct[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAct[i][j] * this.PGenUnits[k][j] / pg[j];
                }
            }
        }
    }

    public void build_Participa2(double[] flux, double[] pg) {
        int k;
        int i = 0;
        int j = 0;
        double[][] AGEN = new double[this.numallbran][this.numallnod];
        double[][] GGDFGEN = new double[this.numallbran][this.numallnod];
        double[] PFAF = new double[this.numallbran];
        double[] PFGDFF = new double[this.numallbran];
        this.AIAll = new double[this.numallbran][this.numallnod];
        double[] NAIAll = new double[this.numallbran];
        for (i = 0; i < this.numallbran; ++i) {
            PFAF[i] = 0.0;
            PFGDFF[i] = 0.0;
            NAIAll[i] = 0.0;
            for (j = 0; j < this.numallnod; ++j) {
                AGEN[i][j] = 0.0;
                GGDFGEN[i][j] = 0.0;
                this.AIAll[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (j = 0; j < this.numallnod; ++j) {
                if (pg[j] > 0.0 && this.GSDFLCAll.getElement(i, j) * flux[i] > 0.0) {
                    AGEN[i][j] = this.GSDFLCAll.getElement(i, j);
                    this.AIAll[i][j] = 1.0;
                    int n = i;
                    NAIAll[n] = NAIAll[n] + pg[j];
                    continue;
                }
                AGEN[i][j] = 0.0;
                this.AIAll[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (j = 0; j < this.numallnod; ++j) {
                if (AGEN[i][j] > 1.0) {
                    AGEN[i][j] = 1.0;
                }
                if (AGEN[i][j] < -1.0) {
                    AGEN[i][j] = -1.0;
                }
                PFAF[i] = PFAF[i] + AGEN[i][j] * pg[j];
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (j = 0; j < this.numallnod; ++j) {
                this.ProrrateoAll[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (j = 0; j < this.numallnod; ++j) {
                this.ProrrateoAll[i][j] = Math.abs(NAIAll[i]) > 1.0E-6 ? Math.abs(this.AIAll[i][j] * pg[j] / NAIAll[i] * 100.0) : 0.0;
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (k = 0; k < this.numallowner; ++k) {
                this.OProrrateoAll[i][k] = 0.0;
            }
        }
        for (i = 0; i < this.numallbran; ++i) {
            for (j = 0; j < this.numallnod; ++j) {
                for (k = 0; k < this.numallowner; ++k) {
                    if (!(pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.OProrrateoAll[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAll[i][j] * this.PGenOwnAll[k][j] / pg[j];
                }
                for (k = 0; k < this.numallgen; ++k) {
                    if (!(pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.PUnitsAll[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.ProrrateoAll[i][j] * this.PGenUnitsAll[k][j] / pg[j];
                }
            }
        }
    }

    public void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa, boolean HydroDBa) {
        int i = 0;
        int j = 0;
        try {
            System.out.println("Loading TPDB Information ...");
            this.conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB", true);
            Statement s = this.conTPDB.createStatement();
            if (this.NameGenDB != null && this.IdDespDB != null && this.PDB != null && this.NameLDB != null && this.PLDB != null) {
                System.out.println("TPDB already loaded, original parameters will be used");
                return;
            }
            ResultSet r4 = s.executeQuery("SELECT *\tFROM SimInfo");
            r4.next();
            this.InitialYearDB = r4.getInt("InitialYear");
            this.InitialMonthDB = r4.getInt("InitialMonth");
            this.YearNumberDB = r4.getInt("YearNumber");
            this.BlockNumberDB = r4.getInt("BlockNumber");
            this.HydroNumberDB = r4.getInt("HydroNumber");
            this.FinalYearDB = this.InitialYearDB + this.YearNumberDB;
            this.FinalMonthDB = this.InitialMonthDB == 1 ? 12 : this.InitialMonthDB - 1;
            String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
            this.year1 = Integer.parseInt(SDYa);
            this.year2 = Integer.parseInt(EDYa);
            for (i = 0; i < 12; ++i) {
                if (mes[i].equals(SDMa)) {
                    this.month1 = i + 1;
                }
                if (!mes[i].equals(EDMa)) continue;
                this.month2 = i + 1;
            }
            this.block1 = Integer.parseInt(SDBa);
            this.hidro1 = Integer.parseInt(SDHa);
            this.block2 = Integer.parseInt(EDBa);
            this.hidro2 = Integer.parseInt(EDHa);
            this.flow1 = ((this.year1 - this.InitialYearDB) * 12 + (this.month1 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block1 - 1) * this.HydroNumberDB + this.hidro1;
            this.flow2 = ((this.year2 - this.InitialYearDB) * 12 + (this.month2 - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (this.block2 - 1) * this.HydroNumberDB + this.hidro2;
            if (this.flow2 < this.flow1) {
                System.out.println(" Cuidado: Las fechas est\u00e1n en orden inverso!");
                int mulanga = this.flow2;
                this.flow2 = this.flow1;
                this.flow1 = mulanga;
                System.out.println(" ........ Problema resuelto autom\u00e1ticamente (inverse selection)");
            }
            int tflo = this.YearNumberDB * 12 * this.BlockNumberDB * this.HydroNumberDB;
            System.out.println(" ");
            System.out.println("Flow Selection Details");
            System.out.println("----------------------");
            System.out.println("Total DB flows  :    " + tflo);
            System.out.println("Total DB years  :    " + this.YearNumberDB);
            System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
            System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
            System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
            System.out.println("Inicio          :" + TPChilean.numformat(this.year1, 8) + "/" + TPChilean.numformat(this.month1, 8) + "/" + TPChilean.numformat(this.block1, 8) + "/" + TPChilean.numformat(this.hidro1, 8) + "/" + TPChilean.numformat(this.flow1, 8));
            System.out.println("Final           :" + TPChilean.numformat(this.year2, 8) + "/" + TPChilean.numformat(this.month2, 8) + "/" + TPChilean.numformat(this.block2, 8) + "/" + TPChilean.numformat(this.hidro2, 8) + "/" + TPChilean.numformat(this.flow2, 8));
            System.out.println(" ");
            this.ndem = this.BlockNumberDB * 12;
            this.blockTime = new double[this.ndem];
            ResultSet r0 = s.executeQuery("SELECT *\tFROM blockTime");
            r0.next();
            for (j = 1; j <= this.ndem; ++j) {
                this.blockTime[j - 1] = r0.getDouble("d" + j);
            }
            ResultSet r1 = s.executeQuery("SELECT IdDesp\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 123456.0;
            }
            r1 = s.executeQuery("SELECT *\tFROM generator   WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (r1.next()) {
                this.NameGenDB[i] = r1.getString("name");
                this.IdDespDB[i] = r1.getInt("IdDesp");
                this.PDB[i] = r1.getDouble("p");
                ++i;
            }
            if (HydroDBa) {
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad = i;
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                for (i = 0; i < this.dimDBLoad; ++i) {
                    this.NameLDB[i] = "nada";
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.PLDB[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
                ResultSet r3 = s.executeQuery("SELECT Year\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    ++i;
                }
                this.dimDBYear = i;
                this.TotDemDB = new double[this.dimDBYear][this.ndem];
                this.HidYearNameLDB = new int[this.dimDBYear];
                for (i = 0; i < this.dimDBYear; ++i) {
                    this.HidYearNameLDB[i] = 1;
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = 123456.0;
                    }
                }
                r3 = s.executeQuery("SELECT *\tFROM loadPower   ORDER BY Year");
                i = 0;
                while (r3.next()) {
                    this.HidYearNameLDB[i] = r3.getInt("Year");
                    for (j = 1; j <= this.ndem; ++j) {
                        this.TotDemDB[i][j - 1] = r3.getDouble("d" + j);
                    }
                    ++i;
                }
            } else {
                this.ndem2 = this.YearNumberDB * 12;
                ResultSet r2 = s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    ++i;
                }
                this.dimDBLoad2 = i;
                this.NameLDB2 = new String[this.dimDBLoad2];
                this.PLDB2 = new double[this.dimDBLoad2][this.ndem2];
                for (i = 0; i < this.dimDBLoad2; ++i) {
                    this.NameLDB2[i] = "nada";
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = 123456.0;
                    }
                }
                r2 = s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                i = 0;
                while (r2.next()) {
                    this.NameLDB2[i] = r2.getString("name");
                    for (j = 1; j <= this.ndem2; ++j) {
                        this.PLDB2[i][j - 1] = r2.getDouble("d" + j);
                    }
                    ++i;
                }
            }
            s.close();
            this.conTPDB.rollback();
            this.conTPDB.close();
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace();
        }
    }

    public boolean Plan_Obra(int nano, int nmes) {
        int count = 0;
        int y1 = 1900;
        int m1 = 1;
        int y2 = 2020;
        int m2 = 12;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_comp TempNdb_comp = (ndb_comp)TempComponent;
            y1 = TempNdb_comp.getentry_period();
            m1 = TempNdb_comp.getentry_month();
            if (y1 == nano && m1 == nmes) {
                return true;
            }
            y2 = TempNdb_comp.getexit_period();
            m2 = TempNdb_comp.getexit_month();
            int rmes = nmes;
            int rano = nano;
            if (rmes == 1) {
                rmes = 12;
                --rano;
            } else if (rmes >= 2 && rmes <= 12) {
                --rmes;
            }
            if (y2 == rano && m2 == rmes) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void GetActiveNetwork(String lc) {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        int slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        boolean countlas = false;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numactnod = 0;
        this.numactlin = 0;
        this.numacttrafo = 0;
        this.numactbran = 0;
        this.numactgen = 0;
        this.numactlast = 0;
        this.numactowner = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numactnod;
                continue;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    ++this.numactlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numacttrafo;
                }
                ++this.numactbran;
                continue;
            }
            if (TempComponent instanceof Generator) {
                ++this.numactgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numactlast;
        }
        if (this.NomActBra != null || this.NomActLin != null || this.NomActTra != null || this.NomActGen != null || this.NomActLas != null || this.NomActNod != null || this.BranchR != null || this.BranchX != null || this.BranchI != null || this.BranchI != null || this.BranchJ != null || this.node_pg != null || this.Flujo != null || this.GenNode != null || this.LasNode != null) {
            this.NomActBra = null;
            this.NomActLin = null;
            this.NomActTra = null;
            this.NomActGen = null;
            this.NomActLas = null;
            this.NomActNod = null;
            this.BranchR = null;
            this.BranchX = null;
            this.BranchI = null;
            this.BranchJ = null;
            this.node_pg = null;
            this.Flujo = null;
            this.GenNode = null;
            this.LasNode = null;
        }
        this.NomActBra = new String[this.numactbran];
        this.NomActLin = new String[this.numactlin];
        this.NomActTra = new String[this.numacttrafo];
        this.NomActGen = new String[this.numactgen];
        this.NomActLas = new String[this.numactlast];
        this.NomActNod = new String[this.numactnod];
        this.BranchR = new double[this.numactbran];
        this.BranchX = new double[this.numactbran];
        this.BranchI = new int[this.numactbran];
        this.BranchJ = new int[this.numactbran];
        this.node_pg = new double[this.numactnod];
        this.Flujo = new double[this.numactbran];
        this.GenNode = new int[this.numactgen];
        this.LasNode = new int[this.numactlast];
        this.MatX = new DoubleSquareMatrix(this.numactnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numactnod);
        this.LosActOwner = new String[this.numactgen];
        this.acumActFlujo = new double[this.numactbran];
        this.minActFlujo = new double[this.numactbran];
        this.maxActFlujo = new double[this.numactbran];
        this.varActFlujo = new double[this.numactbran];
        this.medActGen = new double[this.numactgen];
        this.maxActGen = new double[this.numactgen];
        this.minActGen = new double[this.numactgen];
        this.varActGen = new double[this.numactgen];
        this.actGen = new double[this.numactgen];
        this.medActLas = new double[this.numactlast];
        this.maxActLas = new double[this.numactlast];
        this.minActLas = new double[this.numactlast];
        this.varActLas = new double[this.numactlast];
        this.actLas = new double[this.numactlast];
        this.medActpg = new double[this.numactnod];
        this.maxActpg = new double[this.numactnod];
        this.minActpg = new double[this.numactnod];
        this.varActpg = new double[this.numactnod];
        this.actpg = new double[this.numactnod];
        for (ixi = 0; ixi < this.numactnod; ++ixi) {
            this.node_pg[ixi] = 0.0;
            for (int colu = 0; colu < this.numactnod; ++colu) {
                this.MatX.setElement(ixi, colu, 0.0);
                MatY.setElement(ixi, colu, 0.0);
            }
        }
        for (ixi = 0; ixi < this.numactbran; ++ixi) {
            this.Flujo[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        boolean[] OwnGen = new boolean[this.numactgen];
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numactnod - 1);
        this.GSDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFS = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GGDF = new DoubleMatrix(this.numactbran, this.numactnod);
        this.GSDFLC = new DoubleMatrix(this.numactbran, this.numactnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActLin[countLin] = TempLine.getName();
                this.NomActBra[countBra] = TempLine.getName();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.NomActTra[countTra] = TempTrafo.getName();
                this.NomActBra[countBra] = TempTrafo.getName();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                this.GenNode[countGen] = this.numbus(TempGenerator.getcon2());
                this.NomActGen[countGen] = TempGenerator.getName();
                this.LosActOwner[countGen] = TempGenerator.getinv_owner();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    slack = this.numbus(TempGenerator.getcon2());
                    this.slackGenerator = countGen;
                    this.slackNode = slack;
                    this.nomSlackOwner = TempGenerator.getinv_owner();
                    System.out.println(" ");
                    System.out.println("slack name   = " + TempComponent.getName());
                    System.out.println("slack number = " + slack);
                    System.out.println("slack Owner  = " + this.nomSlackOwner);
                }
                ++count1;
                ++countGen;
                continue;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countLas] = this.numbus(TempLoad.getcon2());
                this.NomActLas[countLas] = TempLoad.getName();
                ++countLas;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomActNod[countNod] = TempBusbar.getName();
            ++countNod;
        }
        int auxact = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numactowner;
            }
        } else {
            this.numactowner = this.numactgen;
        }
        this.PGenOwn = new double[this.numactowner][this.numactnod];
        this.NomActOwner = new String[this.numactowner];
        this.PGenUnits = new double[this.numactgen][this.numactnod];
        auxact = 0;
        int mulina = 0;
        if (this.numactgen >= 2) {
            for (i = 0; i < this.numactgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numactgen; ++j) {
                    if (!this.LosActOwner[i].equals(this.LosActOwner[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomActOwner[mulina] = this.LosActOwner[i];
                ++mulina;
            }
        } else {
            this.NomActOwner[0] = this.LosActOwner[0];
        }
        for (i = 0; i < this.numactowner; ++i) {
            if (!this.NomActOwner[i].equals(this.nomSlackOwner)) continue;
            this.slackOwner = i;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numactnod - 1; ++ii) {
            for (int jj = 0; jj < this.numactnod - 1; ++jj) {
                MatXX.setElement(ii, jj, MatY.getElement(ii, jj));
            }
        }
        System.out.println(" ");
        System.out.println("Inverting MatXX Matrix");
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        System.out.println("MatXX Matrix Inverted");
        for (i = 0; i < this.numactnod - 1; ++i) {
            for (j = 0; j < this.numactnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numactnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slack));
                }
            }
        }
        int slc = this.numbus(lc);
        if (slc == -1) {
            System.out.println("Load Center bad defined, It must be active in all dispatches");
        } else {
            for (i = 0; i < this.numactbran; ++i) {
                for (j = 0; j < this.numactnod; ++j) {
                    this.GSDFLC.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, slc));
                }
            }
        }
    }

    public void finalize() {
        this.GenNode = null;
        this.LasNode = null;
        this.node_pg = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.NomBra = null;
        this.NomLin = null;
        this.NomTra = null;
        this.NomGen = null;
        this.NomNod = null;
        this.NomLas = null;
        this.GSDF = null;
        this.GSDFS = null;
        this.GGDF = null;
        this.ProrrateoAct = null;
        this.Prorrateo = null;
        this.MatX = null;
        this.myPPrintStream = null;
        this.os = null;
        this.Flujo = null;
        this.PDCLF = null;
    }

    private int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return -1;
    }

    public int numbusALL(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorALL.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorALL.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
    }
}

