/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.BarChart;
import de.core.DeepEdit;
import java.awt.Button;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class TPBarFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    TPBarFrame(String titulo, int dim, String[] barName, double[] barValue) {
        super("TP Graphic Options");
        this.setBackground(SystemColor.control);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        int newDim = 0;
        int i = -1;
        int j = -1;
        for (i = 0; i < dim; ++i) {
            if (!(Math.abs(barValue[i]) > 5.0)) continue;
            ++newDim;
        }
        if (newDim == 0) {
            this.setVisible(false);
            this.dispose();
        }
        String[] newBarName = new String[newDim];
        double[] newBarValue = new double[newDim];
        j = 0;
        for (i = 0; i < dim; ++i) {
            if (!(Math.abs(barValue[i]) > 5.0)) continue;
            newBarName[j] = barName[i];
            newBarValue[j] = barValue[i];
            ++j;
        }
        double auxd = -1.0;
        String auxs = "none";
        for (j = 0; j < newDim + 1; ++j) {
            for (i = 0; i < newDim - 1; ++i) {
                if (!(newBarValue[i] < newBarValue[i + 1])) continue;
                auxd = newBarValue[i];
                auxs = newBarName[i];
                newBarValue[i] = newBarValue[i + 1];
                newBarName[i] = newBarName[i + 1];
                newBarValue[i + 1] = auxd;
                newBarName[i + 1] = auxs;
            }
        }
        BarChart myChart = new BarChart(newDim);
        myChart.setSampleValues(0, newBarValue);
        myChart.setLowerRange(1, myChart.getMinValue(0));
        myChart.setRange(1, Math.abs(myChart.getMaxValue(0)));
        myChart.setRangeLabelsOn(true);
        myChart.setTitle(titulo);
        myChart.setSampleLabels(newBarName);
        myChart.setSeriesLabels(newBarName);
        myChart.setMultiSeriesOn(false);
        myChart.setBarWidth(0.6);
        myChart.set3DModeOn(true);
        myChart.set3DDepth(7);
        myChart.setTitleOn(true);
        myChart.setLegendOn(false);
        myChart.setValueLabelsOn(true);
        myChart.setLegendOn(true);
        myChart.setSampleScrollerOn(true);
        myChart.setRangeAdjusterOn(1, true);
        myChart.setRangeLabelsOn(true);
        myChart.setMultiColorOn(true);
        myChart.setBarLabelsOn(true);
        myChart.setBarLabelStyle(1);
        myChart.setPreferredSize(600, 300);
        this.add("Center", myChart);
        Button button2 = new Button("      EXIT     ");
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        this.add("South", button2);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TPBarFrame.this.setVisible(false);
                TPBarFrame.this.dispose();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            this.dispose();
        }
    }

    public static String strformat(String cad, int ltot) {
        String cadmod = cad;
        if (cad.length() < ltot) {
            for (int i = cad.length(); i < ltot; ++i) {
                cadmod = cadmod + " ";
            }
        }
        return cadmod;
    }
}

