/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.Schematic;
import de.core.TPFrame;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public abstract class TP
extends AnalysisTool {
    TPFrame MyTPFrame = null;
    Connection conTPDB = DeepEdit.OpenODBC_JDBCConnection("TPDB_v3.3", true);
    int InitialYearDB = -1;
    int InitialMonthDB = -1;
    int FinalYearDB = -1;
    int FinalMonthDB = -1;
    int BlockNumberDB = -1;
    int HydroNumberDB = -1;
    int YearNumberDB = -1;
    int MonthNumberDB = -1;
    int TotalMonthsDB = -1;
    int year1;
    int year2;
    int month1;
    int month2;
    int block1;
    int block2;
    int hidro1;
    int hidro2;
    String[] NameGenDB;
    String[] NameFlowDB;
    String[] NameCMgDB;
    String[] NamePeajeDB;
    int[] IdDespDB;
    int[] IdDespDBFlow;
    int[] IdDespDBCMg;
    int[] IdBlockDBPeaje;
    double[] PDB;
    double[] FlowDB;
    double[] CMgDB;
    double[] PeajeDB;
    String[] NameLDB;
    String[] NameLDB2;
    double[][] PLDB;
    double[][] PLDB2;
    double[][] TotDemDB;
    int[] auxBpM;
    int[] bloquesPorMes;
    int[] HidYearNameLDB;
    int dimDBGen;
    int dimDBFlow;
    int dimDBCMg;
    int dimDBPeaje;
    int dimDBLoad;
    int dimDBLoad2;
    int dimDBYear;
    int ndem;
    int ndem2;
    double[] blockTime;
    HashMap<String, Integer> ht_dem = null;
    int flow1;
    int flow2;
    Statement s = null;
    ResultSet r = null;
    boolean directDx = false;

    TP(Schematic sch) {
        super(sch);
    }

    protected boolean existTPDB() {
        try {
            this.s = this.conTPDB.createStatement();
            this.r = this.s.executeQuery("SELECT InitialYear FROM SimInfo");
            this.r.next();
            this.InitialYearDB = this.r.getInt(1);
            System.out.println("InitialYearDB = " + this.InitialYearDB);
            this.r = this.s.executeQuery("SELECT YEAR(MAX(blockTime.iniDate)) FROM blockTime");
            this.r.next();
            this.FinalYearDB = this.r.getInt(1);
            System.out.println("FinalYearDB = " + this.FinalYearDB);
            this.r = this.s.executeQuery("SELECT InitialMonth FROM SimInfo");
            this.r.next();
            this.InitialMonthDB = this.r.getInt(1);
            System.out.println("InitialMonthDB =" + this.InitialMonthDB);
            this.r = this.s.executeQuery("SELECT MONTH(MAX(blockTime.iniDate)) FROM blockTime");
            this.r.next();
            this.FinalMonthDB = this.r.getInt(1);
            System.out.println("FinalMonthDB =" + this.FinalMonthDB);
            this.TotalMonthsDB = (this.FinalYearDB - this.InitialYearDB - 1) * 12 + 12 + 1 - this.InitialMonthDB + this.FinalMonthDB;
            this.r = this.s.executeQuery("SELECT BlockNumber FROM SimInfo");
            this.r.next();
            this.BlockNumberDB = this.r.getInt(1);
            this.r = this.s.executeQuery("SELECT HydroNumber FROM SimInfo");
            this.r.next();
            this.HydroNumberDB = this.r.getInt(1);
            System.out.println("HydroNumberDB =" + this.HydroNumberDB);
            this.auxBpM = new int[this.TotalMonthsDB];
            this.bloquesPorMes = new int[this.TotalMonthsDB];
            int y = this.InitialYearDB;
            int m = this.InitialMonthDB;
            for (int n = 0; n < this.TotalMonthsDB; ++n) {
                this.bloquesPorMes[n] = 0;
            }
            int i = y;
            int j = m;
            for (int n = 0; n < this.TotalMonthsDB; ++n) {
                this.r = this.s.executeQuery("SELECT COUNT(BlockNumber) FROM blockTime WHERE MONTH(iniDate)=" + j + " AND YEAR(iniDate)=" + i);
                this.r.next();
                this.bloquesPorMes[n] = this.r.getInt(1);
                if (++j != 13) continue;
                ++i;
                j = 1;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    protected void GetDBAndFlowSelection(int iniY, int iniM, int iniB, int iniH, int endY, int endM, int endB, int endH) {
        this.GetDBAndFlowSelection(iniY, iniM, iniB, iniH, endY, endM, endB, endH, true);
    }

    protected void GetDBAndFlowSelection(int iniY, int iniM, int iniB, int iniH, int endY, int endM, int endB, int endH, boolean HydroDBa) {
        int i;
        assert (this.s != null) : "Did you forget to call existTPDB() from your constructor. We need Statement object from that method first";
        if (iniY * 12 + iniM > endY * 12 + endM) {
            System.out.println("Se ha corregido fechas inversas.");
            i = iniY;
            iniY = endY;
            endY = i;
            i = iniM;
            iniM = endM;
            endM = i;
        }
        if (iniY == this.InitialYearDB && iniM < this.InitialMonthDB) {
            iniM = this.InitialMonthDB;
            System.out.println("Mes inicial menor que existente en TPDB, se fija al m\u00ednimo.");
        }
        if (endY == this.FinalYearDB && endM > this.FinalMonthDB) {
            endM = this.FinalMonthDB;
            System.out.println("Mes final mayor que existente en TPDB, se fija al m\u00e1ximo.");
        }
        this.flow1 = this.getDispatchID(iniY, iniM, iniB, iniH);
        this.flow2 = this.getDispatchID(endY, endM, endB, endH);
        i = this.TotalMonthsDB * this.BlockNumberDB * this.HydroNumberDB;
        System.out.println(" ");
        System.out.println("Flow Selection Details");
        System.out.println("----------------------");
        System.out.println("Total DB Flows  :    " + i);
        System.out.println("Total DB Months :    " + this.TotalMonthsDB);
        System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
        System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
        System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
        System.out.println("Inicio          :    " + iniY + "/ " + iniM + "/ " + iniB + "/ " + iniH + "/ " + this.flow1);
        System.out.println("Final           :    " + endY + "/ " + endM + "/ " + endB + "/ " + endH + "/ " + this.flow2);
        System.out.println(" ");
        try {
            int j;
            this.r = this.s.executeQuery("SELECT IdDesp FROM generator WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
            i = 0;
            while (this.r.next()) {
                ++i;
            }
            this.dimDBGen = i;
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 0.0;
            }
            String aux = "SELECT * FROM generator WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2;
            this.r = this.s.executeQuery(aux);
            i = 0;
            while (this.r.next()) {
                this.NameGenDB[i] = this.r.getString("name");
                this.IdDespDB[i] = this.r.getInt("IdDesp");
                this.PDB[i] = this.r.getDouble("p");
                ++i;
            }
            i = this.BlockNumberDB * this.TotalMonthsDB;
            this.blockTime = new double[i];
            this.r = this.s.executeQuery("SELECT * FROM blockTime");
            this.r.next();
            for (j = 1; j <= i; ++j) {
                this.blockTime[j - 1] = this.r.getDouble("d" + j);
            }
            try {
                this.r = this.s.executeQuery("SELECT name FROM demand WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2 + " ORDER BY name");
                this.ht_dem = new HashMap();
                i = 0;
                String nam1 = "";
                String nam2 = "";
                while (this.r.next()) {
                    nam1 = this.r.getString(1).trim();
                    if (nam1.equalsIgnoreCase(nam2)) continue;
                    this.ht_dem.put(nam1, i);
                    ++i;
                    nam2 = nam1;
                }
                this.ndem = (this.flow2 - this.flow1) / this.HydroNumberDB + 1;
                this.dimDBLoad = this.ht_dem.size();
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                this.r = this.s.executeQuery("SELECT * FROM demand WHERE IdDesp>=" + this.flow1 + " AND IdDesp<=" + this.flow2);
                while (this.r.next()) {
                    i = (this.r.getInt(2) - this.flow1) / this.HydroNumberDB;
                    nam1 = this.r.getString(1).trim();
                    this.PLDB[this.ht_dem.get((Object)nam1).intValue()][i] = this.r.getDouble("p");
                }
                for (Map.Entry<String, Integer> map : this.ht_dem.entrySet()) {
                    this.NameLDB[map.getValue().intValue()] = map.getKey();
                }
                this.directDx = true;
            }
            catch (Exception x) {
                x.printStackTrace(System.out);
                System.out.println("Was not found TPDB v2.0: " + x.getMessage());
                if (HydroDBa) {
                    this.r = this.s.executeQuery("SELECT name FROM load ORDER BY name");
                    i = 0;
                    while (this.r.next()) {
                        ++i;
                    }
                    this.ndem = this.BlockNumberDB * 12;
                    this.dimDBLoad = i;
                    this.NameLDB = new String[this.dimDBLoad];
                    this.PLDB = new double[this.dimDBLoad][this.ndem];
                    i = 0;
                    this.r = this.s.executeQuery("SELECT * FROM load ORDER BY name");
                    while (this.r.next()) {
                        this.NameLDB[i] = this.r.getString("name");
                        for (j = 1; j <= this.NameLDB.length; ++j) {
                            this.PLDB[i][j - 1] = this.r.getDouble("d" + j);
                        }
                        ++i;
                    }
                    i = 0;
                    this.r = this.s.executeQuery("SELECT * FROM loadPower ORDER BY Year");
                    while (this.r.next()) {
                        this.HidYearNameLDB[i] = this.r.getInt("Year");
                        for (j = 1; j <= this.NameLDB.length; ++j) {
                            this.TotDemDB[i][j - 1] = this.r.getDouble("d" + j);
                        }
                        ++i;
                    }
                    this.dimDBYear = i;
                    this.TotDemDB = new double[this.dimDBYear][this.ndem];
                    this.HidYearNameLDB = new int[this.dimDBYear];
                } else {
                    this.ndem2 = this.YearNumberDB * 12;
                    ResultSet r2 = this.s.executeQuery("SELECT name\tFROM load   ORDER BY name");
                    i = 0;
                    while (r2.next()) {
                        ++i;
                    }
                    this.dimDBLoad2 = i;
                    this.NameLDB2 = new String[this.dimDBLoad2];
                    this.PLDB2 = new double[this.dimDBLoad2][this.ndem2];
                    for (i = 0; i < this.dimDBLoad2; ++i) {
                        this.NameLDB2[i] = "nada";
                        for (j = 1; j <= this.ndem2; ++j) {
                            this.PLDB2[i][j - 1] = 123456.0;
                        }
                    }
                    r2 = this.s.executeQuery("SELECT *\tFROM load   ORDER BY name");
                    i = 0;
                    while (r2.next()) {
                        this.NameLDB2[i] = r2.getString("name");
                        for (j = 1; j <= this.ndem2; ++j) {
                            this.PLDB2[i][j - 1] = r2.getDouble("d" + j);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace(System.out);
        }
    }

    protected void GetDBAndFlowSelectionFromTPDB3_3(int iniY, int iniM, int iniB, int iniH, int endY, int endM, int endB, int endH, boolean HydroDBa) {
        int i;
        assert (this.s != null) : "Did you forget to call existTPDB() from your constructor. We need Statement object from that method first";
        if (iniY * 12 + iniM > endY * 12 + endM) {
            System.out.println("Se ha corregido fechas inversas.");
            i = iniY;
            iniY = endY;
            endY = i;
            i = iniM;
            iniM = endM;
            endM = i;
        }
        if (iniY == this.InitialYearDB && iniM < this.InitialMonthDB) {
            iniM = this.InitialMonthDB;
            System.out.println("Mes inicial menor que existente en TPDB, se fija al m\u00ednimo.");
        }
        if (endY == this.FinalYearDB && endM > this.FinalMonthDB) {
            endM = this.FinalMonthDB;
            System.out.println("Mes final mayor que existente en TPDB, se fija al m\u00e1ximo.");
        }
        this.flow1 = this.getDispatchID2(iniB, iniH);
        this.flow2 = this.getDispatchID2(endB, endH);
        int fl1 = this.flow1 - 1;
        int fl2 = this.flow2 - 1;
        i = this.BlockNumberDB * this.HydroNumberDB;
        System.out.println(" ");
        System.out.println("Flow Selection Details");
        System.out.println("----------------------");
        System.out.println("Total DB Flows  :    " + i);
        System.out.println("Total DB Months :    " + this.TotalMonthsDB);
        System.out.println("Total DB Blocks :    " + this.BlockNumberDB);
        System.out.println("Total DB Hidros :    " + this.HydroNumberDB);
        System.out.println("Flujo           :    YEAR/   MONTH/   BLOCK/   HYDRO/    FLOW");
        System.out.println("Inicio          :    " + iniY + "/ " + iniM + "/ " + iniB + "/ " + iniH + "/ " + this.flow1);
        System.out.println("Final           :    " + endY + "/ " + endM + "/ " + endB + "/ " + endH + "/ " + this.flow2);
        System.out.println(" ");
        int y = this.InitialYearDB;
        int m = this.InitialMonthDB;
        for (int n = 0; n < this.TotalMonthsDB; ++n) {
            if (m == 12) {
                m = 0;
                ++y;
            }
            ++m;
        }
        try {
            this.r = this.s.executeQuery("SELECT objectName FROM qryGetAllValues WHERE resultName IN ('gen_p') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC;");
            i = 0;
            while (this.r.next()) {
                ++i;
            }
            this.dimDBGen = i;
            System.out.println("dimDBGen = " + this.dimDBGen);
            this.NameGenDB = new String[this.dimDBGen];
            this.IdDespDB = new int[this.dimDBGen];
            this.PDB = new double[this.dimDBGen];
            for (i = 0; i < this.dimDBGen; ++i) {
                this.NameGenDB[i] = "nada";
                this.IdDespDB[i] = 12345;
                this.PDB[i] = 0.0;
            }
            String aux = "SELECT DispYear, DispMonth, hydroID, BlockNumber, objectName, DataValue FROM qryGetAllValues WHERE resultName IN ('gen_p') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC, BlockNumber ASC, hydroID ASC, DispMonth ASC, DispYear ASC;";
            this.r = this.s.executeQuery(aux);
            i = 0;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("generadoresDB.csv"), "utf-8"));
                writer.write("NameGenDB,IdDespDB,PDB" + System.getProperty("line.separator"));
                while (this.r.next()) {
                    this.NameGenDB[i] = this.r.getString("objectName");
                    this.IdDespDB[i] = this.getDispatchID2(this.r.getInt("BlockNumber") + 1, this.r.getInt("hydroID") + 1);
                    this.PDB[i] = this.r.getDouble("dataValue");
                    writer.write(this.NameGenDB[i] + "," + this.IdDespDB[i] + "," + this.PDB[i] + "" + System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                System.out.println("Error writing file 'generadoresDB.csv':" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            this.r = this.s.executeQuery("SELECT objectName FROM qryGetAllValues WHERE resultName IN ('flow') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC;");
            i = 0;
            while (this.r.next()) {
                ++i;
            }
            this.dimDBFlow = i;
            System.out.println("dimDBFlow = " + this.dimDBFlow);
            this.NameFlowDB = new String[this.dimDBFlow];
            this.IdDespDBFlow = new int[this.dimDBFlow];
            this.FlowDB = new double[this.dimDBFlow];
            for (i = 0; i < this.dimDBFlow; ++i) {
                this.NameFlowDB[i] = "nada";
                this.IdDespDBFlow[i] = 12345;
                this.FlowDB[i] = 0.0;
            }
            aux = "SELECT DispYear, DispMonth, hydroID, BlockNumber, objectName, DataValue FROM qryGetAllValues WHERE resultName IN ('flow') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC, BlockNumber ASC, hydroID ASC, DispMonth ASC, DispYear ASC;";
            this.r = this.s.executeQuery(aux);
            i = 0;
            writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("FlujosDB.csv"), "utf-8"));
                writer.write("NameFlowDB,IdDespDB,FlowDB" + System.getProperty("line.separator"));
                while (this.r.next()) {
                    this.NameFlowDB[i] = this.r.getString("objectName");
                    this.IdDespDBFlow[i] = this.getDispatchID2(this.r.getInt("BlockNumber") + 1, this.r.getInt("hydroID") + 1);
                    this.FlowDB[i] = this.r.getDouble("dataValue");
                    writer.write(this.NameFlowDB[i] + "," + this.IdDespDBFlow[i] + "," + this.FlowDB[i] + System.getProperty("line.separator"));
                    ++i;
                }
            }
            catch (IOException ex) {
                System.out.println("Error writing file 'FlujosDB.csv':" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            System.out.println("iniB, deberia ser 0 = " + iniB);
            System.out.println("endB = " + endB);
            this.r = this.s.executeQuery("SELECT objectName FROM qryGetAllValues WHERE resultName IN ('vatt') AND (BlockNumber) >= " + (iniB - 1) + " AND (BlockNumber) <= " + (endB - 1) + " ORDER BY objectName ASC;");
            i = 0;
            while (this.r.next()) {
                ++i;
            }
            this.dimDBPeaje = i;
            System.out.println("dimDBPeaje = " + this.dimDBPeaje);
            this.NamePeajeDB = new String[this.dimDBPeaje];
            this.IdBlockDBPeaje = new int[this.dimDBPeaje];
            this.PeajeDB = new double[this.dimDBPeaje];
            for (i = 0; i < this.dimDBPeaje; ++i) {
                this.NamePeajeDB[i] = "nada";
                this.IdBlockDBPeaje[i] = 0;
                this.PeajeDB[i] = 0.0;
            }
            aux = "SELECT BlockNumber, objectName, DataValue FROM qryGetAllValues WHERE resultName IN ('vatt') AND (BlockNumber) >= " + (iniB - 1) + " AND (BlockNumber) <= " + (endB - 1) + " ORDER BY objectName ASC, BlockNumber ASC;";
            this.r = this.s.executeQuery(aux);
            i = 0;
            while (this.r.next()) {
                this.NamePeajeDB[i] = this.r.getString("objectName");
                this.IdBlockDBPeaje[i] = this.r.getInt("BlockNumber");
                this.PeajeDB[i] = this.r.getDouble("dataValue");
                ++i;
            }
            this.blockTime = new double[this.BlockNumberDB];
            this.r = this.s.executeQuery("SELECT Duration FROM blockTime;");
            i = 0;
            writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("bloques.csv"), "utf-8"));
                writer.write("block,duration" + System.getProperty("line.separator"));
                while (this.r.next()) {
                    this.blockTime[i] = this.r.getDouble("Duration");
                    writer.write(i + "," + this.blockTime[i] + System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                System.out.println("Error writing file 'bloques.csv':" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            this.r = this.s.executeQuery("SELECT objectName FROM qryGetAllValues WHERE resultName IN ('load_p') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC;");
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("demandasDB.csv"), "utf-8"));
                writer.write("DemandasDB" + System.getProperty("line.separator"));
                this.ht_dem = new HashMap();
                i = 0;
                String nam1 = "";
                String nam2 = "";
                String nam3 = "";
                while (this.r.next()) {
                    nam1 = this.r.getString("objectName").trim();
                    if (nam1.equalsIgnoreCase(nam2)) continue;
                    this.ht_dem.put(nam1, i);
                    ++i;
                    nam2 = nam1;
                }
                this.ndem = (this.flow2 - this.flow1) / this.HydroNumberDB + 1;
                writer.write("ndem = " + this.ndem + System.getProperty("line.separator"));
                this.dimDBLoad = this.ht_dem.size();
                System.out.println("ndem = " + this.ndem);
                System.out.println("dimDBLoad = " + this.dimDBLoad);
                writer.write("dimDBLoad = " + this.dimDBLoad + System.getProperty("line.separator"));
                this.NameLDB = new String[this.dimDBLoad];
                this.PLDB = new double[this.dimDBLoad][this.ndem];
                System.out.println("hydronumber = " + this.HydroNumberDB);
                this.r = this.s.executeQuery("SELECT DispYear, DispMonth, hydroID, BlockNumber, objectName, DataValue FROM qryGetAllValues WHERE resultName IN ('load_p') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC, BlockNumber ASC, hydroID ASC, DispMonth ASC, DispYear ASC;");
                int a = 0;
                int b = 0;
                while (this.r.next()) {
                    a = this.r.getInt("BlockNumber") + 1;
                    b = this.r.getInt("hydroID") + 1;
                    i = (this.getDispatchID2(a, b) - this.flow1) / this.HydroNumberDB;
                    nam3 = this.r.getString("objectName").trim();
                    this.PLDB[this.ht_dem.get((Object)nam3).intValue()][i] = this.r.getDouble("DataValue");
                    writer.write(nam3 + " en barra " + i + " = " + this.PLDB[this.ht_dem.get(nam3)][i] + System.getProperty("line.separator"));
                }
                for (Map.Entry<String, Integer> map : this.ht_dem.entrySet()) {
                    this.NameLDB[map.getValue().intValue()] = map.getKey();
                }
                this.directDx = true;
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                System.out.println("Error writing file 'bloques.csv':" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            this.r = this.s.executeQuery("SELECT objectName FROM qryGetAllValues WHERE resultName IN ('cmg') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC;");
            i = 0;
            while (this.r.next()) {
                ++i;
            }
            this.dimDBCMg = i;
            System.out.println("dimDBCMg = " + this.dimDBCMg);
            this.NameCMgDB = new String[this.dimDBCMg];
            this.IdDespDBCMg = new int[this.dimDBCMg];
            this.CMgDB = new double[this.dimDBCMg];
            for (i = 0; i < this.dimDBCMg; ++i) {
                this.NameCMgDB[i] = "nada";
                this.IdDespDBCMg[i] = 12345;
                this.CMgDB[i] = 0.0;
            }
            aux = "SELECT DispYear, DispMonth, hydroID, BlockNumber, objectName, DataValue FROM qryGetAllValues WHERE resultName IN ('cmg') AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID >= " + fl1 + " AND (BlockNumber)*" + this.HydroNumberDB + " + hydroID <= " + fl2 + " ORDER BY objectName ASC, BlockNumber ASC, hydroID ASC, DispMonth ASC, DispYear ASC;";
            this.r = this.s.executeQuery(aux);
            i = 0;
            writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("CMgDB.csv"), "utf-8"));
                writer.write("NameCMgDB,IdDespDB,CMgDB" + System.getProperty("line.separator"));
                while (this.r.next()) {
                    this.NameCMgDB[i] = this.r.getString("objectName");
                    this.IdDespDBCMg[i] = this.getDispatchID2(this.r.getInt("BlockNumber") + 1, this.r.getInt("hydroID") + 1);
                    this.CMgDB[i] = this.r.getDouble("dataValue");
                    writer.write(this.NameCMgDB[i] + "," + this.IdDespDBCMg[i] + "," + this.CMgDB[i] + "," + System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                System.out.println("Error writing file 'bloques.csv':" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.out.println("Error: al leer Base de Datos " + e);
            e.printStackTrace(System.out);
        }
    }

    protected void GetDBAndFlowSelection(String SDYa, String SDMa, String SDBa, String SDHa, String EDYa, String EDMa, String EDBa, String EDHa, boolean HydroDBa) {
        String[] mes = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
        this.year1 = Integer.parseInt(SDYa);
        this.year2 = Integer.parseInt(EDYa);
        for (int i = 0; i < 12; ++i) {
            if (mes[i].equals(SDMa)) {
                this.month1 = i + 1;
            }
            if (!mes[i].equals(EDMa)) continue;
            this.month2 = i + 1;
        }
        this.block1 = Integer.parseInt(SDBa);
        this.hidro1 = Integer.parseInt(SDHa);
        this.block2 = Integer.parseInt(EDBa);
        this.hidro2 = Integer.parseInt(EDHa);
        this.GetDBAndFlowSelection(this.year1, this.month1, this.block1, this.hidro1, this.year2, this.month2, this.block2, this.hidro2);
    }

    protected int getDispatchID(int year, int month, int block, int hydro) {
        if (this.InitialYearDB > 0 && this.InitialMonthDB > 0 && this.BlockNumberDB > 0 && this.HydroNumberDB > 0) {
            return ((year - this.InitialYearDB) * 12 + (month - this.InitialMonthDB)) * this.BlockNumberDB * this.HydroNumberDB + (block - 1) * this.HydroNumberDB + hydro;
        }
        assert (false) : "Why are you calling this function if you haven't called GetDBAndFlowSelection";
        return -1;
    }

    protected int getDispatchID2(int block, int hydro) {
        if (this.InitialYearDB > 0 && this.InitialMonthDB > 0 && this.BlockNumberDB > 0 && this.HydroNumberDB > 0) {
            return (block - 1) * this.HydroNumberDB + hydro;
        }
        assert (false) : "Why are you calling this function if you haven't called GetDBAndFlowSelection";
        return -1;
    }

    public abstract void Calculate(String var1, boolean var2, boolean var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, boolean var13, boolean var14, boolean var15);

    public abstract void Calculate(String var1, boolean var2, boolean var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, boolean var14);

    public abstract void Calculate(String var1, boolean var2, boolean var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13);

    public abstract void Calculate(String var1, boolean var2, boolean var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, String var14, double var15, double var17);

    public abstract void Calculate(String var1, boolean var2, boolean var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, boolean var14, String var15, double var16);
}

