/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.TABranchLimitFrame;
import de.core.TACongestion;
import de.core.TAMainFrame;
import de.core.XmlBranchLimitInfos;
import de.data.DE_GeneralEnums;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.bind.JAXBException;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class TAOptionFrame
extends JDialog {
    private TAMainFrame parent;
    private TACongestion myTA;
    private JTabbedPane MainJTabPane;
    private JPanel MainPane;
    private JButton btnBrowseBranchLimitFile;
    private JButton btnBrowseDB;
    private JButton btnBrowseInputFolder;
    private JButton btnBrowseOutputFolder;
    private JButton btnCancel;
    private JButton btnCheckSch;
    private JButton btnOK;
    private JButton btnTestDB;
    private JButton btnUpdateTPDB;
    private JComboBox cboControlAreas;
    private JComboBox cboDBType;
    private JComboBox cboFileType;
    private JCheckBox chkDoubleCircuit;
    private JCheckBox chkMakeReport;
    private JCheckBox chkMarketBalance;
    private JCheckBox chkUseDynPriceDiff;
    private JCheckBox chkUseLineTol;
    private JCheckBox chkUsePriceDiffTol;
    private JCheckBox chkUseRelPriceDiffTol;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JLabel lblBranchLimitFile;
    private JLabel lblControlArea;
    private JLabel lblDBName;
    private JLabel lblDBPass;
    private JLabel lblDBPass1;
    private JLabel lblDBServer;
    private JLabel lblDBServer1;
    private JLabel lblDBType;
    private JLabel lblDBType1;
    private JLabel lblDBUserName;
    private JLabel lblDBUserName1;
    private JLabel lblDateFrom;
    private JLabel lblDateFromInDB;
    private JLabel lblDateTo;
    private JLabel lblDateToInDB;
    private JLabel lblDoubleCircuit;
    private JLabel lblDynPriceDiff;
    private JLabel lblFormatFrom;
    private JLabel lblFormatTo;
    private JLabel lblLineLoadTol;
    private JLabel lblMakeReport;
    private JLabel lblMarketBalance;
    private JLabel lblPriceDiffTol;
    private JLabel lblRelPriceDiffTol;
    private JPanel pnlBranchLimit;
    private JPanel pnlDatabase;
    private JPanel pnlDatabase1;
    private JPanel pnlFiles;
    private JPanel pnlHorizon;
    private JPanel pnlParameters;
    private JPanel pnlScope;
    private JPanel tabDatabase;
    private JPanel tabFilter;
    private JPanel tabOptions;
    private JPanel tabRank;
    private JTable tblCoefficients;
    private JTextField txtBranchLimitFile;
    private JTextField txtDBName;
    private JPasswordField txtDBPass;
    private JTextField txtDBServer;
    private JTextField txtDBUserName;
    private JTextField txtDateFrom;
    private JTextField txtDateTo;
    private JTextField txtInputFolder;
    private JTextField txtLineLoadTol;
    private JTextField txtOutputFolder;
    private JTextField txtPLEXOSDBName;
    private JTextField txtPriceDiffTol;
    private JTextField txtRelPriceDiffTol;
    private BindingGroup bindingGroup;

    public TAOptionFrame(TAMainFrame parent) {
        super((Dialog)parent, true);
        this.initComponents();
        this.parent = parent;
        this.myTA = parent.getTransmissionCongestion();
        try {
            this.updateGUIwithTAParameters();
            this.setDateFromTo();
        }
        catch (Exception e) {
            System.err.println("TA Option GUI couldn't be fully updated with stored parameters. Detailts: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void updateTPDB() {
        String strInputFolder = this.txtInputFolder.getText();
        String strOutFolder = this.txtOutputFolder.getText();
        String strPLEXOSDatabaseName = this.txtPLEXOSDBName.getText();
        String strTPDBDabasePath = this.txtDBName.getText();
        String strFileType = this.cboFileType.getSelectedItem().toString();
        String nInputFileType = "PLEXOS_ST";
        if (!AnalysisTool.DirectoryExist(strInputFolder) || !AnalysisTool.DirectoryExist(strOutFolder)) {
            JOptionPane.showMessageDialog(this, "Invalid directory. Please check Input and Output Folder first and try again", "Invalid line selection", 0);
            return;
        }
        if (strFileType.equals(DE_GeneralEnums.DispatchSoftware.PLEXOS_ST.toString())) {
            nInputFileType = "PLEXOS_ST";
            strOutFolder = strOutFolder + File.separator + strPLEXOSDatabaseName;
        } else if (strFileType.equals(DE_GeneralEnums.DispatchSoftware.PLP.toString())) {
            nInputFileType = "PLP";
        } else if (strFileType.equals(DE_GeneralEnums.DispatchSoftware.PCP.toString())) {
            nInputFileType = "PCP";
        } else assert (false) : "Why are you selecting an unsuported sofware for TA?? " + strFileType;
        this.myTA.dispatchFileDataToDatabase(strTPDBDabasePath, strInputFolder, strOutFolder, nInputFileType);
    }

    private void showAllBranchLimits() {
        try {
            XmlBranchLimitInfos myLimits = TACongestion.loadLimitsFromXML(this.txtBranchLimitFile.getText());
            TABranchLimitFrame myLimitFrame = new TABranchLimitFrame(this, this.txtBranchLimitFile.getText());
            myLimitFrame.setTblValues(myLimits);
            myLimitFrame.setVisible(true);
        }
        catch (JAXBException ex) {
            JOptionPane.showMessageDialog(this, "XML Parsing error reading file: \n" + this.txtBranchLimitFile.getText() + "\n Exception details: " + ex.toString(), "Error reading XML File", 0);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.MainPane = new JPanel();
        this.MainJTabPane = new JTabbedPane();
        this.tabFilter = new JPanel();
        this.pnlHorizon = new JPanel();
        this.lblDateFrom = new JLabel();
        this.lblDateTo = new JLabel();
        this.txtDateFrom = new JTextField();
        this.txtDateTo = new JTextField();
        this.lblDateFromInDB = new JLabel();
        this.lblDateToInDB = new JLabel();
        this.lblFormatFrom = new JLabel();
        this.lblFormatTo = new JLabel();
        this.tabOptions = new JPanel();
        this.pnlScope = new JPanel();
        this.cboControlAreas = new JComboBox();
        this.chkDoubleCircuit = new JCheckBox();
        this.chkMakeReport = new JCheckBox();
        this.lblControlArea = new JLabel();
        this.lblDoubleCircuit = new JLabel();
        this.lblMakeReport = new JLabel();
        this.lblMarketBalance = new JLabel();
        this.chkMarketBalance = new JCheckBox();
        this.pnlParameters = new JPanel();
        this.lblLineLoadTol = new JLabel();
        this.lblPriceDiffTol = new JLabel();
        this.txtLineLoadTol = new JTextField();
        this.txtPriceDiffTol = new JTextField();
        this.lblRelPriceDiffTol = new JLabel();
        this.txtRelPriceDiffTol = new JTextField();
        this.chkUseLineTol = new JCheckBox();
        this.chkUsePriceDiffTol = new JCheckBox();
        this.chkUseRelPriceDiffTol = new JCheckBox();
        this.lblDynPriceDiff = new JLabel();
        this.chkUseDynPriceDiff = new JCheckBox();
        this.tabDatabase = new JPanel();
        this.pnlDatabase = new JPanel();
        this.lblDBPass = new JLabel();
        this.lblDBUserName = new JLabel();
        this.txtDBUserName = new JTextField();
        this.txtDBPass = new JPasswordField();
        this.cboDBType = new JComboBox();
        this.lblDBType = new JLabel();
        this.lblDBServer = new JLabel();
        this.txtDBServer = new JTextField();
        this.lblDBName = new JLabel();
        this.txtDBName = new JTextField();
        this.btnBrowseDB = new JButton();
        this.btnTestDB = new JButton();
        this.btnCheckSch = new JButton();
        this.pnlFiles = new JPanel();
        this.pnlDatabase1 = new JPanel();
        this.lblDBPass1 = new JLabel();
        this.lblDBUserName1 = new JLabel();
        this.txtInputFolder = new JTextField();
        this.cboFileType = new JComboBox();
        this.lblDBType1 = new JLabel();
        this.lblDBServer1 = new JLabel();
        this.txtPLEXOSDBName = new JTextField();
        this.btnBrowseInputFolder = new JButton();
        this.btnBrowseOutputFolder = new JButton();
        this.btnUpdateTPDB = new JButton();
        this.txtOutputFolder = new JTextField();
        this.pnlBranchLimit = new JPanel();
        this.lblBranchLimitFile = new JLabel();
        this.txtBranchLimitFile = new JTextField();
        this.btnBrowseBranchLimitFile = new JButton();
        this.tabRank = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblCoefficients = new JTable();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Transmission Analysis Options");
        this.setName("TAOptionFrame");
        this.setResizable(false);
        this.pnlHorizon.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Horizon", 0, 0, null, new Color(0, 51, 204)));
        this.lblDateFrom.setText("Date From:");
        this.lblDateTo.setText("Date To:");
        this.txtDateFrom.setText("dd/mm/yyyy");
        this.txtDateTo.setText("dd/mm/yyyy");
        this.lblDateFromInDB.setForeground(new Color(0, 51, 255));
        this.lblDateFromInDB.setText("dd/mm/yyyy");
        this.lblDateToInDB.setForeground(new Color(0, 0, 255));
        this.lblDateToInDB.setText("dd/mm/yyyy");
        this.lblFormatFrom.setForeground(new Color(153, 153, 153));
        this.lblFormatFrom.setText("[dd/mm/yyyy]");
        this.lblFormatTo.setForeground(new Color(153, 153, 153));
        this.lblFormatTo.setText("[dd/mm/yyyy]");
        GroupLayout pnlHorizonLayout = new GroupLayout(this.pnlHorizon);
        this.pnlHorizon.setLayout(pnlHorizonLayout);
        pnlHorizonLayout.setHorizontalGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHorizonLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlHorizonLayout.createSequentialGroup().addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDateFrom).addComponent(this.lblFormatFrom, -2, 77, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 77, Short.MAX_VALUE).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDateFromInDB).addComponent(this.txtDateFrom, -2, 130, -2))).addGroup(GroupLayout.Alignment.TRAILING, pnlHorizonLayout.createSequentialGroup().addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDateTo).addComponent(this.lblFormatTo, -2, 77, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDateToInDB).addComponent(this.txtDateTo, -2, 130, -2)))).addGap(19, 19, 19)));
        pnlHorizonLayout.setVerticalGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlHorizonLayout.createSequentialGroup().addContainerGap().addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDateFrom).addComponent(this.txtDateFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDateFromInDB).addComponent(this.lblFormatFrom)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDateTo).addComponent(this.txtDateTo, -2, -1, -2)).addGap(5, 5, 5).addGroup(pnlHorizonLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDateToInDB).addComponent(this.lblFormatTo)).addContainerGap()));
        GroupLayout tabFilterLayout = new GroupLayout(this.tabFilter);
        this.tabFilter.setLayout(tabFilterLayout);
        tabFilterLayout.setHorizontalGroup(tabFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabFilterLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.pnlHorizon, -2, -1, -2).addContainerGap(32, Short.MAX_VALUE)));
        tabFilterLayout.setVerticalGroup(tabFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabFilterLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlHorizon, -2, -1, -2).addContainerGap(162, Short.MAX_VALUE)));
        this.MainJTabPane.addTab("Horizon", this.tabFilter);
        this.pnlScope.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scope", 0, 0, null, new Color(0, 51, 204)));
        this.cboControlAreas.setModel(new DefaultComboBoxModel<String>(new String[]{"All Areas"}));
        this.chkMakeReport.setSelected(true);
        this.lblControlArea.setText("Control Areas");
        this.lblDoubleCircuit.setText("Double-circuit lines only");
        this.lblMakeReport.setText("Always make report");
        this.lblMarketBalance.setText("Market Balance");
        GroupLayout pnlScopeLayout = new GroupLayout(this.pnlScope);
        this.pnlScope.setLayout(pnlScopeLayout);
        pnlScopeLayout.setHorizontalGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlScopeLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblControlArea).addComponent(this.lblDoubleCircuit).addComponent(this.lblMakeReport).addComponent(this.lblMarketBalance)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboControlAreas, -2, 80, -2).addComponent(this.chkDoubleCircuit).addComponent(this.chkMakeReport).addComponent(this.chkMarketBalance)).addGap(45, 45, 45)));
        pnlScopeLayout.setVerticalGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlScopeLayout.createSequentialGroup().addGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlScopeLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.cboControlAreas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDoubleCircuit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkMakeReport)).addGroup(pnlScopeLayout.createSequentialGroup().addContainerGap().addComponent(this.lblControlArea).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDoubleCircuit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMakeReport))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlScopeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarketBalance).addComponent(this.chkMarketBalance)).addContainerGap(17, Short.MAX_VALUE)));
        this.pnlParameters.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters", 0, 0, null, new Color(0, 51, 204)));
        this.lblLineLoadTol.setText("Line Load Tolerance [pu]:");
        this.lblPriceDiffTol.setText("Price Difference [$/MWh]:");
        this.txtLineLoadTol.setText("95%");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkUseLineTol, (Property)ELProperty.create((String)"${selected}"), (Object)this.txtLineLoadTol, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtPriceDiffTol.setText("15");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkUsePriceDiffTol, (Property)ELProperty.create((String)"${selected}"), (Object)this.txtPriceDiffTol, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.lblRelPriceDiffTol.setText("Rel. Price Difference [pu]:");
        this.txtRelPriceDiffTol.setText("0.30");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkUseRelPriceDiffTol, (Property)ELProperty.create((String)"${selected}"), (Object)this.txtRelPriceDiffTol, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.chkUseLineTol.setSelected(true);
        this.chkUseRelPriceDiffTol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.chkUseRelPriceDiffTolActionPerformed(evt);
            }
        });
        this.lblDynPriceDiff.setText("Dynamic Price Difference:");
        this.chkUseDynPriceDiff.setSelected(true);
        this.chkUseDynPriceDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.chkUseDynPriceDiffActionPerformed(evt);
            }
        });
        GroupLayout pnlParametersLayout = new GroupLayout(this.pnlParameters);
        this.pnlParameters.setLayout(pnlParametersLayout);
        pnlParametersLayout.setHorizontalGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlParametersLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDynPriceDiff).addComponent(this.lblRelPriceDiffTol).addComponent(this.lblPriceDiffTol).addComponent(this.lblLineLoadTol)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUsePriceDiffTol, GroupLayout.Alignment.TRAILING).addComponent(this.chkUseLineTol, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chkUseDynPriceDiff, -1, -1, Short.MAX_VALUE).addComponent(this.chkUseRelPriceDiffTol, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtRelPriceDiffTol, -2, 50, -2).addComponent(this.txtLineLoadTol, -2, 50, -2).addComponent(this.txtPriceDiffTol, -2, 50, -2)).addGap(21, 21, 21)));
        pnlParametersLayout.setVerticalGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlParametersLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.chkUseDynPriceDiff).addComponent(this.lblDynPriceDiff)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblRelPriceDiffTol).addComponent(this.chkUseRelPriceDiffTol).addComponent(this.txtRelPriceDiffTol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblPriceDiffTol).addComponent(this.chkUsePriceDiffTol).addComponent(this.txtPriceDiffTol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlParametersLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblLineLoadTol).addComponent(this.chkUseLineTol).addComponent(this.txtLineLoadTol, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout tabOptionsLayout = new GroupLayout(this.tabOptions);
        this.tabOptions.setLayout(tabOptionsLayout);
        tabOptionsLayout.setHorizontalGroup(tabOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabOptionsLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(tabOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlScope, -1, -1, Short.MAX_VALUE).addComponent(this.pnlParameters, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        tabOptionsLayout.setVerticalGroup(tabOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabOptionsLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlScope, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlParameters, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.MainJTabPane.addTab("Options", this.tabOptions);
        this.pnlDatabase.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Database Settings", 0, 0, null, new Color(0, 51, 204)));
        this.lblDBPass.setText("Password:");
        this.lblDBUserName.setText("User Name:");
        this.txtDBUserName.setText("admin");
        this.txtDBPass.setText("root");
        this.cboDBType.setModel(new DefaultComboBoxModel<String>(new String[]{"MSAccess", "SQLite"}));
        this.lblDBType.setText("Type:");
        this.lblDBServer.setText("Server:");
        this.txtDBServer.setText("Localhost");
        GroupLayout pnlDatabaseLayout = new GroupLayout(this.pnlDatabase);
        this.pnlDatabase.setLayout(pnlDatabaseLayout);
        pnlDatabaseLayout.setHorizontalGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDatabaseLayout.createSequentialGroup().addContainerGap().addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDatabaseLayout.createSequentialGroup().addComponent(this.lblDBServer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.txtDBServer, -2, 130, -2)).addGroup(pnlDatabaseLayout.createSequentialGroup().addComponent(this.lblDBPass).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.txtDBPass, -2, 130, -2)).addGroup(GroupLayout.Alignment.TRAILING, pnlDatabaseLayout.createSequentialGroup().addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDBUserName).addComponent(this.lblDBType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cboDBType, 0, -1, Short.MAX_VALUE).addComponent(this.txtDBUserName, -2, 130, -2)))).addGap(26, 26, 26)));
        pnlDatabaseLayout.setVerticalGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDatabaseLayout.createSequentialGroup().addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboDBType, -2, -1, -2).addComponent(this.lblDBType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDBUserName, -2, -1, -2).addComponent(this.lblDBUserName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDBPass).addComponent(this.txtDBPass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDBServer, -2, -1, -2).addComponent(this.lblDBServer)).addContainerGap(22, Short.MAX_VALUE)));
        this.lblDBName.setText("TA-Database:");
        this.txtDBName.setText("Full path to database...");
        this.btnBrowseDB.setText("Browse");
        this.btnBrowseDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnBrowseDBActionPerformed(evt);
            }
        });
        this.btnTestDB.setText("Test");
        this.btnTestDB.setEnabled(false);
        this.btnCheckSch.setText("Update Sch");
        this.btnCheckSch.setToolTipText("<html>\nCheck compatibility between selected TA-Database and currently loaded Schematic <br>\nResults are printed to log file: results/TA-schematic.log\n</html>");
        this.btnCheckSch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnCheckSchActionPerformed(evt);
            }
        });
        GroupLayout tabDatabaseLayout = new GroupLayout(this.tabDatabase);
        this.tabDatabase.setLayout(tabDatabaseLayout);
        tabDatabaseLayout.setHorizontalGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabDatabaseLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlDatabase, -1, -1, Short.MAX_VALUE).addComponent(this.lblDBName).addGroup(tabDatabaseLayout.createSequentialGroup().addComponent(this.txtDBName, -2, 314, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseDB, -2, 26, -2))).addGroup(tabDatabaseLayout.createSequentialGroup().addComponent(this.btnTestDB, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCheckSch, -2, 90, -2))).addContainerGap(25, Short.MAX_VALUE)));
        tabDatabaseLayout.setVerticalGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabDatabaseLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlDatabase, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDBName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDBName, -2, -1, -2).addComponent(this.btnBrowseDB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabDatabaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnTestDB).addComponent(this.btnCheckSch)).addContainerGap(76, Short.MAX_VALUE)));
        this.MainJTabPane.addTab("Database", this.tabDatabase);
        this.pnlDatabase1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Database Settings", 0, 0, null, new Color(0, 51, 204)));
        this.lblDBPass1.setText("OutputFolder:");
        this.lblDBUserName1.setText("Input Folder:");
        this.txtInputFolder.setText("Input Folder");
        this.txtInputFolder.setPreferredSize(new Dimension(192, 20));
        this.cboFileType.setModel(new DefaultComboBoxModel<String>(new String[]{"PLEXOS_ST", "PLP", "PCP"}));
        this.cboFileType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TAOptionFrame.this.cboFileTypeItemStateChanged(evt);
            }
        });
        this.lblDBType1.setText("Type:");
        this.lblDBServer1.setText("Database Name:");
        this.txtPLEXOSDBName.setText("Model CDEC-BASE Solution.mdb");
        this.btnBrowseInputFolder.setText("Browse");
        this.btnBrowseInputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnBrowseInputFolderActionPerformed(evt);
            }
        });
        this.btnBrowseOutputFolder.setText("Browse");
        this.btnBrowseOutputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnBrowseOutputFolderActionPerformed(evt);
            }
        });
        this.btnUpdateTPDB.setText("Update TA-Database");
        this.btnUpdateTPDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnUpdateTPDBActionPerformed(evt);
            }
        });
        this.txtOutputFolder.setText(" Output Folder");
        this.txtOutputFolder.setPreferredSize(new Dimension(192, 20));
        GroupLayout pnlDatabase1Layout = new GroupLayout(this.pnlDatabase1);
        this.pnlDatabase1.setLayout(pnlDatabase1Layout);
        pnlDatabase1Layout.setHorizontalGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDatabase1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDBServer1).addGroup(pnlDatabase1Layout.createSequentialGroup().addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnUpdateTPDB).addGroup(pnlDatabase1Layout.createSequentialGroup().addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDBUserName1).addComponent(this.lblDBType1).addComponent(this.lblDBPass1)).addGap(36, 36, 36).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cboFileType, GroupLayout.Alignment.LEADING, -2, 87, -2).addComponent(this.txtPLEXOSDBName, -1, -1, -2).addComponent(this.txtInputFolder, -1, -1, -2)).addComponent(this.txtOutputFolder, -1, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnBrowseInputFolder, -2, 26, -2).addComponent(this.btnBrowseOutputFolder, -2, 26, -2))))));
        pnlDatabase1Layout.setVerticalGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDatabase1Layout.createSequentialGroup().addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboFileType, -2, -1, -2).addComponent(this.lblDBType1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtInputFolder, -2, -1, -2).addComponent(this.lblDBUserName1).addComponent(this.btnBrowseInputFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDBPass1).addComponent(this.btnBrowseOutputFolder).addComponent(this.txtOutputFolder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDatabase1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPLEXOSDBName, -2, -1, -2).addComponent(this.lblDBServer1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.btnUpdateTPDB).addContainerGap()));
        this.pnlBranchLimit.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Branch Limit Details", 0, 0, null, new Color(0, 51, 204)));
        this.lblBranchLimitFile.setText("Input File:");
        this.txtBranchLimitFile.setText("./Database/TABranchLimit.xml");
        this.txtBranchLimitFile.setPreferredSize(new Dimension(192, 20));
        this.btnBrowseBranchLimitFile.setText("Browse");
        this.btnBrowseBranchLimitFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnBrowseBranchLimitFileActionPerformed(evt);
            }
        });
        GroupLayout pnlBranchLimitLayout = new GroupLayout(this.pnlBranchLimit);
        this.pnlBranchLimit.setLayout(pnlBranchLimitLayout);
        pnlBranchLimitLayout.setHorizontalGroup(pnlBranchLimitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBranchLimitLayout.createSequentialGroup().addContainerGap().addComponent(this.lblBranchLimitFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.txtBranchLimitFile, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseBranchLimitFile, -2, 26, -2).addGap(2, 2, 2)));
        pnlBranchLimitLayout.setVerticalGroup(pnlBranchLimitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBranchLimitLayout.createSequentialGroup().addGroup(pnlBranchLimitLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtBranchLimitFile, -2, -1, -2).addComponent(this.btnBrowseBranchLimitFile).addComponent(this.lblBranchLimitFile)).addGap(0, 13, Short.MAX_VALUE)));
        GroupLayout pnlFilesLayout = new GroupLayout(this.pnlFiles);
        this.pnlFiles.setLayout(pnlFilesLayout);
        pnlFilesLayout.setHorizontalGroup(pnlFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlFilesLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(pnlFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlBranchLimit, -1, -1, Short.MAX_VALUE).addComponent(this.pnlDatabase1, -1, -1, Short.MAX_VALUE)).addContainerGap(27, Short.MAX_VALUE)));
        pnlFilesLayout.setVerticalGroup(pnlFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlFilesLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlDatabase1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlBranchLimit, -2, -1, -2).addContainerGap(73, Short.MAX_VALUE)));
        this.MainJTabPane.addTab("Input Files", this.pnlFiles);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Index Coefficients", 0, 0, null, new Color(0, 0, 204)));
        this.tblCoefficients.setModel(new DefaultTableModel(new Object[][]{{"Price Difference [Cmg]", null}, {"Loading Level [LL]", null}, {"Probability [p]", null}, {"Revenue Losses [RLss]", null}, {"Marginal Income [MI]", null}}, new String[]{"Variable", "Coefficient"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblCoefficients.setSelectionMode(2);
        this.tblCoefficients.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.tblCoefficients);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jScrollPane2, -2, 278, -2).addContainerGap(37, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jScrollPane2, -2, 132, -2).addContainerGap(24, Short.MAX_VALUE)));
        GroupLayout tabRankLayout = new GroupLayout(this.tabRank);
        this.tabRank.setLayout(tabRankLayout);
        tabRankLayout.setHorizontalGroup(tabRankLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tabRankLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(69, 69, 69)));
        tabRankLayout.setVerticalGroup(tabRankLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabRankLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addContainerGap(118, Short.MAX_VALUE)));
        this.MainJTabPane.addTab("Ranking", this.tabRank);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TAOptionFrame.this.btnCancelMouseClicked(evt);
            }
        });
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAOptionFrame.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout MainPaneLayout = new GroupLayout(this.MainPane);
        this.MainPane.setLayout(MainPaneLayout);
        MainPaneLayout.setHorizontalGroup(MainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MainJTabPane, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, MainPaneLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnOK, -2, 73, -2).addGap(15, 15, 15).addComponent(this.btnCancel, -2, 73, -2).addContainerGap()));
        MainPaneLayout.setVerticalGroup(MainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MainPaneLayout.createSequentialGroup().addComponent(this.MainJTabPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(MainPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.btnCancel))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MainPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.MainPane, -2, -1, -2).addGap(0, 8, Short.MAX_VALUE)));
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnCancelMouseClicked(MouseEvent evt) {
        this.dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.updateTAwithGUIParameters();
        this.myTA.setRecalculate(true);
        this.parent.updateHeader();
        this.dispose();
    }

    private void btnBrowseDBActionPerformed(ActionEvent evt) {
        String InputFolder = this.GetDBFile();
        if (InputFolder != null) {
            this.txtDBName.setText(InputFolder);
        }
    }

    private void btnBrowseInputFolderActionPerformed(ActionEvent evt) {
        String strInputFolder = this.GetChooserDirectory();
        if (strInputFolder != null) {
            this.txtInputFolder.setText(strInputFolder);
        }
    }

    private void btnBrowseOutputFolderActionPerformed(ActionEvent evt) {
        String strOutputFolder = this.GetChooserDirectory();
        if (strOutputFolder != null) {
            this.txtOutputFolder.setText(strOutputFolder);
        }
    }

    private void btnUpdateTPDBActionPerformed(ActionEvent evt) {
        this.updateTPDB();
    }

    private void btnCheckSchActionPerformed(ActionEvent evt) {
        this.updateTAwithGUIParameters();
        this.myTA.checkActSchematicCompatibility(true, false, true);
    }

    private void btnBrowseBranchLimitFileActionPerformed(ActionEvent evt) {
        this.showAllBranchLimits();
    }

    private void chkUseDynPriceDiffActionPerformed(ActionEvent evt) {
        if (this.chkUseDynPriceDiff.isSelected()) {
            this.chkUseRelPriceDiffTol.doClick();
        }
    }

    private void chkUseRelPriceDiffTolActionPerformed(ActionEvent evt) {
        if (this.chkUseDynPriceDiff.isSelected() && !this.chkUseRelPriceDiffTol.isSelected()) {
            this.chkUseRelPriceDiffTol.doClick();
        }
    }

    private void cboFileTypeItemStateChanged(ItemEvent evt) {
        if (DE_GeneralEnums.DispatchSoftware.PLEXOS_ST.toString().equals(this.cboFileType.getSelectedItem())) {
            this.txtPLEXOSDBName.setEnabled(true);
        } else {
            this.txtPLEXOSDBName.setEnabled(false);
        }
    }

    private String GetDBFile() throws HeadlessException {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle(this.getTitle());
        if (this.cboDBType.getSelectedItem().equals(DE_GeneralEnums.DatabaseVendor.MSAccess.toString())) {
            FileNameExtensionFilter filterAccess2003 = new FileNameExtensionFilter("MS Access 2003 (.mdb)", "mdb");
            chooser.addChoosableFileFilter(filterAccess2003);
            FileNameExtensionFilter filterAccess2007 = new FileNameExtensionFilter("MS Access 2007* (.accdb)", "accdb");
            chooser.addChoosableFileFilter(filterAccess2007);
            chooser.setFileFilter(filterAccess2003);
        } else if (this.cboDBType.getSelectedItem().equals(DE_GeneralEnums.DatabaseVendor.SQLite.toString())) {
            FileNameExtensionFilter filterSQLite = new FileNameExtensionFilter("SQLite db (.sqlite)", "sqlite");
            chooser.addChoosableFileFilter(filterSQLite);
            chooser.setFileFilter(filterSQLite);
        } else assert (false) : "This is not a supported dabase vendor: " + this.cboDBType.getSelectedItem();
        chooser.setFileSelectionMode(0);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private String GetChooserDirectory() throws HeadlessException {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle(this.getTitle());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void updateTAwithGUIParameters() {
        this.myTA.setbMakeReport(this.chkMakeReport.isSelected());
        this.myTA.setbUseDoubleCircuit(this.chkDoubleCircuit.isSelected());
        this.myTA.setbCalculateMarketBalance(this.chkMarketBalance.isSelected());
        this.myTA.setbUsePriceDiff(this.chkUsePriceDiffTol.isSelected());
        this.myTA.setbUseLineLoad(this.chkUseLineTol.isSelected());
        this.myTA.setbUseRelPriceDiff(this.chkUseRelPriceDiffTol.isSelected());
        this.myTA.setbUseDynPriceDiff(this.chkUseDynPriceDiff.isSelected());
        this.myTA.setdLineTol(Double.parseDouble(this.txtLineLoadTol.getText()));
        this.myTA.setdPriceDiffTol(Double.parseDouble(this.txtPriceDiffTol.getText()));
        this.myTA.setdRelPriceDiffTol(Double.parseDouble(this.txtRelPriceDiffTol.getText()));
        this.myTA.setsDBPath(this.txtDBName.getText());
        this.myTA.setsServer(this.txtDBServer.getText());
        this.myTA.setsUserName(this.txtDBUserName.getText());
        this.myTA.setsPass(new String(this.txtDBPass.getPassword()));
        this.myTA.setdPriceFactor(Double.parseDouble(this.tblCoefficients.getValueAt(0, 1).toString()));
        this.myTA.setdLineLoadFactor(Double.parseDouble(this.tblCoefficients.getValueAt(1, 1).toString()));
        this.myTA.setdProbabilityFactor(Double.parseDouble(this.tblCoefficients.getValueAt(2, 1).toString()));
        this.myTA.setdRevenueLossFactor(Double.parseDouble(this.tblCoefficients.getValueAt(3, 1).toString()));
        this.myTA.setdMarginalIncomeFactor(Double.parseDouble(this.tblCoefficients.getValueAt(4, 1).toString()));
        this.myTA.setsLimitXMLFile(this.txtBranchLimitFile.getText());
        this.myTA.setsLastSourceFileType(this.cboFileType.getSelectedItem().toString());
        this.myTA.setStrInputFolder(this.txtInputFolder.getText());
        this.myTA.setStrOutputFolder(this.txtOutputFolder.getText());
        this.myTA.setStrPLEXOSOutputDBName(this.txtPLEXOSDBName.getText());
    }

    private void updateGUIwithTAParameters() {
        this.chkMakeReport.setSelected(this.myTA.isbMakeReport());
        this.chkDoubleCircuit.setSelected(this.myTA.isbUseDoubleCircuit());
        this.chkMarketBalance.setSelected(this.myTA.isbCalculateMarketBalance());
        this.chkUsePriceDiffTol.setSelected(this.myTA.isbUsePriceDiff());
        this.chkUseLineTol.setSelected(this.myTA.isbUseLineLoad());
        this.chkUseRelPriceDiffTol.setSelected(this.myTA.isbUseRelPriceDiff());
        this.chkUseDynPriceDiff.setSelected(this.myTA.isbUseDynPriceDiff());
        this.txtLineLoadTol.setText(String.valueOf(this.myTA.getdLineTol()));
        this.txtPriceDiffTol.setText(String.valueOf(this.myTA.getdPriceDiffTol()));
        this.txtRelPriceDiffTol.setText(String.valueOf(this.myTA.getdRelPriceDiffTol()));
        this.txtDBName.setText(this.myTA.getsDBPath());
        this.txtDBServer.setText(this.myTA.getsServer());
        this.txtDBUserName.setText(this.myTA.getsUserName());
        this.txtDBPass.setText(this.myTA.getsPass());
        this.tblCoefficients.setValueAt(this.myTA.getdPriceFactor(), 0, 1);
        this.tblCoefficients.setValueAt(this.myTA.getdLineLoadFactor(), 1, 1);
        this.tblCoefficients.setValueAt(this.myTA.getdProbabilityFactor(), 2, 1);
        this.tblCoefficients.setValueAt(this.myTA.getdRevenueLossFactor(), 3, 1);
        this.tblCoefficients.setValueAt(this.myTA.getdMarginalIncomeFactor(), 4, 1);
        this.txtBranchLimitFile.setText(this.myTA.getsLimitXMLFile());
        this.cboFileType.setSelectedItem(this.myTA.getsLastSourceFileType());
        this.txtInputFolder.setText(this.myTA.getStrInputFolder());
        this.txtOutputFolder.setText(this.myTA.getStrOutputFolder());
        this.txtPLEXOSDBName.setText(this.myTA.getStrPLEXOSOutputDBName());
    }

    private void setDateFromTo() {
        String strIniDate = this.parent.getStringInitialDate();
        String strEndDate = this.parent.getStringFinalDate();
        this.lblDateFromInDB.setText(strIniDate);
        this.txtDateFrom.setText(strIniDate);
        this.lblDateToInDB.setText(strEndDate);
        this.txtDateTo.setText(strEndDate);
    }
}

