/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.TACongestion;
import de.core.TACongestionInfo;
import de.core.TADetailsAffectedFrame;
import de.core.TADetailsFrame;
import de.core.TAOptionFrame;
import de.core.YearlyStatTieFrame;
import de.core.ndb_branch;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class TAMainFrame
extends JDialog {
    private DeepEdit myDeepEdit;
    private TAOptionFrame myOptionFrame;
    private TACongestion myTA;
    private TAMainFrame myTAFrame;
    ArrayList<TACongestionInfo> lCongestion;
    private JPanel ExecutePane;
    private JPanel RankingPane;
    private JButton btnExecute;
    private JButton btnExit;
    private JButton btnOptions;
    private JButton btnShowDetails;
    private JComboBox cboBalance;
    private JComboBox cboFlowChart;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JLabel lblDateFrom;
    private JLabel lblDateTo;
    private JLabel lblSoftSource;
    private JTable tblRanking;
    private JTextPane txtDBPath;

    public TAMainFrame(DeepEditFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.myDeepEdit = parent.applet;
        this.initializeTA();
        this.updateHeader();
    }

    private void initializeTA() {
        if (this.myTA == null) {
            this.myTA = new TACongestion(this.myDeepEdit);
        } else {
            this.myTA.initSchematicLists();
        }
    }

    public TACongestion getTransmissionCongestion() {
        this.initializeTA();
        return this.myTA;
    }

    public String getStringInitialDate() {
        try {
            Calendar initialDate = this.myTA.getInitialDate();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            return sdf.format(initialDate.getTime());
        }
        catch (NullPointerException e) {
            return "dd/MM/yyyy";
        }
    }

    public String getStringFinalDate() {
        try {
            Calendar finalDate = this.myTA.getFinalDate();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            return sdf.format(finalDate.getTime());
        }
        catch (NullPointerException e) {
            return "dd/MM/yyyy";
        }
    }

    public final void updateHeader() {
        try {
            this.lblDateFrom.setText(this.getStringInitialDate());
            this.lblDateTo.setText(this.getStringFinalDate());
            this.lblSoftSource.setText(this.myTA.getSoftwareSource());
            this.txtDBPath.setText(this.myTA.getsDBPath());
        }
        catch (NullPointerException e) {
            System.out.println("Invalid database. Change the TA-Database or re-run tools. Exception details: " + e);
        }
    }

    private void updateAll() {
        this.updateHeader();
        this.initializeTA();
        this.setVisible(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TAMainFrame.this.myTA.setRecalculate(true);
                    TAMainFrame.this.myTA.Calculate();
                    Thread.sleep(3L);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TAMainFrame.this.updateGUI();
                            TAMainFrame.this.setVisible(true);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }).start();
    }

    public final void updateGUI() {
        this.lCongestion = this.myTA.getCongestionList();
        if (this.lCongestion == null) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.tblRanking.getModel();
        model.setRowCount(0);
        for (TACongestionInfo oCongestion : this.lCongestion) {
            ndb_branch branch = oCongestion.getBranch();
            Object[] o = new Object[]{branch.getName(), branch.getcon1(), branch.getcon2(), oCongestion.getProbability() * 100.0, oCongestion.getIndex()};
            model.addRow(o);
        }
        this.tblRanking.setModel(model);
    }

    public void updateSchematicFromTPDB(int nBlock, int nHydro) {
        this.myTA.updateSchematicFromTPDB(nBlock, nHydro);
    }

    private void showOptions() {
        this.initializeTA();
        this.myOptionFrame = new TAOptionFrame(this);
        this.myOptionFrame.setLocationRelativeTo(this);
        this.myOptionFrame.setVisible(true);
    }

    private void showDetails(TACongestionInfo myTACI) {
        TADetailsFrame myTADframe = new TADetailsFrame(this, myTACI);
        myTADframe.setLocationRelativeTo(this);
        myTADframe.setVisible(true);
    }

    private void calculateSupplierBalance(TACongestionInfo myTACI) {
        if (!myTACI.hasBilateralMarketBalance()) {
            this.myTA.updateAffectedMarketParticipants(myTACI);
        }
    }

    private void showSupplierBalance(TACongestionInfo myTACI) {
        TADetailsAffectedFrame myTADAframe = new TADetailsAffectedFrame(this, myTACI, TACongestionInfo.SUPPLIER_BALANCE);
        myTADAframe.setLocationRelativeTo(this);
        myTADAframe.setVisible(true);
    }

    private void calculateCustomerBalance(TACongestionInfo myTACI) {
        if (!myTACI.hasCustomerBalance()) {
            this.myTA.updateAffectedCustomers(myTACI);
        }
    }

    private void showCustomerBalance(TACongestionInfo myTACI) {
        TADetailsAffectedFrame myTADAframe = new TADetailsAffectedFrame(this, myTACI, TACongestionInfo.CUSTOMER_BALANCE);
        myTADAframe.setLocationRelativeTo(this);
        myTADAframe.setVisible(true);
    }

    private void showLDC(final String sBranchName) {
        this.myTAFrame = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final double[] Flow = TAMainFrame.this.myTA.getFlowInTPDB(sBranchName);
                    double[] dMaxFlowArray = TAMainFrame.this.myTA.getPmaxFromTPDB(sBranchName);
                    final double dMaxFlow = Utils.getMaximum(dMaxFlowArray);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Flow != null) {
                                JDialog jTie = new JDialog(TAMainFrame.this.myTAFrame, sBranchName, true);
                                double[][] yVal = new double[3][];
                                double[][] xVal = new double[3][];
                                String[] sLabels = new String[]{"Flow", "Max Flow", "Min Flow"};
                                Color[] cSeries = new Color[]{new Color(0, 162, 232), new Color(223, 223, 223), new Color(223, 223, 223)};
                                yVal[0] = new double[Flow.length];
                                xVal[0] = new double[Flow.length];
                                for (int i = 0; i < Flow.length; ++i) {
                                    yVal[0][i] = Flow[i];
                                    xVal[0][i] = Utils.safeDivision((double)i * 100.0, Flow.length);
                                }
                                yVal[1] = new double[2];
                                xVal[1] = new double[2];
                                yVal[1][0] = dMaxFlow;
                                yVal[1][1] = dMaxFlow;
                                xVal[1][0] = 0.0;
                                xVal[1][1] = 100.0;
                                yVal[2] = new double[2];
                                xVal[2] = new double[2];
                                yVal[2][0] = -1.0 * dMaxFlow;
                                yVal[2][1] = -1.0 * dMaxFlow;
                                xVal[2][0] = 0.0;
                                xVal[2][1] = 100.0;
                                JFreeChart myChart = YearlyStatTieFrame.getOverlayChart(sBranchName, yVal, xVal, sLabels, cSeries, "Flow[MW]", "Time[%]", true);
                                ChartPanel chartPanel = new ChartPanel(myChart);
                                jTie.getContentPane().add((Component)chartPanel);
                                jTie.setSize(500, 350);
                                jTie.setLocationRelativeTo(TAMainFrame.this.myTAFrame);
                                jTie.setVisible(true);
                            }
                        }
                    });
                }
                catch (SQLException ex) {
                    JOptionPane.showMessageDialog(TAMainFrame.this.myTAFrame, "Error querying flows from TPDB database: \n" + ex, "SQL Exception", 0);
                }
            }
        }).start();
    }

    private void showChronoFlow(String sBranchName) throws Exception {
        Double[][] dFlow = this.myTA.getFlowFromTPDB(sBranchName);
        double[] dMaxFlowArray = this.myTA.getPmaxFromTPDB(sBranchName);
        Color[] cFlowSeries = new Color[this.myTA.finalHydro];
        Point2D.Double[][] seriesFlow = new Point2D.Double[this.myTA.finalHydro][this.myTA.finalBlock];
        for (int h = 0; h < this.myTA.finalHydro; ++h) {
            for (int b = 0; b < this.myTA.finalBlock; ++b) {
                seriesFlow[h][b] = new Point2D.Double(b, dFlow[b][h]);
            }
        }
        String[] sLabels = new String[]{"Max Flow", "Min Flow"};
        Color[] cMinMaxFlowSeries = new Color[]{new Color(223, 223, 223), new Color(223, 223, 223)};
        Point2D[][] seriesMinMaxFlow = new Point2D.Double[2][dMaxFlowArray.length];
        for (int b = 0; b < dMaxFlowArray.length; ++b) {
            seriesMinMaxFlow[0][b] = new Point2D.Double(b, dMaxFlowArray[b]);
            seriesMinMaxFlow[1][b] = new Point2D.Double(b, -1.0 * dMaxFlowArray[b]);
        }
        JDialog jTie = new JDialog(this, sBranchName, true);
        JFreeChart myChart = YearlyStatTieFrame.getOverlayChart(sBranchName, seriesMinMaxFlow, sLabels, cMinMaxFlowSeries, "Flow[MW]", "Time [blocks]", false);
        int s = 0;
        for (Point2D[] point2DArray : seriesFlow) {
            YearlyStatTieFrame.addSeriesToOverlayChart(myChart, point2DArray, 0, "Flow{" + s + "}", new Color(0, 162, 232));
            ++s;
        }
        myChart.getLegend().setVisible(false);
        ChartPanel chartPanel = new ChartPanel(myChart);
        jTie.getContentPane().add((Component)chartPanel);
        jTie.setSize(500, 350);
        jTie.setLocationRelativeTo(this.myTAFrame);
        jTie.setVisible(true);
    }

    private TACongestionInfo getSelectedCongestion() {
        int nRow = this.tblRanking.getSelectedRow();
        String strNameBranch = (String)this.tblRanking.getValueAt(nRow, 0);
        for (TACongestionInfo myCongestion : this.lCongestion) {
            if (!myCongestion.getBranch().getName().equals(strNameBranch)) continue;
            return myCongestion;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.lCongestion != null && this.lCongestion.size() > 0) {
                System.out.println("Solution is temporarly available. Use AnalysisTool/Yearly Tools/Technical/Transmission Analysis to return to main TA window");
            }
            if (this.myTA != null) {
                this.myTA.safeDefaults();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.dispose();
        }
    }

    private void initComponents() {
        this.ExecutePane = new JPanel();
        this.btnExecute = new JButton();
        this.btnOptions = new JButton();
        this.btnShowDetails = new JButton();
        this.btnExit = new JButton();
        this.cboFlowChart = new JComboBox();
        this.cboBalance = new JComboBox();
        this.RankingPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblRanking = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblSoftSource = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblDateFrom = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblDateTo = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.txtDBPath = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transmission Congestion Analysis");
        this.setName("TAMainFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TAMainFrame.this.WindowClose(evt);
            }
        });
        this.btnExecute.setText("Execute");
        this.btnExecute.setPreferredSize(new Dimension(95, 23));
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAMainFrame.this.btnExecuteActionPerformed(evt);
            }
        });
        this.btnOptions.setText("Options");
        this.btnOptions.setPreferredSize(new Dimension(95, 23));
        this.btnOptions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TAMainFrame.this.btnOptionsMouseClicked(evt);
            }
        });
        this.btnShowDetails.setText("Show Details");
        this.btnShowDetails.setPreferredSize(new Dimension(95, 23));
        this.btnShowDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAMainFrame.this.btnShowDetailsActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.setPreferredSize(new Dimension(95, 23));
        this.btnExit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TAMainFrame.this.btnExitMouseClicked(evt);
            }
        });
        this.cboFlowChart.setModel(new DefaultComboBoxModel<String>(new String[]{"Flow LDC", "Flow Chrono"}));
        this.cboFlowChart.setToolTipText("Display chart with Flows as Load Duration Curve or chronologically (samples in series)");
        this.cboFlowChart.setMaximumSize(new Dimension(81, 22));
        this.cboFlowChart.setMinimumSize(new Dimension(81, 22));
        this.cboFlowChart.setPreferredSize(new Dimension(95, 21));
        this.cboFlowChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAMainFrame.this.cboFlowChartActionPerformed(evt);
            }
        });
        this.cboBalance.setModel(new DefaultComboBoxModel<String>(new String[]{"Balance Sup", "Balance Customer"}));
        this.cboBalance.setToolTipText("Display chart with Flows as Load Duration Curve or chronologically (samples in series)");
        this.cboBalance.setMaximumSize(new Dimension(81, 22));
        this.cboBalance.setMinimumSize(new Dimension(81, 22));
        this.cboBalance.setPreferredSize(new Dimension(95, 21));
        this.cboBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TAMainFrame.this.cboBalanceActionPerformed(evt);
            }
        });
        GroupLayout ExecutePaneLayout = new GroupLayout(this.ExecutePane);
        this.ExecutePane.setLayout(ExecutePaneLayout);
        ExecutePaneLayout.setHorizontalGroup(ExecutePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ExecutePaneLayout.createSequentialGroup().addContainerGap().addComponent(this.btnExecute, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboFlowChart, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnShowDetails, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboBalance, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExit, -2, -1, -2).addContainerGap(48, Short.MAX_VALUE)));
        ExecutePaneLayout.setVerticalGroup(ExecutePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ExecutePaneLayout.createSequentialGroup().addGroup(ExecutePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExit, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, ExecutePaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnShowDetails, -2, -1, -2).addComponent(this.cboBalance, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, ExecutePaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOptions, -2, -1, -2).addComponent(this.cboFlowChart, -2, -1, -2)).addComponent(this.btnExecute, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(0, 11, Short.MAX_VALUE)));
        this.tblRanking.setAutoCreateRowSorter(true);
        this.tblRanking.setModel(new DefaultTableModel(new Object[0][], new String[]{"Line", "BusbarFrom", "BusbarTo", "Probability", "Ranking"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblRanking.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblRanking);
        if (this.tblRanking.getColumnModel().getColumnCount() > 0) {
            this.tblRanking.getColumnModel().getColumn(0).setPreferredWidth(125);
        }
        GroupLayout RankingPaneLayout = new GroupLayout(this.RankingPane);
        this.RankingPane.setLayout(RankingPaneLayout);
        RankingPaneLayout.setHorizontalGroup(RankingPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RankingPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
        RankingPaneLayout.setVerticalGroup(RankingPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, RankingPaneLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 326, Short.MAX_VALUE)));
        this.jPanel1.setPreferredSize(new Dimension(649, 20));
        this.jLabel2.setForeground(new Color(102, 102, 102));
        this.jLabel2.setText("Active Case:");
        this.lblSoftSource.setBackground(new Color(204, 204, 204));
        this.lblSoftSource.setText("No Database...");
        this.lblSoftSource.setOpaque(true);
        this.jLabel4.setForeground(new Color(102, 102, 102));
        this.jLabel4.setText("From:");
        this.lblDateFrom.setBackground(new Color(204, 204, 204));
        this.lblDateFrom.setForeground(new Color(0, 0, 255));
        this.lblDateFrom.setText("dd/mm/yyyy");
        this.lblDateFrom.setOpaque(true);
        this.jLabel6.setText("To:");
        this.lblDateTo.setBackground(new Color(204, 204, 204));
        this.lblDateTo.setForeground(new Color(0, 0, 255));
        this.lblDateTo.setText("dd/mm/yyyy");
        this.lblDateTo.setOpaque(true);
        this.jLabel8.setForeground(new Color(102, 102, 102));
        this.jLabel8.setText("Database:");
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setToolTipText("");
        this.jScrollPane3.setHorizontalScrollBar(null);
        this.jScrollPane3.setMaximumSize(new Dimension(50565660, 20));
        this.jScrollPane3.setName("");
        this.jScrollPane3.setPreferredSize(new Dimension(146, 20));
        this.txtDBPath.setEditable(false);
        this.txtDBPath.setBackground(new Color(204, 204, 204));
        this.txtDBPath.setText("./results/TPDB(new).mdb");
        this.txtDBPath.setToolTipText("");
        this.txtDBPath.setCursor(new Cursor(0));
        this.txtDBPath.setMaximumSize(new Dimension(52234520, 20));
        this.txtDBPath.setName("");
        this.jScrollPane3.setViewportView(this.txtDBPath);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSoftSource).addGap(46, 46, 46).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblDateFrom).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblDateTo).addGap(36, 36, 36).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 155, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblSoftSource, -2, 22, -2).addComponent(this.lblDateTo, -2, 22, -2).addComponent(this.lblDateFrom, -2, 22, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.CENTER).addComponent(this.jLabel4, GroupLayout.Alignment.CENTER).addComponent(this.jLabel6, GroupLayout.Alignment.CENTER).addComponent(this.jLabel8, GroupLayout.Alignment.CENTER).addComponent(this.jScrollPane3, GroupLayout.Alignment.CENTER, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RankingPane, -1, -1, Short.MAX_VALUE).addComponent(this.ExecutePane, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 658, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RankingPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ExecutePane, -2, -1, -2)));
        this.pack();
    }

    private void btnExitMouseClicked(MouseEvent evt) {
        this.close();
    }

    private void btnOptionsMouseClicked(MouseEvent evt) {
        this.showOptions();
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        this.updateAll();
    }

    private void btnShowDetailsActionPerformed(ActionEvent evt) {
        if (this.tblRanking.getSelectedRowCount() == 1) {
            this.showDetails(this.getSelectedCongestion());
        } else {
            JOptionPane.showMessageDialog(this, "Please select (only) 1 congestion line in main table to show details", "Invalid line selection", 1);
        }
    }

    private void WindowClose(WindowEvent evt) {
        this.close();
    }

    private void cboFlowChartActionPerformed(ActionEvent evt) {
        block7: {
            if (this.tblRanking.getSelectedRowCount() == 1) {
                try {
                    if (!(evt.getSource() instanceof JComboBox)) break block7;
                    JComboBox evItem = (JComboBox)evt.getSource();
                    if (evItem.getSelectedIndex() == 0) {
                        this.showLDC(this.getSelectedCongestion().getBranch().getName());
                    } else if (evItem.getSelectedIndex() == 1) {
                        this.showChronoFlow(this.getSelectedCongestion().getBranch().getName());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Details: " + e, "Exception showing chrono chart", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select (only) 1 congestion line in main table to show details", "Invalid line selection", 1);
            }
        }
    }

    private void cboBalanceActionPerformed(ActionEvent evt) {
        block7: {
            if (this.tblRanking.getSelectedRowCount() == 1) {
                try {
                    if (!(evt.getSource() instanceof JComboBox)) break block7;
                    JComboBox evItem = (JComboBox)evt.getSource();
                    if (evItem.getSelectedIndex() == 0) {
                        SwingWorker<Boolean, Void> workerBalance = new SwingWorker<Boolean, Void>(){

                            @Override
                            public Boolean doInBackground() {
                                TAMainFrame.this.calculateSupplierBalance(TAMainFrame.this.getSelectedCongestion());
                                return true;
                            }

                            @Override
                            public void done() {
                                TAMainFrame.this.showSupplierBalance(TAMainFrame.this.getSelectedCongestion());
                            }
                        };
                        workerBalance.execute();
                    } else if (evItem.getSelectedIndex() == 1) {
                        SwingWorker<Boolean, Void> workerBalance = new SwingWorker<Boolean, Void>(){

                            @Override
                            public Boolean doInBackground() {
                                TAMainFrame.this.calculateCustomerBalance(TAMainFrame.this.getSelectedCongestion());
                                return true;
                            }

                            @Override
                            public void done() {
                                TAMainFrame.this.showCustomerBalance(TAMainFrame.this.getSelectedCongestion());
                            }
                        };
                        workerBalance.execute();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Details: " + e, "Exception showing Finantial Balance", 0);
                    e.printStackTrace(System.err);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select (only) 1 congestion line in main table to show details", "Invalid line selection", 1);
            }
        }
    }
}

